/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;

public final class AIColony
extends AIObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    public static final String TAG = "aiColony";
    private static final String LIST_ELEMENT = "ListElement";
    private static final int FOREST_MINIMUM = 1;
    private static final int EXPORT_MINIMUM = 10;
    private static final Comparator<Unit> pioneerComparator = Comparator.comparingInt(Unit::getPioneerScore).reversed();
    private static final Comparator<Unit> scoutComparator = Comparator.comparingInt(Unit::getScoutScore).reversed();
    private static final Set<GoodsType> fullExport = new HashSet<GoodsType>();
    private static final Set<GoodsType> partExport = new HashSet<GoodsType>();
    private Colony colony;
    private ColonyPlan colonyPlan;
    private List<AIGoods> exportGoods;
    private List<Wish> wishes;
    private List<TileImprovementPlan> tileImprovementPlans;
    private Turn rearrangeTurn = new Turn(0);
    private static final String AI_GOODS_LIST_TAG = "aiGoodsListElement";
    private static final String GOODS_WISH_LIST_TAG = "goodsWishListElement";
    private static final String TILE_IMPROVEMENT_PLAN_LIST_TAG = "tileImprovementPlanListElement";
    private static final String WORKER_WISH_LIST_TAG = "workerWishListElement";
    private static final String OLD_TILE_IMPROVEMENT_PLAN_LIST_TAG = "tileimprovementplanListElement";

    public AIColony(AIMain aiMain, String id) {
        super(aiMain, id);
        this.baseInitialize();
        this.initialized = false;
    }

    public AIColony(AIMain aiMain, Colony colony) {
        this(aiMain, colony.getId());
        this.colony = colony;
        colony.addPropertyChangeListener("rearrangeColony", this);
        this.setInitialized();
    }

    public AIColony(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.setInitialized();
    }

    private void baseInitialize() {
        if (this.exportGoods != null) {
            return;
        }
        this.colonyPlan = null;
        this.exportGoods = new ArrayList<AIGoods>();
        this.wishes = new ArrayList<Wish>();
        this.tileImprovementPlans = new ArrayList<TileImprovementPlan>();
    }

    @Override
    public void setInitialized() {
        this.initialized = this.getColony() != null;
    }

    public final Colony getColony() {
        return this.colony;
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.colony.getOwner());
    }

    public boolean isBadlyDefended() {
        return this.colony.isBadlyDefended();
    }

    public void update(LogBuilder lb) {
        lb.add("\n  ", this.colony.getName());
        this.resetExports();
        this.updateExportGoods(lb);
        this.updateTileImprovementPlans(lb);
        this.updateWishes(lb);
    }

    public Set<AIUnit> rearrangeColony(LogBuilder lb) {
        AIMain aiMain = this.getAIMain();
        HashSet<AIUnit> result = new HashSet<AIUnit>();
        if (this.colony.getUnitCount() <= 0 && !this.avertAutoDestruction()) {
            return result;
        }
        int turn = this.getGame().getTurn().getNumber();
        if (this.rearrangeTurn.getNumber() > turn) {
            if (this.colony.getCurrentlyBuilding() == null && this.colonyPlan != null && this.colonyPlan.getBestBuildableType() != null) {
                logger.warning(this.colony.getName() + " could be building but is asleep until turn: " + this.rearrangeTurn.getNumber() + "( > " + turn + ")");
            } else {
                return result;
            }
        }
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        Specification spec = this.getSpecification();
        lb.add("\n  ", this.colony.getName());
        int nextRearrange = 15;
        this.exploreLCRs();
        this.stealTiles(lb);
        for (Tile t : CollectionUtils.transform(tile.getSurroundingTiles(1, 1), t2 -> !player.owns((Ownable)t2) && player.canClaimForSettlement((Tile)t2))) {
            AIMessage.askClaimLand(t, this, 0);
            if (!player.owns(t)) continue;
            lb.add(", claimed tile ", t);
        }
        if (this.colonyPlan == null) {
            this.colonyPlan = new ColonyPlan(aiMain, this.colony);
        }
        this.colonyPlan.update();
        BuildableType oldBuild = this.colony.getCurrentlyBuilding();
        BuildableType build = this.colonyPlan.getBestBuildableType();
        if (build != oldBuild) {
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>(1);
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            build = this.colony.getCurrentlyBuilding();
        }
        this.colonyPlan.refine(build, lb);
        List<Unit> workers = this.colony.getUnitList();
        List<UnitWas> was = CollectionUtils.transform(workers, CollectionUtils.alwaysTrue(), u -> new UnitWas((Unit)u));
        Predicate<Unit> workerPred = u -> {
            AIUnit validAIU;
            return u.isPerson() && !u.hasAbility("model.ability.refUnit") && (validAIU = this.getAIUnit((Unit)u)) != null && validAIU.isAvailableForWork(this.colony);
        };
        for (Unit u2 : CollectionUtils.transform(tile.getUnits(), workerPred)) {
            workers.add(u2);
            was.add(new UnitWas(u2));
        }
        AIPlayer aiPlayer = this.getAIOwner();
        LogBuilder aw = new LogBuilder(256);
        boolean preferScouts = aiPlayer.scoutsNeeded() > 0;
        Colony scratch = this.colonyPlan.assignWorkers(new ArrayList<Unit>(workers), preferScouts, aw);
        if (scratch == null) {
            lb.add(", failed to assign workers.");
            this.rearrangeTurn = new Turn(turn + 1);
            return result;
        }
        lb.add(", assigned ", workers.size(), " workers");
        AIMessage.askRearrangeColony(this, workers, scratch);
        if (this.colony.getUnitCount() <= 0) {
            lb.add(", autodestruct detected");
            StringBuilder sb = new StringBuilder(64);
            sb.append("Autodestruct at ").append(this.colony.getName()).append(" in ").append(turn).append(':');
            for (UnitWas uw : was) {
                sb.append('\n').append(uw);
            }
            logger.warning(sb.toString());
            if (!this.avertAutoDestruction()) {
                return result;
            }
        }
        if (build != null && !this.colony.canBuild(build)) {
            BuildableType newBuild = this.colonyPlan.getBestBuildableType();
            lb.add(new Object[]{", reneged building ", build.getSuffix(), " (", this.colony.getNoBuildReason(build, null), ")"});
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            if (newBuild != null) {
                queue.add(newBuild);
            }
            AIMessage.askSetBuildQueue(this, queue);
            nextRearrange = 1;
        }
        if (this.colony.getNetProductionOf(spec.getPrimaryFoodType()) < 0) {
            GoodsType food = spec.getPrimaryFoodType();
            int net = this.colony.getNetProductionOf(food);
            int when = this.colony.getGoodsCount(food) / -net;
            nextRearrange = Math.max(0, Math.min(nextRearrange, when - 1));
        }
        int warehouse = this.colony.getWarehouseCapacity();
        for (GoodsType g : CollectionUtils.transform(spec.getStorableGoodsTypeList(), gt -> !gt.isFoodType())) {
            int have = this.colony.getGoodsCount(g);
            int net = this.colony.getAdjustedNetProductionOf(g);
            if (net >= 0 && (have >= warehouse || g.limitIgnored())) continue;
            int when = net < 0 ? have / -net - 1 : (net > 0 ? (warehouse - have) / net - 1 : Integer.MAX_VALUE);
            nextRearrange = Math.max(1, Math.min(nextRearrange, when));
        }
        for (Unit u3 : this.colony.getUnitList()) {
            AIUnit aiu2 = this.getAIUnit(u3);
            if (aiu2.tryWorkInsideColonyMission(this, lb)) continue;
            result.add(aiu2);
        }
        int tipSize = this.tileImprovementPlans.size();
        if (tipSize > 0) {
            Unit u4;
            AIUnit aiu;
            List<Unit> pioneers = CollectionUtils.transform(tile.getUnits(), u -> u.getPioneerScore() >= 0, Function.identity(), pioneerComparator);
            Iterator<Unit> aiu2 = pioneers.iterator();
            while (aiu2.hasNext() && (!(aiu = this.getAIUnit(u4 = aiu2.next())).tryPioneeringMission(lb) || --tipSize > 0)) {
            }
        }
        for (Unit u5 : tile.getUnitList()) {
            AIUnit aiu = this.getAIUnit(u5);
            if (aiu.trySomeUsefulMission(this.colony, lb)) continue;
            result.add(aiu);
        }
        build = this.colony.getCurrentlyBuilding();
        String buildStr = build != null ? build.toString() : ((build = this.colonyPlan.getBestBuildableType()) != null ? "unexpected-null(" + build + ")" : "expected-null");
        lb.add(", building ", buildStr, ", population ", this.colony.getUnitCount(), ", rearrange ", nextRearrange, ".\n");
        lb.add(aw.toString());
        lb.shrink("\n");
        for (UnitWas uw : was) {
            lb.add("\n  ", uw);
        }
        this.rearrangeTurn = new Turn(turn + nextRearrange);
        return result;
    }

    private void resetExports() {
        Specification spec = this.getSpecification();
        Player player = this.colony.getOwner();
        fullExport.clear();
        partExport.clear();
        for (GoodsType goodsType : spec.getStorableGoodsTypeList()) {
            if (goodsType.isFoodType() || goodsType.isRawMaterialForUnstorableBuildingMaterial() || goodsType.isBuildingMaterial() || goodsType.getMilitary() || goodsType.isTradeGoods()) continue;
            if (goodsType.isRawMaterial()) {
                partExport.add(goodsType);
                continue;
            }
            fullExport.add(goodsType);
        }
        UnitType dUT = spec.getDefaultUnitType(player);
        for (AbstractGoods ag : CollectionUtils.transform(CollectionUtils.flatten(spec.getRoles(), r -> r.isAvailableTo(player, dUT), BuildableType::getRequiredGoods), g -> fullExport.contains(g.getType()))) {
            fullExport.remove(ag.getType());
            partExport.add(ag.getType());
        }
        if (this.colony.getOwner().getMarket() == null) {
            for (GoodsType g3 : spec.getGoodsTypeList()) {
                this.colony.getExportData(g3).setExported(false);
            }
        } else {
            int n = 4 * this.colony.getWarehouseCapacity() / 5;
            for (GoodsType g4 : spec.getGoodsTypeList()) {
                if (fullExport.contains(g4)) {
                    this.colony.getExportData(g4).setExportLevel(0);
                    this.colony.getExportData(g4).setExported(true);
                    continue;
                }
                if (partExport.contains(g4)) {
                    this.colony.getExportData(g4).setExportLevel(n);
                    this.colony.getExportData(g4).setExported(true);
                    continue;
                }
                this.colony.getExportData(g4).setExported(false);
            }
        }
    }

    private void exploreLCRs() {
        Tile tile = this.colony.getTile();
        Predicate<Unit> explorerPred = u -> u.isPerson() && (u.getType().getSkill() <= 0 || u.hasAbility("model.ability.expertScout"));
        List<Unit> scouts = CollectionUtils.transform(tile.getUnits(), explorerPred, Function.identity(), scoutComparator);
        for (Tile t : CollectionUtils.transform(tile.getSurroundingTiles(1, 1), Tile::hasLostCityRumour)) {
            Unit u2;
            Direction direction = tile.getDirection(t);
            do {
                if (!scouts.isEmpty()) continue;
                return;
            } while (!(u2 = scouts.remove(0)).getMoveType(t).isProgress() || !this.getAIUnit(u2).move(direction) || t.hasLostCityRumour());
            u2.setDestination(tile);
        }
    }

    private void stealTiles(LogBuilder lb) {
        Specification spec = this.getSpecification();
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        boolean hasDefender = CollectionUtils.any(tile.getUnits(), u -> u.isDefensiveUnit() && this.getAIUnit((Unit)u).hasDefendSettlementMission());
        if (!hasDefender) {
            return;
        }
        List<GoodsType> needed = CollectionUtils.transform(spec.getRawBuildingGoodsTypeList(), gt -> this.colony.getTotalProductionOf((GoodsType)gt) <= 0);
        UnitType unitType = spec.getDefaultUnitType(player);
        Tile steal = null;
        double score = 1.0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            Player owner = t.getOwner();
            if (owner == null || owner == player || owner.isEuropean() || !player.canClaimForSettlement(t)) continue;
            if (owner.atWarWith(player)) {
                if (!AIMessage.askClaimLand(t, this, -1) || !player.owns(t)) continue;
                lb.add(", stole tile ", t, " from hostile ", owner.getName());
                continue;
            }
            double s = CollectionUtils.sumDouble(needed, gt -> t.getPotentialProduction((GoodsType)gt, unitType)) + CollectionUtils.sumDouble(spec.getFoodGoodsTypeList(), ft -> 0.1 * (double)t.getPotentialProduction((GoodsType)ft, unitType));
            if (!(s > score)) continue;
            score = s;
            steal = t;
        }
        if (steal != null) {
            Player owner = steal.getOwner();
            if (AIMessage.askClaimLand(steal, this, -1) && player.owns(steal)) {
                lb.add(", stole tile ", steal, " (score = ", score, ") from ", owner.getName());
            }
        }
    }

    private boolean avertAutoDestruction() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("Colony ", this.colony.getName(), " rearrangement leaves no units, ", this.colony.getTile().getUnitCount(), " available:");
        for (Unit u : this.colony.getTile().getUnitList()) {
            lb.add(" ", u);
        }
        List<GoodsType> libertyGoods = this.getSpecification().getLibertyGoodsTypeList();
        block1: for (Unit u : CollectionUtils.transform(this.colony.getTile().getUnits(), Unit::isPerson)) {
            for (WorkLocation wl : CollectionUtils.transform(this.colony.getAvailableWorkLocations(), w -> w.canAdd(u))) {
                for (GoodsType type : libertyGoods) {
                    if (wl.getPotentialProduction(type, u.getType()) <= 0 || !AIMessage.askWork(this.getAIUnit(u), wl) || u.getLocation() != wl) continue;
                    AIMessage.askChangeWorkType(this.getAIUnit(u), type);
                    lb.add(", averts destruction with ", u);
                    break block1;
                }
            }
        }
        lb.log(logger, Level.WARNING);
        return this.colony.getUnitCount() > 0;
    }

    public void stopUsing(WorkLocation wl) {
        for (Unit u : wl.getUnitList()) {
            AIMessage.askPutOutsideColony(this.getAIUnit(u));
        }
        if (this.colony.getUnitCount() <= 0) {
            this.avertAutoDestruction();
        }
        this.rearrangeTurn = new Turn(this.getGame().getTurn().getNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AIGoods> getExportGoods() {
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            return new ArrayList<AIGoods>(this.exportGoods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExportGoods() {
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            this.exportGoods.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExportGoods(AIGoods aiGoods) {
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            this.exportGoods.add(aiGoods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExportGoods(List<AIGoods> aiGoods) {
        this.clearExportGoods();
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            this.exportGoods.addAll(aiGoods);
        }
        this.sortExportGoods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortExportGoods() {
        if (this.exportGoods == null) {
            return;
        }
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            this.exportGoods.sort(ValuedAIObject.descendingValueComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExportGoods(AIGoods ag) {
        List<AIGoods> list = this.exportGoods;
        synchronized (list) {
            while (this.exportGoods.remove(ag)) {
            }
        }
    }

    private void dropExportGoods(AIGoods ag) {
        AIUnit transport = ag.getTransport();
        if (transport != null) {
            transport.removeTransportable(ag);
        }
        this.removeExportGoods(ag);
        ag.dispose();
    }

    private void goodsLog(AIGoods ag, String action, LogBuilder lb) {
        Goods goods = ag == null ? null : ag.getGoods();
        int amount = goods == null ? -1 : goods.getAmount();
        String type = goods == null ? "(null)" : ag.getGoods().getType().getSuffix();
        lb.add(", ", action, " ", ag == null ? "(null)" : ag.getId(), " ", amount >= 100 ? "full " : Integer.toString(amount) + " ", type);
    }

    private void updateExportGoods(LogBuilder lb) {
        if (this.colony.hasAbility("model.ability.export")) {
            for (AIGoods aig : this.getExportGoods()) {
                this.goodsLog(aig, "customizes", lb);
                this.dropExportGoods(aig);
            }
        } else {
            for (AIGoods aig : this.getExportGoods()) {
                if (aig == null) continue;
                if (!aig.checkIntegrity(false).safe()) {
                    this.goodsLog(aig, "reaps", lb);
                    this.dropExportGoods(aig);
                    continue;
                }
                if (aig.getGoods().getLocation() != this.colony) {
                    this.goodsLog(aig, "sends", lb);
                    this.removeExportGoods(aig);
                    continue;
                }
                if (this.colony.getAdjustedNetProductionOf(aig.getGoods().getType()) >= 0) continue;
                this.goodsLog(aig, "needs", lb);
                this.dropExportGoods(aig);
            }
            Europe europe = this.colony.getOwner().getEurope();
            int capacity = this.colony.getWarehouseCapacity();
            ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
            block2: for (GoodsType gt : this.getSpecification().getGoodsTypeList()) {
                Europe destination;
                if (this.colony.getAdjustedNetProductionOf(gt) < 0) continue;
                int count = this.colony.getGoodsCount(gt);
                int exportAmount = fullExport.contains(gt) || partExport.contains(gt) ? count : -1;
                if (exportAmount <= 0) continue;
                int priority = exportAmount >= capacity ? 110 : (exportAmount >= 100 ? 100 : 0);
                for (AIGoods aig : this.getExportGoods()) {
                    Goods goods = aig.getGoods();
                    if (goods.getType() != gt) continue;
                    int amount = goods.getAmount();
                    if (amount <= exportAmount) {
                        goods.setAmount(exportAmount);
                        this.goodsLog(aig, "updates", lb);
                        newAIGoods.add(aig);
                        continue block2;
                    }
                    if (exportAmount >= 10) {
                        goods.setAmount(exportAmount);
                        this.goodsLog(aig, "clamps", lb);
                        newAIGoods.add(aig);
                        continue block2;
                    }
                    this.goodsLog(aig, "unexports", lb);
                    this.dropExportGoods(aig);
                    continue block2;
                }
                Europe europe2 = destination = this.colony.getOwner().canTrade(gt) ? europe : null;
                if (exportAmount < 10) continue;
                AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, gt, exportAmount, destination);
                newGoods.setTransportPriority(priority);
                newAIGoods.add(newGoods);
                this.goodsLog(newGoods, "makes", lb);
            }
            this.setExportGoods(newAIGoods);
        }
    }

    private void clearWishes() {
        this.wishes.clear();
    }

    public void addWish(Wish wish) {
        this.wishes.add(wish);
    }

    public boolean completeWish(Wish wish, String reason, LogBuilder lb) {
        if (!this.wishes.remove(wish)) {
            lb.add(", ", reason, " not wished for at ", this.colony.getName());
            return false;
        }
        this.getAIOwner().completeWish(wish);
        lb.add(", ", reason, " fulfills at ", this.colony.getName());
        wish.dispose();
        this.requestRearrange();
        return true;
    }

    public boolean completeWish(Goods goods, LogBuilder lb) {
        boolean ret = false;
        for (Wish wish : CollectionUtils.transform(this.wishes, w -> w.satisfiedBy(goods))) {
            ret |= this.completeWish(wish, goods.toString(), lb);
        }
        return ret;
    }

    public boolean completeWish(Unit unit, LogBuilder lb) {
        boolean ret = false;
        for (Wish wish : CollectionUtils.transform(this.wishes, w -> w.satisfiedBy(unit))) {
            ret |= this.completeWish(wish, unit.toShortString(), lb);
        }
        return ret;
    }

    public boolean completeWish(TransportableAIObject t, LogBuilder lb) {
        AIUnit aiUnit;
        if (t instanceof AIGoods) {
            return this.completeWish((Goods)t.getTransportLocatable(), lb);
        }
        if (t instanceof AIUnit && (aiUnit = (AIUnit)t).isCompleteWishRealizationMission(this.colony)) {
            lb.add(", at wish-target");
            this.completeWish(aiUnit.getUnit(), lb);
            aiUnit.removeMission();
            return true;
        }
        return false;
    }

    public List<Wish> getWishes() {
        return new ArrayList<Wish>(this.wishes);
    }

    public List<GoodsWish> getGoodsWishes() {
        return CollectionUtils.transform(this.wishes, w -> w instanceof GoodsWish, w -> (GoodsWish)w);
    }

    public List<WorkerWish> getWorkerWishes() {
        return CollectionUtils.transform(this.wishes, w -> w instanceof WorkerWish, w -> (WorkerWish)w);
    }

    private void requireGoodsWish(GoodsType type, int amount, int value, LogBuilder lb) {
        GoodsWish gw = (GoodsWish)CollectionUtils.find(this.wishes, w -> w instanceof GoodsWish && ((GoodsWish)w).getGoodsType() == type);
        if (gw != null) {
            gw.update(type, amount, gw.getValue() + 1);
            lb.add(", update ", gw);
        } else {
            gw = new GoodsWish(this.getAIMain(), this.colony, value, amount, type);
            this.wishes.add(gw);
            lb.add(", add ", gw);
        }
    }

    private void requireWorkerWish(UnitType type, boolean expertNeeded, int value, LogBuilder lb) {
        WorkerWish ww = (WorkerWish)CollectionUtils.find(this.wishes, w -> w instanceof WorkerWish && ((WorkerWish)w).getUnitType() == type);
        if (ww != null) {
            ww.update(type, expertNeeded, ww.getValue() + 1);
            lb.add(", update ", ww);
        } else {
            ww = new WorkerWish(this.getAIMain(), this.colony, value, type, expertNeeded);
            this.wishes.add(ww);
            lb.add(", add ", ww);
        }
    }

    private void updateWishes(LogBuilder lb) {
        this.updateWorkerWishes(lb);
        this.updateGoodsWishes(lb);
        this.wishes.sort(ValuedAIObject.descendingValueComparator);
    }

    private void updateWorkerWishes(LogBuilder lb) {
        UnitType bestDefender;
        GoodsType goods;
        Specification spec = this.getSpecification();
        int baseValue = 25;
        int priorityMax = 50;
        int priorityDecay = 5;
        int multipleBonus = 5;
        int multipleMax = 5;
        Comparator<GoodsType> comp = CollectionUtils.cachingIntComparator(gt -> this.colony.getAdjustedNetProductionOf((GoodsType)gt));
        List<GoodsType> producing = CollectionUtils.sort(CollectionUtils.transform(CollectionUtils.flatten(this.colony.getAvailableWorkLocations(), UnitLocation::getUnits), CollectionUtils.isNotNull(Unit::getWorkType), u -> u.getWorkType().getStoredAs(), Collectors.toSet()), comp);
        TypeCountMap<UnitType> experts = new TypeCountMap<UnitType>();
        for (Unit unit : this.colony.getUnitList()) {
            goods = unit.getWorkType();
            UnitType expert = goods == null || goods == unit.getType().getExpertProduction() ? null : spec.getExpertForProducing(goods);
            if (expert == null) continue;
            experts.incrementCount(expert, 1);
        }
        for (UnitType expert : experts.keySet()) {
            goods = expert.getExpertProduction();
            int value = 25 + Math.max(0, 50 - 5 * producing.indexOf(goods)) + Math.min(5, experts.getCount(expert) - 1) * 5;
            this.requireWorkerWish(expert, true, value, lb);
        }
        if (this.colonyPlan != null && experts.isEmpty() && this.colony.governmentChange(this.colony.getUnitCount() + 1) >= 0) {
            boolean needFood = this.colony.getFoodProduction() <= this.colony.getFoodConsumption() + this.colony.getOwner().getMaximumFoodConsumption();
            Player owner = this.colony.getOwner();
            UnitType expert = spec.getDefaultUnitType(owner);
            for (WorkLocationPlan plan : needFood ? this.colonyPlan.getFoodPlans() : this.colonyPlan.getWorkPlans()) {
                WorkLocation location = plan.getWorkLocation();
                if (!location.canBeWorked()) continue;
                expert = spec.getExpertForProducing(plan.getGoodsType());
                break;
            }
            this.requireWorkerWish(expert, false, 50, lb);
        }
        if (this.isBadlyDefended() && (bestDefender = this.colony.getBestDefenderType()) != null) {
            this.requireWorkerWish(bestDefender, true, 100, lb);
        }
    }

    private void updateGoodsWishes(LogBuilder lb) {
        Specification spec = this.getSpecification();
        int goodsWishValue = 50;
        TypeCountMap<GoodsType> required = new TypeCountMap<GoodsType>();
        BuildableType build = this.colony.getCurrentlyBuilding();
        if (build != null) {
            for (AbstractGoods ag : build.getRequiredGoodsList()) {
                if (this.colony.getAdjustedNetProductionOf(ag.getType()) > 0) continue;
                required.incrementCount(ag.getType(), ag.getAmount());
            }
        }
        for (TileImprovementPlan plan : this.tileImprovementPlans) {
            Role role = plan.getType().getRequiredRole();
            if (role == null) continue;
            for (AbstractGoods ag : role.getRequiredGoodsList()) {
                required.incrementCount(ag.getType(), ag.getAmount());
            }
        }
        CollectionUtils.forEach(CollectionUtils.map(CollectionUtils.flatten(this.colony.getCurrentWorkLocations(), wl -> !wl.getProductionInfo().atMaximumProduction(), WorkLocation::getInputs), AbstractGoods::getType), gt -> required.incrementCount((GoodsType)gt, 100));
        for (GoodsType gt2 : CollectionUtils.transform(spec.getGoodsTypeList(), g -> g.isBreedable() && this.colony.getGoodsCount((GoodsType)g) < g.getBreedingNumber())) {
            required.incrementCount(gt2, gt2.getBreedingNumber());
        }
        if (this.isBadlyDefended()) {
            Role role = CollectionUtils.first(spec.getMilitaryRoles());
            Player owner = this.colony.getOwner();
            Predicate<Unit> rolePred = u -> u.roleIsAvailable(role) && (u.hasDefaultRole() || Role.rolesCompatible(role, u.getRole()));
            if (CollectionUtils.any(this.colony.getTile().getUnits(), rolePred)) {
                for (AbstractGoods ag : role.getRequiredGoodsList()) {
                    required.incrementCount(ag.getType(), ag.getAmount());
                }
            }
        }
        for (Wish wish : CollectionUtils.transform(this.wishes, w -> {
            if (w instanceof GoodsWish) {
                GoodsType t = ((GoodsWish)w).getGoodsType();
                return required.getCount(t) < this.colony.getGoodsCount(t);
            }
            return false;
        })) {
            this.completeWish(wish, "redundant", lb);
        }
        Iterator<FreeColObject> iterator = required.keySet().iterator();
        while (iterator.hasNext()) {
            int amount;
            GoodsType type;
            GoodsType requiredType;
            for (requiredType = type = (GoodsType)iterator.next(); requiredType != null && !requiredType.isStorable(); requiredType = requiredType.getInputType()) {
            }
            if (requiredType == null || (amount = Math.min(this.colony.getWarehouseCapacity(), required.getCount(type) - this.colony.getGoodsCount(requiredType))) <= 0) continue;
            int value = goodsWishValue;
            if (this.colony.canProduce(requiredType)) {
                value /= 10;
            }
            this.requireGoodsWish(requiredType, amount, value, lb);
        }
    }

    private void clearTileImprovementPlans() {
        this.tileImprovementPlans.clear();
    }

    private void addTileImprovementPlan(TileImprovementPlan plan) {
        this.tileImprovementPlans.add(plan);
    }

    public List<TileImprovementPlan> getTileImprovementPlans() {
        return new ArrayList<TileImprovementPlan>(this.tileImprovementPlans);
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.tileImprovementPlans.remove(plan);
    }

    private TileImprovementPlan getPlanFor(Tile tile, List<TileImprovementPlan> plans) {
        return CollectionUtils.find(plans, tip -> tip.getTarget() == tile);
    }

    public void updateTileImprovementPlans(LogBuilder lb) {
        List<WorkLocation> wls = CollectionUtils.transform(this.colony.getAvailableWorkLocations(), w -> w instanceof ColonyTile);
        ArrayList<TileImprovementPlan> newPlans = new ArrayList<TileImprovementPlan>(wls.size());
        for (WorkLocation wl : wls) {
            GoodsType goodsType;
            Tile workTile = wl.getWorkTile();
            ColonyTile colonyTile = (ColonyTile)wl;
            if (workTile.getOwningSettlement() != this.colony || this.getPlanFor(workTile, newPlans) != null) continue;
            if (colonyTile.isColonyCenterTile()) {
                AbstractGoods food = CollectionUtils.find(wl.getProduction(), AbstractGoods::isFoodType);
                goodsType = food == null ? null : food.getType();
            } else {
                GoodsType goodsType2 = goodsType = wl.isEmpty() ? null : wl.getCurrentWorkType();
            }
            if (goodsType == null) continue;
            TileImprovementPlan plan = this.getPlanFor(workTile, this.tileImprovementPlans);
            if (plan == null) {
                TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(workTile, goodsType);
                if (type != null) {
                    plan = new TileImprovementPlan(this.getAIMain(), workTile, type, type.getImprovementValue(workTile, goodsType));
                }
            } else if (!plan.update(goodsType)) {
                plan = null;
            }
            if (plan == null) continue;
            TileType change = plan.getType().getChange(workTile.getType());
            Predicate<WorkLocation> forestPred = cwl -> cwl instanceof ColonyTile && !((ColonyTile)cwl).isColonyCenterTile() && cwl.getWorkTile().isForested();
            if (change != null && !change.isForested() && !colonyTile.isColonyCenterTile() && CollectionUtils.count(this.colony.getAvailableWorkLocations(), forestPred) <= 1) continue;
            newPlans.add(plan);
        }
        this.clearTileImprovementPlans();
        this.tileImprovementPlans.addAll(newPlans);
        this.tileImprovementPlans.sort(ValuedAIObject.descendingValueComparator);
        if (!this.tileImprovementPlans.isEmpty()) {
            lb.add(", improve:");
            for (TileImprovementPlan tip : this.tileImprovementPlans) {
                lb.add(" ", tip.getTarget(), "-", tip.getType().getSuffix());
            }
        }
    }

    public List<BuildableType> getPlannedBuildableTypes() {
        return this.colonyPlan == null ? Collections.emptyList() : this.colonyPlan.getBuildableTypes();
    }

    public String planToString() {
        if (this.colonyPlan == null) {
            return "No plan.";
        }
        LogBuilder lb = new LogBuilder(256);
        lb.add(this.colonyPlan, "\n\nTILE IMPROVEMENTS:\n");
        for (TileImprovementPlan tip : this.getTileImprovementPlans()) {
            lb.add(tip, "\n");
        }
        lb.add("\n\nWISHES:\n");
        for (Wish w : this.getWishes()) {
            lb.add(w, "\n");
        }
        lb.add("\n\nEXPORT GOODS:\n");
        for (AIGoods aig : this.getExportGoods()) {
            lb.add(aig, "\n");
        }
        return lb.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("Property change REARRANGE_WORKERS fired.");
        this.requestRearrange();
        if (event != null && event.getOldValue() instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)event.getOldValue();
            int left = this.colony.getGoodsCount(goodsType);
            for (AIGoods aig : this.getExportGoods()) {
                boolean remove = false;
                if (aig.isDisposed()) {
                    remove = true;
                } else if (aig.getGoods() == null) {
                    aig.changeTransport(null);
                    remove = true;
                } else if (aig.getGoodsType() == goodsType) {
                    if (left > 0) {
                        aig.getGoods().setAmount(left);
                    } else {
                        aig.changeTransport(null);
                        remove = true;
                    }
                }
                if (!remove) continue;
                this.removeExportGoods(aig);
                break;
            }
        }
    }

    public void requestRearrange() {
        this.rearrangeTurn = new Turn(0);
    }

    @Override
    public void dispose() {
        Predicate<AIGoods> ourGoodsPred = aig -> !aig.isDisposed() && aig.getGoods() != null && aig.getGoods().getLocation() == this.colony;
        List<AIObject> objects = CollectionUtils.transform(this.getExportGoods(), ourGoodsPred, aig -> aig);
        objects.addAll(this.wishes);
        this.clearWishes();
        objects.addAll(this.tileImprovementPlans);
        this.clearTileImprovementPlans();
        for (AIObject o : objects) {
            o.dispose();
        }
        this.colonyPlan = null;
        super.dispose();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.colony == null || this.colony.isDisposed()) {
            lb.add("\n  Null colony: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (AIGoods ag : this.getExportGoods()) {
            if (!ag.checkIntegrity(true).safe()) continue;
            xw.writeStartElement(AI_GOODS_LIST_TAG);
            xw.writeAttribute("id", ag);
            xw.writeEndElement();
        }
        for (TileImprovementPlan tip : this.tileImprovementPlans) {
            if (!tip.checkIntegrity(true).safe()) continue;
            xw.writeStartElement(TILE_IMPROVEMENT_PLAN_LIST_TAG);
            xw.writeAttribute("id", tip);
            xw.writeEndElement();
        }
        for (Wish w : this.wishes) {
            String tag;
            String string = w instanceof GoodsWish ? GOODS_WISH_LIST_TAG : (tag = w instanceof WorkerWish ? WORKER_WISH_LIST_TAG : null);
            if (!w.checkIntegrity(true).safe() || !w.shouldBeStored() || tag == null) continue;
            xw.writeStartElement(tag);
            xw.writeAttribute("id", w);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.colony = xr.getAttribute(aiMain.getGame(), "id", Colony.class, (Colony)null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.baseInitialize();
        this.clearExportGoods();
        this.clearTileImprovementPlans();
        this.clearWishes();
        super.readChildren(xr);
        this.sortExportGoods();
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = xr.getLocalName();
        if (AI_GOODS_LIST_TAG.equals(tag)) {
            this.addExportGoods(xr.makeAIObject(aiMain, "id", AIGoods.class, null, true));
            xr.closeTag(AI_GOODS_LIST_TAG);
        } else if (GOODS_WISH_LIST_TAG.equals(tag)) {
            this.addWish(xr.makeAIObject(aiMain, "id", GoodsWish.class, null, true));
            xr.closeTag(GOODS_WISH_LIST_TAG);
        } else if (TILE_IMPROVEMENT_PLAN_LIST_TAG.equals(tag) || OLD_TILE_IMPROVEMENT_PLAN_LIST_TAG.equals(tag)) {
            this.addTileImprovementPlan(xr.makeAIObject(aiMain, "id", TileImprovementPlan.class, null, true));
            xr.closeTag(tag);
        } else if (WORKER_WISH_LIST_TAG.equals(tag)) {
            this.addWish(xr.makeAIObject(aiMain, "id", WorkerWish.class, null, true));
            xr.closeTag(WORKER_WISH_LIST_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

