/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization;

import java.util.Map;
import java.util.Optional;
import org.opensearch.neuralsearch.processor.normalization.L2ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.MinMaxScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;

public class ScoreNormalizationFactory {
    public static final ScoreNormalizationTechnique DEFAULT_METHOD = new MinMaxScoreNormalizationTechnique();
    private final Map<String, ScoreNormalizationTechnique> scoreNormalizationMethodsMap = Map.of("min_max", new MinMaxScoreNormalizationTechnique(), "l2", new L2ScoreNormalizationTechnique());

    public ScoreNormalizationTechnique createNormalization(String technique) {
        return Optional.ofNullable(this.scoreNormalizationMethodsMap.get(technique)).orElseThrow(() -> new IllegalArgumentException("provided normalization technique is not supported"));
    }
}

