/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.common.utils.ExponentialBackoff;

class RequestState {
    static final int RETRY_BACKOFF_EXP_BASE = 2;
    static final double RETRY_BACKOFF_JITTER = 0.2;
    private final ExponentialBackoff exponentialBackoff;
    private long lastSentMs = -1L;
    private long lastReceivedMs = -1L;
    private int numAttempts = 0;
    private long backoffMs = 0L;

    public RequestState(long retryBackoffMs) {
        this.exponentialBackoff = new ExponentialBackoff(retryBackoffMs, 2, retryBackoffMs, 0.2);
    }

    RequestState(long retryBackoffMs, int retryBackoffExpBase, long retryBackoffMaxMs, double jitter) {
        this.exponentialBackoff = new ExponentialBackoff(retryBackoffMs, retryBackoffExpBase, retryBackoffMaxMs, jitter);
    }

    public void reset() {
        this.lastSentMs = -1L;
        this.lastReceivedMs = -1L;
        this.numAttempts = 0;
        this.backoffMs = this.exponentialBackoff.backoff(0L);
    }

    public boolean canSendRequest(long currentTimeMs) {
        if (this.lastSentMs == -1L) {
            return true;
        }
        if (this.lastReceivedMs == -1L || this.lastReceivedMs < this.lastSentMs) {
            return false;
        }
        return this.requestBackoffExpired(currentTimeMs);
    }

    public void onSendAttempt(long currentTimeMs) {
        this.lastSentMs = currentTimeMs;
    }

    public void onSuccessfulAttempt(long currentTimeMs) {
        this.lastReceivedMs = currentTimeMs;
        this.backoffMs = this.exponentialBackoff.backoff(0L);
        this.numAttempts = 0;
    }

    public void onFailedAttempt(long currentTimeMs) {
        this.lastReceivedMs = currentTimeMs;
        this.backoffMs = this.exponentialBackoff.backoff(this.numAttempts);
        ++this.numAttempts;
    }

    private boolean requestBackoffExpired(long currentTimeMs) {
        return this.remainingBackoffMs(currentTimeMs) <= 0L;
    }

    long remainingBackoffMs(long currentTimeMs) {
        long timeSinceLastReceiveMs = currentTimeMs - this.lastReceivedMs;
        return Math.max(0L, this.backoffMs - timeSinceLastReceiveMs);
    }
}

