/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.tracing.ScopedSpan;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.attributes.Attributes;
import org.opensearch.telemetry.tracing.noop.NoopTracer;

@InternalApi
final class WrappedTracer
implements Tracer {
    private final Tracer defaultTracer;
    private final TelemetrySettings telemetrySettings;

    public WrappedTracer(TelemetrySettings telemetrySettings, Tracer defaultTracer) {
        this.defaultTracer = defaultTracer;
        this.telemetrySettings = telemetrySettings;
    }

    public Span startSpan(SpanCreationContext context) {
        return this.startSpan(context.getSpanName(), context.getAttributes());
    }

    public Span startSpan(String spanName) {
        return this.startSpan(spanName, Attributes.EMPTY);
    }

    public Span startSpan(String spanName, Attributes attributes) {
        return this.startSpan(spanName, (SpanContext)null, attributes);
    }

    public SpanContext getCurrentSpan() {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.getCurrentSpan();
    }

    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext) {
        return this.startScopedSpan(spanCreationContext, null);
    }

    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext, SpanContext parentSpan) {
        return this.getDelegateTracer().startScopedSpan(spanCreationContext, parentSpan);
    }

    public SpanScope withSpanInScope(Span span) {
        return this.getDelegateTracer().withSpanInScope(span);
    }

    public Span startSpan(String spanName, SpanContext parentSpan, Attributes attributes) {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.startSpan(spanName, parentSpan, attributes);
    }

    public void close() throws IOException {
        this.defaultTracer.close();
    }

    Tracer getDelegateTracer() {
        return this.telemetrySettings.isTracingEnabled() ? this.defaultTracer : NoopTracer.INSTANCE;
    }

    public Span startSpan(String spanName, Map<String, List<String>> headers, Attributes attributes) {
        return this.defaultTracer.startSpan(spanName, headers, attributes);
    }
}

