/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;

public class SecurityConfigApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> getRoutes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/securityconfig/")));
    private static final List<RestHandler.Route> allRoutes = new ImmutableList.Builder().addAll(getRoutes).addAll(Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/securityconfig/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/securityconfig/")))).build();
    private final boolean allowPutOrPatch;

    @Inject
    public SecurityConfigApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.CONFIG, clusterService, threadPool, securityApiDependencies);
        this.allowPutOrPatch = securityApiDependencies.settings().getAsBoolean("plugins.security.unsupported.restapi.allow_securityconfig_modification", Boolean.valueOf(false));
        this.requestHandlersBuilder.configureRequestHandlers(this::securityConfigApiActionRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return this.allowPutOrPatch ? allRoutes : getRoutes;
    }

    @Override
    protected CType getConfigType() {
        return CType.CONFIG;
    }

    private void securityConfigApiActionRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withAllowedEndpoint((RestRequest)request).map(this::withConfigEntityNameOnly).map(ignore -> this.processPutRequest((RestRequest)request)))).onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withAllowedEndpoint((RestRequest)request).map(this::processPatchRequest))).override(RestRequest.Method.DELETE, RequestHandler.methodNotImplementedHandler).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler);
    }

    ValidationResult<RestRequest> withAllowedEndpoint(RestRequest request) {
        if (!this.allowPutOrPatch) {
            return ValidationResult.error(RestStatus.NOT_IMPLEMENTED, Responses.methodNotImplementedMessage(request.method()));
        }
        return ValidationResult.success(request);
    }

    ValidationResult<String> withConfigEntityNameOnly(RestRequest request) {
        String name = this.nameParam(request);
        if (!"config".equals(name)) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("name must be config"));
        }
        return ValidationResult.success(name);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return SecurityConfigApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return SecurityConfigApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return SecurityConfigApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"dynamic", (Object)((Object)RequestContentValidator.DataType.OBJECT));
                    }
                });
            }
        };
    }
}

