/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class RestApiAdminPrivilegesEvaluator {
    protected final Logger logger = LogManager.getLogger(RestApiAdminPrivilegesEvaluator.class);
    public static final String CERTS_INFO_ACTION = "certs";
    public static final String RELOAD_CERTS_ACTION = "reloadcerts";
    private static final String REST_API_PERMISSION_PREFIX = "restapi:admin";
    private static final String REST_ENDPOINT_PERMISSION_PATTERN = "restapi:admin/%s";
    private static final String REST_ENDPOINT_ACTION_PERMISSION_PATTERN = "restapi:admin/%s/%s";
    private static final WildcardMatcher REST_API_PERMISSION_PREFIX_MATCHER = WildcardMatcher.from("restapi:admin/*");
    public static final Map<Endpoint, PermissionBuilder> ENDPOINTS_WITH_PERMISSIONS = ImmutableMap.builder().put((Object)Endpoint.ACTIONGROUPS, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.ACTIONGROUPS)).put((Object)Endpoint.ALLOWLIST, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.ALLOWLIST)).put((Object)Endpoint.INTERNALUSERS, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.INTERNALUSERS)).put((Object)Endpoint.NODESDN, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.NODESDN)).put((Object)Endpoint.ROLES, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.ROLES)).put((Object)Endpoint.ROLESMAPPING, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.ROLESMAPPING)).put((Object)Endpoint.TENANTS, action -> RestApiAdminPrivilegesEvaluator.buildEndpointPermission(Endpoint.TENANTS)).put((Object)Endpoint.SSL, action -> {
        switch (action) {
            case "certs": {
                return RestApiAdminPrivilegesEvaluator.buildEndpointActionPermission(Endpoint.SSL, "certs/info");
            }
            case "reloadcerts": {
                return RestApiAdminPrivilegesEvaluator.buildEndpointActionPermission(Endpoint.SSL, "certs/reload");
            }
        }
        return null;
    }).build();
    private final ThreadContext threadContext;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final AdminDNs adminDNs;
    private final boolean restapiAdminEnabled;

    public RestApiAdminPrivilegesEvaluator(ThreadContext threadContext, PrivilegesEvaluator privilegesEvaluator, AdminDNs adminDNs, boolean restapiAdminEnabled) {
        this.threadContext = threadContext;
        this.privilegesEvaluator = privilegesEvaluator;
        this.adminDNs = adminDNs;
        this.restapiAdminEnabled = restapiAdminEnabled;
    }

    public boolean isCurrentUserAdminFor(Endpoint endpoint, String action) {
        Pair<User, TransportAddress> userAndRemoteAddress = Utils.userAndRemoteAddressFrom(this.threadContext);
        if (userAndRemoteAddress.getLeft() == null) {
            return false;
        }
        if (this.adminDNs.isAdmin((User)userAndRemoteAddress.getLeft())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Security admin permissions required for endpoint {} but {} is not an admin", (Object)endpoint, (Object)((User)userAndRemoteAddress.getLeft()).getName());
            }
            return true;
        }
        if (!ENDPOINTS_WITH_PERMISSIONS.containsKey((Object)endpoint)) {
            this.logger.debug("No permission found for {} endpoint", (Object)endpoint);
            return false;
        }
        String permission = ENDPOINTS_WITH_PERMISSIONS.get((Object)endpoint).build(action);
        boolean hasAccess = this.privilegesEvaluator.hasRestAdminPermissions((User)userAndRemoteAddress.getLeft(), (TransportAddress)userAndRemoteAddress.getRight(), permission);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("User {} with permission {} {} access to endpoint {}", (Object)((User)userAndRemoteAddress.getLeft()).getName(), (Object)permission, (Object)(hasAccess ? "has" : "has no"), (Object)endpoint);
            this.logger.debug("{} set to {}. {} use access decision", (Object)"plugins.security.restapi.admin.enabled", (Object)this.restapiAdminEnabled, (Object)(this.restapiAdminEnabled ? "Will" : "Will not"));
        }
        return hasAccess && this.restapiAdminEnabled;
    }

    public boolean containsRestApiAdminPermissions(Object configObject) {
        if (configObject == null) {
            return false;
        }
        if (configObject instanceof RoleV7) {
            return ((RoleV7)configObject).getCluster_permissions().stream().anyMatch(REST_API_PERMISSION_PREFIX_MATCHER);
        }
        if (configObject instanceof ActionGroupsV7) {
            return ((ActionGroupsV7)configObject).getAllowed_actions().stream().anyMatch(REST_API_PERMISSION_PREFIX_MATCHER);
        }
        return false;
    }

    public boolean isCurrentUserAdminFor(Endpoint endpoint) {
        return this.isCurrentUserAdminFor(endpoint, null);
    }

    private static String buildEndpointActionPermission(Endpoint endpoint, String action) {
        return String.format(REST_ENDPOINT_ACTION_PERMISSION_PATTERN, endpoint.name().toLowerCase(Locale.ROOT), action);
    }

    private static String buildEndpointPermission(Endpoint endpoint) {
        return String.format(REST_ENDPOINT_PERMISSION_PATTERN, endpoint.name().toLowerCase(Locale.ROOT));
    }

    @FunctionalInterface
    public static interface PermissionBuilder {
        default public String build() {
            return this.build(null);
        }

        public String build(String var1);
    }
}

