/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.TriConsumer;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;

@FunctionalInterface
public interface RequestHandler {
    public static final RequestHandler methodNotImplementedHandler = (channel, request, client) -> Responses.methodNotImplemented(channel, request.method());
    public static final RequestHandler accessDeniedHandler = (channel, request, client) -> Responses.forbidden(channel, "Access denied");

    public void handle(RestChannel var1, RestRequest var2, Client var3) throws IOException;

    public static final class RequestHandlersBuilder {
        static final Set<RestRequest.Method> SUPPORTED_METHODS = Set.of(RestRequest.Method.DELETE, RestRequest.Method.GET, RestRequest.Method.PATCH, RestRequest.Method.POST, RestRequest.Method.PUT);
        static final Set<RestRequest.Method> ON_CHANGE_REQUEST = Set.of(RestRequest.Method.DELETE, RestRequest.Method.PATCH, RestRequest.Method.PUT);
        private TriConsumer<Client, SecurityDynamicConfiguration<?>, AbstractApiAction.OnSucessActionListener<IndexResponse>> saveOrUpdateConfigurationHandler;
        private Predicate<RestRequest> accessHandler;
        private boolean checkPermissions = false;
        final Map<RestRequest.Method, RequestHandler> requestHandlers = new HashMap<RestRequest.Method, RequestHandler>();

        RequestHandlersBuilder() {
            SUPPORTED_METHODS.forEach(method -> this.requestHandlers.put((RestRequest.Method)method, methodNotImplementedHandler));
        }

        public RequestHandlersBuilder verifyAccessForAllMethods() {
            this.checkPermissions = true;
            Map<RestRequest.Method, RequestHandler> handlers = this.build();
            handlers.forEach(this::add);
            return this;
        }

        public RequestHandlersBuilder allMethodsNotImplemented() {
            Map<RestRequest.Method, RequestHandler> handlers = this.build();
            handlers.forEach((method, requestHandler) -> this.add((RestRequest.Method)method, methodNotImplementedHandler));
            return this;
        }

        public RequestHandlersBuilder add(RestRequest.Method method, RequestHandler requestHandler) {
            if (!SUPPORTED_METHODS.contains(method)) {
                throw new IllegalArgumentException("Unsupported HTTP method " + method + ". Supported are: " + SUPPORTED_METHODS);
            }
            if (this.checkPermissions && requestHandler != methodNotImplementedHandler) {
                this.requestHandlers.put(method, (channel, request, client) -> {
                    if (this.accessHandler.test(request)) {
                        requestHandler.handle(channel, request, client);
                    } else {
                        accessDeniedHandler.handle(channel, request, client);
                    }
                });
            } else {
                this.requestHandlers.put(method, requestHandler);
            }
            return this;
        }

        public RequestHandlersBuilder override(RestRequest.Method method, RequestHandler requestOperationHandler) {
            this.add(method, requestOperationHandler);
            return this;
        }

        public RequestHandlersBuilder withAccessHandler(Predicate<RestRequest> accessHandler) {
            this.accessHandler = Objects.requireNonNull(accessHandler, "accessHandler can't be null");
            return this;
        }

        RequestHandlersBuilder withSaveOrUpdateConfigurationHandler(TriConsumer<Client, SecurityDynamicConfiguration<?>, AbstractApiAction.OnSucessActionListener<IndexResponse>> saveOrUpdateConfigurationHandler) {
            this.saveOrUpdateConfigurationHandler = Objects.requireNonNull(saveOrUpdateConfigurationHandler, "saveOrUpdateConfigurationHandler can't be null");
            return this;
        }

        public RequestHandlersBuilder onGetRequest(CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException> mapper) {
            Objects.requireNonNull(mapper, "onGetRequest request handler can't be null");
            this.add(RestRequest.Method.GET, (channel, request, client) -> ((ValidationResult)mapper.apply((Object)request)).valid(securityConfiguration -> Responses.ok(channel, securityConfiguration.configuration())).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
            return this;
        }

        public RequestHandlersBuilder onChangeRequest(RestRequest.Method method, CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException> mapper) {
            Objects.requireNonNull(method, "method can't be null");
            Objects.requireNonNull(mapper, "onChangeRequest handler can't be null");
            if (!ON_CHANGE_REQUEST.contains(method)) {
                throw new IllegalArgumentException("Unsupported HTTP method " + method + ". Supported are: " + ON_CHANGE_REQUEST);
            }
            switch (method) {
                case PATCH: {
                    this.add(method, (channel, request, client) -> ((ValidationResult)mapper.apply((Object)request)).valid(securityConfiguration -> this.saveOrUpdateConfigurationHandler.apply((Object)client, securityConfiguration.configuration(), (Object)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

                        public void onResponse(IndexResponse indexResponse) {
                            if (securityConfiguration.maybeEntityName().isPresent()) {
                                Responses.ok(channel, "'" + securityConfiguration.entityName() + "' updated.");
                            } else {
                                Responses.ok(channel, "Resource updated.");
                            }
                        }
                    })).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
                    break;
                }
                case PUT: {
                    this.add(method, (channel, request, client) -> ((ValidationResult)mapper.apply((Object)request)).valid(securityConfiguration -> this.saveOrUpdateConfigurationHandler.apply((Object)client, securityConfiguration.configuration(), (Object)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

                        public void onResponse(IndexResponse response) {
                            if (securityConfiguration.entityExists()) {
                                Responses.ok(channel, "'" + securityConfiguration.entityName() + "' updated.");
                            } else {
                                Responses.created(channel, "'" + securityConfiguration.entityName() + "' created.");
                            }
                        }
                    })).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
                    break;
                }
                case DELETE: {
                    Objects.requireNonNull(mapper, "onDeleteRequest request handler can't be null");
                    this.add(RestRequest.Method.DELETE, (channel, request, client) -> ((ValidationResult)mapper.apply((Object)request)).valid(securityConfiguration -> this.saveOrUpdateConfigurationHandler.apply((Object)client, securityConfiguration.configuration(), (Object)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

                        public void onResponse(IndexResponse response) {
                            Responses.ok(channel, "'" + securityConfiguration.entityName() + "' deleted.");
                        }
                    })).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
                }
            }
            return this;
        }

        public void configureRequestHandlers(Consumer<RequestHandlersBuilder> requestHandlersBuilderHandler) {
            requestHandlersBuilderHandler.accept(this);
        }

        public Map<RestRequest.Method, RequestHandler> build() {
            Objects.requireNonNull(this.accessHandler, "accessHandler hasn't been set");
            Objects.requireNonNull(this.saveOrUpdateConfigurationHandler, "saveOrUpdateConfigurationHandler hasn't been set");
            return Map.copyOf(this.requestHandlers);
        }
    }
}

