/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog;

import java.io.Closeable;
import java.util.Map;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public interface AuditLog
extends Closeable {
    public void logFailedLogin(String var1, boolean var2, String var3, RestRequest var4);

    public void logSucceededLogin(String var1, boolean var2, String var3, RestRequest var4);

    public void logMissingPrivileges(String var1, String var2, RestRequest var3);

    public void logGrantedPrivileges(String var1, RestRequest var2);

    public void logMissingPrivileges(String var1, TransportRequest var2, Task var3);

    public void logGrantedPrivileges(String var1, TransportRequest var2, Task var3);

    public void logIndexEvent(String var1, TransportRequest var2, Task var3);

    public void logBadHeaders(TransportRequest var1, String var2, Task var3);

    public void logBadHeaders(RestRequest var1);

    public void logSecurityIndexAttempt(TransportRequest var1, String var2, Task var3);

    public void logSSLException(TransportRequest var1, Throwable var2, String var3, Task var4);

    public void logSSLException(RestRequest var1, Throwable var2);

    public void logDocumentRead(String var1, String var2, ShardId var3, Map<String, String> var4);

    public void logDocumentWritten(ShardId var1, GetResult var2, Engine.Index var3, Engine.IndexResult var4);

    public void logDocumentDeleted(ShardId var1, Engine.Delete var2, Engine.DeleteResult var3);

    public ComplianceConfig getComplianceConfig();

    public void setConfig(AuditConfig var1);

    public static enum Operation {
        CREATE,
        UPDATE,
        DELETE;

    }

    public static enum Origin {
        REST,
        TRANSPORT,
        LOCAL;

    }
}

