/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class AnomalyDetectorJobRequest
extends ActionRequest {
    private String detectorID;
    private DetectionDateRange detectionDateRange;
    private boolean historical;
    private long seqNo;
    private long primaryTerm;
    private String rawPath;

    public AnomalyDetectorJobRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorID = in.readString();
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.rawPath = in.readString();
        if (in.readBoolean()) {
            this.detectionDateRange = new DetectionDateRange(in);
        }
        this.historical = in.readBoolean();
    }

    public AnomalyDetectorJobRequest(String detectorID, long seqNo, long primaryTerm, String rawPath) {
        this(detectorID, null, false, seqNo, primaryTerm, rawPath);
    }

    public AnomalyDetectorJobRequest(String detectorID, DetectionDateRange detectionDateRange, boolean historical, long seqNo, long primaryTerm, String rawPath) {
        this.detectorID = detectorID;
        this.detectionDateRange = detectionDateRange;
        this.historical = historical;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.rawPath = rawPath;
    }

    public String getDetectorID() {
        return this.detectorID;
    }

    public DetectionDateRange getDetectionDateRange() {
        return this.detectionDateRange;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.detectorID);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.rawPath);
        if (this.detectionDateRange != null) {
            out.writeBoolean(true);
            this.detectionDateRange.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.historical);
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

