/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.storage;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.spark.client.SparkClient;
import org.opensearch.sql.spark.functions.scan.SparkSqlFunctionTableScanBuilder;
import org.opensearch.sql.spark.request.SparkQueryRequest;
import org.opensearch.sql.spark.storage.SparkScan;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class SparkTable
implements Table {
    private final SparkClient sparkClient;
    private final SparkQueryRequest sparkQueryRequest;

    public SparkTable(SparkClient sparkService, SparkQueryRequest sparkQueryRequest) {
        this.sparkClient = sparkService;
        this.sparkQueryRequest = sparkQueryRequest;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Exists operation is not supported in spark datasource");
    }

    public void create(Map<String, ExprType> schema) {
        throw new UnsupportedOperationException("Create operation is not supported in spark datasource");
    }

    public Map<String, ExprType> getFieldTypes() {
        return new HashMap<String, ExprType>();
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        SparkScan metricScan = new SparkScan(this.sparkClient);
        metricScan.setRequest(this.sparkQueryRequest);
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new DefaultImplementor(), (Object)metricScan);
    }

    public TableScanBuilder createScanBuilder() {
        return new SparkSqlFunctionTableScanBuilder(this.sparkClient, this.sparkQueryRequest);
    }

    @Generated
    public SparkQueryRequest getSparkQueryRequest() {
        return this.sparkQueryRequest;
    }
}

