/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.client.Client;
import org.opensearch.sql.legacy.domain.IndexStatement;
import org.opensearch.sql.legacy.executor.format.DataRows;
import org.opensearch.sql.legacy.executor.format.ResultSet;
import org.opensearch.sql.legacy.executor.format.Schema;

public class ShowResultSet
extends ResultSet {
    private static final String TABLE_TYPE = "BASE TABLE";
    private IndexStatement statement;
    private Object queryResult;

    public ShowResultSet(Client client, IndexStatement statement, Object queryResult) {
        this.client = client;
        this.clusterName = this.getClusterName();
        this.statement = statement;
        this.queryResult = queryResult;
        this.schema = new Schema(statement, this.loadColumns());
        this.dataRows = new DataRows(this.loadRows());
    }

    private List<Schema.Column> loadColumns() {
        ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
        columns.add(new Schema.Column("TABLE_CAT", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TABLE_SCHEM", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TABLE_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TABLE_TYPE", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("REMARKS", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TYPE_CAT", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TYPE_SCHEM", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TYPE_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SELF_REFERENCING_COL_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("REF_GENERATION", null, Schema.Type.KEYWORD));
        return columns;
    }

    private List<DataRows.Row> loadRows() {
        ArrayList<DataRows.Row> rows = new ArrayList<DataRows.Row>();
        for (String index : this.extractIndices()) {
            rows.add(new DataRows.Row(this.loadData(index)));
        }
        return rows;
    }

    private List<String> extractIndices() {
        String indexPattern = this.statement.getIndexPattern();
        String[] indices = ((GetIndexResponse)this.queryResult).getIndices();
        return Arrays.stream(indices).filter(index -> this.matchesPatternIfRegex((String)index, indexPattern)).collect(Collectors.toList());
    }

    private Map<String, Object> loadData(String tableName) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("TABLE_CAT", this.clusterName);
        data.put("TABLE_NAME", tableName);
        data.put("TABLE_TYPE", TABLE_TYPE);
        return data;
    }
}

