/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;

public class CorrelationRuleIndices {
    private static final Logger log = LogManager.getLogger(CorrelationRuleIndices.class);
    private final Client client;
    private final ClusterService clusterService;

    public CorrelationRuleIndices(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public static String correlationRuleIndexMappings() throws IOException {
        return new String(Objects.requireNonNull(CorrelationRuleIndices.class.getClassLoader().getResourceAsStream("mappings/correlation-rules.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initCorrelationRuleIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.correlationRuleIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opensearch-sap-correlation-rules-config").mapping(CorrelationRuleIndices.correlationRuleIndexMappings()).settings(Settings.builder().put("index.hidden", true).build());
            this.client.admin().indices().create(indexRequest, actionListener);
        }
    }

    public boolean correlationRuleIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.getRoutingTable().hasIndex(".opensearch-sap-correlation-rules-config");
    }
}

