/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentBuilder;

public class CorrelationIndices {
    private static final Logger log = LogManager.getLogger(CorrelationIndices.class);
    public static final String CORRELATION_INDEX = ".opensearch-sap-correlation-history";
    public static final long FIXED_HISTORICAL_INTERVAL = 1728000000L;
    private final Client client;
    private final ClusterService clusterService;

    public CorrelationIndices(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public static String correlationMappings() throws IOException {
        return new String(Objects.requireNonNull(CorrelationIndices.class.getClassLoader().getResourceAsStream("mappings/correlation.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initCorrelationIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.correlationIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(CORRELATION_INDEX).mapping(CorrelationIndices.correlationMappings()).settings(Settings.builder().put("index.hidden", true).put("index.correlation", true).build());
            this.client.admin().indices().create(indexRequest, actionListener);
        }
    }

    public boolean correlationIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.getRoutingTable().hasIndex(CORRELATION_INDEX);
    }

    public void setupCorrelationIndex(TimeValue indexTimeout, Long setupTimestamp, ActionListener<BulkResponse> listener) {
        try {
            long currentTimestamp = System.currentTimeMillis();
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.field("root", true);
            builder.field("counter", 0L);
            builder.field("finding1", "");
            builder.field("finding2", "");
            builder.field("logType", "");
            builder.field("timestamp", currentTimestamp);
            builder.field("scoreTimestamp", 0L);
            builder.endObject();
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(CORRELATION_INDEX).source(builder).timeout(indexTimeout);
            XContentBuilder scoreBuilder = XContentFactory.jsonBuilder().startObject();
            scoreBuilder.field("scoreTimestamp", setupTimestamp);
            scoreBuilder.field("root", false);
            scoreBuilder.endObject();
            IndexRequest scoreIndexRequest = (IndexRequest)new IndexRequest(CORRELATION_INDEX).source(scoreBuilder).timeout(indexTimeout);
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.add(indexRequest);
            bulkRequest.add(scoreIndexRequest);
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, listener);
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
    }

    public ClusterIndexHealth correlationIndexHealth() {
        ClusterIndexHealth indexHealth = null;
        if (this.correlationIndexExists()) {
            IndexRoutingTable indexRoutingTable = this.clusterService.state().routingTable().index(CORRELATION_INDEX);
            IndexMetadata indexMetadata = this.clusterService.state().metadata().index(CORRELATION_INDEX);
            indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
        }
        return indexHealth;
    }
}

