/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class RareTopNOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final RareTopN.CommandType commandType;
    private final Integer noOfResults;
    private final List<Expression> fieldExprList;
    private final List<Expression> groupByExprList;
    private final Group group;
    private Iterator<ExprValue> iterator;
    private static final Integer DEFAULT_NO_OF_RESULTS = 10;

    public RareTopNOperator(PhysicalPlan input, RareTopN.CommandType commandType, List<Expression> fieldExprList, List<Expression> groupByExprList) {
        this(input, commandType, DEFAULT_NO_OF_RESULTS, fieldExprList, groupByExprList);
    }

    public RareTopNOperator(PhysicalPlan input, RareTopN.CommandType commandType, int noOfResults, List<Expression> fieldExprList, List<Expression> groupByExprList) {
        this.input = input;
        this.commandType = commandType;
        this.noOfResults = noOfResults;
        this.fieldExprList = fieldExprList;
        this.groupByExprList = groupByExprList;
        this.group = new Group();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitRareTopN(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    @Override
    public void open() {
        super.open();
        while (this.input.hasNext()) {
            this.group.push((ExprValue)this.input.next());
        }
        this.iterator = this.group.result().iterator();
    }

    @Generated
    public String toString() {
        return "RareTopNOperator(input=" + this.getInput() + ", commandType=" + this.getCommandType() + ", noOfResults=" + this.getNoOfResults() + ", fieldExprList=" + this.getFieldExprList() + ", groupByExprList=" + this.getGroupByExprList() + ", group=" + this.group + ", iterator=" + this.iterator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RareTopNOperator)) {
            return false;
        }
        RareTopNOperator other = (RareTopNOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$noOfResults = this.getNoOfResults();
        Integer other$noOfResults = other.getNoOfResults();
        if (this$noOfResults == null ? other$noOfResults != null : !((Object)this$noOfResults).equals(other$noOfResults)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        RareTopN.CommandType this$commandType = this.getCommandType();
        RareTopN.CommandType other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !((Object)((Object)this$commandType)).equals((Object)other$commandType)) {
            return false;
        }
        List<Expression> this$fieldExprList = this.getFieldExprList();
        List<Expression> other$fieldExprList = other.getFieldExprList();
        if (this$fieldExprList == null ? other$fieldExprList != null : !((Object)this$fieldExprList).equals(other$fieldExprList)) {
            return false;
        }
        List<Expression> this$groupByExprList = this.getGroupByExprList();
        List<Expression> other$groupByExprList = other.getGroupByExprList();
        return !(this$groupByExprList == null ? other$groupByExprList != null : !((Object)this$groupByExprList).equals(other$groupByExprList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RareTopNOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $noOfResults = this.getNoOfResults();
        result = result * 59 + ($noOfResults == null ? 43 : ((Object)$noOfResults).hashCode());
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        RareTopN.CommandType $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : ((Object)((Object)$commandType)).hashCode());
        List<Expression> $fieldExprList = this.getFieldExprList();
        result = result * 59 + ($fieldExprList == null ? 43 : ((Object)$fieldExprList).hashCode());
        List<Expression> $groupByExprList = this.getGroupByExprList();
        result = result * 59 + ($groupByExprList == null ? 43 : ((Object)$groupByExprList).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public RareTopN.CommandType getCommandType() {
        return this.commandType;
    }

    @Generated
    public Integer getNoOfResults() {
        return this.noOfResults;
    }

    @Generated
    public List<Expression> getFieldExprList() {
        return this.fieldExprList;
    }

    @Generated
    public List<Expression> getGroupByExprList() {
        return this.groupByExprList;
    }

    @VisibleForTesting
    public class Group {
        private final Map<Key, Map<Key, Integer>> groupListMap = new HashMap<Key, Map<Key, Integer>>();

        public void push(ExprValue inputValue) {
            Key groupKey = new Key(inputValue, RareTopNOperator.this.groupByExprList);
            Key fieldKey = new Key(inputValue, RareTopNOperator.this.fieldExprList);
            this.groupListMap.computeIfAbsent(groupKey, k -> {
                HashMap<Key, Integer> map = new HashMap<Key, Integer>();
                map.put(fieldKey, 1);
                return map;
            });
            this.groupListMap.computeIfPresent(groupKey, (key, map) -> {
                map.computeIfAbsent(fieldKey, f -> 1);
                map.computeIfPresent(fieldKey, (field, count) -> count + 1);
                return map;
            });
        }

        public List<ExprValue> result() {
            ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
            this.groupListMap.forEach((groups, fieldMap) -> {
                LinkedHashMap map = new LinkedHashMap();
                List<Key> result = this.find((Map<Key, Integer>)fieldMap);
                result.forEach(field -> {
                    map.putAll(groups.keyMap(RareTopNOperator.this.groupByExprList));
                    map.putAll(field.keyMap(RareTopNOperator.this.fieldExprList));
                    resultBuilder.add((Object)ExprTupleValue.fromExprValueMap(map));
                });
            });
            return resultBuilder.build();
        }

        public List<Key> find(Map<Key, Integer> map) {
            Comparator valueComparator = RareTopN.CommandType.TOP.equals((Object)RareTopNOperator.this.commandType) ? Map.Entry.comparingByValue(Comparator.reverseOrder()) : Map.Entry.comparingByValue();
            return map.entrySet().stream().sorted(valueComparator).limit(RareTopNOperator.this.noOfResults.intValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        @Generated
        public Group() {
        }
    }

    @VisibleForTesting
    public class Key {
        private final List<ExprValue> valueList;

        public Key(ExprValue value, List<Expression> exprList) {
            this.valueList = exprList.stream().map(expr -> expr.valueOf(value.bindingTuples())).collect(Collectors.toList());
        }

        public Map<String, ExprValue> keyMap(List<Expression> exprList) {
            return Streams.zip(exprList.stream().map(expression -> expression.toString()), this.valueList.stream(), AbstractMap.SimpleEntry::new).collect(Collectors.toMap(key -> (String)key.getKey(), key -> (ExprValue)key.getValue()));
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ExprValue> this$valueList = this.valueList;
            List<ExprValue> other$valueList = other.valueList;
            return !(this$valueList == null ? other$valueList != null : !((Object)this$valueList).equals(other$valueList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ExprValue> $valueList = this.valueList;
            result = result * 59 + ($valueList == null ? 43 : ((Object)$valueList).hashCode());
            return result;
        }
    }
}

