/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class LimitOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final Integer limit;
    private final Integer offset;
    private Integer count = 0;

    @Override
    public void open() {
        super.open();
        while (this.input.hasNext() && this.count < this.offset) {
            Integer n = this.count;
            this.count = this.count + 1;
            this.input.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext() && this.count < this.offset + this.limit;
    }

    @Override
    public ExprValue next() {
        Integer n = this.count;
        this.count = this.count + 1;
        return (ExprValue)this.input.next();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return ImmutableList.of((Object)this.input);
    }

    @Generated
    public LimitOperator(PhysicalPlan input, Integer limit, Integer offset) {
        this.input = input;
        this.limit = limit;
        this.offset = offset;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public String toString() {
        return "LimitOperator(input=" + this.getInput() + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", count=" + this.getCount() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitOperator)) {
            return false;
        }
        LimitOperator other = (LimitOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        return !(this$input == null ? other$input != null : !this$input.equals(other$input));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LimitOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }
}

