/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.Settings;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.observability.util.SecureIndexClient;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/observability/index/ObservabilityIntegrationsIndex;", "Lorg/opensearch/common/lifecycle/LifecycleListener;", "()V", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "afterStart", "", "createMappingTemplate", "templateName", "", "patternName", "path", "createMappingTemplates", "getTemplateNames", "", "initialize", "isTemplateExists", "", "template", "opensearch-observability"})
public final class ObservabilityIntegrationsIndex
extends LifecycleListener {
    @NotNull
    public static final ObservabilityIntegrationsIndex INSTANCE = new ObservabilityIntegrationsIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityIntegrationsIndex.class);
    private static Client client;
    private static ClusterService clusterService;

    private ObservabilityIntegrationsIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final ObservabilityIntegrationsIndex initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ObservabilityIntegrationsIndex.client = new SecureIndexClient(client);
        ObservabilityIntegrationsIndex.clusterService = clusterService;
        return this;
    }

    public void afterStart() {
        this.createMappingTemplates();
    }

    private final List<String> getTemplateNames() {
        Object[] objectArray = new String[]{"metrics", "traces"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void createMappingTemplates() {
        for (String name : this.getTemplateNames()) {
            this.createMappingTemplate("ss4o_" + name + "_template", "ss4o_" + name + "-*-*", "templates/" + name + "-mapping-template.json");
        }
    }

    private final void createMappingTemplate(String templateName, String patternName, String path) {
        block9: {
            this.getLog().info("observability:createMappingTemplate " + templateName + " API called");
            if (!this.isTemplateExists(templateName)) {
                String string;
                ClassLoader classLoader = ObservabilityIntegrationsIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(path);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                    string = new String(byArray, charset);
                } else {
                    string = null;
                }
                Intrinsics.checkNotNull(string);
                String indexMappingSource = string;
                Settings settings = Settings.builder().put("index.number_of_shards", 3).put("index.auto_expand_replicas", "0-2").build();
                Template template = new Template(settings, new CompressedXContent(indexMappingSource), null);
                PutComposableIndexTemplateAction.Request request = new PutComposableIndexTemplateAction.Request(templateName).indexTemplate(new ComposableIndexTemplate(CollectionsKt.listOf((Object)patternName), template, Collections.emptyList(), Long.valueOf(1L), Long.valueOf(1L), Collections.singletonMap("description", "Observability " + templateName + " Mapping Template"), new ComposableIndexTemplate.DataStreamTemplate()));
                try {
                    ActionFuture actionFuture;
                    AcknowledgedResponse response;
                    ActionRequestValidationException validationException = request.validateIndexTemplate(null);
                    if (validationException != null && !validationException.validationErrors().isEmpty()) {
                        throw new IllegalStateException(("observability:Index Template " + templateName + " validation errors " + validationException.getMessage()).toString());
                    }
                    Client client = ObservabilityIntegrationsIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (AcknowledgedResponse)(actionFuture = client.admin().indices().execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException(("observability:Mapping Template " + templateName + " creation not Acknowledged").toString());
                    }
                    this.getLog().info("observability:Mapping Template " + templateName + " creation Acknowledged");
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block9;
                    throw exception;
                }
            }
        }
    }

    private final boolean isTemplateExists(String template) {
        try {
            Client client = ObservabilityIntegrationsIndex.client;
            if (client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                client = null;
            }
            IndicesAdminClient indices = client.admin().indices();
            String[] stringArray = new String[]{template};
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)indices.getTemplates(new GetIndexTemplatesRequest(stringArray)).get();
            List list = response.getIndexTemplates();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.indexTemplates");
            return !((Collection)list).isEmpty();
        }
        catch (ResourceNotFoundException exception) {
            return false;
        }
        catch (ResourceAlreadyExistsException exception) {
            return true;
        }
        catch (Exception exception) {
            throw exception;
        }
    }
}

