/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.JvmTerminalCursor;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0015\u001a\u00020\rH\u0000\u001a.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\b\u0010!\u001a\u00020\rH\u0000\u001a\b\u0010\"\u001a\u00020\rH\u0000\u001a\b\u0010#\u001a\u00020\rH\u0000\u00a8\u0006$"}, d2={"codepointSequence", "Lkotlin/sequences/Sequence;", "", "string", "", "getEnv", "key", "getJavaProperty", "getTerminalSize", "Lkotlin/Pair;", "timeoutMs", "", "isWindows", "", "makePrintingTerminalCursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "parseSttySize", "output", "parseWindowsPowershellSize", "runningInIdeaJavaAgent", "sendInterceptedPrintRequest", "", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "lock", "", "stdinInteractive", "stdoutInteractive", "terminalSizeDetectionIsFast", "mordant"})
public final class MppImplKt {
    public static final boolean terminalSizeDetectionIsFast() {
        return false;
    }

    @Nullable
    public static final Pair<Integer, Integer> getTerminalSize(long timeoutMs) {
        Object cmd;
        Object object;
        try {
            ProcessBuilder processBuilder;
            if (MppImplKt.isWindows()) {
                object = new String[]{"powershell.exe", "-noprofile", "-command", "$host.ui.rawui"};
                ProcessBuilder processBuilder2 = new ProcessBuilder((String)object);
                processBuilder = processBuilder2;
            } else {
                object = new String[]{"stty", "size"};
                ProcessBuilder processBuilder3 = new ProcessBuilder((String)object);
                processBuilder = processBuilder3;
            }
            cmd = processBuilder;
            cmd = ((ProcessBuilder)cmd).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (IOException e) {
            return null;
        }
        Object process = cmd;
        try {
            if (!((Process)process).waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
                return null;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        object = ((Process)process).getInputStream();
        Intrinsics.checkNotNullExpressionValue(object, "process.inputStream");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        int n = 0;
        object2 = new InputStreamReader((InputStream)object2, charset);
        n = 8192;
        boolean bl2 = false;
        object = TextStreamsKt.readText(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n));
        boolean bl3 = false;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String output = ((Object)StringsKt.trim((CharSequence)object)).toString();
        return MppImplKt.isWindows() ? MppImplKt.parseWindowsPowershellSize(output) : MppImplKt.parseSttySize(output);
    }

    private static final Pair<Integer, Integer> parseWindowsPowershellSize(String output) {
        Object object;
        MatchResult matchResult = Regex.find$default(new Regex("[Ww]indow[Ss]ize\\s+:?\\s+(\\d+),(\\d+)"), output, 0, 2, null);
        Object object2 = object = matchResult == null ? null : matchResult.getGroupValues();
        if (object == null) {
            return null;
        }
        List<String> groups2 = object;
        object = groups2.get(1);
        boolean bl = false;
        Integer n = Integer.parseInt((String)object);
        object = groups2.get(2);
        bl = false;
        return TuplesKt.to(n, Integer.parseInt((String)object));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Integer, Integer> parseSttySize(String output) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{" "};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)output, stringArray, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toIntOrNull(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Integer it$iv$iv = n;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dimens = (List)destination$iv$iv;
        if (dimens.size() != 2) {
            return null;
        }
        return TuplesKt.to(dimens.get(1), dimens.get(0));
    }

    public static final boolean isWindows() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"os.name\")");
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, "win", false, 2, null);
    }

    @Nullable
    public static final String getEnv(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getenv(key);
    }

    @Nullable
    public static final String getJavaProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getProperty(key);
    }

    public static final boolean runningInIdeaJavaAgent() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = bean.getInputArguments();
                Intrinsics.checkNotNullExpressionValue(jvmArgs, "jvmArgs");
                Iterable $this$any$iv = jvmArgs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue(it, "it");
                        if (!(StringsKt.startsWith$default(it, "-javaagent", false, 2, null) && StringsKt.contains$default((CharSequence)it, "idea_rt.jar", false, 2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean stdoutInteractive() {
        return System.console() != null;
    }

    public static final boolean stdinInteractive() {
        return System.console() != null;
    }

    @NotNull
    public static final Sequence<Integer> codepointSequence(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "string.codePoints().iterator()");
        return SequencesKt.asSequence(ofInt);
    }

    @NotNull
    public static final TerminalCursor makePrintingTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        return new JvmTerminalCursor(terminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void sendInterceptedPrintRequest(@NotNull PrintRequest request, @NotNull TerminalInterface terminalInterface, @NotNull List<? extends TerminalInterceptor> interceptors, @NotNull Object lock) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(terminalInterface, "terminalInterface");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        Intrinsics.checkNotNullParameter(lock, "lock");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock) {
            void $this$fold$iv;
            boolean bl3 = false;
            Iterable iterable = interceptors;
            TerminalInterface terminalInterface2 = terminalInterface;
            boolean $i$f$fold = false;
            PrintRequest accumulator$iv = request;
            for (Object element$iv : $this$fold$iv) {
                void it;
                TerminalInterceptor terminalInterceptor = (TerminalInterceptor)element$iv;
                PrintRequest acc = accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = it.intercept(acc);
            }
            PrintRequest printRequest = accumulator$iv;
            terminalInterface2.completePrintRequest(printRequest);
            Unit unit = Unit.INSTANCE;
        }
    }
}

