/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ImmutablePair;
import gnu.text.SourceLocator;
import gnu.text.SourceMapper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PairWithPosition
extends ImmutablePair
implements SourceLocator {
    String filename;
    long position;

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public final void setLine(int lineno, int colno) {
        this.position = SourceMapper.simpleEncode(lineno, colno);
    }

    public final void setEndLine(int endline, int endcolumn) {
        this.position = SourceMapper.simpleEncode(this.getStartLine(), this.getStartColumn(), endline, endcolumn);
    }

    public final void setLine(int lineno) {
        this.setLine(lineno, 0);
    }

    @Override
    public final String getFileName() {
        return this.filename;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.filename;
    }

    @Override
    public final int getLineNumber() {
        return SourceMapper.simpleStartLine(this.position);
    }

    @Override
    public final int getColumnNumber() {
        return SourceMapper.simpleStartColumn(this.position);
    }

    @Override
    public final int getStartLine() {
        return SourceMapper.simpleStartLine(this.position);
    }

    @Override
    public final int getStartColumn() {
        return SourceMapper.simpleStartColumn(this.position);
    }

    @Override
    public final int getEndLine() {
        return SourceMapper.simpleEndLine(this.position);
    }

    @Override
    public final int getEndColumn() {
        return SourceMapper.simpleEndColumn(this.position);
    }

    @Override
    public boolean isStableSourceLocation() {
        return true;
    }

    public PairWithPosition() {
    }

    public PairWithPosition(SourceLocator where, Object car, Object cdr) {
        super(car, cdr);
        this.filename = where.getFileName();
        this.position = SourceMapper.simpleEncode(where.getStartLine(), where.getStartColumn(), where.getEndLine(), where.getEndColumn());
    }

    public PairWithPosition(Object car, Object cdr) {
        super(car, cdr);
    }

    public static PairWithPosition make(Object car, Object cdr, String filename, int line, int column) {
        PairWithPosition pair = new PairWithPosition(car, cdr);
        pair.filename = filename;
        pair.setLine(line, column);
        return pair;
    }

    public static PairWithPosition make(Object car, Object cdr, String filename, long position) {
        PairWithPosition pair = new PairWithPosition(car, cdr);
        pair.filename = filename;
        pair.position = position;
        return pair;
    }

    public void init(Object car, Object cdr, String filename, long position) {
        this.car = car;
        this.cdr = cdr;
        this.filename = filename;
        this.position = position;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.car);
        out.writeObject(this.cdr);
        out.writeObject(this.filename);
        out.writeLong(this.position);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object car = in.readObject();
        Object cdr = in.readObject();
        String filename = (String)in.readObject();
        long position = in.readLong();
        this.init(car, cdr, filename, position);
    }
}

