/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.DeleteShardCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateShardCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public CreateShardCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String extCollectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        log.info("Create shard invoked: {}", (Object)message);
        if (extCollectionName == null || sliceName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", collection.getInt("nrtReplicas", collection.getInt("replicationFactor", Integer.valueOf(1)))));
        int numPullReplicas = message.getInt("pullReplicas", collection.getInt("pullReplicas", Integer.valueOf(0)));
        int numTlogReplicas = message.getInt("tlogReplicas", collection.getInt("tlogReplicas", Integer.valueOf(0)));
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
        if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
            this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionCreateShard, message, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
        } else {
            this.ccc.offerStateUpdate(Utils.toJSON((Object)message));
        }
        clusterState = CollectionHandlingUtils.waitForNewShard(collectionName, sliceName, this.ccc.getZkStateReader());
        String async = message.getStr("async");
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "nrtReplicas", String.valueOf(numNrtReplicas), "tlogReplicas", String.valueOf(numTlogReplicas), "pullReplicas", String.valueOf(numPullReplicas), "createNodeSet", message.getStr("createNodeSet"), "waitForFinalState", Boolean.toString(waitForFinalState)});
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        CollectionHandlingUtils.addPropertyParams(message, propertyParams);
        addReplicasProps = addReplicasProps.plus(propertyParams);
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        try {
            new AddReplicaCmd(this.ccc).addReplica(clusterState, addReplicasProps, (NamedList<Object>)addResult, () -> {
                NamedList addResultFailure = (NamedList)addResult.get("failure");
                if (addResultFailure != null) {
                    SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                    if (failure == null) {
                        failure = new SimpleOrderedMap();
                        results.add("failure", (Object)failure);
                    }
                    failure.addAll(addResultFailure);
                } else {
                    SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                    if (success == null) {
                        success = new SimpleOrderedMap();
                        results.add("success", (Object)success);
                    }
                    NamedList addResultSuccess = (NamedList)addResult.get("success");
                    success.addAll(addResultSuccess);
                }
            });
        }
        catch (Assign.AssignmentException e) {
            ZkNodeProps deleteShard = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "async", async});
            new DeleteShardCmd(this.ccc).call(clusterState, deleteShard, results);
            throw e;
        }
        log.info("Finished create command on all shards for collection: {}", (Object)collectionName);
    }
}

