/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfTable;
import java.util.Enumeration;
import java.util.Vector;

public class DxfLTYPE
extends DxfTable {
    public static final short LTYPE_XREF = 16;
    public static final short LTYPE_XREF_FOUND = 32;
    public static final short LTYPE_USED = 64;
    public static final String CONTINUOUS = "CONTINUOUS";
    public static final String BYBLOCK = "BYBLOCK";
    public static final String BYLAYER = "BYLAYER";
    private boolean isConti = false;
    private String description;
    private short adjust;
    private float length;
    private Vector pattern;

    DxfLTYPE() {
        this(CONTINUOUS);
    }

    DxfLTYPE(String name) {
        this.name = name.toUpperCase();
    }

    public boolean setGroup(short grpNr, String str) {
        if (grpNr == 3) {
            this.description = str;
            return true;
        }
        return super.setGroup(grpNr, str);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 72: {
                this.adjust = (short)ival;
                break;
            }
            case 73: {
                if (this.pattern != null || ival <= 0) break;
                this.pattern = new Vector(ival);
                break;
            }
            default: {
                return super.setGroup(grpNr, ival);
            }
        }
        return true;
    }

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 40: {
                this.length = fval;
                break;
            }
            case 49: {
                if (this.pattern == null) {
                    this.pattern = new Vector(5);
                }
                this.pattern.addElement(new Float(fval));
                break;
            }
            default: {
                return super.setGroup(grpNr, fval);
            }
        }
        return true;
    }

    public boolean finishRead(DxfFile file) {
        float[] segments = this.getPattern();
        float reallength = 0.0f;
        if (segments != null) {
            int s = segments.length - 1;
            while (s >= 0) {
                reallength += Math.abs(segments[s]);
                --s;
            }
        }
        if (reallength != this.length) {
            Math.abs(this.length - reallength);
            this.length = reallength;
        }
        this.isConti = CONTINUOUS.equals(this.name) || this.length == 0.0f;
        return true;
    }

    public boolean isContinuous() {
        return this.isConti;
    }

    public float getPatternLength() {
        return this.length;
    }

    public float[] getPattern() {
        if (this.isConti || this.pattern == null) {
            return null;
        }
        float[] ret = new float[this.pattern.size()];
        int pos = 0;
        Enumeration e = this.pattern.elements();
        while (e.hasMoreElements()) {
            ret[pos++] = ((Float)e.nextElement()).floatValue();
        }
        return ret;
    }

    public String getDescription() {
        return this.description;
    }

    public short getAdjustmentFlags() {
        return this.adjust;
    }
}

