<?php

declare(strict_types=1);
/**
 * @copyright Copyright (c) 2022 Robin Appelman <robin@icewind.nl>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Photos\Album;

use OC\Metadata\FileMetadata;

class AlbumFile {
	private int $fileId;
	private string $name;
	private string $mimeType;
	private int $size;
	private int $mtime;
	private string $etag;
	private int $added;
	private string $owner;
	/** @var array<string, FileMetadata> */
	private array $metaData = [];

	public function __construct(
		int $fileId,
		string $name,
		string $mimeType,
		int $size,
		int $mtime,
		string $etag,
		int $added,
		string $owner
	) {
		$this->fileId = $fileId;
		$this->name = $name;
		$this->mimeType = $mimeType;
		$this->size = $size;
		$this->mtime = $mtime;
		$this->etag = $etag;
		$this->added = $added;
		$this->owner = $owner;
	}

	public function getFileId(): int {
		return $this->fileId;
	}

	public function getName(): string {
		return $this->name;
	}

	public function getMimeType(): string {
		return $this->mimeType;
	}

	public function getSize(): int {
		return $this->size;
	}

	public function getMTime(): int {
		return $this->mtime;
	}

	public function getEtag(): string {
		return $this->etag;
	}

	public function setMetadata(string $key, FileMetadata $value): void {
		$this->metaData[$key] = $value;
	}

	public function hasMetadata(string $key): bool {
		return isset($this->metaData[$key]);
	}

	public function getMetadata(string $key): FileMetadata {
		return $this->metaData[$key];
	}

	public function getAdded(): int {
		return $this->added;
	}

	public function getOwner(): string {
		return $this->owner;
	}
}
