/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.fi;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "maailma" },
            { "002", "Afrikka" },
            { "003", "Pohjois-Amerikka" },
            { "005", "Etel\u00e4-Amerikka" },
            { "009", "Oseania" },
            { "011", "L\u00e4nsi-Afrikka" },
            { "013", "V\u00e4li-Amerikka" },
            { "014", "It\u00e4-Afrikka" },
            { "015", "Pohjois-Afrikka" },
            { "017", "Keski-Afrikka" },
            { "018", "etel\u00e4inen Afrikka" },
            { "019", "Amerikka" },
            { "021", "pohjoinen Amerikka" },
            { "029", "Karibia" },
            { "030", "It\u00e4-Aasia" },
            { "034", "Etel\u00e4-Aasia" },
            { "035", "Kaakkois-Aasia" },
            { "039", "Etel\u00e4-Eurooppa" },
            { "053", "Australia ja Uusi-Seelanti" },
            { "054", "Melanesia" },
            { "057", "Mikronesia" },
            { "061", "Polynesia" },
            { "142", "Aasia" },
            { "143", "Keski-Aasia" },
            { "145", "L\u00e4nsi-Aasia" },
            { "150", "Eurooppa" },
            { "151", "It\u00e4-Eurooppa" },
            { "154", "Pohjois-Eurooppa" },
            { "155", "L\u00e4nsi-Eurooppa" },
            { "419", "Latinalainen Amerikka" },
            { "AC", "Ascension-saari" },
            { "AD", "Andorra" },
            { "AE", "Arabiemiirikunnat" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AN", "Alankomaiden Antillit" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiina" },
            { "AS", "Amerikan Samoa" },
            { "AT", "It\u00e4valta" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Ahvenanmaa" },
            { "AZ", "Azerbaid\u017ean" },
            { "BA", "Bosnia ja Hertsegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BR", "Brasilia" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019nsaari" },
            { "BW", "Botswana" },
            { "BY", "Valko-Ven\u00e4j\u00e4" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kookossaaret" },
            { "CD", "Kongon demokraattinen tasavalta" },
            { "CF", "Keski-Afrikan tasavalta" },
            { "CG", "Kongon tasavalta" },
            { "CH", "Sveitsi" },
            { "CI", "Norsunluurannikko" },
            { "CK", "Cookinsaaret" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kiina" },
            { "CO", "Kolumbia" },
            { "CP", "Clippertoninsaari" },
            { "CR", "Costa Rica" },
            { "CS", "Serbia ja Montenegro" },
            { "CU", "Kuuba" },
            { "CV", "Kap Verde" },
            { "CX", "Joulusaari" },
            { "CY", "Kypros" },
            { "CZ", "T\u0161ekki" },
            { "DE", "Saksa" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Tanska" },
            { "DM", "Dominica" },
            { "DO", "Dominikaaninen tasavalta" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta ja Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Viro" },
            { "EG", "Egypti" },
            { "EH", "L\u00e4nsi-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Espanja" },
            { "ET", "Etiopia" },
            { "FI", "Suomi" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandinsaaret" },
            { "FM", "Mikronesian liittovaltio" },
            { "FO", "F\u00e4rsaaret" },
            { "FR", "Ranska" },
            { "FX", "Ranskan Eurooppaan kuuluvat osat" },
            { "GA", "Gabon" },
            { "GB", "Britannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Ranskan Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nlanti" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "P\u00e4iv\u00e4ntasaajan Guinea" },
            { "GR", "Kreikka" },
            { "GS", "Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong \u2013 Kiinan e.h.a." },
            { "HM", "Heard- ja McDonaldinsaaret" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Unkari" },
            { "IC", "Kanariansaaret" },
            { "ID", "Indonesia" },
            { "IE", "Irlanti" },
            { "IL", "Israel" },
            { "IM", "Mansaari" },
            { "IN", "Intia" },
            { "IO", "Brittil\u00e4inen Intian valtameren alue" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanti" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japani" },
            { "KE", "Kenia" },
            { "KG", "Kirgisia" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komorit" },
            { "KN", "Saint Kitts ja Nevis" },
            { "KP", "Pohjois-Korea" },
            { "KR", "Etel\u00e4-Korea" },
            { "KW", "Kuwait" },
            { "KY", "Caymansaaret" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Liettua" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinsaaret" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar [Burma]" },
            { "MN", "Mongolia" },
            { "MO", "Macao \u2013 Kiinan e.h.a." },
            { "MP", "Pohjois-Mariaanit" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediivit" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Uusi-Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsaari" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Alankomaat" },
            { "NO", "Norja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Uusi-Seelanti" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Ranskan Polynesia" },
            { "PG", "Papua-Uusi-Guinea" },
            { "PH", "Filippiinit" },
            { "PK", "Pakistan" },
            { "PL", "Puola" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiina" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "ulkomeri" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Ven\u00e4j\u00e4" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabia" },
            { "SB", "Salomonsaaret" },
            { "SC", "Seychellit" },
            { "SD", "Sudan" },
            { "SE", "Ruotsi" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Huippuvuoret ja Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Syyria" },
            { "SZ", "Swazimaa" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- ja Caicossaaret" },
            { "TD", "T\u0161ad" },
            { "TF", "Ranskan ulkopuoliset etel\u00e4iset alueet" },
            { "TG", "Togo" },
            { "TH", "Thaimaa" },
            { "TJ", "Tad\u017eikistan" },
            { "TK", "Tokelau" },
            { "TL", "It\u00e4-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkki" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Yhdysvaltain pienet erillissaaret" },
            { "US", "Yhdysvallat" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikaani" },
            { "VC", "Saint Vincent ja Grenadiinit" },
            { "VE", "Venezuela" },
            { "VG", "Brittil\u00e4iset Neitsytsaaret" },
            { "VI", "Yhdysvaltain Neitsytsaaret" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ja Futuna" },
            { "WS", "Samoa" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Etel\u00e4-Afrikka" },
            { "ZM", "Sambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tuntematon tai virheellinen alue" },
            { "aa", "afar" },
            { "ab", "abhaasi" },
            { "ae", "avesta" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhara" },
            { "an", "aragonia" },
            { "ar", "arabia" },
            { "as", "assami" },
            { "av", "avaari" },
            { "ay", "aimara" },
            { "az", "azeri" },
            { "ba", "ba\u0161kiiri" },
            { "be", "valkoven\u00e4j\u00e4" },
            { "bg", "bulgaria" },
            { "bh", "bihari" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tiibet" },
            { "br", "bretoni" },
            { "bs", "bosnia" },
            { "ca", "katalaani" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "co", "korsika" },
            { "cr", "cree" },
            { "cs", "t\u0161ekki" },
            { "cu", "kirkkoslaavi" },
            { "cv", "t\u0161uvassi" },
            { "cy", "kymri" },
            { "da", "tanska" },
            { "de", "saksa" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "kreikka" },
            { "en", "englanti" },
            { "eo", "esperanto" },
            { "es", "espanja" },
            { "et", "viro" },
            { "eu", "baski" },
            { "fa", "farsi" },
            { "ff", "fulani" },
            { "fi", "suomi" },
            { "fj", "fid\u017ei" },
            { "fo", "f\u00e4\u00e4ri" },
            { "fr", "ranska" },
            { "fy", "l\u00e4nsifriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galicia" },
            { "gn", "guarani" },
            { "gu", "gud\u017earati" },
            { "gv", "manksi" },
            { "ha", "hausa" },
            { "he", "heprea" },
            { "hi", "hindi" },
            { "ho", "hiri-motu" },
            { "hr", "kroatia" },
            { "ht", "haiti" },
            { "hu", "unkari" },
            { "hy", "armenia" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesia" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuanin-yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islanti" },
            { "it", "italia" },
            { "iu", "inuktitut" },
            { "ja", "japani" },
            { "jv", "jaava" },
            { "ka", "georgia" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kuanjama" },
            { "kk", "kazakki" },
            { "kl", "kalaallisut" },
            { "km", "keskikhmer" },
            { "kn", "kannada" },
            { "ko", "korea" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miri" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "la", "latina" },
            { "lb", "luxemburg" },
            { "lg", "ganda" },
            { "li", "limburg" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "liettua" },
            { "lu", "katanganluba" },
            { "lv", "latvia" },
            { "mg", "malagassi" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedonia" },
            { "ml", "malajalam" },
            { "mn", "mongoli" },
            { "mo", "moldova" },
            { "mr", "marathi" },
            { "ms", "malaiji" },
            { "mt", "malta" },
            { "my", "burma" },
            { "na", "nauru" },
            { "nb", "norjan bokm\u00e5l" },
            { "nd", "pohjois-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "hollanti" },
            { "nn", "norjan nynorsk" },
            { "no", "norja" },
            { "nr", "etel\u00e4-ndebele" },
            { "nv", "navajo" },
            { "ny", "njand\u017ea" },
            { "oc", "oksitaani" },
            { "oj", "od\u017eibwa" },
            { "om", "oromo" },
            { "or", "orija" },
            { "os", "osseetti" },
            { "pa", "pand\u017eabi" },
            { "pi", "paali" },
            { "pl", "puola" },
            { "ps", "pa\u0161tu" },
            { "pt", "portugali" },
            { "qu", "ket\u0161ua" },
            { "rm", "retoromaani" },
            { "rn", "rundi" },
            { "ro", "romania" },
            { "ru", "ven\u00e4j\u00e4" },
            { "rw", "ruanda" },
            { "sa", "sanskrit" },
            { "sc", "sardi" },
            { "sd", "sindhi" },
            { "se", "pohjoissaame" },
            { "sg", "sango" },
            { "sh", "serbokroaatti" },
            { "si", "sinhala" },
            { "sk", "slovakki" },
            { "sl", "sloveeni" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somali" },
            { "sq", "albania" },
            { "sr", "serbia" },
            { "ss", "swazi" },
            { "st", "etel\u00e4sotho" },
            { "su", "sunda" },
            { "sv", "ruotsi" },
            { "sw", "swahili" },
            { "ta", "tamili" },
            { "te", "telugu" },
            { "tg", "tad\u017eikki" },
            { "th", "thai" },
            { "ti", "tigrinja" },
            { "tk", "turkmeeni" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tongantonga" },
            { "tr", "turkki" },
            { "ts", "tsonga" },
            { "tt", "tataari" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "ug", "uiguuri" },
            { "uk", "ukraina" },
            { "ur", "urdu" },
            { "uz", "uzbekki" },
            { "ve", "venda" },
            { "vi", "vietnam" },
            { "vo", "volap\u00fck" },
            { "wa", "valloni" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddi\u0161" },
            { "yo", "joruba" },
            { "za", "zhuang" },
            { "zh", "kiina" },
            { "zu", "zulu" },
            { "ace", "at\u0161eh" },
            { "ach", "at\u0161oli" },
            { "ada", "adangme" },
            { "ady", "adyge" },
            { "afa", "afroaasialainen kieli" },
            { "afh", "afrihili" },
            { "ain", "ainu" },
            { "akk", "akkadi" },
            { "ale", "aleutti" },
            { "alg", "algonkikieli" },
            { "alt", "altai" },
            { "ang", "muinaisenglanti" },
            { "anp", "angika" },
            { "apa", "apa\u0161\u0161ikieli" },
            { "arc", "valtakunnanaramea" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "art", "keinotekoinen kieli" },
            { "arw", "arawak" },
            { "asa", "asu" },
            { "ast", "asturia" },
            { "ath", "athabascakieli" },
            { "aus", "australialainen kieli" },
            { "awa", "awadhi" },
            { "bad", "banda" },
            { "bai", "bamilekekieli" },
            { "bal", "belut\u0161i" },
            { "ban", "bali" },
            { "bas", "basa" },
            { "bat", "balttilainen kieli" },
            { "bej", "bed\u017ea" },
            { "bem", "bemba" },
            { "ber", "berberikieli" },
            { "bez", "bena" },
            { "bho", "bhod\u017epuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bantukieli" },
            { "bra", "brad\u017e" },
            { "brx", "bodo" },
            { "btk", "batakkieli" },
            { "bua", "burjaatti" },
            { "bug", "bugi" },
            { "byn", "bilin" },
            { "cad", "caddo" },
            { "cai", "keskiamerikkalainen intiaanikieli" },
            { "car", "karibi" },
            { "cau", "kaukasialainen kieli" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "kelttil\u00e4inen kieli" },
            { "chb", "t\u0161ibt\u0161a" },
            { "chg", "t\u0161agatai" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "chinook-jargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "cmc", "t\u0161amkieli" },
            { "cop", "kopti" },
            { "cpe", "englantiin perustuva kreoli- tai pidgin-kieli" },
            { "cpf", "ranskaan perustuva kreoli- tai pidgin-kieli" },
            { "cpp", "portugaliin perustuva kreoli- tai pidgin-kieli" },
            { "crh", "krimintataari" },
            { "crp", "kreoli- tai pidgin-kieli" },
            { "csb", "ka\u0161ubi" },
            { "cus", "kuu\u0161ilainen kieli" },
            { "dak", "dakota" },
            { "dar", "dargi" },
            { "day", "land-dajakki-kieli" },
            { "del", "delaware" },
            { "den", "slevi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "doi", "dogri" },
            { "dra", "dravidakieli" },
            { "dsb", "alasorbi" },
            { "dua", "duala" },
            { "dum", "keskihollanti" },
            { "dyu", "djula" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "muinaisegypti" },
            { "eka", "ekajuk" },
            { "elx", "elami" },
            { "enm", "keskienglanti" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fiu", "suomalais-ugrilainen kieli" },
            { "fon", "fon" },
            { "frm", "keskiranska" },
            { "fro", "muinaisranska" },
            { "frr", "pohjoisfriisi" },
            { "frs", "it\u00e4friisi" },
            { "fur", "friuli" },
            { "gaa", "ga" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gem", "germaaninen kieli" },
            { "gez", "ge\u2019ez" },
            { "gil", "kiribati" },
            { "gmh", "keskiyl\u00e4saksa" },
            { "goh", "muinaisyl\u00e4saksa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gootti" },
            { "grb", "grebo" },
            { "grc", "muinaiskreikka" },
            { "gsw", "sveitsinsaksa" },
            { "gwi", "gwit\u0161in" },
            { "hai", "haida" },
            { "haw", "havaiji" },
            { "hil", "hiligaino" },
            { "him", "himat\u0161ali" },
            { "hit", "heetti" },
            { "hmn", "hmong" },
            { "hsb", "yl\u00e4sorbi" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ijo", "id\u017eokieli" },
            { "ilo", "iloko" },
            { "inc", "indoarjalainen kieli" },
            { "ine", "indoeurooppalainen kieli" },
            { "inh", "inguu\u0161i" },
            { "ira", "iranilainen kieli" },
            { "iro", "irokeesikieli" },
            { "jbo", "lojban" },
            { "jpr", "juutalaispersia" },
            { "jrb", "juutalaisarabia" },
            { "kaa", "karakalpakki" },
            { "kab", "kabyyli" },
            { "kac", "kat\u0161in" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "karen" },
            { "kaw", "kavi" },
            { "kbd", "kabardi" },
            { "kcg", "tyap" },
            { "kea", "kapverdenkreoli" },
            { "kfo", "norsunluurannikonkoro" },
            { "kha", "khasi" },
            { "khi", "khoisankieli" },
            { "kho", "khotani" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karat\u0161ai-balkaari" },
            { "krl", "karjala" },
            { "kro", "kru-kieli" },
            { "kru", "kurukh" },
            { "kum", "kumykki" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luluanluba" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lusai" },
            { "luy", "luhya" },
            { "mad", "madura" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassar" },
            { "man", "mandingo" },
            { "map", "austronesialainen kieli" },
            { "mas", "maasai" },
            { "mdf", "mok\u0161a" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "keski-iiri" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mis", "luokittelematon kieli" },
            { "mkh", "mon-khmer-kieli" },
            { "mnc", "mant\u0161u" },
            { "mni", "manipuri" },
            { "mno", "manobokieli" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mul", "monia kieli\u00e4" },
            { "mun", "mundakieli" },
            { "mus", "creek" },
            { "mwl", "mirandeesi" },
            { "mwr", "marwari" },
            { "myn", "mayakieli" },
            { "myv", "ers\u00e4" },
            { "nah", "nahuatlkieli" },
            { "nai", "pohjoisamerikkalainen intiaanikieli" },
            { "nap", "napoli" },
            { "nds", "alasaksa" },
            { "new", "newari" },
            { "nia", "nias" },
            { "nic", "nigeril\u00e4is-kongolainen kieli" },
            { "niu", "niue" },
            { "nog", "nogai" },
            { "non", "muinaisnorja" },
            { "nqo", "n\u2019ko" },
            { "nso", "pohjoissotho" },
            { "nub", "nubialainen kieli" },
            { "nwc", "klassinen newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "osmani" },
            { "oto", "otomikieli" },
            { "paa", "papualaiskieli" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamentu" },
            { "pau", "palau" },
            { "peo", "muinaispersia" },
            { "phi", "filippiinil\u00e4iskieli" },
            { "phn", "foinikia" },
            { "pon", "pohnpei" },
            { "pra", "prakritkieli" },
            { "pro", "muinaisprovensaali" },
            { "raj", "rad\u017eastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "roa", "romaaninen kieli" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromania" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakuutti" },
            { "sai", "etel\u00e4amerikkalainen intiaanikieli" },
            { "sal", "sali\u0161ilainen kieli" },
            { "sam", "samarianaramea" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "scn", "sisilia" },
            { "sco", "skotti" },
            { "sel", "selkuppi" },
            { "sem", "seemil\u00e4inen kieli" },
            { "sga", "muinaisiiri" },
            { "sgn", "viittomakieli" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "siouxkieli" },
            { "sit", "sinotiibetil\u00e4inen kieli" },
            { "sla", "slaavilainen kieli" },
            { "sma", "etel\u00e4saame" },
            { "smi", "saamelaiskieli" },
            { "smj", "luulajansaame" },
            { "smn", "inarinsaame" },
            { "sms", "koltansaame" },
            { "snk", "soninke" },
            { "sog", "sogdi" },
            { "son", "songhaikieli" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssa", "niilil\u00e4is-saharalainen kieli" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeri" },
            { "swb", "komori" },
            { "syc", "muinaissyyria" },
            { "syr", "syyria" },
            { "tai", "thaikieli" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tama\u0161ek" },
            { "tog", "malawintonga" },
            { "tpi", "tok-pisin" },
            { "tsi", "tsim\u0161i" },
            { "tum", "tumbuka" },
            { "tup", "tupikieli" },
            { "tut", "altailainen kieli" },
            { "tvl", "tuvalu" },
            { "tyv", "tuva" },
            { "udm", "udmurtti" },
            { "uga", "ugarit" },
            { "umb", "mbundu" },
            { "und", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n kieli" },
            { "vai", "vai" },
            { "vot", "vatja" },
            { "wae", "walser" },
            { "wak", "wakashkieli" },
            { "wal", "wolaitta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "sorbikieli" },
            { "xal", "kalmukki" },
            { "yao", "jao" },
            { "yap", "japi" },
            { "ypk", "jupikkikieli" },
            { "yue", "kantoninkiina" },
            { "zap", "zapoteekki" },
            { "zbl", "blisskieli" },
            { "zen", "zenaga" },
            { "znd", "zandekieli" },
            { "zun", "zuni" },
            { "zxx", "ei kielellist\u00e4 sis\u00e4lt\u00f6\u00e4" },
            { "zza", "zaza" },
            { "Arab", "arabialainen" },
            { "Armi", "valtakunnanaramealainen" },
            { "Armn", "armenialainen" },
            { "Avst", "avestalainen" },
            { "Bali", "balilainen" },
            { "Batk", "batakilainen" },
            { "Beng", "bengalilainen" },
            { "Blis", "bliss-symbolit" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille-pistekirjoitus" },
            { "Bugi", "bugilainen" },
            { "Buhd", "buhidilainen" },
            { "Cakm", "chakmalainen" },
            { "Cans", "kanadalaisten alkuper\u00e4iskansojen yhten\u00e4istetty tavukirjoitus" },
            { "Cari", "kaarialainen" },
            { "Cham", "t\u0161amilainen" },
            { "Cher", "cherokeelainen" },
            { "Cirt", "cirth" },
            { "Copt", "koptilainen" },
            { "Cprt", "muinaiskyproslainen" },
            { "Cyrl", "kyrillinen" },
            { "Cyrs", "kyrillinen muinaiskirkkoslaavimuunnelma" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egyptil\u00e4inen demoottinen" },
            { "Egyh", "egyptil\u00e4inen hieraattinen" },
            { "Egyp", "egyptil\u00e4iset hieroglyfit" },
            { "Ethi", "etiopialainen" },
            { "Geok", "muinaisgeorgialainen" },
            { "Geor", "georgialainen" },
            { "Glag", "glagoliittinen" },
            { "Goth", "goottilainen" },
            { "Grek", "kreikkalainen" },
            { "Gujr", "gud\u017earatilainen" },
            { "Guru", "gurmukhi" },
            { "Hang", "hangul" },
            { "Hani", "kiinalainen han" },
            { "Hano", "hanunoolainen" },
            { "Hans", "kiinalainen yksinkertaistettu han" },
            { "Hant", "kiinalainen perinteinen han" },
            { "Hebr", "heprealainen" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "hiragana tai katakana" },
            { "Hung", "muinaisunkarilainen" },
            { "Inds", "induslainen" },
            { "Ital", "muinaisitalialainen" },
            { "Java", "jaavalainen" },
            { "Jpan", "japanilainen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", "khmeril\u00e4inen" },
            { "Knda", "kannadalainen" },
            { "Kore", "korealainen" },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laolainen" },
            { "Latf", "latinalainen fraktuuramuunnelma" },
            { "Latg", "latinalainen gaelimuunnelma" },
            { "Latn", "latinalainen" },
            { "Lepc", "lepchalainen" },
            { "Limb", "limbulainen" },
            { "Lina", "lineaari-A" },
            { "Linb", "lineaari-B" },
            { "Lyci", "lyykialainen" },
            { "Lydi", "lyydialainen" },
            { "Mand", "mandealainen" },
            { "Mani", "manikealainen" },
            { "Maya", "maya-hieroglyfit" },
            { "Mero", "meroiittinen" },
            { "Mlym", "malajalamilainen" },
            { "Mong", "mongolilainen" },
            { "Moon", "moon-kohokirjoitus" },
            { "Mtei", "meitei" },
            { "Mymr", "burmalainen" },
            { "Nkoo", "n'ko" },
            { "Ogam", "ogam" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "orijalainen" },
            { "Osma", "osmanjalainen" },
            { "Perm", "muinaispermil\u00e4inen" },
            { "Phag", "phags-pa" },
            { "Phli", "piirtokirjoituspahlavilainen" },
            { "Phlp", "psalttaripahlavilainen" },
            { "Phlv", "kirjapahlavilainen" },
            { "Phnx", "foinikialainen" },
            { "Plrd", "Pollardin foneettinen" },
            { "Prti", "piirtokirjoitusparthialainen" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "riimukirjoitus" },
            { "Samr", "samarianaramealainen" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaw\u2019lainen" },
            { "Sinh", "sinhalilainen" },
            { "Sund", "sundalainen" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syyrialainen" },
            { "Syre", "syyrialainen estrangelo-muunnelma" },
            { "Syrj", "syyrialainen l\u00e4ntinen muunnelma" },
            { "Syrn", "syyrialainen it\u00e4inen muunnelma" },
            { "Tagb", "tagbanwalainen" },
            { "Tale", "tailelainen" },
            { "Talu", "uusi tailuelainen" },
            { "Taml", "tamililainen" },
            { "Tavt", "tai viet" },
            { "Telu", "telugulainen" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalogilainen" },
            { "Thaa", "thaana" },
            { "Thai", "thailainen" },
            { "Tibt", "tiibetil\u00e4inen" },
            { "Ugar", "ugaritilainen" },
            { "Vaii", "vailainen" },
            { "Visp", "n\u00e4kyv\u00e4 puhe" },
            { "Xpeo", "muinaispersialainen" },
            { "Xsux", "sumerilais-akkadilainen nuolenp\u00e4\u00e4kirjoitus" },
            { "Yiii", "yil\u00e4inen" },
            { "Zinh", "peritty" },
            { "Zmth", "matemaattinen" },
            { "Zsym", "symbolit" },
            { "Zxxx", "kirjoittamaton" },
            { "Zyyy", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n" },
            { "Zzzz", "tuntematon tai virheellinen kirjoitusj\u00e4rjestelm\u00e4" },
            { "root", "juuri" },
            { "de_AT", "it\u00e4vallansaksa" },
            { "de_CH", "sveitsinyl\u00e4saksa" },
            { "en_AU", "australianenglanti" },
            { "en_CA", "kanadanenglanti" },
            { "en_GB", "britannianenglanti" },
            { "en_US", "amerikanenglanti" },
            { "es_ES", "espanjanespanja" },
            { "fr_CA", "kanadanranska" },
            { "fr_CH", "sveitsinranska" },
            { "nl_BE", "flaami" },
            { "pt_BR", "brasilianportugali" },
            { "pt_PT", "portugalinportugali" },
            { "es_419", "amerikanespanja" },
            { "zh_Hans", "yksinkertaistettu kiina" },
            { "zh_Hant", "perinteinen kiina" },
        };
        return data;
    }
}
