/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.event.AbstractAuthorizationEvent;
import org.springframework.security.access.event.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.access.event.PublicInvocationEvent;

public class LoggerListener
implements ApplicationListener<AbstractAuthorizationEvent> {
    private static final Log logger = LogFactory.getLog(LoggerListener.class);

    @Override
    public void onApplicationEvent(AbstractAuthorizationEvent event) {
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            this.onAuthenticationCredentialsNotFoundEvent((AuthenticationCredentialsNotFoundEvent)event);
        }
        if (event instanceof AuthorizationFailureEvent) {
            this.onAuthorizationFailureEvent((AuthorizationFailureEvent)event);
        }
        if (event instanceof AuthorizedEvent) {
            this.onAuthorizedEvent((AuthorizedEvent)event);
        }
        if (event instanceof PublicInvocationEvent) {
            this.onPublicInvocationEvent((PublicInvocationEvent)event);
        }
    }

    private void onAuthenticationCredentialsNotFoundEvent(AuthenticationCredentialsNotFoundEvent authEvent) {
        logger.warn(LogMessage.format("Security interception failed due to: %s; secure object: %s; configuration attributes: %s", (Object)authEvent.getCredentialsNotFoundException(), authEvent.getSource(), authEvent.getConfigAttributes()));
    }

    private void onPublicInvocationEvent(PublicInvocationEvent event) {
        logger.info(LogMessage.format("Security interception not required for public secure object: %s", event.getSource()));
    }

    private void onAuthorizedEvent(AuthorizedEvent authEvent) {
        logger.info(LogMessage.format("Security authorized for authenticated principal: %s; secure object: %s; configuration attributes: %s", (Object)authEvent.getAuthentication(), authEvent.getSource(), authEvent.getConfigAttributes()));
    }

    private void onAuthorizationFailureEvent(AuthorizationFailureEvent authEvent) {
        logger.warn(LogMessage.format("Security authorization failed due to: %s; authenticated principal: %s; secure object: %s; configuration attributes: %s", (Object)authEvent.getAccessDeniedException(), (Object)authEvent.getAuthentication(), authEvent.getSource(), authEvent.getConfigAttributes()));
    }
}

