/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.google.inject.Injector;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.LifecycleObject;
import org.traccar.schedule.ScheduleTask;
import org.traccar.schedule.TaskDeviceInactivityCheck;
import org.traccar.schedule.TaskHealthCheck;
import org.traccar.schedule.TaskWebSocketKeepalive;

@Singleton
public class ScheduleManager
implements LifecycleObject {
    private final Injector injector;
    private ScheduledExecutorService executor;

    @Inject
    public ScheduleManager(Injector injector) {
        this.injector = injector;
    }

    @Override
    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        List.of(TaskDeviceInactivityCheck.class, TaskWebSocketKeepalive.class, TaskHealthCheck.class).forEach(task -> ((ScheduleTask)this.injector.getInstance(task)).schedule(this.executor));
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

