/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.traccar.Protocol;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@ChannelHandler.Sharable
public class TaipPrefixEncoder
extends MessageToMessageEncoder<ByteBuf> {
    private final Protocol protocol;
    private Config config;

    public TaipPrefixEncoder(Protocol protocol) {
        this.protocol = protocol;
    }

    @Inject
    public void setConfig(Config config) {
        this.config = config;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        if (this.config.getBoolean(Keys.PROTOCOL_PREFIX.withPrefix(this.protocol.getName()))) {
            out.add(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{32, 32, 6, 0}), msg.retain()}));
        } else {
            out.add(msg.retain());
        }
    }
}

