/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import javax.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.CharacterDelimiterFrameDecoder;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.MiniFinderProtocolDecoder;
import org.traccar.protocol.MiniFinderProtocolEncoder;

public class MiniFinderProtocol
extends BaseProtocol {
    @Inject
    public MiniFinderProtocol(Config config) {
        this.setSupportedDataCommands("setTimezone", "voiceMonitoring", "alarmSpeed", "alarmGeofence", "alarmVibration", "setAgps", "alarmFall", "modePowerSaving", "modeDeepSleep", "sosNumber", "setIndicator");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new CharacterDelimiterFrameDecoder(1024, ";\u0000", ";"));
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new MiniFinderProtocolEncoder(MiniFinderProtocol.this));
                pipeline.addLast((ChannelHandler)new MiniFinderProtocolDecoder(MiniFinderProtocol.this));
            }
        });
    }
}

