/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocol;
import org.traccar.ServerManager;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.database.CommandsManager;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.model.Typed;
import org.traccar.model.UserRestrictions;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="commands")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CommandResource
extends ExtendedObjectResource<Command> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandResource.class);
    @Inject
    private CommandsManager commandsManager;
    @Inject
    private ServerManager serverManager;

    public CommandResource() {
        super(Command.class);
    }

    private BaseProtocol getDeviceProtocol(long deviceId) throws StorageException {
        Position position = this.storage.getObject(Position.class, new Request(new Columns.All(), new Condition.LatestPositions(deviceId)));
        if (position != null) {
            return this.serverManager.getProtocol(position.getProtocol());
        }
        return null;
    }

    @GET
    @Path(value="send")
    public Collection<Command> get(@QueryParam(value="deviceId") long deviceId) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        BaseProtocol protocol = this.getDeviceProtocol(deviceId);
        return this.get(false, 0L, 0L, deviceId).stream().filter(command -> {
            String type = command.getType();
            if (protocol != null) {
                return command.getTextChannel() && protocol.getSupportedTextCommands().contains(type) || !command.getTextChannel() && protocol.getSupportedDataCommands().contains(type);
            }
            return type.equals("custom");
        }).collect(Collectors.toList());
    }

    @POST
    @Path(value="send")
    public Response send(Command entity) throws Exception {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getReadonly);
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getLimitCommands);
        this.permissionsService.checkPermission(Device.class, this.getUserId(), entity.getDeviceId());
        if (!this.commandsManager.sendCommand(entity)) {
            return Response.accepted((Object)entity).build();
        }
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="types")
    public Collection<Typed> get(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="textChannel") boolean textChannel) throws StorageException {
        Field[] fields;
        if (deviceId != 0L) {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
            BaseProtocol protocol = this.getDeviceProtocol(deviceId);
            if (protocol != null) {
                if (textChannel) {
                    return protocol.getSupportedTextCommands().stream().map(Typed::new).collect(Collectors.toList());
                }
                return protocol.getSupportedDataCommands().stream().map(Typed::new).collect(Collectors.toList());
            }
            return Collections.singletonList(new Typed("custom"));
        }
        ArrayList<Typed> result = new ArrayList<Typed>();
        for (Field field : fields = Command.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TYPE_")) continue;
            try {
                result.add(new Typed(field.get(null).toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException error) {
                LOGGER.warn("Get command types error", (Throwable)error);
            }
        }
        return result;
    }
}

