/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import java.util.Collection;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.traccar.api.BaseObjectResource;
import org.traccar.model.BaseModel;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class SimpleObjectResource<T extends BaseModel>
extends BaseObjectResource<T> {
    public SimpleObjectResource(Class<T> baseClass) {
        super(baseClass);
    }

    @GET
    public Collection<T> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId) throws StorageException {
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (all) {
            if (this.permissionsService.notAdmin(this.getUserId())) {
                conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
            }
        } else {
            if (userId == 0L) {
                userId = this.getUserId();
            } else {
                this.permissionsService.checkUser(this.getUserId(), userId);
            }
            conditions.add(new Condition.Permission(User.class, userId, this.baseClass));
        }
        return this.storage.getObjects(this.baseClass, new Request(new Columns.All(), Condition.merge(conditions)));
    }
}

