/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.helper.NbiThread;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.wizard.components.WizardPanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class ErrorMessagePanel
extends WizardPanel {
    public static final String CANCEL_DIALOG_MESSAGE_PROPERTY = "cancel.dialog.message";
    public static final String CANCEL_DIALOG_TITLE_PROPERTY = "cancel.dialog.title";
    public static final String ERROR_FAILED_VERIFY_INPUT_PROPERTY = "error.failed.verify.input";
    public static final String DEFAULT_CANCEL_DIALOG_MESSAGE_TEXT = ResourceUtils.getString(ErrorMessagePanel.class, "EMP.cancel.dialog.message");
    public static final String DEFAULT_CANCEL_DIALOG_TITLE_TEXT = ResourceUtils.getString(ErrorMessagePanel.class, "EMP.cancel.dialog.title");
    public static final String DEFAULT_ERROR_FAILED_VERIFY_INPUT_TEXT = ResourceUtils.getString(ErrorMessagePanel.class, "EMP.error.failed.input.verify");

    public ErrorMessagePanel() {
        this.setProperty(CANCEL_DIALOG_MESSAGE_PROPERTY, DEFAULT_CANCEL_DIALOG_MESSAGE_TEXT);
        this.setProperty(CANCEL_DIALOG_TITLE_PROPERTY, DEFAULT_CANCEL_DIALOG_TITLE_TEXT);
        this.setProperty(ERROR_FAILED_VERIFY_INPUT_PROPERTY, DEFAULT_ERROR_FAILED_VERIFY_INPUT_TEXT);
    }

    @Override
    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new ErrorMessagePanelUi(this);
        }
        return this.wizardUi;
    }

    public static class ErrorMessagePanelSwingUi
    extends WizardPanel.WizardPanelSwingUi {
        public static final String ERROR_ICON = "org/netbeans/installer/wizard/components/panels/error.png";
        public static final String WARNING_ICON = "org/netbeans/installer/wizard/components/panels/warning.png";
        public static final String INFO_ICON = "org/netbeans/installer/wizard/components/panels/info.png";
        public static final String EMPTY_ICON = "org/netbeans/installer/wizard/components/panels/empty.png";
        public static final Color ERROR_COLOR = Color.BLACK;
        public static final Color WARNING_COLOR = Color.BLACK;
        public static final Color INFO_COLOR = Color.BLACK;
        public static final Color EMPTY_COLOR = Color.BLACK;
        protected ErrorMessagePanel component;
        private Icon errorIcon;
        private Icon warningIcon;
        private Icon infoIcon;
        private Icon emptyIcon;
        private Color errorColor;
        private Color warningColor;
        private Color infoColor;
        private Color emptyColor;
        private NbiLabel errorLabel;
        private ValidatingThread validatingThread;

        public ErrorMessagePanelSwingUi(ErrorMessagePanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.errorIcon = new ImageIcon(this.getClass().getClassLoader().getResource(ERROR_ICON));
            this.warningIcon = new ImageIcon(this.getClass().getClassLoader().getResource(WARNING_ICON));
            this.infoIcon = new ImageIcon(this.getClass().getClassLoader().getResource(INFO_ICON));
            this.emptyIcon = new ImageIcon(this.getClass().getClassLoader().getResource(EMPTY_ICON));
            this.errorColor = ERROR_COLOR;
            this.warningColor = WARNING_COLOR;
            this.infoColor = INFO_COLOR;
            this.emptyColor = EMPTY_COLOR;
            this.initComponents();
        }

        @Override
        public void evaluateBackButtonClick() {
            if (this.validatingThread != null) {
                this.validatingThread.finish();
                this.validatingThread = null;
            }
            super.evaluateBackButtonClick();
        }

        @Override
        public void evaluateNextButtonClick() {
            String errorMessage;
            if (this.validatingThread != null) {
                this.validatingThread.pause();
            }
            if ((errorMessage = this.validateInput()) == null) {
                this.saveInput();
                if (this.validatingThread != null) {
                    this.validatingThread.finish();
                    this.validatingThread = null;
                }
                this.component.getWizard().next();
            } else {
                ErrorManager.notifyError(errorMessage);
                if (this.validatingThread != null) {
                    this.validatingThread.play();
                }
            }
        }

        @Override
        public void evaluateCancelButtonClick() {
            if (this.validatingThread != null) {
                this.validatingThread.pause();
            }
            if (!UiUtils.showYesNoDialog(this.component.getProperty(ErrorMessagePanel.CANCEL_DIALOG_TITLE_PROPERTY), this.component.getProperty(ErrorMessagePanel.CANCEL_DIALOG_MESSAGE_PROPERTY))) {
                if (this.validatingThread != null) {
                    this.validatingThread.play();
                }
                return;
            }
            if (this.validatingThread != null) {
                this.validatingThread.finish();
                this.validatingThread = null;
            }
            this.component.getWizard().getFinishHandler().cancel();
        }

        @Override
        protected void initialize() {
            this.updateErrorMessage();
            if (this.validatingThread == null) {
                this.validatingThread = new ValidatingThread(this, this.component);
                this.validatingThread.start();
            } else {
                this.validatingThread.play();
            }
        }

        protected String getWarningMessage() {
            return null;
        }

        protected String getInformationalMessage() {
            return null;
        }

        protected final synchronized void updateErrorMessage() {
            try {
                String message = this.validateInput();
                if (message != null) {
                    this.errorLabel.setIcon(this.errorIcon);
                    this.errorLabel.setText(message);
                    this.errorLabel.setForeground(this.errorColor);
                    this.container.getNextButton().setEnabled(false);
                    return;
                }
                message = this.getWarningMessage();
                if (message != null) {
                    this.errorLabel.setIcon(this.warningIcon);
                    this.errorLabel.setText(message);
                    this.errorLabel.setForeground(this.warningColor);
                    this.container.getNextButton().setEnabled(true);
                    return;
                }
                message = this.getInformationalMessage();
                if (message != null) {
                    this.errorLabel.setIcon(this.infoIcon);
                    this.errorLabel.setText(message);
                    this.errorLabel.setForeground(this.infoColor);
                    this.container.getNextButton().setEnabled(true);
                    return;
                }
                this.errorLabel.setIcon(this.emptyIcon);
                this.errorLabel.clearText();
                this.errorLabel.setForeground(this.emptyColor);
                this.container.getNextButton().setEnabled(true);
            }
            catch (Exception e) {
                ErrorManager.notifyError(this.component.getProperty(ErrorMessagePanel.ERROR_FAILED_VERIFY_INPUT_PROPERTY), e);
            }
        }

        private void initComponents() {
            this.errorLabel = new NbiLabel();
            this.add((Component)this.errorLabel, new GridBagConstraints(0, 99, 99, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 11, 11), 0, 0));
        }

        public static class ValidatingDocumentListener
        implements DocumentListener {
            private ErrorMessagePanelSwingUi swingUi;

            public ValidatingDocumentListener(ErrorMessagePanelSwingUi swingUi) {
                this.swingUi = swingUi;
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.swingUi.updateErrorMessage();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.swingUi.updateErrorMessage();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.swingUi.updateErrorMessage();
            }
        }

        public static class ValidatingThread
        extends NbiThread {
            private ErrorMessagePanelSwingUi swingUi;
            private boolean paused;
            private boolean stopped;
            public static final long VALIDATION_DELAY = 2000L;

            public ValidatingThread(ErrorMessagePanelSwingUi swingUi, WizardPanel panel) {
                this.swingUi = swingUi;
                this.paused = false;
                this.stopped = false;
            }

            @Override
            public void run() {
                while (!this.stopped) {
                    if (!this.paused) {
                        this.swingUi.updateErrorMessage();
                    }
                    if (this.stopped) break;
                    try {
                        ValidatingThread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        ErrorManager.notifyDebug("Interrupted", e);
                    }
                }
            }

            public void pause() {
                this.paused = true;
            }

            public void finish() {
                this.paused = true;
                this.stopped = true;
            }

            public void play() {
                this.paused = false;
                this.stopped = false;
            }
        }
    }

    public static class ErrorMessagePanelUi
    extends WizardPanel.WizardPanelUi {
        protected ErrorMessagePanel component;

        public ErrorMessagePanelUi(ErrorMessagePanel component) {
            super(component);
            this.component = component;
        }

        @Override
        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new ErrorMessagePanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

