/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.util;

import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;

public class SubscriberWrapper
implements HttpResponse.BodySubscriber<String> {
    private final CountDownLatch latch;
    private final HttpResponse.BodySubscriber<String> subscriber;
    private Flow.Subscription subscription;

    public SubscriberWrapper(HttpResponse.BodySubscriber<String> subscriber, CountDownLatch latch) {
        this.subscriber = subscriber;
        this.latch = latch;
    }

    @Override
    public CompletionStage<String> getBody() {
        return this.subscriber.getBody();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
        this.subscription = subscription;
        this.latch.countDown();
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        this.subscriber.onNext((String)((Object)item));
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    public void cancel() {
        this.subscription.cancel();
    }
}

