/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import org.apache.maven.model.Resource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.VisibilityQueryDataFilter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.MavenSourcesImpl;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class OthersRootChildren
extends Children.Keys<SourceGroup> {
    private static final String FILTERED_RESOURCE = "org/netbeans/modules/maven/nodes/filteredResourceWarningBadge.png";
    private NbMavenProjectImpl project;
    private PropertyChangeListener changeListener;
    private boolean test;

    public OthersRootChildren(NbMavenProjectImpl prj, boolean testResource) {
        this.project = prj;
        this.test = testResource;
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName()) || "RESOURCES".equals(evt.getPropertyName())) {
                    OthersRootChildren.this.regenerateKeys();
                    OthersRootChildren.this.refresh();
                }
            }
        };
    }

    protected void addNotify() {
        super.addNotify();
        NbMavenProject.addPropertyChangeListener(this.project, this.changeListener);
        this.regenerateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        NbMavenProject.removePropertyChangeListener(this.project, this.changeListener);
        super.removeNotify();
    }

    private void regenerateKeys() {
        ArrayList<SourceGroup> list = new ArrayList<SourceGroup>();
        SourceGroup[] resgroup = this.getSourceGroups();
        HashSet<FileObject> files = new HashSet<FileObject>();
        for (int i = 0; i < resgroup.length; ++i) {
            list.add(resgroup[i]);
            files.add(resgroup[i].getRootFolder());
        }
        this.setKeys(list);
        ((OthersRootNode)this.getNode()).setFiles(files);
    }

    private SourceGroup[] getSourceGroups() {
        Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
        if (srcs == null) {
            throw new IllegalStateException("need Sources instance in lookup");
        }
        return srcs.getSourceGroups(this.test ? "TestResources" : "Resources");
    }

    void doRefresh() {
        for (SourceGroup sg : this.getSourceGroups()) {
            super.refreshKey((Object)sg);
        }
    }

    protected Node[] createNodes(SourceGroup grp) {
        Node[] toReturn = new Node[1];
        if (grp instanceof MavenSourcesImpl.OtherGroup) {
            DataFolder dobj = DataFolder.findFolder((FileObject)grp.getRootFolder());
            MavenSourcesImpl.OtherGroup resgrp = (MavenSourcesImpl.OtherGroup)grp;
            if (resgrp.getResource() != null && OthersRootNode.showAsPackages()) {
                Project owner = FileOwnerQuery.getOwner((FileObject)resgrp.getRootFolder());
                if (owner != null && owner.getProjectDirectory().equals(this.project.getProjectDirectory())) {
                    toReturn[0] = new OGFilterNode(PackageView.createPackageView((SourceGroup)grp), resgrp);
                } else {
                    Children childs = dobj.createNodeChildren((DataFilter)VisibilityQueryDataFilter.VISIBILITY_QUERY_FILTER);
                    toReturn[0] = new OGFilterNode(dobj.getNodeDelegate().cloneNode(), childs, resgrp);
                }
            } else {
                Children childs = dobj.createNodeChildren((DataFilter)VisibilityQueryDataFilter.VISIBILITY_QUERY_FILTER);
                toReturn[0] = new OGFilterNode(dobj.getNodeDelegate().cloneNode(), childs, resgrp);
            }
        } else assert (false) : "Group is not a MavenSourcesImpl.OtherGroup instance";
        return toReturn;
    }

    private static class OGFilterNode
    extends FilterNode {
        private final MavenSourcesImpl.OtherGroup group;

        OGFilterNode(Node orig, MavenSourcesImpl.OtherGroup grp) {
            super(orig);
            this.group = grp;
        }

        OGFilterNode(Node orig, Children childs, MavenSourcesImpl.OtherGroup grp) {
            super(orig, childs);
            this.group = grp;
        }

        public String getShortDescription() {
            if (this.group.getResource() != null) {
                Resource rs = this.group.getResource();
                String str = Bundle.TIP_Resource1(rs.getDirectory());
                if (rs.getTargetPath() != null) {
                    str = str + Bundle.TIP_Resource2(rs.getTargetPath());
                }
                if (rs.isFiltering()) {
                    str = str + Bundle.TIP_Resource6(rs.isFiltering());
                }
                if (rs.getIncludes() != null && rs.getIncludes().size() > 0) {
                    str = str + Bundle.TIP_Resource3(Arrays.toString(rs.getIncludes().toArray()));
                }
                if (rs.getExcludes() != null && rs.getExcludes().size() > 0) {
                    str = str + Bundle.TIP_Resource4(Arrays.toString(rs.getExcludes().toArray()));
                }
                return str;
            }
            return Bundle.TIP_Resource5(FileUtil.getFileDisplayName((FileObject)this.group.getRootFolder()));
        }

        public String getDisplayName() {
            if (this.group.getResource() != null) {
                return this.group.getDisplayName();
            }
            return super.getDisplayName();
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Image computeIcon(boolean opened, int type) {
            if (this.group.getResource() != null) {
                Icon icon = this.group.getIcon(opened);
                Image img = ImageUtilities.icon2Image((Icon)icon);
                if (this.group.getResource().isFiltering()) {
                    Image warn = ImageUtilities.loadImage((String)OthersRootChildren.FILTERED_RESOURCE);
                    img = ImageUtilities.mergeImages((Image)img, (Image)warn, (int)0, (int)8);
                }
                return img;
            }
            return super.getIcon(type);
        }
    }
}

