/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.util;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLTypeUtil {
    public static String getString(String key) {
        return ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString(key);
    }

    public static String getSqlTypeString(int sqlType) {
        switch (sqlType) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case -15: {
                return "NCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
        }
        Logger.getLogger(SQLTypeUtil.class.getName()).log(Level.WARNING, "Unknown JDBC column type: {0}. Returns null.", sqlType);
        return "UNKNOWN";
    }

    public static boolean isNumeric(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacter(int type) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlob(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLob(int type) {
        return SQLTypeUtil.isBlob(type) || 2005 == type || -1 == type;
    }

    public static boolean isCompatibleType(int type1, int type2) {
        return type1 == type2 || SQLTypeUtil.isCharacter(type1) && SQLTypeUtil.isCharacter(type2) || SQLTypeUtil.isNumeric(type1) && SQLTypeUtil.isNumeric(type2) || SQLTypeUtil.isBlob(type1) && SQLTypeUtil.isBlob(type2);
    }
}

