/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.netbeans.modules.gradle.tooling.BaseModel;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;

public class NbProjectInfoModel
extends BaseModel
implements NbProjectInfo {
    private final Map<String, Object> info = new HashMap<String, Object>();
    private final Map<String, Object> ext = new HashMap<String, Object>();
    private final Set<String> problems = new LinkedHashSet<String>();
    private final Set<NbProjectInfo.Report> reports = new LinkedHashSet<NbProjectInfo.Report>();
    private boolean miscOnly = false;

    public NbProjectInfoModel() {
        this.ext.put("perf", new LinkedHashMap());
    }

    @Override
    public Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    public Map<String, Object> getExt() {
        return this.ext;
    }

    @Override
    public Set<String> getProblems() {
        return this.problems;
    }

    @Override
    public Set<NbProjectInfo.Report> getReports() {
        return this.reports;
    }

    void noteProblem(String s) {
        this.problems.add(s);
    }

    void noteProblem(Throwable e) {
        if (e instanceof MultiCauseException && !(e instanceof ModuleVersionResolveException)) {
            MultiCauseException mce = (MultiCauseException)e;
            for (Throwable t : mce.getCauses()) {
                ReportImpl r = this.createReport(t, false);
                if (r == null) continue;
                ReportImpl outer = this.createReport(e, true);
                outer.addCause(r);
                this.reports.add(outer);
            }
        } else {
            ReportImpl r = this.createReport(e, false);
            if (r != null) {
                this.reports.add(r);
            }
        }
    }

    private ReportImpl createReport(Throwable e, boolean shallow) {
        ReportImpl nested;
        ReportImpl report;
        if (e == null) {
            return null;
        }
        Throwable reported = e;
        if (e instanceof LocationAwareException) {
            LocationAwareException lae = (LocationAwareException)e;
            reported = lae.getCause();
            report = new ReportImpl(reported.getClass().getName(), lae.getLocation(), lae.getLineNumber(), reported.getMessage());
        } else {
            report = new ReportImpl(reported.getClass().getName(), null, -1, e.getMessage());
            reported = e;
        }
        if (shallow) {
            return report;
        }
        if (e.getCause() != null && e.getCause() != reported && (nested = this.createReport(e.getCause(), false)) != null) {
            report.addCause(nested);
        }
        return report;
    }

    public void setMiscOnly(boolean miscOnly) {
        this.miscOnly = miscOnly;
    }

    @Override
    public boolean getMiscOnly() {
        return this.miscOnly;
    }

    public void registerPerf(String name, Object runtime) {
        ((LinkedHashMap)this.ext.get("perf")).put(name, runtime);
    }

    static class ReportImpl
    implements Serializable,
    NbProjectInfo.Report {
        private final String errorClass;
        private final String scriptLocation;
        private final int lineNumber;
        private final String message;
        private NbProjectInfo.Report cause;

        public ReportImpl(String errorClass, String scriptLocation, int lineNumber, String message) {
            this.errorClass = errorClass;
            this.scriptLocation = scriptLocation;
            this.lineNumber = lineNumber;
            this.message = message;
        }

        @Override
        public String getErrorClass() {
            return this.errorClass;
        }

        @Override
        public String getScriptLocation() {
            return this.scriptLocation;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void addCause(NbProjectInfo.Report cause) {
            this.cause = cause;
        }

        @Override
        public NbProjectInfo.Report getCause() {
            return this.cause;
        }
    }
}

