/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import java.util.HashMap;
import javax.faces.FacesException;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.impl.AllExpressionResolver;
import org.primefaces.expression.impl.ChildExpressionResolver;
import org.primefaces.expression.impl.CompositeExpressionResolver;
import org.primefaces.expression.impl.FormExpressionResolver;
import org.primefaces.expression.impl.IdExpressionResolver;
import org.primefaces.expression.impl.NamingContainerExpressionResolver;
import org.primefaces.expression.impl.NextExpressionResolver;
import org.primefaces.expression.impl.ParentExpressionResolver;
import org.primefaces.expression.impl.PreviousExpressionResolver;
import org.primefaces.expression.impl.ThisExpressionResolver;

public class SearchExpressionResolverFactory {
    private static final HashMap<String, SearchExpressionResolver> RESOLVER_MAPPING = new HashMap();
    private static final IdExpressionResolver ID_EXPRESSION_RESOLVER = new IdExpressionResolver();

    public static SearchExpressionResolver findResolver(String expression) {
        SearchExpressionResolver resolver = null;
        if (expression.startsWith("@")) {
            int parenthesisPosition = expression.indexOf(40);
            if (parenthesisPosition > 0) {
                String expressionWithoutParam = expression.substring(0, parenthesisPosition);
                resolver = RESOLVER_MAPPING.get(expressionWithoutParam);
            } else {
                resolver = RESOLVER_MAPPING.get(expression);
            }
        } else {
            resolver = ID_EXPRESSION_RESOLVER;
        }
        if (resolver == null) {
            throw new FacesException("No SearchExpressionResolver available for expression \"" + expression + "\"");
        }
        return resolver;
    }

    public static void registerResolver(String keyword, SearchExpressionResolver resolver) {
        RESOLVER_MAPPING.put(keyword, resolver);
    }

    public static SearchExpressionResolver removeResolver(String keyword) {
        return RESOLVER_MAPPING.remove(keyword);
    }

    private SearchExpressionResolverFactory() {
    }

    static {
        RESOLVER_MAPPING.put("@this", new ThisExpressionResolver());
        RESOLVER_MAPPING.put("@composite", new CompositeExpressionResolver());
        RESOLVER_MAPPING.put("@parent", new ParentExpressionResolver());
        RESOLVER_MAPPING.put("@form", new FormExpressionResolver());
        RESOLVER_MAPPING.put("@all", new AllExpressionResolver());
        RESOLVER_MAPPING.put("@namingcontainer", new NamingContainerExpressionResolver());
        RESOLVER_MAPPING.put("@none", new NamingContainerExpressionResolver());
        RESOLVER_MAPPING.put("@next", new NextExpressionResolver());
        RESOLVER_MAPPING.put("@previous", new PreviousExpressionResolver());
        RESOLVER_MAPPING.put("@child", new ChildExpressionResolver());
    }
}

