/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.j2ee.persistence.dd.common.JPAParseUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.openide.filesystems.FileObject;

public final class PersistenceMetadata {
    private static final PersistenceMetadata DEFAULT = new PersistenceMetadata();
    private Map<FileObject, Persistence> ddMap = new WeakHashMap<FileObject, Persistence>(5);

    private PersistenceMetadata() {
    }

    public static PersistenceMetadata getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistence getRoot(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        Persistence persistence = null;
        Map<FileObject, Persistence> map = this.ddMap;
        synchronized (map) {
            persistence = this.ddMap.get(fo);
            if (persistence == null) {
                String version = "1.0";
                try (InputStream is = fo.getInputStream();){
                    version = JPAParseUtils.getVersion(is);
                }
                is = fo.getInputStream();
                try {
                    persistence = "2.1".equals(version) ? org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.Persistence.createGraph(is) : ("2.0".equals(version) ? org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence.createGraph(is) : org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence.createGraph(is));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                this.ddMap.put(fo, persistence);
            }
        }
        return persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileObject fo) {
        Map<FileObject, Persistence> map = this.ddMap;
        synchronized (map) {
            if (fo != null) {
                this.ddMap.remove(fo);
            }
        }
    }
}

