/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class GradleCliCompletionProvider
implements CompletionProvider {
    private static final Pattern PROP_INPUT = Pattern.compile("\\$\\{([\\w.]*)$");
    private static final String INPUT_TOKEN = "input:";
    private static final Set<GradleCommandLine.GradleOptionItem> GRADLE_OPTIONS;

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                String filter = null;
                int startOffset = caretOffset - 1;
                try {
                    StyledDocument bDoc = (StyledDocument)doc;
                    int lineStartOffset = GradleCliCompletionProvider.getRowFirstNonWhite(bDoc, caretOffset);
                    char[] line = bDoc.getText(lineStartOffset, caretOffset - lineStartOffset).toCharArray();
                    int whiteOffset = GradleCliCompletionProvider.indexOfWhite(line);
                    filter = new String(line, whiteOffset + 1, line.length - whiteOffset - 1);
                    startOffset = whiteOffset > 0 ? lineStartOffset + whiteOffset + 1 : lineStartOffset;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                Project project = null;
                Object prop = doc.getProperty("stream");
                if (prop != null && prop instanceof Project) {
                    project = (Project)prop;
                }
                Matcher tokenMatcher = PROP_INPUT.matcher(filter);
                boolean tokenInFilter = tokenMatcher.find();
                try {
                    GradleCommandLine cli = new GradleCommandLine((CharSequence)doc.getText(0, doc.getLength()));
                    if (!filter.startsWith("-") && !tokenInFilter && project != null) {
                        GradleBaseProject gbp = GradleBaseProject.get(project);
                        for (GradleTask gradleTask : gbp.getTasks()) {
                            if (gradleTask.isPrivate() || cli.getTasks().contains(gradleTask.getName()) || cli.getExcludedTasks().contains(gradleTask.getName()) || !gradleTask.getName().startsWith(filter) && !gradleTask.matches(filter)) continue;
                            resultSet.addItem((CompletionItem)new GradleTaskCompletionItem(gradleTask, startOffset, caretOffset));
                        }
                    }
                    if (filter.isEmpty() || filter.startsWith("-")) {
                        for (GradleCommandLine.GradleOptionItem item : GRADLE_OPTIONS) {
                            if (!cli.canAdd(item)) continue;
                            for (String f : item.getFlags()) {
                                if (!f.startsWith(filter)) continue;
                                resultSet.addItem((CompletionItem)new GradleOptionCompletionItem(item, f, startOffset, caretOffset));
                            }
                        }
                    }
                }
                catch (BadLocationException cli) {
                    // empty catch block
                }
                if (tokenInFilter && project != null) {
                    String propFilter = tokenMatcher.group(1);
                    ReplaceTokenProvider tokenProvider = (ReplaceTokenProvider)project.getLookup().lookup(ReplaceTokenProvider.class);
                    for (String string : tokenProvider.getSupportedTokens()) {
                        if (!string.startsWith(propFilter)) continue;
                        resultSet.addItem((CompletionItem)new TokenCompletionItem(string, startOffset + tokenMatcher.start(1), caretOffset));
                    }
                    if (GradleCliCompletionProvider.INPUT_TOKEN.startsWith(propFilter)) {
                        resultSet.addItem((CompletionItem)new TokenCompletionItem(GradleCliCompletionProvider.INPUT_TOKEN, startOffset + tokenMatcher.start(1), caretOffset));
                    }
                }
                resultSet.finish();
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }

    static int getRowFirstNonWhite(StyledDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        int start = lineElement.getStartOffset();
        while (start + 1 < lineElement.getEndOffset()) {
            try {
                if (doc.getText(start, 1).charAt(0) != ' ') {
                    break;
                }
            }
            catch (BadLocationException ex) {
                throw (BadLocationException)new BadLocationException("calling getText(" + start + ", " + (start + 1) + ") on doc of length: " + doc.getLength(), start).initCause(ex);
            }
            ++start;
        }
        return start;
    }

    static int indexOfWhite(char[] line) {
        int i = line.length;
        while (--i > -1) {
            char c = line[i];
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    static {
        HashSet<Enum> all = new HashSet<Enum>();
        GRADLE_OPTIONS = Collections.unmodifiableSet(all);
        all.addAll(Arrays.asList(GradleCommandLine.Flag.values()));
        all.addAll(Arrays.asList(GradleCommandLine.Parameter.values()));
        all.addAll(Arrays.asList(GradleCommandLine.Property.values()));
    }

    private static class TokenCompletionItem
    extends AbstractGradleCompletionItem {
        final String token;

        public TokenCompletionItem(String token, int startOffset, int caretOffset) {
            super(startOffset, caretOffset);
            this.token = token;
        }

        @Override
        protected String getValue() {
            return this.token;
        }
    }

    private static class GradleOptionCompletionItem
    extends AbstractGradleCompletionItem {
        private final GradleCommandLine.GradleOptionItem item;
        private final String value;

        public GradleOptionCompletionItem(GradleCommandLine.GradleOptionItem item, String value, int startOffset, int caretOffset) {
            super(startOffset, caretOffset);
            this.item = item;
            this.value = value;
        }

        @Override
        public int getSortPriority() {
            return this.value.startsWith("--") ? 5 : 4;
        }

        @Override
        protected String getValue() {
            return this.value;
        }

        @Override
        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            HashMap attributes = new HashMap(defaultFont.getAttributes());
            if (!this.item.isSupported()) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            Font font = new Font(attributes);
            CompletionUtilities.renderHtml(null, (String)this.getValue(), null, (Graphics)g, (Font)font, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    resultSet.setDocumentation((CompletionDocumentation)new GradleItemCompletionDocumentation());
                    resultSet.finish();
                }
            });
        }

        private class GradleItemCompletionDocumentation
        implements CompletionDocumentation {
            private GradleItemCompletionDocumentation() {
            }

            public String getText() {
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                if (!GradleOptionCompletionItem.this.item.isSupported()) {
                    sb.append("<b>Unsupported:</b> This argument will be ignored");
                }
                sb.append(GradleOptionCompletionItem.this.item.getDescription());
                return sb.toString();
            }

            public URL getURL() {
                return null;
            }

            public CompletionDocumentation resolveLink(String link) {
                return null;
            }

            public Action getGotoSourceAction() {
                return null;
            }
        }
    }

    private static class GradleTaskCompletionItem
    extends AbstractGradleCompletionItem {
        private static final String TASK_ICON = "org/netbeans/modules/gradle/resources/gradle-task.gif";
        private static final ImageIcon TASK_IMAGEICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gradle/resources/gradle-task.gif", (boolean)false);
        private final GradleTask task;

        public GradleTaskCompletionItem(GradleTask task, int startOffset, int caretOffset) {
            super(startOffset, caretOffset);
            this.task = task;
        }

        @Override
        public int getSortPriority() {
            switch (this.task.getGroup()) {
                case "application": {
                    return 0;
                }
                case "build": {
                    return 1;
                }
                case "distribution": {
                    return 2;
                }
            }
            return 3;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    resultSet.setDocumentation((CompletionDocumentation)new GradleTaskCompletionDocumentation());
                    resultSet.finish();
                }
            });
        }

        @Override
        protected String getValue() {
            return this.task.getName();
        }

        @Override
        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)TASK_IMAGEICON, (String)this.getValue(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        private class GradleTaskCompletionDocumentation
        implements CompletionDocumentation {
            private GradleTaskCompletionDocumentation() {
            }

            public String getText() {
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append("<b>Name:</b> ").append(GradleTaskCompletionItem.this.task.getName()).append("<br/>");
                sb.append("<b>Group:</b> ").append(GradleTaskCompletionItem.this.task.getGroup()).append("<br/>");
                sb.append("<b>Path:</b> ").append(GradleTaskCompletionItem.this.task.getPath()).append("<br/>");
                sb.append("<b>Description:</b><p>").append(GradleTaskCompletionItem.this.task.getDescription());
                return sb.toString();
            }

            public URL getURL() {
                return null;
            }

            public CompletionDocumentation resolveLink(String link) {
                return null;
            }

            public Action getGotoSourceAction() {
                return null;
            }
        }
    }

    private static abstract class AbstractGradleCompletionItem
    implements CompletionItem {
        private final int startOffset;
        private final int caretOffset;

        public AbstractGradleCompletionItem(int startOffset, int caretOffset) {
            this.startOffset = startOffset;
            this.caretOffset = caretOffset;
        }

        protected abstract String getValue();

        public void defaultAction(JTextComponent jtc) {
            try {
                Document doc = jtc.getDocument();
                doc.remove(this.startOffset, this.caretOffset - this.startOffset);
                doc.insertString(this.startOffset, this.getValue(), null);
                Completion.get().hideAll();
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        public int getPreferredWidth(Graphics g, Font font) {
            return CompletionUtilities.getPreferredWidth((String)this.getValue(), null, (Graphics)g, (Font)font);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml(null, (String)this.getValue(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return Integer.MAX_VALUE;
        }

        public CharSequence getSortText() {
            return this.getValue();
        }

        public CharSequence getInsertPrefix() {
            return this.getValue();
        }
    }
}

