/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.storage.CommonStore;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.osgi.util.NLS;

class CommonStorable
implements ICommonStorable {
    private final File path;
    private final CommonStore store;

    public CommonStorable(CommonStore store, File path) {
        this.store = store;
        this.path = path;
    }

    @Override
    public void delete(String item) throws CoreException {
        this.getFile(item).delete();
    }

    @Override
    public void deleteAll() throws CoreException {
        File[] children = this.path.listFiles();
        if (children != null) {
            File child;
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                child = fileArray[n2];
                if (child.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", NLS.bind((String)"The storage location ''{0}'' contains sub directories", (Object)this.path)));
                }
                ++n2;
            }
            fileArray = children;
            n = children.length;
            n2 = 0;
            while (n2 < n) {
                child = fileArray[n2];
                child.delete();
                ++n2;
            }
        }
        if (this.path.exists()) {
            this.path.delete();
        }
    }

    @Override
    public boolean exists(String handle) {
        if (!this.path.exists()) {
            return false;
        }
        return this.getFile(handle).exists();
    }

    public IStatus flush() {
        return Status.OK_STATUS;
    }

    public File getPath() {
        return this.path;
    }

    public boolean isDirty() {
        return false;
    }

    @Override
    public InputStream read(String item, IProgressMonitor monitor) throws IOException {
        File file = this.getFile(item);
        return new FileInputStream(file);
    }

    @Override
    public void release() {
        this.store.release(this);
    }

    @Override
    public OutputStream write(String item, IProgressMonitor monitor) throws IOException {
        File file = this.getFile(item);
        return new FileOutputStream(file);
    }

    private File getFile(String item) {
        File file = new File(this.path, item);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }
}

