/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.completion;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Completion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.java.completion.BaseTask;
import org.netbeans.modules.java.completion.Utilities;
import org.netbeans.modules.parsing.api.Source;
import org.openide.util.Pair;

public final class JavaCompletionTask<T>
extends BaseTask {
    private static final String ERROR = "<error>";
    private static final String INIT = "<init>";
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final String SEMI = ";";
    private static final String EMPTY = "";
    private static final String ABSTRACT_KEYWORD = "abstract";
    private static final String ASSERT_KEYWORD = "assert";
    private static final String BOOLEAN_KEYWORD = "boolean";
    private static final String BREAK_KEYWORD = "break";
    private static final String BYTE_KEYWORD = "byte";
    private static final String CASE_KEYWORD = "case";
    private static final String CATCH_KEYWORD = "catch";
    private static final String CHAR_KEYWORD = "char";
    private static final String CLASS_KEYWORD = "class";
    private static final String CONTINUE_KEYWORD = "continue";
    private static final String DEFAULT_KEYWORD = "default";
    private static final String DO_KEYWORD = "do";
    private static final String DOUBLE_KEYWORD = "double";
    private static final String ELSE_KEYWORD = "else";
    private static final String ENUM_KEYWORD = "enum";
    private static final String EXPORTS_KEYWORD = "exports";
    private static final String EXTENDS_KEYWORD = "extends";
    private static final String FALSE_KEYWORD = "false";
    private static final String FINAL_KEYWORD = "final";
    private static final String FINALLY_KEYWORD = "finally";
    private static final String FLOAT_KEYWORD = "float";
    private static final String FOR_KEYWORD = "for";
    private static final String IF_KEYWORD = "if";
    private static final String IMPLEMENTS_KEYWORD = "implements";
    private static final String IMPORT_KEYWORD = "import";
    private static final String INSTANCEOF_KEYWORD = "instanceof";
    private static final String INT_KEYWORD = "int";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final String LONG_KEYWORD = "long";
    private static final String MODULE_KEYWORD = "module";
    private static final String NATIVE_KEYWORD = "native";
    private static final String NEW_KEYWORD = "new";
    private static final String NON_SEALED_KEYWORD = "non-sealed";
    private static final String NULL_KEYWORD = "null";
    private static final String OPEN_KEYWORD = "open";
    private static final String OPENS_KEYWORD = "opens";
    private static final String PACKAGE_KEYWORD = "package";
    private static final String PERMITS_KEYWORD = "permits";
    private static final String PRIVATE_KEYWORD = "private";
    private static final String PROTECTED_KEYWORD = "protected";
    private static final String PROVIDES_KEYWORD = "provides";
    private static final String PUBLIC_KEYWORD = "public";
    private static final String RETURN_KEYWORD = "return";
    private static final String REQUIRES_KEYWORD = "requires";
    private static final String SEALED_KEYWORD = "sealed";
    private static final String SHORT_KEYWORD = "short";
    private static final String STATIC_KEYWORD = "static";
    private static final String STRICT_KEYWORD = "strictfp";
    private static final String SUPER_KEYWORD = "super";
    private static final String SWITCH_KEYWORD = "switch";
    private static final String SYNCHRONIZED_KEYWORD = "synchronized";
    private static final String THIS_KEYWORD = "this";
    private static final String THROW_KEYWORD = "throw";
    private static final String THROWS_KEYWORD = "throws";
    private static final String TO_KEYWORD = "to";
    private static final String TRANSIENT_KEYWORD = "transient";
    private static final String TRANSITIVE_KEYWORD = "transitive";
    private static final String TRUE_KEYWORD = "true";
    private static final String TRY_KEYWORD = "try";
    private static final String USES_KEYWORD = "uses";
    private static final String VAR_KEYWORD = "var";
    private static final String VOID_KEYWORD = "void";
    private static final String VOLATILE_KEYWORD = "volatile";
    private static final String WHILE_KEYWORD = "while";
    private static final String WITH_KEYWORD = "with";
    private static final String YIELD_KEYWORD = "yield";
    private static final String RECORD_KEYWORD = "record";
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_ITERABLE = "java.lang.Iterable";
    private static final String[] PRIM_KEYWORDS = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    private static final String[] STATEMENT_KEYWORDS = new String[]{"do", "if", "for", "switch", "synchronized", "try", "void", "while"};
    private static final String[] STATEMENT_SPACE_KEYWORDS = new String[]{"assert", "new", "throw"};
    private static final String[] BLOCK_KEYWORDS = new String[]{"assert", "class", "final", "new", "strictfp", "throw"};
    private static final String[] MODULE_BODY_KEYWORDS = new String[]{"exports", "opens", "requires", "provides", "uses"};
    private static final String[] CLASS_BODY_KEYWORDS = new String[]{"abstract", "class", "enum", "final", "interface", "native", "private", "protected", "public", "static", "strictfp", "synchronized", "transient", "void", "volatile"};
    private final ItemFactory<T> itemFactory;
    private final Set<Options> options;
    private ArrayList<T> results;
    private boolean hasAdditionalClasses;
    private boolean hasAdditionalMembers;
    private int anchorOffset;

    public static <I> JavaCompletionTask<I> create(int caretOffset, @NonNull ItemFactory<I> factory, @NonNull Set<Options> options, @NullAllowed Callable<Boolean> cancel) {
        return new JavaCompletionTask<I>(caretOffset, factory, cancel, options);
    }

    private JavaCompletionTask(int caretOffset, ItemFactory<T> factory, Callable<Boolean> cancel, Set<Options> options) {
        super(caretOffset, cancel);
        this.itemFactory = factory;
        this.options = options;
    }

    public List<T> getResults() {
        return this.results;
    }

    public boolean hasAdditionalClasses() {
        return this.hasAdditionalClasses;
    }

    public boolean hasAdditionalMembers() {
        return this.hasAdditionalMembers;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    @Override
    protected void resolve(CompilationController controller) throws IOException {
        BaseTask.Env env = this.getCompletionEnvironment(controller, true);
        if (env == null) {
            return;
        }
        if (this.options.contains((Object)Options.SKIP_ACCESSIBILITY_CHECK)) {
            env.skipAccessibilityCheck();
        }
        this.results = new ArrayList();
        this.anchorOffset = controller.getSnapshot().getOriginalOffset(env.getOffset());
        TreePath path = env.getPath();
        switch (path.getLeaf().getKind()) {
            case COMPILATION_UNIT: {
                this.insideCompilationUnit(env);
                break;
            }
            case MODULE: {
                this.insideModule(env);
                break;
            }
            case EXPORTS: {
                this.insideExports(env);
                break;
            }
            case OPENS: {
                this.insideOpens(env);
                break;
            }
            case PROVIDES: {
                this.insideProvides(env);
                break;
            }
            case REQUIRES: {
                this.insideRequires(env);
                break;
            }
            case USES: {
                this.insideUses(env);
                break;
            }
            case PACKAGE: {
                this.insidePackage(env);
                break;
            }
            case IMPORT: {
                this.insideImport(env);
                break;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                this.insideClass(env);
                break;
            }
            case VARIABLE: {
                this.insideVariable(env);
                break;
            }
            case METHOD: {
                this.insideMethod(env);
                break;
            }
            case MODIFIERS: {
                this.insideModifiers(env, path);
                break;
            }
            case ANNOTATION: 
            case TYPE_ANNOTATION: {
                this.insideAnnotation(env);
                break;
            }
            case ANNOTATED_TYPE: {
                this.insideAnnotatedType(env);
                break;
            }
            case TYPE_PARAMETER: {
                this.insideTypeParameter(env);
                break;
            }
            case PARAMETERIZED_TYPE: {
                this.insideParameterizedType(env, path);
                break;
            }
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                TreePath parentPath = path.getParentPath();
                if (parentPath.getLeaf().getKind() != Tree.Kind.PARAMETERIZED_TYPE) break;
                this.insideParameterizedType(env, parentPath);
                break;
            }
            case BLOCK: {
                this.insideBlock(env);
                break;
            }
            case MEMBER_SELECT: {
                this.insideMemberSelect(env);
                break;
            }
            case MEMBER_REFERENCE: {
                this.insideMemberReference(env);
                break;
            }
            case LAMBDA_EXPRESSION: {
                this.insideLambdaExpression(env);
                break;
            }
            case METHOD_INVOCATION: {
                this.insideMethodInvocation(env);
                break;
            }
            case NEW_CLASS: {
                this.insideNewClass(env);
                break;
            }
            case ASSERT: 
            case RETURN: 
            case THROW: {
                this.localResult(env);
                this.addValueKeywords(env);
                break;
            }
            case TRY: {
                this.insideTry(env);
                break;
            }
            case CATCH: {
                this.insideCatch(env);
                break;
            }
            case UNION_TYPE: {
                this.insideUnionType(env);
                break;
            }
            case IF: {
                this.insideIf(env);
                break;
            }
            case WHILE_LOOP: {
                this.insideWhile(env);
                break;
            }
            case DO_WHILE_LOOP: {
                this.insideDoWhile(env);
                break;
            }
            case FOR_LOOP: {
                this.insideFor(env);
                break;
            }
            case ENHANCED_FOR_LOOP: {
                this.insideForEach(env);
                break;
            }
            case SWITCH: {
                this.insideSwitch(env);
                break;
            }
            case CASE: {
                this.insideCase(env);
                break;
            }
            case LABELED_STATEMENT: {
                this.localResult(env);
                this.addKeywordsForStatement(env);
                break;
            }
            case PARENTHESIZED: {
                this.insideParens(env);
                break;
            }
            case TYPE_CAST: {
                this.insideExpression(env, path);
                break;
            }
            case INSTANCE_OF: {
                this.insideTypeCheck(env);
                break;
            }
            case ARRAY_ACCESS: {
                this.insideArrayAccess(env);
                break;
            }
            case NEW_ARRAY: {
                this.insideNewArray(env);
                break;
            }
            case ASSIGNMENT: {
                this.insideAssignment(env);
                break;
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                this.insideCompoundAssignment(env);
                break;
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                this.localResult(env);
                break;
            }
            case AND: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                this.insideBinaryTree(env);
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.insideConditionalExpression(env);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.insideExpressionStatement(env);
                break;
            }
            case BREAK: 
            case CONTINUE: {
                this.insideBreakOrContinue(env);
                break;
            }
            case STRING_LITERAL: {
                this.insideStringLiteral(env);
                break;
            }
            case SWITCH_EXPRESSION: {
                this.insideSwitch(env);
                break;
            }
            case RECORD: {
                this.insideRecord(env);
                break;
            }
            case DEFAULT_CASE_LABEL: {
                this.localResult(env);
                this.addKeywordsForBlock(env);
            }
        }
    }

    private void insideCompilationUnit(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        ExpressionTree pkg = root.getPackageName();
        if (pkg == null || (long)offset <= sourcePositions.getStartPosition(root, root)) {
            this.addKeywordsForCU(env);
            return;
        }
        if ((long)offset <= sourcePositions.getStartPosition(root, pkg)) {
            this.addPackages(env, null, true);
        } else {
            TokenSequence<JavaTokenId> first = this.findFirstNonWhitespaceToken(env, (int)sourcePositions.getEndPosition(root, pkg), offset);
            if (first != null && first.token().id() == JavaTokenId.SEMICOLON) {
                this.addKeywordsForCU(env);
            }
        }
    }

    private void insideModule(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        TreePath path = env.getPath();
        CompilationController controller = env.getController();
        int startPos = (int)env.getSourcePositions().getStartPosition(env.getRoot(), path.getLeaf());
        String headerText = controller.getText().substring(startPos, offset);
        int idx = headerText.indexOf(123);
        if (idx >= 0) {
            this.addKeywordsForModuleBody(env);
        } else if (!headerText.contains(MODULE_KEYWORD)) {
            this.addKeyword(env, MODULE_KEYWORD, SPACE, false);
        }
    }

    private void insideExports(BaseTask.Env env) throws IOException {
        int extPos;
        ExpressionTree name;
        TokenSequence<JavaTokenId> last;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        ExportsTree exp = (ExportsTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        if (exp.getModuleNames() != null) {
            Tree mdl;
            int implPos;
            int startPos = (int)sourcePositions.getStartPosition(root, exp);
            Tree lastModule = null;
            Iterator<? extends ExpressionTree> iterator = exp.getModuleNames().iterator();
            while (iterator.hasNext() && (long)(implPos = (int)sourcePositions.getEndPosition(root, mdl = (Tree)iterator.next())) != -1L && offset > implPos) {
                lastModule = mdl;
                startPos = implPos;
            }
            if (lastModule != null) {
                last = this.findLastNonWhitespaceToken(env, startPos, offset);
                if (last != null && last.token().id() == JavaTokenId.COMMA) {
                    this.addModuleNames(env, null, true);
                }
                return;
            }
        }
        if ((name = exp.getPackageName()) != null && (long)(extPos = (int)sourcePositions.getEndPosition(root, name)) != -1L && offset > extPos) {
            last = this.findLastNonWhitespaceToken(env, extPos + 1, offset);
            if (last != null && last.token().id() == JavaTokenId.TO) {
                this.addModuleNames(env, null, true);
            } else {
                this.addKeyword(env, TO_KEYWORD, SPACE, false);
            }
            return;
        }
        this.addPackages(env, null, true);
    }

    private void insideOpens(BaseTask.Env env) throws IOException {
        int extPos;
        ExpressionTree name;
        TokenSequence<JavaTokenId> last;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        OpensTree op = (OpensTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        if (op.getModuleNames() != null) {
            Tree mdl;
            int implPos;
            int startPos = (int)sourcePositions.getStartPosition(root, op);
            Tree lastModule = null;
            Iterator<? extends ExpressionTree> iterator = op.getModuleNames().iterator();
            while (iterator.hasNext() && (long)(implPos = (int)sourcePositions.getEndPosition(root, mdl = (Tree)iterator.next())) != -1L && offset > implPos) {
                lastModule = mdl;
                startPos = implPos;
            }
            if (lastModule != null) {
                last = this.findLastNonWhitespaceToken(env, startPos, offset);
                if (last != null && last.token().id() == JavaTokenId.COMMA) {
                    this.addModuleNames(env, null, true);
                }
                return;
            }
        }
        if ((name = op.getPackageName()) != null && (long)(extPos = (int)sourcePositions.getEndPosition(root, name)) != -1L && offset > extPos) {
            last = this.findLastNonWhitespaceToken(env, extPos + 1, offset);
            if (last != null && last.token().id() == JavaTokenId.TO) {
                this.addModuleNames(env, null, true);
            } else {
                this.addKeyword(env, TO_KEYWORD, SPACE, false);
            }
            return;
        }
        this.addPackages(env, null, true);
    }

    private void insideProvides(BaseTask.Env env) throws IOException {
        int extPos;
        ExpressionTree serv;
        TokenSequence<JavaTokenId> last;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        ProvidesTree prov = (ProvidesTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        if (prov.getImplementationNames() != null) {
            Tree impl;
            int implPos;
            int startPos = (int)sourcePositions.getStartPosition(root, prov);
            Tree lastImpl = null;
            Iterator<? extends ExpressionTree> iterator = prov.getImplementationNames().iterator();
            while (iterator.hasNext() && (long)(implPos = (int)sourcePositions.getEndPosition(root, impl = (Tree)iterator.next())) != -1L && offset > implPos) {
                lastImpl = impl;
                startPos = implPos;
            }
            if (lastImpl != null && (last = this.findLastNonWhitespaceToken(env, startPos, offset)) != null && last.token().id() != JavaTokenId.COMMA) {
                return;
            }
        }
        if ((serv = prov.getServiceName()) != null && (long)(extPos = (int)sourcePositions.getEndPosition(root, serv)) != -1L && offset > extPos) {
            last = this.findLastNonWhitespaceToken(env, extPos + 1, offset);
            if (last != null && last.token().id() == JavaTokenId.WITH) {
                CompilationController cc = env.getController();
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Element el = cc.getTrees().getElement(new TreePath(path, serv));
                this.options.add(Options.ALL_COMPLETION);
                this.addTypes(env, EnumSet.of(ElementKind.CLASS), el != null && el.getKind().isInterface() ? (DeclaredType)el.asType() : null);
            } else {
                this.addKeyword(env, WITH_KEYWORD, SPACE, false);
            }
            return;
        }
        this.options.add(Options.ALL_COMPLETION);
        this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.INTERFACE), null);
    }

    private void insideRequires(BaseTask.Env env) throws IOException {
        int extPos;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        RequiresTree req = (RequiresTree)path.getLeaf();
        ExpressionTree name = req.getModuleName();
        if (name != null && (long)(extPos = (int)env.getSourcePositions().getEndPosition(env.getRoot(), name)) != -1L && offset > extPos) {
            return;
        }
        if (!req.isStatic()) {
            this.addKeyword(env, STATIC_KEYWORD, SPACE, false);
        }
        if (!req.isTransitive()) {
            this.addKeyword(env, TRANSITIVE_KEYWORD, SPACE, false);
        }
        this.addModuleNames(env, null, false);
    }

    private void insideUses(BaseTask.Env env) throws IOException {
        int extPos;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        UsesTree uses = (UsesTree)path.getLeaf();
        ExpressionTree name = uses.getServiceName();
        if (name != null && (long)(extPos = (int)env.getSourcePositions().getEndPosition(env.getRoot(), name)) != -1L && offset > extPos) {
            return;
        }
        this.options.add(Options.ALL_COMPLETION);
        this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.INTERFACE), null);
    }

    private void insidePackage(BaseTask.Env env) {
        int offset = env.getOffset();
        PackageTree pt = (PackageTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        if ((long)offset <= sourcePositions.getStartPosition(env.getRoot(), pt.getPackageName())) {
            this.addPackages(env, null, true);
        }
    }

    private void insideImport(BaseTask.Env env) throws IOException {
        env.getController().toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = env.getOffset();
        String prefix = env.getPrefix();
        ImportTree im = (ImportTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        if ((long)offset <= sourcePositions.getStartPosition(root, im.getQualifiedIdentifier())) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, im, offset);
            if (last != null && last.token().id() == JavaTokenId.IMPORT && Utilities.startsWith(STATIC_KEYWORD, prefix)) {
                this.addKeyword(env, STATIC_KEYWORD, SPACE, false);
            }
            if (this.options.contains((Object)Options.ALL_COMPLETION) || this.options.contains((Object)Options.COMBINED_COMPLETION)) {
                EnumSet<ElementKind> classKinds = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
                if (this.isRecordSupported(env)) {
                    classKinds.add(ElementKind.RECORD);
                }
                this.addTypes(env, classKinds, null);
            } else {
                this.addPackages(env, null, false);
            }
        }
    }

    private void insideClass(BaseTask.Env env) throws IOException {
        TypeParameterTree tp;
        int tpPos;
        int extPos;
        Tree impl;
        int implPos;
        Object perm;
        int permPos;
        String headerText;
        int idx;
        int offset = env.getOffset();
        env.insideClass();
        TreePath path = env.getPath();
        ClassTree cls = (ClassTree)path.getLeaf();
        CompilationController controller = env.getController();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        int startPos = (int)sourcePositions.getEndPosition(root, cls.getModifiers());
        if (startPos <= 0) {
            startPos = (int)sourcePositions.getStartPosition(root, cls);
        }
        if ((idx = (headerText = controller.getText().substring(startPos, offset)).indexOf(123)) >= 0) {
            this.addKeywordsForClassBody(env);
            this.addClassTypes(env, null);
            this.addElementCreators(env);
            return;
        }
        TreeUtilities tu = controller.getTreeUtilities();
        Object lastPerm = null;
        ArrayList permits = cls.getPermitsClause();
        permits = permits == null ? new ArrayList() : permits;
        Iterator iterator = permits.iterator();
        while (iterator.hasNext() && (long)(permPos = (int)sourcePositions.getEndPosition(root, (Tree)(perm = (Tree)iterator.next()))) != -1L && offset > permPos) {
            lastPerm = perm;
            startPos = permPos;
        }
        if (lastPerm != null) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, startPos, offset);
            if (last != null && last.token().id() == JavaTokenId.COMMA) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addClassTypes(env, null);
            }
            return;
        }
        Tree lastImpl = null;
        perm = cls.getImplementsClause().iterator();
        while (perm.hasNext() && (long)(implPos = (int)sourcePositions.getEndPosition(root, impl = (Tree)perm.next())) != -1L && offset > implPos) {
            lastImpl = impl;
            startPos = implPos;
        }
        if (lastImpl != null) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, startPos, offset);
            if (last != null && last.token().id() == JavaTokenId.COMMA) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
            } else if (this.isSealedSupported(env) && last != null && TokenUtilities.textEquals((CharSequence)last.token().text(), (CharSequence)PERMITS_KEYWORD)) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addClassTypes(env, null);
            } else if (this.isSealedSupported(env)) {
                this.addKeyword(env, PERMITS_KEYWORD, SPACE, false);
            }
            return;
        }
        Tree ext = cls.getExtendsClause();
        if (ext != null && (long)(extPos = (int)sourcePositions.getEndPosition(root, ext)) != -1L && offset > extPos) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, extPos + 1, offset);
            if (last != null && last.token().id() == JavaTokenId.IMPLEMENTS) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
            } else if (this.isSealedSupported(env) && last != null && TokenUtilities.textEquals((CharSequence)last.token().text(), (CharSequence)PERMITS_KEYWORD)) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addClassTypes(env, null);
            } else {
                this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                if (this.isSealedSupported(env)) {
                    this.addKeyword(env, PERMITS_KEYWORD, SPACE, false);
                }
            }
            return;
        }
        TypeParameterTree lastTypeParam = null;
        Iterator<? extends TypeParameterTree> last = cls.getTypeParameters().iterator();
        while (last.hasNext() && (long)(tpPos = (int)sourcePositions.getEndPosition(root, tp = last.next())) != -1L && offset > tpPos) {
            lastTypeParam = tp;
            startPos = tpPos;
        }
        if (lastTypeParam != null) {
            TokenSequence<JavaTokenId> first = this.findFirstNonWhitespaceToken(env, startPos, offset);
            if (first != null && (first.token().id() == JavaTokenId.GT || first.token().id() == JavaTokenId.GTGT || first.token().id() == JavaTokenId.GTGTGT)) {
                if ((first = this.nextNonWhitespaceToken(first)) != null && first.offset() < offset) {
                    if (first.token().id() == JavaTokenId.EXTENDS) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.afterExtends();
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addTypes(env, tu.isInterface(cls) ? EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE) : EnumSet.of(ElementKind.CLASS), null);
                        return;
                    }
                    if (first.token().id() == JavaTokenId.IMPLEMENTS) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                        return;
                    }
                }
                if (!tu.isAnnotation(cls)) {
                    if (!tu.isEnum(cls)) {
                        this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                        if (this.isSealedSupported(env)) {
                            this.addKeyword(env, PERMITS_KEYWORD, SPACE, false);
                        }
                    }
                    if (!tu.isInterface(cls)) {
                        this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                    }
                }
            } else if (lastTypeParam.getBounds().isEmpty()) {
                this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
            }
            return;
        }
        TokenSequence<JavaTokenId> lastNonWhitespaceToken = this.findLastNonWhitespaceToken(env, startPos, offset);
        if (lastNonWhitespaceToken != null) {
            switch ((JavaTokenId)lastNonWhitespaceToken.token().id()) {
                case EXTENDS: {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    env.afterExtends();
                    env.addToExcludes(controller.getTrees().getElement(path));
                    this.addTypes(env, tu.isInterface(cls) ? EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE) : EnumSet.of(ElementKind.CLASS), null);
                    break;
                }
                case IMPLEMENTS: {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    env.addToExcludes(controller.getTrees().getElement(path));
                    this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                    break;
                }
                case IDENTIFIER: {
                    if (this.isSealedSupported(env) && TokenUtilities.textEquals((CharSequence)lastNonWhitespaceToken.token().text(), (CharSequence)PERMITS_KEYWORD)) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addClassTypes(env, null);
                        break;
                    }
                    if (tu.isAnnotation(cls)) break;
                    if (!tu.isEnum(cls)) {
                        this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                        if (this.isSealedSupported(env)) {
                            this.addKeyword(env, PERMITS_KEYWORD, SPACE, false);
                        }
                    }
                    if (tu.isInterface(cls)) break;
                    this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                }
            }
            return;
        }
        lastNonWhitespaceToken = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getStartPosition(root, cls), offset);
        if (lastNonWhitespaceToken != null && lastNonWhitespaceToken.token().id() == JavaTokenId.AT) {
            this.addKeyword(env, INTERFACE_KEYWORD, SPACE, false);
            this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE), null);
        } else if (path.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
            this.addClassModifiers(env, cls.getModifiers().getFlags());
        } else {
            this.addMemberModifiers(env, cls.getModifiers().getFlags(), false);
            this.addClassTypes(env, null);
        }
    }

    private void insideVariable(BaseTask.Env env) throws IOException {
        int typePos;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        VariableTree var = (VariableTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        CompilationController controller = env.getController();
        Tree type = var.getType();
        int n = typePos = type.getKind() == Tree.Kind.ERRONEOUS && ((ErroneousTree)type).getErrorTrees().isEmpty() ? (int)sourcePositions.getEndPosition(root, type) : (int)sourcePositions.getStartPosition(root, type);
        if (offset <= typePos) {
            Tree parent = path.getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.CATCH) {
                TypeElement te;
                if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
                    TreeUtilities tu = controller.getTreeUtilities();
                    TreePath tryPath = tu.getPathElementOfKind(Tree.Kind.TRY, path);
                    Set exs = tu.getUncaughtExceptions(tryPath);
                    Elements elements = controller.getElements();
                    for (TypeMirror ex : exs) {
                        if (ex.getKind() != TypeKind.DECLARED || !this.startsWith(env, ((DeclaredType)ex).asElement().getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(((DeclaredType)ex).asElement()) || Utilities.isExcluded(((TypeElement)((DeclaredType)ex).asElement()).getQualifiedName())) continue;
                        env.addToExcludes(((DeclaredType)ex).asElement());
                        this.results.add(this.itemFactory.createTypeItem((CompilationInfo)controller, (TypeElement)((DeclaredType)ex).asElement(), (DeclaredType)ex, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(((DeclaredType)ex).asElement()), false, false, false, true, false));
                    }
                }
                if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) != null) {
                    this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
                }
            } else if (parent.getKind() == Tree.Kind.TRY) {
                TypeElement te = controller.getElements().getTypeElement("java.lang.AutoCloseable");
                if (te != null) {
                    this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
                }
            } else {
                if (path.getParentPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                    LambdaExpressionTree let = (LambdaExpressionTree)path.getParentPath().getLeaf();
                    if (let.getParameters().size() == 1) {
                        this.addVarTypeForLambdaParam(env);
                    } else if (this.isLambdaVarType(env, let)) {
                        this.addVarTypeForLambdaParam(env);
                        return;
                    }
                }
                boolean isLocal = !TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind());
                this.addMemberModifiers(env, var.getModifiers().getFlags(), isLocal);
                this.addClassTypes(env, null);
                ModifiersTree mods = var.getModifiers();
                if (mods.getFlags().isEmpty() && mods.getAnnotations().isEmpty()) {
                    this.addElementCreators(env);
                }
            }
            return;
        }
        controller.toPhase(JavaSource.Phase.RESOLVED);
        Tree init = this.unwrapErrTree(var.getInitializer());
        if (init == null) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getEndPosition(root, type), offset);
            if (last == null || last.token().id() == JavaTokenId.COMMA) {
                this.insideExpression(env, new TreePath(path, type));
            } else if (last.token().id() == JavaTokenId.EQ) {
                this.localResult(env);
                this.addValueKeywords(env);
            }
        } else {
            int pos = (int)sourcePositions.getStartPosition(root, init);
            if (pos < 0) {
                return;
            }
            if (offset <= pos) {
                TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getEndPosition(root, type), offset);
                if (last == null) {
                    this.insideExpression(env, new TreePath(path, type));
                } else if (last.token().id() == JavaTokenId.EQ) {
                    this.localResult(env);
                    this.addValueKeywords(env);
                }
            } else {
                this.insideExpression(env, new TreePath(path, init));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insideMethod(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> lastToken;
        int modsPos;
        ModifiersTree mods;
        int retPos;
        Object retType;
        Tree thr;
        int thrPos;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        MethodTree mth = (MethodTree)path.getLeaf();
        CompilationController controller = env.getController();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        int startPos = (int)sourcePositions.getStartPosition(root, mth);
        Object lastTree = null;
        int state = 0;
        Iterator<Tree> iterator = mth.getThrows().iterator();
        while (iterator.hasNext() && (long)(thrPos = (int)sourcePositions.getEndPosition(root, thr = (Tree)iterator.next())) != -1L && offset > thrPos) {
            lastTree = thr;
            startPos = thrPos;
            state = 4;
        }
        if (lastTree == null) {
            VariableTree param;
            int parPos;
            iterator = mth.getParameters().iterator();
            while (iterator.hasNext() && (long)(parPos = (int)sourcePositions.getEndPosition(root, param = (VariableTree)iterator.next())) != -1L && offset > parPos) {
                lastTree = param;
                startPos = parPos;
                state = 3;
            }
        }
        if (lastTree == null && (retType = mth.getReturnType()) != null && (long)(retPos = (int)sourcePositions.getEndPosition(root, (Tree)retType)) != -1L && offset > retPos) {
            lastTree = retType;
            startPos = retPos;
            state = 2;
        }
        if (lastTree == null) {
            TypeParameterTree tp;
            int tpPos;
            retType = mth.getTypeParameters().iterator();
            while (retType.hasNext() && (long)(tpPos = (int)sourcePositions.getEndPosition(root, tp = (TypeParameterTree)retType.next())) != -1L && offset > tpPos) {
                lastTree = tp;
                startPos = tpPos;
                state = 1;
            }
        }
        if (lastTree == null && (mods = mth.getModifiers()) != null && (long)(modsPos = (int)sourcePositions.getEndPosition(root, mods)) != -1L && offset > modsPos) {
            lastTree = mods;
            startPos = modsPos;
        }
        if ((lastToken = this.findLastNonWhitespaceToken(env, startPos, offset)) != null) {
            block0 : switch ((JavaTokenId)lastToken.token().id()) {
                case LPAREN: {
                    this.addMemberModifiers(env, Collections.emptySet(), true);
                    this.addClassTypes(env, null);
                    return;
                }
                case RPAREN: {
                    Tree mthParent = path.getParentPath().getLeaf();
                    switch (mthParent.getKind()) {
                        case ANNOTATION_TYPE: {
                            this.addKeyword(env, DEFAULT_KEYWORD, SPACE, false);
                            return;
                        }
                    }
                    this.addKeyword(env, THROWS_KEYWORD, SPACE, false);
                    return;
                }
                case THROWS: {
                    TypeElement te;
                    if (!this.options.contains((Object)Options.ALL_COMPLETION) && mth.getBody() != null) {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        Set exs = controller.getTreeUtilities().getUncaughtExceptions(new TreePath(path, mth.getBody()));
                        Elements elements = controller.getElements();
                        for (TypeMirror ex : exs) {
                            if (ex.getKind() != TypeKind.DECLARED || !this.startsWith(env, ((DeclaredType)ex).asElement().getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(((DeclaredType)ex).asElement()) || Utilities.isExcluded(((TypeElement)((DeclaredType)ex).asElement()).getQualifiedName())) continue;
                            env.addToExcludes(((DeclaredType)ex).asElement());
                            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)((DeclaredType)ex).asElement(), (DeclaredType)ex, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(((DeclaredType)ex).asElement()), false, false, false, true, false));
                        }
                    }
                    if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) == null) return;
                    this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
                    return;
                }
                case DEFAULT: {
                    this.addLocalConstantsAndTypes(env);
                    return;
                }
                case GT: 
                case GTGT: 
                case GTGTGT: {
                    this.addPrimitiveTypeKeywords(env);
                    this.addKeyword(env, VOID_KEYWORD, SPACE, false);
                    this.addClassTypes(env, null);
                    return;
                }
                case COMMA: {
                    switch (state) {
                        case 3: {
                            this.addMemberModifiers(env, Collections.emptySet(), true);
                            this.addClassTypes(env, null);
                            break block0;
                        }
                        case 4: {
                            TypeElement te;
                            if (!this.options.contains((Object)Options.ALL_COMPLETION) && mth.getBody() != null) {
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                Set exs = controller.getTreeUtilities().getUncaughtExceptions(new TreePath(path, mth.getBody()));
                                Trees trees = controller.getTrees();
                                Types types = controller.getTypes();
                                for (ExpressionTree expressionTree : mth.getThrows()) {
                                    TypeMirror t = trees.getTypeMirror(new TreePath(path, expressionTree));
                                    Iterator it = exs.iterator();
                                    while (it.hasNext()) {
                                        if (!types.isSubtype((TypeMirror)it.next(), t)) continue;
                                        it.remove();
                                    }
                                    if (expressionTree != lastTree) continue;
                                    break;
                                }
                                Elements elements = controller.getElements();
                                for (TypeMirror ex : exs) {
                                    if (ex.getKind() != TypeKind.DECLARED || !this.startsWith(env, ((DeclaredType)ex).asElement().getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(((DeclaredType)ex).asElement()) || Utilities.isExcluded(((TypeElement)((DeclaredType)ex).asElement()).getQualifiedName())) continue;
                                    env.addToExcludes(((DeclaredType)ex).asElement());
                                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)((DeclaredType)ex).asElement(), (DeclaredType)ex, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(((DeclaredType)ex).asElement()), false, false, false, true, false));
                                }
                            }
                            if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) == null) return;
                            this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
                        }
                    }
                }
            }
            return;
        }
        switch (state) {
            case 0: {
                this.addMemberModifiers(env, mth.getModifiers().getFlags(), false);
                this.addClassTypes(env, null);
                return;
            }
            case 1: {
                if (!((TypeParameterTree)lastTree).getBounds().isEmpty()) return;
                this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                return;
            }
            case 2: {
                this.insideExpression(env, new TreePath(path, (Tree)lastTree));
            }
        }
    }

    private void insideModifiers(BaseTask.Env env, TreePath modPath) throws IOException {
        Tree grandParent;
        int offset = env.getOffset();
        ModifiersTree mods = (ModifiersTree)modPath.getLeaf();
        EnumSet<Modifier> m = EnumSet.noneOf(Modifier.class);
        TokenSequence ts = env.getController().getTreeUtilities().tokensFor((Tree)mods, env.getSourcePositions());
        JavaTokenId lastNonWhitespaceTokenId = null;
        while (ts.moveNext() && ts.offset() < offset) {
            lastNonWhitespaceTokenId = (JavaTokenId)ts.token().id();
            switch (lastNonWhitespaceTokenId) {
                case PUBLIC: {
                    m.add(Modifier.PUBLIC);
                    break;
                }
                case PROTECTED: {
                    m.add(Modifier.PROTECTED);
                    break;
                }
                case PRIVATE: {
                    m.add(Modifier.PRIVATE);
                    break;
                }
                case STATIC: {
                    m.add(Modifier.STATIC);
                    break;
                }
                case DEFAULT: {
                    m.add(Modifier.DEFAULT);
                    break;
                }
                case ABSTRACT: {
                    m.add(Modifier.ABSTRACT);
                    break;
                }
                case FINAL: {
                    m.add(Modifier.FINAL);
                    break;
                }
                case SYNCHRONIZED: {
                    m.add(Modifier.SYNCHRONIZED);
                    break;
                }
                case NATIVE: {
                    m.add(Modifier.NATIVE);
                    break;
                }
                case STRICTFP: {
                    m.add(Modifier.STRICTFP);
                    break;
                }
                case TRANSIENT: {
                    m.add(Modifier.TRANSIENT);
                    break;
                }
                case VOLATILE: {
                    m.add(Modifier.VOLATILE);
                }
            }
        }
        if (lastNonWhitespaceTokenId == JavaTokenId.AT) {
            this.addKeyword(env, INTERFACE_KEYWORD, SPACE, false);
            this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE), null);
            return;
        }
        TreePath parentPath = modPath.getParentPath();
        Tree parent = parentPath.getLeaf();
        TreePath grandParentPath = parentPath.getParentPath();
        Tree tree = grandParent = grandParentPath != null ? grandParentPath.getLeaf() : null;
        if (this.isTopLevelClass(parent, env.getRoot())) {
            this.addClassModifiers(env, m);
        } else if (parent.getKind() != Tree.Kind.VARIABLE || grandParent == null || TreeUtilities.CLASS_TREE_KINDS.contains((Object)grandParent.getKind())) {
            this.addMemberModifiers(env, m, false);
            this.addClassTypes(env, null);
        } else if (parent.getKind() == Tree.Kind.VARIABLE && grandParent.getKind() == Tree.Kind.METHOD) {
            this.addMemberModifiers(env, m, true);
            this.addClassTypes(env, null);
        } else {
            this.localResult(env);
            this.addKeywordsForBlock(env);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insideAnnotation(BaseTask.Env env) throws IOException {
        CompilationUnitTree root;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        AnnotationTree ann = (AnnotationTree)path.getLeaf();
        CompilationController controller = env.getController();
        SourcePositions sourcePositions = env.getSourcePositions();
        int typeEndPos = (int)sourcePositions.getEndPosition(root = env.getRoot(), ann.getAnnotationType());
        if (offset <= typeEndPos) {
            TreePath parentPath = path.getParentPath();
            if (parentPath.getLeaf().getKind() == Tree.Kind.MODIFIERS && (parentPath.getParentPath().getLeaf().getKind() != Tree.Kind.VARIABLE || parentPath.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CLASS)) {
                this.addKeyword(env, INTERFACE_KEYWORD, SPACE, false);
            }
            if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Set<TypeMirror> smarts = this.getSmartTypes(env);
                if (smarts != null) {
                    Elements elements = controller.getElements();
                    for (TypeMirror smart : smarts) {
                        TypeElement typeElement;
                        if (smart.getKind() != TypeKind.DECLARED || (typeElement = (TypeElement)((DeclaredType)smart).asElement()).getKind() != ElementKind.ANNOTATION_TYPE || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(typeElement) || Utilities.isExcluded(typeElement.getQualifiedName())) continue;
                        this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), typeElement, (DeclaredType)smart, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(typeElement), false, false, false, true, false));
                    }
                }
            }
            this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE), null);
            return;
        }
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, ann, offset);
        if (ts == null || ts.token().id() != JavaTokenId.LPAREN && ts.token().id() != JavaTokenId.COMMA) {
            return;
        }
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        Trees trees = controller.getTrees();
        Element annTypeElement = trees.getElement(new TreePath(path, ann.getAnnotationType()));
        if (annTypeElement != null && annTypeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            void var14_22;
            HashSet<String> names = new HashSet<String>();
            for (ExpressionTree expressionTree : ann.getArguments()) {
                Object var;
                if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT || sourcePositions.getEndPosition(root, ((AssignmentTree)expressionTree).getExpression()) >= (long)offset || (var = ((AssignmentTree)expressionTree).getVariable()).getKind() != Tree.Kind.IDENTIFIER) continue;
                names.add(((IdentifierTree)var).getName().toString());
            }
            Elements elements = controller.getElements();
            Object var14_21 = null;
            for (Element element : ((TypeElement)annTypeElement).getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                String name = element.getSimpleName().toString();
                if ("value".equals(name)) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                } else if (((ExecutableElement)element).getDefaultValue() == null) {
                    Object var14_24 = null;
                }
                if (names.contains(name) || !this.startsWith(env, name) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element)) continue;
                this.results.add(this.itemFactory.createAttributeItem((CompilationInfo)env.getController(), (ExecutableElement)element, (ExecutableType)element.asType(), this.anchorOffset, elements.isDeprecated(element)));
            }
            if (var14_22 != null && names.isEmpty()) {
                Element el = null;
                TreePath treePath = path.getParentPath();
                if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    el = trees.getElement(treePath);
                } else {
                    TreePath treePath2 = treePath.getParentPath();
                    Tree.Kind pKind = treePath2.getLeaf().getKind();
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)pKind) || pKind == Tree.Kind.METHOD || pKind == Tree.Kind.VARIABLE) {
                        el = trees.getElement(treePath2);
                    }
                }
                if (el != null) {
                    AnnotationMirror annotation = null;
                    for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
                        if (annTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                        annotation = annotationMirror;
                        break;
                    }
                    if (annotation != null) {
                        this.addAttributeValues(env, el, annotation, (ExecutableElement)var14_22);
                    }
                }
                this.addLocalConstantsAndTypes(env);
            }
        }
    }

    private void insideAnnotatedType(BaseTask.Env env) throws IOException {
        CompilationUnitTree root;
        int offset = env.getOffset();
        AnnotatedTypeTree att = (AnnotatedTypeTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int pos = (int)sourcePositions.getStartPosition(root = env.getRoot(), att.getUnderlyingType());
        if (pos >= 0 && pos < offset) {
            this.insideExpression(env, new TreePath(env.getPath(), att.getUnderlyingType()));
        } else {
            this.addClassTypes(env, null);
        }
    }

    private void insideAnnotationAttribute(BaseTask.Env env, TreePath annotationPath, Name attributeName) throws IOException {
        CompilationController controller = env.getController();
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        Trees trees = controller.getTrees();
        AnnotationTree at = (AnnotationTree)annotationPath.getLeaf();
        Element annTypeElement = trees.getElement(new TreePath(annotationPath, at.getAnnotationType()));
        Element el = null;
        TreePath pPath = annotationPath.getParentPath();
        if (pPath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
            el = trees.getElement(pPath);
        } else {
            Tree.Kind pKind = (pPath = pPath.getParentPath()).getLeaf().getKind();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)pKind) || pKind == Tree.Kind.METHOD || pKind == Tree.Kind.VARIABLE) {
                el = trees.getElement(pPath);
            }
        }
        if (el != null && annTypeElement != null && annTypeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            ExecutableElement memberElement = null;
            for (Element element : ((TypeElement)annTypeElement).getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || !attributeName.contentEquals(element.getSimpleName())) continue;
                memberElement = (ExecutableElement)element;
                break;
            }
            if (memberElement != null) {
                AnnotationMirror annotation = null;
                for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
                    if (annTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                    annotation = annotationMirror;
                    break;
                }
                if (annotation != null) {
                    this.addAttributeValues(env, el, annotation, memberElement);
                }
            }
        }
    }

    private void insideTypeParameter(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        TreePath path = env.getPath();
        TypeParameterTree tp = (TypeParameterTree)path.getLeaf();
        CompilationController controller = env.getController();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, tp, offset);
        if (ts != null) {
            switch ((JavaTokenId)ts.token().id()) {
                case EXTENDS: {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                    break;
                }
                case AMP: {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                    break;
                }
                case IDENTIFIER: {
                    if ((long)ts.offset() != env.getSourcePositions().getStartPosition(env.getRoot(), tp)) break;
                    this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                }
            }
        }
    }

    private void insideParameterizedType(BaseTask.Env env, TreePath ptPath) throws IOException {
        int offset = env.getOffset();
        ParameterizedTypeTree ta = (ParameterizedTypeTree)ptPath.getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, ta, offset);
        if (ts != null) {
            switch ((JavaTokenId)ts.token().id()) {
                case EXTENDS: 
                case COMMA: 
                case SUPER: 
                case LT: {
                    if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
                        Set<TypeMirror> smarts;
                        TypeElement te;
                        Object typeParams;
                        Tree arg;
                        int parPos;
                        CompilationController controller = env.getController();
                        SourcePositions sourcePositions = env.getSourcePositions();
                        CompilationUnitTree root = env.getRoot();
                        int index = 0;
                        Iterator<? extends Tree> iterator = ta.getTypeArguments().iterator();
                        while (iterator.hasNext() && (long)(parPos = (int)sourcePositions.getEndPosition(root, arg = iterator.next())) != -1L && offset > parPos) {
                            ++index;
                        }
                        Elements elements = controller.getElements();
                        Types types = controller.getTypes();
                        TypeMirror tm = controller.getTrees().getTypeMirror(new TreePath(ptPath, ta.getType()));
                        List<? extends TypeMirror> bounds = null;
                        if (tm.getKind() == TypeKind.DECLARED && index < (typeParams = (te = (TypeElement)((DeclaredType)tm).asElement()).getTypeParameters()).size()) {
                            TypeParameterElement typeParam = (TypeParameterElement)typeParams.get(index);
                            bounds = typeParam.getBounds();
                        }
                        if ((smarts = this.getSmartTypes(env)) != null) {
                            for (TypeMirror smart : smarts) {
                                List<? extends TypeMirror> typeArgs;
                                if (smart == null || smart.getKind() != TypeKind.DECLARED || !types.isSubtype(tm, types.erasure(smart)) || index >= (typeArgs = ((DeclaredType)smart).getTypeArguments()).size()) continue;
                                TypeMirror lowerBound = typeArgs.get(index);
                                TypeMirror upperBound = null;
                                if (lowerBound.getKind() == TypeKind.WILDCARD) {
                                    upperBound = ((WildcardType)lowerBound).getSuperBound();
                                    lowerBound = ((WildcardType)lowerBound).getExtendsBound();
                                }
                                if (lowerBound != null && lowerBound.getKind() == TypeKind.TYPEVAR) {
                                    lowerBound = ((TypeVariable)lowerBound).getUpperBound();
                                }
                                if (upperBound != null && upperBound.getKind() == TypeKind.TYPEVAR) {
                                    upperBound = ((TypeVariable)upperBound).getUpperBound();
                                }
                                if (upperBound != null && upperBound.getKind() == TypeKind.DECLARED) {
                                    while (upperBound.getKind() == TypeKind.DECLARED) {
                                        TypeElement elem = (TypeElement)((DeclaredType)upperBound).asElement();
                                        if (this.startsWith(env, elem.getSimpleName().toString()) && this.withinBounds(env, upperBound, bounds) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(elem)) && !Utilities.isExcluded(elem.getQualifiedName())) {
                                            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, (DeclaredType)upperBound, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), false, true, false, true, false));
                                        }
                                        env.addToExcludes(elem);
                                        upperBound = elem.getSuperclass();
                                    }
                                    continue;
                                }
                                if (lowerBound == null || lowerBound.getKind() != TypeKind.DECLARED) continue;
                                for (DeclaredType subtype : this.getSubtypesOf(env, (DeclaredType)lowerBound)) {
                                    TypeElement elem = (TypeElement)subtype.asElement();
                                    if (this.withinBounds(env, subtype, bounds) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(elem)) && !Utilities.isExcluded(elem.getQualifiedName())) {
                                        this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, subtype, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), false, true, false, true, false));
                                    }
                                    env.addToExcludes(elem);
                                }
                            }
                        } else if (bounds != null && !bounds.isEmpty()) {
                            TypeMirror lowerBound = (TypeMirror)bounds.get(0);
                            bounds = bounds.subList(0, bounds.size());
                            for (DeclaredType subtype : this.getSubtypesOf(env, (DeclaredType)lowerBound)) {
                                TypeElement elem = (TypeElement)subtype.asElement();
                                if (this.withinBounds(env, subtype, bounds) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(elem)) && !Utilities.isExcluded(elem.getQualifiedName())) {
                                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, subtype, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), false, true, false, true, false));
                                }
                                env.addToExcludes(elem);
                            }
                        }
                    }
                    this.addClassTypes(env, null);
                    break;
                }
                case QUESTION: {
                    this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                    this.addKeyword(env, SUPER_KEYWORD, SPACE, false);
                }
            }
        }
    }

    private void insideBlock(BaseTask.Env env) throws IOException {
        TreePath parentPath;
        StatementTree stat;
        int pos;
        int offset = env.getOffset();
        BlockTree bl = (BlockTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        int blockPos = (int)sourcePositions.getStartPosition(root, bl);
        String text = env.getController().getText().substring(blockPos, offset);
        if (text.indexOf(123) < 0) {
            this.addMemberModifiers(env, Collections.singleton(Modifier.STATIC), false);
            this.addClassTypes(env, null);
            return;
        }
        Tree last = null;
        Iterator<? extends StatementTree> iterator = bl.getStatements().iterator();
        while (iterator.hasNext() && (long)(pos = (int)sourcePositions.getStartPosition(root, stat = iterator.next())) != -1L && offset > pos) {
            last = stat;
        }
        if (last == null) {
            ExecutableElement enclMethod = env.getScope().getEnclosingMethod();
            if (enclMethod != null && enclMethod.getKind() == ElementKind.CONSTRUCTOR) {
                String prefix = env.getPrefix();
                if (Utilities.startsWith(THIS_KEYWORD, prefix)) {
                    Element element = enclMethod.getEnclosingElement();
                    this.addThisOrSuperConstructor(env, element.asType(), element, THIS_KEYWORD, enclMethod);
                }
                if (Utilities.startsWith(SUPER_KEYWORD, prefix)) {
                    Element element = enclMethod.getEnclosingElement();
                    element = ((DeclaredType)((TypeElement)element).getSuperclass()).asElement();
                    this.addThisOrSuperConstructor(env, element.asType(), element, SUPER_KEYWORD, enclMethod);
                }
            }
        } else if (last.getKind() == Tree.Kind.TRY) {
            if (((TryTree)last).getFinallyBlock() == null) {
                this.addKeyword(env, CATCH_KEYWORD, null, true);
                this.addKeyword(env, FINALLY_KEYWORD, null, true);
                if (((TryTree)last).getCatches().isEmpty() && ((TryTree)last).getResources().isEmpty()) {
                    return;
                }
            }
        } else if (last.getKind() == Tree.Kind.IF && ((IfTree)last).getElseStatement() == null) {
            this.addKeyword(env, ELSE_KEYWORD, null, true);
        }
        this.localResult(env);
        this.addKeywordsForBlock(env);
        String prefix = env.getPrefix();
        if (env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_13) >= 0 && Utilities.startsWith(YIELD_KEYWORD, prefix) && (parentPath = env.getPath().getParentPath()).getLeaf().getKind() == Tree.Kind.CASE && parentPath.getParentPath().getLeaf().getKind() == Tree.Kind.SWITCH_EXPRESSION) {
            this.addKeyword(env, YIELD_KEYWORD, null, false);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insideMemberSelect(BaseTask.Env env) throws IOException {
        PackageElement pe;
        int offset = env.getOffset();
        String prefix = env.getPrefix();
        TreePath path = env.getPath();
        MemberSelectTree fa = (MemberSelectTree)path.getLeaf();
        CompilationController controller = env.getController();
        CompilationUnitTree root = env.getRoot();
        SourcePositions sourcePositions = env.getSourcePositions();
        int expEndPos = (int)sourcePositions.getEndPosition(root, fa.getExpression());
        boolean afterDot = false;
        boolean afterLt = false;
        int openLtNum = 0;
        JavaTokenId lastNonWhitespaceTokenId = null;
        TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(expEndPos);
        block20: while (ts.moveNext() && ts.offset() < offset) {
            switch ((JavaTokenId)ts.token().id()) {
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case FLOAT_LITERAL_INVALID: 
                case LONG_LITERAL: 
                case ELLIPSIS: {
                    if (ts.offset() != expEndPos || ts.token().text().charAt(0) != '.') break;
                }
                case DOT: {
                    afterDot = true;
                    break;
                }
                case LT: {
                    afterLt = true;
                    ++openLtNum;
                    break;
                }
                case GT: {
                    --openLtNum;
                    break;
                }
                case GTGT: {
                    openLtNum -= 2;
                    break;
                }
                case GTGTGT: {
                    openLtNum -= 3;
                }
            }
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block20;
                }
            }
            lastNonWhitespaceTokenId = (JavaTokenId)ts.token().id();
        }
        if (!afterDot) {
            if (expEndPos > offset) return;
            this.insideExpression(env, new TreePath(path, fa.getExpression()));
            return;
        }
        if (openLtNum > 0) {
            switch (lastNonWhitespaceTokenId) {
                case QUESTION: {
                    this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
                    this.addKeyword(env, SUPER_KEYWORD, SPACE, false);
                    return;
                }
                case COMMA: 
                case LT: {
                    this.addClassTypes(env, null);
                    return;
                }
                case EXTENDS: 
                case SUPER: {
                    this.addClassTypes(env, null);
                }
            }
            return;
        }
        if (lastNonWhitespaceTokenId == JavaTokenId.STAR) return;
        controller.toPhase(JavaSource.Phase.RESOLVED);
        if (this.withinModuleName(env)) {
            String fqnPrefix = fa.getExpression().toString() + '.';
            this.anchorOffset = (int)sourcePositions.getStartPosition(root, fa);
            this.addModuleNames(env, fqnPrefix, true);
            return;
        }
        TreePath parentPath = path.getParentPath();
        Tree parent = parentPath != null ? parentPath.getLeaf() : null;
        TreePath grandParentPath = parentPath != null ? parentPath.getParentPath() : null;
        Tree grandParent = grandParentPath != null ? grandParentPath.getLeaf() : null;
        ExpressionTree exp = fa.getExpression();
        TreePath expPath = new TreePath(path, exp);
        TypeMirror type = controller.getTrees().getTypeMirror(expPath);
        if (type != null) {
            TypeElement te;
            Element el = controller.getTrees().getElement(expPath);
            TreeUtilities tu = controller.getTreeUtilities();
            DeclaredType baseType = null;
            Set exs = null;
            boolean inImport = false;
            boolean insideNew = false;
            boolean srcOnly = false;
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && ((ClassTree)parent).getExtendsClause() == fa) {
                EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS);
                env.afterExtends();
            } else if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && ((ClassTree)parent).getImplementsClause().contains(fa)) {
                EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.INTERFACE);
            } else if (parent.getKind() == Tree.Kind.IMPORT) {
                inImport = true;
                EnumSet<ElementKind> enumSet = ((ImportTree)parent).isStatic() ? EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT}) : EnumSet.of(ElementKind.CLASS, ElementKind.ANNOTATION_TYPE, ElementKind.ENUM, ElementKind.INTERFACE);
            } else if (parent.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)parent).getIdentifier() == fa) {
                insideNew = true;
                EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE);
                if (grandParent.getKind() == Tree.Kind.THROW && (te = controller.getElements().getTypeElement("java.lang.Throwable")) != null) {
                    baseType = controller.getTypes().getDeclaredType(te, new TypeMirror[0]);
                }
            } else if (parent.getKind() == Tree.Kind.PARAMETERIZED_TYPE && ((ParameterizedTypeTree)parent).getTypeArguments().contains(fa)) {
                EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE);
            } else if (parent.getKind() == Tree.Kind.ANNOTATION || parent.getKind() == Tree.Kind.TYPE_ANNOTATION) {
                if (((AnnotationTree)parent).getAnnotationType() == fa) {
                    EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.ANNOTATION_TYPE);
                } else {
                    ExpressionTree et;
                    Iterator<? extends ExpressionTree> it = ((AnnotationTree)parent).getArguments().iterator();
                    if (it.hasNext() && ((et = it.next()) == fa || et.getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)et).getExpression() == fa)) {
                        if (type.getKind() == TypeKind.ERROR && el.getKind().isClass()) {
                            el = controller.getElements().getPackageElement(((TypeElement)el).getQualifiedName());
                        }
                        if (el instanceof PackageElement) {
                            this.addPackageContent(env, (PackageElement)el, EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE), null, false, false);
                            return;
                        } else {
                            if (type.getKind() != TypeKind.DECLARED) return;
                            this.addMemberConstantsAndTypes(env, (DeclaredType)type, el);
                        }
                        return;
                    }
                    EnumSet<ElementKind[]> enumSet = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT});
                }
            } else {
                Object trees;
                if (parent.getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)parent).getExpression() == fa && grandParent != null && grandParent.getKind() == Tree.Kind.ANNOTATION) {
                    if (type.getKind() == TypeKind.ERROR && el.getKind().isClass()) {
                        el = controller.getElements().getPackageElement(((TypeElement)el).getQualifiedName());
                    }
                    if (el instanceof PackageElement) {
                        this.addPackageContent(env, (PackageElement)el, EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE), null, false, false);
                        return;
                    } else {
                        if (type.getKind() != TypeKind.DECLARED) return;
                        this.addMemberConstantsAndTypes(env, (DeclaredType)type, el);
                    }
                    return;
                }
                if (parent.getKind() == Tree.Kind.VARIABLE && ((VariableTree)parent).getType() == fa) {
                    if (grandParent.getKind() == Tree.Kind.CATCH) {
                        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE);
                        if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
                            exs = controller.getTreeUtilities().getUncaughtExceptions(grandParentPath.getParentPath());
                        }
                        if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) != null) {
                            baseType = controller.getTypes().getDeclaredType(te, new TypeMirror[0]);
                        }
                    } else {
                        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE);
                    }
                } else if (parent.getKind() == Tree.Kind.METHOD && ((MethodTree)parent).getThrows().contains(fa)) {
                    Types types = controller.getTypes();
                    if (!this.options.contains((Object)Options.ALL_COMPLETION) && ((MethodTree)parent).getBody() != null) {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        exs = controller.getTreeUtilities().getUncaughtExceptions(new TreePath(path, ((MethodTree)parent).getBody()));
                        trees = controller.getTrees();
                        for (ExpressionTree expressionTree : ((MethodTree)parent).getThrows()) {
                            if (sourcePositions.getEndPosition(root, expressionTree) >= (long)offset) break;
                            TypeMirror t = ((Trees)trees).getTypeMirror(new TreePath(path, expressionTree));
                            Iterator it = exs.iterator();
                            while (it.hasNext()) {
                                if (!types.isSubtype((TypeMirror)it.next(), t)) continue;
                                it.remove();
                            }
                        }
                    }
                    EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE);
                    TypeElement te2 = controller.getElements().getTypeElement("java.lang.Throwable");
                    if (te2 != null) {
                        baseType = controller.getTypes().getDeclaredType(te2, new TypeMirror[0]);
                    }
                } else {
                    if (parent.getKind() == Tree.Kind.METHOD && ((MethodTree)parent).getDefaultValue() == fa) {
                        if (type.getKind() == TypeKind.ERROR && el.getKind().isClass()) {
                            el = controller.getElements().getPackageElement(((TypeElement)el).getQualifiedName());
                        }
                        if (el instanceof PackageElement) {
                            this.addPackageContent(env, (PackageElement)el, EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE), null, false, false);
                            return;
                        } else {
                            if (type.getKind() != TypeKind.DECLARED) return;
                            this.addMemberConstantsAndTypes(env, (DeclaredType)type, el);
                        }
                        return;
                    }
                    if (parent.getKind() == Tree.Kind.TYPE_PARAMETER) {
                        boolean bl;
                        Tree bound;
                        int pos;
                        TypeParameterTree tpt = (TypeParameterTree)parent;
                        trees = controller.getTrees();
                        boolean bl2 = true;
                        Iterator<? extends Tree> iterator = tpt.getBounds().iterator();
                        while (iterator.hasNext() && offset > (pos = (int)sourcePositions.getEndPosition(root, bound = iterator.next()))) {
                            bl = false;
                            env.addToExcludes(((Trees)trees).getElement(new TreePath(parentPath, bound)));
                        }
                        EnumSet<ElementKind> enumSet = bl ? EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE) : EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE);
                    } else if (parent.getKind() == Tree.Kind.AND) {
                        TypeMirror tm = controller.getTrees().getTypeMirror(new TreePath(path, ((BinaryTree)parent).getLeftOperand()));
                        if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                            env.addToExcludes(((DeclaredType)tm).asElement());
                            EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE);
                        } else if (tm != null && tm.getKind() == TypeKind.INTERSECTION) {
                            for (TypeMirror typeMirror : ((IntersectionType)tm).getBounds()) {
                                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                                env.addToExcludes(((DeclaredType)typeMirror).asElement());
                            }
                            EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE);
                        } else {
                            EnumSet<ElementKind[]> enumSet = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT});
                        }
                    } else if (afterLt) {
                        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.METHOD);
                    } else if (parent.getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)parent).getExpression() == fa) {
                        env.insideForEachExpression();
                        EnumSet<ElementKind[]> enumSet = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT});
                    } else if (tu.getPathElementOfKind(Tree.Kind.EXPORTS, path) != null) {
                        EnumSet<ElementKind> enumSet = EnumSet.noneOf(ElementKind.class);
                        srcOnly = true;
                    } else if (tu.getPathElementOfKind(Tree.Kind.PROVIDES, path) != null) {
                        EnumSet<ElementKind> enumSet = this.withinProvidesService(env) ? EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.INTERFACE) : EnumSet.of(ElementKind.CLASS);
                    } else if (tu.getPathElementOfKind(Tree.Kind.USES, path) != null) {
                        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.INTERFACE);
                    } else {
                        EnumSet<ElementKind[]> enumSet = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT});
                    }
                }
            }
            switch (type.getKind()) {
                case TYPEVAR: {
                    while (type != null && type.getKind() == TypeKind.TYPEVAR) {
                        type = ((TypeVariable)type).getUpperBound();
                    }
                    if (type == null) {
                        return;
                    }
                    type = controller.getTypes().capture(type);
                }
                case ARRAY: 
                case DECLARED: 
                case UNION: 
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    void var24_52;
                    Element e;
                    Elements elements;
                    String typeName;
                    boolean b;
                    boolean bl = b = exp.getKind() == Tree.Kind.PARENTHESIZED || exp.getKind() == Tree.Kind.TYPE_CAST;
                    while (b) {
                        if (exp.getKind() == Tree.Kind.PARENTHESIZED) {
                            exp = ((ParenthesizedTree)exp).getExpression();
                            expPath = new TreePath(expPath, exp);
                            continue;
                        }
                        if (exp.getKind() == Tree.Kind.TYPE_CAST) {
                            exp = ((TypeCastTree)exp).getExpression();
                            expPath = new TreePath(expPath, exp);
                            continue;
                        }
                        b = false;
                    }
                    el = controller.getTrees().getElement(expPath);
                    if (el != null && (el.getKind().isClass() || el.getKind().isInterface()) && parent.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)parent).getIdentifier() == fa && prefix != null) {
                        typeName = controller.getElementUtilities().getElementName(el, true) + "." + prefix;
                        TypeMirror typeMirror = controller.getTreeUtilities().parseType(typeName, env.getScope().getEnclosingClass());
                        if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                            this.addMembers(env, typeMirror, ((DeclaredType)typeMirror).asElement(), EnumSet.of(ElementKind.CONSTRUCTOR), null, inImport, insideNew, false);
                        }
                    }
                    if (exs != null && !exs.isEmpty()) {
                        elements = controller.getElements();
                        for (TypeMirror typeMirror : exs) {
                            if (typeMirror.getKind() != TypeKind.DECLARED || (e = ((DeclaredType)typeMirror).asElement()).getEnclosingElement() != el || !this.startsWith(env, e.getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || Utilities.isExcluded(((TypeElement)e).getQualifiedName())) continue;
                            env.addToExcludes(e);
                            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)e, (DeclaredType)typeMirror, this.anchorOffset, null, elements.isDeprecated(e), insideNew, insideNew || env.isInsideClass(), true, true, false));
                        }
                        return;
                    }
                    if (el == null) {
                        if (exp.getKind() == Tree.Kind.ARRAY_TYPE) {
                            TypeMirror tm = type;
                            while (tm.getKind() == TypeKind.ARRAY) {
                                tm = ((ArrayType)tm).getComponentType();
                            }
                            if (tm.getKind().isPrimitive()) {
                                el = controller.getTypes().boxedClass((PrimitiveType)tm);
                            } else if (tm.getKind() == TypeKind.DECLARED) {
                                el = ((DeclaredType)tm).asElement();
                            }
                        } else if (exp.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                            if (type.getKind().isPrimitive()) {
                                el = controller.getTypes().boxedClass((PrimitiveType)type);
                            } else if (type.getKind() == TypeKind.VOID) {
                                el = controller.getElements().getTypeElement("java.lang.Void");
                            }
                        }
                    }
                    this.addMembers(env, type, el, (EnumSet<ElementKind>)var24_52, baseType, inImport, insideNew, false);
                    return;
                }
                default: {
                    void var24_52;
                    Element e;
                    Elements elements;
                    String typeName;
                    el = controller.getTrees().getElement(expPath);
                    if (type.getKind() == TypeKind.ERROR && el != null && el.getKind().isClass()) {
                        el = controller.getElements().getPackageElement(((TypeElement)el).getQualifiedName());
                    }
                    if (el == null || el.getKind() != ElementKind.PACKAGE) return;
                    if (parent.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)parent).getIdentifier() == fa && prefix != null) {
                        typeName = controller.getElementUtilities().getElementName(el, true) + "." + prefix;
                        TypeMirror typeMirror = controller.getTreeUtilities().parseType(typeName, env.getScope().getEnclosingClass());
                        if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                            this.addMembers(env, typeMirror, ((DeclaredType)typeMirror).asElement(), EnumSet.of(ElementKind.CONSTRUCTOR), null, inImport, insideNew, false);
                        }
                    }
                    if (exs != null && !exs.isEmpty()) {
                        elements = controller.getElements();
                        for (TypeMirror typeMirror : exs) {
                            if (typeMirror.getKind() != TypeKind.DECLARED || (e = ((DeclaredType)typeMirror).asElement()).getEnclosingElement() != el || !this.startsWith(env, e.getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || Utilities.isExcluded(((TypeElement)e).getQualifiedName())) continue;
                            env.addToExcludes(e);
                            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)e, (DeclaredType)typeMirror, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(e), false, env.isInsideClass(), true, true, false));
                        }
                    }
                    this.addPackageContent(env, (PackageElement)el, (EnumSet<ElementKind>)var24_52, baseType, insideNew, srcOnly);
                    if (!this.results.isEmpty() || ((PackageElement)el).getQualifiedName() != el.getSimpleName()) return;
                    ClassIndex ci = controller.getClasspathInfo().getClassIndex();
                    if (!el.getEnclosedElements().isEmpty() || !ci.getPackageNames(el.getSimpleName() + ".", true, EnumSet.allOf(ClassIndex.SearchScope.class)).isEmpty()) return;
                    Trees trees = controller.getTrees();
                    Scope scope = env.getScope();
                    for (ElementHandle teHandle : ci.getDeclaredTypes(el.getSimpleName().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                        TypeElement te3 = (TypeElement)teHandle.resolve((CompilationInfo)controller);
                        if (te3 == null || !trees.isAccessible(scope, te3)) continue;
                        this.addMembers(env, te3.asType(), te3, (EnumSet<ElementKind>)var24_52, baseType, inImport, insideNew, true);
                    }
                    return;
                }
            }
        }
        if (parent.getKind() != Tree.Kind.COMPILATION_UNIT || ((CompilationUnitTree)parent).getPackageName() != fa || (pe = controller.getElements().getPackageElement(this.fullName(exp))) == null) return;
        this.addPackageContent(env, pe, EnumSet.of(ElementKind.PACKAGE), null, false, true);
    }

    private void insideMemberReference(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        MemberReferenceTree mr = (MemberReferenceTree)path.getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, mr, env.getOffset());
        if (ts != null) {
            switch ((JavaTokenId)ts.token().id()) {
                case GT: 
                case GTGT: 
                case GTGTGT: 
                case COLONCOLON: {
                    CompilationController controller = env.getController();
                    ExpressionTree exp = mr.getQualifierExpression();
                    TreePath expPath = new TreePath(path, exp);
                    Trees trees = controller.getTrees();
                    TypeMirror type = trees.getTypeMirror(expPath);
                    if (type != null && type.getKind() == TypeKind.TYPEVAR) {
                        while (type != null && type.getKind() == TypeKind.TYPEVAR) {
                            type = ((TypeVariable)type).getUpperBound();
                        }
                        if (type != null) {
                            type = controller.getTypes().capture(type);
                        }
                    }
                    if (type == null || type.getKind() != TypeKind.DECLARED && type.getKind() != TypeKind.ARRAY && type.getKind() != TypeKind.TYPEVAR) break;
                    Element e = trees.getElement(expPath);
                    this.addMethodReferences(env, type, e);
                    if (e != null && !e.getKind().isClass() && !e.getKind().isInterface()) break;
                    this.addKeyword(env, NEW_KEYWORD, SPACE, false);
                    break;
                }
                case COMMA: 
                case LT: {
                    this.addClassTypes(env, null);
                }
            }
        }
    }

    private void insideLambdaExpression(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        LambdaExpressionTree let = (LambdaExpressionTree)path.getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, let, env.getOffset());
        if (ts != null) {
            switch ((JavaTokenId)ts.token().id()) {
                case ARROW: {
                    this.localResult(env);
                    this.addValueKeywords(env);
                    break;
                }
                case COMMA: {
                    if (let.getParameters().isEmpty() || env.getController().getTrees().getSourcePositions().getStartPosition(path.getCompilationUnit(), let.getParameters().get(0).getType()) >= 0L) {
                        this.addClassTypes(env, null);
                        this.addPrimitiveTypeKeywords(env);
                        this.addKeyword(env, FINAL_KEYWORD, SPACE, false);
                        break;
                    }
                    boolean isFirstParamVarType = this.isLambdaVarType(env, let);
                    if (!isFirstParamVarType) break;
                    this.addVarTypeForLambdaParam(env);
                }
            }
        }
    }

    private void insideMethodInvocation(BaseTask.Env env) throws IOException {
        int offset;
        TreePath path = env.getPath();
        MethodInvocationTree mi = (MethodInvocationTree)path.getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, mi, offset = env.getOffset());
        if (ts == null || ts.token().id() != JavaTokenId.LPAREN && ts.token().id() != JavaTokenId.COMMA) {
            SourcePositions sp = env.getSourcePositions();
            CompilationUnitTree root = env.getRoot();
            int lastTokenEndOffset = ts != null ? ts.offset() + ts.token().length() : -1;
            for (ExpressionTree expressionTree : mi.getArguments()) {
                int pos = (int)sp.getEndPosition(root, expressionTree);
                if (lastTokenEndOffset == pos) {
                    this.insideExpression(env, new TreePath(path, expressionTree));
                    break;
                }
                if (offset > pos) continue;
                break;
            }
            return;
        }
        String prefix = env.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.addMethodArguments(env, mi);
        }
        this.addLocalMembersAndVars(env);
        this.addValueKeywords(env);
        this.addClassTypes(env, null);
        this.addPrimitiveTypeKeywords(env);
    }

    private void insideNewClass(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        NewClassTree nc = (NewClassTree)path.getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, nc, env.getOffset());
        if (ts != null) {
            switch ((JavaTokenId)ts.token().id()) {
                case NEW: {
                    Set<TypeMirror> smarts;
                    TypeMirror tm;
                    String prefix = env.getPrefix();
                    CompilationController controller = env.getController();
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement tel = controller.getElements().getTypeElement("java.lang.Throwable");
                    DeclaredType base = path.getParentPath().getLeaf().getKind() == Tree.Kind.THROW && tel != null ? controller.getTypes().getDeclaredType(tel, new TypeMirror[0]) : null;
                    TypeElement toExclude = null;
                    if (nc.getIdentifier().getKind() == Tree.Kind.IDENTIFIER && prefix != null && (tm = controller.getTreeUtilities().parseType(prefix, env.getScope().getEnclosingClass())) != null && tm.getKind() == TypeKind.DECLARED) {
                        TypeElement te = (TypeElement)((DeclaredType)tm).asElement();
                        this.addMembers(env, tm, te, EnumSet.of(ElementKind.CONSTRUCTOR), base, false, true, false);
                        if ((te.getTypeParameters().isEmpty() || SourceVersion.RELEASE_5.compareTo(controller.getSourceVersion()) > 0) && !this.hasAccessibleInnerClassConstructor(te, env.getScope(), controller.getTrees())) {
                            toExclude = te;
                        }
                    }
                    boolean insideNew = true;
                    ExpressionTree encl = nc.getEnclosingExpression();
                    if (!this.options.contains((Object)Options.ALL_COMPLETION) && (smarts = this.getSmartTypes(env)) != null) {
                        Elements elements = env.getController().getElements();
                        for (TypeMirror smart : smarts) {
                            if (smart == null) continue;
                            if (smart.getKind() == TypeKind.DECLARED) {
                                if (encl != null) continue;
                                for (DeclaredType subtype : this.getSubtypesOf(env, (DeclaredType)smart)) {
                                    TypeElement elem = (TypeElement)subtype.asElement();
                                    if (!(toExclude == elem || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(elem) || Utilities.isExcluded(elem.getQualifiedName()))) {
                                        this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, (DeclaredType)SourceUtils.resolveCapturedType((CompilationInfo)controller, (TypeMirror)subtype), this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), true, true, false, true, false));
                                    }
                                    env.addToExcludes(elem);
                                }
                                continue;
                            }
                            if (smart.getKind() != TypeKind.ARRAY) continue;
                            insideNew = false;
                            try {
                                TypeMirror tm2 = smart;
                                while (tm2.getKind() == TypeKind.ARRAY) {
                                    tm2 = ((ArrayType)tm2).getComponentType();
                                }
                                if (tm2.getKind().isPrimitive() && this.startsWith(env, tm2.toString())) {
                                    this.results.add(this.itemFactory.createArrayItem((CompilationInfo)env.getController(), (ArrayType)smart, this.anchorOffset, env.getReferencesCount(), env.getController().getElements()));
                                    continue;
                                }
                                if (tm2.getKind() != TypeKind.DECLARED && tm2.getKind() != TypeKind.ERROR || !this.startsWith(env, ((DeclaredType)tm2).asElement().getSimpleName().toString())) continue;
                                this.results.add(this.itemFactory.createArrayItem((CompilationInfo)env.getController(), (ArrayType)smart, this.anchorOffset, env.getReferencesCount(), env.getController().getElements()));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                        }
                    }
                    if (toExclude != null) {
                        env.addToExcludes(toExclude);
                    }
                    if (insideNew) {
                        env.insideNew();
                    }
                    if (encl == null) {
                        EnumSet<ElementKind> classKinds = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
                        if (this.isRecordSupported(env)) {
                            classKinds.add(ElementKind.RECORD);
                        }
                        this.addTypes(env, classKinds, base);
                        break;
                    }
                    TypeMirror enclType = controller.getTrees().getTypeMirror(new TreePath(path, nc.getEnclosingExpression()));
                    if (enclType == null || enclType.getKind() != TypeKind.DECLARED) break;
                    this.addMembers(env, enclType, ((DeclaredType)enclType).asElement(), EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE), base, false, insideNew, false);
                    break;
                }
                case LPAREN: 
                case RPAREN: 
                case COMMA: {
                    String prefix = env.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        this.addConstructorArguments(env, nc);
                    }
                    this.addLocalMembersAndVars(env);
                    this.addValueKeywords(env);
                    this.addClassTypes(env, null);
                    this.addPrimitiveTypeKeywords(env);
                    break;
                }
                case GT: 
                case GTGT: 
                case GTGTGT: {
                    CompilationController controller = env.getController();
                    TypeMirror tm = controller.getTrees().getTypeMirror(new TreePath(path, nc.getIdentifier()));
                    this.addMembers(env, tm, ((DeclaredType)tm).asElement(), EnumSet.of(ElementKind.CONSTRUCTOR), null, false, false, false);
                }
            }
        }
    }

    private void insideTry(BaseTask.Env env) throws IOException {
        CompilationController controller = env.getController();
        TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, env.getPath().getLeaf(), env.getOffset());
        if (last != null && (last.token().id() == JavaTokenId.LPAREN || last.token().id() == JavaTokenId.SEMICOLON)) {
            TypeElement te;
            this.addKeyword(env, FINAL_KEYWORD, SPACE, false);
            if (controller.getSourceVersion().compareTo(SourceVersion.RELEASE_9) >= 0) {
                this.addEffectivelyFinalAutoCloseables(env);
            }
            if ((te = controller.getElements().getTypeElement("java.lang.AutoCloseable")) != null) {
                this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
            }
        }
    }

    private void insideCatch(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        CatchTree ct = (CatchTree)path.getLeaf();
        CompilationController controller = env.getController();
        TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, ct, env.getOffset());
        if (last != null && last.token().id() == JavaTokenId.LPAREN) {
            TypeElement te;
            this.addKeyword(env, FINAL_KEYWORD, SPACE, false);
            if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
                TreeUtilities tu;
                TreePath tryPath = (tu = controller.getTreeUtilities()).getPathElementOfKind(Tree.Kind.TRY, path);
                Set exs = tu.getUncaughtExceptions(tryPath != null ? tryPath : path.getParentPath());
                Elements elements = controller.getElements();
                for (TypeMirror ex : exs) {
                    if (ex.getKind() != TypeKind.DECLARED || !this.startsWith(env, ((DeclaredType)ex).asElement().getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(((DeclaredType)ex).asElement()) || Utilities.isExcluded(((TypeElement)((DeclaredType)ex).asElement()).getQualifiedName())) continue;
                    env.addToExcludes(((DeclaredType)ex).asElement());
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)((DeclaredType)ex).asElement(), (DeclaredType)ex, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(((DeclaredType)ex).asElement()), false, false, false, true, false));
                }
            }
            if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) != null) {
                this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
            }
        }
    }

    private void insideUnionType(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        UnionTypeTree dtt = (UnionTypeTree)path.getLeaf();
        CompilationController controller = env.getController();
        TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, dtt, env.getOffset());
        if (last != null && last.token().id() == JavaTokenId.BAR) {
            TypeElement te;
            TreePath tryPath;
            TreeUtilities tu;
            Set exs;
            if (!this.options.contains((Object)Options.ALL_COMPLETION) && !(exs = (tu = controller.getTreeUtilities()).getUncaughtExceptions(tryPath = tu.getPathElementOfKind(Tree.Kind.TRY, path))).isEmpty()) {
                Trees trees = controller.getTrees();
                Types types = controller.getTypes();
                for (Tree tree : dtt.getTypeAlternatives()) {
                    TypeMirror tm = trees.getTypeMirror(new TreePath(path, tree));
                    if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                    Iterator it = exs.iterator();
                    while (it.hasNext()) {
                        if (!types.isSubtype(tm, (TypeMirror)it.next())) continue;
                        it.remove();
                    }
                }
                Elements elements = controller.getElements();
                for (TypeMirror ex : exs) {
                    if (ex.getKind() != TypeKind.DECLARED || !this.startsWith(env, ((DeclaredType)ex).asElement().getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(((DeclaredType)ex).asElement()) || Utilities.isExcluded(((TypeElement)((DeclaredType)ex).asElement()).getQualifiedName())) continue;
                    env.addToExcludes(((DeclaredType)ex).asElement());
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)((DeclaredType)ex).asElement(), (DeclaredType)ex, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(((DeclaredType)ex).asElement()), false, false, false, true, false));
                }
            }
            if ((te = controller.getElements().getTypeElement("java.lang.Throwable")) != null) {
                this.addTypes(env, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.TYPE_PARAMETER), controller.getTypes().getDeclaredType(te, new TypeMirror[0]));
            }
        }
    }

    private void insideIf(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        IfTree iff = (IfTree)env.getPath().getLeaf();
        if (env.getSourcePositions().getEndPosition(env.getRoot(), iff.getCondition()) <= (long)env.getOffset() && (last = this.findLastNonWhitespaceToken(env, iff, env.getOffset())) != null && (last.token().id() == JavaTokenId.RPAREN || last.token().id() == JavaTokenId.ELSE)) {
            this.localResult(env);
            this.addKeywordsForStatement(env);
        }
    }

    private void insideWhile(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        WhileLoopTree wlt = (WhileLoopTree)env.getPath().getLeaf();
        if (env.getSourcePositions().getEndPosition(env.getRoot(), wlt.getCondition()) <= (long)env.getOffset() && (last = this.findLastNonWhitespaceToken(env, wlt, env.getOffset())) != null && last.token().id() == JavaTokenId.RPAREN) {
            this.localResult(env);
            this.addKeywordsForStatement(env);
        }
    }

    private void insideDoWhile(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        DoWhileLoopTree dwlt = (DoWhileLoopTree)env.getPath().getLeaf();
        if (env.getSourcePositions().getEndPosition(env.getRoot(), dwlt.getStatement()) <= (long)env.getOffset() && (last = this.findLastNonWhitespaceToken(env, dwlt, env.getOffset())) != null && (last.token().id() == JavaTokenId.RBRACE || last.token().id() == JavaTokenId.SEMICOLON)) {
            this.addKeyword(env, WHILE_KEYWORD, null, false);
        }
    }

    private void insideFor(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        int pos3;
        Tree update;
        int pos2;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        ForLoopTree fl = (ForLoopTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        Tree lastTree = null;
        int lastTreePos = offset;
        Iterator<? extends ExpressionStatementTree> iterator = fl.getUpdate().iterator();
        while (iterator.hasNext() && (long)(pos2 = (int)sourcePositions.getEndPosition(root, update = (Tree)iterator.next())) != -1L && offset > pos2) {
            lastTree = update;
            lastTreePos = pos2;
        }
        if (lastTree == null && (long)(pos3 = (int)sourcePositions.getEndPosition(root, fl.getCondition())) != -1L && pos3 < offset) {
            lastTree = fl.getCondition();
            lastTreePos = pos3;
        }
        if (lastTree == null) {
            Tree init;
            Iterator<? extends StatementTree> pos3 = fl.getInitializer().iterator();
            while (pos3.hasNext() && (long)(pos2 = (int)sourcePositions.getEndPosition(root, init = (Tree)pos3.next())) != -1L && offset > pos2) {
                lastTree = init;
                lastTreePos = pos2;
            }
        }
        if (lastTree == null) {
            last = this.findLastNonWhitespaceToken(env, fl, offset);
            if (last != null && last.token().id() == JavaTokenId.LPAREN) {
                this.addLocalFieldsAndVars(env);
                this.addClassTypes(env, null);
                this.addPrimitiveTypeKeywords(env);
            }
        } else {
            last = this.findLastNonWhitespaceToken(env, lastTreePos, offset);
            if (last != null && last.token().id() == JavaTokenId.SEMICOLON) {
                this.localResult(env);
                this.addValueKeywords(env);
            } else if (last != null && last.token().id() == JavaTokenId.RPAREN) {
                this.localResult(env);
                this.addKeywordsForStatement(env);
            } else {
                switch (lastTree.getKind()) {
                    case VARIABLE: {
                        ExpressionTree var = ((VariableTree)lastTree).getInitializer();
                        if (var == null) break;
                        this.insideExpression(env, new TreePath(new TreePath(path, lastTree), var));
                        break;
                    }
                    case EXPRESSION_STATEMENT: {
                        Tree exp = this.unwrapErrTree(((ExpressionStatementTree)lastTree).getExpression());
                        if (exp == null) break;
                        this.insideExpression(env, new TreePath(new TreePath(path, lastTree), exp));
                        break;
                    }
                    default: {
                        this.insideExpression(env, new TreePath(path, lastTree));
                    }
                }
            }
        }
    }

    private void insideForEach(BaseTask.Env env) throws IOException {
        CompilationUnitTree root;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        if (sourcePositions.getStartPosition(root = env.getRoot(), efl.getExpression()) >= (long)offset) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getEndPosition(root, efl.getVariable()), offset);
            if (last != null && last.token().id() == JavaTokenId.COLON) {
                env.insideForEachExpression();
                this.addKeyword(env, NEW_KEYWORD, SPACE, false);
                this.localResult(env);
            }
            return;
        }
        TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getEndPosition(root, efl.getExpression()), offset);
        if (last != null && last.token().id() == JavaTokenId.RPAREN) {
            this.addKeywordsForStatement(env);
        } else {
            env.insideForEachExpression();
            this.addKeyword(env, NEW_KEYWORD, SPACE, false);
        }
        this.localResult(env);
    }

    private void insideSwitch(BaseTask.Env env) throws IOException {
        CompilationUnitTree root;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        ExpressionTree exprTree = null;
        exprTree = path.getLeaf().getKind() == Tree.Kind.SWITCH ? ((SwitchTree)path.getLeaf()).getExpression() : ((SwitchExpressionTree)path.getLeaf()).getExpression();
        SourcePositions sourcePositions = env.getSourcePositions();
        if (sourcePositions.getStartPosition(root = env.getRoot(), exprTree) < (long)offset) {
            CaseTree t;
            int pos;
            CaseTree lastCase = null;
            List<? extends CaseTree> cases = path.getLeaf().getKind() == Tree.Kind.SWITCH ? ((SwitchTree)path.getLeaf()).getCases() : ((SwitchExpressionTree)path.getLeaf()).getCases();
            Iterator<? extends CaseTree> iterator = cases.iterator();
            while (iterator.hasNext() && (long)(pos = (int)sourcePositions.getStartPosition(root, t = iterator.next())) != -1L && offset > pos) {
                lastCase = t;
            }
            if (lastCase != null) {
                StatementTree stat;
                int pos2;
                Tree caseBody22;
                Tree last = null;
                List<? extends StatementTree> statements = lastCase.getStatements();
                if (statements == null && (caseBody22 = lastCase.getBody()) instanceof StatementTree) {
                    statements = Collections.singletonList((StatementTree)caseBody22);
                }
                Iterator<? extends StatementTree> caseBody22 = statements.iterator();
                while (caseBody22.hasNext() && (long)(pos2 = (int)sourcePositions.getStartPosition(root, stat = caseBody22.next())) != -1L && offset > pos2) {
                    last = stat;
                }
                if (last != null) {
                    if (last.getKind() == Tree.Kind.TRY) {
                        if (((TryTree)last).getFinallyBlock() == null) {
                            this.addKeyword(env, CATCH_KEYWORD, null, false);
                            this.addKeyword(env, FINALLY_KEYWORD, null, false);
                            if (((TryTree)last).getCatches().isEmpty()) {
                                return;
                            }
                        }
                    } else if (last.getKind() == Tree.Kind.IF && ((IfTree)last).getElseStatement() == null) {
                        this.addKeyword(env, ELSE_KEYWORD, null, false);
                    }
                }
                this.localResult(env);
                this.addKeywordsForBlock(env);
                String prefix = env.getPrefix();
                if (env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_13) >= 0 && path.getLeaf().getKind() == Tree.Kind.SWITCH_EXPRESSION && Utilities.startsWith(YIELD_KEYWORD, prefix)) {
                    this.addKeyword(env, YIELD_KEYWORD, null, false);
                }
            } else {
                TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, path.getLeaf(), offset);
                if (ts != null && ts.token().id() == JavaTokenId.LBRACE) {
                    this.addKeyword(env, CASE_KEYWORD, SPACE, false);
                    this.addKeyword(env, DEFAULT_KEYWORD, COLON, false);
                }
            }
        }
    }

    private void insideCase(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        TreePath path = env.getPath();
        CaseTree cst = (CaseTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        CompilationController controller = env.getController();
        TreePath parentPath = path.getParentPath();
        ExpressionTree caseExpressionTree = null;
        ExpressionTree caseErroneousTree = null;
        List<? extends ExpressionTree> caseTreeList = cst.getExpressions();
        if (!caseTreeList.isEmpty() && caseTreeList.size() == 1) {
            caseExpressionTree = caseTreeList.get(0);
            caseErroneousTree = caseTreeList.get(0);
        } else if (caseTreeList.size() > 1) {
            caseExpressionTree = caseTreeList.get(0);
            for (ExpressionTree expressionTree : caseTreeList) {
                if (expressionTree == null || expressionTree.getKind() != Tree.Kind.ERRONEOUS) continue;
                caseErroneousTree = expressionTree;
                break;
            }
        }
        if (caseExpressionTree != null && (sourcePositions.getStartPosition(root, caseExpressionTree) >= (long)offset || caseErroneousTree != null && caseErroneousTree.getKind() == Tree.Kind.ERRONEOUS && ((ErroneousTree)caseErroneousTree).getErrorTrees().isEmpty() && sourcePositions.getEndPosition(root, caseErroneousTree) >= (long)offset)) {
            if (parentPath.getLeaf().getKind() == Tree.Kind.SWITCH || parentPath.getLeaf().getKind() == Tree.Kind.SWITCH_EXPRESSION) {
                ExpressionTree exprTree = null;
                exprTree = parentPath.getLeaf().getKind() == Tree.Kind.SWITCH ? ((SwitchTree)parentPath.getLeaf()).getExpression() : ((SwitchExpressionTree)parentPath.getLeaf()).getExpression();
                TypeMirror typeMirror = controller.getTrees().getTypeMirror(new TreePath(parentPath, exprTree));
                if (typeMirror.getKind() == TypeKind.DECLARED && ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.ENUM) {
                    this.addEnumConstants(env, (TypeElement)((DeclaredType)typeMirror).asElement());
                } else {
                    this.addLocalConstantsAndTypes(env);
                }
            }
        } else {
            TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, cst, offset);
            if (ts != null && ts.token().id() == JavaTokenId.IDENTIFIER) {
                for (ExpressionTree expressionTree : caseTreeList) {
                    if (expressionTree == null || expressionTree.getKind() != Tree.Kind.IDENTIFIER) continue;
                    TreePath tPath = new TreePath(path, expressionTree);
                    this.insideExpression(env, tPath);
                    return;
                }
            } else if (ts != null && ts.token().id() != JavaTokenId.DEFAULT) {
                this.localResult(env);
                this.addKeywordsForBlock(env);
            }
        }
    }

    private void insideParens(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        ParenthesizedTree pa = (ParenthesizedTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        Tree exp = this.unwrapErrTree(pa.getExpression());
        if (exp == null || (long)env.getOffset() <= sourcePositions.getStartPosition(root, exp)) {
            Set<TypeMirror> smarts;
            if (!this.options.contains((Object)Options.ALL_COMPLETION) && path.getParentPath().getLeaf().getKind() != Tree.Kind.SWITCH && (smarts = this.getSmartTypes(env)) != null) {
                Elements elements = env.getController().getElements();
                for (TypeMirror smart : smarts) {
                    if (smart == null) continue;
                    if (smart.getKind() == TypeKind.DECLARED) {
                        for (DeclaredType subtype : this.getSubtypesOf(env, (DeclaredType)smart)) {
                            TypeElement elem = (TypeElement)subtype.asElement();
                            if (!(!Utilities.isShowDeprecatedMembers() && elements.isDeprecated(elem) || Utilities.isExcluded(elem.getQualifiedName()))) {
                                this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, subtype, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), false, false, false, true, false));
                            }
                            env.addToExcludes(elem);
                        }
                        DeclaredType type = (DeclaredType)smart;
                        TypeElement element = (TypeElement)type.asElement();
                        if (!elements.isFunctionalInterface(element)) continue;
                        this.addVarTypeForLambdaParam(env);
                        continue;
                    }
                    if (smart.getKind() != TypeKind.ARRAY) continue;
                    try {
                        TypeMirror tm = smart;
                        while (tm.getKind() == TypeKind.ARRAY) {
                            tm = ((ArrayType)tm).getComponentType();
                        }
                        if (tm.getKind().isPrimitive() && this.startsWith(env, tm.toString())) {
                            this.results.add(this.itemFactory.createArrayItem((CompilationInfo)env.getController(), (ArrayType)smart, this.anchorOffset, env.getReferencesCount(), env.getController().getElements()));
                            continue;
                        }
                        if (tm.getKind() != TypeKind.DECLARED && tm.getKind() != TypeKind.ERROR || !this.startsWith(env, ((DeclaredType)tm).asElement().getSimpleName().toString())) continue;
                        this.results.add(this.itemFactory.createArrayItem((CompilationInfo)env.getController(), (ArrayType)smart, this.anchorOffset, env.getReferencesCount(), env.getController().getElements()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            this.addLocalMembersAndVars(env);
            this.addClassTypes(env, null);
            this.addPrimitiveTypeKeywords(env);
            this.addValueKeywords(env);
        } else {
            this.insideExpression(env, new TreePath(path, exp));
        }
    }

    private void insideTypeCheck(BaseTask.Env env) throws IOException {
        InstanceOfTree iot = (InstanceOfTree)env.getPath().getLeaf();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, iot, env.getOffset());
        if (ts != null && ts.token().id() == JavaTokenId.INSTANCEOF) {
            this.addClassTypes(env, null);
        }
    }

    private void insideArrayAccess(BaseTask.Env env) throws IOException {
        String aatText;
        int bPos;
        Tree expr;
        CompilationUnitTree root;
        int offset = env.getOffset();
        ArrayAccessTree aat = (ArrayAccessTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int aaTextStart = (int)sourcePositions.getEndPosition(root = env.getRoot(), aat.getExpression());
        if ((long)aaTextStart != -1L && ((expr = this.unwrapErrTree(aat.getIndex())) == null || offset <= (int)sourcePositions.getStartPosition(root, expr)) && (bPos = (aatText = env.getController().getText().substring(aaTextStart, offset)).indexOf(91)) > -1) {
            this.localResult(env);
            this.addValueKeywords(env);
        }
    }

    private void insideNewArray(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        TreePath path = env.getPath();
        NewArrayTree nat = (NewArrayTree)path.getLeaf();
        if (nat.getInitializers() != null) {
            Tree init;
            int pos;
            SourcePositions sourcePositions = env.getSourcePositions();
            CompilationUnitTree root = env.getRoot();
            Tree last = null;
            int lastPos = offset;
            Iterator<? extends ExpressionTree> iterator = nat.getInitializers().iterator();
            while (iterator.hasNext() && (long)(pos = (int)sourcePositions.getEndPosition(root, init = (Tree)iterator.next())) != -1L && offset > pos) {
                last = init;
                lastPos = pos;
            }
            if (last != null) {
                TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, lastPos, offset);
                if (ts != null && ts.token().id() == JavaTokenId.COMMA) {
                    TreePath parentPath = path.getParentPath();
                    TreePath gparentPath = parentPath.getParentPath();
                    if (gparentPath.getLeaf().getKind() == Tree.Kind.ANNOTATION && parentPath.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                        ExpressionTree var = ((AssignmentTree)parentPath.getLeaf()).getVariable();
                        if (var.getKind() == Tree.Kind.IDENTIFIER) {
                            this.insideAnnotationAttribute(env, gparentPath, ((IdentifierTree)var).getName());
                            this.addLocalConstantsAndTypes(env);
                        }
                    } else {
                        this.localResult(env);
                        this.addValueKeywords(env);
                    }
                }
                return;
            }
        }
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, nat, offset);
        switch ((JavaTokenId)ts.token().id()) {
            case LBRACKET: 
            case LBRACE: {
                TreePath parentPath = path.getParentPath();
                TreePath gparentPath = parentPath.getParentPath();
                if (gparentPath.getLeaf().getKind() == Tree.Kind.ANNOTATION && parentPath.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    ExpressionTree var = ((AssignmentTree)parentPath.getLeaf()).getVariable();
                    if (var.getKind() != Tree.Kind.IDENTIFIER) break;
                    this.insideAnnotationAttribute(env, gparentPath, ((IdentifierTree)var).getName());
                    this.addLocalConstantsAndTypes(env);
                    break;
                }
                this.localResult(env);
                this.addValueKeywords(env);
                break;
            }
            case RBRACKET: {
                if (nat.getDimensions().size() <= 0) break;
                this.insideExpression(env, path);
            }
        }
    }

    private void insideAssignment(BaseTask.Env env) throws IOException {
        CompilationUnitTree root;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        AssignmentTree as = (AssignmentTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int asTextStart = (int)sourcePositions.getEndPosition(root = env.getRoot(), as.getVariable());
        if ((long)asTextStart != -1L) {
            Tree expr = this.unwrapErrTree(as.getExpression());
            if (expr == null || offset <= (int)sourcePositions.getStartPosition(root, expr)) {
                CompilationController controller = env.getController();
                String asText = controller.getText().substring(asTextStart, offset);
                int eqPos = asText.indexOf(61);
                if (eqPos > -1) {
                    TreePath parentPath = path.getParentPath();
                    if (parentPath.getLeaf().getKind() != Tree.Kind.ANNOTATION) {
                        this.localResult(env);
                        this.addValueKeywords(env);
                    } else if (as.getVariable().getKind() == Tree.Kind.IDENTIFIER) {
                        this.insideAnnotationAttribute(env, parentPath, ((IdentifierTree)as.getVariable()).getName());
                        this.addLocalConstantsAndTypes(env);
                    }
                }
            } else {
                this.insideExpression(env, new TreePath(path, expr));
            }
        }
    }

    private void insideCompoundAssignment(BaseTask.Env env) throws IOException {
        String catText;
        int eqPos;
        Tree expr;
        CompilationUnitTree root;
        int offset = env.getOffset();
        CompoundAssignmentTree cat = (CompoundAssignmentTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int catTextStart = (int)sourcePositions.getEndPosition(root = env.getRoot(), cat.getVariable());
        if ((long)catTextStart != -1L && ((expr = this.unwrapErrTree(cat.getExpression())) == null || offset <= (int)sourcePositions.getStartPosition(root, expr)) && (eqPos = (catText = env.getController().getText().substring(catTextStart, offset)).indexOf(61)) > -1) {
            this.localResult(env);
            this.addValueKeywords(env);
        }
    }

    private void insideStringLiteral(BaseTask.Env env) throws IOException {
        ExpressionTree var;
        TreePath path = env.getPath();
        TreePath parentPath = path.getParentPath();
        TreePath grandParentPath = parentPath.getParentPath();
        if (grandParentPath != null && grandParentPath.getLeaf().getKind() == Tree.Kind.ANNOTATION && parentPath.getLeaf().getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)parentPath.getLeaf()).getExpression() == path.getLeaf() && (var = ((AssignmentTree)parentPath.getLeaf()).getVariable()).getKind() == Tree.Kind.IDENTIFIER) {
            this.insideAnnotationAttribute(env, grandParentPath, ((IdentifierTree)var).getName());
        }
    }

    private void insideBinaryTree(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        CompilationUnitTree root;
        int offset = env.getOffset();
        TreePath path = env.getPath();
        BinaryTree bi = (BinaryTree)path.getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int pos = (int)sourcePositions.getEndPosition(root = env.getRoot(), bi.getRightOperand());
        if ((long)pos != -1L && pos < offset) {
            return;
        }
        pos = (int)sourcePositions.getEndPosition(root, bi.getLeftOperand());
        if ((long)pos != -1L && (last = this.findLastNonWhitespaceToken(env, pos, offset)) != null) {
            TypeMirror tm;
            CompilationController controller = env.getController();
            controller.toPhase(JavaSource.Phase.RESOLVED);
            TypeMirror typeMirror = tm = last.token().id() == JavaTokenId.AMP ? controller.getTrees().getTypeMirror(new TreePath(path, bi.getLeftOperand())) : null;
            if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                env.addToExcludes(((DeclaredType)tm).asElement());
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
            } else if (tm != null && tm.getKind() == TypeKind.INTERSECTION) {
                for (TypeMirror typeMirror2 : ((IntersectionType)tm).getBounds()) {
                    if (typeMirror2.getKind() != TypeKind.DECLARED) continue;
                    env.addToExcludes(((DeclaredType)typeMirror2).asElement());
                }
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
            } else {
                this.localResult(env);
                this.addValueKeywords(env);
            }
        }
    }

    private void insideConditionalExpression(BaseTask.Env env) throws IOException {
        TokenSequence<JavaTokenId> last;
        CompilationUnitTree root;
        ConditionalExpressionTree co = (ConditionalExpressionTree)env.getPath().getLeaf();
        SourcePositions sourcePositions = env.getSourcePositions();
        int coTextStart = (int)sourcePositions.getStartPosition(root = env.getRoot(), co);
        if ((long)coTextStart != -1L && (last = this.findLastNonWhitespaceToken(env, coTextStart, env.getOffset())) != null && (last.token().id() == JavaTokenId.QUESTION || last.token().id() == JavaTokenId.COLON)) {
            this.localResult(env);
            this.addValueKeywords(env);
        }
    }

    private void insideExpressionStatement(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        ExpressionStatementTree est = (ExpressionStatementTree)path.getLeaf();
        CompilationController controller = env.getController();
        Tree t = est.getExpression();
        if (t.getKind() == Tree.Kind.ERRONEOUS) {
            Iterator<? extends Tree> it = ((ErroneousTree)t).getErrorTrees().iterator();
            if (it.hasNext()) {
                t = it.next();
            } else {
                this.localResult(env);
                Tree parentTree = path.getParentPath().getLeaf();
                switch (parentTree.getKind()) {
                    case FOR_LOOP: {
                        if (((ForLoopTree)parentTree).getStatement() == est) {
                            this.addKeywordsForStatement(env);
                            break;
                        }
                        this.addValueKeywords(env);
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        if (((EnhancedForLoopTree)parentTree).getStatement() == est) {
                            this.addKeywordsForStatement(env);
                            break;
                        }
                        this.addValueKeywords(env);
                        break;
                    }
                    case VARIABLE: {
                        this.addValueKeywords(env);
                        break;
                    }
                    case LAMBDA_EXPRESSION: {
                        this.addValueKeywords(env);
                        break;
                    }
                    default: {
                        this.addKeywordsForStatement(env);
                    }
                }
                return;
            }
        }
        TreePath tPath = new TreePath(path, t);
        if (t.getKind() == Tree.Kind.MODIFIERS) {
            this.insideModifiers(env, tPath);
        } else if (t.getKind() == Tree.Kind.MEMBER_SELECT && ERROR.contentEquals(((MemberSelectTree)t).getIdentifier())) {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePath expPath = new TreePath(tPath, ((MemberSelectTree)t).getExpression());
            TypeMirror type = controller.getTrees().getTypeMirror(expPath);
            switch (type.getKind()) {
                case TYPEVAR: {
                    type = ((TypeVariable)type).getUpperBound();
                    if (type == null) {
                        return;
                    }
                    type = controller.getTypes().capture(type);
                }
                case ARRAY: 
                case DECLARED: 
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    this.addMembers(env, type, controller.getTrees().getElement(expPath), EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT}), null, false, false, false);
                    break;
                }
                default: {
                    Element el = controller.getTrees().getElement(expPath);
                    if (el instanceof PackageElement) {
                        this.addPackageContent(env, (PackageElement)el, EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.ENUM_CONSTANT}), null, false, false);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.insideExpression(env, tPath);
        }
    }

    private void insideExpression(BaseTask.Env env, TreePath exPath) throws IOException {
        Element e;
        Tree t;
        Object tm;
        TokenSequence<JavaTokenId> last;
        int offset = env.getOffset();
        String prefix = env.getPrefix();
        Tree et = exPath.getLeaf();
        Tree parent = exPath.getParentPath().getLeaf();
        final CompilationController controller = env.getController();
        int endPos = (int)env.getSourcePositions().getEndPosition(env.getRoot(), et);
        if ((long)endPos != -1L && endPos < offset && (last = this.findLastNonWhitespaceToken(env, endPos, offset)) != null && last.token().id() != JavaTokenId.COMMA) {
            return;
        }
        controller.toPhase(JavaSource.Phase.RESOLVED);
        ElementKind varKind = ElementKind.LOCAL_VARIABLE;
        Set<Modifier> varMods = EnumSet.noneOf(Modifier.class);
        if (parent.getKind() == Tree.Kind.VARIABLE) {
            varMods = ((VariableTree)parent).getModifiers().getFlags();
            Element varEl = controller.getTrees().getElement(exPath.getParentPath());
            if (varEl != null) {
                varKind = varEl.getKind();
            }
        }
        if (et.getKind() == Tree.Kind.ANNOTATED_TYPE) {
            et = ((AnnotatedTypeTree)et).getUnderlyingType();
            exPath = new TreePath(exPath, et);
        }
        if (parent.getKind() != Tree.Kind.PARENTHESIZED && (et.getKind() == Tree.Kind.PRIMITIVE_TYPE || et.getKind() == Tree.Kind.ARRAY_TYPE || et.getKind() == Tree.Kind.PARAMETERIZED_TYPE)) {
            tm = controller.getTrees().getTypeMirror(exPath);
            final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
            Scope scope = env.getScope();
            final ExecutableElement method = scope.getEnclosingMethod();
            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror t) {
                    return (method == null || method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE).contains((Object)JavaCompletionTask.simplifyElementKind(e.getKind())) && controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && !illegalForwardRefs.containsKey(e.getSimpleName());
                }
            };
            for (String name : Utilities.varNamesSuggestions((TypeMirror)tm, varKind, varMods, null, prefix, controller.getTypes(), controller.getElements(), controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), CodeStyle.getDefault((Document)controller.getDocument()))) {
                this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), name, this.anchorOffset, true, false));
            }
            return;
        }
        if (et.getKind() == Tree.Kind.UNION_TYPE) {
            tm = ((UnionTypeTree)et).getTypeAlternatives().iterator();
            while (tm.hasNext()) {
                et = t = (Tree)tm.next();
                exPath = new TreePath(exPath, t);
            }
        }
        if (et.getKind() == Tree.Kind.IDENTIFIER) {
            Element e2 = controller.getTrees().getElement(exPath);
            if (e2 == null) {
                return;
            }
            TypeMirror tm2 = controller.getTrees().getTypeMirror(exPath);
            switch (JavaCompletionTask.simplifyElementKind(e2.getKind())) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case PACKAGE: {
                    VariableElement ve;
                    if (parent.getKind() != Tree.Kind.PARENTHESIZED || env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0) {
                        final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
                        Scope scope = env.getScope();
                        final ExecutableElement method = scope.getEnclosingMethod();
                        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element e, TypeMirror t) {
                                return (method == null || method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE).contains((Object)JavaCompletionTask.simplifyElementKind(e.getKind())) && controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && !illegalForwardRefs.containsKey(e.getSimpleName());
                            }
                        };
                        for (String name : Utilities.varNamesSuggestions(tm2, varKind, varMods, null, prefix, controller.getTypes(), controller.getElements(), controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), CodeStyle.getDefault((Document)controller.getDocument()))) {
                            this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), name, this.anchorOffset, true, false));
                        }
                    }
                    if ((ve = this.getFieldOrVar(env, e2.getSimpleName().toString())) == null) break;
                    this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                    break;
                }
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case FIELD: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    TypeElement te;
                    if (tm2 != null && (tm2.getKind() == TypeKind.DECLARED || tm2.getKind() == TypeKind.ARRAY || tm2.getKind() == TypeKind.ERROR)) {
                        this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                    }
                    if ((te = this.getTypeElement(env, e2.getSimpleName().toString())) == null) break;
                    final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
                    Scope scope = env.getScope();
                    final ExecutableElement method = scope.getEnclosingMethod();
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            return (method == null || method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE).contains((Object)JavaCompletionTask.simplifyElementKind(e.getKind())) && controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && !illegalForwardRefs.containsKey(e.getSimpleName());
                        }
                    };
                    for (String name : Utilities.varNamesSuggestions(controller.getTypes().getDeclaredType(te, new TypeMirror[0]), varKind, varMods, null, prefix, controller.getTypes(), controller.getElements(), controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), CodeStyle.getDefault((Document)controller.getDocument()))) {
                        this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), name, this.anchorOffset, true, false));
                    }
                    break;
                }
            }
            return;
        }
        Tree exp = null;
        if (et.getKind() == Tree.Kind.PARENTHESIZED) {
            exp = ((ParenthesizedTree)et).getExpression();
        } else if (et.getKind() == Tree.Kind.TYPE_CAST) {
            if (env.getSourcePositions().getEndPosition(env.getRoot(), ((TypeCastTree)et).getType()) <= (long)offset) {
                exp = ((TypeCastTree)et).getType();
            }
        } else if (et.getKind() == Tree.Kind.ASSIGNMENT && (t = ((AssignmentTree)et).getExpression()).getKind() == Tree.Kind.PARENTHESIZED && env.getSourcePositions().getEndPosition(env.getRoot(), t) < (long)offset) {
            exp = ((ParenthesizedTree)t).getExpression();
        }
        if (exp != null) {
            exPath = new TreePath(exPath, exp);
            if (exp.getKind() == Tree.Kind.PRIMITIVE_TYPE || exp.getKind() == Tree.Kind.ARRAY_TYPE || exp.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                this.localResult(env);
                this.addValueKeywords(env);
                return;
            }
            e = controller.getTrees().getElement(exPath);
            if (e == null) {
                if (exp.getKind() == Tree.Kind.TYPE_CAST) {
                    this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                }
                return;
            }
            TypeMirror tm3 = controller.getTrees().getTypeMirror(exPath);
            switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case PACKAGE: {
                    if (exp.getKind() == Tree.Kind.IDENTIFIER) {
                        VariableElement ve = this.getFieldOrVar(env, e.getSimpleName().toString());
                        if (ve != null) {
                            this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                        }
                        if (ve != null && tm3 != null && tm3.getKind() == TypeKind.ERROR) break;
                        this.localResult(env);
                        this.addValueKeywords(env);
                        break;
                    }
                    if (exp.getKind() == Tree.Kind.MEMBER_SELECT) {
                        if (tm3 != null && (tm3.getKind() == TypeKind.ERROR || tm3.getKind() == TypeKind.PACKAGE)) {
                            this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                        }
                        this.localResult(env);
                        this.addValueKeywords(env);
                        break;
                    }
                    if (exp.getKind() != Tree.Kind.PARENTHESIZED || tm3 == null || tm3.getKind() != TypeKind.DECLARED && tm3.getKind() != TypeKind.ARRAY) break;
                    this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                    break;
                }
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case FIELD: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    TypeElement te;
                    if (tm3 != null && (tm3.getKind() == TypeKind.DECLARED || tm3.getKind() == TypeKind.ARRAY || tm3.getKind() == TypeKind.ERROR)) {
                        this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                    }
                    if ((te = this.getTypeElement(env, e.getSimpleName().toString())) == null && exp.getKind() != Tree.Kind.MEMBER_SELECT) break;
                    this.localResult(env);
                    this.addValueKeywords(env);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    if (tm3 == null || tm3.getKind() != TypeKind.DECLARED && tm3.getKind() != TypeKind.ARRAY && tm3.getKind() != TypeKind.ERROR) break;
                    this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
                }
            }
            return;
        }
        e = controller.getTrees().getElement(exPath);
        TypeMirror tm4 = controller.getTrees().getTypeMirror(exPath);
        if (e == null) {
            if (tm4 != null && (tm4.getKind() == TypeKind.DECLARED || tm4.getKind() == TypeKind.ARRAY)) {
                this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
            }
            return;
        }
        switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case PACKAGE: {
                final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
                Scope scope = env.getScope();
                final ExecutableElement method = scope.getEnclosingMethod();
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror t) {
                        return (method == null || method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE).contains((Object)JavaCompletionTask.simplifyElementKind(e.getKind())) && controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && !illegalForwardRefs.containsKey(e.getSimpleName());
                    }
                };
                for (String name : Utilities.varNamesSuggestions(tm4, varKind, varMods, null, prefix, controller.getTypes(), controller.getElements(), controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), CodeStyle.getDefault((Document)controller.getDocument()))) {
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), name, this.anchorOffset, true, false));
                }
                break;
            }
            case ENUM_CONSTANT: 
            case EXCEPTION_PARAMETER: 
            case FIELD: 
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case PARAMETER: 
            case CONSTRUCTOR: 
            case METHOD: {
                if (tm4 == null || tm4.getKind() != TypeKind.DECLARED && tm4.getKind() != TypeKind.ARRAY && tm4.getKind() != TypeKind.ERROR) break;
                this.addKeyword(env, INSTANCEOF_KEYWORD, SPACE, false);
            }
        }
    }

    private void insideBreakOrContinue(BaseTask.Env env) throws IOException {
        TreePath path = env.getPath();
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, path.getLeaf(), env.getOffset());
        if (ts != null && (ts.token().id() == JavaTokenId.BREAK || ts.token().id() == JavaTokenId.CONTINUE)) {
            while (path != null) {
                if (path.getLeaf().getKind() == Tree.Kind.LABELED_STATEMENT) {
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), ((LabeledStatementTree)path.getLeaf()).getLabel().toString(), this.anchorOffset, false, false));
                }
                path = path.getParentPath();
            }
        }
    }

    private void addClassTypes(BaseTask.Env env, DeclaredType baseType) throws IOException {
        EnumSet<ElementKind> classKinds = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.TYPE_PARAMETER);
        if (this.isRecordSupported(env)) {
            classKinds.add(ElementKind.RECORD);
        }
        this.addTypes(env, classKinds, baseType);
    }

    private boolean isRecordSupported(BaseTask.Env env) {
        return env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_14) >= 0;
    }

    private boolean isSealedSupported(BaseTask.Env env) {
        return env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_15) >= 0;
    }

    private void insideRecord(BaseTask.Env env) throws IOException {
        TypeParameterTree tp;
        int tpPos;
        TokenSequence<JavaTokenId> first;
        Tree impl;
        int implPos;
        String headerText;
        int idx;
        int offset = env.getOffset();
        env.insideClass();
        TreePath path = env.getPath();
        ClassTree cls = (ClassTree)path.getLeaf();
        CompilationController controller = env.getController();
        SourcePositions sourcePositions = env.getSourcePositions();
        CompilationUnitTree root = env.getRoot();
        int startPos = (int)sourcePositions.getEndPosition(root, cls.getModifiers());
        if (startPos <= 0) {
            startPos = (int)sourcePositions.getStartPosition(root, cls);
        }
        if ((idx = (headerText = controller.getText().substring(startPos, offset)).indexOf(123)) >= 0) {
            this.addKeywordsForClassBody(env);
            this.addClassTypes(env, null);
            this.addElementCreators(env);
            return;
        }
        TreeUtilities tu = controller.getTreeUtilities();
        Tree lastImpl = null;
        Iterator<? extends Tree> iterator = cls.getImplementsClause().iterator();
        while (iterator.hasNext() && (long)(implPos = (int)sourcePositions.getEndPosition(root, impl = iterator.next())) != -1L && offset > implPos) {
            lastImpl = impl;
            startPos = implPos;
        }
        if (lastImpl != null) {
            TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, startPos, offset);
            if (last != null && last.token().id() == JavaTokenId.COMMA) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
            }
            return;
        }
        List<? extends Tree> members = cls.getMembers();
        Tree lastParam = null;
        for (Tree tree : members) {
            ModifiersTree modifiers;
            Set<Modifier> modifierSet;
            if (tree.getKind() == Tree.Kind.VARIABLE && !(modifierSet = (modifiers = ((VariableTree)tree).getModifiers()).getFlags()).contains((Object)Modifier.STATIC)) {
                int paramPos = (int)sourcePositions.getEndPosition(root, tree);
                if ((long)paramPos == -1L || offset <= paramPos) break;
                lastParam = tree;
                startPos = paramPos;
            }
            if (lastParam == null) continue;
            first = this.findFirstNonWhitespaceToken(env, startPos, offset);
            if (first != null && first.token().id() == JavaTokenId.COMMA) {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                env.addToExcludes(controller.getTrees().getElement(path));
                this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                return;
            }
            if (first != null && first.token().id() == JavaTokenId.RPAREN) {
                first = this.nextNonWhitespaceToken(first);
                if (!tu.isInterface(cls) && first.token().id() == JavaTokenId.LBRACE) {
                    this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                }
            }
            return;
        }
        TypeParameterTree lastTypeParam = null;
        Iterator<? extends TypeParameterTree> iterator2 = cls.getTypeParameters().iterator();
        while (iterator2.hasNext() && (long)(tpPos = (int)sourcePositions.getEndPosition(root, tp = iterator2.next())) != -1L && offset > tpPos) {
            lastTypeParam = tp;
            startPos = tpPos;
        }
        TokenSequence<JavaTokenId> tokenSequence = this.findLastNonWhitespaceToken(env, startPos, offset);
        if (tokenSequence != null) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case LPAREN: {
                    this.addMemberModifiers(env, Collections.emptySet(), true);
                    this.addClassTypes(env, null);
                    break;
                }
                case IMPLEMENTS: {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    env.addToExcludes(controller.getTrees().getElement(path));
                    this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                    break;
                }
                case RPAREN: {
                    if (tu.isAnnotation(cls) || tu.isInterface(cls)) break;
                    this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                }
            }
            return;
        }
        if (lastTypeParam != null) {
            first = this.findFirstNonWhitespaceToken(env, startPos, offset);
            if (first != null && (first.token().id() == JavaTokenId.GT || first.token().id() == JavaTokenId.GTGT || first.token().id() == JavaTokenId.GTGTGT)) {
                first = this.nextNonWhitespaceToken(first);
                TokenSequence<JavaTokenId> last = this.findLastNonWhitespaceToken(env, first.offset(), offset);
                TokenSequence<JavaTokenId> old = first;
                first = this.nextNonWhitespaceToken(first);
                first = last != null && first.token().id() == last.token().id() ? this.nextNonWhitespaceToken(first) : old;
                if (first != null && first.offset() < offset) {
                    if (first.token().id() == JavaTokenId.EXTENDS) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.afterExtends();
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addTypes(env, tu.isInterface(cls) ? EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE) : EnumSet.of(ElementKind.CLASS), null);
                        return;
                    }
                    if (first.token().id() == JavaTokenId.IMPLEMENTS) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                        return;
                    }
                } else if (!tu.isAnnotation(cls)) {
                    if (!tu.isInterface(cls) && first.token().id() == JavaTokenId.LBRACE) {
                        this.addKeyword(env, IMPLEMENTS_KEYWORD, SPACE, false);
                    } else if (!tu.isInterface(cls) && first.token().id() == JavaTokenId.RPAREN) {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        env.addToExcludes(controller.getTrees().getElement(path));
                        this.addTypes(env, EnumSet.of(ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE), null);
                    }
                    return;
                }
            } else if (lastTypeParam.getBounds().isEmpty()) {
                this.addKeyword(env, EXTENDS_KEYWORD, SPACE, false);
            }
            return;
        }
        TokenSequence<JavaTokenId> tokenSequence2 = this.findLastNonWhitespaceToken(env, (int)sourcePositions.getStartPosition(root, cls), offset);
        if (tokenSequence2 != null && tokenSequence2.token().id() == JavaTokenId.AT) {
            this.addKeyword(env, INTERFACE_KEYWORD, SPACE, false);
            this.addTypes(env, EnumSet.of(ElementKind.ANNOTATION_TYPE), null);
        } else if (path.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
            this.addClassModifiers(env, cls.getModifiers().getFlags());
        } else {
            this.addMemberModifiers(env, cls.getModifiers().getFlags(), false);
            this.addClassTypes(env, null);
        }
    }

    private void localResult(BaseTask.Env env) throws IOException {
        this.addLocalMembersAndVars(env);
        this.addClassTypes(env, null);
        this.addPrimitiveTypeKeywords(env);
    }

    private void addLocalConstantsAndTypes(BaseTask.Env env) throws IOException {
        String prefix = env.getPrefix();
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        final Types types = controller.getTypes();
        final Trees trees = controller.getTrees();
        final Scope scope = env.getScope();
        Set<TypeMirror> smartTypes = null;
        boolean smartType = false;
        if (!this.options.contains((Object)Options.ALL_COMPLETION) && (smartTypes = this.getSmartTypes(env)) != null) {
            for (TypeMirror st : smartTypes) {
                if (st.getKind() == TypeKind.BOOLEAN) {
                    smartType = true;
                }
                if (st.getKind().isPrimitive()) {
                    st = types.boxedClass((PrimitiveType)st).asType();
                }
                if (st.getKind() != TypeKind.DECLARED) continue;
                final DeclaredType type = (DeclaredType)st;
                TypeElement element = (TypeElement)type.asElement();
                if (element.getKind() == ElementKind.ANNOTATION_TYPE && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element))) {
                    this.results.add(this.itemFactory.createAnnotationItem((CompilationInfo)env.getController(), element, type, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(element)));
                }
                if (JAVA_LANG_CLASS.contentEquals(element.getQualifiedName())) {
                    this.addTypeDotClassMembers(env, type);
                }
                if (!this.startsWith(env, element.getSimpleName().toString(), prefix)) continue;
                final boolean isStatic = element.getKind().isClass() || element.getKind().isInterface();
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror t) {
                        return (e.getKind() == ElementKind.ENUM_CONSTANT || e.getKind() == ElementKind.FIELD && ((VariableElement)e).getConstantValue() != null) && (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && trees.isAccessible(scope, e, (DeclaredType)t) && types.isAssignable(((VariableElement)e).asType(), type);
                    }
                };
                for (Element ee : controller.getElementUtilities().getMembers((TypeMirror)type, acceptor)) {
                    if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated(ee)) continue;
                    this.results.add(this.itemFactory.createStaticMemberItem((CompilationInfo)env.getController(), type, ee, this.asMemberOf(ee, type, types), false, this.anchorOffset, elements.isDeprecated(ee), false));
                }
            }
        }
        if (env.getPath().getLeaf().getKind() != Tree.Kind.CASE) {
            if (Utilities.startsWith(FALSE_KEYWORD, prefix)) {
                this.results.add(this.itemFactory.createKeywordItem(FALSE_KEYWORD, null, this.anchorOffset, smartType));
            }
            if (Utilities.startsWith(TRUE_KEYWORD, prefix)) {
                this.results.add(this.itemFactory.createKeywordItem(TRUE_KEYWORD, null, this.anchorOffset, smartType));
            }
        }
        TypeElement enclClass = scope.getEnclosingClass();
        for (Element e : this.getLocalMembersAndVars(env)) {
            switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                case FIELD: {
                    if (((VariableElement)e).getConstantValue() == null) break;
                    TypeMirror tm = this.asMemberOf(e, enclClass != null ? enclClass.asType() : null, types);
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, tm, this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                    break;
                }
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    if (((VariableElement)e).getConstantValue() == null) break;
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, e.asType(), this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, e.asType(), smartTypes), env.assignToVarPos()));
                }
            }
        }
        this.addClassTypes(env, null);
    }

    private void addLocalMembersAndVars(final BaseTask.Env env) throws IOException {
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        Types types = controller.getTypes();
        final Trees trees = controller.getTrees();
        final Scope scope = env.getScope();
        Iterable<Element> locals = this.getLocalMembersAndVars(env);
        Set<TypeMirror> smartTypes = null;
        if (!this.options.contains((Object)Options.ALL_COMPLETION)) {
            smartTypes = this.getSmartTypes(env);
            if (smartTypes != null) {
                for (TypeMirror st : smartTypes) {
                    if (st.getKind().isPrimitive()) {
                        st = types.boxedClass((PrimitiveType)st).asType();
                    }
                    if (st.getKind() != TypeKind.DECLARED) continue;
                    DeclaredType type = (DeclaredType)st;
                    TypeElement element = (TypeElement)type.asElement();
                    if (JAVA_LANG_CLASS.contentEquals(element.getQualifiedName())) {
                        this.addTypeDotClassMembers(env, type);
                    } else if (controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && elements.isFunctionalInterface(element) && this.itemFactory instanceof LambdaItemFactory) {
                        this.results.add(((LambdaItemFactory)this.itemFactory).createLambdaItem((CompilationInfo)env.getController(), element, type, this.anchorOffset, true, env.addSemicolon()));
                        if (controller.getElementUtilities().getDescriptorElement(element).getReturnType().getKind() != TypeKind.VOID) {
                            this.results.add(((LambdaItemFactory)this.itemFactory).createLambdaItem((CompilationInfo)env.getController(), element, type, this.anchorOffset, false, env.addSemicolon()));
                        }
                    }
                    final boolean startsWith = this.startsWith(env, element.getSimpleName().toString());
                    final boolean withinScope = this.withinScope(env, element);
                    if (withinScope && scope.getEnclosingClass() == element) continue;
                    final boolean isStatic = element.getKind().isClass() || element.getKind().isInterface();
                    final Set<TypeMirror> finalSmartTypes = smartTypes;
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            return (startsWith || JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString())) && (!e.getSimpleName().contentEquals(JavaCompletionTask.CLASS_KEYWORD) && !withinScope && (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) || withinScope && e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD)) && trees.isAccessible(scope, e, (DeclaredType)t) && (e.getKind().isField() && JavaCompletionTask.this.isOfSmartType(env, ((VariableElement)e).asType(), finalSmartTypes) || e.getKind() == ElementKind.METHOD && JavaCompletionTask.this.isOfSmartType(env, ((ExecutableElement)e).getReturnType(), finalSmartTypes));
                        }
                    };
                    for (Element ee : controller.getElementUtilities().getMembers((TypeMirror)type, acceptor)) {
                        if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated(ee)) continue;
                        this.results.add(this.itemFactory.createStaticMemberItem((CompilationInfo)env.getController(), type, ee, this.asMemberOf(ee, type, types), false, this.anchorOffset, elements.isDeprecated(ee), env.addSemicolon()));
                    }
                }
            }
        } else {
            this.addChainedMembers(env, locals);
            this.addAllStaticMemberNames(env);
        }
        TypeElement enclClass = scope.getEnclosingClass();
        List<ExecutableElement> methodsIn = null;
        for (Element e : locals) {
            switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, e.asType(), this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, e.asType(), smartTypes), env.assignToVarPos()));
                    break;
                }
                case FIELD: {
                    String name = e.getSimpleName().toString();
                    if (THIS_KEYWORD.equals(name) || SUPER_KEYWORD.equals(name)) {
                        this.results.add(this.itemFactory.createKeywordItem(name, null, this.anchorOffset, this.isOfSmartType(env, e.asType(), smartTypes)));
                        break;
                    }
                    TypeMirror tm = this.asMemberOf(e, enclClass != null ? enclClass.asType() : null, types);
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, tm, this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                    break;
                }
                case METHOD: {
                    if (methodsIn == null) {
                        methodsIn = ElementFilter.methodsIn(locals);
                    }
                    ExecutableType et = (ExecutableType)this.asMemberOf(e, enclClass != null ? enclClass.asType() : null, types);
                    if (e.getEnclosingElement() != enclClass && JavaCompletionTask.conflictsWithLocalMethods(e.getSimpleName(), enclClass, methodsIn)) {
                        this.results.add(this.itemFactory.createStaticMemberItem((CompilationInfo)env.getController(), (DeclaredType)e.getEnclosingElement().asType(), e, et, false, this.anchorOffset, elements.isDeprecated(e), env.addSemicolon()));
                        break;
                    }
                    this.results.add(this.itemFactory.createExecutableItem((CompilationInfo)env.getController(), (ExecutableElement)e, et, this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), false, env.addSemicolon(), this.isOfSmartType(env, this.getCorrectedReturnType(env, et, (ExecutableElement)e, enclClass != null ? enclClass.asType() : null), smartTypes), env.assignToVarPos(), false));
                }
            }
        }
    }

    private void addLocalFieldsAndVars(BaseTask.Env env) throws IOException {
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        Types types = controller.getTypes();
        Scope scope = env.getScope();
        Set<TypeMirror> smartTypes = this.options.contains((Object)Options.ALL_COMPLETION) ? null : this.getSmartTypes(env);
        TypeElement enclClass = scope.getEnclosingClass();
        for (Element e : this.getLocalMembersAndVars(env)) {
            switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, e.asType(), this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, e.asType(), smartTypes), env.assignToVarPos()));
                    break;
                }
                case FIELD: {
                    String name = e.getSimpleName().toString();
                    if (THIS_KEYWORD.equals(name) || SUPER_KEYWORD.equals(name)) {
                        this.results.add(this.itemFactory.createKeywordItem(name, null, this.anchorOffset, this.isOfSmartType(env, e.asType(), smartTypes)));
                        break;
                    }
                    TypeMirror tm = this.asMemberOf(e, enclClass != null ? enclClass.asType() : null, types);
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, tm, this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                }
            }
        }
    }

    private void addEffectivelyFinalAutoCloseables(BaseTask.Env env) throws IOException {
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        TypeElement te = elements.getTypeElement("java.lang.AutoCloseable");
        if (te != null) {
            Types types = controller.getTypes();
            ElementUtilities eu = controller.getElementUtilities();
            Scope scope = env.getScope();
            Set<TypeMirror> smartTypes = this.options.contains((Object)Options.ALL_COMPLETION) ? null : this.getSmartTypes(env);
            TypeElement enclClass = scope.getEnclosingClass();
            for (Element e : this.getLocalMembersAndVars(env)) {
                switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case PARAMETER: {
                        if (!types.isSubtype(e.asType(), te.asType()) || !eu.isEffectivelyFinal((VariableElement)e)) break;
                        this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, e.asType(), this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, e.asType(), smartTypes), env.assignToVarPos()));
                        break;
                    }
                    case FIELD: {
                        if (!types.isSubtype(e.asType(), te.asType())) break;
                        String name = e.getSimpleName().toString();
                        if (THIS_KEYWORD.equals(name) || SUPER_KEYWORD.equals(name)) {
                            this.results.add(this.itemFactory.createKeywordItem(name, null, this.anchorOffset, this.isOfSmartType(env, e.asType(), smartTypes)));
                            break;
                        }
                        TypeMirror tm = this.asMemberOf(e, enclClass != null ? enclClass.asType() : null, types);
                        this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, tm, this.anchorOffset, null, env.getScope().getEnclosingClass() != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                    }
                }
            }
        }
    }

    private Iterable<? extends Element> getLocalMembersAndVars(final BaseTask.Env env) throws IOException {
        final String prefix = env.getPrefix();
        CompilationController controller = env.getController();
        final Elements elements = controller.getElements();
        final Trees trees = controller.getTrees();
        TreeUtilities tu = controller.getTreeUtilities();
        final ElementUtilities eu = controller.getElementUtilities();
        final Scope scope = env.getScope();
        final TypeElement enclClass = scope.getEnclosingClass();
        final boolean enclStatic = enclClass != null && enclClass.getModifiers().contains((Object)Modifier.STATIC);
        final boolean ctxStatic = enclClass != null && (tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic());
        final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
        final ExecutableElement method = scope.getEnclosingMethod() != null && scope.getEnclosingMethod().getEnclosingElement() == enclClass ? scope.getEnclosingMethod() : null;
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                boolean isStatic = ctxStatic || t != null && t.getKind() == TypeKind.DECLARED && ((DeclaredType)t).asElement() != enclClass && enclStatic;
                switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                    case CONSTRUCTOR: {
                        return false;
                    }
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case PARAMETER: {
                        return JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) && (method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && eu.isEffectivelyFinal((VariableElement)e) || method == null && (e.getEnclosingElement().getKind() == ElementKind.INSTANCE_INIT || e.getEnclosingElement().getKind() == ElementKind.STATIC_INIT || e.getEnclosingElement().getKind() == ElementKind.CONSTRUCTOR || e.getEnclosingElement().getKind() == ElementKind.METHOD && e.getEnclosingElement().getEnclosingElement().getKind() == ElementKind.FIELD)) && (!illegalForwardRefs.containsKey(e.getSimpleName()) || ((Element)illegalForwardRefs.get(e.getSimpleName())).getEnclosingElement() != e.getEnclosingElement());
                    }
                    case FIELD: {
                        if (e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) || e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD)) {
                            return Utilities.startsWith(e.getSimpleName().toString(), prefix) && !isStatic;
                        }
                    }
                    case ENUM_CONSTANT: {
                        return !(!JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) || illegalForwardRefs.containsValue(e) || isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || !trees.isAccessible(scope, e, (DeclaredType)t));
                    }
                    case METHOD: {
                        String sn = e.getSimpleName().toString();
                        return !(!JavaCompletionTask.this.startsWith(env, sn) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(scope, e, (DeclaredType)t) || Utilities.isExcludeMethods() && Utilities.isExcluded(eu.getElementName(e.getEnclosingElement(), true) + "." + sn));
                    }
                }
                return false;
            }
        };
        return controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor);
    }

    private void addTypeDotClassMembers(BaseTask.Env env, DeclaredType type) throws IOException {
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        Types types = controller.getTypes();
        Iterator<? extends TypeMirror> it = type.getTypeArguments().iterator();
        TypeMirror tm = it.hasNext() ? it.next() : elements.getTypeElement(JAVA_LANG_OBJECT).asType();
        Collection<DeclaredType> dts = null;
        if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror bound = ((WildcardType)tm).getSuperBound();
            if (bound != null) {
                if (bound.getKind() == TypeKind.DECLARED) {
                    dts = this.getSupertypesOf(env, (DeclaredType)bound);
                }
            } else {
                bound = ((WildcardType)tm).getExtendsBound();
                if (bound != null) {
                    if (bound.getKind() == TypeKind.DECLARED) {
                        dts = JAVA_LANG_OBJECT.contentEquals(((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName()) ? Collections.singleton((DeclaredType)elements.getTypeElement(JAVA_LANG_OBJECT).asType()) : this.getSubtypesOf(env, (DeclaredType)bound);
                    }
                } else {
                    dts = Collections.singleton((DeclaredType)elements.getTypeElement(JAVA_LANG_OBJECT).asType());
                }
            }
        } else if (tm.getKind() == TypeKind.DECLARED) {
            dts = Collections.singleton((DeclaredType)tm);
        }
        if (dts != null) {
            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror t) {
                    return e.getKind() == ElementKind.FIELD && e.getSimpleName().contentEquals(JavaCompletionTask.CLASS_KEYWORD);
                }
            };
            for (DeclaredType dt : dts) {
                if (!this.startsWith(env, dt.asElement().getSimpleName().toString())) continue;
                for (Element ee : controller.getElementUtilities().getMembers((TypeMirror)dt, acceptor)) {
                    this.results.add(this.itemFactory.createStaticMemberItem((CompilationInfo)env.getController(), dt, ee, this.asMemberOf(ee, dt, types), false, this.anchorOffset, elements.isDeprecated(ee), env.addSemicolon()));
                }
            }
        }
    }

    private void addChainedMembers(final BaseTask.Env env, Iterable<? extends Element> locals) throws IOException {
        final Set<TypeMirror> smartTypes = this.getSmartTypes(env);
        if (smartTypes != null && !smartTypes.isEmpty()) {
            CompilationController controller = env.getController();
            final Scope scope = env.getScope();
            TypeElement enclClass = scope.getEnclosingClass();
            Elements elements = controller.getElements();
            final Types types = controller.getTypes();
            final Trees trees = controller.getTrees();
            ElementUtilities eu = controller.getElementUtilities();
            for (Element element : locals) {
                TypeMirror localElementType = null;
                TypeMirror type = null;
                switch (JavaCompletionTask.simplifyElementKind(element.getKind())) {
                    case ENUM_CONSTANT: 
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case PARAMETER: {
                        type = localElementType = element.asType();
                        break;
                    }
                    case FIELD: {
                        String name = element.getSimpleName().toString();
                        if (THIS_KEYWORD.equals(name) || SUPER_KEYWORD.equals(name)) break;
                        type = localElementType = this.asMemberOf(element, enclClass != null ? enclClass.asType() : null, types);
                        break;
                    }
                    case METHOD: {
                        localElementType = this.asMemberOf(element, enclClass != null ? enclClass.asType() : null, types);
                        type = ((ExecutableType)localElementType).getReturnType();
                    }
                }
                if (type == null || type.getKind() != TypeKind.DECLARED || this.isOfSmartType(env, type, smartTypes)) continue;
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror t) {
                        switch (e.getKind()) {
                            case FIELD: {
                                if (e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) || e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD)) {
                                    return false;
                                }
                            }
                            case ENUM_CONSTANT: {
                                return trees.isAccessible(scope, e, (DeclaredType)t) && JavaCompletionTask.this.isOfSmartType(env, JavaCompletionTask.this.asMemberOf(e, t, types), smartTypes);
                            }
                            case METHOD: {
                                return trees.isAccessible(scope, e, (DeclaredType)t) && JavaCompletionTask.this.isOfSmartType(env, ((ExecutableType)JavaCompletionTask.this.asMemberOf(e, t, types)).getReturnType(), smartTypes);
                            }
                        }
                        return false;
                    }
                };
                for (Element e : eu.getMembers(type, acceptor)) {
                    if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e)) continue;
                    ArrayList<Element> chainedElements = new ArrayList<Element>(2);
                    chainedElements.add(element);
                    chainedElements.add(e);
                    ArrayList<TypeMirror> chainedTypes = new ArrayList<TypeMirror>(2);
                    chainedTypes.add(localElementType);
                    chainedTypes.add(this.asMemberOf(e, type, types));
                    this.results.add(this.itemFactory.createChainedMembersItem((CompilationInfo)env.getController(), chainedElements, chainedTypes, this.anchorOffset, elements.isDeprecated(element) || elements.isDeprecated(e), env.addSemicolon()));
                }
            }
        }
    }

    private void addAllStaticMemberNames(BaseTask.Env env) {
        String prefix = env.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            CompilationController controller = env.getController();
            Set<? extends Element> excludes = env.getExcludes();
            HashSet<ElementHandle> excludeHandles = null;
            if (excludes != null) {
                excludeHandles = new HashSet<ElementHandle>(excludes.size());
                for (Element element : excludes) {
                    excludeHandles.add(ElementHandle.create((Element)element));
                }
            }
            ClassIndex.NameKind kind = Utilities.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
            Iterable iterable = controller.getClasspathInfo().getClassIndex().getDeclaredSymbols(prefix, kind, EnumSet.allOf(ClassIndex.SearchScope.class));
            for (ClassIndex.Symbols symbols : iterable) {
                if (Utilities.isExcluded(symbols.getEnclosingType().getQualifiedName()) || excludeHandles != null && excludeHandles.contains(symbols.getEnclosingType()) || JavaCompletionTask.isAnnonInner((ElementHandle<TypeElement>)symbols.getEnclosingType())) continue;
                for (String name : symbols.getSymbols()) {
                    if (Utilities.isExcludeMethods() && Utilities.isExcluded(symbols.getEnclosingType().getQualifiedName() + '.' + name)) continue;
                    this.results.add(this.itemFactory.createStaticMemberItem((ElementHandle<TypeElement>)symbols.getEnclosingType(), name, this.anchorOffset, env.addSemicolon(), env.getReferencesCount(), controller.getSnapshot().getSource()));
                }
            }
        }
    }

    private void addMemberConstantsAndTypes(final BaseTask.Env env, TypeMirror type, Element elem) throws IOException {
        Set<TypeMirror> smartTypes = this.options.contains((Object)Options.ALL_COMPLETION) ? null : this.getSmartTypes(env);
        CompilationController controller = env.getController();
        final Elements elements = controller.getElements();
        Types types = controller.getTypes();
        final Trees trees = controller.getTrees();
        TypeElement typeElem = type.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)type).asElement() : null;
        final boolean isStatic = elem != null && (elem.getKind().isClass() || elem.getKind().isInterface() || elem.getKind() == ElementKind.TYPE_PARAMETER);
        final boolean isSuperCall = elem != null && elem.getKind().isField() && elem.getSimpleName().contentEquals(SUPER_KEYWORD);
        final Scope scope = env.getScope();
        TypeElement enclClass = scope.getEnclosingClass();
        final TypeMirror enclType = enclClass != null ? enclClass.asType() : null;
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                if (!JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) || isStatic && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                    return false;
                }
                switch (e.getKind()) {
                    case FIELD: {
                        if (((VariableElement)e).getConstantValue() == null && !JavaCompletionTask.CLASS_KEYWORD.contentEquals(e.getSimpleName())) {
                            return false;
                        }
                    }
                    case ENUM_CONSTANT: {
                        return (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && trees.isAccessible(scope, e, (DeclaredType)(isSuperCall && enclType != null ? enclType : t));
                    }
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: {
                        return (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && !Utilities.isExcluded(((TypeElement)e).getQualifiedName()) && trees.isAccessible(scope, e, (DeclaredType)t);
                    }
                }
                return false;
            }
        };
        for (Element e : controller.getElementUtilities().getMembers(type, acceptor)) {
            switch (e.getKind()) {
                case ENUM_CONSTANT: 
                case FIELD: {
                    String name = e.getSimpleName().toString();
                    if (CLASS_KEYWORD.equals(name)) {
                        this.results.add(this.itemFactory.createKeywordItem(name, null, this.anchorOffset, false));
                        break;
                    }
                    TypeMirror tm = this.asMemberOf(e, type, types);
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)e, tm, this.anchorOffset, null, typeElem != e.getEnclosingElement(), elements.isDeprecated(e), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                    break;
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    DeclaredType dt = (DeclaredType)this.asMemberOf(e, type, types);
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)e, dt, this.anchorOffset, null, elements.isDeprecated(e), false, env.isInsideClass(), true, false, false));
                }
            }
        }
    }

    private void addMethodReferences(final BaseTask.Env env, TypeMirror type, Element elem) throws IOException {
        Set<TypeMirror> smartTypes = this.getSmartTypes(env);
        final String prefix = env.getPrefix();
        CompilationController controller = env.getController();
        final Elements elements = controller.getElements();
        Types types = controller.getTypes();
        TreeUtilities tu = controller.getTreeUtilities();
        final ElementUtilities eu = controller.getElementUtilities();
        TypeElement typeElem = type.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)type).asElement() : null;
        boolean isThisCall = elem != null && elem.getKind().isField() && elem.getSimpleName().contentEquals(THIS_KEYWORD);
        final boolean isSuperCall = elem != null && elem.getKind().isField() && elem.getSimpleName().contentEquals(SUPER_KEYWORD);
        final Scope scope = env.getScope();
        if ((isThisCall || isSuperCall) && tu.isStaticContext(scope)) {
            return;
        }
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                switch (e.getKind()) {
                    case METHOD: {
                        String sn = e.getSimpleName().toString();
                        return !(!JavaCompletionTask.this.startsWith(env, sn, prefix) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || !env.isAccessible(scope, e, t, isSuperCall) || Utilities.isExcludeMethods() && Utilities.isExcluded(eu.getElementName(e.getEnclosingElement(), true) + "." + sn));
                    }
                }
                return false;
            }
        };
        for (Element e : eu.getMembers(type, acceptor)) {
            switch (e.getKind()) {
                case METHOD: {
                    ExecutableType et = (ExecutableType)this.asMemberOf(e, type, types);
                    this.results.add(this.itemFactory.createExecutableItem((CompilationInfo)env.getController(), (ExecutableElement)e, et, this.anchorOffset, null, typeElem != e.getEnclosingElement(), elements.isDeprecated(e), false, false, this.isOfSmartType(env, et, smartTypes), env.assignToVarPos(), true));
                }
            }
        }
    }

    private void addMembers(final BaseTask.Env env, TypeMirror type, final Element elem, final EnumSet<ElementKind> kinds, final DeclaredType baseType, final boolean inImport, final boolean insideNew, boolean autoImport) throws IOException {
        Set<TypeMirror> smartTypes = this.getSmartTypes(env);
        TreePath path = env.getPath();
        TypeMirror actualType = type;
        if (path != null && path.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            actualType = this.adjustType(env, type, elem, new TreePath(path, ((MemberSelectTree)path.getLeaf()).getExpression()));
        }
        CompilationController controller = env.getController();
        final Trees trees = controller.getTrees();
        final Elements elements = controller.getElements();
        final ElementUtilities eu = controller.getElementUtilities();
        final Types types = controller.getTypes();
        TreeUtilities tu = controller.getTreeUtilities();
        TypeElement typeElem = actualType.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)actualType).asElement() : null;
        final boolean isStatic = elem != null && (elem.getKind().isClass() || elem.getKind().isInterface() || elem.getKind() == ElementKind.TYPE_PARAMETER) && elem.asType().getKind() != TypeKind.ERROR;
        boolean isThisCall = elem != null && elem.getKind().isField() && elem.getSimpleName().contentEquals(THIS_KEYWORD);
        final boolean isSuperCall = elem != null && elem.getKind().isField() && elem.getSimpleName().contentEquals(SUPER_KEYWORD);
        final Scope scope = env.getScope();
        if ((isThisCall || isSuperCall) && tu.isStaticContext(scope)) {
            return;
        }
        final boolean[] ctorSeen = new boolean[]{false};
        final boolean[] nestedClassSeen = new boolean[]{false};
        final TypeElement enclClass = scope.getEnclosingClass();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                    case FIELD: {
                        if (!JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString())) {
                            return false;
                        }
                        if (e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) || e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD)) {
                            TypeElement cls = enclClass;
                            while (cls != null) {
                                if (cls == elem) {
                                    return JavaCompletionTask.this.isOfKindAndType(JavaCompletionTask.this.asMemberOf(e, t, types), e, kinds, baseType, scope, trees, types);
                                }
                                TypeElement outer = eu.enclosingTypeElement((Element)cls);
                                cls = !cls.getModifiers().contains((Object)Modifier.STATIC) ? outer : null;
                            }
                            return false;
                        }
                        if (isStatic) {
                            if (!e.getModifiers().contains((Object)Modifier.STATIC) || e.getSimpleName().contentEquals(JavaCompletionTask.CLASS_KEYWORD) && elem.getKind() == ElementKind.TYPE_PARAMETER) {
                                return false;
                            }
                        } else if (!JavaCompletionTask.this.options.contains((Object)Options.ALL_COMPLETION) && e.getModifiers().contains((Object)Modifier.STATIC)) {
                            if ((Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && JavaCompletionTask.this.isOfKindAndType(JavaCompletionTask.this.asMemberOf(e, t, types), e, kinds, baseType, scope, trees, types) && env.isAccessible(scope, e, t, isSuperCall) && (isStatic && !inImport || !e.getSimpleName().contentEquals(JavaCompletionTask.CLASS_KEYWORD))) {
                                JavaCompletionTask.this.hasAdditionalMembers = true;
                            }
                            return false;
                        }
                        return (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && JavaCompletionTask.this.isOfKindAndType(JavaCompletionTask.this.asMemberOf(e, t, types), e, kinds, baseType, scope, trees, types) && env.isAccessible(scope, e, t, isSuperCall) && (isStatic && !inImport || !e.getSimpleName().contentEquals(JavaCompletionTask.CLASS_KEYWORD));
                    }
                    case ENUM_CONSTANT: 
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case PARAMETER: {
                        return JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && JavaCompletionTask.this.isOfKindAndType(JavaCompletionTask.this.asMemberOf(e, t, types), e, kinds, baseType, scope, trees, types) && env.isAccessible(scope, e, t, isSuperCall);
                    }
                    case METHOD: {
                        String sn = e.getSimpleName().toString();
                        if (isStatic) {
                            if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                                return false;
                            }
                        } else if (!JavaCompletionTask.this.options.contains((Object)Options.ALL_COMPLETION) && e.getModifiers().contains((Object)Modifier.STATIC)) {
                            if (!(!JavaCompletionTask.this.startsWith(env, sn) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || !JavaCompletionTask.this.isOfKindAndType(((ExecutableType)JavaCompletionTask.this.asMemberOf(e, t, types)).getReturnType(), e, kinds, baseType, scope, trees, types) || !env.isAccessible(scope, e, t, isSuperCall) || Utilities.isExcludeMethods() && Utilities.isExcluded(eu.getElementName(e.getEnclosingElement(), true) + "." + sn))) {
                                JavaCompletionTask.this.hasAdditionalMembers = true;
                            }
                            return false;
                        }
                        return !(!JavaCompletionTask.this.startsWith(env, sn) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || !JavaCompletionTask.this.isOfKindAndType(((ExecutableType)JavaCompletionTask.this.asMemberOf(e, t, types)).getReturnType(), e, kinds, baseType, scope, trees, types) || !env.isAccessible(scope, e, t, isSuperCall) || Utilities.isExcludeMethods() && Utilities.isExcluded(eu.getElementName(e.getEnclosingElement(), true) + "." + sn));
                    }
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: {
                        if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                            nestedClassSeen[0] = true;
                        }
                        return !(!JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || Utilities.isExcluded(((TypeElement)e).getQualifiedName()) || !JavaCompletionTask.this.isOfKindAndType(e.asType(), e, kinds, baseType, scope, trees, types) || env.isAfterExtends() && !JavaCompletionTask.this.containsAccessibleNonFinalType(e, scope, trees) || !env.isAccessible(scope, e, t, isSuperCall) || !isStatic);
                    }
                    case CONSTRUCTOR: {
                        ctorSeen[0] = true;
                        return (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && JavaCompletionTask.this.isOfKindAndType(e.getEnclosingElement().asType(), e, kinds, baseType, scope, trees, types) && (env.isAccessible(scope, e, t, isSuperCall || insideNew) || elem.getModifiers().contains((Object)Modifier.ABSTRACT) && !e.getModifiers().contains((Object)Modifier.PRIVATE)) && isStatic;
                    }
                }
                return false;
            }
        };
        boolean addCast = actualType != type && elem instanceof VariableElement && !elem.getKind().isField();
        for (Element element : controller.getElementUtilities().getMembers(actualType, acceptor)) {
            switch (JavaCompletionTask.simplifyElementKind(element.getKind())) {
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case FIELD: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    String name = element.getSimpleName().toString();
                    if (THIS_KEYWORD.equals(name) || CLASS_KEYWORD.equals(name) || SUPER_KEYWORD.equals(name)) {
                        if (env.isExcludedKW(name)) break;
                        this.results.add(this.itemFactory.createKeywordItem(name, null, this.anchorOffset, this.isOfSmartType(env, element.asType(), smartTypes)));
                        env.addExcludedKW(name);
                        break;
                    }
                    TypeMirror tm = this.asMemberOf(element, actualType, types);
                    if (addCast && this.itemFactory instanceof TypeCastableItemFactory) {
                        this.results.add(((TypeCastableItemFactory)this.itemFactory).createTypeCastableVariableItem((CompilationInfo)env.getController(), (VariableElement)element, tm, actualType, this.anchorOffset, autoImport ? env.getReferencesCount() : null, typeElem != element.getEnclosingElement(), elements.isDeprecated(element), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                        break;
                    }
                    this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)element, tm, this.anchorOffset, autoImport ? env.getReferencesCount() : null, typeElem != element.getEnclosingElement(), elements.isDeprecated(element), this.isOfSmartType(env, tm, smartTypes), env.assignToVarPos()));
                    break;
                }
                case CONSTRUCTOR: {
                    ExecutableType et = (ExecutableType)this.asMemberOf(element, actualType, types);
                    this.results.add(this.itemFactory.createExecutableItem((CompilationInfo)env.getController(), (ExecutableElement)element, et, this.anchorOffset, autoImport ? env.getReferencesCount() : null, typeElem != element.getEnclosingElement(), elements.isDeprecated(element), inImport, false, this.isOfSmartType(env, actualType, smartTypes), env.assignToVarPos(), false));
                    break;
                }
                case METHOD: {
                    ExecutableType et = (ExecutableType)this.asMemberOf(element, actualType, types);
                    if (addCast && this.itemFactory instanceof TypeCastableItemFactory && !types.isSubtype(type, element.getEnclosingElement().asType()) && type.getKind() == TypeKind.DECLARED && !this.hasBaseMethod(elements, (DeclaredType)type, (ExecutableElement)element)) {
                        this.results.add(((TypeCastableItemFactory)this.itemFactory).createTypeCastableExecutableItem((CompilationInfo)env.getController(), (ExecutableElement)element, et, actualType, this.anchorOffset, autoImport ? env.getReferencesCount() : null, typeElem != element.getEnclosingElement(), elements.isDeprecated(element), inImport, env.addSemicolon(), this.isOfSmartType(env, this.getCorrectedReturnType(env, et, (ExecutableElement)element, actualType), smartTypes), env.assignToVarPos(), false));
                        break;
                    }
                    this.results.add(this.itemFactory.createExecutableItem((CompilationInfo)env.getController(), (ExecutableElement)element, et, this.anchorOffset, autoImport ? env.getReferencesCount() : null, typeElem != element.getEnclosingElement(), elements.isDeprecated(element), inImport, env.addSemicolon(), this.isOfSmartType(env, this.getCorrectedReturnType(env, et, (ExecutableElement)element, actualType), smartTypes), env.assignToVarPos(), false));
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    DeclaredType dt = (DeclaredType)this.asMemberOf(element, actualType, types);
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)element, dt, this.anchorOffset, null, elements.isDeprecated(element), insideNew, insideNew || env.isInsideClass(), true, this.isOfSmartType(env, dt, smartTypes), autoImport));
                }
            }
        }
        if (!ctorSeen[0] && kinds.contains((Object)ElementKind.CONSTRUCTOR) && elem.getKind().isInterface()) {
            this.results.add(this.itemFactory.createDefaultConstructorItem((TypeElement)elem, this.anchorOffset, this.isOfSmartType(env, actualType, smartTypes)));
        }
        if (isStatic && enclClass != null && elem.getKind().isInterface() && env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0) {
            for (TypeMirror typeMirror : enclClass.getInterfaces()) {
                if (((DeclaredType)typeMirror).asElement() != elem) continue;
                this.results.add(this.itemFactory.createKeywordItem(SUPER_KEYWORD, null, this.anchorOffset, this.isOfSmartType(env, actualType, smartTypes)));
                break;
            }
        }
        if (!isStatic && nestedClassSeen[0]) {
            this.addKeyword(env, NEW_KEYWORD, SPACE, false);
        }
    }

    private boolean hasBaseMethod(Elements elements, DeclaredType type, ExecutableElement invoked) {
        TypeElement clazz = (TypeElement)type.asElement();
        for (ExecutableElement existing : ElementFilter.methodsIn(elements.getAllMembers(clazz))) {
            if (!existing.getSimpleName().equals(invoked.getSimpleName()) || !elements.overrides(invoked, existing, clazz)) continue;
            return true;
        }
        return false;
    }

    private void addThisOrSuperConstructor(BaseTask.Env env, TypeMirror type, final Element elem, String name, final ExecutableElement toExclude) throws IOException {
        CompilationController controller = env.getController();
        final Elements elements = controller.getElements();
        Types types = controller.getTypes();
        final Trees trees = controller.getTrees();
        final Scope scope = env.getScope();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                switch (e.getKind()) {
                    case CONSTRUCTOR: {
                        return toExclude != e && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && (trees.isAccessible(scope, e, (DeclaredType)t) || elem.getModifiers().contains((Object)Modifier.ABSTRACT) && !e.getModifiers().contains((Object)Modifier.PRIVATE));
                    }
                }
                return false;
            }
        };
        for (Element e : controller.getElementUtilities().getMembers(type, acceptor)) {
            if (e.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableType et = (ExecutableType)this.asMemberOf(e, type, types);
            this.results.add(this.itemFactory.createThisOrSuperConstructorItem((CompilationInfo)env.getController(), (ExecutableElement)e, et, this.anchorOffset, elements.isDeprecated(e), name));
        }
    }

    private void addEnumConstants(BaseTask.Env env, TypeElement elem) {
        Elements elements = env.getController().getElements();
        Trees trees = env.getController().getTrees();
        TreePath path = env.getPath().getParentPath();
        HashSet<Element> alreadyUsed = new HashSet<Element>();
        List<? extends CaseTree> caseTrees = null;
        if (path != null && path.getLeaf().getKind() == Tree.Kind.SWITCH) {
            SwitchTree st = (SwitchTree)path.getLeaf();
            caseTrees = st.getCases();
        } else if (path != null && path.getLeaf().getKind() == Tree.Kind.SWITCH_EXPRESSION) {
            caseTrees = ((SwitchExpressionTree)path.getLeaf()).getCases();
        }
        if (caseTrees != null) {
            for (CaseTree caseTree : caseTrees) {
                for (ExpressionTree expressionTree : caseTree.getExpressions()) {
                    Element e = expressionTree != null ? trees.getElement(new TreePath(path, expressionTree)) : null;
                    if (e == null || e.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    alreadyUsed.add(e);
                }
            }
        }
        for (Element element : elem.getEnclosedElements()) {
            String name;
            if (element.getKind() != ElementKind.ENUM_CONSTANT || alreadyUsed.contains(element) || !this.startsWith(env, name = element.getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element)) continue;
            this.results.add(this.itemFactory.createVariableItem((CompilationInfo)env.getController(), (VariableElement)element, element.asType(), this.anchorOffset, null, false, elements.isDeprecated(element), false, env.assignToVarPos()));
        }
    }

    private void addPackageContent(BaseTask.Env env, PackageElement pe, EnumSet<ElementKind> kinds, DeclaredType baseType, boolean insideNew, boolean srcOnly) throws IOException {
        if (this.isRecordSupported(env)) {
            kinds.add(ElementKind.RECORD);
        }
        Set<TypeMirror> smartTypes = this.options.contains((Object)Options.ALL_COMPLETION) ? null : this.getSmartTypes(env);
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        Types types = controller.getTypes();
        Trees trees = controller.getTrees();
        ElementUtilities eu = controller.getElementUtilities();
        Scope scope = env.getScope();
        for (Element element : pe.getEnclosedElements()) {
            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
            String name = element.getSimpleName().toString();
            if (env.getExcludes() != null && env.getExcludes().contains(element) || !this.startsWith(env, name) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element) || !trees.isAccessible(scope, (TypeElement)element) || !this.isOfKindAndType(element.asType(), element, kinds, baseType, scope, trees, types) || Utilities.isExcluded(eu.getElementName(element, true))) continue;
            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)element, (DeclaredType)element.asType(), this.anchorOffset, null, elements.isDeprecated(element), insideNew, insideNew || env.isInsideClass(), true, this.isOfSmartType(env, element.asType(), smartTypes), false));
        }
        String pkgName = pe.getQualifiedName() + ".";
        this.addPackages(env, pkgName, srcOnly);
    }

    private void addPackages(BaseTask.Env env, String fqnPrefix, boolean srcOnly) {
        if (fqnPrefix == null) {
            fqnPrefix = EMPTY;
        }
        String prefix = env.getPrefix() != null ? fqnPrefix + env.getPrefix() : fqnPrefix;
        CompilationController controller = env.getController();
        Elements elements = controller.getElements();
        Element el = controller.getTrees().getElement(new TreePath(controller.getCompilationUnit()));
        ModuleElement moduleElement = el != null ? controller.getElements().getModuleOf(el) : null;
        HashSet<String> seenPkgs = new HashSet<String>();
        EnumSet<ClassIndex.SearchScope> scope = srcOnly ? EnumSet.of(ClassIndex.SearchScope.SOURCE) : EnumSet.allOf(ClassIndex.SearchScope.class);
        for (String pkgName : env.getController().getClasspathInfo().getClassIndex().getPackageNames(fqnPrefix, false, scope)) {
            int idx;
            if (!this.startsWith(env, pkgName, prefix) || Utilities.isExcluded(pkgName + ".") || (moduleElement != null ? elements.getPackageElement(moduleElement, pkgName) : elements.getPackageElement(pkgName)) == null) continue;
            if (fqnPrefix != null) {
                pkgName = pkgName.substring(fqnPrefix.length());
            }
            if ((idx = pkgName.indexOf(46)) > 0) {
                pkgName = pkgName.substring(0, idx);
            }
            if (!seenPkgs.add(pkgName)) continue;
            this.results.add(this.itemFactory.createPackageItem(pkgName, this.anchorOffset, srcOnly));
        }
    }

    private void addModuleNames(BaseTask.Env env, String fqnPrefix, boolean srcOnly) {
        if (fqnPrefix == null) {
            fqnPrefix = EMPTY;
        }
        srcOnly = false;
        String prefix = env.getPrefix() != null ? fqnPrefix + env.getPrefix() : fqnPrefix;
        for (String name : SourceUtils.getModuleNames((CompilationInfo)env.getController(), srcOnly ? EnumSet.of(ClassIndex.SearchScope.SOURCE) : EnumSet.allOf(ClassIndex.SearchScope.class))) {
            if (!this.startsWith(env, name, prefix) || !(this.itemFactory instanceof ModuleItemFactory)) continue;
            this.results.add(((ModuleItemFactory)this.itemFactory).createModuleItem(name, this.anchorOffset));
        }
    }

    private void addTypes(BaseTask.Env env, EnumSet<ElementKind> kinds, DeclaredType baseType) throws IOException {
        if (this.options.contains((Object)Options.ALL_COMPLETION) || this.options.contains((Object)Options.COMBINED_COMPLETION)) {
            if (baseType == null) {
                this.addAllTypes(env, kinds);
            } else {
                Elements elements = env.getController().getElements();
                Set<? extends Element> excludes = env.getExcludes();
                for (DeclaredType subtype : this.getSubtypesOf(env, baseType)) {
                    TypeElement elem = (TypeElement)subtype.asElement();
                    if (excludes != null && excludes.contains(elem) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(elem) || Utilities.isExcluded(elem.getQualifiedName()) || env.isAfterExtends() && elem.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), elem, subtype, this.anchorOffset, env.getReferencesCount(), elements.isDeprecated(elem), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), false, true, false));
                }
            }
        } else {
            this.addLocalAndImportedTypes(env, kinds, baseType);
            this.hasAdditionalClasses = true;
        }
        this.addPackages(env, null, kinds.isEmpty());
    }

    private void addLocalAndImportedTypes(final BaseTask.Env env, final EnumSet<ElementKind> kinds, final DeclaredType baseType) throws IOException {
        CompilationController controller = env.getController();
        final Trees trees = controller.getTrees();
        final Elements elements = controller.getElements();
        final Types types = controller.getTypes();
        TreeUtilities tu = controller.getTreeUtilities();
        final Scope scope = env.getScope();
        final ExecutableElement enclMethod = scope.getEnclosingMethod();
        TypeElement enclClass = scope.getEnclosingClass();
        final boolean isStatic = enclClass == null ? false : tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic();
        Object acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                if (!(env.getExcludes() != null && env.getExcludes().contains(e) || !e.getKind().isClass() && !e.getKind().isInterface() && e.getKind() != ElementKind.TYPE_PARAMETER || env.isAfterExtends() && !JavaCompletionTask.this.containsAccessibleNonFinalType(e, scope, trees))) {
                    String name = e.getSimpleName().toString();
                    return !(name.length() <= 0 || Character.isDigit(name.charAt(0)) || !JavaCompletionTask.this.startsWith(env, name) || isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getEnclosingElement() != enclMethod || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || e.getKind() != ElementKind.TYPE_PARAMETER && Utilities.isExcluded(((TypeElement)e).getQualifiedName()) || !JavaCompletionTask.this.isOfKindAndType(e.asType(), e, kinds, baseType, scope, trees, types));
                }
                return false;
            }
        };
        for (Element e : controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor)) {
            switch (e.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)e, (DeclaredType)e.asType(), this.anchorOffset, null, elements.isDeprecated(e), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), false, false, false));
                    env.addToExcludes(e);
                    break;
                }
                case TYPE_PARAMETER: {
                    this.results.add(this.itemFactory.createTypeParameterItem((TypeParameterElement)e, this.anchorOffset));
                }
            }
        }
        acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                if (e.getKind().isClass() || e.getKind().isInterface()) {
                    return !(env.getExcludes() != null && env.getExcludes().contains(e) || !JavaCompletionTask.this.startsWith(env, e.getSimpleName().toString()) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || Utilities.isExcluded(((TypeElement)e).getQualifiedName()) || !trees.isAccessible(scope, (TypeElement)e) || !JavaCompletionTask.this.isOfKindAndType(e.asType(), e, kinds, baseType, scope, trees, types) || env.isAfterExtends() && !JavaCompletionTask.this.containsAccessibleNonFinalType(e, scope, trees));
                }
                return false;
            }
        };
        for (Element e : controller.getElementUtilities().getGlobalTypes(acceptor)) {
            this.results.add(this.itemFactory.createTypeItem((CompilationInfo)env.getController(), (TypeElement)e, (DeclaredType)e.asType(), this.anchorOffset, null, elements.isDeprecated(e), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), false, false, false));
        }
    }

    private void addAllTypes(BaseTask.Env env, EnumSet<ElementKind> kinds) {
        String prefix = env.getPrefix();
        CompilationController controller = env.getController();
        Set<? extends Element> excludes = env.getExcludes();
        HashSet<ElementHandle> excludeHandles = null;
        if (excludes != null) {
            excludeHandles = new HashSet<ElementHandle>(excludes.size());
            for (Element element : excludes) {
                excludeHandles.add(ElementHandle.create((Element)element));
            }
        }
        if (!kinds.contains((Object)ElementKind.CLASS) && !kinds.contains((Object)ElementKind.INTERFACE)) {
            Set declaredTypes = controller.getClasspathInfo().getClassIndex().getDeclaredTypes(EMPTY, ClassIndex.NameKind.PREFIX, EnumSet.allOf(ClassIndex.SearchScope.class));
            HashMap<String, ElementHandle> hashMap = new HashMap<String, ElementHandle>(declaredTypes.size());
            HashSet<String> doNotRemove = new HashSet<String>();
            for (ElementHandle name : declaredTypes) {
                int idx;
                String sName;
                if (excludeHandles != null && excludeHandles.contains(name) || JavaCompletionTask.isAnnonInner((ElementHandle<TypeElement>)name)) continue;
                if (!kinds.contains((Object)name.getKind()) && !doNotRemove.contains(name.getQualifiedName())) {
                    int idx2 = name.getQualifiedName().lastIndexOf(46);
                    sName = idx2 < 0 ? name.getQualifiedName() : name.getQualifiedName().substring(idx2 + 1);
                    if (!this.startsWith(env, sName, prefix)) continue;
                    hashMap.put(name.getQualifiedName(), name);
                    continue;
                }
                String qName = name.getQualifiedName();
                sName = null;
                while ((idx = qName.lastIndexOf(46)) > 0) {
                    if (sName == null && (sName = qName.substring(idx + 1)).length() > 0 && this.startsWith(env, sName, prefix)) {
                        this.results.add(this.itemFactory.createTypeItem((ElementHandle<TypeElement>)name, kinds, this.anchorOffset, env.getReferencesCount(), controller.getSnapshot().getSource(), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), env.isAfterExtends()));
                    }
                    qName = qName.substring(0, idx);
                    doNotRemove.add(qName);
                    ElementHandle r = (ElementHandle)hashMap.remove(qName);
                    if (r == null) continue;
                    this.results.add(this.itemFactory.createTypeItem((ElementHandle<TypeElement>)r, kinds, this.anchorOffset, env.getReferencesCount(), controller.getSnapshot().getSource(), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), env.isAfterExtends()));
                }
            }
        } else {
            String subwordsPattern = null;
            if (prefix != null && !env.isCamelCasePrefix() && Utilities.isSubwordSensitive()) {
                subwordsPattern = Utilities.createSubwordsPattern(prefix);
            }
            ClassIndex.NameKind nameKind = env.isCamelCasePrefix() ? (Utilities.isCaseSensitive() ? ClassIndex.NameKind.CAMEL_CASE : ClassIndex.NameKind.CAMEL_CASE_INSENSITIVE) : (subwordsPattern != null ? ClassIndex.NameKind.REGEXP : (Utilities.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX));
            Set declaredTypes = controller.getClasspathInfo().getClassIndex().getDeclaredTypes(subwordsPattern != null ? subwordsPattern : (prefix != null ? prefix : EMPTY), nameKind, EnumSet.allOf(ClassIndex.SearchScope.class));
            this.results.ensureCapacity(this.results.size() + declaredTypes.size());
            for (ElementHandle name : declaredTypes) {
                if (!kinds.contains((Object)name.getKind()) || excludeHandles != null && excludeHandles.contains(name) || JavaCompletionTask.isAnnonInner((ElementHandle<TypeElement>)name)) continue;
                this.results.add(this.itemFactory.createTypeItem((ElementHandle<TypeElement>)name, kinds, this.anchorOffset, env.getReferencesCount(), controller.getSnapshot().getSource(), env.isInsideNew(), env.isInsideNew() || env.isInsideClass(), env.isAfterExtends()));
            }
        }
    }

    private Set<DeclaredType> getSupertypesOf(BaseTask.Env env, DeclaredType type) {
        LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
        bases.add(type);
        HashSet<DeclaredType> ret = new HashSet<DeclaredType>();
        while (!bases.isEmpty()) {
            TypeMirror sup;
            DeclaredType head = (DeclaredType)bases.remove();
            TypeElement elem = (TypeElement)head.asElement();
            if (this.startsWith(env, elem.getSimpleName().toString())) {
                ret.add(head);
            }
            if ((sup = elem.getSuperclass()).getKind() == TypeKind.DECLARED) {
                bases.add((DeclaredType)sup);
            }
            for (TypeMirror typeMirror : elem.getInterfaces()) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                bases.add((DeclaredType)typeMirror);
            }
        }
        return ret;
    }

    private List<DeclaredType> getSubtypesOf(BaseTask.Env env, DeclaredType baseType) throws IOException {
        if (((TypeElement)baseType.asElement()).getQualifiedName().contentEquals(JAVA_LANG_OBJECT)) {
            return Collections.emptyList();
        }
        LinkedList<DeclaredType> subtypes = new LinkedList<DeclaredType>();
        String prefix = env.getPrefix();
        CompilationController controller = env.getController();
        Types types = controller.getTypes();
        Trees trees = controller.getTrees();
        Scope scope = env.getScope();
        if (prefix != null && prefix.length() > 2 && baseType.getTypeArguments().isEmpty()) {
            String subwordsPattern = null;
            if (!env.isCamelCasePrefix() && Utilities.isSubwordSensitive()) {
                subwordsPattern = Utilities.createSubwordsPattern(prefix);
            }
            ClassIndex.NameKind kind = env.isCamelCasePrefix() ? (Utilities.isCaseSensitive() ? ClassIndex.NameKind.CAMEL_CASE : ClassIndex.NameKind.CAMEL_CASE_INSENSITIVE) : (subwordsPattern != null ? ClassIndex.NameKind.REGEXP : (Utilities.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX));
            for (ElementHandle handle : controller.getClasspathInfo().getClassIndex().getDeclaredTypes(subwordsPattern != null ? subwordsPattern : prefix, kind, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                TypeElement te = (TypeElement)handle.resolve((CompilationInfo)controller);
                if (te == null || !trees.isAccessible(scope, te) || !types.isSubtype(types.getDeclaredType(te, new TypeMirror[0]), baseType)) continue;
                subtypes.add(types.getDeclaredType(te, new TypeMirror[0]));
            }
        } else {
            HashSet<TypeElement> elems = new HashSet<TypeElement>();
            LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
            bases.add(baseType);
            ClassIndex index = controller.getClasspathInfo().getClassIndex();
            while (!bases.isEmpty()) {
                List<? extends TypeMirror> tas;
                DeclaredType head = (DeclaredType)bases.remove();
                TypeElement elem = (TypeElement)head.asElement();
                if (!elems.add(elem)) continue;
                if (this.startsWith(env, elem.getSimpleName().toString())) {
                    subtypes.add(head);
                }
                boolean isRaw = !(tas = head.getTypeArguments()).iterator().hasNext();
                block2: for (ElementHandle eh : index.getElements(ElementHandle.create((Element)elem), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                    TypeElement e = (TypeElement)eh.resolve((CompilationInfo)controller);
                    if (e != null) {
                        if (!trees.isAccessible(scope, e)) continue;
                        if (isRaw) {
                            DeclaredType dt = types.getDeclaredType(e, new TypeMirror[0]);
                            bases.add(dt);
                            continue;
                        }
                        HashMap<Element, TypeMirror> map = new HashMap<Element, TypeMirror>();
                        TypeMirror sup = e.getSuperclass();
                        if (sup.getKind() == TypeKind.DECLARED && ((DeclaredType)sup).asElement() == elem) {
                            DeclaredType dt = (DeclaredType)sup;
                            Iterator<? extends TypeMirror> iterator = tas.iterator();
                            Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                            while (it.hasNext() && iterator.hasNext()) {
                                TypeMirror stm;
                                TypeMirror basetm = iterator.next();
                                if (basetm == (stm = it.next())) continue;
                                if (stm.getKind() != TypeKind.TYPEVAR) continue block2;
                                map.put(((TypeVariable)stm).asElement(), basetm);
                            }
                            if (it.hasNext() != iterator.hasNext()) {
                                continue;
                            }
                        } else {
                            for (TypeMirror typeMirror : e.getInterfaces()) {
                                if (((DeclaredType)typeMirror).asElement() != elem) continue;
                                DeclaredType dt = (DeclaredType)typeMirror;
                                Iterator<? extends TypeMirror> ittas = tas.iterator();
                                Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                                while (it.hasNext() && ittas.hasNext()) {
                                    TypeMirror stm;
                                    TypeMirror basetm = ittas.next();
                                    if (basetm == (stm = it.next())) continue;
                                    if (stm.getKind() != TypeKind.TYPEVAR) continue block2;
                                    map.put(((TypeVariable)stm).asElement(), basetm);
                                }
                                if (it.hasNext() != ittas.hasNext()) continue block2;
                            }
                        }
                        bases.add(this.getDeclaredType(e, map, types));
                        continue;
                    }
                    Logger.getLogger("global").log(Level.FINE, String.format("Cannot resolve: %s on bootpath: %s classpath: %s sourcepath: %s\n", eh.toString(), controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT), controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE), controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE)));
                }
            }
        }
        return subtypes;
    }

    private void addMethodArguments(BaseTask.Env env, MethodInvocationTree mit) throws IOException {
        final CompilationController controller = env.getController();
        TreePath path = env.getPath();
        CompilationUnitTree root = env.getRoot();
        SourcePositions sourcePositions = env.getSourcePositions();
        List<Tree> argTypes = this.getArgumentsUpToPos(env, mit.getArguments(), (int)sourcePositions.getEndPosition(root, mit.getMethodSelect()), env.getOffset(), true);
        if (argTypes != null) {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            TypeMirror[] types = new TypeMirror[argTypes.size()];
            int j = 0;
            for (Tree t : argTypes) {
                types[j++] = controller.getTrees().getTypeMirror(new TreePath(path, t));
            }
            List<Pair<ExecutableElement, ExecutableType>> methods = null;
            String name = null;
            ExpressionTree mid = mit.getMethodSelect();
            path = new TreePath(path, mid);
            switch (mid.getKind()) {
                case MEMBER_SELECT: {
                    ExpressionTree exp = ((MemberSelectTree)mid).getExpression();
                    path = new TreePath(path, exp);
                    final Trees trees = controller.getTrees();
                    TypeMirror typeMirror = trees.getTypeMirror(path);
                    Element element = trees.getElement(path);
                    final boolean isStatic = element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind() == ElementKind.TYPE_PARAMETER);
                    final boolean isSuperCall = element != null && element.getKind().isField() && element.getSimpleName().contentEquals(SUPER_KEYWORD);
                    final Scope scope = env.getScope();
                    TypeElement enclClass = scope.getEnclosingClass();
                    final TypeMirror enclType = enclClass != null ? enclClass.asType() : null;
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            return !(isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getKind() != ElementKind.CONSTRUCTOR || t.getKind() == TypeKind.DECLARED && !trees.isAccessible(scope, e, (DeclaredType)(isSuperCall && enclType != null ? enclType : t)));
                        }
                    };
                    methods = this.getMatchingExecutables(typeMirror, controller.getElementUtilities().getMembers(typeMirror, acceptor), ((MemberSelectTree)mid).getIdentifier().toString(), types, controller.getTypes());
                    break;
                }
                case IDENTIFIER: {
                    final Scope scope = env.getScope();
                    TreeUtilities tu = controller.getTreeUtilities();
                    final Trees trees = controller.getTrees();
                    TypeElement enclClass = scope.getEnclosingClass();
                    final boolean isStatic = enclClass != null ? tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic() : false;
                    final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
                    final ExecutableElement method = scope.getEnclosingMethod();
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                                case EXCEPTION_PARAMETER: 
                                case LOCAL_VARIABLE: 
                                case RESOURCE_VARIABLE: 
                                case PARAMETER: {
                                    return (method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && (!illegalForwardRefs.containsKey(e.getSimpleName()) || ((Element)illegalForwardRefs.get(e.getSimpleName())).getEnclosingElement() != e.getEnclosingElement());
                                }
                                case FIELD: {
                                    if (illegalForwardRefs.containsValue(e)) {
                                        return false;
                                    }
                                    if (!e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) && !e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD)) break;
                                    return !isStatic;
                                }
                            }
                            return (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && trees.isAccessible(scope, e, (DeclaredType)t);
                        }
                    };
                    name = ((IdentifierTree)mid).getName().toString();
                    if (SUPER_KEYWORD.equals(name) && enclClass != null) {
                        TypeMirror superclass = enclClass.getSuperclass();
                        methods = this.getMatchingExecutables(superclass, controller.getElementUtilities().getMembers(superclass, acceptor), INIT, types, controller.getTypes());
                        break;
                    }
                    if (THIS_KEYWORD.equals(name) && enclClass != null) {
                        TypeMirror thisclass = enclClass.asType();
                        methods = this.getMatchingExecutables(thisclass, controller.getElementUtilities().getMembers(thisclass, acceptor), INIT, types, controller.getTypes());
                        break;
                    }
                    methods = this.getMatchingExecutables(enclClass != null ? enclClass.asType() : null, controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), name, types, controller.getTypes());
                    name = null;
                    break;
                }
            }
            if (methods != null) {
                Elements elements = controller.getElements();
                for (Pair pair : methods) {
                    if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated((Element)pair.first())) continue;
                    this.results.add(this.itemFactory.createParametersItem((CompilationInfo)env.getController(), (ExecutableElement)pair.first(), (ExecutableType)pair.second(), this.anchorOffset, elements.isDeprecated((Element)pair.first()), types.length, name));
                }
            }
        }
    }

    private void addConstructorArguments(BaseTask.Env env, NewClassTree nct) throws IOException {
        CompilationController controller = env.getController();
        TreePath path = env.getPath();
        CompilationUnitTree root = env.getRoot();
        SourcePositions sourcePositions = env.getSourcePositions();
        List<Tree> argTypes = this.getArgumentsUpToPos(env, nct.getArguments(), (int)sourcePositions.getEndPosition(root, nct.getIdentifier()), env.getOffset(), true);
        if (argTypes != null) {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            TypeMirror[] types = new TypeMirror[argTypes.size()];
            int j = 0;
            for (Tree t : argTypes) {
                types[j++] = controller.getTrees().getTypeMirror(new TreePath(path, t));
            }
            path = new TreePath(path, nct.getIdentifier());
            final Trees trees = controller.getTrees();
            TypeMirror type = trees.getTypeMirror(path);
            Element el = trees.getElement(path);
            final Scope scope = env.getScope();
            final boolean isAnonymous = nct.getClassBody() != null || el != null && (el.getKind().isInterface() || el.getModifiers().contains((Object)Modifier.ABSTRACT));
            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror t) {
                    return e.getKind() == ElementKind.CONSTRUCTOR && (trees.isAccessible(scope, e, (DeclaredType)t) || isAnonymous && e.getModifiers().contains((Object)Modifier.PROTECTED));
                }
            };
            List<Pair<ExecutableElement, ExecutableType>> ctors = this.getMatchingExecutables(type, controller.getElementUtilities().getMembers(type, acceptor), INIT, types, controller.getTypes());
            Elements elements = controller.getElements();
            for (Pair<ExecutableElement, ExecutableType> ctor : ctors) {
                if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated((Element)ctor.first())) continue;
                this.results.add(this.itemFactory.createParametersItem((CompilationInfo)env.getController(), (ExecutableElement)ctor.first(), (ExecutableType)ctor.second(), this.anchorOffset, elements.isDeprecated((Element)ctor.first()), types.length, null));
            }
        }
    }

    private void addAttributeValues(BaseTask.Env env, Element element, AnnotationMirror annotation, ExecutableElement member) throws IOException {
        CompilationController controller = env.getController();
        TreeUtilities tu = controller.getTreeUtilities();
        ElementUtilities eu = controller.getElementUtilities();
        for (Completion completion : SourceUtils.getAttributeValueCompletions((CompilationInfo)controller, (Element)element, (AnnotationMirror)annotation, (ExecutableElement)member, (String)env.getPrefix())) {
            Name fqn;
            String value = completion.getValue().trim();
            if (value.length() <= 0 || !this.startsWith(env, value)) continue;
            TypeMirror type = member.getReturnType();
            TypeElement typeElement = null;
            while (type.getKind() == TypeKind.ARRAY) {
                type = ((ArrayType)type).getComponentType();
            }
            if (type.getKind() == TypeKind.DECLARED && JAVA_LANG_CLASS.contentEquals(fqn = ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName())) {
                String name = value.endsWith(".class") ? value.substring(0, value.length() - 6) : value;
                TypeMirror tm = tu.parseType(name, eu.outermostTypeElement(element));
                TypeElement typeElement2 = typeElement = tm != null && tm.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)tm).asElement() : null;
                if (typeElement != null && this.startsWith(env, typeElement.getSimpleName().toString())) {
                    env.addToExcludes(typeElement);
                }
            }
            this.results.add(this.itemFactory.createAttributeValueItem((CompilationInfo)env.getController(), value, completion.getMessage(), typeElement, this.anchorOffset, env.getReferencesCount()));
        }
    }

    private void addKeyword(BaseTask.Env env, String kw, String postfix, boolean smartType) {
        if (Utilities.startsWith(kw, env.getPrefix())) {
            this.results.add(this.itemFactory.createKeywordItem(kw, postfix, this.anchorOffset, smartType));
        }
    }

    private void addKeywordsForCU(BaseTask.Env env) {
        ArrayList<String> kws = new ArrayList<String>();
        int offset = env.getOffset();
        String prefix = env.getPrefix();
        CompilationUnitTree cu = env.getRoot();
        boolean pkgInfo = env.getController().getTreeUtilities().isPackageInfo(cu);
        boolean mdlInfo = env.getController().getTreeUtilities().isModuleInfo(cu);
        SourcePositions sourcePositions = env.getSourcePositions();
        if (!pkgInfo && !mdlInfo) {
            kws.add(ABSTRACT_KEYWORD);
            kws.add(CLASS_KEYWORD);
            kws.add(ENUM_KEYWORD);
            kws.add(FINAL_KEYWORD);
            kws.add(INTERFACE_KEYWORD);
            if (this.isRecordSupported(env)) {
                kws.add(RECORD_KEYWORD);
            }
            if (this.isSealedSupported(env)) {
                kws.add(SEALED_KEYWORD);
                kws.add(NON_SEALED_KEYWORD);
            }
        }
        boolean beforeAnyClass = true;
        boolean beforePublicClass = true;
        for (Tree tree : cu.getTypeDecls()) {
            int pos;
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                pos = (int)sourcePositions.getEndPosition(cu, tree);
                if ((long)pos == -1L || offset < pos) continue;
                beforeAnyClass = false;
                if (!((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                beforePublicClass = false;
                break;
            }
            if (tree.getKind() != Tree.Kind.MODULE || (long)(pos = (int)sourcePositions.getEndPosition(cu, tree)) == -1L || offset < pos) continue;
            beforeAnyClass = false;
        }
        if (beforePublicClass && !pkgInfo && !mdlInfo) {
            kws.add(PUBLIC_KEYWORD);
        }
        if (beforeAnyClass) {
            if (mdlInfo) {
                kws.add(MODULE_KEYWORD);
                kws.add(OPEN_KEYWORD);
            }
            kws.add(IMPORT_KEYWORD);
            Tree firstImport = null;
            Iterator<? extends ImportTree> iterator = cu.getImports().iterator();
            if (iterator.hasNext()) {
                Tree t2;
                firstImport = t2 = (Tree)iterator.next();
            }
            ExpressionTree expressionTree = cu.getPackageName();
            if (!mdlInfo && (expressionTree != null && (long)offset <= sourcePositions.getStartPosition(cu, cu) || expressionTree == null && (firstImport == null || sourcePositions.getStartPosition(cu, firstImport) >= (long)offset))) {
                kws.add(PACKAGE_KEYWORD);
            }
        }
        for (String string : kws) {
            if (!Utilities.startsWith(string, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(string, SPACE, this.anchorOffset, false));
        }
    }

    private void addKeywordsForModuleBody(BaseTask.Env env) {
        String prefix = env.getPrefix();
        for (String kw : MODULE_BODY_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
    }

    private void addKeywordsForClassBody(BaseTask.Env env) {
        String prefix = env.getPrefix();
        for (String kw : CLASS_BODY_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
        if (this.isSealedSupported(env)) {
            if (Utilities.startsWith(SEALED_KEYWORD, prefix)) {
                this.results.add(this.itemFactory.createKeywordItem(SEALED_KEYWORD, SPACE, this.anchorOffset, false));
            }
            if (Utilities.startsWith(NON_SEALED_KEYWORD, prefix)) {
                this.results.add(this.itemFactory.createKeywordItem(NON_SEALED_KEYWORD, SPACE, this.anchorOffset, false));
            }
        }
        if (env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && Utilities.startsWith(DEFAULT_KEYWORD, prefix) && env.getController().getTreeUtilities().getPathElementOfKind(Tree.Kind.INTERFACE, env.getPath()) != null) {
            this.results.add(this.itemFactory.createKeywordItem(DEFAULT_KEYWORD, SPACE, this.anchorOffset, false));
        }
        if (this.isRecordSupported(env) && Utilities.startsWith(RECORD_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(RECORD_KEYWORD, SPACE, this.anchorOffset, false));
        }
        this.addPrimitiveTypeKeywords(env);
    }

    private void addKeywordsForBlock(BaseTask.Env env) {
        String prefix = env.getPrefix();
        for (String kw : STATEMENT_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, null, this.anchorOffset, false));
        }
        for (String kw : BLOCK_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
        if (this.isRecordSupported(env) && Utilities.startsWith(RECORD_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(RECORD_KEYWORD, SPACE, this.anchorOffset, false));
        }
        if (Utilities.startsWith(RETURN_KEYWORD, prefix)) {
            TreePath tp = env.getController().getTreeUtilities().getPathElementOfKind(EnumSet.of(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION), env.getPath());
            String postfix = SPACE;
            if (tp != null) {
                if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
                    Tree rt = ((MethodTree)tp.getLeaf()).getReturnType();
                    if (rt == null || rt.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)rt).getPrimitiveTypeKind() == TypeKind.VOID) {
                        postfix = SEMI;
                    }
                } else {
                    ExecutableType dt;
                    TypeMirror tm = env.getController().getTrees().getTypeMirror(tp);
                    if (tm != null && tm.getKind() == TypeKind.DECLARED && (dt = env.getController().getTypeUtilities().getDescriptorType((DeclaredType)tm)) != null && dt.getReturnType().getKind() == TypeKind.VOID) {
                        postfix = SEMI;
                    }
                }
            }
            this.results.add(this.itemFactory.createKeywordItem(RETURN_KEYWORD, postfix, this.anchorOffset, false));
        }
        boolean caseAdded = false;
        boolean breakAdded = false;
        boolean continueAdded = false;
        block6: for (TreePath tp = env.getPath(); tp != null; tp = tp.getParentPath()) {
            switch (tp.getLeaf().getKind()) {
                case SWITCH: {
                    CaseTree lastCase = null;
                    CompilationUnitTree root = env.getRoot();
                    SourcePositions sourcePositions = env.getSourcePositions();
                    for (CaseTree caseTree : ((SwitchTree)tp.getLeaf()).getCases()) {
                        if (sourcePositions.getStartPosition(root, caseTree) >= (long)env.getOffset()) break;
                        lastCase = caseTree;
                    }
                    if (!(caseAdded || lastCase != null && lastCase.getExpression() == null)) {
                        caseAdded = true;
                        if (Utilities.startsWith(CASE_KEYWORD, prefix)) {
                            this.results.add(this.itemFactory.createKeywordItem(CASE_KEYWORD, SPACE, this.anchorOffset, false));
                        }
                        if (Utilities.startsWith(DEFAULT_KEYWORD, prefix)) {
                            this.results.add(this.itemFactory.createKeywordItem(DEFAULT_KEYWORD, COLON, this.anchorOffset, false));
                        }
                    }
                    if (breakAdded || !Utilities.startsWith(BREAK_KEYWORD, prefix)) continue block6;
                    breakAdded = true;
                    this.results.add(this.itemFactory.createKeywordItem(BREAK_KEYWORD, this.withinLabeledStatement(env) ? null : SEMI, this.anchorOffset, false));
                    continue block6;
                }
                case WHILE_LOOP: 
                case DO_WHILE_LOOP: 
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    if (!breakAdded && Utilities.startsWith(BREAK_KEYWORD, prefix)) {
                        breakAdded = true;
                        this.results.add(this.itemFactory.createKeywordItem(BREAK_KEYWORD, this.withinLabeledStatement(env) ? null : SEMI, this.anchorOffset, false));
                    }
                    if (continueAdded || !Utilities.startsWith(CONTINUE_KEYWORD, prefix)) continue block6;
                    continueAdded = true;
                    this.results.add(this.itemFactory.createKeywordItem(CONTINUE_KEYWORD, this.withinLabeledStatement(env) ? null : SEMI, this.anchorOffset, false));
                }
            }
        }
        if (env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_10) >= 0 && Utilities.startsWith(VAR_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(VAR_KEYWORD, SPACE, this.anchorOffset, false));
        }
    }

    private void addKeywordsForStatement(BaseTask.Env env) {
        TreePath tp;
        String prefix = env.getPrefix();
        for (String kw : STATEMENT_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, null, this.anchorOffset, false));
        }
        for (String kw : STATEMENT_SPACE_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
        if (Utilities.startsWith(RETURN_KEYWORD, prefix)) {
            tp = env.getController().getTreeUtilities().getPathElementOfKind(EnumSet.of(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION), env.getPath());
            String postfix = SPACE;
            if (tp != null) {
                if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
                    Tree rt = ((MethodTree)tp.getLeaf()).getReturnType();
                    if (rt == null || rt.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)rt).getPrimitiveTypeKind() == TypeKind.VOID) {
                        postfix = SEMI;
                    }
                } else {
                    ExecutableType dt;
                    TypeMirror tm = env.getController().getTrees().getTypeMirror(tp);
                    if (tm != null && tm.getKind() == TypeKind.DECLARED && (dt = env.getController().getTypeUtilities().getDescriptorType((DeclaredType)tm)) != null && dt.getReturnType().getKind() == TypeKind.VOID) {
                        postfix = SEMI;
                    }
                }
            }
            this.results.add(this.itemFactory.createKeywordItem(RETURN_KEYWORD, postfix, this.anchorOffset, false));
        }
        boolean cAdded = false;
        boolean bAdded = false;
        block6: for (tp = env.getPath(); !(tp == null || cAdded && bAdded); tp = tp.getParentPath()) {
            switch (tp.getLeaf().getKind()) {
                case WHILE_LOOP: 
                case DO_WHILE_LOOP: 
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    if (!cAdded && Utilities.startsWith(CONTINUE_KEYWORD, prefix)) {
                        this.results.add(this.itemFactory.createKeywordItem(CONTINUE_KEYWORD, SEMI, this.anchorOffset, false));
                        cAdded = true;
                    }
                }
                case SWITCH: {
                    if (bAdded || !Utilities.startsWith(BREAK_KEYWORD, prefix)) continue block6;
                    this.results.add(this.itemFactory.createKeywordItem(BREAK_KEYWORD, SEMI, this.anchorOffset, false));
                    bAdded = true;
                }
            }
        }
    }

    private void addValueKeywords(BaseTask.Env env) throws IOException {
        boolean isVar;
        Set<TypeMirror> smartTypes;
        String prefix = env.getPrefix();
        boolean smartType = false;
        if (!this.options.contains((Object)Options.ALL_COMPLETION) && (smartTypes = this.getSmartTypes(env)) != null && !smartTypes.isEmpty()) {
            for (TypeMirror st : smartTypes) {
                if (st.getKind() != TypeKind.BOOLEAN) continue;
                smartType = true;
                break;
            }
        }
        if (Utilities.startsWith(FALSE_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(FALSE_KEYWORD, null, this.anchorOffset, smartType));
        }
        if (Utilities.startsWith(TRUE_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(TRUE_KEYWORD, null, this.anchorOffset, smartType));
        }
        boolean bl = isVar = env.getPath().getLeaf().getKind() == Tree.Kind.VARIABLE && env.getController().getTreeUtilities().isSynthetic(new TreePath(env.getPath(), ((VariableTree)env.getPath().getLeaf()).getType()));
        if (Utilities.startsWith(NULL_KEYWORD, prefix) && !isVar) {
            this.results.add(this.itemFactory.createKeywordItem(NULL_KEYWORD, null, this.anchorOffset, false));
        }
        if (Utilities.startsWith(NEW_KEYWORD, prefix)) {
            this.results.add(this.itemFactory.createKeywordItem(NEW_KEYWORD, SPACE, this.anchorOffset, false));
        }
    }

    private void addPrimitiveTypeKeywords(BaseTask.Env env) {
        String prefix = env.getPrefix();
        for (String kw : PRIM_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, null, this.anchorOffset, false));
        }
    }

    private void addClassModifiers(BaseTask.Env env, Set<Modifier> modifiers) {
        String prefix = env.getPrefix();
        ArrayList<String> kws = new ArrayList<String>();
        if (!modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PRIVATE)) {
            kws.add(PUBLIC_KEYWORD);
        }
        if (!modifiers.contains((Object)Modifier.FINAL)) {
            if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
                kws.add(ABSTRACT_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.SEALED) && !modifiers.contains((Object)Modifier.NON_SEALED)) {
                if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
                    kws.add(FINAL_KEYWORD);
                }
                if (this.isSealedSupported(env)) {
                    kws.add(SEALED_KEYWORD);
                    kws.add(NON_SEALED_KEYWORD);
                }
            }
        }
        kws.add(CLASS_KEYWORD);
        kws.add(INTERFACE_KEYWORD);
        kws.add(ENUM_KEYWORD);
        if (this.isRecordSupported(env)) {
            kws.add(RECORD_KEYWORD);
        }
        for (String kw : kws) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
    }

    private void addMemberModifiers(BaseTask.Env env, Set<Modifier> modifiers, boolean isLocal) {
        String prefix = env.getPrefix();
        ArrayList<String> kws = new ArrayList<String>();
        if (isLocal) {
            if (!modifiers.contains((Object)Modifier.FINAL)) {
                kws.add(FINAL_KEYWORD);
            }
        } else {
            if (!(modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PRIVATE))) {
                kws.add(PUBLIC_KEYWORD);
                kws.add(PROTECTED_KEYWORD);
                kws.add(PRIVATE_KEYWORD);
            }
            if (!(env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_8) < 0 || env.getController().getTreeUtilities().getPathElementOfKind(Tree.Kind.INTERFACE, env.getPath()) == null || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.ABSTRACT) || modifiers.contains((Object)Modifier.DEFAULT))) {
                kws.add(DEFAULT_KEYWORD);
            }
            if (!(modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.ABSTRACT) || modifiers.contains((Object)Modifier.VOLATILE))) {
                kws.add(FINAL_KEYWORD);
            }
            if (!(modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.ABSTRACT) || modifiers.contains((Object)Modifier.DEFAULT) || modifiers.contains((Object)Modifier.NATIVE) || modifiers.contains((Object)Modifier.SYNCHRONIZED))) {
                kws.add(ABSTRACT_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.DEFAULT)) {
                kws.add(STATIC_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE)) {
                kws.add(NATIVE_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.STRICTFP)) {
                kws.add(STRICT_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.SYNCHRONIZED) && !modifiers.contains((Object)Modifier.ABSTRACT)) {
                kws.add(SYNCHRONIZED_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.TRANSIENT)) {
                kws.add(TRANSIENT_KEYWORD);
            }
            if (!modifiers.contains((Object)Modifier.FINAL) && !modifiers.contains((Object)Modifier.VOLATILE)) {
                kws.add(VOLATILE_KEYWORD);
            }
            kws.add(VOID_KEYWORD);
            kws.add(CLASS_KEYWORD);
            kws.add(INTERFACE_KEYWORD);
            kws.add(ENUM_KEYWORD);
            if (this.isRecordSupported(env)) {
                kws.add(RECORD_KEYWORD);
            }
        }
        for (String kw : kws) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
        for (String kw : PRIM_KEYWORDS) {
            if (!Utilities.startsWith(kw, prefix)) continue;
            this.results.add(this.itemFactory.createKeywordItem(kw, SPACE, this.anchorOffset, false));
        }
    }

    private void addElementCreators(BaseTask.Env env) throws IOException {
        TypeMirror tm;
        CompilationController controller = env.getController();
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        TreeUtilities tu = controller.getTreeUtilities();
        TreePath clsPath = tu.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, env.getPath());
        if (clsPath == null) {
            return;
        }
        ClassTree cls = (ClassTree)clsPath.getLeaf();
        CompilationUnitTree root = env.getRoot();
        SourcePositions sourcePositions = env.getSourcePositions();
        Tree currentMember = null;
        int nextMemberPos = -1;
        for (Tree tree : cls.getMembers()) {
            int pos = (int)sourcePositions.getStartPosition(root, tree);
            if (pos >= this.caretOffset) {
                nextMemberPos = pos;
                break;
            }
            pos = (int)sourcePositions.getEndPosition(root, tree);
            if (this.caretOffset >= pos) continue;
            currentMember = tree;
            nextMemberPos = pos;
            break;
        }
        if (nextMemberPos > this.caretOffset) {
            String text = controller.getText().substring(this.caretOffset, nextMemberPos);
            int n = text.indexOf(10);
            if (n >= 0) {
                text = text.substring(0, n);
            }
            if (text.trim().length() > 0) {
                return;
            }
        }
        Trees trees = controller.getTrees();
        ElementUtilities elementUtilities = controller.getElementUtilities();
        TypeElement te = (TypeElement)trees.getElement(clsPath);
        if (te == null || te.getKind() == ElementKind.ANNOTATION_TYPE) {
            return;
        }
        String prefix = env.getPrefix();
        Types types = controller.getTypes();
        DeclaredType clsType = (DeclaredType)te.asType();
        if (te.getKind().isClass() || te.getKind().isInterface() && SourceVersion.RELEASE_8.compareTo(controller.getSourceVersion()) <= 0) {
            for (Object ee : elementUtilities.findUnimplementedMethods(te)) {
                if (!this.startsWith(env, ee.getSimpleName().toString()) || (tm = this.asMemberOf((Element)ee, clsType, types)).getKind() != TypeKind.EXECUTABLE) continue;
                this.results.add(this.itemFactory.createOverrideMethodItem((CompilationInfo)env.getController(), (ExecutableElement)ee, (ExecutableType)tm, this.anchorOffset, true));
            }
        }
        if (te.getKind().isClass() || te.getKind().isInterface()) {
            for (Object ee : elementUtilities.findOverridableMethods(te)) {
                if (!this.startsWith(env, ee.getSimpleName().toString()) || (tm = this.asMemberOf((Element)ee, clsType, types)).getKind() != TypeKind.EXECUTABLE) continue;
                this.results.add(this.itemFactory.createOverrideMethodItem((CompilationInfo)env.getController(), (ExecutableElement)ee, (ExecutableType)tm, this.anchorOffset, false));
            }
        }
        if (!te.getKind().isClass()) {
            return;
        }
        if (prefix == null || this.startsWith(env, "get") || this.startsWith(env, "set") || this.startsWith(env, "is") || this.startsWith(env, prefix, "get") || this.startsWith(env, prefix, "set") || this.startsWith(env, prefix, "is")) {
            CodeStyle codeStyle = CodeStyle.getDefault((Document)controller.getDocument());
            for (VariableElement variableElement : ElementFilter.fieldsIn(controller.getElements().getAllMembers(te))) {
                Name name = variableElement.getSimpleName();
                if (name.contentEquals(ERROR)) continue;
                boolean isStatic = variableElement.getModifiers().contains((Object)Modifier.STATIC);
                String setterName = CodeStyleUtils.computeSetterName((CharSequence)name, (boolean)isStatic, (CodeStyle)codeStyle);
                String getterName = CodeStyleUtils.computeGetterName((CharSequence)name, (variableElement.asType().getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0, (boolean)isStatic, (CodeStyle)codeStyle);
                if ((prefix == null || this.startsWith(env, getterName)) && !elementUtilities.hasGetter(te, variableElement, codeStyle)) {
                    this.results.add(this.itemFactory.createGetterSetterMethodItem((CompilationInfo)env.getController(), variableElement, this.asMemberOf(variableElement, clsType, types), this.anchorOffset, getterName, false));
                }
                if (prefix != null && !this.startsWith(env, setterName) || variableElement.getModifiers().contains((Object)Modifier.FINAL) || elementUtilities.hasSetter(te, variableElement, codeStyle)) continue;
                this.results.add(this.itemFactory.createGetterSetterMethodItem((CompilationInfo)env.getController(), variableElement, this.asMemberOf(variableElement, clsType, types), this.anchorOffset, setterName, true));
            }
        }
        if (this.startsWith(env, te.getSimpleName().toString())) {
            Element e;
            Set uninitializedFields = tu.getUninitializedFields(clsPath);
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(te.getEnclosedElements());
            if (currentMember != null && currentMember.getKind() == Tree.Kind.VARIABLE && (e = trees.getElement(new TreePath(clsPath, currentMember))).getKind().isField()) {
                uninitializedFields.remove((VariableElement)e);
            }
            Parameterizable dctor2generate = null;
            LinkedHashMap<ExecutableElement, boolean[]> ctors2generate = new LinkedHashMap<ExecutableElement, boolean[]>();
            LinkedHashSet<VariableElement> uninitializedFinalFields = new LinkedHashSet<VariableElement>();
            for (VariableElement ve : uninitializedFields) {
                if (!ve.getModifiers().contains((Object)Modifier.FINAL)) continue;
                uninitializedFinalFields.add(ve);
            }
            int ufSize = uninitializedFields.size();
            int uffSize = uninitializedFinalFields.size();
            if (cls.getKind() != Tree.Kind.ENUM && te.getSuperclass().getKind() == TypeKind.DECLARED) {
                DeclaredType superType = (DeclaredType)te.getSuperclass();
                Scope scope = env.getScope();
                for (ExecutableElement ctor : ElementFilter.constructorsIn(superType.asElement().getEnclosedElements())) {
                    if (!trees.isAccessible(scope, ctor, superType)) continue;
                    if (dctor2generate == null || ((ExecutableElement)dctor2generate).getParameters().size() > ctor.getParameters().size()) {
                        dctor2generate = ctor;
                    }
                    ctors2generate.put(ctor, new boolean[]{uffSize > 0 && uffSize < ufSize, ufSize > 0});
                }
            } else {
                dctor2generate = te;
                ctors2generate.put(null, new boolean[]{uffSize > 0 && uffSize < ufSize, ufSize > 0});
            }
            for (ExecutableElement executableElement : constructors) {
                if (elementUtilities.isSynthetic((Element)executableElement)) continue;
                List<? extends VariableElement> parameters = executableElement.getParameters();
                if (parameters.isEmpty()) {
                    dctor2generate = null;
                }
                for (Map.Entry entry : ctors2generate.entrySet()) {
                    boolean same;
                    Iterator<? extends VariableElement> original;
                    Iterator<Object> proposed;
                    List params = entry.getKey() != null ? ((ExecutableElement)entry.getKey()).getParameters() : Collections.emptyList();
                    int paramSize = params.size();
                    if (uffSize > 0 && uffSize < ufSize && parameters.size() == paramSize + uffSize) {
                        proposed = uninitializedFinalFields.iterator();
                        original = parameters.iterator();
                        for (same = true; same && proposed.hasNext() && original.hasNext(); same &= types.isSameType(((VariableElement)proposed.next()).asType(), original.next().asType())) {
                        }
                        if (same) {
                            proposed = params.iterator();
                            while (same && proposed.hasNext() && original.hasNext()) {
                                same &= types.isSameType(((VariableElement)proposed.next()).asType(), original.next().asType());
                            }
                            if (same) {
                                ((boolean[])entry.getValue())[0] = false;
                            }
                        }
                    }
                    if (parameters.size() != paramSize + ufSize) continue;
                    proposed = uninitializedFields.iterator();
                    original = parameters.iterator();
                    for (same = true; same && proposed.hasNext() && original.hasNext(); same &= types.isSameType(((VariableElement)proposed.next()).asType(), original.next().asType())) {
                    }
                    if (!same) continue;
                    proposed = params.iterator();
                    while (same && proposed.hasNext() && original.hasNext()) {
                        same &= types.isSameType(((VariableElement)proposed.next()).asType(), original.next().asType());
                    }
                    if (!same) continue;
                    ((boolean[])entry.getValue())[1] = false;
                }
            }
            if (dctor2generate != null) {
                this.results.add(this.itemFactory.createInitializeAllConstructorItem((CompilationInfo)env.getController(), true, uninitializedFinalFields, dctor2generate.getKind() == ElementKind.CONSTRUCTOR ? (ExecutableElement)dctor2generate : null, te, this.anchorOffset));
            }
            for (Map.Entry entry : ctors2generate.entrySet()) {
                if (((boolean[])entry.getValue())[0]) {
                    this.results.add(this.itemFactory.createInitializeAllConstructorItem((CompilationInfo)env.getController(), false, uninitializedFinalFields, (ExecutableElement)entry.getKey(), te, this.anchorOffset));
                }
                if (!((boolean[])entry.getValue())[1]) continue;
                this.results.add(this.itemFactory.createInitializeAllConstructorItem((CompilationInfo)env.getController(), false, uninitializedFields, (ExecutableElement)entry.getKey(), te, this.anchorOffset));
            }
        }
    }

    private TypeElement getTypeElement(BaseTask.Env env, final String simpleName) throws IOException {
        if (simpleName == null || simpleName.length() == 0) {
            return null;
        }
        CompilationController controller = env.getController();
        TreeUtilities tu = controller.getTreeUtilities();
        final Trees trees = controller.getTrees();
        final Scope scope = env.getScope();
        TypeElement enclClass = scope.getEnclosingClass();
        final boolean isStatic = enclClass == null ? false : tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic();
        Object acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                return !(!e.getKind().isClass() && !e.getKind().isInterface() || !e.getSimpleName().contentEquals(simpleName) || isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(scope, e, (DeclaredType)t));
            }
        };
        Iterator iterator = controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor).iterator();
        if (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            return (TypeElement)e;
        }
        acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                return e.getSimpleName().contentEquals(simpleName) && trees.isAccessible(scope, (TypeElement)e);
            }
        };
        for (TypeElement e : controller.getElementUtilities().getGlobalTypes(acceptor)) {
            if (!simpleName.contentEquals(e.getSimpleName())) continue;
            return e;
        }
        return null;
    }

    private VariableElement getFieldOrVar(BaseTask.Env env, final String simpleName) throws IOException {
        if (simpleName == null || simpleName.length() == 0) {
            return null;
        }
        final CompilationController controller = env.getController();
        Scope scope = env.getScope();
        TypeElement enclClass = scope.getEnclosingClass();
        final boolean isStatic = enclClass == null ? false : controller.getTreeUtilities().isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic();
        final Map<Name, ? extends Element> illegalForwardRefs = env.getForwardReferences();
        final ExecutableElement method = scope.getEnclosingMethod();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror t) {
                if (!e.getSimpleName().contentEquals(simpleName)) {
                    return false;
                }
                switch (JavaCompletionTask.simplifyElementKind(e.getKind())) {
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: {
                        if (isStatic && (e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) || e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD))) {
                            return false;
                        }
                    }
                    case EXCEPTION_PARAMETER: 
                    case PARAMETER: {
                        return (method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL) || controller.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0 && controller.getElementUtilities().isEffectivelyFinal((VariableElement)e)) && (!illegalForwardRefs.containsKey(e.getSimpleName()) || ((Element)illegalForwardRefs.get(e.getSimpleName())).getEnclosingElement() != e.getEnclosingElement());
                    }
                    case FIELD: {
                        if (e.getSimpleName().contentEquals(JavaCompletionTask.THIS_KEYWORD) || e.getSimpleName().contentEquals(JavaCompletionTask.SUPER_KEYWORD)) {
                            return !isStatic;
                        }
                    }
                    case ENUM_CONSTANT: {
                        return !illegalForwardRefs.containsValue(e);
                    }
                }
                return false;
            }
        };
        Iterator iterator = controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor).iterator();
        if (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            return (VariableElement)e;
        }
        return null;
    }

    private TypeMirror getCorrectedReturnType(BaseTask.Env env, ExecutableType et, ExecutableElement el, TypeMirror site) {
        TypeMirror type = et.getReturnType();
        if (site != null && site.getKind() == TypeKind.DECLARED && "getClass".contentEquals(el.getSimpleName()) && et.getParameterTypes().isEmpty() && type.getKind() == TypeKind.DECLARED && JAVA_LANG_CLASS.contentEquals(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName()) && ((TypeElement)((DeclaredType)type).asElement()).getTypeParameters().size() == 1) {
            Types types = env.getController().getTypes();
            type = types.getDeclaredType((TypeElement)((DeclaredType)type).asElement(), types.getWildcardType(site, null));
        }
        return type;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOfSmartType(BaseTask.Env env, TypeMirror type, Set<? extends TypeMirror> smartTypes) {
        void var5_11;
        if (smartTypes == null) return false;
        if (smartTypes.isEmpty()) {
            return false;
        }
        if (env.isInsideForEachExpression()) {
            if (type.getKind() == TypeKind.ARRAY) {
                type = ((ArrayType)type).getComponentType();
            } else {
                if (type.getKind() != TypeKind.DECLARED) return false;
                Elements elements = env.getController().getElements();
                Types types = env.getController().getTypes();
                TypeElement iterableTE = elements.getTypeElement(JAVA_LANG_ITERABLE);
                if (iterableTE == null) return false;
                DeclaredType declaredType = types.getDeclaredType(iterableTE, new TypeMirror[0]);
                DeclaredType declaredType2 = declaredType;
                if (declaredType2 == null) return false;
                if (!types.isSubtype(type, declaredType2)) return false;
                Iterator<? extends TypeMirror> it = ((DeclaredType)type).getTypeArguments().iterator();
                type = it.hasNext() ? it.next() : elements.getTypeElement(JAVA_LANG_OBJECT).asType();
            }
        } else if (type.getKind() == TypeKind.EXECUTABLE) {
            ExecutableType descriptorType;
            TypeMirror typeMirror;
            Types types = env.getController().getTypes();
            TypeUtilities typeUtilities = env.getController().getTypeUtilities();
            Iterator<? extends TypeMirror> iterator = smartTypes.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((typeMirror = iterator.next()).getKind() != TypeKind.DECLARED || (descriptorType = typeUtilities.getDescriptorType((DeclaredType)typeMirror)) == null || !types.isSubsignature((ExecutableType)type, descriptorType) || !types.isSubtype(((ExecutableType)type).getReturnType(), descriptorType.getReturnType()));
            return true;
        }
        Iterator<? extends TypeMirror> iterator = smartTypes.iterator();
        do {
            if (!iterator.hasNext()) return false;
            TypeMirror typeMirror = iterator.next();
            if (type.getKind() != TypeKind.DECLARED) continue;
            TypeMirror typeMirror2 = this.inferDeclaredType(env.getController().getTypes(), (DeclaredType)type, typeMirror);
        } while (!SourceUtils.checkTypesAssignable((CompilationInfo)env.getController(), (TypeMirror)type, (TypeMirror)var5_11));
        return true;
    }

    private boolean isTopLevelClass(Tree tree, CompilationUnitTree root) {
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((ExpressionStatementTree)tree).getExpression().getKind() == Tree.Kind.ERRONEOUS) {
            for (Tree tree2 : root.getTypeDecls()) {
                if (tree != tree2) continue;
                return true;
            }
        }
        return tree.getKind() == Tree.Kind.COMPILATION_UNIT;
    }

    private static boolean isAnnonInner(ElementHandle<TypeElement> elem) {
        String name = elem.getQualifiedName();
        int idx = name.lastIndexOf(46);
        String simpleName = idx > -1 ? name.substring(idx + 1) : name;
        return simpleName.length() == 0 || Character.isDigit(simpleName.charAt(0));
    }

    private boolean isOfKindAndType(TypeMirror type, Element e, EnumSet<ElementKind> kinds, TypeMirror base, Scope scope, Trees trees, Types types) {
        if (type.getKind() != TypeKind.ERROR && kinds.contains((Object)e.getKind())) {
            if (base == null) {
                return true;
            }
            if (types.isSubtype(type, base)) {
                return true;
            }
        }
        if ((e.getKind().isClass() || e.getKind().isInterface()) && (kinds.contains((Object)ElementKind.ANNOTATION_TYPE) || kinds.contains((Object)ElementKind.CLASS) || kinds.contains((Object)ElementKind.ENUM) || kinds.contains((Object)ElementKind.INTERFACE))) {
            DeclaredType dt = (DeclaredType)e.asType();
            for (Element element : e.getEnclosedElements()) {
                if (!trees.isAccessible(scope, element, dt) || !this.isOfKindAndType(element.asType(), element, kinds, base, scope, trees, types)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsAccessibleNonFinalType(Element e, Scope scope, Trees trees) {
        if (e.getKind().isClass() || e.getKind().isInterface()) {
            if (!e.getModifiers().contains((Object)Modifier.FINAL)) {
                return true;
            }
            DeclaredType dt = (DeclaredType)e.asType();
            for (Element element : e.getEnclosedElements()) {
                if (!trees.isAccessible(scope, element, dt) || !this.containsAccessibleNonFinalType(element, scope, trees)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<? extends TypeMirror> getSmartTypes(BaseTask.Env env) throws IOException {
        Set<? extends TypeMirror> smartTypes = env.getSmartTypes();
        if (smartTypes == null) {
            CompilationController controller = env.getController();
            controller.toPhase(JavaSource.Phase.RESOLVED);
            smartTypes = this.getSmartTypesImpl(env);
            if (smartTypes != null) {
                Iterator<? extends TypeMirror> it = smartTypes.iterator();
                TypeMirror err = null;
                if (it.hasNext()) {
                    err = it.next();
                    if (it.hasNext() || err.getKind() != TypeKind.ERROR) {
                        err = null;
                    }
                }
                if (err != null) {
                    HashSet<? extends TypeMirror> st = new HashSet<TypeMirror>();
                    Types types = controller.getTypes();
                    TypeElement te = (TypeElement)((DeclaredType)err).asElement();
                    if (te.getQualifiedName() == te.getSimpleName()) {
                        ClassIndex ci = controller.getClasspathInfo().getClassIndex();
                        for (ElementHandle eh : ci.getDeclaredTypes(te.getSimpleName().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                            te = (TypeElement)eh.resolve((CompilationInfo)controller);
                            if (te == null) continue;
                            st.add(types.erasure(te.asType()));
                        }
                    }
                    smartTypes = st;
                }
            }
            env.setSmartTypes(smartTypes);
        }
        return smartTypes;
    }

    private Set<? extends TypeMirror> getSmartTypesImpl(BaseTask.Env env) throws IOException {
        int offset = env.getOffset();
        CompilationController controller = env.getController();
        TreeUtilities tu = controller.getTreeUtilities();
        Tree lastTree = null;
        int dim = 0;
        for (TreePath path = tu.pathFor(offset); path != null; path = path.getParentPath()) {
            Tree tree = path.getLeaf();
            switch (tree.getKind()) {
                case VARIABLE: {
                    TypeMirror type = controller.getTrees().getTypeMirror(path);
                    if (type == null) {
                        return null;
                    }
                    while (dim-- > 0) {
                        if (type.getKind() == TypeKind.ARRAY) {
                            type = ((ArrayType)type).getComponentType();
                            continue;
                        }
                        return null;
                    }
                    return type != null ? Collections.singleton(type) : null;
                }
                case ASSIGNMENT: {
                    TypeMirror type = controller.getTrees().getTypeMirror(new TreePath(path, ((AssignmentTree)tree).getVariable()));
                    if (type == null) {
                        return null;
                    }
                    TreePath parentPath = path.getParentPath();
                    if (parentPath != null && parentPath.getLeaf().getKind() == Tree.Kind.ANNOTATION && type.getKind() == TypeKind.EXECUTABLE) {
                        type = ((ExecutableType)type).getReturnType();
                        while (dim-- > 0) {
                            if (type.getKind() == TypeKind.ARRAY) {
                                type = ((ArrayType)type).getComponentType();
                                continue;
                            }
                            return null;
                        }
                        if (type.getKind() == TypeKind.ARRAY) {
                            type = ((ArrayType)type).getComponentType();
                        }
                    }
                    return type != null ? Collections.singleton(type) : null;
                }
                case RETURN: {
                    ExecutableType descType;
                    TypeMirror type;
                    TreePath methodOrLambdaPath = tu.getPathElementOfKind(EnumSet.of(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION), path);
                    if (methodOrLambdaPath == null) {
                        return null;
                    }
                    if (methodOrLambdaPath.getLeaf().getKind() == Tree.Kind.METHOD) {
                        Tree retTree = ((MethodTree)methodOrLambdaPath.getLeaf()).getReturnType();
                        if (retTree == null) {
                            return null;
                        }
                        type = controller.getTrees().getTypeMirror(new TreePath(methodOrLambdaPath, retTree));
                        if (type == null && JavaSource.Phase.RESOLVED.compareTo((Enum)controller.getPhase()) > 0) {
                            controller.toPhase(JavaSource.Phase.RESOLVED);
                            type = controller.getTrees().getTypeMirror(new TreePath(methodOrLambdaPath, retTree));
                        }
                        return type != null ? Collections.singleton(type) : null;
                    }
                    type = controller.getTrees().getTypeMirror(methodOrLambdaPath);
                    if (type == null || type.getKind() != TypeKind.DECLARED || (descType = controller.getTypeUtilities().getDescriptorType((DeclaredType)type)) == null) break;
                    return Collections.singleton(descType.getReturnType());
                }
                case THROW: {
                    TypeMirror type;
                    TreePath methodPath = tu.getPathElementOfKind(Tree.Kind.METHOD, path);
                    if (methodPath == null) {
                        return null;
                    }
                    HashSet<TypeMirror> ret = new HashSet<TypeMirror>();
                    Trees trees = controller.getTrees();
                    for (ExpressionTree expressionTree : ((MethodTree)methodPath.getLeaf()).getThrows()) {
                        type = trees.getTypeMirror(new TreePath(methodPath, expressionTree));
                        if (type == null && JavaSource.Phase.RESOLVED.compareTo((Enum)controller.getPhase()) > 0) {
                            controller.toPhase(JavaSource.Phase.RESOLVED);
                            type = trees.getTypeMirror(new TreePath(methodPath, expressionTree));
                        }
                        if (type == null) continue;
                        ret.add(type);
                    }
                    return ret;
                }
                case TRY: {
                    TryTree tt = (TryTree)tree;
                    BlockTree blockTree = tt.getBlock();
                    SourcePositions sourcePositions = env.getSourcePositions();
                    if (blockTree != null && sourcePositions.getStartPosition(env.getRoot(), blockTree) <= (long)offset) {
                        return null;
                    }
                    TypeElement te = controller.getElements().getTypeElement("java.lang.AutoCloseable");
                    return te != null ? Collections.singleton(controller.getTypes().getDeclaredType(te, new TypeMirror[0])) : null;
                }
                case IF: {
                    IfTree iff = (IfTree)tree;
                    return iff.getCondition() == lastTree ? Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN)) : null;
                }
                case WHILE_LOOP: {
                    WhileLoopTree wl = (WhileLoopTree)tree;
                    return wl.getCondition() == lastTree ? Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN)) : null;
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree dwl = (DoWhileLoopTree)tree;
                    return dwl.getCondition() == lastTree ? Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN)) : null;
                }
                case FOR_LOOP: {
                    String text;
                    ForLoopTree fl = (ForLoopTree)tree;
                    Tree cond = fl.getCondition();
                    if (lastTree != null) {
                        Iterator<? extends Tree> itt;
                        if (cond instanceof ErroneousTree && (itt = ((ErroneousTree)cond).getErrorTrees().iterator()).hasNext()) {
                            cond = itt.next();
                        }
                        return cond == lastTree ? Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN)) : null;
                    }
                    SourcePositions sourcePositions = env.getSourcePositions();
                    CompilationUnitTree root = env.getRoot();
                    if (cond != null && sourcePositions.getEndPosition(root, cond) < (long)offset) {
                        return null;
                    }
                    Tree lastInit = null;
                    for (Tree tree2 : fl.getInitializer()) {
                        if (sourcePositions.getEndPosition(root, tree2) >= (long)offset) {
                            return null;
                        }
                        lastInit = tree2;
                    }
                    if (lastInit == null) {
                        text = controller.getText().substring((int)sourcePositions.getStartPosition(root, fl), offset).trim();
                        int n = text.indexOf(40);
                        if (n >= 0) {
                            text = text.substring(n + 1);
                        }
                    } else {
                        text = controller.getText().substring((int)sourcePositions.getEndPosition(root, lastInit), offset).trim();
                    }
                    return SEMI.equals(text) ? Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN)) : null;
                }
                case ENHANCED_FOR_LOOP: {
                    String text;
                    CompilationUnitTree root;
                    SourcePositions sourcePositions;
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                    Tree expr = enhancedForLoopTree.getExpression();
                    if (lastTree != null) {
                        Iterator<? extends Tree> itt;
                        if (expr instanceof ErroneousTree && (itt = ((ErroneousTree)expr).getErrorTrees().iterator()).hasNext()) {
                            expr = itt.next();
                        }
                        if (expr != lastTree) {
                            return null;
                        }
                    } else {
                        sourcePositions = env.getSourcePositions();
                        root = env.getRoot();
                        if (enhancedForLoopTree.getVariable() == null || sourcePositions.getEndPosition(root, enhancedForLoopTree.getVariable()) > (long)offset) {
                            text = controller.getText().substring((int)sourcePositions.getStartPosition(root, enhancedForLoopTree), offset).trim();
                            int idx = text.indexOf(40);
                            if (idx >= 0) {
                                text = text.substring(idx + 1);
                            }
                        } else {
                            text = controller.getText().substring((int)sourcePositions.getEndPosition(root, enhancedForLoopTree.getVariable()), offset).trim();
                        }
                        if (!COLON.equals(text)) {
                            return null;
                        }
                    }
                    TypeMirror var = enhancedForLoopTree.getVariable() != null ? controller.getTrees().getTypeMirror(new TreePath(path, enhancedForLoopTree.getVariable())) : null;
                    return var != null ? Collections.singleton(var) : null;
                }
                case SWITCH: {
                    SwitchTree sw = (SwitchTree)tree;
                    if (sw.getExpression() != lastTree && sw.getExpression().getKind() != Tree.Kind.ERRONEOUS) {
                        return null;
                    }
                    HashSet<TypeMirror> ret = new HashSet<TypeMirror>();
                    Types types = controller.getTypes();
                    ret.add(controller.getTypes().getPrimitiveType(TypeKind.INT));
                    TypeElement te = controller.getElements().getTypeElement("java.lang.Enum");
                    if (te != null) {
                        ret.add(types.getDeclaredType(te, new TypeMirror[0]));
                    }
                    if (controller.getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0 && (te = controller.getElements().getTypeElement("java.lang.String")) != null) {
                        ret.add(types.getDeclaredType(te, new TypeMirror[0]));
                    }
                    return ret;
                }
                case METHOD_INVOCATION: {
                    Element el;
                    ExpressionTree exp;
                    MethodInvocationTree mi = (MethodInvocationTree)tree;
                    SourcePositions sourcePositions = env.getSourcePositions();
                    CompilationUnitTree root = env.getRoot();
                    List<Tree> argTypes = this.getArgumentsUpToPos(env, mi.getArguments(), (int)sourcePositions.getEndPosition(root, mi.getMethodSelect()), lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset, true);
                    if (argTypes == null) break;
                    TypeMirror[] args = new TypeMirror[argTypes.size()];
                    int j = 0;
                    for (Tree tree3 : argTypes) {
                        args[j++] = controller.getTrees().getTypeMirror(new TreePath(path, tree3));
                    }
                    TypeMirror[] targs = null;
                    if (!mi.getTypeArguments().isEmpty()) {
                        targs = new TypeMirror[mi.getTypeArguments().size()];
                        j = 0;
                        for (Tree t2 : mi.getTypeArguments()) {
                            TypeMirror typeMirror = controller.getTrees().getTypeMirror(new TreePath(path, t2));
                            if (typeMirror == null) {
                                return null;
                            }
                            targs[j++] = typeMirror;
                        }
                    }
                    ExpressionTree expressionTree = mi.getMethodSelect();
                    path = new TreePath(path, expressionTree);
                    TypeMirror typeMirror = controller.getTrees().getTypeMirror(path);
                    ExecutableType executableType = typeMirror != null && typeMirror.getKind() == TypeKind.EXECUTABLE ? (ExecutableType)typeMirror : null;
                    ExecutableElement executableElement = executableType == null ? null : (ExecutableElement)controller.getTrees().getElement(path);
                    switch (expressionTree.getKind()) {
                        case MEMBER_SELECT: {
                            String name = ((MemberSelectTree)expressionTree).getIdentifier().toString();
                            exp = ((MemberSelectTree)expressionTree).getExpression();
                            path = new TreePath(path, exp);
                            TypeMirror tm = controller.getTrees().getTypeMirror(path);
                            el = controller.getTrees().getElement(path);
                            final Trees trs = controller.getTrees();
                            if (el != null && tm.getKind() == TypeKind.DECLARED) {
                                final boolean bl = el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.TYPE_PARAMETER;
                                final boolean isSuperCall = el.getKind().isField() && el.getSimpleName().contentEquals(SUPER_KEYWORD);
                                final Scope scope = env.getScope();
                                TypeElement enclClass = scope.getEnclosingClass();
                                final TypeMirror enclType = enclClass != null ? enclClass.asType() : null;
                                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                    public boolean accept(Element e, TypeMirror t) {
                                        return e.getKind() == ElementKind.METHOD && (!bl || e.getModifiers().contains((Object)Modifier.STATIC)) && trs.isAccessible(scope, e, (DeclaredType)(isSuperCall && enclType != null ? enclType : t));
                                    }
                                };
                                return this.getMatchingArgumentTypes(tm, controller.getElementUtilities().getMembers(tm, acceptor), name, args, targs, executableElement, executableType, controller.getTypes(), controller.getTypeUtilities());
                            }
                            return null;
                        }
                        case IDENTIFIER: {
                            boolean isStatic;
                            String name = ((IdentifierTree)expressionTree).getName().toString();
                            final Scope scope = env.getScope();
                            final Trees trs = controller.getTrees();
                            TypeElement enclClass = scope.getEnclosingClass();
                            boolean bl = enclClass != null ? tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic() : (isStatic = false);
                            if (SUPER_KEYWORD.equals(name) && enclClass != null) {
                                ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                                    public boolean accept(Element e, TypeMirror t) {
                                        return e.getKind() == ElementKind.CONSTRUCTOR && trs.isAccessible(scope, e, (DeclaredType)t);
                                    }
                                };
                                TypeMirror superclass = enclClass.getSuperclass();
                                return this.getMatchingArgumentTypes(superclass, controller.getElementUtilities().getMembers(superclass, elementAcceptor), INIT, args, targs, executableElement, executableType, controller.getTypes(), controller.getTypeUtilities());
                            }
                            ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element e, TypeMirror t) {
                                    return e.getKind() == ElementKind.METHOD && (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && trs.isAccessible(scope, e, (DeclaredType)t);
                                }
                            };
                            return this.getMatchingArgumentTypes(enclClass != null ? enclClass.asType() : null, controller.getElementUtilities().getLocalMembersAndVars(scope, elementAcceptor), THIS_KEYWORD.equals(name) ? INIT : name, args, targs, executableElement, executableType, controller.getTypes(), controller.getTypeUtilities());
                        }
                    }
                    break;
                }
                case NEW_CLASS: {
                    Element element;
                    NewClassTree nc = (NewClassTree)tree;
                    SourcePositions sourcePositions = env.getSourcePositions();
                    CompilationUnitTree root = env.getRoot();
                    int idEndPos = (int)sourcePositions.getEndPosition(root, nc.getIdentifier());
                    if (idEndPos < 0) {
                        idEndPos = (int)sourcePositions.getStartPosition(root, nc);
                    }
                    if (idEndPos < 0 || idEndPos >= offset || controller.getText().substring(idEndPos, offset).indexOf(40) < 0) break;
                    List<Tree> argTypes = this.getArgumentsUpToPos(env, nc.getArguments(), idEndPos, lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset, true);
                    if (argTypes == null) break;
                    Trees trees = controller.getTrees();
                    TypeMirror[] args = new TypeMirror[argTypes.size()];
                    boolean bl = false;
                    for (Tree tree4 : argTypes) {
                        args[++var37_27] = trees.getTypeMirror(new TreePath(path, tree4));
                    }
                    TypeMirror[] targs = null;
                    if (!nc.getTypeArguments().isEmpty()) {
                        targs = new TypeMirror[nc.getTypeArguments().size()];
                        boolean bl2 = false;
                        for (Tree tree5 : nc.getTypeArguments()) {
                            TypeMirror ta = trees.getTypeMirror(new TreePath(path, tree5));
                            if (ta == null) {
                                return null;
                            }
                            targs[++var37_29] = ta;
                        }
                    }
                    ExecutableElement executableElement = (element = controller.getTrees().getElement(path)) != null && element.getKind() == ElementKind.CONSTRUCTOR ? (ExecutableElement)element : null;
                    TypeMirror ncTM = executableElement != null ? executableElement.asType() : null;
                    ExecutableType ncType = ncTM != null && ncTM.getKind() == TypeKind.EXECUTABLE ? (ExecutableType)ncTM : null;
                    ExpressionTree mid = nc.getIdentifier();
                    TypeMirror tm = trees.getTypeMirror(path = new TreePath(path, mid));
                    if (tm != null && tm.getKind() == TypeKind.ERROR && path.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                        path = new TreePath(path, ((ParameterizedTypeTree)path.getLeaf()).getType());
                        tm = trees.getTypeMirror(path);
                    }
                    Element el = controller.getTrees().getElement(path);
                    final Trees trees2 = controller.getTrees();
                    if (el != null && tm.getKind() == TypeKind.DECLARED) {
                        final Scope scope = env.getScope();
                        final boolean isAnonymous = nc.getClassBody() != null || el.getKind().isInterface() || el.getModifiers().contains((Object)Modifier.ABSTRACT);
                        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element e, TypeMirror t) {
                                return e.getKind() == ElementKind.CONSTRUCTOR && (trees2.isAccessible(scope, e, (DeclaredType)t) || isAnonymous && e.getModifiers().contains((Object)Modifier.PROTECTED));
                            }
                        };
                        return this.getMatchingArgumentTypes(tm, controller.getElementUtilities().getMembers(tm, acceptor), INIT, args, targs, executableElement, ncType, controller.getTypes(), controller.getTypeUtilities());
                    }
                    return null;
                }
                case NEW_ARRAY: {
                    CompilationUnitTree root;
                    TypeMirror type;
                    NewArrayTree nat = (NewArrayTree)tree;
                    Tree tree6 = nat.getType();
                    if (tree6 == null) {
                        ++dim;
                        break;
                    }
                    SourcePositions sourcePositions = env.getSourcePositions();
                    int typeEndPos = (int)sourcePositions.getEndPosition(root = env.getRoot(), tree6);
                    if (typeEndPos > offset) break;
                    String text = controller.getText().substring(typeEndPos, offset);
                    if (text.indexOf(123) >= 0) {
                        type = controller.getTrees().getTypeMirror(new TreePath(path, tree6));
                        while (dim-- > 0) {
                            if (type.getKind() == TypeKind.ARRAY) {
                                type = ((ArrayType)type).getComponentType();
                                continue;
                            }
                            return null;
                        }
                        return type != null ? Collections.singleton(type) : null;
                    }
                    if (text.trim().endsWith("[")) {
                        return Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.INT));
                    }
                    return null;
                }
                case LAMBDA_EXPRESSION: {
                    ExecutableType descType;
                    TypeMirror type;
                    LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
                    int n = (int)env.getSourcePositions().getStartPosition(env.getRoot(), lambdaExpressionTree.getBody());
                    if (offset <= n && this.findLastNonWhitespaceToken(env, tree, offset).token().id() != JavaTokenId.ARROW || lastTree != null && lastTree.getKind() == Tree.Kind.BLOCK || (type = controller.getTrees().getTypeMirror(path)) == null || type.getKind() != TypeKind.DECLARED || (descType = controller.getTypeUtilities().getDescriptorType((DeclaredType)type)) == null) break;
                    return Collections.singleton(descType.getReturnType());
                }
                case CASE: {
                    TreePath parentPath;
                    TypeMirror type;
                    CaseTree ct = (CaseTree)tree;
                    ExpressionTree exp = ct.getExpression();
                    if (exp != null && env.getSourcePositions().getEndPosition(env.getRoot(), exp) >= (long)offset && (parentPath = path.getParentPath()).getLeaf().getKind() == Tree.Kind.SWITCH) {
                        exp = ((SwitchTree)parentPath.getLeaf()).getExpression();
                        type = controller.getTrees().getTypeMirror(new TreePath(parentPath, exp));
                        return type != null ? Collections.singleton(type) : null;
                    }
                    return null;
                }
                case ANNOTATION: {
                    int n;
                    Element el;
                    TypeMirror type;
                    AnnotationTree ann = (AnnotationTree)tree;
                    int n2 = (int)env.getSourcePositions().getStartPosition(env.getRoot(), ann.getAnnotationType());
                    if (offset <= n2 || offset < (n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), ann.getAnnotationType()))) break;
                    String text = controller.getText().substring(n, offset).trim();
                    if (("(".equals(text) || text.endsWith("{") || text.endsWith(",")) && (el = (TypeElement)controller.getTrees().getElement(new TreePath(path, ann.getAnnotationType()))) != null) {
                        for (Element element : el.getEnclosedElements()) {
                            if (element.getKind() != ElementKind.METHOD || !"value".contentEquals(element.getSimpleName())) continue;
                            type = ((ExecutableElement)element).getReturnType();
                            while (dim-- > 0) {
                                if (type.getKind() == TypeKind.ARRAY) {
                                    type = ((ArrayType)type).getComponentType();
                                    continue;
                                }
                                return null;
                            }
                            if (type.getKind() == TypeKind.ARRAY) {
                                type = ((ArrayType)type).getComponentType();
                            }
                            return type != null ? Collections.singleton(type) : null;
                        }
                    }
                    return null;
                }
                case REMAINDER_ASSIGNMENT: 
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                case AND_ASSIGNMENT: 
                case XOR_ASSIGNMENT: 
                case OR_ASSIGNMENT: {
                    CompoundAssignmentTree cat = (CompoundAssignmentTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), cat.getVariable());
                    if (offset <= n) break;
                    HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                    Types types = controller.getTypes();
                    ret.add(types.getPrimitiveType(TypeKind.BYTE));
                    ret.add(types.getPrimitiveType(TypeKind.CHAR));
                    ret.add(types.getPrimitiveType(TypeKind.INT));
                    ret.add(types.getPrimitiveType(TypeKind.LONG));
                    ret.add(types.getPrimitiveType(TypeKind.SHORT));
                    return ret;
                }
                case AND: 
                case LEFT_SHIFT: 
                case OR: 
                case REMAINDER: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: 
                case XOR: {
                    BinaryTree bt = (BinaryTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), bt.getLeftOperand());
                    if (offset <= n) break;
                }
                case BITWISE_COMPLEMENT: {
                    HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                    Types types = controller.getTypes();
                    ret.add(types.getPrimitiveType(TypeKind.BYTE));
                    ret.add(types.getPrimitiveType(TypeKind.CHAR));
                    ret.add(types.getPrimitiveType(TypeKind.INT));
                    ret.add(types.getPrimitiveType(TypeKind.LONG));
                    ret.add(types.getPrimitiveType(TypeKind.SHORT));
                    return ret;
                }
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: {
                    BinaryTree bt = (BinaryTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), bt.getLeftOperand());
                    if (offset <= n) break;
                }
                case LOGICAL_COMPLEMENT: {
                    return Collections.singleton(controller.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
                }
                case EQUAL_TO: 
                case NOT_EQUAL_TO: 
                case PLUS: {
                    BinaryTree bt = (BinaryTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), bt.getLeftOperand());
                    if (offset <= n) break;
                    TypeMirror typeMirror = controller.getTrees().getTypeMirror(new TreePath(path, bt.getLeftOperand()));
                    if (typeMirror == null) {
                        return null;
                    }
                    if (typeMirror.getKind().isPrimitive()) {
                        HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                        Types types = controller.getTypes();
                        ret.add(types.getPrimitiveType(TypeKind.BYTE));
                        ret.add(types.getPrimitiveType(TypeKind.CHAR));
                        ret.add(types.getPrimitiveType(TypeKind.DOUBLE));
                        ret.add(types.getPrimitiveType(TypeKind.FLOAT));
                        ret.add(types.getPrimitiveType(TypeKind.INT));
                        ret.add(types.getPrimitiveType(TypeKind.LONG));
                        ret.add(types.getPrimitiveType(TypeKind.SHORT));
                        return ret;
                    }
                    return Collections.singleton(typeMirror);
                }
                case PLUS_ASSIGNMENT: {
                    CompoundAssignmentTree cat = (CompoundAssignmentTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), cat.getVariable());
                    if (offset <= n) break;
                    TypeMirror typeMirror = controller.getTrees().getTypeMirror(new TreePath(path, cat.getVariable()));
                    if (typeMirror == null) {
                        return null;
                    }
                    if (typeMirror.getKind().isPrimitive()) {
                        HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                        Types types = controller.getTypes();
                        ret.add(types.getPrimitiveType(TypeKind.BYTE));
                        ret.add(types.getPrimitiveType(TypeKind.CHAR));
                        ret.add(types.getPrimitiveType(TypeKind.DOUBLE));
                        ret.add(types.getPrimitiveType(TypeKind.FLOAT));
                        ret.add(types.getPrimitiveType(TypeKind.INT));
                        ret.add(types.getPrimitiveType(TypeKind.LONG));
                        ret.add(types.getPrimitiveType(TypeKind.SHORT));
                        return ret;
                    }
                    return Collections.singleton(typeMirror);
                }
                case MULTIPLY_ASSIGNMENT: 
                case DIVIDE_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: {
                    CompoundAssignmentTree cat = (CompoundAssignmentTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), cat.getVariable());
                    if (offset <= n) break;
                    HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                    Types types = controller.getTypes();
                    ret.add(types.getPrimitiveType(TypeKind.BYTE));
                    ret.add(types.getPrimitiveType(TypeKind.CHAR));
                    ret.add(types.getPrimitiveType(TypeKind.DOUBLE));
                    ret.add(types.getPrimitiveType(TypeKind.FLOAT));
                    ret.add(types.getPrimitiveType(TypeKind.INT));
                    ret.add(types.getPrimitiveType(TypeKind.LONG));
                    ret.add(types.getPrimitiveType(TypeKind.SHORT));
                    return ret;
                }
                case DIVIDE: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case MINUS: 
                case MULTIPLY: {
                    BinaryTree bt = (BinaryTree)tree;
                    int n = (int)env.getSourcePositions().getEndPosition(env.getRoot(), bt.getLeftOperand());
                    if (offset <= n) break;
                }
                case PREFIX_INCREMENT: 
                case PREFIX_DECREMENT: 
                case UNARY_PLUS: 
                case UNARY_MINUS: {
                    HashSet<PrimitiveType> ret = new HashSet<PrimitiveType>();
                    Types types = controller.getTypes();
                    ret.add(types.getPrimitiveType(TypeKind.BYTE));
                    ret.add(types.getPrimitiveType(TypeKind.CHAR));
                    ret.add(types.getPrimitiveType(TypeKind.DOUBLE));
                    ret.add(types.getPrimitiveType(TypeKind.FLOAT));
                    ret.add(types.getPrimitiveType(TypeKind.INT));
                    ret.add(types.getPrimitiveType(TypeKind.LONG));
                    ret.add(types.getPrimitiveType(TypeKind.SHORT));
                    return ret;
                }
                case EXPRESSION_STATEMENT: {
                    String text;
                    ExpressionTree exp = ((ExpressionStatementTree)tree).getExpression();
                    if (exp.getKind() != Tree.Kind.PARENTHESIZED || !(text = controller.getText().substring((int)env.getSourcePositions().getStartPosition(env.getRoot(), exp), offset).trim()).endsWith(")")) break;
                    return null;
                }
                case BLOCK: {
                    return null;
                }
            }
            lastTree = tree;
        }
        return null;
    }

    private List<Pair<ExecutableElement, ExecutableType>> getMatchingExecutables(TypeMirror type, Iterable<? extends Element> elements, String name, TypeMirror[] argTypes, Types types) {
        ArrayList<Pair<ExecutableElement, ExecutableType>> ret = new ArrayList<Pair<ExecutableElement, ExecutableType>>();
        block0: for (Element element : elements) {
            if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD || !name.contentEquals(element.getSimpleName())) continue;
            List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
            int parSize = params.size();
            boolean varArgs = ((ExecutableElement)element).isVarArgs();
            if (!varArgs && parSize < argTypes.length) continue;
            ExecutableType eType = (ExecutableType)this.asMemberOf(element, type, types);
            if (parSize == 0) {
                ret.add((Pair<ExecutableElement, ExecutableType>)Pair.of((Object)((ExecutableElement)element), (Object)eType));
                continue;
            }
            Iterator<? extends TypeMirror> parIt = eType.getParameterTypes().iterator();
            TypeMirror param = null;
            for (int i = 0; i <= argTypes.length; ++i) {
                if (parIt.hasNext()) {
                    param = parIt.next();
                    if (!parIt.hasNext() && param.getKind() == TypeKind.ARRAY) {
                        param = ((ArrayType)param).getComponentType();
                    }
                } else if (!varArgs) continue block0;
                if (i == argTypes.length) {
                    ret.add((Pair<ExecutableElement, ExecutableType>)Pair.of((Object)((ExecutableElement)element), (Object)eType));
                    continue block0;
                }
                if (argTypes[i] == null || !types.isAssignable(argTypes[i], param)) continue block0;
            }
        }
        return ret;
    }

    private Set<TypeMirror> getMatchingArgumentTypes(TypeMirror type, Iterable<? extends Element> elements, String name, TypeMirror[] argTypes, TypeMirror[] typeArgTypes, ExecutableElement prototypeSym, ExecutableType prototype, Types types, TypeUtilities tu) {
        HashSet<TypeMirror> ret = new HashSet<TypeMirror>();
        List<TypeMirror> tatList = typeArgTypes != null ? Arrays.asList(typeArgTypes) : null;
        block0: for (Element element : elements) {
            if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD || !name.contentEquals(element.getSimpleName())) continue;
            List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
            int parSize = params.size();
            boolean varArgs = ((ExecutableElement)element).isVarArgs();
            if (!varArgs && parSize <= argTypes.length) continue;
            ExecutableType meth = element == prototypeSym && prototype != null ? prototype : (ExecutableType)this.asMemberOf(element, type, types);
            Iterator<? extends TypeMirror> parIt = meth.getParameterTypes().iterator();
            TypeMirror param = null;
            HashMap<TypeVariable, TypeMirror> table = new HashMap<TypeVariable, TypeMirror>();
            for (int i = 0; i <= argTypes.length; ++i) {
                if (parIt.hasNext()) {
                    param = parIt.next();
                } else if (!varArgs) continue block0;
                if (tatList != null && param.getKind() == TypeKind.DECLARED && tatList.size() == meth.getTypeVariables().size()) {
                    param = tu.substitute(param, meth.getTypeVariables(), tatList);
                }
                if (i == argTypes.length) {
                    TypeMirror toAdd = null;
                    if (i < parSize) {
                        toAdd = param;
                    }
                    if (varArgs && !parIt.hasNext() && param.getKind() == TypeKind.ARRAY) {
                        toAdd = ((ArrayType)param).getComponentType();
                    }
                    while (toAdd != null && toAdd.getKind() == TypeKind.TYPEVAR) {
                        toAdd = ((TypeVariable)toAdd).getUpperBound();
                    }
                    if (toAdd == null || !ret.add(toAdd)) continue block0;
                    TypeMirror toRemove = null;
                    for (TypeMirror tm : ret) {
                        if (tm == toAdd) continue;
                        TypeMirror tmErasure = types.erasure(tm);
                        TypeMirror toAddErasure = types.erasure(toAdd);
                        if (types.isSubtype(toAddErasure, tmErasure)) {
                            toRemove = toAdd;
                            break;
                        }
                        if (!types.isSubtype(tmErasure, toAddErasure)) continue;
                        toRemove = tm;
                        break;
                    }
                    if (toRemove == null || toRemove.getKind().isPrimitive() || "java.lang.String".equals(toRemove.toString()) || "char[]".equals(toRemove.toString())) continue block0;
                    ret.remove(toRemove);
                    continue block0;
                }
                if (argTypes[i] == null) continue block0;
                if (varArgs && !parIt.hasNext() && param.getKind() == TypeKind.ARRAY) {
                    if (types.isAssignable(argTypes[i], param)) {
                        varArgs = false;
                        continue;
                    }
                    if (argTypes[i].getKind() == TypeKind.ERROR || types.isAssignable(argTypes[i], ((ArrayType)param).getComponentType())) continue;
                    continue block0;
                }
                if (argTypes[i].getKind() == TypeKind.ERROR || types.isAssignable(argTypes[i], param)) continue;
                if (tatList != null || param.getKind() != TypeKind.DECLARED || argTypes[i].getKind() != TypeKind.DECLARED || !types.isAssignable(types.erasure(argTypes[i]), types.erasure(param))) continue block0;
                Iterator<? extends TypeMirror> argTypeTAs = ((DeclaredType)argTypes[i]).getTypeArguments().iterator();
                for (TypeMirror typeMirror : ((DeclaredType)param).getTypeArguments()) {
                    if (!argTypeTAs.hasNext() || typeMirror.getKind() != TypeKind.TYPEVAR) break;
                    table.put((TypeVariable)typeMirror, argTypeTAs.next());
                }
                if (table.size() != meth.getTypeVariables().size()) continue;
                tatList = new ArrayList<TypeMirror>(meth.getTypeVariables().size());
                for (TypeVariable typeVariable : meth.getTypeVariables()) {
                    tatList.add((TypeMirror)table.get(typeVariable));
                }
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    private TypeMirror adjustType(BaseTask.Env env, TypeMirror original, Element element, TreePath path) {
        if (element instanceof VariableElement && !element.getKind().isField() && this.itemFactory instanceof TypeCastableItemFactory) {
            final Trees trees = env.getController().getTrees();
            Types types = env.getController().getTypes();
            TypeUtilities tu = env.getController().getTypeUtilities();
            Tree last = null;
            while (path != null) {
                IfTree ifTree;
                if (path.getLeaf().getKind() == Tree.Kind.IF && (ifTree = (IfTree)path.getLeaf()).getThenStatement() == last) {
                    Boolean used;
                    TypeMirror tm;
                    InstanceOfTree instTree;
                    ExpressionTree cond = ifTree.getCondition();
                    while (cond.getKind() == Tree.Kind.PARENTHESIZED) {
                        cond = ((ParenthesizedTree)cond).getExpression();
                    }
                    if (cond.getKind() == Tree.Kind.INSTANCE_OF && element == trees.getElement(new TreePath(path, (instTree = (InstanceOfTree)cond).getExpression())) && (tm = trees.getTypeMirror(new TreePath(path, instTree.getType()))) != null && tu.isCastable(original, tm) && (used = (Boolean)new ErrorAwareTreePathScanner<Boolean, Element>(){

                        public Boolean reduce(Boolean r1, Boolean r2) {
                            return r1 == Boolean.TRUE ? r1 : r2;
                        }

                        public Boolean visitAssignment(AssignmentTree tree, Element e) {
                            return e == trees.getElement(new TreePath(this.getCurrentPath(), tree.getVariable())) ? Boolean.TRUE : (Boolean)super.visitAssignment(tree, (Object)e);
                        }

                        public Boolean visitCompoundAssignment(CompoundAssignmentTree tree, Element e) {
                            return e == trees.getElement(new TreePath(this.getCurrentPath(), tree.getVariable())) ? Boolean.TRUE : (Boolean)super.visitCompoundAssignment(tree, (Object)e);
                        }
                    }.scan(new TreePath(path, ifTree.getThenStatement()), (Object)element)) != Boolean.TRUE) {
                        if (original.getKind() == TypeKind.DECLARED) {
                            return this.inferDeclaredType(types, (DeclaredType)original, tm);
                        }
                        return tm;
                    }
                }
                last = path.getLeaf();
                path = path.getParentPath();
            }
        }
        return original;
    }

    /*
     * WARNING - void declaration
     */
    private TypeMirror inferDeclaredType(Types types, DeclaredType original, TypeMirror type) {
        List<? extends TypeParameterElement> typeParams;
        Element el;
        if (type != null && type.getKind() == TypeKind.DECLARED && ((el = ((DeclaredType)type).asElement()).getKind().isClass() || el.getKind().isInterface()) && !(typeParams = ((TypeElement)el).getTypeParameters()).isEmpty() && !original.getTypeArguments().isEmpty()) {
            TypeMirror infSup;
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                void var7_7;
                if (typeMirror.getKind() == TypeKind.WILDCARD) {
                    TypeMirror typeMirror2 = ((WildcardType)typeMirror).getExtendsBound();
                }
                if (var7_7 != null && var7_7.getKind() == TypeKind.TYPEVAR) continue;
                return type;
            }
            if (el == original.asElement()) {
                return original;
            }
            HashMap<Element, TypeMirror> map = new HashMap<Element, TypeMirror>();
            TypeMirror typeMirror = ((TypeElement)el).getSuperclass();
            if (typeMirror != (infSup = this.inferDeclaredType(types, original, typeMirror))) {
                Iterator<? extends TypeMirror> supTP = ((DeclaredType)typeMirror).getTypeArguments().iterator();
                Iterator<? extends TypeMirror> iterator = ((DeclaredType)infSup).getTypeArguments().iterator();
                while (supTP.hasNext() && iterator.hasNext()) {
                    TypeMirror next = supTP.next();
                    if (next.getKind() != TypeKind.TYPEVAR) continue;
                    map.put(((TypeVariable)next).asElement(), iterator.next());
                }
                assert (!supTP.hasNext() && !iterator.hasNext());
            }
            for (TypeMirror typeMirror3 : ((TypeElement)el).getInterfaces()) {
                TypeMirror infIface;
                if (typeMirror3 == (infIface = this.inferDeclaredType(types, original, typeMirror3))) continue;
                Iterator<? extends TypeMirror> iterator = ((DeclaredType)typeMirror3).getTypeArguments().iterator();
                Iterator<? extends TypeMirror> infTP = ((DeclaredType)infIface).getTypeArguments().iterator();
                while (iterator.hasNext() && infTP.hasNext()) {
                    TypeMirror next = iterator.next();
                    if (next.getKind() != TypeKind.TYPEVAR) continue;
                    map.put(((TypeVariable)next).asElement(), infTP.next());
                }
                assert (!iterator.hasNext() && !infTP.hasNext());
            }
            TypeMirror[] targs = new TypeMirror[typeParams.size()];
            boolean bl = false;
            for (TypeParameterElement typeParameterElement : typeParams) {
                TypeMirror val = (TypeMirror)map.get(typeParameterElement);
                targs[++var10_17] = val != null ? val : typeParameterElement.getBounds().get(0);
            }
            return types.getDeclaredType((TypeElement)el, targs);
        }
        return type;
    }

    private boolean withinScope(BaseTask.Env env, TypeElement e) throws IOException {
        for (Element encl = env.getScope().getEnclosingClass(); encl != null; encl = encl.getEnclosingElement()) {
            if (e != encl) continue;
            return true;
        }
        return false;
    }

    private boolean withinLabeledStatement(BaseTask.Env env) {
        for (TreePath path = env.getPath(); path != null; path = path.getParentPath()) {
            if (path.getLeaf().getKind() != Tree.Kind.LABELED_STATEMENT) continue;
            return true;
        }
        return false;
    }

    private boolean withinModuleName(BaseTask.Env env) {
        Tree last = null;
        for (TreePath path = env.getPath(); path != null; path = path.getParentPath()) {
            Tree tree = path.getLeaf();
            if (last != null && (tree.getKind() == Tree.Kind.EXPORTS && ((ExportsTree)tree).getModuleNames() != null && ((ExportsTree)tree).getModuleNames().contains(last) || tree.getKind() == Tree.Kind.REQUIRES && ((RequiresTree)tree).getModuleName() == last)) {
                return true;
            }
            last = tree;
        }
        return false;
    }

    private boolean withinProvidesService(BaseTask.Env env) {
        Tree last = null;
        for (TreePath path = env.getPath(); path != null; path = path.getParentPath()) {
            Tree tree = path.getLeaf();
            if (last != null && tree.getKind() == Tree.Kind.PROVIDES && ((ProvidesTree)tree).getServiceName() == last) {
                return true;
            }
            last = tree;
        }
        return false;
    }

    private boolean hasAccessibleInnerClassConstructor(Element e, Scope scope, Trees trees) {
        DeclaredType dt = (DeclaredType)e.asType();
        for (TypeElement inner : ElementFilter.typesIn(e.getEnclosedElements())) {
            if (!trees.isAccessible(scope, inner, dt)) continue;
            DeclaredType innerType = (DeclaredType)inner.asType();
            for (ExecutableElement ctor : ElementFilter.constructorsIn(inner.getEnclosedElements())) {
                if (!trees.isAccessible(scope, ctor, innerType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean conflictsWithLocalMethods(Name name, TypeElement enclClass, List<ExecutableElement> methodsIn) {
        for (ExecutableElement local : methodsIn) {
            if (local.getEnclosingElement() != enclClass || !name.contentEquals(local.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private String fullName(Tree tree) {
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)tree).getName().toString();
            }
            case MEMBER_SELECT: {
                String sname = this.fullName(((MemberSelectTree)tree).getExpression());
                return sname == null ? null : sname + '.' + ((MemberSelectTree)tree).getIdentifier();
            }
        }
        return null;
    }

    private DeclaredType getDeclaredType(TypeElement e, HashMap<? extends Element, ? extends TypeMirror> map, Types types) {
        List<? extends TypeParameterElement> tpes = e.getTypeParameters();
        TypeMirror[] targs = new TypeMirror[tpes.size()];
        int i = 0;
        for (TypeParameterElement typeParameterElement : tpes) {
            TypeMirror t = map.get(typeParameterElement);
            targs[i++] = t != null ? t : typeParameterElement.asType();
        }
        Element encl = e.getEnclosingElement();
        if ((encl.getKind().isClass() || encl.getKind().isInterface()) && !((TypeElement)encl).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)encl, map, types), e, targs);
        }
        return types.getDeclaredType(e, targs);
    }

    private boolean startsWith(BaseTask.Env env, String theString) {
        String prefix = env.getPrefix();
        return this.startsWith(env, theString, prefix);
    }

    private boolean startsWith(BaseTask.Env env, String theString, String prefix) {
        return env.isCamelCasePrefix() ? (Utilities.isCaseSensitive() ? Utilities.startsWithCamelCase(theString, prefix) : Utilities.startsWithCamelCase(theString, prefix) || Utilities.startsWith(theString, prefix)) : Utilities.startsWith(theString, prefix);
    }

    private boolean withinBounds(BaseTask.Env env, TypeMirror type, List<? extends TypeMirror> bounds) {
        if (bounds != null) {
            Types types = env.getController().getTypes();
            for (TypeMirror typeMirror : bounds) {
                if (types.isSubtype(type, typeMirror)) continue;
                return false;
            }
        }
        return true;
    }

    private void addVarTypeForLambdaParam(BaseTask.Env env) throws IOException {
        if (env.getController().getSourceVersion().compareTo(SourceVersion.RELEASE_11) < 0) {
            return;
        }
        this.results.add(this.itemFactory.createKeywordItem(VAR_KEYWORD, SPACE, this.anchorOffset, false));
    }

    private boolean isLambdaVarType(BaseTask.Env env, Tree tree) {
        if (tree.getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
            return false;
        }
        LambdaExpressionTree let = (LambdaExpressionTree)tree;
        if (let.getParameters().isEmpty()) {
            return false;
        }
        boolean isFirstParamVarType = false;
        VariableTree firstParamTree = let.getParameters().get(0);
        int firstParamStartPos = (int)env.getSourcePositions().getStartPosition(env.getRoot(), firstParamTree);
        TokenSequence<JavaTokenId> ts = this.findLastNonWhitespaceToken(env, let, env.getOffset());
        ts.move(firstParamStartPos);
        ts.movePrevious();
        while (ts.token().id() != JavaTokenId.COMMA && !isFirstParamVarType && ts.moveNext()) {
            isFirstParamVarType = ts.token().id() == JavaTokenId.VAR;
        }
        return isFirstParamVarType;
    }

    private static ElementKind simplifyElementKind(ElementKind kind) {
        if (ElementKind.BINDING_VARIABLE == kind) {
            return ElementKind.LOCAL_VARIABLE;
        }
        if (ElementKind.RECORD == kind) {
            return ElementKind.CLASS;
        }
        return kind;
    }

    public static enum Options {
        ALL_COMPLETION,
        COMBINED_COMPLETION,
        SKIP_ACCESSIBILITY_CHECK;

    }

    public static interface ModuleItemFactory<T>
    extends ItemFactory<T> {
        public T createModuleItem(String var1, int var2);
    }

    public static interface LambdaItemFactory<T>
    extends ItemFactory<T> {
        public T createLambdaItem(CompilationInfo var1, TypeElement var2, DeclaredType var3, int var4, boolean var5, boolean var6);
    }

    public static interface TypeCastableItemFactory<T>
    extends ItemFactory<T> {
        public T createTypeCastableVariableItem(CompilationInfo var1, VariableElement var2, TypeMirror var3, TypeMirror var4, int var5, ReferencesCount var6, boolean var7, boolean var8, boolean var9, int var10);

        public T createTypeCastableExecutableItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, TypeMirror var4, int var5, ReferencesCount var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, int var12, boolean var13);
    }

    public static interface ItemFactory<T> {
        public T createKeywordItem(String var1, String var2, int var3, boolean var4);

        public T createPackageItem(String var1, int var2, boolean var3);

        public T createTypeItem(CompilationInfo var1, TypeElement var2, DeclaredType var3, int var4, ReferencesCount var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11);

        public T createTypeItem(ElementHandle<TypeElement> var1, EnumSet<ElementKind> var2, int var3, ReferencesCount var4, Source var5, boolean var6, boolean var7, boolean var8);

        public T createArrayItem(CompilationInfo var1, ArrayType var2, int var3, ReferencesCount var4, Elements var5);

        public T createTypeParameterItem(TypeParameterElement var1, int var2);

        public T createVariableItem(CompilationInfo var1, VariableElement var2, TypeMirror var3, int var4, ReferencesCount var5, boolean var6, boolean var7, boolean var8, int var9);

        public T createVariableItem(CompilationInfo var1, String var2, int var3, boolean var4, boolean var5);

        public T createExecutableItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, int var4, ReferencesCount var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12);

        public T createThisOrSuperConstructorItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, int var4, boolean var5, String var6);

        public T createOverrideMethodItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, int var4, boolean var5);

        public T createGetterSetterMethodItem(CompilationInfo var1, VariableElement var2, TypeMirror var3, int var4, String var5, boolean var6);

        public T createDefaultConstructorItem(TypeElement var1, int var2, boolean var3);

        public T createParametersItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, int var4, boolean var5, int var6, String var7);

        public T createAnnotationItem(CompilationInfo var1, TypeElement var2, DeclaredType var3, int var4, ReferencesCount var5, boolean var6);

        public T createAttributeItem(CompilationInfo var1, ExecutableElement var2, ExecutableType var3, int var4, boolean var5);

        public T createAttributeValueItem(CompilationInfo var1, String var2, String var3, TypeElement var4, int var5, ReferencesCount var6);

        public T createStaticMemberItem(CompilationInfo var1, DeclaredType var2, Element var3, TypeMirror var4, boolean var5, int var6, boolean var7, boolean var8);

        public T createStaticMemberItem(ElementHandle<TypeElement> var1, String var2, int var3, boolean var4, ReferencesCount var5, Source var6);

        public T createChainedMembersItem(CompilationInfo var1, List<? extends Element> var2, List<? extends TypeMirror> var3, int var4, boolean var5, boolean var6);

        public T createInitializeAllConstructorItem(CompilationInfo var1, boolean var2, Iterable<? extends VariableElement> var3, ExecutableElement var4, TypeElement var5, int var6);
    }
}

