/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIamWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String page;
    private Integer limit;
    private String resourceIdentifier;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "resourceIdentifier", "opcRequestId"})
    ListIamWorkRequestsRequest(String compartmentId, String page, Integer limit, String resourceIdentifier, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.resourceIdentifier = resourceIdentifier;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).page(this.page).limit(this.limit).resourceIdentifier(this.resourceIdentifier).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListIamWorkRequestsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", resourceIdentifier=" + this.getResourceIdentifier() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListIamWorkRequestsRequest)) {
            return false;
        }
        ListIamWorkRequestsRequest other = (ListIamWorkRequestsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$resourceIdentifier = this.getResourceIdentifier();
        String other$resourceIdentifier = other.getResourceIdentifier();
        if (this$resourceIdentifier == null ? other$resourceIdentifier != null : !this$resourceIdentifier.equals(other$resourceIdentifier)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListIamWorkRequestsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $resourceIdentifier = this.getResourceIdentifier();
        result = result * 59 + ($resourceIdentifier == null ? 43 : $resourceIdentifier.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIamWorkRequestsRequest, Void> {
        private String compartmentId;
        private String page;
        private Integer limit;
        private String resourceIdentifier;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIamWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.resourceIdentifier(o.getResourceIdentifier());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIamWorkRequestsRequest build() {
            ListIamWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListIamWorkRequestsRequest buildWithoutInvocationCallback() {
            return new ListIamWorkRequestsRequest(this.compartmentId, this.page, this.limit, this.resourceIdentifier, this.opcRequestId);
        }

        public String toString() {
            return "ListIamWorkRequestsRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", resourceIdentifier=" + this.resourceIdentifier + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

