/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class KnowledgeBaseNode
extends OCINode {
    private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/knowledge_base.svg";

    public KnowledgeBaseNode(OCIItem item) {
        super(item, Children.LEAF);
        this.setIconBaseWithExtension(ICON);
    }

    public static NodeProvider<KnowledgeBaseItem> createNode() {
        return KnowledgeBaseNode::new;
    }

    public static ChildrenProvider<CompartmentItem, KnowledgeBaseItem> listKnowledgeBases() {
        return compartment -> {
            try (ApplicationDependencyManagementClient client = new ApplicationDependencyManagementClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.builder().compartmentId(compartment.getKey().getValue()).build();
                ListKnowledgeBasesResponse response = client.listKnowledgeBases(request);
                List projects = response.getKnowledgeBaseCollection().getItems();
                List list = projects.stream().map(p -> new KnowledgeBaseItem(OCID.of(p.getId(), "KnowledgeBase"), p.getDisplayName())).collect(Collectors.toList());
                return list;
            }
        };
    }
}

