/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.database.model.MaintenanceWindow;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemSummary {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomains")
    private final List<String> faultDomains;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="dbSystemOptions")
    private final DbSystemOptions dbSystemOptions;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="dataStoragePercentage")
    private final Integer dataStoragePercentage;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;
    @JsonProperty(value="lastPatchHistoryEntryId")
    private final String lastPatchHistoryEntryId;
    @JsonProperty(value="listenerPort")
    private final Integer listenerPort;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="diskRedundancy")
    private final DiskRedundancy diskRedundancy;
    @JsonProperty(value="sparseDiskgroup")
    private final Boolean sparseDiskgroup;
    @JsonProperty(value="scanIpIds")
    private final List<String> scanIpIds;
    @JsonProperty(value="vipIds")
    private final List<String> vipIds;
    @JsonProperty(value="scanDnsRecordId")
    private final String scanDnsRecordId;
    @JsonProperty(value="scanDnsName")
    private final String scanDnsName;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="recoStorageSizeInGB")
    private final Integer recoStorageSizeInGB;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="maintenanceWindow")
    private final MaintenanceWindow maintenanceWindow;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="sourceDbSystemId")
    private final String sourceDbSystemId;
    @JsonProperty(value="pointInTimeDataDiskCloneTimestamp")
    private final Date pointInTimeDataDiskCloneTimestamp;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).displayName(this.displayName).availabilityDomain(this.availabilityDomain).faultDomains(this.faultDomains).subnetId(this.subnetId).backupSubnetId(this.backupSubnetId).nsgIds(this.nsgIds).backupNetworkNsgIds(this.backupNetworkNsgIds).shape(this.shape).dbSystemOptions(this.dbSystemOptions).sshPublicKeys(this.sshPublicKeys).timeZone(this.timeZone).hostname(this.hostname).domain(this.domain).kmsKeyId(this.kmsKeyId).version(this.version).cpuCoreCount(this.cpuCoreCount).clusterName(this.clusterName).dataStoragePercentage(this.dataStoragePercentage).databaseEdition(this.databaseEdition).lastPatchHistoryEntryId(this.lastPatchHistoryEntryId).listenerPort(this.listenerPort).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).lifecycleDetails(this.lifecycleDetails).diskRedundancy(this.diskRedundancy).sparseDiskgroup(this.sparseDiskgroup).scanIpIds(this.scanIpIds).vipIds(this.vipIds).scanDnsRecordId(this.scanDnsRecordId).scanDnsName(this.scanDnsName).zoneId(this.zoneId).dataStorageSizeInGBs(this.dataStorageSizeInGBs).recoStorageSizeInGB(this.recoStorageSizeInGB).nodeCount(this.nodeCount).licenseModel(this.licenseModel).maintenanceWindow(this.maintenanceWindow).lastMaintenanceRunId(this.lastMaintenanceRunId).nextMaintenanceRunId(this.nextMaintenanceRunId).freeformTags(this.freeformTags).definedTags(this.definedTags).sourceDbSystemId(this.sourceDbSystemId).pointInTimeDataDiskCloneTimestamp(this.pointInTimeDataDiskCloneTimestamp);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public List<String> getFaultDomains() {
        return this.faultDomains;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getShape() {
        return this.shape;
    }

    public DbSystemOptions getDbSystemOptions() {
        return this.dbSystemOptions;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getDataStoragePercentage() {
        return this.dataStoragePercentage;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public String getLastPatchHistoryEntryId() {
        return this.lastPatchHistoryEntryId;
    }

    public Integer getListenerPort() {
        return this.listenerPort;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public DiskRedundancy getDiskRedundancy() {
        return this.diskRedundancy;
    }

    public Boolean getSparseDiskgroup() {
        return this.sparseDiskgroup;
    }

    public List<String> getScanIpIds() {
        return this.scanIpIds;
    }

    public List<String> getVipIds() {
        return this.vipIds;
    }

    public String getScanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public String getScanDnsName() {
        return this.scanDnsName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public Integer getRecoStorageSizeInGB() {
        return this.recoStorageSizeInGB;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public MaintenanceWindow getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getSourceDbSystemId() {
        return this.sourceDbSystemId;
    }

    public Date getPointInTimeDataDiskCloneTimestamp() {
        return this.pointInTimeDataDiskCloneTimestamp;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbSystemSummary)) {
            return false;
        }
        DbSystemSummary other = (DbSystemSummary)o;
        Integer this$cpuCoreCount = this.getCpuCoreCount();
        Integer other$cpuCoreCount = other.getCpuCoreCount();
        if (this$cpuCoreCount == null ? other$cpuCoreCount != null : !((Object)this$cpuCoreCount).equals(other$cpuCoreCount)) {
            return false;
        }
        Integer this$dataStoragePercentage = this.getDataStoragePercentage();
        Integer other$dataStoragePercentage = other.getDataStoragePercentage();
        if (this$dataStoragePercentage == null ? other$dataStoragePercentage != null : !((Object)this$dataStoragePercentage).equals(other$dataStoragePercentage)) {
            return false;
        }
        Integer this$listenerPort = this.getListenerPort();
        Integer other$listenerPort = other.getListenerPort();
        if (this$listenerPort == null ? other$listenerPort != null : !((Object)this$listenerPort).equals(other$listenerPort)) {
            return false;
        }
        Boolean this$sparseDiskgroup = this.getSparseDiskgroup();
        Boolean other$sparseDiskgroup = other.getSparseDiskgroup();
        if (this$sparseDiskgroup == null ? other$sparseDiskgroup != null : !((Object)this$sparseDiskgroup).equals(other$sparseDiskgroup)) {
            return false;
        }
        Integer this$dataStorageSizeInGBs = this.getDataStorageSizeInGBs();
        Integer other$dataStorageSizeInGBs = other.getDataStorageSizeInGBs();
        if (this$dataStorageSizeInGBs == null ? other$dataStorageSizeInGBs != null : !((Object)this$dataStorageSizeInGBs).equals(other$dataStorageSizeInGBs)) {
            return false;
        }
        Integer this$recoStorageSizeInGB = this.getRecoStorageSizeInGB();
        Integer other$recoStorageSizeInGB = other.getRecoStorageSizeInGB();
        if (this$recoStorageSizeInGB == null ? other$recoStorageSizeInGB != null : !((Object)this$recoStorageSizeInGB).equals(other$recoStorageSizeInGB)) {
            return false;
        }
        Integer this$nodeCount = this.getNodeCount();
        Integer other$nodeCount = other.getNodeCount();
        if (this$nodeCount == null ? other$nodeCount != null : !((Object)this$nodeCount).equals(other$nodeCount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        if (this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain)) {
            return false;
        }
        List<String> this$faultDomains = this.getFaultDomains();
        List<String> other$faultDomains = other.getFaultDomains();
        if (this$faultDomains == null ? other$faultDomains != null : !((Object)this$faultDomains).equals(other$faultDomains)) {
            return false;
        }
        String this$subnetId = this.getSubnetId();
        String other$subnetId = other.getSubnetId();
        if (this$subnetId == null ? other$subnetId != null : !this$subnetId.equals(other$subnetId)) {
            return false;
        }
        String this$backupSubnetId = this.getBackupSubnetId();
        String other$backupSubnetId = other.getBackupSubnetId();
        if (this$backupSubnetId == null ? other$backupSubnetId != null : !this$backupSubnetId.equals(other$backupSubnetId)) {
            return false;
        }
        List<String> this$nsgIds = this.getNsgIds();
        List<String> other$nsgIds = other.getNsgIds();
        if (this$nsgIds == null ? other$nsgIds != null : !((Object)this$nsgIds).equals(other$nsgIds)) {
            return false;
        }
        List<String> this$backupNetworkNsgIds = this.getBackupNetworkNsgIds();
        List<String> other$backupNetworkNsgIds = other.getBackupNetworkNsgIds();
        if (this$backupNetworkNsgIds == null ? other$backupNetworkNsgIds != null : !((Object)this$backupNetworkNsgIds).equals(other$backupNetworkNsgIds)) {
            return false;
        }
        String this$shape = this.getShape();
        String other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        DbSystemOptions this$dbSystemOptions = this.getDbSystemOptions();
        DbSystemOptions other$dbSystemOptions = other.getDbSystemOptions();
        if (this$dbSystemOptions == null ? other$dbSystemOptions != null : !((Object)this$dbSystemOptions).equals(other$dbSystemOptions)) {
            return false;
        }
        List<String> this$sshPublicKeys = this.getSshPublicKeys();
        List<String> other$sshPublicKeys = other.getSshPublicKeys();
        if (this$sshPublicKeys == null ? other$sshPublicKeys != null : !((Object)this$sshPublicKeys).equals(other$sshPublicKeys)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$kmsKeyId = this.getKmsKeyId();
        String other$kmsKeyId = other.getKmsKeyId();
        if (this$kmsKeyId == null ? other$kmsKeyId != null : !this$kmsKeyId.equals(other$kmsKeyId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        DatabaseEdition this$databaseEdition = this.getDatabaseEdition();
        DatabaseEdition other$databaseEdition = other.getDatabaseEdition();
        if (this$databaseEdition == null ? other$databaseEdition != null : !((Object)((Object)this$databaseEdition)).equals((Object)other$databaseEdition)) {
            return false;
        }
        String this$lastPatchHistoryEntryId = this.getLastPatchHistoryEntryId();
        String other$lastPatchHistoryEntryId = other.getLastPatchHistoryEntryId();
        if (this$lastPatchHistoryEntryId == null ? other$lastPatchHistoryEntryId != null : !this$lastPatchHistoryEntryId.equals(other$lastPatchHistoryEntryId)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        DiskRedundancy this$diskRedundancy = this.getDiskRedundancy();
        DiskRedundancy other$diskRedundancy = other.getDiskRedundancy();
        if (this$diskRedundancy == null ? other$diskRedundancy != null : !((Object)((Object)this$diskRedundancy)).equals((Object)other$diskRedundancy)) {
            return false;
        }
        List<String> this$scanIpIds = this.getScanIpIds();
        List<String> other$scanIpIds = other.getScanIpIds();
        if (this$scanIpIds == null ? other$scanIpIds != null : !((Object)this$scanIpIds).equals(other$scanIpIds)) {
            return false;
        }
        List<String> this$vipIds = this.getVipIds();
        List<String> other$vipIds = other.getVipIds();
        if (this$vipIds == null ? other$vipIds != null : !((Object)this$vipIds).equals(other$vipIds)) {
            return false;
        }
        String this$scanDnsRecordId = this.getScanDnsRecordId();
        String other$scanDnsRecordId = other.getScanDnsRecordId();
        if (this$scanDnsRecordId == null ? other$scanDnsRecordId != null : !this$scanDnsRecordId.equals(other$scanDnsRecordId)) {
            return false;
        }
        String this$scanDnsName = this.getScanDnsName();
        String other$scanDnsName = other.getScanDnsName();
        if (this$scanDnsName == null ? other$scanDnsName != null : !this$scanDnsName.equals(other$scanDnsName)) {
            return false;
        }
        String this$zoneId = this.getZoneId();
        String other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        LicenseModel this$licenseModel = this.getLicenseModel();
        LicenseModel other$licenseModel = other.getLicenseModel();
        if (this$licenseModel == null ? other$licenseModel != null : !((Object)((Object)this$licenseModel)).equals((Object)other$licenseModel)) {
            return false;
        }
        MaintenanceWindow this$maintenanceWindow = this.getMaintenanceWindow();
        MaintenanceWindow other$maintenanceWindow = other.getMaintenanceWindow();
        if (this$maintenanceWindow == null ? other$maintenanceWindow != null : !((Object)this$maintenanceWindow).equals(other$maintenanceWindow)) {
            return false;
        }
        String this$lastMaintenanceRunId = this.getLastMaintenanceRunId();
        String other$lastMaintenanceRunId = other.getLastMaintenanceRunId();
        if (this$lastMaintenanceRunId == null ? other$lastMaintenanceRunId != null : !this$lastMaintenanceRunId.equals(other$lastMaintenanceRunId)) {
            return false;
        }
        String this$nextMaintenanceRunId = this.getNextMaintenanceRunId();
        String other$nextMaintenanceRunId = other.getNextMaintenanceRunId();
        if (this$nextMaintenanceRunId == null ? other$nextMaintenanceRunId != null : !this$nextMaintenanceRunId.equals(other$nextMaintenanceRunId)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        String this$sourceDbSystemId = this.getSourceDbSystemId();
        String other$sourceDbSystemId = other.getSourceDbSystemId();
        if (this$sourceDbSystemId == null ? other$sourceDbSystemId != null : !this$sourceDbSystemId.equals(other$sourceDbSystemId)) {
            return false;
        }
        Date this$pointInTimeDataDiskCloneTimestamp = this.getPointInTimeDataDiskCloneTimestamp();
        Date other$pointInTimeDataDiskCloneTimestamp = other.getPointInTimeDataDiskCloneTimestamp();
        if (this$pointInTimeDataDiskCloneTimestamp == null ? other$pointInTimeDataDiskCloneTimestamp != null : !((Object)this$pointInTimeDataDiskCloneTimestamp).equals(other$pointInTimeDataDiskCloneTimestamp)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cpuCoreCount = this.getCpuCoreCount();
        result = result * 59 + ($cpuCoreCount == null ? 43 : ((Object)$cpuCoreCount).hashCode());
        Integer $dataStoragePercentage = this.getDataStoragePercentage();
        result = result * 59 + ($dataStoragePercentage == null ? 43 : ((Object)$dataStoragePercentage).hashCode());
        Integer $listenerPort = this.getListenerPort();
        result = result * 59 + ($listenerPort == null ? 43 : ((Object)$listenerPort).hashCode());
        Boolean $sparseDiskgroup = this.getSparseDiskgroup();
        result = result * 59 + ($sparseDiskgroup == null ? 43 : ((Object)$sparseDiskgroup).hashCode());
        Integer $dataStorageSizeInGBs = this.getDataStorageSizeInGBs();
        result = result * 59 + ($dataStorageSizeInGBs == null ? 43 : ((Object)$dataStorageSizeInGBs).hashCode());
        Integer $recoStorageSizeInGB = this.getRecoStorageSizeInGB();
        result = result * 59 + ($recoStorageSizeInGB == null ? 43 : ((Object)$recoStorageSizeInGB).hashCode());
        Integer $nodeCount = this.getNodeCount();
        result = result * 59 + ($nodeCount == null ? 43 : ((Object)$nodeCount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        List<String> $faultDomains = this.getFaultDomains();
        result = result * 59 + ($faultDomains == null ? 43 : ((Object)$faultDomains).hashCode());
        String $subnetId = this.getSubnetId();
        result = result * 59 + ($subnetId == null ? 43 : $subnetId.hashCode());
        String $backupSubnetId = this.getBackupSubnetId();
        result = result * 59 + ($backupSubnetId == null ? 43 : $backupSubnetId.hashCode());
        List<String> $nsgIds = this.getNsgIds();
        result = result * 59 + ($nsgIds == null ? 43 : ((Object)$nsgIds).hashCode());
        List<String> $backupNetworkNsgIds = this.getBackupNetworkNsgIds();
        result = result * 59 + ($backupNetworkNsgIds == null ? 43 : ((Object)$backupNetworkNsgIds).hashCode());
        String $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        DbSystemOptions $dbSystemOptions = this.getDbSystemOptions();
        result = result * 59 + ($dbSystemOptions == null ? 43 : ((Object)$dbSystemOptions).hashCode());
        List<String> $sshPublicKeys = this.getSshPublicKeys();
        result = result * 59 + ($sshPublicKeys == null ? 43 : ((Object)$sshPublicKeys).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $kmsKeyId = this.getKmsKeyId();
        result = result * 59 + ($kmsKeyId == null ? 43 : $kmsKeyId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        DatabaseEdition $databaseEdition = this.getDatabaseEdition();
        result = result * 59 + ($databaseEdition == null ? 43 : ((Object)((Object)$databaseEdition)).hashCode());
        String $lastPatchHistoryEntryId = this.getLastPatchHistoryEntryId();
        result = result * 59 + ($lastPatchHistoryEntryId == null ? 43 : $lastPatchHistoryEntryId.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        DiskRedundancy $diskRedundancy = this.getDiskRedundancy();
        result = result * 59 + ($diskRedundancy == null ? 43 : ((Object)((Object)$diskRedundancy)).hashCode());
        List<String> $scanIpIds = this.getScanIpIds();
        result = result * 59 + ($scanIpIds == null ? 43 : ((Object)$scanIpIds).hashCode());
        List<String> $vipIds = this.getVipIds();
        result = result * 59 + ($vipIds == null ? 43 : ((Object)$vipIds).hashCode());
        String $scanDnsRecordId = this.getScanDnsRecordId();
        result = result * 59 + ($scanDnsRecordId == null ? 43 : $scanDnsRecordId.hashCode());
        String $scanDnsName = this.getScanDnsName();
        result = result * 59 + ($scanDnsName == null ? 43 : $scanDnsName.hashCode());
        String $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        LicenseModel $licenseModel = this.getLicenseModel();
        result = result * 59 + ($licenseModel == null ? 43 : ((Object)((Object)$licenseModel)).hashCode());
        MaintenanceWindow $maintenanceWindow = this.getMaintenanceWindow();
        result = result * 59 + ($maintenanceWindow == null ? 43 : ((Object)$maintenanceWindow).hashCode());
        String $lastMaintenanceRunId = this.getLastMaintenanceRunId();
        result = result * 59 + ($lastMaintenanceRunId == null ? 43 : $lastMaintenanceRunId.hashCode());
        String $nextMaintenanceRunId = this.getNextMaintenanceRunId();
        result = result * 59 + ($nextMaintenanceRunId == null ? 43 : $nextMaintenanceRunId.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        String $sourceDbSystemId = this.getSourceDbSystemId();
        result = result * 59 + ($sourceDbSystemId == null ? 43 : $sourceDbSystemId.hashCode());
        Date $pointInTimeDataDiskCloneTimestamp = this.getPointInTimeDataDiskCloneTimestamp();
        result = result * 59 + ($pointInTimeDataDiskCloneTimestamp == null ? 43 : ((Object)$pointInTimeDataDiskCloneTimestamp).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DbSystemSummary(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", displayName=" + this.getDisplayName() + ", availabilityDomain=" + this.getAvailabilityDomain() + ", faultDomains=" + this.getFaultDomains() + ", subnetId=" + this.getSubnetId() + ", backupSubnetId=" + this.getBackupSubnetId() + ", nsgIds=" + this.getNsgIds() + ", backupNetworkNsgIds=" + this.getBackupNetworkNsgIds() + ", shape=" + this.getShape() + ", dbSystemOptions=" + this.getDbSystemOptions() + ", sshPublicKeys=" + this.getSshPublicKeys() + ", timeZone=" + this.getTimeZone() + ", hostname=" + this.getHostname() + ", domain=" + this.getDomain() + ", kmsKeyId=" + this.getKmsKeyId() + ", version=" + this.getVersion() + ", cpuCoreCount=" + this.getCpuCoreCount() + ", clusterName=" + this.getClusterName() + ", dataStoragePercentage=" + this.getDataStoragePercentage() + ", databaseEdition=" + (Object)((Object)this.getDatabaseEdition()) + ", lastPatchHistoryEntryId=" + this.getLastPatchHistoryEntryId() + ", listenerPort=" + this.getListenerPort() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", timeCreated=" + this.getTimeCreated() + ", lifecycleDetails=" + this.getLifecycleDetails() + ", diskRedundancy=" + (Object)((Object)this.getDiskRedundancy()) + ", sparseDiskgroup=" + this.getSparseDiskgroup() + ", scanIpIds=" + this.getScanIpIds() + ", vipIds=" + this.getVipIds() + ", scanDnsRecordId=" + this.getScanDnsRecordId() + ", scanDnsName=" + this.getScanDnsName() + ", zoneId=" + this.getZoneId() + ", dataStorageSizeInGBs=" + this.getDataStorageSizeInGBs() + ", recoStorageSizeInGB=" + this.getRecoStorageSizeInGB() + ", nodeCount=" + this.getNodeCount() + ", licenseModel=" + (Object)((Object)this.getLicenseModel()) + ", maintenanceWindow=" + this.getMaintenanceWindow() + ", lastMaintenanceRunId=" + this.getLastMaintenanceRunId() + ", nextMaintenanceRunId=" + this.getNextMaintenanceRunId() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", sourceDbSystemId=" + this.getSourceDbSystemId() + ", pointInTimeDataDiskCloneTimestamp=" + this.getPointInTimeDataDiskCloneTimestamp() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "displayName", "availabilityDomain", "faultDomains", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "shape", "dbSystemOptions", "sshPublicKeys", "timeZone", "hostname", "domain", "kmsKeyId", "version", "cpuCoreCount", "clusterName", "dataStoragePercentage", "databaseEdition", "lastPatchHistoryEntryId", "listenerPort", "lifecycleState", "timeCreated", "lifecycleDetails", "diskRedundancy", "sparseDiskgroup", "scanIpIds", "vipIds", "scanDnsRecordId", "scanDnsName", "zoneId", "dataStorageSizeInGBs", "recoStorageSizeInGB", "nodeCount", "licenseModel", "maintenanceWindow", "lastMaintenanceRunId", "nextMaintenanceRunId", "freeformTags", "definedTags", "sourceDbSystemId", "pointInTimeDataDiskCloneTimestamp"})
    @Deprecated
    public DbSystemSummary(String id, String compartmentId, String displayName, String availabilityDomain, List<String> faultDomains, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String shape, DbSystemOptions dbSystemOptions, List<String> sshPublicKeys, String timeZone, String hostname, String domain, String kmsKeyId, String version, Integer cpuCoreCount, String clusterName, Integer dataStoragePercentage, DatabaseEdition databaseEdition, String lastPatchHistoryEntryId, Integer listenerPort, LifecycleState lifecycleState, Date timeCreated, String lifecycleDetails, DiskRedundancy diskRedundancy, Boolean sparseDiskgroup, List<String> scanIpIds, List<String> vipIds, String scanDnsRecordId, String scanDnsName, String zoneId, Integer dataStorageSizeInGBs, Integer recoStorageSizeInGB, Integer nodeCount, LicenseModel licenseModel, MaintenanceWindow maintenanceWindow, String lastMaintenanceRunId, String nextMaintenanceRunId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String sourceDbSystemId, Date pointInTimeDataDiskCloneTimestamp) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.availabilityDomain = availabilityDomain;
        this.faultDomains = faultDomains;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.shape = shape;
        this.dbSystemOptions = dbSystemOptions;
        this.sshPublicKeys = sshPublicKeys;
        this.timeZone = timeZone;
        this.hostname = hostname;
        this.domain = domain;
        this.kmsKeyId = kmsKeyId;
        this.version = version;
        this.cpuCoreCount = cpuCoreCount;
        this.clusterName = clusterName;
        this.dataStoragePercentage = dataStoragePercentage;
        this.databaseEdition = databaseEdition;
        this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
        this.listenerPort = listenerPort;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.diskRedundancy = diskRedundancy;
        this.sparseDiskgroup = sparseDiskgroup;
        this.scanIpIds = scanIpIds;
        this.vipIds = vipIds;
        this.scanDnsRecordId = scanDnsRecordId;
        this.scanDnsName = scanDnsName;
        this.zoneId = zoneId;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.recoStorageSizeInGB = recoStorageSizeInGB;
        this.nodeCount = nodeCount;
        this.licenseModel = licenseModel;
        this.maintenanceWindow = maintenanceWindow;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.sourceDbSystemId = sourceDbSystemId;
        this.pointInTimeDataDiskCloneTimestamp = pointInTimeDataDiskCloneTimestamp;
    }

    public static enum LicenseModel {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiskRedundancy {
        High("HIGH"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiskRedundancy> map;

        private DiskRedundancy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiskRedundancy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiskRedundancy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiskRedundancy.class);
            map = new HashMap<String, DiskRedundancy>();
            for (DiskRedundancy v : DiskRedundancy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Migrated("MIGRATED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        NeedsAttention("NEEDS_ATTENTION"),
        Upgrading("UPGRADING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseEdition {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseEdition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseEdition.class);
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomains")
        private List<String> faultDomains;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="dbSystemOptions")
        private DbSystemOptions dbSystemOptions;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="dataStoragePercentage")
        private Integer dataStoragePercentage;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonProperty(value="lastPatchHistoryEntryId")
        private String lastPatchHistoryEntryId;
        @JsonProperty(value="listenerPort")
        private Integer listenerPort;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="diskRedundancy")
        private DiskRedundancy diskRedundancy;
        @JsonProperty(value="sparseDiskgroup")
        private Boolean sparseDiskgroup;
        @JsonProperty(value="scanIpIds")
        private List<String> scanIpIds;
        @JsonProperty(value="vipIds")
        private List<String> vipIds;
        @JsonProperty(value="scanDnsRecordId")
        private String scanDnsRecordId;
        @JsonProperty(value="scanDnsName")
        private String scanDnsName;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="recoStorageSizeInGB")
        private Integer recoStorageSizeInGB;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="maintenanceWindow")
        private MaintenanceWindow maintenanceWindow;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="sourceDbSystemId")
        private String sourceDbSystemId;
        @JsonProperty(value="pointInTimeDataDiskCloneTimestamp")
        private Date pointInTimeDataDiskCloneTimestamp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomains(List<String> faultDomains) {
            this.faultDomains = faultDomains;
            this.__explicitlySet__.add("faultDomains");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder dbSystemOptions(DbSystemOptions dbSystemOptions) {
            this.dbSystemOptions = dbSystemOptions;
            this.__explicitlySet__.add("dbSystemOptions");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder dataStoragePercentage(Integer dataStoragePercentage) {
            this.dataStoragePercentage = dataStoragePercentage;
            this.__explicitlySet__.add("dataStoragePercentage");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder lastPatchHistoryEntryId(String lastPatchHistoryEntryId) {
            this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
            this.__explicitlySet__.add("lastPatchHistoryEntryId");
            return this;
        }

        public Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            this.__explicitlySet__.add("diskRedundancy");
            return this;
        }

        public Builder sparseDiskgroup(Boolean sparseDiskgroup) {
            this.sparseDiskgroup = sparseDiskgroup;
            this.__explicitlySet__.add("sparseDiskgroup");
            return this;
        }

        public Builder scanIpIds(List<String> scanIpIds) {
            this.scanIpIds = scanIpIds;
            this.__explicitlySet__.add("scanIpIds");
            return this;
        }

        public Builder vipIds(List<String> vipIds) {
            this.vipIds = vipIds;
            this.__explicitlySet__.add("vipIds");
            return this;
        }

        public Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            this.__explicitlySet__.add("scanDnsRecordId");
            return this;
        }

        public Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            this.__explicitlySet__.add("scanDnsName");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder recoStorageSizeInGB(Integer recoStorageSizeInGB) {
            this.recoStorageSizeInGB = recoStorageSizeInGB;
            this.__explicitlySet__.add("recoStorageSizeInGB");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            this.__explicitlySet__.add("maintenanceWindow");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder sourceDbSystemId(String sourceDbSystemId) {
            this.sourceDbSystemId = sourceDbSystemId;
            this.__explicitlySet__.add("sourceDbSystemId");
            return this;
        }

        public Builder pointInTimeDataDiskCloneTimestamp(Date pointInTimeDataDiskCloneTimestamp) {
            this.pointInTimeDataDiskCloneTimestamp = pointInTimeDataDiskCloneTimestamp;
            this.__explicitlySet__.add("pointInTimeDataDiskCloneTimestamp");
            return this;
        }

        public DbSystemSummary build() {
            DbSystemSummary __instance__ = new DbSystemSummary(this.id, this.compartmentId, this.displayName, this.availabilityDomain, this.faultDomains, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.shape, this.dbSystemOptions, this.sshPublicKeys, this.timeZone, this.hostname, this.domain, this.kmsKeyId, this.version, this.cpuCoreCount, this.clusterName, this.dataStoragePercentage, this.databaseEdition, this.lastPatchHistoryEntryId, this.listenerPort, this.lifecycleState, this.timeCreated, this.lifecycleDetails, this.diskRedundancy, this.sparseDiskgroup, this.scanIpIds, this.vipIds, this.scanDnsRecordId, this.scanDnsName, this.zoneId, this.dataStorageSizeInGBs, this.recoStorageSizeInGB, this.nodeCount, this.licenseModel, this.maintenanceWindow, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.freeformTags, this.definedTags, this.sourceDbSystemId, this.pointInTimeDataDiskCloneTimestamp);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DbSystemSummary o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).displayName(o.getDisplayName()).availabilityDomain(o.getAvailabilityDomain()).faultDomains(o.getFaultDomains()).subnetId(o.getSubnetId()).backupSubnetId(o.getBackupSubnetId()).nsgIds(o.getNsgIds()).backupNetworkNsgIds(o.getBackupNetworkNsgIds()).shape(o.getShape()).dbSystemOptions(o.getDbSystemOptions()).sshPublicKeys(o.getSshPublicKeys()).timeZone(o.getTimeZone()).hostname(o.getHostname()).domain(o.getDomain()).kmsKeyId(o.getKmsKeyId()).version(o.getVersion()).cpuCoreCount(o.getCpuCoreCount()).clusterName(o.getClusterName()).dataStoragePercentage(o.getDataStoragePercentage()).databaseEdition(o.getDatabaseEdition()).lastPatchHistoryEntryId(o.getLastPatchHistoryEntryId()).listenerPort(o.getListenerPort()).lifecycleState(o.getLifecycleState()).timeCreated(o.getTimeCreated()).lifecycleDetails(o.getLifecycleDetails()).diskRedundancy(o.getDiskRedundancy()).sparseDiskgroup(o.getSparseDiskgroup()).scanIpIds(o.getScanIpIds()).vipIds(o.getVipIds()).scanDnsRecordId(o.getScanDnsRecordId()).scanDnsName(o.getScanDnsName()).zoneId(o.getZoneId()).dataStorageSizeInGBs(o.getDataStorageSizeInGBs()).recoStorageSizeInGB(o.getRecoStorageSizeInGB()).nodeCount(o.getNodeCount()).licenseModel(o.getLicenseModel()).maintenanceWindow(o.getMaintenanceWindow()).lastMaintenanceRunId(o.getLastMaintenanceRunId()).nextMaintenanceRunId(o.getNextMaintenanceRunId()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).sourceDbSystemId(o.getSourceDbSystemId()).pointInTimeDataDiskCloneTimestamp(o.getPointInTimeDataDiskCloneTimestamp());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DbSystemSummary.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", displayName=" + this.displayName + ", availabilityDomain=" + this.availabilityDomain + ", faultDomains=" + this.faultDomains + ", subnetId=" + this.subnetId + ", backupSubnetId=" + this.backupSubnetId + ", nsgIds=" + this.nsgIds + ", backupNetworkNsgIds=" + this.backupNetworkNsgIds + ", shape=" + this.shape + ", dbSystemOptions=" + this.dbSystemOptions + ", sshPublicKeys=" + this.sshPublicKeys + ", timeZone=" + this.timeZone + ", hostname=" + this.hostname + ", domain=" + this.domain + ", kmsKeyId=" + this.kmsKeyId + ", version=" + this.version + ", cpuCoreCount=" + this.cpuCoreCount + ", clusterName=" + this.clusterName + ", dataStoragePercentage=" + this.dataStoragePercentage + ", databaseEdition=" + (Object)((Object)this.databaseEdition) + ", lastPatchHistoryEntryId=" + this.lastPatchHistoryEntryId + ", listenerPort=" + this.listenerPort + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeCreated=" + this.timeCreated + ", lifecycleDetails=" + this.lifecycleDetails + ", diskRedundancy=" + (Object)((Object)this.diskRedundancy) + ", sparseDiskgroup=" + this.sparseDiskgroup + ", scanIpIds=" + this.scanIpIds + ", vipIds=" + this.vipIds + ", scanDnsRecordId=" + this.scanDnsRecordId + ", scanDnsName=" + this.scanDnsName + ", zoneId=" + this.zoneId + ", dataStorageSizeInGBs=" + this.dataStorageSizeInGBs + ", recoStorageSizeInGB=" + this.recoStorageSizeInGB + ", nodeCount=" + this.nodeCount + ", licenseModel=" + (Object)((Object)this.licenseModel) + ", maintenanceWindow=" + this.maintenanceWindow + ", lastMaintenanceRunId=" + this.lastMaintenanceRunId + ", nextMaintenanceRunId=" + this.nextMaintenanceRunId + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", sourceDbSystemId=" + this.sourceDbSystemId + ", pointInTimeDataDiskCloneTimestamp=" + this.pointInTimeDataDiskCloneTimestamp + ")";
        }
    }
}

