/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dialog;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentItem;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModel;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class Page
extends PageFlowSceneElement
implements SaveCookie {
    public final PageFlowController pc;
    private Node original;
    private PageContentModel pageContentModel = null;
    private String nodeDisplayName;
    private boolean renaming = false;
    private static final Image ABSTRACTNODE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/abstract.gif");
    private boolean hasPageContentModelBeenChecked = false;
    private PageContentChangeListener pccl;

    public Page(PageFlowController pc, Node original) {
        this.pc = pc;
        this.setNode(original);
    }

    public void updateContentModel() {
        if (!this.isDataNode()) {
            return;
        }
        FileObject fileObject = ((DataNode)this.original).getDataObject().getPrimaryFile();
        this.destroyListeners();
        for (PageContentModelProvider pageContentModelProvider : PageFlowController.getPageContentModelProviders()) {
            this.pageContentModel = pageContentModelProvider.getPageContentModel(fileObject);
            if (this.pageContentModel == null) continue;
            this.initListeners();
            return;
        }
    }

    private void setNode(Node newNode) {
        String oldDisplayName = this.nodeDisplayName;
        this.original = newNode;
        this.nodeDisplayName = this.original.getDisplayName();
        if (this.original instanceof DataNode) {
            assert (this.pc != null);
            FileObject fileObj = ((DataNode)this.original).getDataObject().getPrimaryFile();
            assert (fileObj != null);
            this.nodeDisplayName = Page.getFolderDisplayName(this.pc.getWebFolder(), fileObj);
        }
        if (!this.nodeDisplayName.equals(oldDisplayName)) {
            if (oldDisplayName != null) {
                this.pc.removePageName2Page(oldDisplayName, false);
            }
            this.pc.putPageName2Page(this.nodeDisplayName, this);
        }
    }

    public void updateNode_HACK() {
        this.setNode(this.original);
    }

    public void replaceWrappedNode(Node newNode) {
        this.setNode(newNode);
        this.pc.putPageName2Page(this.getDisplayName(), this);
    }

    public boolean isRenaming() {
        return this.renaming;
    }

    @Override
    public void setName(String s) {
        String oldDisplayName = this.getDisplayName();
        try {
            if (!this.pc.isPageInAnyFacesConfig(oldDisplayName)) {
                this.original.setName(s);
            } else {
                this.renaming = true;
                this.original.setName(s);
                String newDisplayName = this.original.getDisplayName();
                if (this.isDataNode()) {
                    newDisplayName = Page.getFolderDisplayName(this.pc.getWebFolder(), ((DataNode)this.original).getDataObject().getPrimaryFile());
                }
                this.pc.saveLocation(oldDisplayName, newDisplayName);
                this.renaming = false;
                this.pc.renamePageInModel(oldDisplayName, newDisplayName);
            }
        }
        catch (IllegalArgumentException iae) {
            boolean needToAnnotate;
            boolean bl = needToAnnotate = Exceptions.findLocalizedMessage((Throwable)iae) == null;
            if (needToAnnotate) {
                Exceptions.attachLocalizedMessage((Throwable)iae, (String)NbBundle.getMessage(Page.class, (String)"MSG_BadFormat", (Object)oldDisplayName, (Object)s));
            }
            Exceptions.printStackTrace((Throwable)iae);
        }
    }

    public String getDisplayName() {
        return this.nodeDisplayName;
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    @Override
    public boolean canRename() {
        return this.isModifiable();
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    public void destroy2() {
        this.destroyListeners();
        if (this.original instanceof NonDataNode) {
            this.original = null;
        }
        this.pccl = null;
        this.pageContentModel = null;
    }

    @Override
    public void destroy() throws IOException {
        Object input = DialogDescriptor.NO_OPTION;
        boolean removePageName2NodeReference = true;
        if (this.isDataNode()) {
            DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(Page.class, (String)"MSG_DELETE_QUESTION", (Object)this.getDisplayName()), NbBundle.getMessage(Page.class, (String)"MSG_DELETE_TITLE"), true, 1, DialogDescriptor.NO_OPTION, null);
            Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
            d.setVisible(true);
            input = dialog.getValue();
            if (this.pc != null && this.pc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                removePageName2NodeReference = false;
            }
        }
        String displayName = this.getDisplayName();
        if (input == DialogDescriptor.YES_OPTION) {
            this.pc.removeSceneNodeEdges(this);
            this.original.destroy();
            this.destroyListeners();
        } else if (input == DialogDescriptor.NO_OPTION || input == DialogDescriptor.CANCEL_OPTION) {
            // empty if block
        }
    }

    @Override
    public Image getIcon(int type) {
        if (!this.isDataNode()) {
            return ABSTRACTNODE;
        }
        return this.original.getIcon(type);
    }

    @Override
    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    @Override
    public Node getNode() {
        if (this.isDataNode()) {
            return this.original;
        }
        return new NonDataNode(this.original.getName());
    }

    public boolean isDataNode() {
        return this.original instanceof DataNode;
    }

    public void save() throws IOException {
        this.getCookie(SaveCookie.class).save();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        if (type.equals(SaveCookie.class)) {
            return (T)this.pc.getConfigDataObject().getCookie(type);
        }
        return (T)this.original.getCookie(type);
    }

    public static String getFolderDisplayName(FileObject webFolder, FileObject fileObject) {
        String folderpath = webFolder.getPath();
        String filepath = fileObject.getPath();
        return filepath.replaceFirst(folderpath + "/", "");
    }

    public static String getFolderDisplayName(FileObject webFolder, String path, String fileNameExt) {
        String folderpath = webFolder.getPath();
        return path.replaceFirst(folderpath + "/", "") + fileNameExt;
    }

    public Collection<PageContentItem> getPageContentItems() {
        if (this.pageContentModel == null) {
            return new ArrayList<PageContentItem>();
        }
        return this.pageContentModel.getPageContentItems();
    }

    public Collection<Pin> getPinNodes() {
        if (!this.hasPageContentModelBeenChecked) {
            this.updateContentModel();
            this.hasPageContentModelBeenChecked = true;
        }
        if (this.pageContentModel == null) {
            return Collections.emptyList();
        }
        Collection<PageContentItem> pageContentItems = this.pageContentModel.getPageContentItems();
        ArrayList<Pin> pinNodes = new ArrayList<Pin>(pageContentItems.size());
        for (PageContentItem pageContentItem : pageContentItems) {
            pinNodes.add(new Pin(this, pageContentItem));
        }
        return pinNodes;
    }

    private void initListeners() {
        if (this.pageContentModel != null && this.pccl == null) {
            this.pccl = new PageContentChangeListener();
            this.pageContentModel.addChangeListener(this.pccl);
        }
    }

    private void destroyListeners() {
        if (this.pccl != null && this.pageContentModel != null) {
            try {
                this.pageContentModel.removeChangeListener(this.pccl);
                this.pageContentModel.destroy();
                this.pageContentModel = null;
                this.pccl = null;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private final Page getInstance() {
        return this;
    }

    public Action[] getActions(boolean context) {
        if (this.pageContentModel != null) {
            return this.pageContentModel.getActions();
        }
        return new SystemAction[0];
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public final class NonDataNode
    extends AbstractNode {
        public NonDataNode(String pageName) {
            super(Children.LEAF);
            super.setName(pageName);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return Page.this.getInstance().getName();
        }

        public void setName(String s) {
            super.setName(s);
            Page.this.getInstance().setName(s);
        }
    }

    private class PageContentChangeListener
    implements ChangeListener {
        private PageContentChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!Page.this.pc.getView().isShowing()) {
                Page.this.pc.setGraphDirty();
            } else {
                Page.this.pc.updatePageItems(Page.this.getInstance());
            }
        }
    }
}

