/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.BorderLayout;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentCopyable;
import org.jd.gui.api.feature.ContentSavable;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.ContentSelectable;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.view.component.ClassFilePage;
import org.jd.gui.view.component.JavaFilePage;
import org.jd.gui.view.component.TypePage;

public class DynamicPage
extends JPanel
implements ContentCopyable,
ContentSavable,
ContentSearchable,
ContentSelectable,
FocusedTypeGettable,
IndexesChangeListener,
LineNumberNavigable,
PreferencesChangeListener,
UriGettable,
UriOpenable,
API.LoadSourceListener {
    protected API api;
    protected Container.Entry entry;
    protected TypePage page;
    protected URI lastOpenedUri;
    protected Collection<Future<Indexes>> lastCollectionOfFutureIndexes;

    public DynamicPage(API api, Container.Entry entry) {
        super(new BorderLayout());
        this.api = api;
        this.entry = entry;
        String source = api.getSource(entry);
        if (source == null) {
            this.page = new ClassFilePage(api, entry);
            this.add(this.page);
            api.loadSource(entry, this);
        } else {
            this.page = new JavaFilePage(api, new DelegatedEntry(entry, source));
            this.add(this.page);
        }
    }

    @Override
    public void copy() {
        this.page.copy();
    }

    @Override
    public String getFileName() {
        return this.page.getFileName();
    }

    @Override
    public void save(API api, OutputStream outputStream) {
        this.page.save(api, outputStream);
    }

    @Override
    public boolean highlightText(String text, boolean caseSensitive) {
        return this.page.highlightText(text, caseSensitive);
    }

    @Override
    public void findNext(String text, boolean caseSensitive) {
        this.page.findNext(text, caseSensitive);
    }

    @Override
    public void findPrevious(String text, boolean caseSensitive) {
        this.page.findPrevious(text, caseSensitive);
    }

    @Override
    public void selectAll() {
        this.page.selectAll();
    }

    @Override
    public String getFocusedTypeName() {
        return this.page.getFocusedTypeName();
    }

    @Override
    public Container.Entry getEntry() {
        return this.entry;
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.lastCollectionOfFutureIndexes = collectionOfFutureIndexes;
        this.page.indexesChanged(this.lastCollectionOfFutureIndexes);
    }

    @Override
    public int getMaximumLineNumber() {
        return this.page.getMaximumLineNumber();
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        this.page.goToLineNumber(lineNumber);
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return this.page.checkLineNumber(lineNumber);
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        this.page.preferencesChanged(preferences);
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public boolean openUri(URI uri) {
        this.lastOpenedUri = uri;
        return this.page.openUri(this.lastOpenedUri);
    }

    @Override
    public void sourceLoaded(String source) {
        SwingUtilities.invokeLater(() -> {
            Point viewPosition = this.page.getScrollPane().getViewport().getViewPosition();
            this.removeAll();
            this.page = new JavaFilePage(this.api, new DelegatedEntry(this.entry, source));
            this.add(this.page);
            this.page.getScrollPane().getViewport().setViewPosition(viewPosition);
            if (this.lastOpenedUri != null) {
                this.page.openUri(this.lastOpenedUri);
            }
            if (this.lastCollectionOfFutureIndexes != null) {
                this.page.indexesChanged(this.lastCollectionOfFutureIndexes);
            }
        });
    }

    protected static class DelegatedEntry
    implements Container.Entry {
        protected Container.Entry entry;
        protected String source;

        DelegatedEntry(Container.Entry entry, String source) {
            this.entry = entry;
            this.source = source;
        }

        @Override
        public Container getContainer() {
            return this.entry.getContainer();
        }

        @Override
        public Container.Entry getParent() {
            return this.entry.getParent();
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public String getPath() {
            return this.entry.getPath();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public long length() {
            return this.entry.length();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.source.getBytes());
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            return this.entry.getChildren();
        }
    }
}

