/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authorization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthorizationWebFilter
implements WebFilter {
    private static final Log logger = LogFactory.getLog(AuthorizationWebFilter.class);
    private ReactiveAuthorizationManager<? super ServerWebExchange> authorizationManager;

    public AuthorizationWebFilter(ReactiveAuthorizationManager<? super ServerWebExchange> authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return ((Mono)ReactiveSecurityContextHolder.getContext().filter(c -> c.getAuthentication() != null).map(SecurityContext::getAuthentication).as(authentication -> this.authorizationManager.verify((Mono<Authentication>)authentication, exchange2))).doOnSuccess(it -> logger.debug("Authorization successful")).doOnError(AccessDeniedException.class, ex -> logger.debug(LogMessage.format("Authorization failed: %s", (Object)ex.getMessage()))).switchIfEmpty(chain.filter(exchange2));
    }
}

