function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import remark2rehype from 'remark-rehype';
import rehype2react from 'rehype-react';
import * as MarkdownTooltip from './markdown_tooltip';
import * as MarkdownCheckbox from './markdown_checkbox';
import React, { createElement } from 'react';
import { EuiLink } from '../../link';
import { EuiCodeBlock, EuiCode } from '../../code';
import markdown from 'remark-parse';
import highlight from 'remark-highlight.js';
import emoji from 'remark-emoji';
import all from 'mdast-util-to-hast/lib/all';
export var getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  return [[markdown, {}], [highlight, {}], [emoji, {
    emoticon: true
  }], [MarkdownTooltip.parser, {}], [MarkdownCheckbox.parser, {}]];
};
export var defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();

var unknownHandler = function unknownHandler(h, node) {
  return h(node.position, node.type, node, all(h, node));
};

export var getDefaultEuiMarkdownProcessingPlugins = function getDefaultEuiMarkdownProcessingPlugins() {
  return [[remark2rehype, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to

  }], [rehype2react, {
    createElement: createElement,
    components: {
      a: EuiLink,
      code: function code(props) {
        return (// If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) ? /*#__PURE__*/React.createElement(EuiCodeBlock, _extends({
            fontSize: "m",
            paddingSize: "s"
          }, props)) : /*#__PURE__*/React.createElement(EuiCode, props)
        );
      },
      tooltipPlugin: MarkdownTooltip.renderer,
      checkboxPlugin: MarkdownCheckbox.renderer
    }
  }]];
};
export var defaultProcessingPlugins = getDefaultEuiMarkdownProcessingPlugins();