/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.udp.stream.UdpInputStream;
import de.rub.nds.tlsattacker.transport.udp.stream.UdpOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.DatagramSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerUdpTransportHandler
extends TransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int port;
    private DatagramSocket socket;

    public ServerUdpTransportHandler(long timeout, int port) {
        super(timeout, ConnectionEndType.SERVER, false);
        this.port = port;
    }

    @Override
    public void closeConnection() throws IOException {
        this.socket.close();
        this.inStream.close();
        this.outStream.close();
    }

    @Override
    public void initialize() throws IOException {
        this.socket = new DatagramSocket(this.port);
        this.socket.setSoTimeout((int)this.getTimeout());
        this.setStreams(new PushbackInputStream(new UdpInputStream(this.socket, true)), new UdpOutputStream(this.socket));
        this.waitOnReceive();
    }

    private void waitOnReceive() throws IOException {
        while (this.inStream.available() == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.socket.isClosed();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }

    public int getPort() {
        return this.port;
    }
}

