%-----------------------------------
/tx@PstWLDict 200 dict def
tx@PstWLDict begin
%--------------------------------------------
%% nm2rgb convert nanometer wavelength to RGB
%% (380 <= Lambda <= 780 ) -> R,G,B on stack
%--------------------------------------------
/lfactor {lambda 380 sub 0.0175 mul 0.3 add} def
/hfactor {780 lambda sub 0.00875 mul 0.3 add} def
/nm2rgb {% -- nm2rgb -- red green blue
  lambda 509 le
    {lambda 439 le
       {lambda 379 le
          {0 0 0}% lambda < 380
          {lambda 419 le
             {440 lambda sub 60 div lfactor mul gamma exp
              0 lfactor mul gamma exp % 379 < lambda <= 419
              1 lfactor mul gamma exp}
             {440 lambda sub 60 div gamma exp
              0 gamma exp % 419 < lambda < 439
              1 gamma exp}
             ifelse} % 419
          ifelse} % 379
       {lambda 489 le
          {0
           lambda 440 sub 50 div abs gamma exp %% abs
           1 gamma exp}
          {0
           1 gamma exp
           510 lambda sub 20 div gamma exp}
          ifelse} % 489
       ifelse} % 439
    {lambda 644 le
       {lambda 579 le
          {lambda 510 sub 70 div abs gamma exp %% abs
           1 gamma exp
           0}
          {1 gamma exp
           645 lambda sub 65 div gamma exp
           0}
          ifelse} % 579
       {lambda 780 le
          {lambda 700 le
             {1 gamma exp
              0
              0}
             {1 hfactor mul gamma exp
              0
              0}
             ifelse} % 700
          {0 0 0}% lambda > 780
          ifelse} % 780
       ifelse} % 644
    ifelse % 579
} bind def
%-------------------------------------
%% colored line
/bande {% -- bande --
  Lwidth setlinewidth
  xpos Lwidth 2 div add dup
  y1 moveto
  y2 lineto stroke
} def % faster than bind def, here
%--------------------------------------
%% drawing a spectrum
/tx@psspectrum {
  % x1 y1 x2 y2 gamma brightness numlines lend lbegin -- tx@psspectrum
  /psk@psspectrum@begin ED
  /psk@psspectrum@end ED
  /psk@psspectrum@numlines ED
  /psk@psspectrum@brightness ED
%  tx@PstWLDict begin /gamma ED end
  /gamma ED
  /y2 ED /x2 ED /y1 ED /x1 ED
  /DL {psk@psspectrum@end psk@psspectrum@begin sub} bind def % Delta lambda
  /DX {x2 x1 sub} bind def                                   % Delta X
  /LambdaStep {DL psk@psspectrum@numlines div} bind def
  /Lwidth     {DX psk@psspectrum@numlines div} bind def
  %% loop
  0 1 psk@psspectrum@numlines 1 sub {
    dup
    LambdaStep mul psk@psspectrum@begin add /lambda ED
    Lwidth mul x1 add /xpos ED
    tx@PstWLDict begin nm2rgb end setrgbcolor
    currenthsbcolor psk@psspectrum@brightness mul sethsbcolor
    tx@PstWLDict begin bande end
  } bind for
} def
%--------------------------------------
%% drawing lines
/DrawLines {% -- DrawLines --
  tx@PstWLDict begin nm2rgb end setrgbcolor
  currenthsbcolor ratio 4 div 0.75 add mul
  psk@psspectrum@brightness mul sethsbcolor
  tx@PstWLDict begin bande end
} def
%--------------------------------------
/ClipLines {% -- ClipLines --
  %% Some clipping tests :
  %% wavelength out of begin= and end= should not be drawn
  %% Is end= greater or lower than begin= ?
  psk@psspectrum@begin psk@psspectrum@end le {% ifelse
   lambda psk@psspectrum@begin ge {% if
    lambda psk@psspectrum@end le { DrawLines } if
   } if
  }{% else
   lambda psk@psspectrum@begin le {% if
    lambda psk@psspectrum@end ge { DrawLines } if
   } if
  } ifelse
} def
%--------------------------------------
/tx@rays {
  % [[wl1 I1 q1] [wl2 I2 q2] [wl3 I3 q3] ... ] Imax UserMin UserCharge
  % Lwidth x1 y1 x2 y2 gamma brightness lend lbegin
  % -- tx@rays
  /psk@psspectrum@begin ED
  /psk@psspectrum@end ED
  /psk@psspectrum@brightness ED
%  tx@PstWLDict begin /gamma ED end
  /gamma ED
  /y2 ED /x2 ED /y1 ED /x1 ED
  /Lwidth ED
  /UserCharge ED
  /UserImin ED
  /Imax ED
  /DL {psk@psspectrum@end psk@psspectrum@begin sub} def % Delta lambda
  /DX {x2 x1 sub} def                                   % Delta X
  aload
  length {% repeat
    aload pop % on stack : charge intensity lambda
    /charge ED
    % Intensity is on stack
    Imax div /ratio ED % Intensity/Imax = ratio
    /lambda ED
    ratio UserImin ge { % If intensity >= Imin, draw the line
      /xpos {lambda psk@psspectrum@begin sub DX mul DL div x1 add
             Lwidth 2 div sub} def
      UserCharge -2 eq % ifelse
        {% q=-2 means to draw all lines
          ClipLines
        }
        {% only draws lines corresponding to the charge
          UserCharge charge eq { ClipLines } if
        } ifelse
    } if
  } bind repeat
} def
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% Visible lines of some classical elements... thanks Larry W.
%
% Data structure : list of 3 elements array
% [[wavelength1 intensity1 charge1]
%  [wl2 I2 q2]
%  [wl3 I3 q3]
%  ...
%  ] Imax
% (intensity max at the end of each def)
% Sometimes, there is no charge in the source file, so I put charge = -1
% (see Es, Bk...)
%
/wl@elt@H {[
[383.5384 5 0][388.9049 6 0][397.0072 8 0][410.174 15 0][434.047 30 0]
[486.133 80 0][656.272 120 0][656.2852 180 0]]
180} bind def
%
/wl@elt@He {[
[381.9607 10 0][381.976 1 0][388.865 500 0][396.4729 20 0][400.927 1 0]
[402.6191 50 0][402.636 5 0][412.082 12 0][412.099 2 0][414.376 3 0]
[438.7929 10 0][443.755 3 0][447.1479 200 0][447.168 25 0][468.54 6 1]
[468.57 30 1][471.3146 30 0][471.338 4 0][492.1931 20 0][501.5678 100 0]
[504.774 10 0][541.152 5 1][587.562 500 0][587.597 100 0][656.01 8 1]
[667.815 100 0][686.748 3 0][706.519 200 0][706.571 30 0][728.135 50 0]]
500} bind def
%
/wl@elt@Li {[
[391.53 20 0][391.535 20 0][398.548 10 0][398.554 10 0][413.256 40 0]
[413.262 40 0][427.307 20 0][427.313 20 0][432.542 5 1][432.547 5 1]
[432.554 1 1][460.283 13 0][460.289 13 0][467.165 6 1][467.17 2 1]
[467.806 3 1][467.829 1 1][488.132 4 1][488.139 4 1][488.149 1 1]
[497.166 8 0][497.175 8 0][548.355 600 1][548.565 600 1][610.354 320 0]
[610.365 320 0][670.776 3600 0][670.791 3600 0]]
3600} bind def
%
/wl@elt@Be {[
[381.345 700 0][386.513 40 0][386.542 80 0][386.551 1 0][386.572 6 0]
[386.603 100 0][425.305 100 0][425.376 60 0][436.066 300 1][436.099 500 1]
[440.794 400 0][457.266 12 0][467.333 700 1][467.342 1000 1][470.937 6 0]
[482.816 200 1][484.916 40 0][485.822 2 1][508.775 80 0][521.812 8 1]
[521.833 20 1][525.586 3 1][527.028 64 1][527.081 500 1][540.304 20 1]
[541.021 20 1][622.911 10 0][627.943 16 1][627.973 30 1][647.354 30 0]
[654.789 60 1][655.836 60 1][656.452 30 0][663.644 2 1][675.672 1 1]
[675.713 2 1][678.656 30 0][688.422 1 0][688.444 6 0][698.275 100 0]
[715.44 6 0][715.465 40 0][720.913 100 0][740.12 3 1][740.143 2 1]
[755.19 10 0][761.868 10 0][761.888 20 0][424.914 90 2][448.552 2 2]
[448.73 100 2][449.509 1 2][449.78 140 2][614.201 140 2]]
1000} bind def
%
/wl@elt@B {[
[412.193 285 1][419.479 110 1][447.21 110 1][447.285 110 1][478.421 70 1]
[494.038 110 1][608.044 110 1][628.547 70 1][703.02 70 1][703.19 40 1]
[424.298 40 2][424.361 70 2][448.705 220 2][449.773 360 2]]
360} bind def
%
/wl@elt@C {[
[387.619 350 1][387.641 350 1][387.666 350 1][391.898 570 1][392.069 800 1]
[407.452 250 1][407.585 350 1][426.7 800 1][426.726 1000 1][477.175 200 0]
[493.205 200 0][505.217 200 0][513.294 350 1][513.328 350 1][514.349 350 1]
[514.516 570 1][515.109 400 1][538.034 300 0][564.807 250 1][566.247 350 1]
[588.977 570 1][589.159 350 1][600.113 200 0][600.603 250 0][600.718 110 0]
[601.068 150 0][601.322 300 0][601.484 250 0][657.805 800 1][658.288 570 1]
[658.761 200 0][678.39 250 1][711.318 250 0][711.519 250 0][711.563 250 1]
[711.699 200 0][711.99 350 1][723.132 800 1][723.642 1000 1][405.606 150 2]
[406.794 200 2][406.891 250 2][407.026 250 2][416.286 150 2][418.69 250 2]
[432.556 200 2][464.742 600 2][465.025 520 2][465.147 375 2][466.586 200 2]
[569.592 450 2][582.642 150 2][674.438 150 2][703.725 150 2][761.265 150 2]
[465.83 200 3][580.133 250 3][581.198 200 3][772.62 90 3][494.388 5 4]
[494.456 5 4]]
1000} bind def
%
/wl@elt@N {[
[383.837 285 1][391.9 360 1][395.585 450 1][399.5 1000 1][403.508 360 1]
[404.131 550 1][404.353 360 1][409.994 140 0][410.995 185 0][417.616 285 1]
[422.774 285 1][423.691 285 1][423.705 220 1][424.178 450 1][443.274 285 1]
[444.703 650 1][453.041 360 1][460.148 550 1][460.716 450 1][461.387 360 1]
[462.139 450 1][463.054 870 1][464.308 550 1][478.813 285 1][480.329 450 1]
[484.738 180 0][489.511 285 1][491.494 160 0][493.512 210 0][495.023 160 0]
[496.398 350 0][498.737 285 1][499.436 450 1][500.148 650 1][500.27 360 1]
[500.515 870 1][500.732 550 1][501.062 450 1][501.639 360 1][502.566 360 1]
[504.51 550 1][528.12 185 0][529.268 140 0][549.567 450 1][553.536 285 1]
[566.663 650 1][567.602 550 1][567.956 870 1][568.621 450 1][571.077 450 1]
[574.73 285 1][575.25 700 0][576.475 240 0][582.954 265 0][585.404 235 0]
[592.781 360 1][593.178 550 1][594.024 285 1][594.165 650 1][595.239 285 1]
[599.943 160 0][600.847 210 0][616.776 285 1][637.962 360 1][641.165 185 0]
[642.064 210 0][642.302 210 0][642.832 210 0][643.768 185 0][644.094 235 0]
[645.79 185 0][646.844 300 0][648.205 750 1][648.27 360 0][648.375 300 0]
[648.171 265 0][648.48 325 0][649.122 160 0][649.954 210 0][650.631 185 0]
[661.056 750 1][662.254 185 0][663.694 185 0][664.496 235 0][664.65 185 0]
[665.346 235 0][665.651 210 0][672.262 185 0][739.864 210 0][740.612 160 0]
[740.624 265 0][742.364 685 0][744.229 785 0][746.831 900 0][760.88 185 0]
[776.224 450 1][393.852 90 2][399.863 150 2][400.358 200 2][409.733 250 2]
[410.343 200 2][419.576 120 2][420.01 150 2][433.291 90 2][434.568 120 2]
[437.911 300 2][451.091 90 2][451.486 120 2][463.414 90 2][464.064 120 2]
[485.882 90 2][486.715 150 2][531.435 90 2][532.082 200 2][532.718 150 2]
[645.411 90 2][646.702 120 2][405.776 150 3][460.633 90 3][638.077 150 3]
[460.373 350 4][461.998 250 4][494.456 200 4][761.846 60 4]]
1000} bind def
%
/wl@elt@O {[
[380.314 160 1][382.341 120 0][391.196 450 1][391.929 160 1][394.729 185 0]
[394.748 160 0][394.759 140 0][395.437 220 1][395.461 100 0][397.326 450 1]
[398.22 220 1][406.99 160 1][407.216 285 1][407.587 450 1][408.391 80 1]
[408.714 50 1][408.927 150 1][409.724 110 1][410.5 220 1][411.922 285 1]
[413.281 160 1][414.606 50 1][415.33 220 1][418.546 285 1][418.979 450 1]
[423.327 80 0][425.374 50 1][425.398 50 1][427.547 50 1][430.378 50 1]
[431.714 285 1][433.686 160 1][434.556 220 1][434.943 285 1][436.69 220 1]
[436.825 100 0][439.595 220 1][441.491 450 1][441.698 285 1][444.821 160 1]
[445.238 160 1][446.545 50 1][446.628 50 1][446.783 50 1][446.941 50 1]
[459.097 360 1][459.617 285 1][460.939 80 1][463.885 160 1][464.181 360 1]
[464.914 450 1][465.084 160 1][466.164 360 1][467.623 285 1][469.921 220 1]
[470.536 285 1][492.46 160 1][494.306 220 1][532.91 135 0][532.968 160 0]
[533.074 190 0][543.518 90 0][543.578 110 0][543.686 135 0][557.734 120 0]
[595.839 160 0][595.858 190 0][599.528 80 0][604.623 160 0][604.644 190 0]
[604.649 110 0][610.627 100 0][615.598 400 0][615.677 450 0][615.818 490 0]
[625.683 80 0][626.155 100 0][636.634 100 0][637.432 100 0][645.36 320 0]
[645.444 360 0][645.598 400 0][660.491 80 0][665.383 100 0][700.192 360 0]
[700.223 450 0][715.67 210 0][725.415 400 0][725.445 450 0][725.453 320 0]
[747.644 210 0][747.724 100 0][747.908 120 0][748.067 120 0][770.675 100 0]
[777.194 870 0][777.417 810 0][777.539 750 0][396.159 200 2][559.237 110 2]
[412.399 100 4][493.027 230 4][559.791 130 4][650.024 130 4]]
870} bind def
%
/wl@elt@F {[
[380.583 140 1][384.709 270 1][384.999 260 1][385.167 250 1][389.848 5 0]
[389.883 190 1][390.193 180 1][390.382 170 1][393.069 8 0][393.426 5 0]
[394.856 5 0][397.204 150 1][397.267 160 1][397.478 170 1][402.473 240 1]
[402.501 220 1][402.549 230 1][408.391 160 1][410.307 190 1][410.322 170 1]
[410.351 200 1][410.371 180 1][410.387 170 1][410.916 170 1][411.654 160 1]
[411.921 150 1][420.715 140 1][422.516 170 1][424.412 150 1][424.623 200 1]
[424.639 190 1][424.659 180 1][424.677 170 1][424.684 160 1][427.536 170 1]
[427.753 160 1][427.893 160 1][429.917 200 1][444.653 160 1][444.672 170 1]
[444.719 180 1][473.438 140 1][485.939 170 1][493.326 160 1][496.065 6 0]
[500.2 140 1][517.325 150 1][523.041 15 0][527.901 12 0][554.052 18 0]
[555.243 12 0][557.733 10 0][558.927 160 1][562.406 20 0][562.693 12 0]
[565.915 15 0][566.753 40 0][567.167 90 0][568.914 18 0][570.082 25 0]
[570.731 25 0][595.015 12 0][595.919 25 0][596.528 70 0][599.443 50 0]
[601.583 150 0][603.804 80 0][604.754 900 0][608.011 100 0][614.976 800 0]
[621.087 400 0][623.965 13000 0][624.79 140 1][634.851 10000 0][641.365 8000 0]
[656.969 450 0][658.039 300 0][665.041 400 0][669.048 1800 0][670.828 400 0]
[677.398 7000 0][679.553 1500 0][683.426 9000 0][685.603 50000 0][687.022 8000 0]
[690.248 15000 0][690.982 6000 0][696.635 4000 0][703.747 45000 0][712.789 30000 0]
[717.99 130 1][720.236 15000 0][721.179 130 1][730.903 1000 0][731.102 15000 0]
[731.43 700 0][733.196 5000 0][739.869 10000 0][742.565 4000 0][748.272 2200 0]
[748.916 2500 0][751.492 900 0][755.224 5000 0][757.338 5000 0][760.717 7000 0]
[775.47 18000 0][442.03 140 2][442.735 120 2][443.232 120 2][447.999 140 2]
[501.254 150 2][511.099 160 2][575.317 140 2][576.12 120 2][609.182 150 2]
[612.55 140 2][623.357 130 2][636.305 140 2][733.677 120 2][735.494 130 2]]
50000} bind def
%
/wl@elt@Ne {[
[381.843 100 1][382.975 120 1][421.974 150 1][423.385 100 1][425.065 120 1]
[436.986 120 1][437.94 70 1][437.955 150 1][438.506 100 1][439.199 200 1]
[439.799 150 1][440.93 150 1][441.322 100 1][442.139 100 1][442.852 100 1]
[442.863 100 1][443.09 150 1][443.094 150 1][445.705 120 1][452.272 100 1]
[453.7754 10 0][454.038 10 0][456.906 100 1][470.4395 15 0][470.8862 12 0]
[471.0067 10 0][471.2066 10 0][471.5347 15 0][475.2732 10 0][478.8927 12 0]
[479.022 10 0][482.7344 10 0][488.4917 10 0][500.5159 4 0][503.7751 10 0]
[514.4938 10 0][533.0778 25 0][534.1094 20 0][534.3283 8 0][540.0562 60 0]
[556.2766 5 0][565.6659 10 0][571.9225 5 0][574.8298 12 0][576.4419 80 0]
[580.445 12 0][582.0156 40 0][585.2488 500 0][587.2828 100 0][588.1895 100 0]
[590.2462 60 0][590.6429 60 0][594.4834 100 0][596.5471 100 0][597.4627 100 0]
[597.5534 120 0][598.7907 80 0][602.9997 100 0][607.4338 100 0][609.6163 80 0]
[612.845 60 0][614.3063 100 0][616.3594 120 0][618.2146 250 0][621.7281 150 0]
[626.6495 150 0][630.4789 60 0][633.4428 100 0][638.2992 120 0][640.2246 200 0]
[650.6528 150 0][653.2882 60 0][659.8953 150 0][665.2093 70 0][667.8276 90 0]
[671.7043 20 0][692.9467 100 0][702.405 90 0][703.2413 100 0][705.1292 50 0]
[705.9107 80 0][717.3938 100 0][721.32 150 1][723.519 150 1][724.5167 100 0]
[734.394 150 1][747.2439 40 0][748.8871 90 0][749.21 100 1][752.282 150 1]
[753.5774 80 0][754.4044 60 0][772.4628 100 0][774.074 120 1]]
500} bind def
%
/wl@elt@Na {[
[408.137 200 1][411.37 300 1][412.308 250 1][423.326 250 1][423.899 2 0]
[424.037 200 1][424.09 250 1][424.208 3 0][427.364 4 0][427.679 5 0]
[428.784 2 0][429.101 3 0][429.248 250 1][429.286 250 1][430.881 250 1]
[430.904 250 1][432.091 250 1][432.14 6 0][432.462 7 0][433.729 250 1]
[434.149 4 0][434.411 250 1][434.474 5 0][436.86 200 1][437.522 200 1]
[438.749 200 1][439.003 8 0][439.281 250 1][439.334 9 0][440.512 200 1]
[441.989 6 0][442.325 7 0][444.67 200 1][444.741 200 1][445.474 200 1]
[445.523 200 1][445.721 200 1][447.463 200 1][447.88 200 1][448.167 200 1]
[449.015 200 1][449.087 200 1][449.418 10 0][449.766 11 0][449.962 200 1]
[450.697 200 1][451.921 200 1][452.498 200 1][453.332 200 1][454.163 7 0]
[454.519 8 0][455.153 200 1][459.092 160 1][472.223 160 1][473.11 160 1]
[473.25 100 1][474.167 160 1][476.879 160 1][478.879 100 1][481.475 50 1]
[483.526 50 1][514.311 60 1][519.165 100 1][520.333 50 1][520.855 80 1]
[539.063 60 1][540.046 70 1][541.455 90 1][568.2633 5 0][568.8204 9 0]
[588.995 32 0][589.5924 16 0][617.525 60 1][619.926 70 1][623.468 70 1]
[626.001 80 1][627.474 80 1][631.08 60 1][635.283 60 1][635.805 60 1]
[636.115 70 1][636.641 70 1][637.891 60 1][647.529 50 1][651.421 90 1]
[652.468 80 1][653.07 130 1][654.404 130 1][654.575 130 1][655.243 80 1]]
300} bind def
%
/wl@elt@Mg {[
[382.93 140 0][383.23 300 0][383.829 500 0][384.824 8 1][384.891 1 0]
[385.04 7 1][385.396 2 0][385.496 1 0][385.886 2 0][387.831 3 0]
[389.191 2 0][389.33 2 0][389.557 3 0][390.386 4 0][393.84 6 0]
[398.421 1 0][398.675 8 0][405.469 2 0][405.75 10 0][407.506 3 0]
[408.183 2 0][416.51 4 0][416.727 15 0][435.191 20 0][435.453 6 0]
[438.038 6 0][438.464 9 1][439.059 10 1][442.8 8 1][443.399 9 1]
[443.649 5 1][443.66 4 1][448.116 14 1][448.133 13 1][453.429 6 1]
[457.11 28 0][462.13 3 0][470.299 7 0][473.003 10 0][473.959 6 1]
[473.971 5 1][485.11 7 1][516.733 75 0][517.268 220 0][518.361 400 0]
[526.421 8 1][526.437 7 1][534.598 1 0][540.154 9 1][550.96 2 0]
[552.841 6 0][571.109 30 0][578.531 5 0][578.556 4 0][591.643 7 1]
[591.816 6 1][631.872 10 0][631.924 9 0][631.949 7 0][634.674 10 1]
[634.696 9 1][654.597 11 1][662.044 5 1][662.057 6 1][663.083 2 0]
[678.145 7 1][678.785 8 1][681.286 7 1][681.927 8 1][689.49 4 0]
[696.54 6 0][706.041 8 0][719.317 10 0][729.106 10 0][738.7 5 0]
[738.769 12 0][758.076 4 1][765.76 20 0][765.915 19 0][765.99 17 0]
[769.016 8 0][769.155 15 0][772.261 1 0][774.634 1 0][775.93 1 0]
[778.65 5 1][779.098 4 1][491.6 10 2][583.982 10 2][625.675 15 2]]
500} bind def
%
/wl@elt@Al {[
[390.068 450 1][393.2 60 0][394.4006 4500 0][396.152 9000 0][399.586 110 1]
[422.681 290 1][458.582 150 1][458.819 110 1][466.68 550 1][489.876 110 1]
[490.277 110 1][528.021 150 1][510.752 70 0][528.377 290 1][528.585 150 1]
[531.232 110 1][531.607 220 1][537.184 150 1][555.706 180 0][555.795 110 0]
[559.323 450 1][585.362 110 1][597.194 220 1][600.176 290 1][600.188 220 1]
[600.642 450 1][606.111 150 1][606.843 290 1][606.853 110 1][607.323 450 1]
[618.157 110 1][618.168 150 1][618.228 290 1][618.245 220 1][618.342 450 1]
[620.152 450 1][620.17 360 1][622.618 290 1][623.178 360 1][624.336 450 1]
[633.574 450 1][669.602 360 0][669.867 230 0][708.397 60 0][708.464 70 0]
[736.157 110 0][736.23 140 0][760.616 60 0][761.482 90 0][398.014 110 2]
[408.245 110 2][408.861 150 2][414.237 110 2][414.992 650 2][415.017 650 2]
[436.464 110 2][447.989 650 2][447.997 650 2][451.256 760 2][452.894 550 2]
[452.919 870 2][470.115 110 2][470.141 150 2][490.41 110 2][515.101 110 2]
[516.389 110 2][569.66 1200 2][572.273 1000 2][605.521 110 2][763.537 220 2]
[766.026 150 2][768.197 220 2]]
9000} bind def
%
/wl@elt@Si {[
[385.366 100 1][385.602 500 1][386.26 200 1][390.5523 300 0][395.574 10 1]
[397.746 10 1][399.177 15 1][399.801 10 1][407.545 20 1][407.678 15 1]
[410.2936 70 0][412.807 300 1][413.089 500 1][418.335 10 1][419.072 100 1]
[419.813 50 1][462.142 100 1][462.172 150 1][478.2991 50 0][479.2212 35 0]
[479.2324 80 0][488.32 15 1][490.699 20 1][493.28 20 1][494.7607 30 0]
[500.6061 40 0][504.103 1000 1][505.598 1000 1][518.19 100 1][518.525 100 1]
[519.286 200 1][520.241 500 1][529.519 30 1][540.534 100 1][541.724 15 1]
[542.892 15 1][543.289 15 1][543.862 100 1][544.726 20 1][545.449 15 1]
[545.645 100 1][546.643 500 1][546.687 500 1][546.921 100 1][549.323 40 0]
[549.645 200 1][551.7535 35 0][554.074 100 1][557.666 150 1][562.2221 30 0]
[563.297 100 1][563.948 200 1][564.5611 90 0][566.066 150 1][566.5554 80 0]
[566.956 1000 1][568.144 30 1][568.4484 120 0][568.881 300 1][569.0425 100 0]
[570.1105 90 0][570.137 200 1][570.637 100 1][570.8397 160 0][574.7667 45 0]
[575.3625 45 0][575.422 45 0][576.2977 45 0][577.2145 70 0][578.0384 70 0]
[578.573 30 1][579.3071 90 0][579.49 30 1][579.7859 100 0][580.047 150 1]
[580.674 200 1][582.78 30 1][584.613 50 1][586.748 10 1][586.84 300 1]
[587.3764 40 0][591.522 150 1][594.8545 200 0][595.756 500 1][597.893 500 1]
[606.745 10 1][608.006 20 1][608.667 10 1][612.5021 90 0][613.1574 85 0]
[613.185 90 0][614.2487 100 0][614.5015 100 0][615.5134 160 0][623.732 160 0]
[623.8287 40 0][624.3813 125 0][624.4468 125 0][625.4188 180 0][633.1954 45 0]
[634.71 1000 1][637.136 1000 1][652.6609 45 0][652.7199 45 0][655.5462 45 0]
[666.052 50 1][666.5 15 1][667.188 100 1][669.938 20 1][671.704 50 1]
[672.1853 100 0][674.164 30 0][675.028 20 1][681.845 30 1][682.982 50 1]
[684.8568 30 0][697.6523 80 0][700.3567 180 0][700.5883 180 0][701.728 30 0]
[701.7646 90 0][703.4903 250 0][716.469 70 0][716.5545 200 0][718.489 70 0]
[719.358 65 0][719.39 30 0][722.6206 100 0][723.5326 100 0][723.582 60 0]
[725.0625 180 0][727.5294 160 0][728.281 40 0][728.9173 400 0][729.026 55 0]
[737.3 35 0][740.5774 375 0][740.9082 200 0][741.535 40 0][741.5946 275 0]
[742.3497 425 0][742.46 85 0][768.0267 100 0][774.271 40 0][380.654 30 2]
[384.246 7 2][392.447 20 2][394.749 6 2][396.384 6 2][398.124 5 2]
[410.186 5 2][410.242 8 2][411.55 5 2][433.85 9 2][434.14 8 2]
[437.763 8 2][440.59 6 2][440.672 8 2][449.405 6 2][455.262 30 2]
[455.4 8 2][456.782 25 2][457.476 20 2][461.966 7 2][463.828 7 2]
[466.587 8 2][468.302 9 2][468.38 7 2][471.665 16 2][473.052 7 2]
[480.043 8 2][481.333 15 2][481.972 16 2][482.897 18 2][509.142 10 2]
[511.376 7 2][511.412 8 2][519.726 5 2][545.146 6 2][547.305 7 2]
[570.46 7 2][571.629 8 2][573.973 20 2][589.879 10 2][631.446 7 2]
[652.436 6 2][683.156 6 2][685.165 7 2][746.189 5 2][746.262 8 2]
[746.632 9 2][761.236 12 2][403.139 1 3][403.806 2 3][408.885 10 3]
[411.61 9 3][421.241 7 3][431.41 3 3][432.818 5 3][440.373 2 3]
[441.165 1 3][461.127 1 3][462.862 3 3][463.124 9 3][465.432 10 3]
[465.692 3 3][466.714 1 3][467.33 2 3][494.745 1 3][495.011 3 3]
[530.497 2 3][530.949 1 3][666.756 5 3][670.121 7 3][699.836 3 3]
[704.794 6 3][706.841 4 3][763.05 2 3][765.456 4 3][767.875 4 3]
[771.879 5 3][772.382 6 3][772.564 2 3][773.047 1 3][775.291 1 3]]
1000} bind def
%
/wl@elt@P {[
[417.848 100 1][428.86 200 1][438.535 200 1][442.071 400 1][445.246 100 1]
[446.3 150 1][446.798 120 1][447.526 200 1][449.924 200 1][453.081 120 1]
[455.483 120 1][455.807 120 1][458.171 120 1][458.804 500 1][458.986 500 1]
[460.208 600 1][462.67 300 1][465.831 300 1][486.442 200 1][492.72 150 1]
[494.353 500 1][495.439 300 1][496.971 300 1][519.141 150 1][525.352 300 1]
[529.613 400 1][531.607 250 1][534.475 300 1][537.82 250 1][538.688 300 1]
[540.972 200 1][542.591 400 1][545.074 400 1][545.831 100 0][546.12 125 1]
[547.775 200 0][548.355 200 1][549.973 200 1][550.719 200 1][554.114 200 1]
[558.327 200 1][558.834 250 1][572.771 100 1][602.418 500 1][603.404 400 1]
[604.312 500 1][605.55 250 1][605.786 100 1][608.782 350 1][609.768 150 0]
[616.559 350 1][619.901 180 0][623.229 100 1][636.727 200 1][643.532 250 1]
[643.631 130 1][645.999 600 1][650.346 600 1][650.797 600 1][671.328 150 1]
[671.742 120 0][716.545 100 0][717.512 150 0][717.666 120 0][750.576 100 0]
[390.4812 200 2][391.4314 250 2][395.7641 300 2][397.8307 350 2][405.744 200 2]
[405.9312 400 2][408.0084 300 2][422.2195 500 2][424.672 350 2][442.8171 200 2]
[446.3668 200 2][447.9776 250 2][608.3409 150 2][640.9204 150 2][648.444 150 2]
[648.6381 150 2][699.269 150 2][424.9656 300 3][454.0288 250 3][454.1112 250 3]
[454.8056 150 3][454.8449 200 3][523.5499 150 3][598.9774 150 3][614.2605 150 3]
[671.3939 150 3][671.5906 120 3][744.3657 200 3][408.318 150 4][409.495 110 4]
[515.672 110 4]]
600} bind def
%
/wl@elt@S {[
[386.76 285 0][390.2 285 0][393.33 360 1][412.08 450 0][414.23 280 1]
[414.51 360 1][415.31 450 1][416.27 450 1][469.41 450 0][469.54 285 0]
[469.62 160 0][471.62 280 1][481.55 450 1][492.41 360 1][492.53 450 1]
[499.35 285 0][542.86 360 1][543.28 650 1][545.38 1000 1][547.36 1000 1]
[550.97 1000 1][556.49 280 1][560.61 1000 1][564 450 1][564.03 450 1]
[564.7 280 1][565.99 650 1][566.47 450 1][570.61 160 0][581.92 450 1]
[605.27 450 0][628.64 280 1][628.71 450 1][630.55 450 1][631.27 450 1]
[638.49 280 1][639.73 280 1][639.8 280 1][641.37 360 1][674.36 160 0]
[674.88 285 0][675.72 450 0][757.9 450 0][762.98 450 0][768.61 285 0]
[769.67 450 0][383.83 160 2][392.86 160 2][425.36 360 2][428.5 110 2]
[433.27 70 2]]
1000} bind def
%
/wl@elt@Cl {[
[380.518 1900 1][380.946 1300 1][382.02 1700 1][382.759 2800 1][383.335 4500 1]
[384.32 2500 1][384.537 3100 1][384.565 3900 1][384.58 1500 1][385.099 10000 1]
[385.137 7900 1][385.165 1200 1][386.083 25000 1][386.099 4400 1][386.137 1000 1]
[391.387 1500 1][391.663 1100 1][394.482 20 0][410.479 20 0][413.25 10000 1]
[420.967 65 0][422.642 50 0][426.458 60 0][436.327 100 0][436.95 100 0]
[437.293 5000 1][437.99 100 0][438.975 100 0][439.04 90 0][440.303 90 0]
[443.849 100 0][447.53 90 0][448.991 1500 1][452.619 100 0][460.098 80 0]
[462.3938 40 0][465.404 50 0][466.1208 80 0][469.1523 45 0][472.1255 40 0]
[474.0729 45 0][476.865 4300 1][478.132 13000 1][479.455 99000 1][481.006 29000 1]
[481.947 16000 1][489.677 81000 1][490.478 47000 1][491.773 26000 1][499.548 10000 1]
[507.826 26000 1][509.9789 30 0][521.794 56000 1][522.136 23000 1][539.212 15000 1]
[542.323 99000 1][542.351 10000 1][544.337 19000 1][544.421 10000 1][545.702 5600 1]
[553.2162 40 0][579.6305 50 0][579.9914 45 0][585.6742 30 0][594.858 100 0]
[601.9812 50 0][608.261 35 0][609.469 1900 1][611.443 160 0][614.0245 200 0]
[619.4757 160 0][639.866 160 0][643.4833 150 0][653.143 150 0][666.167 1400 1]
[667.843 150 0][668.602 1300 1][671.341 1200 1][684.029 150 0][693.2903 300 0]
[698.1886 300 0][708.6814 600 0][725.662 7500 0][741.411 5000 0][746.237 550 0]
[748.947 550 0][749.2118 700 0][754.7072 11000 0][767.242 2300 0][770.2828 450 0]
[771.7581 7000 0][774.497 10000 0][776.916 2200 0][777.109 650 0][392.587 500 2]
[399.15 700 2][401.85 600 2][405.907 600 2][410.423 500 2][410.683 500 2]
[437.091 400 2][460.821 500 2][470.314 300 2][486.375 100 2][497.164 10 2]]
99000} bind def
%
/wl@elt@Ar {[
[380.3172 25 1][380.9456 50 1][383.4679 7 0][385.0581 70 1][386.8528 35 1]
[392.5719 35 1][392.8623 50 1][393.2547 25 1][394.6097 70 1][394.7505 7 0]
[394.8979 35 0][397.9356 20 1][399.4792 35 1][401.3857 50 1][403.3809 50 1]
[403.546 20 1][404.2894 150 1][404.4418 50 0][405.2921 100 1][407.2005 200 1]
[407.2385 70 1][407.6628 25 1][407.9574 35 1][408.2387 25 1][410.3912 150 1]
[413.1724 300 1][415.6086 35 1][415.859 400 0][416.418 50 0][417.9297 35 1]
[418.1884 50 0][419.0713 100 0][419.1029 50 0][419.8317 200 0][420.0674 400 0]
[421.8665 25 1][422.2637 25 1][422.6988 25 1][422.8158 100 1][423.722 100 1]
[425.1185 25 0][425.9362 200 0][426.6286 100 0][426.6527 70 1][427.2169 150 0]
[427.7528 550 1][428.2898 20 1][430.0101 100 0][430.065 25 1][430.9239 70 1]
[433.12 200 1][433.203 50 1][433.3561 100 0][433.5338 50 0][434.5168 25 0]
[434.8064 800 1][435.2205 50 1][436.2066 25 1][436.7832 50 1][437.0753 200 1]
[437.1329 70 1][437.5954 50 1][437.9667 150 1][438.5057 50 1][440.0097 70 1]
[440.0986 200 1][442.6001 400 1][443.0189 150 1][443.0996 50 1][443.3838 50 1]
[443.9461 20 1][444.8879 35 1][447.4759 100 1][448.1811 200 1][451.0733 100 0]
[452.2323 20 0][453.0552 20 1][454.5052 400 1][456.4405 20 1][457.935 400 1]
[458.9898 400 1][459.6097 15 0][460.9567 550 1][462.8441 7 0][463.7233 35 1]
[465.7901 400 1][470.2316 15 0][472.1591 20 1][472.6868 550 1][473.2053 50 1]
[473.5906 300 1][476.4865 800 1][480.602 550 1][484.781 150 1][486.591 50 1]
[487.9864 800 1][488.9042 70 1][490.4752 20 1][493.3209 35 1][496.508 200 1]
[500.9334 50 1][501.7163 70 1][506.2037 70 1][509.0495 20 1][514.1783 100 1]
[514.5308 70 1][515.1391 5 0][516.2285 15 0][516.5773 25 1][518.7746 20 0]
[521.6814 20 1][522.1271 7 0][542.1352 5 0][545.1652 10 0][549.5874 25 0]
[550.6113 5 0][555.8702 25 0][557.2541 10 0][560.6733 35 0][565.0704 20 0]
[573.952 10 0][583.4263 5 0][586.031 10 0][588.2624 15 0][588.8584 25 0]
[591.2085 50 0][592.8813 15 0][594.2669 5 0][598.7302 7 0][599.8999 5 0]
[602.515 5 0][603.2127 70 0][604.3223 35 0][605.2723 10 0][605.9372 20 0]
[609.8803 7 0][610.5635 10 0][611.4923 100 1][614.5441 10 0][617.0174 7 0]
[617.2278 150 1][617.3096 10 0][621.2503 10 0][621.5938 5 0][624.312 25 1]
[629.6872 7 0][630.7657 15 0][636.9575 7 0][638.4717 20 0][641.6307 70 0]
[648.3082 25 1][653.8112 15 0][660.4853 15 0][663.8221 25 1][663.974 20 1]
[664.3698 50 1][666.0676 5 0][666.4051 5 0][666.6359 25 1][667.7282 100 0]
[668.4293 35 1][675.2834 150 0][675.6163 5 0][676.6612 15 0][686.1269 20 1]
[687.1289 150 0][687.9582 5 0][688.8174 10 0][693.7664 50 0][695.1478 7 0]
[696.025 7 0][696.5431 10000 0][703.0251 150 0][706.7218 10000 0][706.8736 100 0]
[710.7478 25 0][712.582 25 0][714.7042 1000 0][715.8839 15 0][720.698 70 0]
[726.5172 15 0][727.0664 7 0][727.2936 2000 0][731.1716 35 0][731.6005 25 0]
[735.0814 5 0][735.3293 70 0][737.2118 200 0][738.0426 20 1][738.398 10000 0]
[739.298 20 0][741.2337 15 0][742.5294 10 0][743.5368 25 0][743.6297 10 0]
[750.3869 20000 0][751.4652 15000 0][763.5106 25000 0][772.3761 15000 0][772.4207 10000 0]
[385.832 10 2][390.784 7 2][396.053 8 2][402.36 6 2][414.67 5 2]]
25000} bind def
%
/wl@elt@K {[
[380.014 6 1][381.656 6 1][381.75 7 1][387.374 5 1][387.862 4 1]
[389.792 8 1][392.3 5 1][392.636 5 1][394.253 6 1][395.521 6 1]
[396.672 6 1][397.258 6 1][399.51 6 1][400.124 7 1][401.21 5 1]
[404.259 6 1][404.414 18 0][404.721 17 0][409.369 5 1][411.499 6 1]
[413.472 7 1][414.919 7 1][418.624 8 1][422.297 7 1][422.567 7 1]
[426.34 7 1][430.5 7 1][430.91 7 1][434.003 5 1][438.816 7 1]
[446.665 5 1][450.533 6 1][459.565 5 1][460.845 8 1][464.188 10 0]
[464.237 11 0][465.938 5 1][474.091 4 0][474.435 6 0][475.393 5 0]
[475.739 7 0][478.649 5 0][479.105 7 0][479.975 6 0][480.435 8 0]
[482.923 9 1][484.986 7 0][485.609 8 0][486.348 8 0][486.976 9 0]
[494.202 8 0][494.329 6 1][495.082 9 0][495.615 9 0][496.503 10 0]
[500.56 8 1][505.627 7 1][508.423 10 0][509.717 11 0][509.92 11 0]
[511.225 12 0][531.024 5 1][532.328 12 0][533.969 13 0][534.297 12 0]
[535.957 14 0][547.013 6 1][564.273 5 1][577.232 4 1][578.238 16 0]
[580.175 17 0][581.215 15 0][583.189 17 0][596.964 2 1][612.027 8 1]
[624.659 6 1][630.729 7 1][642.796 5 1][659.5 2 1][691.108 19 0]
[693.628 12 0][693.877 20 0][696.418 7 0][696.467 12 0][766.49 25 0]
[769.896 24 0][388.55 1 2]]
25} bind def
%
/wl@elt@Ca {[
[387.048 9 0][387.254 11 0][387.256 11 0][387.578 12 0][387.58 12 0]
[388.91 6 0][392.348 6 0][393.366 230 1][393.529 9 0][394.604 6 0]
[394.89 15 0][395.705 17 0][396.847 220 1][397.257 8 0][397.371 18 0]
[409.71 50 1][409.853 15 0][409.857 15 0][410.982 60 1][411.028 30 1]
[420.618 40 1][422.007 50 1][422.673 50 0][424.046 15 0][428.301 24 0]
[428.936 22 0][429.899 22 0][430.253 25 0][430.774 23 0][431.865 22 0]
[435.508 20 0][442.544 25 0][443.496 26 0][443.569 25 0][445.478 30 0]
[445.589 28 0][445.661 20 0][447.204 20 1][447.923 10 1][448.918 20 1]
[452.694 23 0][457.855 22 0][458.14 23 0][458.147 23 0][458.587 24 0]
[458.596 24 0][468.527 20 0][471.674 30 1][472.103 40 1][479.997 40 1]
[487.813 25 0][500.148 70 1][501.997 80 1][502.114 40 1][504.162 23 0]
[518.885 25 0][526.171 22 0][526.224 23 0][526.424 22 0][526.556 24 0]
[527.027 25 0][528.527 60 1][530.722 70 1][533.919 50 1][534.947 27 0]
[551.298 23 0][558.197 25 0][558.876 27 0][559.012 24 0][559.447 26 0]
[559.849 25 0][560.129 24 0][560.285 24 0][585.745 30 0][592.272 10 1]
[592.369 10 1][610.272 27 0][612.222 29 0][616.129 22 0][616.217 30 0]
[616.376 22 0][616.644 24 0][616.906 26 0][616.956 28 0][643.907 35 0]
[644.981 30 0][645.56 22 0][645.687 80 1][646.257 34 0][647.166 29 0]
[649.378 32 0][649.965 28 0][657.278 23 0][671.769 30 0][714.815 33 0]
[720.219 31 0][732.615 33 0][757.581 30 1][758.111 60 1][760.13 80 1]
[760.232 20 1][408.177 15 2][415.357 15 2][416.431 15 2][418.42 15 2]
[420.724 18 2][423.374 17 2][424.074 16 2][428.439 15 2][430.281 20 2]
[432.919 15 2][433.357 16 2][435.838 15 2][439.959 19 2][440.629 17 2]
[443.13 17 2][449.988 19 2][451.659 18 2][457.212 18 2][470.883 11 2]
[471.627 11 2][485.917 10 2][500.895 10 2][505.007 10 2][523.182 10 2]
[524.737 11 2][527.198 13 2][530.132 10 2][532.129 11 2][532.806 10 2]
[557.058 11 2][557.906 10 2][606.998 13 2][617.322 10 2][621.398 12 2]
[629.489 11 2][637.011 11 2][638.755 10 2][642.451 12 2][648.535 12 2]
[653.878 10 2][654.224 10 2][730.869 10 2]]
230} bind def
%
/wl@elt@Sc {[
[383.307 270 1][384.303 610 1][389.497 90 0][390.749 20000 0][391.181 23000 0]
[392.351 45 1][393.338 4400 0][395.227 45 0][398.906 45 1][399.661 5500 0]
[401.449 530 1][402.04 20000 0][402.369 20000 0][403.067 220 0][403.139 140 0]
[403.423 100 0][404.38 220 0][404.648 200 0][404.779 2700 0][404.995 120 0]
[405.455 5500 0][405.659 220 0][407.497 160 0][407.857 160 0][408.24 6100 0]
[408.667 200 0][408.716 400 0][409.313 40 0][409.485 65 0][409.835 55 0]
[410.033 65 0][413.3 440 0][414.03 530 0][414.74 65 0][415.236 720 0]
[415.472 55 -1][416.188 90 0][416.519 1100 0][417.156 65 0][418.645 45 0]
[418.762 65 0][420.52 75 0][421.234 65 0][421.249 45 0][421.61 75 0]
[421.826 110 0][421.973 110 0][422.188 40 0][422.559 90 0][423.193 180 0]
[423.361 200 0][423.782 100 0][423.805 400 0][423.957 90 0][424.612 100 0]
[424.683 15000 1][428.356 55 -1][429.477 290 1][430.571 350 1][431.409 4200 1]
[432.074 3300 1][432.501 2400 1][434.853 28 0][435.461 180 1][435.864 110 0]
[435.908 55 0][436.492 28 0][437.446 2000 1][438.481 130 1][438.96 45 0]
[440.037 1100 1][441.556 880 1][442.066 28 1][443.136 45 1][454.255 65 0]
[454.468 90 0][455.724 120 0][457.399 160 0][459.294 65 0][459.845 65 0]
[460.472 55 0][460.953 45 0][460.995 45 0][467.04 350 1][468.049 40 0]
[469.829 50 1][470.697 120 0][470.934 120 0][472.877 200 0][472.923 490 0]
[473.23 40 0][473.41 590 0][473.508 60 -1][473.765 690 0][474.102 790 0]
[474.381 1200 0][475.316 200 0][477.935 220 0][479.15 90 0][482.728 100 0]
[483.367 100 0][483.944 170 0][484.047 40 0][484.768 80 0][485.268 80 0]
[485.779 140 -1][490.667 80 0][490.976 90 0][492.284 90 0][493.425 90 0]
[493.574 45 0][494.133 70 0][495.406 170 0][497.366 120 0][498.037 150 0]
[498.345 80 0][499.192 140 0][501.839 80 0][502.014 70 0][502.151 80 0]
[503.102 530 1][503.274 55 0][506.432 250 0][506.886 80 0][507.023 530 0]
[507.581 250 0][508.156 2100 0][508.372 1200 0][508.555 1100 0][508.695 750 0]
[508.714 390 0][508.989 270 0][509.246 45 0][509.673 390 0][509.923 620 0]
[510.112 370 0][510.906 180 0][511.286 150 0][511.669 320 0][513.368 70 -1]
[517.106 45 -1][521.052 390 0][521.128 45 0][521.967 280 0][523.982 350 1]
[525.833 280 0][528.497 35 0][528.576 210 0][530.194 35 0][531.835 22 1]
[533.177 70 0][533.423 14 1][533.941 95 0][534.105 120 0][534.296 95 0]
[534.93 350 0][534.971 120 0][535.03 60 0][535.575 210 0][535.61 530 0]
[535.719 14 1][537.535 270 0][539.208 370 0][541.612 45 0][542.557 45 0]
[542.941 45 0][543.294 35 0][543.323 55 0][543.822 45 0][543.903 55 0]
[544.26 55 0][544.62 270 0][544.739 18 0][545.134 120 0][545.521 30 0]
[546.52 18 0][546.84 55 0][547.219 60 0][547.464 18 0][548.199 750 0]
[548.462 530 0][551.422 570 0][551.539 16 0][552.05 660 0][552.606 45 0]
[552.682 660 1][554.104 55 0][554.64 30 0][555.04 18 0][555.225 5 1]
[555.359 35 0][556.11 16 0][556.486 70 0][557.124 18 0][557.976 14 0]
[559.133 110 0][559.338 35 0][560.419 22 0][563.102 22 0][564.098 80 1]
[564.636 45 0][564.76 16 0][564.956 55 0][565.788 250 1][565.834 60 1]
[566.716 55 1][566.904 70 1][567.181 1500 0][568.42 95 1][568.684 1200 0]
[570.021 1100 0][570.861 190 0][571.175 880 0][571.728 230 0][572.408 180 0]
[573.685 55 -1][576.445 55 -1][577.274 95 -1][577.532 55 -1][580.984 70 -1]
[581.16 70 -1][584.773 95 -1][584.907 70 -1][588.738 70 -1][591.804 35 -1]
[591.911 30 0][592.81 60 -1][596.149 35 0][596.825 60 -1][596.919 35 0]
[598.842 90 0][601.707 160 -1][602.618 60 0][603.617 620 -1][606.431 490 -1]
[607.265 440 -1][607.93 620 -1][610.187 320 -1][610.993 370 -1][611.597 370 -1]
[614.87 180 -1][615.393 150 -1][618.809 150 -1][619.29 150 -1][621.068 620 0]
[623.941 90 0][623.978 320 0][624.563 120 1][624.996 110 0][625.896 250 0]
[626.225 60 0][627.631 55 0][627.976 45 1][630.07 18 1][630.567 750 0]
[630.99 26 1][632.085 16 1][634.483 26 0][637.882 60 0][640.841 55 -1]
[641.335 90 0][643.708 26 -1][644.624 55 -1][645.778 26 -1][648.54 35 -1]
[649.59 26 -1][652.562 55 -1][653.53 22 -1][655.784 45 -1][656.688 35 -1]
[657.585 18 -1][660.46 60 1][660.999 26 -1][661.794 18 -1][664.508 18 -1]
[665.442 22 -1][666.101 26 -1][670.048 18 -1][670.593 18 -1][673.787 65 0]
[673.94 35 0][681.708 35 0][681.952 50 0][682.954 29 0][683.503 50 0]
[696.312 5 -1][699.068 5 -1][702.572 5 -1][703.577 8 -1][707.237 5 -1]
[709.438 5 -1][713.814 12 0][716.913 14 0][725.757 12 0][727.557 8 0]
[730.062 3 0][752.413 12 0][755.396 14 0][757.444 15 0][761.745 11 0]
[766.572 14 0][769.773 30 0][772.972 18 0][774.117 55 0][775.037 5 0]
[775.272 5 0][777.106 6 0][778.517 15 0][779.468 8 0][406.121 80 2]
[406.866 100 2][430.947 40 2][474.095 10 2][478.087 15 2][499.289 50 2]
[503.209 60 2][625.601 80 2][630.76 60 2][744.916 90 2][754.815 70 2]
[459.442 8 3][463.996 8 3][550.174 8 3][562.072 9 3][570.682 10 3]
[577.163 14 3][654.803 9 3]]
23000} bind def
%
/wl@elt@Ti {[
[381.822 70 0][382.203 60 0][382.819 240 0][383.368 95 0][383.678 95 0]
[384.645 60 0][385.305 130 0][385.373 130 0][385.814 170 0][386.644 240 0]
[386.84 170 0][387.321 120 0][387.526 260 0][388.215 170 0][388.233 170 0]
[388.289 500 0][388.802 60 0][388.995 70 0][389.525 200 0][389.849 85 0]
[390.054 530 1][390.096 180 0][390.478 2600 0][391.119 110 0][391.346 500 1]
[391.434 500 0][391.474 24 0][391.982 35 0][392.142 290 0][392.453 1100 0]
[392.632 110 0][392.988 890 0][393.202 35 1][393.424 70 0][394.778 1100 0]
[394.867 4500 0][395.634 4500 0][395.821 5200 0][396.285 950 0][396.427 950 0]
[398.176 4800 0][398.248 570 0][398.433 60 0][398.525 35 0][398.559 60 0]
[398.976 5700 0][399.47 35 0][399.864 7800 0][399.936 70 0][400.249 70 0]
[400.381 70 0][400.597 35 0][400.806 70 0][400.893 950 0][400.966 190 0]
[401.239 70 1][401.358 180 0][401.538 70 0][401.628 35 0][401.777 120 0]
[402.183 140 0][402.457 1200 0][402.514 40 1][402.654 190 0][402.748 40 0]
[402.834 40 1][403.051 190 0][403.391 40 0][403.491 30 0][403.583 110 0]
[404.032 35 0][405.502 290 0][405.762 85 0][405.814 85 0][406.026 410 0]
[406.422 200 0][406.51 200 0][407.847 840 0][407.972 40 0][408.246 290 0]
[409.917 85 0][411.271 220 0][412.217 85 0][412.331 40 0][412.357 85 0]
[412.754 130 0][412.917 40 0][413.125 40 0][413.729 140 0][414.305 85 0]
[415.096 170 0][415.964 85 0][416.365 70 1][416.414 35 0][416.632 40 0]
[416.935 85 0][417.103 120 0][417.19 40 1][418.33 35 0][418.612 360 0]
[418.869 40 0][420.075 70 0][420.346 85 0][421.173 35 0][422.479 40 0]
[422.765 40 0][423.789 130 0][424.912 85 0][425.604 130 0][425.854 70 0]
[426.16 70 0][426.313 330 0][426.571 35 0][426.622 40 0][427.014 70 0]
[427.243 85 0][427.458 240 0][427.643 120 0][427.823 120 0][427.881 30 0]
[428.138 110 0][428.271 220 0][428.499 160 0][428.601 890 0][428.74 840 0]
[428.816 30 0][428.907 950 0][429.023 120 1][429.094 840 0][429.114 120 0]
[429.412 140 1][429.576 840 0][429.866 2000 0][429.923 200 0][429.964 200 0]
[430.005 200 1][430.056 2900 0][430.109 4100 0][430.193 85 1][430.592 6000 0]
[430.79 180 1][430.85 35 0][431.165 40 0][431.287 85 1][431.435 85 0]
[431.48 1200 0][431.864 360 0][432.166 180 0][432.513 190 0][432.636 160 0]
[433.484 30 0][433.792 160 1][434.429 24 1][434.611 70 0][435.406 35 0]
[436.049 95 0][436.894 24 0][436.968 95 0][437.238 60 0][438.808 30 0]
[439.392 170 0][439.504 330 1][439.977 60 1][440.428 240 0][440.49 60 0]
[440.568 30 0][441.654 60 0][441.728 220 0][441.772 60 1][442.176 120 0]
[442.282 120 0][442.439 24 0][442.583 30 0][442.606 120 0][442.71 890 0]
[443.002 21 0][443.037 85 0][443.128 50 0][443.26 30 0][443.358 24 0]
[443.4 170 0][443.659 70 0][443.823 30 0][444.035 130 0][444.127 50 0]
[444.38 230 1][444.427 24 0][444.915 840 0][445.049 30 1][445.09 550 0]
[445.332 840 0][445.371 290 0][445.533 950 0][445.743 1100 0][446.209 21 0]
[446.338 70 0][446.354 95 0][446.581 290 0][446.85 240 1][447.124 240 0]
[447.485 95 0][447.97 95 0][448.059 50 0][448.126 530 0][448.269 95 0]
[448.832 19 1][448.909 260 0][449.255 24 0][449.501 40 0][449.615 240 0]
[449.773 24 0][450.127 200 1][450.378 40 0][450.636 21 0][451.117 50 0]
[451.274 780 0][451.562 19 0][451.803 1000 0][451.87 95 0][452.28 1000 0]
[452.731 780 0][453.324 6000 0][453.397 240 1][453.478 3600 0][453.558 2400 0]
[453.592 1200 0][453.605 1200 0][453.723 24 0][453.91 24 0][454.469 720 0]
[454.877 950 0][454.963 240 1][455.246 950 0][455.508 24 0][455.549 720 0]
[455.786 19 0][455.811 19 0][455.992 60 0][456.263 50 0][456.343 35 0]
[456.377 110 1][457.091 35 0][457.198 240 1][458.584 19 -1][458.995 24 1]
[459.923 60 0][460.937 21 0][461.727 950 0][461.952 24 0][462.309 480 0]
[462.934 190 0][463.487 50 -1][463.788 60 0][463.937 240 0][463.967 220 0]
[463.995 190 0][464.519 140 0][465.002 120 0][465.604 24 0][465.647 720 0]
[466.759 840 0][467.512 70 0][468.192 950 0][468.692 21 0][469.08 24 0]
[469.134 190 0][469.368 40 0][469.694 24 0][469.876 190 0][471.019 120 0]
[471.53 24 0][472.262 65 0][472.317 65 0][473.117 55 0][473.343 45 0]
[473.468 18 0][474.211 22 0][474.279 170 0][474.768 22 0][475.812 310 0]
[475.928 310 0][476.633 45 0][476.977 28 0][477.826 65 0][478.172 45 0]
[479.249 110 0][479.622 45 0][479.798 35 0][479.98 110 0][480.51 28 1]
[480.543 110 0][480.853 45 0][481.108 22 0][481.225 40 0][482.042 200 0]
[482.546 22 0][483.613 40 0][484.087 470 0][484.847 65 0][485.601 290 0]
[486.418 35 0][486.826 200 0][487.014 250 0][488.091 28 0][488.235 45 0]
[488.508 400 0][489.991 380 0][491.362 320 0][491.524 55 0][491.987 130 0]
[492.177 180 0][492.541 55 0][492.616 30 0][492.834 150 0][493.774 30 0]
[493.829 95 0][494.158 30 0][494.819 21 0][495.825 21 0][496.475 55 0]
[496.604 21 0][496.858 65 0][497.305 75 0][497.535 120 0][497.774 65 0]
[497.82 120 0][498.173 5800 0][498.915 150 0][499.107 4600 0][499.508 30 0]
[499.71 140 0][499.951 4000 0][500.101 230 0][500.721 3600 0][500.965 120 0]
[501.33 230 0][501.419 3200 0][501.617 580 0][502.003 840 0][502.287 840 0]
[502.484 580 0][502.558 300 0][503.591 1200 0][503.647 840 0][503.84 740 0]
[503.995 1200 0][504.062 75 0][504.359 85 0][504.427 35 0][504.541 55 0]
[504.821 26 0][505.287 110 0][505.408 21 0][506.211 110 0][506.407 35 0]
[506.466 1400 0][506.599 95 0][506.833 35 0][506.935 65 0][507.148 130 0]
[508.534 40 0][508.707 130 0][510.315 21 0][510.944 55 0][511.344 190 0]
[512.042 270 0][512.915 30 1][514.547 270 0][514.748 230 0][515.22 210 0]
[516.686 21 -1][517.375 1100 0][518.634 40 0][518.87 85 1][518.958 30 0]
[519.298 1300 0][519.404 85 0][520.11 65 0][520.608 120 0][520.787 75 0]
[520.842 65 -1][521.039 1400 0][521.229 65 0][521.971 150 0][522.269 95 0]
[522.364 85 0][522.432 250 0][522.456 95 0][522.495 190 0][522.656 65 1]
[523.858 120 0][524.615 21 0][524.657 55 0][524.731 75 0][525.095 21 0]
[525.211 110 0][525.583 75 0][525.999 55 0][526.35 55 0][526.598 150 0]
[528.239 40 0][528.345 140 0][528.439 35 0][528.881 26 -1][529.579 65 0]
[529.726 120 0][529.844 65 0][533.681 26 1][534.15 17 0][535.108 75 0]
[536.665 26 0][536.964 55 0][538.918 40 0][538.999 55 0][539.66 17 0]
[539.709 85 0][540.402 35 0][540.961 110 0][542.626 40 0][542.915 75 0]
[543.673 26 0][543.832 17 0][544.664 40 0][544.834 11 -1][544.89 30 0]
[544.916 21 0][545.365 35 0][546.051 55 0][547.121 75 0][547.27 35 0]
[547.355 40 0][547.423 85 0][547.446 30 0][547.771 120 0][548.143 110 0]
[548.187 75 0][548.82 85 0][549.015 150 0][549.084 26 0][550.39 110 0]
[551.178 40 0][551.253 340 0][551.435 270 0][551.454 320 0][553.049 26 -1]
[556.549 110 0][557.916 13 -1][558.298 21 -1][558.568 30 -1][559.785 65 -1]
[562.928 55 -1][563.584 17 -1][564.414 250 0][564.858 75 0][566.155 26 -1]
[566.216 190 0][566.291 75 0][567.342 21 0][567.544 130 0][567.994 30 0]
[568.947 95 0][570.268 75 0][570.823 35 0][571.188 65 0][571.392 40 0]
[571.513 95 0][571.648 55 0][572.048 35 0][573.951 85 0][574.002 40 0]
[574.122 19 0][575.284 21 0][575.686 19 0][576.227 40 0][576.635 55 0]
[577.405 75 0][578.078 30 0][578.598 75 0][580.426 65 0][581.496 21 -1]
[582.371 40 0][584.118 21 -1][585.234 21 -1][586.646 400 0][588.031 65 0]
[588.868 21 -1][589.932 230 0][590.333 55 0][591.855 120 0][592.212 150 0]
[593.782 75 0][594.176 120 0][595.317 300 0][596.584 200 0][597.856 270 0]
[599.904 340 0][599.968 65 0][601.273 21 -1][606.463 110 0][608.523 120 0]
[609.117 120 0][609.281 40 0][609.867 40 0][612.101 35 0][612.622 120 0]
[613.838 19 0][614.622 30 0][614.974 21 0][616.223 30 -1][618.615 35 0]
[621.528 95 0][622.049 75 0][622.141 65 0][625.81 380 0][625.87 380 0]
[626.11 300 0][630.375 65 0][631.224 55 0][631.803 26 0][633.61 30 0]
[636.635 35 0][641.91 11 0][649.769 17 0][650.814 19 0][654.628 55 0]
[655.423 65 0][655.483 11 -1][655.607 75 0][656.562 19 0][657.518 14 0]
[659.911 35 0][665.146 18 -1][666.655 18 0][666.774 22 -1][666.839 9 -1]
[667.718 18 0][669.121 22 -1][671.668 26 0][672.395 16 -1][674.312 80 0]
[674.552 22 0][684.464 18 -1][686.039 18 -1][686.147 35 0][687.392 9 0]
[691.319 12 0][693.315 14 0][694.37 14 0][699.663 23 0][700.466 15 0]
[700.835 14 0][701.094 14 0][703.586 14 0][703.88 40 0][705.065 14 0]
[705.451 40 -1][706.911 23 0][707.205 23 -1][708.789 45 -1][712.49 30 -1]
[712.561 40 -1][713.891 26 0][716.713 26 -1][717.153 23 -1][718.989 55 0]
[720.364 26 -1][720.944 260 0][721.62 60 0][724.486 130 0][725.172 130 0]
[726.34 19 -1][726.629 19 0][726.905 19 -1][731.556 15 0][731.839 26 0]
[734.472 120 0][735.216 11 0][735.774 90 0][736.411 60 0][744.06 26 0]
[747.494 9 0][748.961 26 0][749.612 19 0][758.055 12 0][758.962 9 -1]
[761.45 15 0][765.444 23 0][770.521 11 -1][387.25 12 2][388.121 12 2]
[389.363 12 2][389.633 10 2][391.547 15 2][392.138 12 2][392.161 10 2]
[392.295 12 2][392.486 10 2][406.021 10 2][411.914 10 2][421.552 11 2]
[426.984 11 2][429.67 11 2][434.804 10 2][443.391 11 2][454.022 10 2]
[454.984 15 2][455.546 10 2][457.22 15 2][464.945 10 2][465.286 12 2]
[487.4 10 2][495.01 10 2][497.119 10 2][508.38 10 2][514.731 14 2]
[522.628 12 2][524.749 11 2][527.812 17 2][527.87 10 2][529.843 12 2]
[530.12 16 2][530.688 15 2][539.569 10 2][553.301 12 2][581.744 10 2]
[661.138 12 2][662.158 18 2][662.937 10 2][664.747 14 2][666.799 18 2]
[667.419 15 2][670.776 14 2][672.48 12 2][673.41 16 2][686.226 15 2]
[687.435 12 2][689.612 10 2][701.538 12 2][707.193 10 2][707.264 20 2]
[708.457 18 2][712.413 15 2][717.179 11 2][717.592 10 2][721.75 10 2]
[722.555 9 2][727.067 12 2][731.63 14 2][731.668 10 2][737.996 12 2]
[740.813 10 2][745.785 10 2][750.687 15 2][750.768 17 2][752.385 10 2]
[754.429 12 2][756.625 9 2][413.122 13 3][413.378 14 3][439.733 10 3]
[440.345 9 3][461.811 15 3][539.893 20 3][547.098 8 3][549.251 18 3]
[551.772 10 3][587.779 14 3][588.596 15 3][589.115 7 3][623.162 6 3]
[624.665 17 3][624.774 11 3][629.241 15 3][691.385 12 3][697.851 15 3]
[749.137 9 3][749.477 8 3][765.212 5 3][770.685 8 3]]
7800} bind def
%
/wl@elt@V {[
[380.347 570 0][380.68 190 0][380.75 300 0][380.852 520 0][380.96 230 0]
[381.349 1000 0][381.784 140 0][381.824 1300 0][381.996 230 0][382.149 230 0]
[382.201 570 0][382.289 450 0][382.321 300 0][382.856 1700 0][383.422 280 0]
[383.9 160 0][383.938 110 0][384.044 570 0][384.075 2600 0][384.189 110 0]
[384.444 380 0][384.733 320 0][384.932 110 0][385.537 1200 0][385.584 3000 0]
[386.222 150 0][386.387 130 0][386.486 1300 0][386.76 230 0][387.108 170 0]
[387.508 1500 0][387.59 420 0][387.609 570 0][387.871 130 1][389.018 700 0]
[389.286 460 0][389.802 280 0][389.913 140 1][390.018 140 0][390.115 140 0]
[390.225 2400 0][390.675 100 0][390.989 700 0][391.079 100 0][391.221 220 0]
[391.433 140 1][391.641 100 1][392.049 100 0][392.19 100 0][392.243 230 0]
[392.466 240 0][392.524 150 0][392.793 200 0][393.002 260 0][393.134 150 0]
[393.401 260 0][393.514 150 0][393.628 100 0][394.366 150 0][395.023 100 0]
[395.197 140 1][397.364 100 1][399.057 540 0][399.28 260 0][399.873 430 0]
[400.571 170 1][402.339 120 1][403.183 120 0][403.563 150 1][404.264 120 0]
[405.096 360 0][405.135 360 0][405.707 280 0][405.782 130 0][406.393 230 0]
[407.154 230 0][409.058 1100 0][409.241 180 0][409.269 1800 0][409.35 120 0]
[409.549 890 0][409.98 2800 0][410.216 590 0][410.44 230 0][410.478 260 0]
[410.517 2800 0][410.822 120 0][410.979 2300 0][411.178 8900 0][411.233 120 0]
[411.352 230 0][411.518 4300 0][411.647 1800 0][411.818 180 0][411.864 180 0]
[411.946 230 0][412.054 180 0][412.319 180 0][412.357 2000 0][412.407 120 0]
[412.807 3100 0][412.886 120 0][413.202 3100 0][413.449 2300 0][415.969 150 0]
[417.401 100 0][417.942 230 0][418.259 150 0][418.984 180 0][419.156 180 0]
[420.986 230 0][422.662 120 0][423.246 360 0][423.295 180 0][423.4 180 0]
[423.576 120 0][425.737 100 0][425.931 120 0][426.216 120 0][426.864 560 0]
[427.155 460 0][427.696 460 0][428.406 430 0][429.182 330 0][429.611 220 0]
[429.768 170 0][429.803 170 0][430.621 170 0][430.718 140 0][430.98 170 0]
[433.002 460 0][433.282 510 0][434.101 760 0][435.287 1000 0][435.498 130 0]
[435.594 150 0][436.804 150 0][437.323 140 0][437.53 100 0][437.924 12000 0]
[438.055 100 0][438.472 7000 0][438.997 4800 0][439.523 3600 0][440.058 1400 0]
[440.664 2300 0][440.764 2800 0][440.82 3600 0][440.851 4600 0][441.214 140 0]
[441.647 640 0][441.994 120 0][442.157 640 0][442.6 460 0][442.731 120 0]
[442.852 310 0][442.98 230 0][443.614 430 0][443.784 640 0][444.168 830 0]
[444.421 640 0][445.201 610 0][445.748 410 0][445.776 120 0][445.976 1000 0]
[446.029 2000 0][446.236 610 0][446.801 120 0][446.971 380 0][447.404 120 0]
[447.471 200 0][448.889 380 0][449.606 100 0][450.195 120 0][452.422 140 0]
[454.539 360 0][454.965 100 0][456.071 280 0][457.178 200 0][457.717 510 0]
[457.873 140 0][458.04 640 0][458.636 830 0][459.122 170 0][459.411 1300 0]
[460.615 100 0][460.965 30 0][461.174 25 0][461.977 230 0][462.441 65 0]
[462.648 50 0][463.518 100 0][464.007 65 0][464.074 65 0][464.64 130 0]
[464.889 30 0][466.614 30 0][467.049 160 0][468.445 24 0][468.692 35 0]
[470.616 55 0][470.657 80 0][471.056 80 0][471.412 65 0][471.589 35 0]
[471.769 55 0][472.151 40 0][472.286 40 0][472.953 40 0][473.038 27 0]
[474.263 27 0][474.663 24 0][474.852 40 0][475.098 45 0][475.156 35 0]
[475.393 40 0][475.748 65 0][476.663 55 0][477.636 130 0][478.651 110 0]
[479.692 130 0][479.977 19 0][480.753 130 0][482.745 130 0][483.164 150 0]
[483.243 120 0][483.302 19 0][484.881 19 0][485.148 320 0][486.261 35 0]
[486.474 480 0][487.126 21 0][487.548 620 0][488.056 55 0][488.156 740 0]
[489.16 27 0][489.421 21 0][490.062 55 0][490.429 95 0][492.565 85 0]
[493.203 35 0][496.612 23 0][500.233 70 0][501.462 85 0][505.163 28 0]
[506.412 35 0][510.514 35 0][512.853 110 0][513.842 110 0][513.953 25 0]
[514.872 70 0][515.935 40 0][516.994 23 0][517.677 70 0][519.201 20 0]
[519.299 110 0][519.362 23 0][519.483 110 0][519.536 55 0][520.661 20 0]
[521.659 40 0][522.577 35 0][523.375 35 0][523.407 110 0][524.02 20 0]
[524.087 110 0][526.098 17 0][535.341 40 0][538.343 35 0][538.514 40 0]
[538.83 14 0][539.787 11 0][540.193 100 0][541.526 140 0][541.809 28 0]
[542.408 50 0][543.418 40 0][543.766 11 0][545.812 17 0][547.133 13 -1]
[548.722 25 0][548.792 85 0][548.994 25 0][550.487 28 0][550.775 70 0]
[551.118 14 0][554.593 23 0][554.707 70 0][555.875 35 0][556.166 28 0]
[558.45 140 0][558.6 23 0][559.242 100 0][560.138 28 0][560.494 70 0]
[562.42 13 0][562.46 200 0][562.489 70 0][562.601 55 0][562.764 400 0]
[563.246 13 0][563.39 10 0][563.551 13 0][564.611 85 0][565.744 110 0]
[566.836 110 0][567.085 310 0][568.322 20 0][569.852 1200 0][570.356 920 0]
[570.698 570 0][570.895 11 0][571.621 11 0][572.564 70 0][572.703 850 0]
[572.766 170 0][573.125 230 0][573.401 40 0][573.706 230 0][574.345 110 0]
[574.77 17 0][574.887 40 0][575.274 17 0][576.141 17 0][577.242 70 0]
[577.664 35 0][578.261 11 0][578.35 11 0][578.438 40 0][578.616 55 0]
[578.856 23 0][580.714 35 0][581.706 23 0][581.753 35 0][583.072 55 0]
[584.63 85 0][585.032 11 0][592.457 40 0][597.891 28 0][598.078 20 0]
[600.231 28 0][600.263 55 0][601.612 28 0][602.541 20 0][603.973 450 0]
[605.814 100 0][606.726 20 0][608.144 480 0][609.022 1300 0][610.698 28 0]
[611.167 280 0][611.952 600 0][612.834 20 0][613.538 280 0][615.015 180 0]
[617.036 85 0][618.935 23 0][619.919 450 0][621.387 130 0][621.637 450 0]
[621.831 28 0][622.45 130 0][623.074 430 0][623.32 100 0][624.013 55 0]
[624.281 170 0][624.31 710 0][625.182 280 0][625.69 85 0][625.857 85 0]
[626.122 55 0][626.632 85 0][626.882 130 0][627.465 170 0][628.233 17 0]
[628.516 200 0][629.283 200 0][629.649 170 0][631.15 28 0][632.466 14 0]
[632.684 70 0][633.909 55 0][634.948 50 0][635.558 14 0][635.73 50 0]
[635.882 25 0][636.127 35 0][637.936 23 0][639.328 14 0][643.047 35 0]
[643.163 23 0][643.318 14 0][643.516 11 0][645.234 70 0][648.805 11 0]
[650.417 55 0][653.143 110 0][654.351 28 0][655.802 17 0][656.588 11 0]
[660.597 50 0][660.783 15 0][662.354 10 0][662.485 50 0][663.326 13 0]
[664.379 13 0][669.366 8 0][670.807 8 0][675.3 65 0][676.012 10 0]
[676.649 50 0][678.498 40 0][678.632 15 0][681.24 26 0][682.994 9 0]
[683.244 15 0][683.958 12 0][684.19 12 0][687.088 10 0][687.156 8 0]
[689.4 7 0][697.45 12 0][702.607 21 0][706.369 7 0][709.208 11 0]
[710.258 6 0][714.815 24 0][715.136 7 0][718.208 7 0][726.429 14 0]
[732.144 8 0][733.892 40 0][735.654 35 0][735.866 11 0][736.139 24 0]
[736.249 12 0][736.316 24 0][738.595 9 0][739.349 6 -1][748.59 12 0]
[748.808 12 0][749.244 12 -1][757.875 12 0][759.124 9 0][759.692 14 0]
[759.828 12 0][762.481 24 0][770.137 5 0][770.481 8 0][471.489 40 2]
[659.72 50 2][498.565 50 3][513.078 50 3][526.216 50 3][535.232 60 3]
[594.012 40 3][420.032 20 4][493.053 15 4][535.607 8 4][662.88 7 4]
[759.551 3 4]]
12000} bind def
%
/wl@elt@Cr {[
[380.48 530 0][380.683 110 0][380.793 110 0][381.543 180 0][381.848 70 0]
[381.956 180 0][382.352 70 0][382.642 130 0][383.003 130 0][384.128 380 0]
[384.898 190 0][384.936 140 0][385.004 290 0][385.222 140 0][385.422 190 0]
[385.529 110 0][385.557 140 0][385.763 260 0][387.453 70 0][388.329 660 0]
[388.366 50 0][388.522 570 0][388.679 380 0][389.193 60 0][389.404 260 0]
[389.765 40 0][390.211 35 0][390.292 360 0][390.316 60 0][390.876 960 0]
[391.182 120 0][391.584 120 0][391.624 190 0][391.76 35 0][391.916 1900 0]
[392.102 600 0][392.665 30 0][392.864 600 0][394.149 410 0][395.11 30 0]
[395.24 40 0][395.316 35 0][396.369 1900 0][396.906 120 0][396.975 1600 0]
[397.126 85 0][397.666 1600 0][397.868 85 0][397.98 40 0][398.123 85 0]
[398.391 960 0][398.434 190 0][398.999 160 0][399.112 960 0][399.167 160 0]
[399.284 190 0][399.397 40 0][400.144 160 0][401.247 120 1][401.467 30 0]
[402.226 85 0][402.501 70 0][402.617 120 0][402.71 85 0][403.068 85 0]
[403.91 190 0][404.878 160 0][405.877 120 0][406.572 40 0][406.694 85 0]
[407.486 35 0][407.606 40 0][407.709 40 0][407.768 40 0][410.487 40 0]
[410.958 40 0][412.061 40 0][412.182 40 0][412.216 35 0][412.339 40 0]
[412.652 140 0][412.73 35 0][412.764 40 0][413.136 40 0][415.278 30 0]
[415.382 120 0][416.142 85 0][416.362 140 0][416.552 70 0][416.984 40 0]
[417.02 35 0][417.277 40 0][417.48 170 0][417.594 30 0][417.926 170 0]
[418.49 35 0][418.636 30 0][419.013 35 0][419.127 85 0][419.21 35 0]
[419.366 85 0][419.495 70 0][419.723 40 0][419.852 85 0][420.359 60 0]
[420.447 40 0][420.836 35 0][420.937 110 0][420.976 40 0][421.135 40 0]
[421.636 40 0][421.763 85 0][422.157 40 0][422.273 40 0][423.896 40 0]
[424.07 60 0][425.435 20000 0][425.55 70 0][426.135 60 0][426.314 110 0]
[427.106 30 0][427.291 40 0][427.48 16000 0][428.04 85 0][428.972 10000 0]
[429.196 40 0][429.576 85 0][429.774 70 0][430.051 35 0][430.118 50 0]
[430.545 30 0][431.964 35 0][432.508 60 0][433.757 780 0][433.945 1100 0]
[433.972 380 0][434.013 60 0][434.451 1900 0][434.683 70 0][435.105 380 0]
[435.177 2300 0][435.963 570 0][436.313 70 0][437.128 530 0][437.325 70 0]
[437.416 110 0][437.533 70 0][438.111 50 0][438.498 530 0][438.75 60 0]
[439.175 70 0][440.35 60 0][441.03 24 0][441.109 60 0][441.225 35 0]
[441.387 50 0][442.428 60 0][442.85 24 0][443.049 50 0][443.218 50 0]
[445.854 110 0][445.974 30 0][446.536 30 0][448.288 30 0][448.805 40 0]
[448.947 50 0][449.231 60 0][449.686 660 0][449.873 50 0][450.03 70 0]
[450.111 50 0][450.179 22 0][450.685 24 0][451.19 95 0][451.437 12 0]
[451.453 35 0][452.114 24 0][452.611 24 0][452.647 380 0][452.734 70 0]
[452.985 24 0][453.074 380 0][453.515 50 0][453.572 240 0][453.979 40 0]
[454.05 240 0][454.072 240 0][454.107 35 0][454.151 19 0][454.262 24 0]
[454.462 140 0][454.534 24 0][454.596 600 0][455.617 50 0][455.866 22 1]
[456.417 19 0][456.551 120 0][456.964 95 0][457.168 120 0][457.512 22 0]
[458.006 360 0][458.614 24 0][459.139 360 0][459.559 70 0][460.01 50 0]
[460.075 480 0][460.102 50 0][461.337 240 0][461.614 600 0][461.955 70 0]
[462.196 85 0][462.249 70 0][462.276 24 0][462.619 550 0][463.218 24 0]
[463.718 40 0][463.777 50 0][463.952 50 0][464.617 1600 0][464.681 24 0]
[464.813 24 0][464.887 24 0][464.946 35 0][465.128 570 0][465.216 840 0]
[465.474 35 0][465.619 19 0][466.333 40 0][466.383 70 0][466.48 95 0]
[466.59 35 0][466.622 22 0][466.651 70 0][466.934 50 0][468.054 40 0]
[468.087 19 0][468.937 70 0][469.395 60 0][469.515 24 0][469.706 60 0]
[469.846 240 0][470.061 35 0][470.804 190 0][471.843 240 0][472.31 50 0]
[472.442 50 0][472.715 50 0][472.972 24 0][473.071 120 0][473.735 140 0]
[474.531 19 0][475.208 70 0][475.611 340 0][476.429 50 0][476.663 22 0]
[476.786 30 0][478.932 190 0][479.251 95 0][480.103 120 0][482.938 110 0]
[483.686 14 0][486.12 17 0][486.184 70 0][487.08 140 0][488.578 35 0]
[488.596 19 0][488.701 130 0][488.853 19 0][490.324 35 0][492.227 260 0]
[493.633 110 0][494.25 70 0][495.481 110 0][496.493 35 0][501.332 60 0]
[505.19 17 0][506.591 17 0][506.771 40 0][507.292 40 0][511.075 30 0]
[511.313 17 0][512.346 17 0][513.965 50 0][514.467 14 0][516.623 70 0]
[517.743 35 0][518.459 70 0][519.2 70 0][519.349 12 0][519.644 85 0]
[520.019 35 0][520.452 5300 0][520.604 8400 0][520.844 11000 0][521.413 19 0]
[522.175 30 0][522.494 85 0][522.689 12 0][523.897 19 0][524.34 30 0]
[524.756 290 0][525.492 60 0][525.513 60 0][526.175 19 0][526.415 530 0]
[526.516 30 0][526.572 180 0][527.201 35 0][527.344 30 0][527.517 95 0]
[527.569 35 0][527.603 70 0][528.029 19 0][528.719 10 0][529.669 340 0]
[529.736 70 0][529.827 660 0][530.075 85 0][530.421 17 0][531.288 24 0]
[531.878 24 0][532.834 340 0][532.917 70 0][532.972 17 0][534.044 14 0]
[534.476 10 0][534.581 780 0][534.832 380 0][538.698 30 0][538.757 22 0]
[539.039 10 0][540.061 40 0][540.5 22 0][540.979 1400 0][544.241 12 0]
[546.397 19 0][548.05 19 0][562.864 24 0][564.236 7 0][564.937 12 0]
[566.404 24 0][568.12 7 0][568.248 7 0][569.473 24 0][569.833 40 0]
[570.231 24 0][571.264 12 0][571.278 24 0][571.982 7 0][574.643 7 0]
[575.369 7 0][578.12 12 0][578.181 6 0][578.311 24 0][578.393 30 0]
[578.5 24 0][578.582 19 0][578.799 60 0][579.1 180 0][633.01 35 0]
[636.287 22 0][666.108 19 0][666.926 11 0][688.162 5 0][688.238 10 0]
[688.303 21 0][692.413 27 0][692.52 17 0][697.848 30 0][697.982 11 0]
[718.552 7 0][723.62 6 0][735.59 85 0][740.021 130 0][746.231 150 0]]
20000} bind def
%
/wl@elt@Mn {[
[380.055 110 0][380.191 55 0][380.672 3200 0][380.959 700 0][381.069 55 0]
[381.675 90 0][382.351 2100 0][382.389 390 0][382.968 200 0][383.386 480 0]
[383.436 1300 0][383.978 350 0][384.108 670 0][384.398 350 0][391.832 65 0]
[392.647 120 0][395.284 65 0][397.589 55 0][397.708 65 0][398.258 130 0]
[398.524 150 0][398.683 190 0][398.71 150 0][401.81 1500 0][402.644 150 0]
[403.076 27000 0][403.307 19000 0][403.449 11000 0][403.573 1500 0][403.873 55 0]
[404.136 5600 0][404.513 210 0][404.876 1100 0][404.9 80 0][405.173 55 0]
[405.247 65 0][405.521 150 0][405.554 1900 0][405.795 210 0][405.893 1100 0]
[405.939 150 0][406.174 730 0][406.353 730 0][406.508 80 0][406.8 80 0]
[407.028 290 0][407.924 730 0][407.942 730 0][408.294 1100 0][408.363 1100 0]
[408.994 65 0][410.536 55 0][411.09 200 0][413.112 150 0][413.504 120 0]
[414.106 80 0][414.753 55 0][414.88 80 0][417.66 150 0][418.999 120 0]
[420.176 65 0][421.175 65 0][423.514 370 0][423.529 510 0][423.972 190 0]
[425.766 290 0][426.592 290 0][428.11 270 0][428.408 65 0][431.255 65 0]
[432.363 50 1][437.495 45 0][438.17 45 0][441.188 55 0][441.488 350 0]
[441.978 55 0][443.635 210 0][445.159 800 0][445.3 160 0][445.501 130 0]
[445.532 160 0][445.582 110 0][445.704 55 0][445.755 210 0][445.826 270 0]
[446.038 55 0][446.108 150 0][446.202 510 0][446.468 290 0][447.014 200 0]
[447.279 130 0][447.94 40 0][449.008 170 0][449.89 240 0][450.222 240 0]
[460.536 80 0][462.654 80 0][467.169 35 0][470.116 50 0][470.972 160 0]
[472.748 180 0][473.911 130 0][475.404 1000 0][476.153 180 0][476.238 750 0]
[476.586 300 0][476.643 500 0][478.342 940 0][482.352 1000 0][484.432 25 0]
[496.588 35 0][500.491 19 0][507.479 30 0][511.794 60 0][515.089 50 0]
[519.659 50 0][525.532 85 0][534.106 160 0][534.988 19 0][537.763 95 0]
[539.467 95 0][539.949 50 0][540.742 95 0][541.369 35 0][542.036 85 0]
[543.255 35 0][545.747 12 0][547.064 60 0][548.14 40 0][550.587 30 0]
[551.677 50 0][553.776 40 0][555.198 21 0][556.776 8 0][557.301 7 0]
[557.368 8 0][573.829 7 0][578.019 7 0][581.684 7 0][601.35 140 0]
[601.664 200 0][602.18 290 0][638.467 7 0][644.097 17 0][649.171 24 0]
[694.252 14 0][698.996 12 0][706.984 14 0][718.425 12 0][724.782 10 0]
[728.382 24 0][730.289 35 0][732.651 50 0][768.02 12 0][771.242 10 0]
[776.472 10 0][424.617 100 2][507.92 200 2][510.003 150 2][511.703 100 2]
[525.223 100 2][536.559 100 2][545.407 150 2][547.468 200 2][567.112 100 2]
[594.665 200 2][621.311 100 2][623.121 200 2][623.864 100 2][627.371 100 2]]
27000} bind def
%
/wl@elt@Fe {[
[380.5345 200 0][380.6696 80 0][381.2964 600 0][381.3059 60 0][381.584 1500 0]
[382.0425 2500 0][382.1179 150 0][382.4306 80 0][382.4444 2500 0][382.588 1500 0]
[382.7823 1200 0][383.4222 1000 0][383.9257 120 0][384.0437 500 0][384.1047 800 0]
[384.3256 120 0][384.68 80 0][384.996 200 0][385.0817 120 0][385.6372 2500 0]
[385.9212 150 0][385.9911 10000 0][386.5523 150 0][386.7215 60 0][387.2501 250 0]
[387.3761 150 0][387.8018 250 0][387.8573 2000 0][388.6282 4000 0][388.7048 200 0]
[388.8513 300 0][389.5656 800 0][389.9707 1200 0][390.2945 400 0][390.6479 250 0]
[391.6731 80 0][392.0258 600 0][392.2911 1200 0][392.792 1200 0][393.0296 2000 0]
[394.8774 60 0][394.9953 60 0][395.1164 50 0][395.2601 50 0][395.6454 60 0]
[395.668 250 0][396.6614 60 0][396.9257 100 0][397.7741 80 0][398.1771 40 0]
[398.3956 50 0][399.4114 60 0][399.7392 200 0][399.8053 40 0][400.5241 400 0]
[400.9713 60 0][401.453 80 0][402.1867 100 0][404.0638 50 0][404.5813 4000 0]
[406.3594 1500 0][406.6975 50 0][406.7977 50 0][407.1737 1200 0][407.6629 40 0]
[410.0737 40 0][410.7489 40 0][411.8544 150 0][412.7608 40 0][413.2058 400 0]
[413.4676 80 0][413.6997 40 0][414.3415 200 0][414.3869 800 0][415.3898 40 0]
[415.45 50 0][415.6799 60 0][417.2744 50 0][417.4912 60 0][417.5635 50 0]
[417.7593 50 0][418.1754 120 0][418.4891 50 0][418.7038 120 0][418.7795 120 0]
[419.143 80 0][419.5329 40 0][419.8304 150 0][419.9095 40 0][420.2029 300 0]
[420.3984 40 0][420.6696 80 0][421.0343 80 0][421.6183 400 0][421.936 100 0]
[422.2212 50 0][422.5956 50 0][422.7423 200 0][423.317 11 1][423.3602 100 0]
[423.5936 250 0][423.8809 50 0][424.7425 50 0][425.0118 200 0][425.0787 300 0]
[425.8315 40 0][426.0473 800 0][427.1153 250 0][427.1759 1200 0][428.2402 1200 0]
[429.1462 80 0][429.9234 250 0][430.7901 1200 0][431.5084 150 0][432.5761 1500 0]
[435.2734 80 0][436.9771 80 0][437.5929 800 0][438.3544 3000 0][440.475 1200 0]
[441.5122 300 0][442.7299 600 0][446.1652 400 0][446.6551 120 0][447.6017 80 0]
[448.2169 80 0][448.2252 200 0][448.9739 50 0][452.8613 50 0][458.383 11 1]
[464.7433 30 0][473.6771 30 0][485.9741 50 0][487.1317 120 0][487.2136 60 0]
[487.8208 30 0][489.0754 100 0][489.1492 250 0][490.3309 30 0][491.8992 150 0]
[492.0502 500 0][492.392 12 1][495.7597 1500 0][499.05 11 1][500.1862 80 0]
[500.191 18 1][500.42 11 1][500.5711 30 0][500.6117 100 0][501.2067 60 0]
[501.4941 30 0][501.843 12 1][503.064 11 1][503.077 25 0][503.571 12 1]
[504.1755 150 0][504.9819 30 0][505.1634 30 0][507.4748 25 0][510.073 18 1]
[510.095 15 1][511.0357 150 0][513.369 40 0][513.9251 40 0][513.9462 100 0]
[514.436 11 1][514.946 12 1][515.191 25 0][516.227 30 0][516.6281 80 0]
[516.7487 2500 0][516.8897 80 0][516.903 12 1][517.1595 500 0][519.1454 50 0]
[519.2343 80 0][519.4941 200 0][520.4582 30 0][521.5179 25 0][521.6274 150 0]
[521.685 18 1][522.6862 60 0][522.715 1000 0][522.749 13 1][523.2939 250 0]
[524.795 13 1][525.123 13 1][526.026 18 1][526.418 11 1][526.6555 100 0]
[526.9537 1200 0][527.0357 800 0][528.1789 30 0][528.3621 60 0][530.2299 25 0]
[530.618 11 1][531.623 13 1][532.4178 150 0][532.8038 800 0][532.8531 300 0]
[533.2899 100 0][533.959 14 1][533.9928 80 0][534.1023 500 0][536.487 25 0]
[536.747 40 0][536.996 50 0][537.1489 400 0][538.337 60 0][538.706 14 1]
[539.3167 40 0][539.586 12 1][539.7127 300 0][540.206 15 1][540.412 60 0]
[540.5774 250 0][541.091 30 0][541.52 60 0][542.407 60 0][542.783 30 1]
[542.9695 250 0][542.999 13 1][543.4523 100 0][544.6871 200 0][545.545 25 0]
[545.5609 120 0][546.593 16 1][546.694 20 1][548.231 16 1][549.383 14 1]
[549.7516 25 0][550.1464 20 0][550.62 18 1][550.6778 30 0][551.078 12 1]
[552.906 12 1][554.476 13 1][556.9618 30 0][557.2841 60 0][558.6755 120 0]
[561.5644 200 0][562.4541 20 0][564.54 12 1][566.2515 50 0][576.299 20 0]
[578.363 11 1][586.2353 30 0][588.502 13 1][590.282 16 1][591.4114 30 0]
[595.57 14 1][598.6956 30 0][596.171 18 1][596.24 30 1][596.563 13 1]
[606.5482 40 0][610.2159 30 0][613.6614 40 0][613.7694 40 0][614.773 30 1]
[614.924 20 1][617.516 15 1][619.1558 40 0][621.3429 30 0][621.9279 30 0]
[623.0726 40 0][623.837 20 1][624.6317 20 0][624.756 80 1][625.2554 30 0]
[630.532 15 1][633.197 12 1][638.375 15 1][639.3602 20 0][639.9999 30 0]
[641.1647 20 0][641.69 20 1][642.1349 20 0][643.0844 30 0][644.643 20 1]
[645.638 200 1][649.4981 60 0][651.605 20 1][654.6239 20 0][659.2913 20 0]
[667.7989 40 0][685.518 15 0][694.521 15 0][706.744 20 1][713.094 15 0]
[716.4443 25 0][718.7313 80 0][720.7381 30 0][722.451 12 1][730.797 50 1]
[732.07 40 1][737.646 20 1][744.5746 30 0][746.238 20 1][749.5059 40 0]
[751.1045 60 0][758.604 15 0][771.171 15 1][778.059 30 0][395.433 16 2]
[396.872 11 2][396.949 9 2][397.942 10 2][403.542 10 2][405.311 11 2]
[408.1 12 2][412.09 10 2][412.202 11 2][412.278 11 2][413.776 15 2]
[413.935 13 2][414.048 9 2][415.496 9 2][416.473 18 2][416.492 9 2]
[416.684 13 2][417.426 13 2][421.067 9 2][422.227 11 2][423.556 13 2]
[423.862 9 2][424.375 12 2][427.34 12 2][427.972 12 2][428.616 14 2]
[429.685 16 2][430.478 18 2][431.036 20 2][432.368 9 2][437.204 9 2]
[437.214 9 2][437.231 11 2][437.253 14 2][437.281 18 2][439.576 9 2]
[441.96 12 2][443.102 9 2][511.107 9 2][512.735 9 2][515.612 12 2]
[519.908 10 2][523.566 10 2][524.331 18 2][526.034 13 2][527.237 9 2]
[527.298 14 2][527.648 15 2][528.23 16 2][528.483 12 2][529.812 11 2]
[529.993 12 2][530.26 14 2][530.676 10 2][531.088 9 2][532.274 10 2]
[534.688 11 2][535.377 12 2][536.376 12 2][536.806 10 2][537.547 11 2]
[571.988 11 2][574.419 9 2][575.638 10 2][583.393 18 2][584.876 9 2]
[585.462 10 2][587.626 9 2][589.191 15 2][589.868 9 2][591.896 9 2]
[592.013 10 2][592.969 18 2][595.231 10 2][595.362 14 2][596.848 9 2]
[597.932 12 2][598.101 9 2][598.908 12 2][599.954 18 2][603.102 9 2]
[603.259 16 2][603.656 13 2][604.872 11 2][605.418 11 2][605.636 9 2]
[614.999 9 2][616.974 9 2][618.526 9 2][618.656 7 2][619.479 7 2]
[619.543 6 2][620.137 6 2][620.304 5 2][625.981 5 2][629.45 6 2]
[635.781 5 2][731.763 5 2][732.014 6 2]]
10000} bind def
%
/wl@elt@Co {[
[384.205 1400 0][384.547 6900 0][387.312 5500 0][387.396 2800 0][389.408 7900 0]
[391.14 20 1][393.597 1500 0][396.31 80 1][397.674 40 1][398.302 10 1]
[399.531 6000 0][399.791 970 0][402.09 350 0][403.614 10 1][403.737 20 1]
[404.002 4 1][404.539 370 0][405.023 5 1][405.24 10 1][406.273 20 1]
[406.45 2 1][406.637 350 0][407.434 5 1][409.239 830 0][409.657 1 1]
[411.054 550 0][411.877 2800 0][412.132 4400 0][413.088 3 1][414.513 3 1]
[416.067 3 1][418.113 1 1][419.071 90 0][420.861 1 1][424.425 30 1]
[427.233 8 1][428.825 20 1][432.886 3 1][438.426 2 1][439.694 2 1]
[441.391 3 1][446.956 90 0][448.25 10 1][448.912 2 1][449.744 4 1]
[450.054 10 1][453.096 690 0][453.322 2 1][454.966 90 0][455.929 1 1]
[456.559 140 0][456.926 1 1][458.16 190 0][461.63 5 1][462.938 120 0]
[466.066 25 1][466.341 85 0][479.286 110 0][483.116 10 1][484.027 100 0]
[486.788 150 0][496.418 80 1][497.005 10 1][499.047 10 1][499.598 20 1]
[514.674 35 0][521.271 50 0][523.022 50 0][523.521 45 0][524.793 50 0]
[526.63 26 0][526.649 45 0][526.852 26 0][528.065 45 0][530.106 26 0]
[534.271 50 0][534.339 26 0][535.205 50 0][535.348 26 0][536.958 35 0]
[548.334 45 0][553.077 17 0][564.722 17 0][599.188 17 0][608.244 17 0]
[628.263 17 0][645.024 45 0][645.5 21 0][656.342 15 0][663.244 15 0]
[681.494 14 0][687.24 14 0][705.289 21 0][708.499 45 0][741.738 8 0]
[771.268 8 0]]
7900} bind def
%
/wl@elt@Ni {[
[380.714 700 0][383.169 110 0][385.83 1200 0][388.967 30 0][397.217 35 0]
[397.356 110 0][440.155 110 0][445.904 85 0][446.246 18 0][447.048 55 0]
[459.253 35 0][460.037 18 0][460.5 65 0][460.623 18 0][464.866 75 0]
[468.622 23 0][471.442 110 0][471.578 22 0][475.652 30 0][476.395 15 0]
[478.654 45 0][480.7 22 0][482.903 22 0][483.118 19 0][485.541 45 0]
[486.627 30 0][487.344 17 0][490.441 40 0][491.836 22 0][493.583 16 0]
[498.016 45 0][498.413 45 0][499.202 500 1][500.034 16 0][501.246 18 0]
[501.759 50 0][503.537 100 0][504.885 16 0][508.052 100 0][508.111 65 0]
[508.408 26 0][509.932 18 0][509.995 26 0][511.54 21 0][512.938 18 0]
[513.708 23 0][514.277 23 0][514.648 40 0][515.576 40 0][516.866 16 0]
[517.656 13 0][543.587 8 0][547.691 180 0][551 6 0][557.873 6 0]
[558.786 9 0][559.228 13 0][561.479 9 0][562.533 5 0][564.97 4 0]
[566.402 5 0][568.22 12 0][569.5 8 0][570.956 23 0][571.19 10 0]
[571.509 10 0][575.468 16 0][576.085 8 0][585.776 10 0][589.288 10 0]
[610.812 10 0][617.681 10 0][619.118 10 0][625.636 13 0][631.466 10 0]
[664.364 16 0][676.777 22 0][677.232 9 0][691.456 10 0][711.09 5 0]
[712.22 26 0][718.2 6 0][719.702 5 0][726.193 5 0][729.145 5 0]
[738.524 4 0][739.36 16 0][740.935 16 0][741.451 5 0][742.228 23 0]
[752.276 13 0][752.512 9 0][755.56 19 0][757.405 8 0][761.7 23 0]
[761.921 9 0][771.432 16 0][771.558 5 0][772.761 19 0][774.889 19 0]
[778.894 10 0][779.759 13 0]]
1200} bind def
%
/wl@elt@Cu {[
[381.8879 100 1][382.6921 140 1][386.4137 160 1][388.4131 280 1][389.2924 150 1]
[390.3177 170 1][392.0654 140 1][393.3268 120 1][398.7024 120 1][399.3302 150 1]
[400.3476 140 1][402.263 1250 0][403.2647 100 1][404.3484 600 1][404.3751 500 1]
[406.264 2000 0][406.8106 120 1][413.1363 500 1][414.3017 200 1][415.3623 300 1]
[416.114 500 1][416.4284 370 1][417.1851 400 1][417.9512 500 1][421.1866 500 1]
[423.0449 320 1][425.5635 200 1][427.511 950 0][427.9962 300 1][429.247 500 1]
[436.537 400 1][444.4831 100 1][450.6002 400 1][451.6049 150 1][454.1032 150 1]
[455.592 500 1][459.6906 100 1][464.9271 120 1][465.112 2000 0][466.1363 120 1]
[467.1702 320 1][467.3577 300 1][468.1994 450 1][475.8433 100 1][481.2948 400 1]
[485.1262 120 1][485.4988 300 1][487.3304 100 1][490.1427 150 1][490.9734 1000 1]
[491.8376 500 1][492.6424 200 1][493.1698 900 1][494.3026 120 1][495.3724 700 1]
[498.5506 500 1][500.6801 400 1][500.9851 350 1][501.262 400 1][502.1279 350 1]
[503.9016 200 1][504.7348 300 1][505.1793 900 1][505.891 400 1][506.5459 500 1]
[506.7094 450 1][507.2302 350 1][508.8277 450 1][509.3816 420 1][510.0067 350 1]
[510.554 1500 0][512.4476 250 1][515.324 2000 0][515.8093 100 1][518.3367 100 1]
[521.82 2500 0][526.9991 100 1][527.6525 100 1][529.252 1650 0][536.8383 100 1]
[570.024 1500 0][578.213 1500 0][580.5989 150 1][583.3515 100 1][589.7971 200 1]
[593.7577 120 1][594.1196 400 1][599.326 100 1][600.012 650 1][602.3264 100 1]
[607.2218 250 1][608.0343 150 1][609.999 150 1][610.7412 160 1][611.4493 300 1]
[615.0384 600 1][615.4222 750 1][617.2037 500 1][618.6884 550 1][618.8676 400 1]
[619.8092 300 1][620.4261 470 1][620.8457 450 1][621.6939 750 1][621.9844 700 1]
[626.1848 500 1][627.3349 1000 1][628.8696 350 1][630.1009 900 1][630.5972 550 1]
[631.2492 400 1][632.6466 120 1][637.3268 400 1][637.784 750 1][640.3384 400 1]
[642.3884 850 1][644.2965 200 1][644.8559 750 1][646.6246 170 1][647.0168 950 1]
[648.1437 750 1][648.4421 400 1][651.7317 220 1][653.0083 400 1][655.1286 120 1]
[657.708 200 1][662.4292 750 1][664.1396 800 1][666.0962 450 1][677.0362 100 1]
[680.6216 300 1][680.9647 400 1][682.3202 320 1][684.4157 250 1][686.8791 320 1]
[687.2231 270 1][687.9404 270 1][693.7553 220 1][695.2871 150 1][697.7572 150 1]
[702.286 200 1][719.4896 300 1][732.6008 400 1][733.1694 300 1][738.2277 250 1]
[740.4354 1000 1][743.4156 270 1][756.2015 500 1][765.2333 700 1][766.4648 1000 1]
[768.1788 150 1][774.4097 450 1][777.8738 800 1][380.413 600 2][380.918 600 2]
[388.168 300 2][395.381 150 2][409.049 100 2][428.34 200 2][435.197 500 2]
[435.28 1000 2][435.524 500 2][437.084 500 2][437.14 500 2][437.343 500 2]
[437.711 1000 2][438.642 200 2][492.741 150 2][509.428 400 2][516.897 200 2]
[520.834 400 2][521.921 600 2][526.859 200 2][531.778 400 2][536.979 300 2]
[541.848 350 2][549.494 250 2][557.394 50 2][560.9 100 2][570.212 75 2]
[576.856 100 2][585.072 100 2][596.525 200 2][610.087 30 2][636.927 50 2]
[651.254 20 2][664.413 20 2][679.32 50 2]]
2500} bind def
%
/wl@elt@Zn {[
[380.634 50 1][384.029 100 1][388.334 50 0][396.543 15 0][411.321 10 0]
[429.288 25 0][429.833 25 0][462.981 35 0][468.014 300 0][472.215 400 0]
[481.053 400 0][491.162 800 1][492.403 500 1][506.866 7 0][506.958 15 0]
[518.198 200 0][530.865 8 0][531.024 7 0][531.102 7 0][577.21 4 0]
[577.55 4 0][577.711 10 0][589.433 500 1][602.118 500 1][610.249 500 1]
[611.153 100 1][621.461 500 1][623.79 8 0][623.917 8 0][636.234 1000 0]
[647.918 10 0][692.832 15 0][693.847 8 0][694.32 3 0][747.88 200 1]
[758.85 300 1][761.29 100 1][773.25 300 1][775.79 200 1][779.936 10 0]]
1000} bind def
%
/wl@elt@Ga {[
[392.439 9 1][403.299 10 0][417.204 10 0][425.111 4 1][425.116 15 1]
[425.404 10 1][425.564 4 1][425.57 5 1][425.577 10 1][426.2 40 1]
[521.821 3 1][533.83 1 1][535.349 2 0][536.06 2 1][536.35 1 1]
[541.68 3 1][542.16 1 1][542.56 1 1][633.42 10 1][639.656 2000 0]
[641.344 1000 0][641.94 5 1][645.63 3 1][700 1 1][705.124 3 0]
[710.682 5 0][711.63 1 0][717.29 2 0][719.36 5 0][719.87 7 1]
[725.14 10 0][728.96 3 0][734.93 5 0][740.3 20 0][746.4 30 0]
[755.66 6 0][762.05 10 0][773.477 50 0][779.3 2 1][380.66 10 2]
[438.069 100 2][438.176 150 2][486.3 100 2][499.378 150 2][580.828 10 2]
[584.825 20 2][599.351 15 2]]
2000} bind def
%
/wl@elt@Ge {[
[384.511 30 1][422.6562 70 0][468.5829 10 0][468.987 75 1][469.002 50 1]
[474.1806 1000 1][481.4608 1000 1][482.4097 50 1][513.1752 100 1][517.8648 200 1]
[519.4583 3 0][526.5892 6 0][551.3263 6 0][556.4741 8 0][560.701 8 0]
[561.6135 6 0][562.1426 7 0][565.596 8 0][566.4226 6 0][566.4842 5 0]
[569.1954 9 0][570.1776 6 0][571.7877 5 0][580.1029 6 0][580.2093 9 0]
[589.3389 1000 1][602.1041 500 1][607.839 150 1][626.714 50 1][626.807 150 1]
[626.834 100 1][628.3452 75 1][633.6377 100 1][648.4181 100 1][655.7488 6 0]
[678.051 50 1][704.9369 50 1][713.012 6 0][714.539 30 1][733.038 7 0]
[735.3334 5 0][738.4208 7 0][740.264 6 0][751.157 7 0][777.62 5 0]
[388.478 15 2][417.896 200 2][424.541 12 2][426.085 200 2][429.171 150 2]
[467.436 10 2][501.688 10 2][513.475 18 2][522.937 5 2][525.661 3 2]]
1000} bind def
%
/wl@elt@As {[
[384.26 340 1][419.0082 715 1][419.74 615 1][424.2982 615 1][431.5657 500 1]
[432.3867 500 1][433.664 500 1][435.2145 500 1][435.2864 425 1][437.117 375 1]
[442.7106 615 1][443.1562 615 1][445.8469 715 1][446.1075 340 1][446.6348 715 1]
[447.446 500 1][449.423 800 1][450.7659 850 1][453.974 615 1][454.3483 715 1]
[460.2427 615 1][462.9787 340 1][470.7586 340 1][473.067 340 1][488.8557 340 1]
[506.898 100 0][510.558 340 1][510.755 500 1][512.134 100 0][514.163 100 0]
[523.138 425 1][533.123 500 1][540.813 100 0][545.132 135 0][549.7727 340 1]
[555.809 425 1][565.132 425 1][611.007 425 1][617.027 500 1][651.174 300 1]
[709.227 300 1][710.272 300 1][392.26 325 2][403.72 185 2]]
850} bind def
%
/wl@elt@Se {[
[407.02 285 1][417.53 360 1][418.09 450 1][432.87 120 0][433.03 100 0]
[438.29 285 1][444.6 285 1][444.92 220 1][446.76 285 1][473.08 500 0]
[473.9 400 0][474.22 300 0][484.06 285 1][484.5 360 1][522.75 450 1]
[530.54 360 1][536.55 100 0][536.99 120 0][537.41 110 0][552.24 285 1]
[556.69 285 1][586.63 285 1][605.6 450 1][632.56 200 0][644.42 360 1]
[649.05 285 1][653.5 285 1][683.13 150 0][699.069 120 0][699.1792 100 0]
[701.0809 200 0][701.3875 150 0][706.2065 300 0][757.51 200 0][758.34 250 0]
[759.22 150 0][760.68 120 0][380.09 450 2][404.67 360 2][408.32 220 2]
[416.91 450 2][463.79 220 2][630.38 285 2]]
500} bind def
%
/wl@elt@Br {[
[381.565 1200 0][383.469 350 1][387.121 300 1][389.163 400 1][390.124 300 1]
[391.42 300 1][391.438 500 1][391.951 350 1][392.409 400 1][392.955 300 1]
[393.969 350 1][395.061 350 1][398.038 500 1][399.236 1500 0][402.404 300 1]
[413.566 300 1][414.02 300 1][417.963 400 1][419.345 300 1][422.389 1000 1]
[423.689 300 1][429.139 300 1][436.514 2000 0][436.56 1000 1][442.514 1500 0]
[444.174 10000 0][447.261 10000 0][447.772 20000 0][449.042 1000 0][451.344 3000 0]
[452.559 15000 0][452.96 300 1][454.292 500 1][457.574 3000 0][460.136 300 1]
[461.458 2500 0][462.27 350 1][464.202 300 1][465.198 300 1][467.87 500 1]
[469.317 400 1][470.485 500 1][471.976 350 1][472.036 400 1][472.82 300 1]
[473.541 300 1][474.264 400 1][475.228 2500 0][476.6 350 1][477.94 400 1]
[478.031 4000 0][478.519 1600 0][478.55 500 1][480.233 300 1][481.67 500 1]
[481.846 300 1][484.481 350 1][484.875 350 1][492.112 400 1][492.879 400 1]
[493.066 450 1][494.551 300 1][497.976 4000 0][503.874 300 1][505.464 300 1]
[516.438 400 1][518.001 300 1][518.235 500 1][519.39 300 1][523.823 500 1]
[527.268 300 1][530.41 350 1][533.057 400 1][533.205 500 1][539.548 1200 0]
[542.278 400 1][542.499 350 1][543.507 300 1][546.622 1200 0][547.847 350 1]
[548.879 300 1][549.506 300 1][550.669 500 1][558.994 350 1][571.871 300 1]
[583.078 300 1][585.208 1800 0][594.048 1600 0][612.214 2400 0][614.86 40000 0]
[616.174 300 1][617.739 2000 0][633.548 1500 0][635.073 60000 0][635.294 400 1]
[641.032 2500 0][648.356 1800 0][651.462 1000 0][654.457 20000 0][654.809 1500 0]
[655.98 50000 0][657.131 1000 0][657.914 1800 0][658.217 20000 0][662.047 1500 0]
[663.162 50000 0][668.228 20000 0][669.213 10000 0][672.828 8000 0][676.006 2000 0]
[677.948 2000 0][678.674 2200 0][679.004 6500 0][679.148 1600 0][686.115 1800 0]
[700.519 10000 0][726.045 2000 0][734.851 10000 0][751.296 40000 0][759.161 1600 0]
[759.507 1800 0][761.641 2000 0][382.026 450 2][390.395 200 2][450.655 350 2]
[451.974 200 2][517.587 150 2][544.68 100 2][719.28 100 2][767.31 100 2]]
60000} bind def
%
/wl@elt@Kr {[
[387.544 150 1][390.6177 150 1][392.0081 200 1][399.484 100 1][399.7793 100 1]
[405.7037 300 1][406.5128 300 1][408.8337 500 1][409.8729 250 1][410.9248 100 1]
[414.5122 250 1][425.058 150 1][427.3969 1000 0][428.2967 100 0][429.2923 600 1]
[430.049 200 1][431.781 500 1][431.8551 400 0][431.9579 1000 0][432.298 150 1]
[435.1359 100 0][435.5477 3000 1][436.2641 500 0][436.969 200 1][437.6121 800 0]
[438.654 300 1][439.9965 200 0][442.5189 100 0][443.1685 500 1][443.6812 600 1]
[445.3917 600 0][446.3689 800 0][447.5014 800 1][448.988 400 1][450.2353 600 0]
[452.314 400 1][455.661 200 1][457.7209 800 1][458.2978 300 1][459.28 150 1]
[461.5292 500 1][461.9166 1000 1][463.3885 800 1][465.8876 2000 1][468.0406 500 1]
[469.1301 100 1][469.436 200 1][473.9002 3000 1][476.2435 300 1][476.5744 1000 1]
[481.176 300 1][482.518 300 1][483.2077 800 1][484.6612 700 1][485.72 150 1]
[494.559 300 1][502.24 200 1][508.652 250 1][512.573 400 1][520.832 500 1]
[530.866 200 1][533.341 500 1][546.817 200 1][556.2224 500 0][557.0288 2000 0]
[558.0386 80 0][564.9561 100 0][568.189 400 1][569.035 200 1][583.2855 100 0]
[587.0914 3000 0][599.222 200 1][599.3849 60 0][605.6125 60 0][642.018 300 1]
[642.1026 100 0][645.6288 200 0][657.007 150 1][669.9228 60 0][690.4678 100 0]
[721.313 250 1][722.4104 100 0][728.7258 80 0][728.978 400 1][740.702 400 1]
[742.5541 60 0][743.578 200 1][748.6862 100 0][752.446 300 1][758.7411 1000 0]
[760.1544 2000 0][764.116 150 1][768.5244 1000 0][769.4538 1200 0][773.569 250 1]
[774.6827 150 0][386.87 40 2][406.737 50 2][413.133 40 2][415.446 40 2]
[501.645 20 2][550.143 10 2][603.717 10 2][607.838 10 2][631.022 10 2]
[380.93 3 3][386.058 5 3][393.429 5 3]]
3000} bind def
%
/wl@elt@Rb {[
[380.19 2500 1][382.666 1000 1][386.074 450 1][390.729 250 1][392.22 500 1]
[392.644 2500 1][394.051 25000 1][397.815 1000 1][402.949 1700 1][408.388 2500 1]
[410.428 2000 1][413.611 1700 1][419.308 3500 1][420.18 1000 0][421.553 500 0]
[424.44 90000 1][426.658 500 1][427.025 250 1][427.314 15000 1][428.797 2500 1]
[429.397 1500 1][430.626 500 1][434.696 1000 1][437.712 2500 1][444.01 300 1]
[446.947 1000 1][449.392 400 1][451.904 700 1][453.034 3000 1][453.379 500 1]
[454.074 400 1][457.177 20000 1][462.242 3000 1][463.189 350 1][464.857 10000 1]
[465.928 500 1][473.045 1000 1][475.53 1000 1][475.782 400 1][477.595 30000 1]
[478.283 5000 1][485.534 300 1][488.559 1500 1][508.7987 2 0][513.2471 2 0]
[515.0134 10 0][515.208 10000 1][516.458 300 1][516.5023 1 0][516.5142 2 0]
[516.965 1 0][519.5278 15 0][523.3968 2 0][526.0034 20 0][526.0228 1 0]
[527.051 200 1][532.238 3 0][536.2601 40 0][539.0568 4 0][543.1532 75 0]
[543.183 3 0][551.255 500 1][552.278 5000 1][557.8788 6 0][563.599 5000 1]
[564.7774 40 0][565.375 20 0][569.915 3000 1][572.4121 60 0][572.4614 3 0]
[573.964 200 1][607.0755 75 0][613.527 200 1][615.9626 30 0][619.908 1000 1]
[620.6309 75 0][626.94 300 1][629.8325 120 0][629.9224 5 0][645.833 10000 1]
[655.562 1000 1][656.081 5000 1][677.507 3000 1][727.9997 100 0][731.652 300 1]
[740.8173 150 0][761.8933 200 0][775.7651 300 0][775.9436 60 0]]
90000} bind def
%
/wl@elt@Sr {[
[394.08 300 0][396.926 600 0][397.004 300 0][403.038 1300 0][403.238 300 0]
[407.771 46000 1][416.18 200 1][421.552 32000 1][430.545 340 1][443.804 350 0]
[460.733 65000 0][472.228 3200 0][474.192 2200 0][478.432 1400 0][481.188 4800 0]
[483.208 3600 0][485.504 500 0][486.87 600 0][487.249 3000 0][487.606 600 0]
[487.632 2000 0][489.198 1000 0][496.226 8000 0][496.794 1300 0][515.607 800 0]
[522.22 1400 0][522.511 2000 0][522.927 2000 0][523.855 2800 0][525.69 4800 0]
[532.982 350 0][545.084 1500 0][548.084 7000 0][548.612 1100 0][550.417 3500 0]
[552.183 2600 0][553.481 2000 0][554.005 2000 0][554.336 250 0][597.01 200 0]
[634.575 250 0][636.394 250 0][636.996 350 0][638.075 1000 0][638.65 900 0]
[638.824 600 0][640.847 9000 0][644.668 250 0][646.579 250 0][650.4 5500 0]
[654.679 1000 0][655.026 1700 0][661.726 3000 0][664.354 800 0][679.105 1800 0]
[687.838 4800 0][689.259 1200 0][707.01 5500 0][715.309 60 0][716.724 250 0]
[723.227 200 0][730.941 2500 0][762.15 500 0][767.306 400 0][387.426 30 2]
[393.64 30 2][393.672 30 2][395.875 30 2][409.403 30 2][409.702 30 2]
[410.563 30 2][433.58 35 2][507.109 30 2][513.034 30 2][515.826 35 2]
[525.771 40 2][526.221 30 2][528.832 30 2][539.103 30 2][544.348 40 2]
[546.39 30 2][566.466 30 2][568.972 30 2][429.857 9 3][468.508 9 3]]
65000} bind def
%
/wl@elt@Y {[
[381.835 1300 1][383.288 4000 1][384.787 70 1][387.682 80 0][387.828 480 1]
[388.777 30 0][390.459 60 0][391.825 50 0][393.011 60 0][393.066 240 1]
[395.036 4400 1][395.16 150 1][395.509 60 0][398.26 3600 1][398.75 40 0]
[403.983 940 0][404.764 2400 0][407.738 9400 0][408.122 90 0][408.371 2000 0]
[410.238 9900 0][410.639 60 0][411.081 80 0][412.492 320 1][412.831 8900 0]
[414.285 7500 0][415.763 100 0][416.752 2400 0][417.414 2000 0][417.754 8000 1]
[419.928 120 1][420.47 380 1][421.302 80 0][421.354 40 0][421.78 160 0]
[422.063 280 0][422.425 80 0][423.573 600 1][423.594 2200 0][425.12 300 0]
[430.23 360 0][430.963 2800 1][431.63 50 0][433.078 110 0][433.729 30 0]
[434.465 60 0][434.879 440 0][435.233 60 0][435.27 60 0][435.773 120 0]
[435.873 800 1][436.603 120 0][437.494 12000 1][437.561 150 0][437.933 80 0]
[438.548 30 0][438.774 100 0][439.401 30 0][439.467 30 0][439.802 1800 1]
[442.259 890 1][443.734 80 0][444.366 100 0][444.663 130 0][446.527 20 0]
[447.389 40 0][447.572 170 0][447.696 180 0][447.745 160 0][448.728 110 0]
[448.747 300 0][449.175 30 0][449.242 25 0][450.595 500 0][451.358 50 0]
[451.401 80 0][452.205 40 0][452.725 890 0][452.78 440 0][454.432 100 0]
[455.937 100 0][456.439 30 0][457.356 60 0][458.132 35 0][458.177 30 0]
[459.655 130 0][460.48 95 0][461.3 40 0][464.37 2000 0][465.832 200 0]
[465.889 70 0][466.747 85 0][467.082 60 0][467.484 2000 0][467.835 60 0]
[468.232 260 1][468.977 85 0][469.681 180 0][470.885 35 0][472.585 60 0]
[472.853 170 0][473.237 60 0][474.14 85 0][475.279 160 0][476.098 410 0]
[478.018 17 0][478.104 120 0][478.658 160 1][478.689 170 0][479.93 180 0]
[480.431 50 0][480.481 70 0][481.738 85 -1][481.82 140 -1][481.964 140 0]
[482.213 120 0][482.331 190 1][483.915 60 0][483.987 770 0][484.568 550 0]
[485.269 410 0][485.425 120 0][485.487 890 1][485.67 50 0][485.984 330 0]
[487.965 50 0][488.369 1900 1][488.628 50 0][488.665 40 0][489.344 95 0]
[490.012 1100 1][490.611 100 0][490.9 45 0][492.187 150 0][493.093 35 0]
[495.066 45 0][497.43 120 0][498.213 120 1][500.697 100 0][507.021 75 0]
[507.219 75 0][508.742 1100 1][508.818 30 0][511.911 210 1][512.321 450 1]
[513.52 180 0][519.643 120 1][520.041 960 1][520.572 1500 1][524.081 180 0]
[528.982 60 1][532.078 45 1][538.062 75 0][540.278 220 1][541.703 24 0]
[542.437 90 0][543.824 190 0][546.646 710 0][546.847 100 0][547.339 90 1]
[548.074 90 1][549.317 60 0][549.559 35 0][549.741 240 1][550.345 300 0]
[550.99 250 1][551.364 60 0][552.163 120 0][552.676 24 0][552.754 740 0]
[554.163 35 0][554.45 120 0][554.602 90 1][555.643 75 0][556.775 60 0]
[557.742 180 0][558.108 24 0][558.187 620 0][559.096 21 0][559.412 21 0]
[560.633 120 0][562.391 15 0][563.013 560 0][563.225 24 0][563.289 21 0]
[564.469 120 0][564.847 120 0][566.294 740 1][567.527 90 0][569.363 18 0]
[570.673 160 0][572.061 24 0][572.889 75 1][573.012 150 -1][573.209 21 0]
[574.385 90 0][574.693 18 -1][576.422 24 -1][576.564 75 0][577.395 35 0]
[578.169 100 1][580 15 -1][581.858 15 -1][582.187 30 0][583.227 21 0]
[583.807 9 -1][585.883 15 -1][587.183 15 0][587.614 24 -1][587.996 24 0]
[589.394 24 -1][590.296 35 0][591.219 24 -1][593.11 24 -1][593.908 90 -1]
[594.572 45 0][595.002 24 0][595.641 75 -1][597.204 1300 -1][598.186 50 0]
[598.764 1000 -1][600.36 740 -1][600.465 120 -1][600.919 120 0][601.987 620 -1]
[602.341 120 0][603.66 500 -1][605.381 420 -1][607.278 130 -1][608.8 50 0]
[608.935 210 -1][609.678 160 -1][610.782 130 -1][611.473 130 -1][612.738 75 -1]
[613.206 1400 -1][613.504 120 0][613.843 150 0][614.836 1100 -1][615.172 120 -1]
[616.508 820 -1][618.223 560 -1][619.173 1200 0][619.982 590 -1][621.796 450 -1]
[622.259 300 0][623.672 270 -1][625.105 45 0][627.501 120 -1][629.546 60 -1]
[631.62 24 -1][633.81 24 -1][635.948 15 -1][636.987 15 -1][640.201 75 0]
[643.5 1000 0][643.718 24 0][650.123 18 -1][651.833 18 -1][653.584 18 -1]
[653.86 90 0][655.384 12 -1][655.739 70 0][657.258 12 -1][657.685 35 0]
[658.487 23 0][661.375 95 1][662.249 14 0][663.649 19 0][665.061 40 0]
[666.44 21 0][668.758 150 0][669.183 14 0][669.475 7 0][669.926 16 0]
[670.071 70 0][671.32 35 0][673.599 40 0][679.371 190 0][679.541 70 1]
[680.315 12 0][681.516 21 0][683.249 14 1][684.524 45 0][685.824 14 1]
[688.722 29 0][689.6 21 1][690.826 9 0][693.352 14 0][695.031 24 0]
[695.168 10 1][695.804 10 0][697.988 24 0][700.897 13 0][700.993 10 0]
[703.518 19 0][705.294 29 0][705.428 13 0][707.513 9 0][712.792 11 0]
[719.166 35 0][719.593 10 0][726.417 35 1][729.308 9 0][733.062 9 0]
[733.296 5 1][734.646 50 0][739.877 11 0][745.03 29 1][749.488 17 0]
[753.671 7 0][756.313 35 0][761.772 8 0][762.294 19 0][765.289 7 0]
[768.949 5 0][769.8 8 0][771.989 19 0][772.408 19 0][778.842 13 0]
[779.632 13 0][386.696 500 2][390.074 3000 2][391.458 4000 2][403.96 3800 2]
[404.011 3000 2][412.161 120 2][473.762 2000 2][510.288 7500 2][512.04 1300 2]
[523.81 10000 2][526.358 3000 2][538.364 4000 2][556.281 6000 2][556.727 600 2]
[557.224 4000 2][559.548 400 2][560.208 3000 2][725.458 2000 2][755.871 9000 2]]
12000} bind def
%
/wl@elt@Zr {[
[381.758 210 1][382.241 560 0][383.596 2200 0][383.676 1300 1][384.302 550 1]
[384.701 550 0][384.925 550 0][386.387 2900 0][386.434 770 0][387.76 990 0]
[387.905 200 0][388.542 1500 0][389.032 2900 0][389.138 2000 0][390.052 400 0]
[391.594 310 1][392.179 610 0][392.953 1200 0][393.412 200 1][393.479 200 1]
[395.822 940 1][396.666 490 0][396.826 990 0][397.35 660 0][397.529 200 0]
[398.16 200 0][399.113 770 1][399.897 770 1][400.76 200 0][401.225 200 0]
[402.398 400 0][402.492 770 0][402.72 990 0][402.895 240 0][402.968 400 1]
[403.004 490 0][403.589 400 0][404.222 240 0][404.358 610 0][404.456 490 0]
[404.561 400 1][404.867 610 1][405.033 200 1][405.048 200 0][405.503 770 0]
[405.571 600 0][406.153 330 0][406.416 1500 0][407.27 2000 0][407.493 310 0]
[407.653 200 0][407.831 240 0][408.122 2000 0][410.84 200 0][412.146 400 0]
[414.92 1200 1][415.264 200 0][415.624 290 1][416.121 400 1][416.636 400 0]
[418.332 200 0][418.756 660 0][419.476 400 0][419.909 610 0][420.146 610 0]
[420.898 610 1][421.188 200 1][421.386 400 0][422.776 2000 0][423.606 200 0]
[423.931 2000 0][424.034 770 0][424.12 770 0][424.169 1200 0][426.802 310 0]
[428.22 550 0][429.479 550 0][430.289 310 0][434.113 550 0][434.789 1000 0]
[435.974 290 1][436.081 310 0][436.645 350 0][437.978 240 1][441.304 190 0]
[442.046 240 0][442.724 120 0][443.149 160 0][444.3 140 1][445.743 110 0]
[446.691 110 0][447.031 110 0][447.056 190 0][449.697 200 1][450.712 550 0]
[453.575 610 0][454.222 490 0][455.301 200 0][455.513 200 0][455.552 140 0]
[457.552 490 0][458.229 100 0][459.055 140 0][460.257 350 0][460.442 140 0]
[462.641 210 0][463.398 700 0][464.483 210 0][468.342 260 0][468.78 2300 0]
[468.845 510 0][470.779 110 0][471.008 1900 0][471.192 160 0][471.762 120 0]
[471.912 210 0][473.233 300 0][473.948 1400 0][476.278 190 0][477.231 870 0]
[478.492 210 0][478.867 160 0][480.587 260 0][480.947 140 0][481.504 190 0]
[481.563 700 0][482.429 280 0][482.804 190 0][483.878 110 0][485.136 210 0]
[486.606 160 0][488.124 110 0][488.36 110 0][499.476 100 0][501.146 30 0]
[504.658 250 0][506.039 85 0][506.491 360 0][506.522 110 0][507.026 100 0]
[507.398 75 0][507.825 470 0][508.526 85 0][511.227 50 1][511.524 140 0]
[512.042 50 0][513.34 85 0][515.545 300 0][515.8 200 0][515.867 35 0]
[516.099 75 0][516.596 85 0][517.899 17 0][518.37 100 0][518.703 30 0]
[519.16 100 1][520.115 100 0][520.93 85 0][522.493 85 0][524.347 30 0]
[527.741 120 0][528.005 75 0][529.482 60 0][529.679 120 0][530.197 60 0]
[531.14 110 0][532.126 25 0][533.084 22 0][533.843 12 0][535.009 30 1]
[535.035 30 1][535.09 25 0][535.192 25 0][536.256 75 0][536.335 12 0]
[536.939 17 0][538.237 20 0][538.514 270 0][538.665 30 0][539.118 17 0]
[539.588 17 0][540.513 25 0][540.762 85 0][541.393 17 0][542.186 20 0]
[542.636 15 0][542.842 25 0][543.776 25 0][544.041 15 0][544.857 35 0]
[547.492 10 0][547.74 10 0][547.833 35 0][548.083 35 0][548.116 10 0]
[548.609 30 0][550.212 140 0][550.787 25 0][551.711 30 0][551.805 10 0]
[552.841 75 0][553.23 20 0][553.746 45 0][554.532 50 0][555.175 22 -1]
[555.317 25 -1][561.211 12 0][562.014 120 0][562.353 35 0][562.902 25 -1]
[562.958 25 -1][566.451 160 0][566.628 20 0][568.09 120 0][568.542 15 0]
[570.889 30 0][571.821 75 -1][573.57 120 0][574.817 35 -1][577.857 17 -1]
[579.774 160 0][584.732 30 0][586.827 50 0][586.95 110 0][587.98 340 0]
[588.562 85 0][590.109 50 0][590.861 30 -1][592.513 140 0][593.52 100 0]
[595.535 110 0][597.78 30 -1][598.423 100 0][599.537 17 0][600.105 50 0]
[602.536 30 0][603.261 85 0][604.585 170 0][604.924 100 0][606.284 140 0]
[612.083 50 0][612.191 170 0][612.484 85 0][612.744 680 0][613.455 340 0]
[614.046 100 0][614.32 440 0][615.561 30 0][615.771 75 0][616.02 25 0]
[618.94 35 0][619.296 60 0][621.305 85 0][621.469 100 0][622.651 170 -1]
[625.726 100 0][626.105 50 -1][626.706 35 0][629.284 45 -1][629.966 120 0]
[630.434 15 0][631.302 300 0][631.471 30 0][632.135 50 0][634.036 22 0]
[634.51 50 -1][634.522 75 0][637.856 75 -1][640.7 35 0][641.239 50 -1]
[642.617 12 0][643.433 35 0][644.574 60 0][645.162 20 0][645.763 20 0]
[647.021 110 0][647.379 60 -1][648.435 11 0][648.964 110 0][649.31 22 0]
[650.326 50 0][650.636 50 0][650.815 50 -1][654.29 30 -1][655.054 35 0]
[656.943 30 0][657.656 20 0][657.806 30 -1][659.199 50 0][659.671 10 0]
[659.884 10 0][660.327 50 0][662.056 15 0][667.801 11 1][668.818 22 0]
[670.212 11 0][670.961 17 0][671.788 27 0][675.273 40 0][676.238 75 0]
[676.916 85 0][677.289 27 0][678.715 15 1][679.085 35 0][682.878 45 0]
[683.289 45 0][684.533 13 0][684.634 17 0][684.697 100 0][684.926 27 0]
[685.256 13 0][688.829 120 0][690.059 29 0][690.436 20 0][690.737 29 0]
[691.687 20 0][693.238 16 0][694.846 29 0][695.384 150 0][696.644 60 0]
[697.591 10 0][699.084 150 0][699.432 80 0][700.546 10 0][702.74 100 0]
[705.736 25 0][705.796 14 0][708.73 140 0][708.943 25 0][709.446 35 0]
[709.559 50 0][709.77 540 0][710.291 280 0][710.372 170 0][711.168 140 0]
[711.282 40 0][711.352 18 0][713.295 12 0][714.074 16 0][714.447 12 0]
[716.909 590 0][720.162 50 0][725.817 12 0][726.476 35 0][730.621 20 0]
[731.162 25 0][731.372 35 0][731.808 90 0][732.782 10 0][733.597 50 0]
[734.396 50 0][737.35 20 0][738.363 25 0][740.09 14 0][741.139 10 0]
[742.275 10 0][743.31 10 0][743.986 110 0][746.757 18 0][747.958 16 0]
[751.57 14 0][751.795 12 0][754.062 20 0][754.459 20 0][755.146 29 0]
[755.47 40 0][755.845 25 0][756.009 12 0][756.212 12 0][760.715 80 0]
[761.208 14 0][762.117 20 0][765.86 29 0][769.083 18 0][770.427 14 0]
[770.842 10 0][776.655 10 0]]
2900} bind def
%
/wl@elt@Nb {[
[380.13 270 0][380.292 2700 0][380.388 670 0][380.474 530 0][381.049 670 0]
[381.103 530 0][381.551 530 0][381.886 210 1][381.915 210 0][382.488 670 0]
[383.518 350 0][383.645 250 0][384.59 210 0][385.895 290 0][386.338 350 0]
[386.792 270 0][387.756 530 0][387.882 870 0][388.314 670 0][388.544 1100 0]
[388.568 670 0][388.607 210 0][389.13 580 0][390.897 210 0][391.47 670 0]
[392.02 530 0][393.744 670 0][394.367 520 0][396.569 250 0][396.609 910 0]
[397.185 210 0][403.252 1100 0][403.953 250 0][405.894 16000 0][405.951 210 0]
[406.079 350 0][406.826 210 0][407.973 12000 0][408.486 270 0][410.04 440 0]
[410.092 6700 0][411.69 310 0][412.381 5300 0][412.943 670 0][412.993 770 0]
[413.71 2300 0][413.944 440 0][413.971 2700 0][414.321 350 0][415.012 870 0]
[415.258 4400 0][416.347 870 0][416.366 4400 0][416.466 4000 0][416.813 3500 0]
[418.444 310 0][419.088 1200 0][419.207 870 0][419.509 870 0][419.566 1300 0]
[419.851 310 0][420.152 350 0][420.531 870 0][421.473 350 0][421.794 420 0]
[422.915 420 0][425.544 250 0][426.205 770 0][426.602 420 0][427.069 290 0]
[428.699 400 0][429.96 580 0][430.099 580 0][430.956 120 0][431.127 390 0]
[431.245 120 0][432.633 350 0][432.738 120 0][433.137 390 0][434.282 140 0]
[434.865 140 0][434.903 110 0][435.157 290 0][436.843 210 0][437.796 140 0]
[438.836 130 0][439.269 160 0][441.021 330 0][441.944 190 0][443.722 230 0]
[444.718 290 0][445.68 140 0][445.742 140 0][446.971 140 0][447.129 140 0]
[447.253 140 0][450.304 150 0][452.341 530 0][454.682 480 0][456.453 370 0]
[457.308 720 0][458.162 480 0][460.677 1200 0][461.617 170 0][463.011 450 0]
[464.895 450 0][464.927 110 0][466.383 450 0][466.624 340 0][466.722 240 0]
[467.209 580 0][467.537 530 0][467.848 110 0][468.514 320 0][470.614 130 0]
[470.829 260 0][471.35 150 0][473.389 110 0][474.97 220 0][481.638 110 0]
[484.837 110 0][496.778 130 0][497.314 110 0][498.897 190 0][500.095 85 0]
[500.225 65 0][501.327 40 0][501.775 230 0][501.951 40 0][502.636 150 0]
[503.013 40 0][503.904 210 0][504.796 40 0][505.801 170 0][505.935 65 0]
[506.525 130 0][507.74 40 0][507.896 750 0][509.441 40 0][509.53 420 0]
[510.016 170 0][512.03 170 0][512.18 85 0][512.766 85 0][513.334 40 0]
[513.475 210 0][514.058 75 0][514.754 75 0][515.064 40 0][515.263 75 0]
[516.033 250 0][516.438 250 0][518.031 230 0][518.698 110 0][518.92 190 0]
[519.308 170 0][519.584 150 0][520.322 65 0][520.513 35 0][521.91 85 0]
[522.516 65 0][523.281 150 0][523.743 85 0][524.039 29 0][525.162 150 0]
[525.303 75 0][525.393 85 0][526.992 50 0][527.153 270 0][527.248 25 0]
[527.62 130 0][527.943 29 0][528.526 50 0][529.634 35 0][531.555 50 0]
[531.701 17 0][531.86 250 0][531.949 50 0][533.487 75 0][533.681 25 0]
[534.08 50 0][534.358 25 0][534.417 460 0][535.074 340 0][535.328 40 0]
[535.531 25 0][535.57 40 0][535.919 29 0][536.201 17 0][537.527 40 0]
[538.134 40 0][538.83 17 0][539.586 21 0][539.633 29 0][541.124 29 0]
[541.63 21 0][542.244 65 0][543.126 21 0][543.727 110 0][544.831 19 0]
[545.619 19 0][545.804 40 0][546.81 19 0][548.1 40 0][548.309 13 0]
[548.349 19 0][549.106 13 0][549.953 17 0][550.458 40 0][550.912 17 0]
[551.282 35 0][551.739 17 0][552.357 50 0][554.147 25 0][555.135 85 0]
[556.3 29 0][557.144 17 0][557.616 35 0][557.829 35 0][558.697 50 0]
[559.095 17 0][559.489 13 0][559.959 17 0][560.352 40 0][560.393 13 0]
[562.826 25 0][562.917 65 0][563.542 35 0][564.211 170 0][564.53 35 0]
[565.414 17 0][566.471 130 0][566.563 170 0][566.686 17 0][567.102 65 0]
[567.191 85 0][567.747 25 0][569.309 25 0][569.79 35 0][570.616 40 0]
[570.648 85 0][570.933 29 0][571.559 17 0][571.635 65 0][572.566 25 0]
[572.919 130 0][573.736 21 0][573.82 13 0][575.144 85 0][576.034 110 0]
[576.499 65 0][577.108 29 0][577.607 50 0][578.034 17 0][578.754 85 0]
[578.979 17 0][579.424 50 0][580.403 50 0][581.533 29 0][581.943 110 0]
[582.062 35 0][583.49 75 0][583.815 25 0][583.864 130 0][584.247 50 0]
[584.609 17 0][586.647 65 0][587.47 35 0][587.779 17 0][589.344 40 0]
[590.062 190 0][590.38 40 0][592.741 29 0][593.416 40 0][595.77 40 0]
[598.322 150 0][598.608 65 0][599.793 85 0][602.975 50 0][603.184 50 0]
[604.55 50 0][604.872 25 0][605.665 29 0][610.771 29 0][614.251 40 0]
[614.813 50 0][616.432 50 0][621.306 29 0][622.196 75 0][625.176 40 0]
[626.077 21 0][643.046 85 0][643.322 50 0][649.784 17 0][654.461 65 0]
[657.473 15 0][659.1 19 0][660.616 19 0][660.728 19 0][661.415 35 0]
[662.698 19 0][666.084 210 0][667.733 150 0][670.12 65 0][672.362 130 0]
[673.988 75 0][679.531 25 0][682.811 85 0][684.935 25 0][687.092 19 0]
[687.636 40 0][690.289 25 0][690.807 35 0][691.832 40 0][694.607 17 0]
[697.249 17 0][698.609 25 0][699.032 85 0][699.611 17 0][702.348 21 0]
[703.804 17 0][704.681 190 0][706.641 8 0][707.523 8 0][709.894 40 0]
[710.201 17 0][711.931 19 0][712.295 15 0][712.617 35 0][713.006 17 0]
[715.943 130 0][719.137 17 0][720.894 19 0][725.235 50 0][727.481 15 0]
[731.703 13 0][732.392 17 0][732.838 29 0][735.316 65 0][737.25 190 0]
[741.983 13 0][743.602 15 0][747.82 19 0][751.593 65 0][751.977 29 0]
[757.458 170 0][758.321 17 0][763.981 13 0][764.771 13 0][770.333 25 0]
[772.668 75 0][775.731 25 0][778.711 6 0]]
16000} bind def
%
/wl@elt@Mo {[
[380.184 290 0][382.67 520 0][382.887 940 0][383.375 1700 0][384.725 380 0]
[386.411 29000 0][386.908 580 0][388.682 580 0][390.177 380 0][390.296 19000 0]
[394.148 65 1][394.304 230 0][405.601 270 0][406.208 1400 0][406.988 2300 0]
[408.144 1300 0][408.438 940 0][410.215 250 0][410.747 730 0][412.01 630 0]
[414.355 2900 0][414.894 230 0][415.528 250 0][415.74 200 0][417.827 200 0]
[418.582 480 0][418.832 2500 0][419.456 250 0][423.259 1500 0][426.928 270 0]
[427.691 890 0][427.724 1200 0][428.864 1400 0][429.213 680 0][429.321 890 0]
[429.388 360 0][432.614 840 0][432.674 250 0][435.034 230 0][436.904 230 0]
[438.164 1900 0][441.157 2500 0][442.362 210 0][443.495 990 0][444.22 200 0]
[444.974 340 0][445.736 480 0][447.456 630 0][449.128 230 0][450.49 120 0]
[451.215 140 0][451.713 230 0][452.434 230 0][452.94 120 0][453.68 400 0]
[455.811 110 0][457.65 210 0][459.516 170 0][460.988 360 0][462.138 100 0]
[462.647 460 0][462.748 100 0][466.276 220 0][467.19 130 0][468.822 130 0]
[470.726 640 0][470.822 150 0][471.792 220 0][472.914 100 0][473.144 700 0]
[475.039 100 0][476.019 770 0][477.634 150 0][479.652 100 0][481.925 410 0]
[483.051 410 0][486.8 360 0][495.062 110 0][495.754 150 0][497.912 210 0]
[499.991 110 0][501.081 20 0][501.46 180 0][501.678 26 0][501.985 20 0]
[502.9 80 0][503.078 65 0][503.891 23 0][504.652 26 0][504.771 100 0]
[505.5 50 0][505.807 35 0][505.988 200 0][506.252 35 0][506.464 29 0]
[507.987 35 0][508.002 100 0][508.126 35 0][509.097 40 0][509.134 35 0]
[509.216 35 0][509.589 40 0][509.665 100 0][509.752 130 0][509.803 35 0]
[510.971 130 0][511.497 80 0][511.697 35 0][512.383 29 0][514.538 150 0]
[514.739 110 0][516.319 80 0][516.776 100 0][517.108 160 0][517.294 230 0]
[517.418 160 0][519.144 40 0][520.017 110 0][520.074 50 0][521.044 26 0]
[521.186 50 0][521.94 80 0][523.106 65 0][523.236 26 0][523.426 100 0]
[523.82 460 0][524.088 230 0][524.281 110 0][524.551 100 0][525.904 150 0]
[526.017 16 0][526.114 65 0][526.895 20 0][527.18 35 0][527.628 35 0]
[527.965 65 0][528.086 210 0][528.384 20 0][529.208 55 0][529.346 35 0]
[529.547 55 0][530.626 20 0][531.389 55 0][531.504 35 0][531.989 20 0]
[532.447 20 0][532.706 35 0][535.235 20 0][535.488 80 0][535.551 35 0]
[535.648 65 0][536.056 560 0][536.428 110 0][536.711 35 0][537.24 35 0]
[538.869 26 0][539.452 65 0][539.738 35 0][540.047 50 0][540.579 35 0]
[540.639 35 0][541.738 40 0][542.689 23 0][543.568 55 0][543.775 65 0]
[545.051 40 0][545.646 35 0][546.053 26 0][546.557 23 0][547.59 35 0]
[549.028 35 0][549.217 20 0][549.38 26 0][549.849 26 0][550.154 50 0]
[550.187 23 0][550.354 26 0][550.649 7800 0][552.004 23 0][552.064 26 0]
[552.652 40 0][552.697 40 0][553.305 5200 0][553.941 40 0][554.312 50 0]
[554.449 40 0][555.628 55 0][555.672 26 0][556.405 20 0][556.862 40 0]
[556.948 26 0][557.045 2500 0][557.519 35 0][559.158 20 0][560.276 40 0]
[560.862 23 0][560.923 23 0][561.093 100 0][561.307 23 0][561.845 20 0]
[561.938 23 0][563.247 330 0][563.486 50 0][565.013 230 0][567.363 23 0]
[567.447 55 0][567.789 40 0][568.289 35 0][568.914 460 0][569.928 23 0]
[570.572 80 0][571.18 23 0][572.274 210 0][572.877 23 0][572.945 26 0]
[575.14 620 0][577.455 23 0][577.936 40 0][578.333 23 0][579.185 520 0]
[579.577 23 0][580.046 26 0][580.267 35 0][582.52 23 0][583.559 23 0]
[583.999 20 0][584.886 20 0][584.973 55 0][585.152 50 0][585.827 520 0]
[586.138 20 0][586.933 50 0][587.659 26 0][588.833 820 0][589.229 23 0]
[589.338 50 0][589.878 20 0][590.147 40 0][592.636 40 0][592.888 160 0]
[598.817 40 0][602.549 35 0][602.727 16 0][603.066 1300 0][604.783 20 0]
[605.481 20 0][607.958 20 0][608.127 10 0][610.187 40 0][613.063 10 0]
[619.766 10 0][621.789 20 0][626.427 10 0][626.588 16 0][629.074 15 0]
[630.175 13 0][632.354 11 0][635.722 40 0][638.911 16 0][639.112 11 0]
[640.107 35 0][640.911 26 0][641.239 10 0][642.437 100 0][644.634 20 0]
[647.12 20 0][647.399 20 0][649.313 10 0][651.984 23 0][661.12 15 0]
[661.913 230 0][662.457 10 0][665.038 50 0][665.968 13 0][669.047 18 0]
[673.398 110 0][674.608 21 0][674.627 50 0][675.397 35 0][676.35 13 0]
[679.988 10 0][680.262 10 0][681.203 10 0][682.563 13 0][682.887 18 0]
[683.888 40 0][684.892 16 0][688.628 21 0][689.236 16 0][689.801 10 0]
[689.898 10 0][690.82 13 0][691.401 35 0][693.41 13 0][694.739 10 0]
[696.064 10 0][697.871 16 0][698.894 26 0][699.913 12 0][700.16 16 0]
[703.798 22 0][706.021 22 0][706.334 13 0][708.122 13 0][710.987 110 0]
[713.408 27 0][724.25 150 0][724.585 40 0][726.762 22 0][730.019 17 0]
[734.849 13 0][736.165 13 0][736.441 10 0][739.136 40 0][743.41 10 0]
[744.734 13 0][745.285 13 0][748.574 140 0][750.447 13 0][757.264 11 0]
[759.516 11 0][760.184 11 0][765.676 17 0][767.949 13 0][772.077 27 0]]
29000} bind def
%
/wl@elt@Tc {[
[381.467 200 0][381.689 300 0][382.447 300 0][382.854 500 0][383.035 200 0]
[383.245 200 0][383.282 600 0][383.756 1500 0][384.131 800 0][384.597 800 0]
[384.76 500 0][385.122 300 0][385.673 500 0][386.307 200 0][386.411 400 0]
[386.824 1000 0][387.566 200 0][387.916 500 0][388.072 600 0][389.212 300 0]
[389.322 200 0][389.983 600 0][391.938 300 0][392.366 300 0][392.757 200 0]
[393.37 200 0][394.657 4000 0][394.709 2000 0][395.573 200 0][397.964 300 0]
[398.035 500 0][398.497 10000 0][398.778 400 0][399.404 300 0][399.451 2000 0]
[399.697 200 0][400.469 300 0][400.714 500 0][401.2 1000 0][401.668 400 0]
[401.722 600 0][402.076 2000 0][403.163 20000 0][403.925 1000 0][404.178 200 0]
[404.911 10000 0][405.195 500 0][405.318 200 0][405.608 200 0][408.354 400 0]
[408.871 10000 0][409.369 200 0][409.567 15000 0][411.022 1000 0][411.508 10000 0]
[411.927 600 0][412.422 8000 0][412.827 1000 0][413.481 300 0][413.912 300 0]
[413.985 800 0][414.127 400 0][414.495 6000 0][414.508 3000 0][414.762 200 0]
[416.561 10000 0][416.742 500 0][416.968 1000 0][417.027 4000 0][417.253 5000 0]
[417.628 1000 0][418.651 800 0][421.861 300 0][423.819 10000 0][426.227 20000 0]
[426.269 1000 0][427.497 800 1][427.89 800 0][429.706 30000 0][433.686 400 0]
[435.849 400 0][435.926 200 0][442.959 1000 0][448.153 1000 0][448.706 3000 0]
[449.503 400 0][451.598 1000 0][452.284 10000 0][453.953 2000 0][454.209 400 0]
[455.22 400 0][455.285 800 0][455.705 1000 0][456.454 2000 0][457.845 1000 0]
[459.335 1000 0][460.916 300 0][461.686 1000 0][462.269 200 0][462.496 300 0]
[463.057 1000 0][463.315 200 0][463.75 3000 0][464.328 500 0][464.833 2000 0]
[466.021 2000 0][466.93 2000 0][467.217 400 0][467.89 200 0][468.936 400 0]
[469.428 300 0][470.692 1000 0][471.422 200 0][471.777 2000 0][471.902 500 0]
[471.928 4000 0][473.651 200 0][474.061 10000 0][474.961 500 0][475.272 1000 0]
[476.236 200 0][477.154 4000 0][477.389 200 0][478.392 200 0][478.56 500 0]
[479.048 200 0][479.162 250 0][479.998 300 0][480.569 100 0][480.942 100 0]
[481.679 500 0][482.074 10000 0][483.135 300 0][483.437 1000 0][483.539 1000 0]
[484.136 100 0][485.359 20000 0][485.721 100 0][486.219 100 0][486.673 10000 0]
[487.077 200 0][488.87 100 0][489.088 150 0][489.192 8000 0][489.249 150 0]
[490.851 1000 0][490.957 2000 0][491.302 500 0][491.47 150 0][492.067 200 0]
[492.36 300 0][494.806 400 0][497.634 5000 0][499.5 400 0][500.267 200 0]
[500.574 100 0][501.452 200 0][502.624 500 0][502.679 300 0][502.789 150 0]
[503.245 80 0][505.527 300 0][505.833 60 0][506.069 500 0][509.074 80 0]
[509.628 5000 0][510.324 200 0][510.432 500 0][510.981 200 0][512.06 100 0]
[513.926 500 0][515.063 500 0][516.181 2000 0][517.481 2000 0][520.656 100 0]
[522.555 200 0][526.022 200 0][526.144 200 0][527.551 1000 0][528.507 800 0]
[530.531 100 0][531.496 400 0][532.02 600 0][533.479 200 0][535.348 500 0]
[535.663 200 0][535.865 300 0][536.014 200 0][537.52 500 0][542.305 150 0]
[544.74 200 0][545.19 500 0][545.595 100 0][547.196 300 0][548.301 70 0]
[548.537 60 0][550.689 80 0][552.411 150 0][552.823 100 0][554.194 200 0]
[554.363 80 0][555.053 100 0][558.902 3000 0][560.223 200 0][562.045 2000 0]
[562.994 300 0][564.213 1500 0][564.494 800 0][565.6 100 0][567.215 60 0]
[568.73 200 0][568.905 200 0][572.531 700 0][577.147 500 0][579.465 100 0]
[579.985 80 0][581.424 100 0][583.148 200 0][583.633 150 0][592.336 150 0]
[592.447 1000 0][592.629 200 0][593.193 600 0][603.236 60 0][604.799 60 0]
[606.509 200 0][608.523 800 0][609.939 300 0][610.296 500 0][612.068 1000 0]
[613.08 1000 0][613.223 150 0][618.47 100 0][619.266 800 0][624.418 600 0]
[631.218 100 0][635.486 100 0][635.673 100 0][638.987 80 0][640.883 100 0]
[645.59 1000 0][646.193 600 0][647.027 100 0][649.168 200 0][652.682 200 0]
[657.924 150 0][662.557 500 0][667.366 300 0][668.71 100 0][678.6 80 0]
[679.863 70 0][685.69 60 0][700.237 150 0][701.657 100 0][708.618 500 0]
[709.312 60 0][714.128 200 0][715.762 200 0][725.608 70 0][732.238 100 0]
[732.914 80 0][739.68 100 0][740.261 100 0][740.536 200 0][742.715 60 0]
[743.412 150 0][745.249 600 0][746.159 60 0][753.495 80 0][754.026 800 0]
[754.339 80 0][757.402 200 0][757.926 500 0][762.453 90 0][768.445 100 0]
[769.737 500 0][769.819 80 0][779.304 800 0][779.828 60 0]]
30000} bind def
%
/wl@elt@Ru {[
[380.026 310 0][380.868 310 0][381.272 600 0][381.727 760 0][381.903 760 0]
[382.209 650 0][382.493 550 0][383.18 760 0][383.505 220 0][383.807 310 0]
[383.97 930 0][384.668 480 0][385.043 760 0][385.646 480 0][385.755 1300 0]
[386.072 220 0][386.269 650 0][386.784 1300 0][387.352 260 0][389.221 650 0]
[390.908 760 0][392.092 260 0][392.347 1500 0][392.592 3300 0][393.176 600 0]
[393.355 310 0][394.557 760 0][395.021 460 0][395.268 310 0][396.49 460 0]
[397.844 600 0][397.942 600 0][398.486 870 0][399.598 280 0][402.216 1500 0]
[402.383 600 0][403.921 310 0][405.14 1400 0][405.405 710 0][406.446 370 0]
[406.761 200 0][406.837 760 0][407.3 200 0][407.673 980 0][408.06 6000 0]
[408.543 310 0][409.779 930 0][410.174 350 0][411.274 1900 0][414.416 2000 0]
[414.574 650 0][414.677 260 0][416.751 870 0][419.758 550 0][419.888 550 0]
[419.99 7600 0][420.602 1500 0][421.206 5400 0][421.444 760 0][421.727 930 0]
[422.068 370 0][423.031 550 0][424.105 760 0][424.306 760 0][424.673 370 0]
[425.899 310 0][428.433 760 0][429.328 220 0][429.479 260 0][429.593 550 0]
[429.771 3700 0][430.76 930 0][431.843 370 0][431.987 550 0][434.207 550 0]
[434.97 350 0][435.413 710 0][436.121 870 0][437.221 2400 0][438.539 870 0]
[438.565 1300 0][439.044 1700 0][441.003 1600 0][442.146 160 0][442.846 330 0]
[443.976 460 0][444.934 440 0][446.004 1100 0][447.393 190 0][448.045 150 0]
[449.814 350 0][451.01 120 0][451.689 220 0][451.782 220 0][452.095 110 0]
[454.733 170 0][454.785 110 0][455.451 5400 0][455.998 110 0][458.444 1700 0]
[459.11 110 0][459.252 150 0][459.908 330 0][463.569 170 0][464.509 200 0]
[464.761 720 0][465.432 290 0][468.179 290 0][468.402 190 0][469.011 290 0]
[470.948 1400 0][473.133 140 0][473.352 120 0][475.784 500 0][481.552 260 0]
[484.456 120 0][486.915 550 0][489.56 160 0][490.305 470 0][490.789 120 0]
[492.107 260 0][493.843 180 0][496.89 160 0][498.035 160 0][499.274 120 0]
[501.123 160 0][501.495 90 0][502.618 90 0][502.816 65 0][504.035 35 0]
[504.074 35 0][504.731 65 0][505.733 450 0][506.264 21 0][507.297 90 0]
[507.632 120 0][509.383 200 0][510.707 80 0][512.373 24 0][512.726 55 0]
[513.389 65 0][513.655 530 0][514.276 170 0][514.724 250 0][515.107 110 0]
[515.32 55 0][515.514 500 0][516 55 0][517.103 920 0][519.502 180 0]
[519.987 80 0][520.212 45 0][521.343 45 0][522.355 65 0][524.238 40 0]
[525.167 55 0][525.707 40 0][526.647 40 0][526.683 40 0][528.082 40 0]
[528.408 130 0][529.116 40 0][530.486 80 0][530.927 260 0][531.533 13 0]
[533.293 40 0][533.47 45 0][533.593 110 0][536.177 130 0][537.784 65 0]
[538.588 65 0][540.104 110 0][540.139 40 0][541.886 40 0][542.759 55 0]
[543.921 26 0][545.271 13 0][545.482 80 0][545.613 90 0][547.518 13 0]
[547.94 55 0][548.03 26 0][548.432 80 0][548.464 18 0][549.669 26 0]
[550.102 13 0][551.071 130 0][551.237 20 0][551.786 8 0][552.178 12 0]
[553.099 12 0][554.066 24 0][555.652 12 0][555.975 90 0][556.903 11 0]
[557.84 21 0][560.314 21 0][560.355 8 0][560.673 13 0][562.979 11 0]
[563.624 290 0][564.166 11 0][564.956 7 0][565.33 7 0][566.52 11 0]
[567.963 16 0][569.905 180 0][572.482 13 0][572.573 13 0][574.599 16 0]
[574.747 16 0][575.202 11 0][575.683 11 0][576.792 11 0][580.439 16 0]
[581.498 65 0][582.806 8 0][583.321 16 0][591.934 55 0][592.145 80 0]
[592.687 21 0][593.238 26 0][593.665 8 0][595.115 8 0][597.338 21 0]
[597.417 8 0][598.867 16 0][599.365 35 0][611.677 18 0][619.942 26 0]
[622.52 26 0][628.449 9 0][629.522 18 0][633.062 13 0][633.612 9 0]
[636.341 9 0][637.645 9 0][639.023 16 0][641.757 8 0][644.484 26 0]
[649.644 8 0][652.874 11 0][656.045 4 0][659.374 4 0][661.82 9 0]
[666.314 21 0][669 55 0][670.752 11 0][671.83 15 0][673.045 15 0]
[675.654 7 0][676.695 21 0][677.502 30 0][678.723 13 0][681.351 8 0]
[682.388 15 0][682.417 21 0][683.152 7 0][691.148 26 0][692.323 110 0]
[698.201 26 0][702.798 26 0][708.606 9 0][708.735 12 0][714.172 4 0]
[721.926 6 0][723.892 35 0][726.696 7 0][732.356 8 0][739.393 16 0]
[746.891 18 0][747.54 12 0][748.579 26 0][749.975 70 0][753.207 7 0]
[755.961 26 0][761.294 5 0][762.15 18 0][772.287 18 0][772.991 5 0]
[779.186 22 0][779.789 4 0]]
7600} bind def
%
/wl@elt@Rh {[
[380.592 760 0][380.676 1300 0][380.95 45 0][381.245 95 0][381.501 470 0]
[381.647 760 0][381.819 1300 0][382.226 3800 0][382.848 2300 0][383.389 2000 0]
[383.475 45 0][385.652 5900 0][387.001 490 0][387.239 70 0][387.734 380 0]
[388.834 70 0][390.422 29 0][391.283 23 0][391.351 120 0][392.219 240 0]
[393.423 2000 0][393.498 45 0][393.584 50 0][394.272 590 0][395.824 95 0]
[395.886 3800 0][396.454 45 1][397.531 380 0][398.44 240 0][399.561 240 0]
[399.615 380 0][402.314 120 0][404.841 60 0][404.904 23 0][405.344 40 0]
[405.634 23 0][407.757 70 0][408.278 560 0][408.428 19 0][408.779 45 0]
[408.85 60 0][409.752 140 0][410.749 45 0][411.633 70 0][411.968 120 0]
[412.168 1100 0][412.887 1500 0][413.527 2100 0][415.437 240 0][419.65 330 0]
[420.662 70 0][421.114 3300 0][423.02 29 0][424.444 40 0][427.343 60 0]
[427.86 60 0][428.871 820 0][429.677 70 0][434.244 23 0][437.304 45 0]
[437.48 4200 0][437.992 95 0][443.332 23 0][449.247 35 0][450.378 29 0]
[452.872 23 0][454.427 16 0][454.873 35 0][455.164 40 0][456.089 19 0]
[456.519 16 0][456.9 130 0][457.131 14 0][460.812 29 0][461.991 14 0]
[464.318 23 0][467.503 150 0][472.1 19 0][474.511 70 0][475.558 12 0]
[481.049 23 0][484.243 21 0][484.399 45 0][485.163 60 0][496.371 60 0]
[497.775 60 0][497.918 40 0][508.552 14 0][509.063 70 0][512.069 23 0]
[513.076 19 0][515.554 60 0][515.709 14 0][515.869 40 0][517.597 60 0]
[517.727 12 0][518.419 35 0][519.314 95 0][520.695 16 0][521.152 16 0]
[521.273 19 0][521.479 16 0][522.266 19 0][523.062 19 0][523.716 45 0]
[523.78 9 0][526.927 14 0][528.012 11 0][529.214 14 0][531.479 14 0]
[532.974 40 0][533.108 14 0][534.931 9 0][535.44 130 0][535.647 23 0]
[537.91 45 0][539.044 95 0][540.473 23 0][542.407 60 0][542.472 19 0]
[542.545 19 0][543.958 12 0][544.136 12 0][544.432 9 0][544.523 35 0]
[546.811 23 0][547.085 35 0][547.612 12 0][548.142 12 0][548.423 16 0]
[550.465 9 0][553.504 29 0][554.458 21 0][559.942 160 0][560.771 7 0]
[560.835 16 0][563.277 5 0][565.962 9 0][568.638 40 0][570.247 9 0]
[572.73 6 0][579.266 29 0][579.579 9 0][580.334 9 0][580.691 40 0]
[582.184 6 0][583.158 35 0][590.731 7 0][591.854 9 0][594.146 7 0]
[598.36 130 0][599.119 9 0][610.272 35 0][611.615 6 0][612.806 8 0]
[618.689 8 0][619.999 14 0][625.372 16 0][627.666 5 0][627.746 8 0]
[629.338 6 0][631.953 29 0][641.472 12 0][651.041 16 0][651.97 19 0]
[662.78 9 0][663.016 19 0][675.235 40 0][679.665 9 0][682.733 13 0]
[685.768 11 0][687.994 20 0][696.567 65 0][697.291 8 0][697.915 16 0]
[700.158 16 0][703.876 11 0][710.164 18 0][710.445 15 0][714.255 6 0]
[721.906 9 0][726.818 18 0][727.082 35 0][727.194 12 0][727.303 5 0]
[737.557 9 0][738.664 5 0][743.08 9 0][744.239 18 0][744.677 7 0]
[747.574 12 0][749.524 12 0][754.202 8 0][755.767 11 0][757.722 8 0]
[769.005 11 0][777.29 18 0][779.161 29 0][385.298 1 2]]
5900} bind def
%
/wl@elt@Pd {[
[383.229 1500 0][389.42 2200 0][395.864 1500 0][408.734 290 0][416.984 90 0]
[421.295 2500 0][447.359 180 0][478.818 55 0][481.751 45 0][487.543 35 0]
[511.081 55 0][511.702 75 0][516.384 160 0][523.486 55 0][529.563 120 0]
[531.257 18 0][534.51 15 0][539.524 35 0][554.28 55 0][554.702 35 0]
[561.944 27 0][564.269 15 0][565.542 14 0][567.007 75 0][569.014 11 0]
[569.509 55 0][573.661 18 0][677.454 23 0][678.452 65 0][683.342 4 0]
[701.644 11 0][731.006 13 0][736.812 75 0][739.192 27 0][748.69 16 0]
[776.403 120 0][778.667 27 0]]
2500} bind def
%
/wl@elt@Ag {[
[381.094 200 0][381.178 50 0][384.074 100 0][384.785 15 0][390.741 50 0]
[390.931 50 1][391.44 50 0][392.01 70 1][392.801 10 0][394.043 10 0]
[394.297 10 0][394.943 60 1][398.158 100 0][398.519 70 1][399.215 10 0]
[405.548 100 0][408.343 10 0][408.591 80 1][418.548 100 1][421.096 90 0]
[421.282 100 0][431.107 50 0][439.623 20 0][447.604 50 0][455.6 20 0]
[461.569 30 0][462.004 80 1][462.046 50 1][466.848 60 0][467.76 30 0]
[478.84 100 1][479.62 20 0][484.782 30 0][487.41 100 0][488.821 20 0]
[491.75 10 0][493.575 10 0][499.289 20 0][502.735 80 1][512.35 15 0]
[520.908 1000 0][533.362 10 0][546.55 1000 0][547.155 100 0][547.538 20 0]
[554.567 20 0][555.958 10 0][566.734 100 0][608.378 10 0][626.85 10 0]
[662.108 20 0][735.996 20 0][768.778 320 0]]
1000} bind def
%
/wl@elt@Cd {[
[398.1926 10 0][402.912 100 1][413.477 200 1][414.149 50 1][428.508 100 1]
[430.6672 8 0][441.241 100 1][441.2989 3 0][441.563 1000 1][444.045 30 1]
[466.2352 8 0][467.8149 200 0][474.469 30 1][479.9912 300 0][488.172 50 1]
[502.55 50 1][508.5822 1000 0][515.466 6 0][526.801 100 1][527.16 100 1]
[533.748 1000 1][537.813 1000 1][538.189 200 1][584.33 40 1][588.022 50 1]
[609.9142 300 0][611.149 100 0][632.5166 100 0][633.0013 30 0][635.472 400 1]
[635.998 500 1][643.847 2000 0][646.494 400 1][656.765 25 1][672.578 500 1]
[675.919 100 1][677.8116 30 0][723.701 50 1][728.438 100 1][734.567 1000 0]]
2000} bind def
%
/wl@elt@In {[
[383.465 250 1][384.218 200 1][388.978 100 1][390.207 100 1][392.212 60 1]
[393.44 65 1][396.235 250 1][400.466 120 1][401.392 140 1][405.694 410 1]
[410.176 17000 0][420.514 140 1][421.304 100 1][421.966 110 1][437.287 150 1]
[450.078 150 1][451.131 18000 0][454.901 110 1][457.085 140 1][457.802 180 1]
[457.84 180 1][461.608 140 1][461.717 170 1][462.014 250 1][462.07 150 1]
[462.73 170 1][463.704 140 1][463.816 380 1][464.458 220 1][465.562 360 1]
[465.674 320 1][468.111 190 1][468.48 450 1][487.837 3 0][490.706 90 1]
[492.493 70 1][497.377 150 1][510.936 80 1][511.514 100 1][511.74 140 1]
[512.08 270 1][512.175 200 1][512.985 80 1][517.542 240 1][518.444 140 1]
[525.432 30 0][526.274 12 0][530.945 150 1][541.141 80 1][541.845 140 1]
[543.67 220 1][549.75 130 1][550.708 140 1][551.3 320 1][552.328 250 1]
[553.65 130 1][555.545 190 1][557.69 240 1][563.67 200 1][570.85 160 1]
[570.991 50 0][572.18 100 1][572.768 50 0][585.315 210 1][590.34 490 1]
[591.54 260 1][591.878 120 1][606.29 130 1][609.595 250 1][610.866 210 1]
[611.59 180 1][612.87 230 1][612.94 240 1][613.21 320 1][614 150 1]
[614.323 90 1][614.81 140 1][614.95 190 1][616.115 80 1][616.245 180 1]
[622.428 100 1][622.83 280 1][623.11 140 1][630.48 270 1][636.23 290 1]
[646.9 300 1][654.12 210 1][675.188 190 1][676.59 180 1][678.372 100 1]
[684.744 8 0][689.15 320 1][690.013 4 0][718.29 380 1][725.5 180 1]
[727.65 210 1][730.34 180 1][735.06 320 1][763.27 100 1][768.29 100 1]
[774.07 210 1][777.696 100 1][778.9 180 1][385.282 100 2][402.377 100 2]
[403.232 150 2][406.23 50 2][407.157 100 2][407.293 100 2][425.268 100 2]
[450.958 40 2][524.877 200 2][564.515 100 2][572.317 40 2][581.95 100 2]
[619.772 200 2]]
18000} bind def
%
/wl@elt@Sn {[
[380.102 280 0][384.144 4 1][429.465 1 1][452.474 40 0][457.913 1 1]
[458.029 1 1][487.722 2 1][494.431 3 1][497.973 20 0][507.114 2 1]
[507.267 2 1][517.454 20 0][533.236 10 1][556.195 20 1][558.892 25 1]
[559.62 2 1][563.171 500 0][575.359 15 0][579.72 1 1][579.918 15 1]
[592.544 50 0][597.03 100 0][603.77 150 0][605.486 200 -1][606.9 250 0]
[607.346 100 0][607.748 6 1][607.97 5 1][614.971 400 0][615.46 200 0]
[617.15 150 0][631.078 100 0][635.435 40 0][645.35 70 1][676.145 8 1]
[684.405 25 1][719.14 20 1][738.779 10 1][739.86 20 0][740.862 1 1]
[768.53 30 0][774.18 13 1][775.497 100 0]]
500} bind def
%
/wl@elt@Sb {[
[385.022 20 1][403.355 200 0][403.356 20 1][413.363 20 1][414.054 15 1]
[419.517 15 1][421.907 20 1][431.432 20 1][434.483 12 1][441.142 12 1]
[444.648 12 1][450.692 12 1][451.45 15 1][459.69 30 1][459.909 20 1]
[460.477 15 1][464.732 30 1][467.574 20 1][471.126 40 1][473.544 12 1]
[475.781 20 1][476.536 20 1][476.691 12 1][478.403 30 1][480.201 20 1]
[483.282 20 1][487.724 20 1][494.74 15 1][504.456 15 1][516.632 12 1]
[517.655 15 1][523.894 20 1][535.424 20 1][546.408 15 1][549.032 30 0]
[555.61 40 0][556.813 15 1][560.219 30 0][563.202 100 0][563.975 30 1]
[583.034 60 0][589.509 15 1][600.521 100 1][605.341 20 1][607.98 30 1]
[613.004 50 1][615.494 20 1][630.276 12 1][661.149 20 0][664.744 30 1]
[668.801 15 1][680.667 6 1][764.828 30 0][426.509 40 2][435.216 50 2]
[459.189 30 2][469.291 30 2][524.771 1 2][569.08 1 2][571.73 1 2]
[584.55 3 2][624.67 5 2][628.76 3 2]]
200} bind def
%
/wl@elt@Te {[
[380.092 20 1][390.567 20 1][391.854 20 1][393.149 30 1][394.798 20 1]
[396.922 40 1][397.594 25 1][398.177 20 1][400.652 50 1][401.169 20 1]
[402.973 30 1][404.717 40 1][404.888 30 1][407.348 15 1][410.104 30 1]
[412.732 70 1][416.355 30 1][416.977 100 1][417.929 30 1][421.131 25 1]
[422.573 80 1][424.647 30 1][425.115 20 1][426.111 100 1][426.436 30 1]
[427.343 60 1][428.585 80 1][432.09 40 1][436.128 30 1][436.4 150 1]
[437.712 30 1][438.51 75 1][439.6 60 1][447.863 170 1][453.707 80 1]
[455.778 100 1][463.062 70 1][464.112 100 1][465.437 180 1][468.691 200 1]
[469.638 100 1][470.653 100 1][476.605 100 1][477.156 70 1][478.487 100 1]
[482.714 100 1][483.128 150 1][484.29 150 1][486.512 130 1][486.624 200 1]
[488.522 80 1][490.444 80 1][496.188 60 1][500.082 60 1][508.3 8 0]
[514.87 7 0][544.984 50 1][548.795 50 1][557.635 150 1][564.926 150 1]
[566.62 100 1][570.812 200 1][573.35 7 0][575.585 150 1][578.91 8 0]
[593.615 50 1][597.468 100 1][627.35 8 0][634.97 8 0][636.713 50 1]
[640.59 8 0][645.67 7 0][661.34 8 0][664.858 10 1][666.02 8 0]
[669 8 0][679 10 0][683.76 20 0][685.47 20 0][701.606 10 1]
[703.913 10 1][719.11 15 0][723.662 10 1][726.35 20 0][728.09 8 0]
[728.926 10 1][744.539 10 1][746.098 12 1][746.875 15 1][748.126 10 1]
[755.68 10 0][768.861 6 1][775.91 15 0]]
200} bind def
%
/wl@elt@I {[
[410.223 200 0][412.921 200 0][413.415 100 0][432.184 500 0][445.286 300 1]
[459.977 200 1][463.245 300 1][466.648 500 1][467.553 1000 1][476.331 250 0]
[486.232 1000 0][491.694 200 0][498.692 1000 1][506.537 400 1][511.929 10000 0]
[514.973 200 1][516.12 3000 1][517.619 300 1][521.627 600 1][522.897 500 1]
[523.457 1000 0][524.571 3000 1][526.936 500 1][529.978 400 1][532.28 400 1]
[533.822 10000 1][534.515 5000 1][536.986 1000 1][540.542 800 1][540.736 800 1]
[542.706 600 0][543.583 3000 1][543.8 1000 1][546.462 2000 1][549.15 800 1]
[549.694 1000 1][550.472 1000 1][552.206 600 1][559.852 600 1][560.032 1000 1]
[561.289 1500 1][562.569 10000 1][567.808 1000 1][569.091 2000 1][570.205 500 1]
[571.053 4000 1][573.827 1000 1][576.072 1000 1][576.433 1000 0][577.483 500 1]
[578.702 500 1][589.403 2000 0][595.025 5000 1][598.486 300 0][602.408 2000 0]
[606.893 500 1][607.498 2000 1][608.243 1000 0][612.749 2000 1][619.188 800 0]
[620.486 1000 1][621.31 500 0][624.448 800 0][625.749 900 1][629.398 1000 0]
[631.313 500 0][633.037 800 0][633.35 400 0][633.785 2000 0][633.944 1000 0]
[635.916 500 0][656.649 1000 0][658.375 2000 0][658.527 1000 0][661.966 5000 0]
[666.111 500 0][666.596 600 1][669.729 500 0][671.883 300 1][673.203 400 0]
[681.257 4000 1][695.878 1000 1][698.978 500 0][708.521 200 1][712.005 500 0]
[712.205 1200 0][714.206 2000 0][716.479 1000 0][719.166 400 0][722.73 700 0]
[723.678 1000 0][723.784 500 0][735.135 500 1][740.206 5000 0][741.05 1000 0]
[741.648 500 0][746.899 5000 0][749.052 500 0][755.418 2000 0][755.665 500 0]
[770.02 2000 0][779.898 500 1][396.316 3 2][407.714 3 2]]
10000} bind def
%
/wl@elt@Xe {[
[390.791 100 1][403.759 100 1][405.746 200 1][409.889 100 1][415.804 200 1]
[418.01 1000 1][419.315 500 1][420.848 300 1][420.947 100 1][421.372 300 1]
[421.56 100 1][422.3 300 1][423.825 400 1][424.538 500 1][425.157 100 1]
[429.64 500 1][431.051 500 1][433.052 1000 1][436.92 200 1][437.378 100 1]
[439.32 500 1][439.577 500 1][440.688 200 1][441.607 150 1][444.813 500 1]
[446.219 1000 1][448.086 500 1][452.186 100 1][473.4152 600 0][479.2619 150 0]
[480.702 500 0][482.971 400 0][484.329 300 0][491.651 500 0][492.3152 500 0]
[497.171 200 1][497.271 400 1][498.877 300 1][499.117 100 1][502.828 200 0]
[504.492 200 1][508.062 1000 1][512.242 300 1][512.57 100 1][517.882 100 1]
[518.804 300 1][519.137 400 1][519.21 100 1][526.044 500 1][526.195 500 1]
[529.222 2000 1][530.927 300 1][531.387 1000 1][533.933 2000 1][536.32 200 1]
[536.807 200 1][537.239 500 1][539.28 100 0][541.915 3000 1][543.896 800 1]
[544.545 300 1][545.045 200 1][546.039 400 1][547.261 1000 1][549.486 100 1]
[552.553 200 1][553.107 600 1][556.662 100 0][561.667 300 1][565.938 300 1]
[566.756 600 1][567.091 150 1][569.575 100 0][569.961 200 1][571.61 200 1]
[572.691 500 1][575.103 500 1][575.865 300 1][577.639 300 1][581.596 100 1]
[582.389 300 0][582.48 150 0][587.502 100 0][589.329 300 1][589.499 100 0]
[590.513 200 1][593.417 100 0][594.553 500 1][597.113 300 1][597.646 2000 1]
[600.892 200 1][603.62 1000 1][605.115 2000 1][609.35 600 1][609.759 1500 1]
[610.143 400 1][611.508 100 1][614.645 100 1][617.83 150 0][617.966 120 0]
[618.242 300 0][619.407 500 1][619.826 100 0][622.002 100 1][627.082 500 1]
[627.754 400 1][628.441 100 1][628.601 100 0][630.086 250 1][631.806 500 0]
[634.396 400 1][635.635 600 1][637.528 200 1][639.799 100 1][646.97 300 0]
[647.284 150 0][648.776 120 0][649.872 100 0][650.418 200 0][651.283 300 1]
[652.865 200 1][653.316 100 0][659.501 1000 1][659.556 100 0][659.725 400 1]
[659.884 100 1][666.892 150 0][669.432 300 1][672.801 200 0][678.871 150 1]
[679.037 100 1][680.574 1000 1][682.732 200 0][687.211 100 0][688.216 300 0]
[691.022 80 1][692.553 100 0][694.211 800 1][697.618 100 0][699.088 2000 1]
[708.215 150 1][711.96 500 0][714.75 50 1][714.903 200 1][716.483 500 1]
[728.434 100 1][730.18 200 1][733.93 200 1][738.6 100 0][739.379 150 0]
[754.845 300 1][758.468 200 0][761.857 80 1][764.202 500 0][764.391 100 0]
[767.066 200 1][778.704 60 1][384.15 100 2][387.78 200 2][388.05 60 2]
[392.255 500 2][395.059 300 2][405.007 200 2][406.04 60 2][410.91 100 2]
[414.57 100 2][428.59 30 2][443.42 50 2][446.21 100 2][456.91 100 2]
[457.01 100 2][464.14 100 2][467.37 30 2][468.357 60 2][472.36 30 2]
[475.73 100 2][486.95 40 2][523.9 60 2][536.71 30 2][540.1 50 2]
[552.44 40 2][620.597 60 2][622.17 25 2][623.82 60 2][625.905 60 2]]
3000} bind def
%
/wl@elt@Cs {[
[380.51 500 1][387.016 15 1][387.6143 150 0][388.8608 80 0][389.698 1000 1]
[390.693 350 1][392.558 500 1][395.95 350 1][396.519 500 1][397.8 150 1]
[404.718 350 1][405.396 200 1][406.796 500 1][406.877 500 1][407.336 70 1]
[411.929 60 1][412.121 500 1][413.2 100 1][415.127 350 1][415.861 350 1]
[419.32 60 1][421.313 500 1][422.112 200 1][423.219 500 1][423.441 350 1]
[424.197 100 1][427.174 100 1][427.71 2000 1][428.835 1000 1][429.2 200 1]
[430.064 500 1][430.794 50 1][432.758 50 1][433.024 350 1][436.328 2000 1]
[437.302 500 1][438.443 400 1][438.876 100 1][439.691 200 1][439.95 350 1]
[440.385 350 1][440.525 1000 1][441.021 350 1][442.405 100 1][443.571 350 1]
[444.4 100 1][445.344 200 1][445.768 200 1][445.918 200 1][449.366 100 1]
[450.152 1000 1][450.671 200 1][450.683 100 1][451.55 100 1][452.285 150 1]
[452.672 1000 1][453.894 800 1][455.5276 400 0][456.698 150 1][457.179 150 1]
[459.3169 200 0][460.376 2500 1][460.999 100 1][461.613 150 1][462.309 350 1]
[464.651 500 1][465.654 150 1][467.028 350 1][469.561 100 1][470.179 500 1]
[473.298 350 1][473.966 350 1][474.913 100 1][476.362 500 1][478.636 200 1]
[483.016 800 1][487.002 800 1][495.284 800 1][497.259 500 1][504.38 800 1]
[505.27 500 1][505.987 500 1][508.177 100 1][509.66 400 1][522.7 1500 1]
[524.937 800 1][527.404 400 1][530.661 350 1][534.916 350 1][537.097 800 1]
[541.969 500 1][546.5944 5 0][550.2884 5 0][556.302 1000 1][563.5212 11 0]
[566.4018 30 0][574.5724 8 0][581.418 350 1][583.116 500 1][583.8835 5 0]
[584.5141 30 0][592.565 500 1][601.049 80 0][603.4089 30 0][612.862 400 1]
[621.31 120 0][621.7599 15 0][635.4555 50 0][641.954 100 1][643.1969 15 0]
[647.2623 15 0][649.553 200 1][653.644 200 1][658.602 30 0][658.651 200 0]
[662.866 35 0][672.3284 200 0][682.4652 100 0][687.0455 100 0][695.552 400 1]
[697.3297 200 0][698.3491 35 0][722.8536 200 0][727.99 60 0][727.9957 200 0]
[760.8903 150 0]]
2500} bind def
%
/wl@elt@Ba {[
[381.669 200 1][384.28 200 1][385.476 100 1][388.933 20 0][389.178 1400 1]
[389.265 20 0][390.991 40 0][391.473 500 1][393.572 50 0][393.787 20 0]
[393.967 200 1][394.951 500 1][399.34 80 0][399.566 30 0][403.626 300 1]
[408.377 200 1][408.486 30 0][413.066 1500 1][413.243 20 0][416.6 200 1]
[421.604 500 1][426.795 800 1][428.31 100 0][428.78 300 1][429.76 200 1]
[430.932 800 1][432.3 20 0][432.573 600 1][432.674 200 1][432.962 300 1]
[435.033 80 0][440.254 60 0][440.523 400 1][443.189 40 0][448.898 60 0]
[449.364 50 0][450.592 40 0][450.963 200 1][452.317 60 0][452.493 130 1]
[455.403 65000 1][457.385 40 0][457.964 80 0][459.975 30 0][461.992 20 0]
[462.833 25 0][464.41 300 1][467.362 30 0][469.162 35 0][470.043 20 0]
[470.894 800 1][472.644 40 0][484.346 800 1][484.714 300 1][485.084 200 1]
[487.765 30 0][489.997 400 1][490.29 15 0][493.409 20000 1][494.735 8 0]
[495.715 1000 1][499.781 300 1][501.3 1000 1][515.994 20 0][526.703 20 0]
[536.135 800 1][539.16 1000 1][542.105 200 1][542.455 100 0][542.879 200 1]
[548.03 300 1][551.905 200 0][553.548 1000 0][562.04 20 0][568.018 10 0]
[577.762 400 0][578.418 800 1][580.023 100 0][580.569 20 0][582.628 150 0]
[585.368 2800 1][590.764 15 0][597.17 100 0][598.125 800 1][599.709 100 0]
[599.985 300 1][601.947 100 0][606.312 200 0][611.078 300 0][613.583 400 1]
[614.172 20000 1][634.168 150 0][637.891 500 1][645.085 90 0][648.291 150 0]
[649.69 12000 1][649.876 300 0][652.731 150 0][659.533 3000 0][665.41 150 0]
[667.527 1500 0][669.384 1800 0][676.962 1000 1][686.569 600 0][686.785 300 0]
[687.409 1000 1][705.994 6000 0][712.033 2400 0][719.524 600 0][722.884 600 0]
[728.03 3000 0][739.241 1200 0][741.753 300 0][745.978 900 0][748.808 600 0]
[763.69 450 0][764.291 600 0][767.209 1800 0][778.048 1200 0][392.685 25 2]
[399.306 25 2][405.371 18 2][469.744 15 2][504.955 10 2][509.754 10 2]
[510.225 12 2][513.454 10 2][599.8 10 2][610.199 13 2][637.711 10 2]
[638.376 10 2][652.617 8 2][709.549 8 2]]
65000} bind def
%
/wl@elt@La {[
[383.508 190 1][384.072 600 1][384.6 120 1][384.902 1600 1][385.491 130 1]
[387.164 3400 1][388.637 1700 1][391.605 1300 1][392.154 1100 1][392.756 160 0]
[392.922 2200 1][393.622 180 1][394.91 9000 1][398.852 4400 1][399.575 3600 1]
[401.539 180 0][402.588 250 1][403.169 2800 1][403.721 140 0][404.291 3000 1]
[405.008 320 1][406.033 220 0][406.479 160 0][406.739 850 1][407.671 110 1]
[407.735 2800 1][407.918 120 0][408.672 5500 1][408.961 180 0][409.954 280 1]
[410.487 110 0][412.323 4400 1][413.704 110 0][414.174 550 1][415.197 1100 1]
[415.278 220 1][416.026 100 0][418.732 280 0][419.236 280 1][419.655 1500 1]
[420.404 240 1][421.756 300 1][423.095 200 1][423.838 1600 1][424.999 140 1]
[426.359 320 1][426.95 480 1][427.564 240 1][428.027 300 0][428.697 600 1]
[429.605 600 1][430.044 120 1][432.251 440 1][433.374 4600 1][435.44 550 1]
[436.467 110 1][437.197 110 -1][437.584 110 -1][437.81 110 1][438.344 280 1]
[438.52 100 1][441.824 220 -1][442.317 160 -1][442.39 160 0][442.755 260 1]
[442.81 100 -1][442.99 2000 1][443.298 160 -1][443.801 100 -1][445.215 100 0]
[445.58 100 1][452.237 850 1][452.531 170 1][452.612 420 1][455.846 400 1]
[455.929 110 1][456.791 160 0][457.002 200 0][457.488 400 1][458.006 200 1]
[460.578 160 1][461.339 410 1][461.988 410 1][464.528 110 1][465.55 540 1]
[466.251 360 1][466.376 230 1][466.891 200 1][467.183 160 1][469.25 230 1]
[470.328 140 1][471.644 170 1][471.994 140 1][472.842 230 1][474.028 500 1]
[474.309 390 1][474.873 320 1][476.689 160 0][480.404 160 1][480.901 160 1]
[482.406 200 1][486.091 320 1][489.992 850 1][492.098 1000 1][492.179 1000 1]
[493.483 140 1][494.647 110 1][494.977 370 0][497.039 340 1][498.683 370 1]
[499.128 140 1][499.947 720 1][504.688 140 0][505.057 210 0][505.646 170 0]
[510.623 200 0][511.456 470 1][512.299 470 1][514.542 450 0][515.674 180 1]
[515.743 180 1][515.869 290 0][516.362 120 1][517.731 580 0][518.342 850 1]
[518.822 260 1][520.415 170 1][521.186 720 0][523.427 520 0][525.346 340 0]
[525.939 110 1][527.119 370 0][529.084 140 1][530.198 370 1][530.262 140 1]
[530.355 180 1][534.067 110 1][535.786 110 0][537.709 130 1][538.099 140 1]
[545.515 500 0][550.134 470 0][560.25 110 -1][563.122 160 0][564.825 240 0]
[565.772 130 0][574.066 180 0][574.441 160 0][576.184 160 0][576.907 160 1]
[576.934 370 0][578.924 320 0][579.134 450 0][579.758 220 1][580.578 160 1]
[582.199 140 0][593.062 320 0][624.993 720 0][626.23 260 1][629.609 180 1]
[632.039 160 1][632.591 110 0][639.048 170 1][639.423 450 0][641.099 210 0]
[645.599 250 0][652.699 110 1][654.316 130 0][657.851 140 0][670.95 180 0]
[677.426 120 1][701.122 13 -1][702.367 75 0][703.205 26 0][704.084 26 -1]
[704.596 110 0][705.48 13 -1][706.623 160 1][706.837 65 0][707.079 21 -1]
[707.638 13 0][708.54 21 -1][710.102 26 -1][711.68 10 1][713.158 19 -1]
[714.977 10 0][715.808 40 0][716.125 50 0][716.26 10 -1][721.991 21 0]
[725.716 10 -1][727.009 26 0][727.03 10 0][728.234 110 1][732.091 10 0]
[733.418 110 0][734.534 65 0][737.971 50 -1][738.008 85 -1][738.273 35 0]
[740.352 110 -1][740.375 210 -1][741.134 50 -1][743.428 65 -1][743.436 110 -1]
[744.292 30 -1][746.308 50 0][746.525 50 -1][746.548 95 -1][748.35 75 1]
[749.65 40 -1][749.678 95 -1][749.883 50 0][750.679 30 -1][752.821 19 -1]
[752.839 50 -1][753.359 30 0][753.923 85 0][756.009 35 -1][759.226 35 -1]
[761.294 19 1][762.499 19 -1][766.434 21 0][412.924 3 2][413.743 5 2]
[448.297 200 2][449.905 300 2][514.573 5 2][515.841 8 2][546.781 6 2]
[549.19 55 2][551.172 2 2][551.819 1 2][552.954 45 2][574.409 1 2]
[577.814 200 2][581.345 2 2][587.563 3 2][588.862 55 2][593.271 3 2]
[601.711 2 2][605.584 20 2][611.925 35 2][614.199 120 2][622 55 2]
[634.821 60 2][427.076 2000 3][454.98 1500 3][483.689 500 3]]
9000} bind def
%
/wl@elt@Ce {[
[380.152 2500 1][380.309 800 1][380.811 1000 1][380.921 490 1][381.22 250 1]
[381.585 490 1][381.746 470 1][381.902 300 1][382.39 470 1][383.055 470 1]
[383.108 490 1][383.455 490 1][383.61 270 1][383.854 1100 1][384.376 200 1]
[384.652 220 1][384.81 250 1][384.859 860 1][385.315 860 1][385.418 1200 1]
[385.431 1200 1][385.529 620 1][385.702 390 1][385.764 370 1][386.246 200 1]
[386.813 200 1][387.468 270 1][387.697 620 1][387.836 1100 1][388.245 1500 1]
[388.998 1000 1][389.075 210 1][389.098 210 1][389.511 620 1][389.68 590 1]
[389.827 490 1][389.894 270 1][390.334 200 1][390.434 250 1][390.692 200 1]
[390.729 770 1][390.841 560 1][390.854 390 1][390.931 270 1][391.219 230 1]
[391.244 980 1][391.552 390 1][391.614 390 1][391.764 230 1][391.828 770 1]
[391.981 480 1][392.173 590 1][392.311 560 1][392.464 450 1][393.109 770 1]
[393.137 310 1][393.183 230 1][393.373 310 1][393.809 560 1][394.034 770 1]
[394.097 310 1][394.215 2000 1][394.275 2700 1][394.389 770 1][394.797 310 1]
[395.254 3100 1][395.366 340 1][395.536 310 1][395.606 230 1][395.628 980 1]
[395.827 230 1][395.887 230 1][396.091 770 1][396.45 390 1][396.705 770 1]
[397.168 450 1][397.207 270 1][397.507 270 1][397.865 770 1][398.088 560 1]
[398.289 560 1][398.329 310 1][398.468 770 1][398.944 370 1][399.239 700 1]
[399.291 370 1][399.382 910 1][399.924 2800 1][400.156 230 1][400.377 910 1]
[400.564 370 1][400.759 210 1][401.239 2700 1][401.49 910 1][401.588 250 1]
[401.904 200 1][402.227 240 1][402.449 840 1][402.515 240 1][402.841 840 1]
[403.034 250 1][403.134 840 1][403.767 340 1][404.076 2100 1][404.258 910 1]
[404.521 230 1][404.634 620 1][405.143 210 1][405.199 210 1][405.351 700 1]
[405.499 450 1][406.222 280 1][406.294 230 1][406.728 280 1][406.884 420 1]
[407.181 1100 1][407.292 270 1][407.348 1800 1][407.374 210 1][407.571 1500 1]
[407.585 1500 1][407.624 210 1][407.747 420 1][407.832 530 1][407.852 270 1]
[408.044 270 1][408.122 670 1][408.323 910 1][408.523 450 1][408.736 250 1]
[408.885 230 1][410.177 450 1][410.5 250 1][410.742 510 1][411.038 200 1]
[411.139 250 1][411.537 420 1][411.701 250 1][411.729 200 1][411.759 200 1]
[411.814 770 1][411.902 250 1][411.979 310 1][411.988 310 1][412.083 450 1]
[412.324 510 1][412.349 510 1][412.387 980 1][412.479 510 1][412.737 980 1]
[412.774 250 1][412.807 200 1][413.071 530 1][413.11 480 1][413.38 2700 1]
[413.544 270 1][413.747 270 1][413.765 2000 1][413.81 270 1][413.835 210 1]
[414.24 770 1][414.449 390 1][414.5 670 1][414.623 480 1][414.89 280 1]
[414.979 420 1][414.994 980 1][415.091 420 1][415.197 1400 1][415.313 230 1]
[415.903 450 1][416.352 310 1][416.561 1300 1][416.688 620 1][416.78 250 1]
[416.977 320 1][416.988 320 1][417.67 340 1][418.108 340 1][418.533 340 1]
[418.66 3500 1][418.732 530 1][419.309 560 1][419.328 370 1][419.387 370 1]
[419.634 630 1][419.8 280 1][419.867 280 1][419.872 840 1][420.124 240 1]
[420.294 910 1][420.941 270 1][421.404 370 1][421.759 310 1][422.26 1500 1]
[422.775 770 1][423.174 390 1][423.421 240 1][423.602 200 1][423.992 980 1]
[424.272 390 1][424.589 310 1][424.598 310 1][424.672 390 1][424.868 1100 1]
[425.337 390 1][425.579 620 1][426.343 200 1][427.019 620 1][427.072 390 1]
[427.886 200 1][428.537 280 1][428.866 200 1][428.944 200 1][428.994 2000 1]
[429.607 200 1][429.667 1500 1][429.678 420 1][429.936 590 1][430.033 770 1]
[430.514 420 1][430.672 770 1][430.974 390 1][432.072 560 1][433.045 310 1]
[433.271 310 1][433.623 240 1][433.777 980 1][433.931 340 1][434.979 700 1]
[435.271 560 1][436.466 910 1][437.382 350 1][437.592 530 1][438.217 910 1]
[438.684 700 1][438.801 310 1][439.166 1700 1][439.879 200 1][439.92 510 1]
[441.064 350 1][441.076 350 1][441.69 310 1][441.878 980 1][442.368 200 1]
[442.707 310 1][442.792 480 1][442.844 310 1][442.927 650 1][444.439 480 1]
[444.47 450 1][444.934 770 1][445.073 620 1][446.021 2400 1][446.114 450 1]
[446.341 420 1][446.754 280 1][447.124 1400 1][447.272 450 1][447.936 700 1]
[448.39 700 1][448.691 840 1][449.785 250 1][450.641 100 0][451.586 110 1]
[451.959 100 1][452.308 770 1][452.735 840 1][452.847 840 1][453.249 110 1]
[453.907 110 1][453.975 840 1][454.496 210 1][455.13 250 1][456.028 650 1]
[456.096 310 1][456.236 2100 1][456.584 420 1][457.228 1100 1][458.25 420 1]
[459.112 130 1][459.393 840 1][460.64 420 1][462.49 420 1][462.816 1700 1]
[463.232 170 0][465.051 110 0][465.429 130 1][466.95 110 1][468.013 150 1]
[468.461 270 1][471.4 200 1][471.481 100 1][472.509 110 1][473.352 100 1]
[473.728 310 1][473.953 100 1][474.717 160 1][475.784 110 1][476.877 100 1]
[477.394 230 1][482.255 110 0][484.777 140 0][488.246 180 1][494.344 110 0]
[497.15 130 1][499.463 130 0][500.91 210 0][501.177 100 1][502.287 120 1]
[503.778 120 1][504.085 120 0][504.402 180 1][507.178 120 0][507.535 240 1]
[507.968 470 1][511.27 130 0][511.717 160 1][512.957 170 0][514.757 110 1]
[514.999 100 0][515.969 280 0][516.148 280 0][517.455 190 0][518.746 370 1]
[519.166 210 1][521.192 190 0][522.346 260 0][522.975 180 0][523.292 140 1]
[524.592 260 0][526.571 130 1][527.423 340 1][529.656 130 0][532.808 130 0]
[533.054 190 1][535.353 450 1][539.34 300 1][539.764 150 0][540.923 280 1]
[542.038 110 0][544.924 140 0][546.837 140 1][547.229 140 1][551.208 260 1]
[555.625 110 0][556.497 170 0][556.597 130 0][559.588 100 0][560.128 240 0]
[565.514 190 0][566.996 240 0][567.775 120 0][569.294 120 0][569.699 300 0]
[569.923 370 0][571.903 240 0][577.312 140 0][578.815 120 0][581.292 120 0]
[594.086 230 0][600.018 11 0][600.19 55 0][600.586 55 0][600.62 15 0]
[600.682 55 0][600.737 19 0][601.342 75 0][601.659 23 0][602.42 110 0]
[602.716 15 0][603.126 11 0][603.358 23 1][603.42 35 1][603.441 23 0]
[603.549 35 1][604.339 110 1][604.542 28 0][604.74 55 0][605.18 19 1]
[605.75 23 0][605.8 35 0][606.675 23 0][606.946 19 0][606.948 35 0]
[607.2 35 0][607.661 35 0][607.716 17 0][608.037 17 0][608.128 17 0]
[608.886 19 0][608.896 19 0][609.319 35 0][609.834 45 1][609.98 11 0]
[610.874 28 1][611.856 15 0][611.89 17 0][612.367 45 0][613.2 19 1]
[613.218 19 0][613.545 11 0][613.903 23 0][614.292 15 0][614.336 35 1]
[614.643 23 0][614.784 19 0][615.172 23 0][615.982 19 0][616.214 19 0]
[616.545 19 0][617.528 19 0][618.617 35 0][618.797 15 0][619.523 15 0]
[619.553 19 0][619.805 19 0][620.898 35 0][621.682 11 0][622.894 35 0]
[622.913 19 0][623.245 23 1][623.745 28 0][623.871 13 0][624.187 11 0]
[624.291 13 0][625.365 15 0][625.799 13 0][626.427 15 0][627.205 45 1]
[627.647 15 0][629.558 35 0][629.951 28 1][630.021 23 0][630.664 13 0]
[631.001 35 0][633.54 15 0][633.721 11 0][634.07 13 0][634.395 35 1]
[637.111 35 1][638.684 28 0][639.302 23 1][639.516 11 0][642.529 11 1]
[643.007 35 0][643.439 19 0][643.64 23 0][644.612 19 0][645.803 35 0]
[646.688 19 1][646.739 28 0][647.372 35 0][649.097 17 0][650.327 11 1]
[650.716 11 1][651.359 23 1][651.731 19 0][655.17 19 0][655.565 45 0]
[657.91 23 0][660.635 15 0][660.686 15 1][661.206 22 0][662.3 10 0]
[662.893 30 0][665.089 13 0][665.272 22 1][666.141 10 0][666.559 13 0]
[667.554 10 1][668.66 15 0][670.066 26 0][670.427 35 0][670.452 13 1]
[670.604 10 1][672.871 15 0][672.957 15 0][674.47 15 1][674.69 10 0]
[677.428 30 1][677.559 35 0][677.828 10 0][680.781 18 0][680.882 10 0]
[681.823 15 0][682.973 10 1][684.725 13 0][685.655 12 0][689.366 10 0]
[689.845 10 1][692.481 30 0][693.945 10 0][697.35 19 1][698.382 10 1]
[698.602 30 0][705.451 12 0][705.868 11 1][706 11 0][706.175 35 1]
[706.449 11 0][708.635 35 1][710.504 11 1][711.508 11 1][712.473 10 0]
[714.142 16 0][715.023 19 1][715.167 10 0][715.525 16 0][715.699 16 1]
[718.94 16 1][719.172 10 0][720.156 11 1][720.189 16 0][720.355 10 0]
[721.067 12 0][721.736 19 0][723.571 16 1][723.836 22 1][724.173 12 0]
[725.275 25 0][726.264 12 0][727.79 11 0][729.617 11 0][730.142 19 1]
[731.345 19 1][732.991 25 0][733.468 16 1][734.344 12 0][739.777 25 0]
[740.127 11 0][741.794 12 1][742.47 11 -1][743.308 12 0][743.856 11 0]
[744.444 12 0][747.241 10 0][748.657 16 1][752.746 11 0][752.768 11 0]
[753.373 10 0][755.125 10 0][756.244 12 0][756.286 10 0][756.36 10 0]
[760.31 10 0][761.611 25 1][764.608 12 0][764.788 10 0][768.247 12 0]
[768.917 25 1][773.233 10 0][774.835 16 0][779.77 10 0][393.68 800 2]
[395.71 300 2][416.942 500 2][419.17 300 2][419.483 500 2][421.326 300 2]
[421.713 300 2][428.477 400 2][430.471 300 2][434.635 600 2][438.997 400 2]
[444.832 600 2][448.527 500 2][452.192 1000 2][453.573 1000 2][457.69 300 2]
[462.76 500 2][476.607 300 2][497.645 500 2][565.097 500 2][566.42 1000 2]
[569.108 500 2][571.059 300 2][574.947 500 2][594.983 500 2][596.222 2000 2]
[596.271 500 2][597.956 400 2][598.34 1000 2][600.263 3000 2][603.254 10000 2]
[606.091 10000 2][606.179 500 2][609.735 500 2][609.887 500 2][613.51 500 2]
[628.779 300 2][630.816 500 2][634.175 300 2][694.494 1000 2][773.904 700 2]
[775.827 300 2]]
10000} bind def
%
/wl@elt@Pr {[
[380.03 680 1][380.484 290 1][380.918 140 1][381.184 390 1][381.602 1300 1]
[381.766 120 1][381.828 680 1][381.914 120 1][382.18 310 1][382.318 150 1]
[382.667 120 1][383.072 960 1][383.493 140 1][384.099 480 1][384.234 270 1]
[384.454 150 1][384.659 580 1][385.079 1200 1][385.155 720 1][385.28 960 1]
[385.825 120 1][385.914 110 1][386.545 480 1][386.752 210 1][387.072 210 1]
[387.619 480 1][387.718 1700 1][387.92 270 1][388.047 680 1][388.519 440 1]
[388.934 440 1][389.171 120 1][389.725 190 1][389.884 210 1][390.245 250 1]
[390.805 770 1][391.29 630 1][391.355 310 1][391.476 210 1][391.885 1300 1]
[391.963 420 1][392.053 250 1][392.547 960 1][392.746 480 1][392.929 370 1]
[393.582 370 1][393.83 250 1][394.763 730 1][394.943 900 1][395.351 900 1]
[395.675 380 1][395.944 190 0][396.245 470 1][396.426 560 1][396.481 1600 1]
[396.657 560 1][397.116 500 1][397.167 320 1][397.214 620 1][397.485 320 1]
[398.968 1300 1][399.191 230 1][399.216 340 1][399.479 1600 1][399.583 270 1]
[399.704 560 1][399.796 230 1][399.912 320 1][400.017 620 1][400.47 730 1]
[400.869 1900 1][401.06 620 1][401.539 730 1][402.096 620 1][402.271 470 1]
[402.554 360 1][402.683 230 1][402.9 230 1][402.972 360 1][403.175 730 1]
[403.247 230 1][403.383 960 1][403.433 230 1][403.822 230 1][403.845 730 1]
[403.934 470 1][404.481 1300 1][404.57 230 1][404.663 230 1][404.708 340 1]
[405.113 450 1][405.488 2200 1][405.654 2200 1][405.88 450 1][406.222 230 1]
[406.281 3400 1][406.88 210 1][407.977 500 1][408.098 500 1][408.185 790 1]
[408.334 500 1][408.721 200 1][409.682 560 1][409.84 380 1][410.072 2900 1]
[411.389 270 1][411.846 1700 1][412.915 250 1][413.077 340 1][413.361 200 1]
[414.122 1500 1][414.311 2700 1][414.65 270 1][414.844 270 1][415.65 200 1]
[416.416 1700 1][416.804 270 1][416.945 230 1][417.182 620 1][417.225 730 1]
[417.532 250 1][417.562 250 1][417.863 200 1][417.939 5200 1][418.948 2500 1]
[419.16 560 1][420.117 290 1][420.672 2500 1][420.832 500 1][421.186 320 1]
[421.781 320 1][422.293 3800 1][422.535 3800 1][423.311 320 1][423.615 320 1]
[424.002 270 1][424.101 960 1][424.351 340 1][424.763 840 1][425.44 500 1]
[426.378 270 1][426.909 320 1][427.227 790 1][428.007 470 1][428.242 790 1]
[429.898 450 1][430.361 290 1][430.576 1500 1][432.355 210 1][432.941 270 1]
[433.397 1300 1][433.574 200 1][433.87 360 1][434.43 620 1][434.749 470 1]
[435.04 340 1][435.491 450 1][435.979 410 1][436.833 1200 1][437.162 320 1]
[439.608 270 1][440.36 170 1][440.512 100 1][440.583 430 1][440.882 1700 1]
[441.377 410 1][441.904 160 1][441.965 190 1][442.122 160 1][442.458 160 1]
[442.913 1200 1][443.228 110 1][444.983 730 1][445.19 140 1][445.468 140 1]
[446.597 100 1][446.866 960 1][447.726 140 1][449.646 1100 1][451.015 790 1]
[451.758 200 1][453.415 340 1][453.592 340 1][456.312 200 1][461.208 140 1]
[462.874 270 1][463.228 140 0][463.568 140 0][463.955 200 0][464.349 110 1]
[464.605 140 1][465.15 200 1][466.465 140 1][467.209 270 1][468.78 180 0]
[469.577 290 0][470.807 140 1][470.952 140 0][473.067 180 0][473.669 250 0]
[474.416 100 0][474.692 150 1][476.272 100 1][478.335 110 1][490.699 110 0]
[491.402 140 0][492.46 200 0][493.6 140 0][493.974 320 0][494.03 160 0]
[495.137 380 0][497.575 110 0][501.859 120 0][501.976 200 0][502.696 200 0]
[503.338 100 0][503.441 270 1][504.383 110 0][504.552 320 0][505.34 160 0]
[508.712 180 0][511.038 360 1][511.076 560 1][512.952 410 1][513.344 270 0]
[513.514 270 1][513.981 100 0][515.23 100 1][516.174 200 1][517.39 620 1]
[519.132 200 1][519.443 120 0][519.511 150 1][519.531 200 1][520.655 360 1]
[520.79 150 1][521.905 360 1][522.011 560 1][522.797 110 0][525.973 680 1]
[526.388 180 1][529.202 340 1][529.262 340 1][529.809 230 1][532.276 430 1]
[535.24 200 1][550.15 16 0][550.879 40 1][550.915 65 1][551.163 16 1]
[551.358 55 1][551.512 28 1][551.938 13 1][552.031 20 1][552.279 45 1]
[552.415 28 0][552.591 28 1][552.793 16 0][553.021 13 0][553.116 45 0]
[553.517 150 1][553.837 28 0][553.878 20 1][554.501 55 1][554.833 20 1]
[555.342 11 1][556.146 22 1][556.206 45 0][556.552 13 0][556.691 13 1]
[557.183 45 1][557.461 11 1][557.881 11 0][558.235 13 1][558.402 11 1]
[559.492 22 0][559.729 22 1][560.13 13 1][560.565 90 1][560.668 13 0]
[560.893 28 1][561.022 55 1][562.006 11 1][562.026 20 0][562.189 45 1]
[562.305 110 1][562.445 90 1][563.303 11 0][563.646 22 1][563.879 55 1]
[564.037 16 1][564.316 16 0][564.541 22 1][565.423 35 1][565.984 55 1]
[566.157 35 0][566.219 16 1][566.846 65 0][566.955 45 1][566.999 35 1]
[567.414 16 1][567.703 16 1][568.189 55 1][568.56 13 1][568.652 16 0]
[568.717 22 1][568.844 65 1][568.921 22 1][569.097 55 1][569.59 22 1]
[570.438 22 0][570.761 65 0][571.163 40 1][571.383 22 1][571.608 16 1]
[571.908 45 1][571.963 45 1][572.838 11 0][573.188 40 1][574.713 20 1]
[574.774 11 0][574.795 11 1][575.302 22 1][575.617 90 1][575.94 16 1]
[576.02 22 0][576.916 22 1][576.979 16 1][577.316 45 1][577.591 11 1]
[577.729 16 1][577.928 90 0][578.528 65 1][578.617 65 1][578.829 16 1]
[578.892 16 1][579.086 16 1][579.136 45 1][579.295 22 0][581.058 40 1]
[581.355 16 1][581.517 160 1][581.857 55 1][582.062 40 1][582.136 16 0]
[582.259 55 1][582.372 90 1][583.094 45 1][583.513 40 0][584.465 35 1]
[584.498 40 1][584.713 65 1][585.064 65 1][585.263 45 1][585.444 11 0]
[585.607 45 1][585.69 55 1][585.968 90 1][586.883 80 1][587.383 22 1]
[587.472 35 0][587.81 35 0][587.904 35 0][587.925 80 1][588.472 35 0]
[589.223 55 1][589.422 22 1][590.311 40 1][590.445 45 1][590.867 40 1]
[591.531 11 0][591.597 11 0][592.076 40 0][593.066 40 1][593.633 16 1]
[593.99 160 1][594.072 65 1][594.165 22 0][594.716 35 1][594.976 22 0]
[595.127 55 1][595.176 20 1][595.66 90 1][595.925 13 0][596.218 20 0]
[596.3 28 0][596.782 110 1][597.695 13 0][597.888 13 0][598.119 65 1]
[598.614 40 0][598.714 45 0][599.127 13 0][599.489 13 0][599.606 11 0]
[600.244 29 1][600.633 90 1][600.854 13 0][601.648 55 1][601.78 150 1]
[601.985 28 0][602.572 150 1][604.287 35 1][604.666 55 1][604.926 35 0]
[605.004 28 1][605.088 11 0][605.513 140 0][606.727 13 1][608.581 13 0]
[608.616 28 1][608.752 65 1][609.038 20 1][609.309 28 1][609.628 18 0]
[610.672 22 1][610.908 18 0][611.438 65 1][611.802 22 0][612.215 22 0]
[614.151 35 1][614.823 65 0][615.782 22 1][615.91 13 1][616.118 190 1]
[616.538 18 0][616.594 270 1][618.234 55 1][618.796 13 0][619.745 35 1]
[620.081 35 1][620.563 13 1][621.059 13 0][621.273 22 0][621.806 18 0]
[623.68 20 0][624.105 20 0][624.435 45 1][625.51 35 1][626.255 40 1]
[626.454 18 1][627.466 22 1][627.868 40 1][628.128 110 1][628.902 18 0]
[629.801 11 0][630.205 11 0][630.235 35 1][630.405 16 0][630.523 35 1]
[631.813 11 1][632.236 45 0][634.388 22 0][634.711 28 1][635.098 18 0]
[635.72 22 0][635.903 55 0][636.362 11 1][637.761 16 0][637.859 16 0]
[638.957 11 0][639.199 18 0][639.318 40 0][639.796 45 1][641.069 10 0]
[641.123 55 0][641.368 40 1][641.543 10 0][642.963 45 1][643.184 45 1]
[644.278 7 1][644.391 9 1][645.344 16 0][645.484 9 1][645.618 9 0]
[646.019 9 0][646.772 18 1][647.526 9 1][647.802 35 1][648.655 45 0]
[648.697 9 1][649.175 40 0][649.349 9 0][649.489 11 0][649.711 22 0]
[649.894 18 1][650.072 22 0][650.409 9 0][651.714 8 0][651.879 16 1]
[653.452 8 0][654.047 16 0][655.33 7 0][656.462 22 1][656.677 45 1]
[657.103 7 0][657.8 6 0][658.456 6 1][659.374 9 1][659.548 11 0]
[660.986 15 0][661.667 55 0][661.834 11 1][663.1 7 0][663.206 13 0]
[664.712 14 0][665.683 75 1][667.341 55 1][667.378 75 1][668.751 5 1]
[669.925 4 0][673.679 13 0][674.709 35 0][674.919 19 0][678.499 7 1]
[679.86 55 0][681.176 11 1][681.287 17 1][681.404 13 1][681.761 9 0]
[682.76 35 1][683.05 19 1][684.439 9 0][684.547 9 1][684.659 9 1]
[685.046 17 1][685.277 11 0][687.044 11 0][688.466 7 0][689.271 8 0]
[697.038 8 -1][698.012 8 0][702.151 40 1][702.453 10 0][704.24 13 0]
[704.445 8 1][705.107 7 0][707.999 10 0][709.518 11 0][711.455 20 0]
[711.69 10 0][711.824 11 1][713.733 7 1][715.988 10 0][716.777 7 1]
[718.995 7 0][720.885 10 1][722.77 24 1][723.153 13 0][724.326 7 0]
[725.921 7 0][728.761 7 0][728.919 7 0][732.442 7 0][732.847 7 0]
[734.486 7 -1][740.756 16 1][745.174 20 1][749.559 11 0][749.942 6 0]
[754.102 14 1][757.486 6 0][764.566 20 1][770.498 7 1][772.184 16 0]
[778.616 6 1][381.725 60 2][386.18 60 2][398.051 150 2][400.02 200 2]
[401.836 90 2][402.96 180 2][414.246 90 2][414.448 120 2][414.785 90 2]
[417.215 90 2][417.977 150 2][418.418 180 2][419.701 240 2][421.945 120 2]
[423.145 180 2][427.507 180 2][428.632 120 2][429.827 90 2][430.173 90 2]
[431.634 90 2][435.428 60 2][437.982 90 2][438.147 90 2][440.471 120 2]
[442.11 120 2][443.185 120 2][444.793 150 2][445.014 180 2][445.1 120 2]
[446.102 120 2][446.181 200 2][450.031 300 2][461.202 450 2][462.518 600 2]
[465.416 120 2][471.37 600 2][472.555 300 2][472.821 270 2][474.711 300 2]
[477.183 300 2][477.53 450 2][485.739 600 2][520.851 150 2][526.168 150 2]
[526.444 1000 2][528.47 1500 2][529.999 1500 2][534.002 1500 2][542.77 100 2]
[558.174 100 2][564.68 150 2][576.527 600 2][584.441 1500 2][594.798 200 2]
[595.605 7000 2][599.894 900 2][605.301 1500 2][607.109 900 2][609.002 9000 2]
[616.024 5000 2][616.122 1500 2][619.505 100 2][619.563 2000 2][631.036 200 2]
[636.165 100 2][642.926 300 2][644.474 300 2][650.004 600 2][650.149 300 2]
[657.89 200 2][661.646 100 2][670.67 600 2][672.763 100 2][682.796 200 2]
[685.463 100 2][685.73 200 2][686.68 1000 2][689.906 1000 2][690.352 500 2]
[691.014 7000 2][693.455 150 2][697.096 500 2][697.983 100 2][703.039 5000 2]
[707.521 100 2][707.662 4500 2][708.399 100 2][711.253 500 2][716.564 100 2]
[723.162 250 2][723.826 100 2][724.021 250 2][726.232 100 2][734.069 150 2]
[734.37 350 2][734.975 200 2][735.061 300 2][735.552 100 2][742.648 2000 2]
[742.905 4000 2][746.396 100 2][748.74 250 2][749.32 200 2][751.117 100 2]
[752.911 500 2][754.92 100 2][758.864 150 2][759.641 300 2][762.563 100 2]
[764.834 100 2][767.065 100 2][767.465 200 2][774.234 500 2][774.559 250 2]
[775.431 500 2][775.548 100 2][778.198 3000 2]]
9000} bind def
%
/wl@elt@Nd {[
[380.112 370 1][380.138 200 1][380.23 340 1][380.347 1200 1][380.41 200 1]
[380.536 2500 1][380.555 340 1][380.723 470 1][380.877 540 1][380.906 440 1]
[381.049 580 1][381.106 240 1][381.177 270 1][381.253 200 1][381.473 710 1]
[381.97 240 1][382.247 410 1][382.642 1200 1][382.8 240 1][382.885 540 1]
[382.916 440 1][383.047 510 1][383.654 740 1][383.791 340 1][383.898 1700 1]
[383.951 340 1][384.182 410 1][384.824 1700 1][384.852 1500 1][385.022 470 1]
[385.166 2400 1][385.855 340 1][386.094 270 1][386.252 300 1][386.333 3700 1]
[386.652 240 1][386.681 220 1][386.907 850 1][387.574 240 1][387.587 470 1]
[387.858 1100 1][387.955 1000 1][388.038 780 1][388.078 1200 1][388.159 200 -1]
[388.787 540 1][388.966 370 1][388.993 1300 1][389.058 1300 1][389.094 1300 1]
[389.151 580 1][389.206 470 1][389.463 810 1][389.613 270 1][389.763 440 1]
[390.021 2000 1][390.184 1300 1][390.589 1700 1][390.77 200 1][390.784 510 1]
[391.116 2000 1][391.223 850 1][391.369 340 1][391.513 440 1][391.595 610 1]
[391.765 340 1][391.992 220 1][392.096 1100 1][392.71 510 1][392.926 200 1]
[393.482 610 1][393.611 410 1][393.886 510 1][394.151 2000 1][395.116 2000 1]
[395.22 810 1][395.287 320 1][395.352 320 1][395.745 240 1][395.8 590 1]
[396.221 510 1][396.312 1400 1][396.39 270 1][397.33 1100 1][397.369 740 1]
[397.685 740 1][397.949 740 1][398.236 320 1][398.625 470 1][399.01 1400 1]
[399.174 1000 1][399.468 1100 1][400.05 410 1][400.402 540 1][400.743 410 1]
[401.225 3700 1][401.27 540 1][401.881 370 1][402.087 1000 1][402.134 1000 1]
[402.178 1000 1][402.3 1200 1][402.478 340 1][403.047 410 1][403.182 1200 1]
[403.812 270 1][404.08 3000 1][404.106 200 1][404.359 410 1][404.881 410 1]
[405.115 850 1][405.996 850 1][406.109 4700 1][406.928 1100 1][407.512 710 1]
[407.528 470 1][407.762 240 1][408.023 470 1][408.582 240 1][409.613 270 1]
[409.818 220 1][410.659 200 1][410.908 1400 1][410.946 2500 1][411.048 510 1]
[411.383 300 1][412.388 410 1][413.336 470 1][413.533 510 1][415.608 3000 1]
[415.626 510 1][416.057 340 1][416.8 410 1][417.561 810 1][417.732 2400 1]
[417.864 200 1][417.959 640 1][418.498 250 1][420.56 470 1][421.129 470 1]
[422.025 290 1][422.773 440 1][423.238 1300 1][423.419 250 1][423.524 290 1]
[423.984 290 1][424.738 2000 1][425.244 850 1][425.429 290 -1][426.184 410 1]
[426.671 340 1][427.056 240 1][427.279 340 1][427.509 340 1][428.244 470 1]
[428.257 240 1][428.452 710 1][429.78 270 1][430.358 5400 1][430.445 340 1]
[430.778 200 1][431.452 470 1][432.576 1100 1][432.793 510 1][433.87 540 1]
[435.129 680 1][435.817 850 1][436.638 240 1][436.864 340 1][437.493 470 1]
[438.566 710 1][439.066 250 1][440.083 540 1][441.106 510 1][444.639 580 1]
[445.157 1400 1][445.199 200 1][445.64 300 1][446.299 740 1][450.182 410 1]
[450.659 200 1][451.334 170 1][451.636 250 1][452.725 120 0][454.127 340 1]
[454.261 340 1][455.614 100 1][455.967 170 0][456.322 340 1][457.889 200 1]
[457.932 200 1][458.662 100 0][459.702 200 1][460.382 100 0][460.987 100 0]
[462.194 300 0][462.798 100 0][463.424 510 0][464.11 340 0][464.577 250 1]
[464.64 200 0][464.967 300 0][465.473 200 0][467.056 130 1][468.074 170 1]
[468.345 310 0][468.404 110 0][469.035 110 0][469.644 190 0][470.357 130 1]
[470.654 470 1][470.696 140 0][470.971 190 1][471.559 190 1][471.902 240 0]
[472.435 190 1][473.177 140 0][477.946 120 0][478.941 170 1][479.715 120 1]
[481.134 240 1][482.034 140 1][482.548 350 1][483.228 130 1][484.906 110 1]
[485.902 280 1][486.674 190 0][488.381 350 0][488.91 140 1][489.07 220 1]
[489.107 240 0][489.693 280 0][490.153 120 0][490.184 210 0][490.203 110 1]
[491.341 190 0][491.437 170 1][492.068 330 1][492.453 470 0][494.483 260 0]
[495.478 290 0][495.913 290 1][496.139 150 1][498.994 250 1][503.352 150 1]
[506.373 110 1][507.659 360 1][508.984 150 1][509.28 360 1][510.239 180 1]
[510.521 150 1][510.759 360 1][512.379 340 1][513.06 680 1][513.233 170 1]
[516.514 170 1][518.117 130 1][518.26 120 1][519.145 500 1][519.262 630 1]
[520.012 330 1][521.237 310 1][521.323 150 0][522.505 130 1][522.843 130 1]
[523.42 450 1][523.979 250 1][524.959 720 1][525.082 200 1][525.551 360 1]
[526.948 120 1][527.343 590 1][527.688 150 1][529.167 110 0][529.317 680 1]
[530.228 160 1][530.647 110 1][531.146 220 1][531.982 500 1][535.698 180 1]
[536.147 290 1][537.194 150 1][538.59 110 1][543.153 160 1][545.112 110 1]
[548.57 170 1][550.147 35 0][552.572 45 0][553.382 90 0][553.527 55 1]
[554.324 55 0][554.847 55 1][556.117 55 0][557.55 27 0][557.67 27 0]
[557.77 27 0][558.761 27 0][559.443 240 1][560.143 55 0][560.192 45 0]
[562.054 220 0][563.576 65 0][563.954 45 0][565.357 35 0][566.887 70 1]
[566.977 65 0][567.597 140 0][567.633 55 0][568.853 220 1][568.951 23 0]
[570.157 30 0][570.224 130 1][570.621 80 1][570.828 160 1][571.812 80 1]
[572.683 65 1][572.929 100 0][573.455 23 -1][574.086 70 1][574.919 55 0]
[574.966 27 0][576.733 23 0][577.612 45 0][578.496 45 0][578.822 45 0]
[580.009 45 0][580.402 160 1][581.157 80 1][581.389 45 0][582.037 27 0]
[582.587 70 1][582.674 30 0][584.239 80 1][584.466 30 0][584.595 23 0]
[585.891 55 0][586.708 35 0][586.89 30 0][587.104 27 0][588.329 30 0]
[588.624 23 0][588.791 30 0][592.122 27 0][595.587 27 0][599.476 30 0]
[599.647 27 0][600.767 45 0][603.127 35 1][603.329 27 0][603.424 45 1]
[606.603 55 0][607.17 27 0][607.397 30 0][613.347 23 1][614.928 27 0]
[615.506 27 0][615.783 35 1][616.667 23 1][617.049 35 1][617.859 45 0]
[618.391 27 1][620.824 27 0][622.339 45 0][622.65 27 0][623.85 23 1]
[624.408 35 0][625.749 23 0][625.873 27 1][627.729 23 1][628.579 27 0]
[629.284 23 1][629.707 23 0][631.049 55 0][634.151 27 1][638.207 23 1]
[638.52 65 1][648.569 35 0][663.014 45 0][663.796 35 1][665.057 45 1]
[665.567 30 0][673.779 25 1][674.011 40 1][674.254 25 0][679.037 30 1]
[680.4 30 1][684.672 25 1][690.043 40 1][694.139 24 1][701.08 17 1]
[701.885 8 1][702.092 17 1][702.458 17 1][703.321 10 -1][703.73 35 1]
[705.214 7 1][705.474 7 1][706.147 7 1][706.689 40 1][708.293 8 1]
[708.971 12 1][709.209 12 -1][709.274 12 1][709.294 12 -1][709.398 17 0]
[709.542 20 0][712.935 29 1][714.204 12 1][714.372 10 -1][715.103 8 1]
[715.309 6 0][718.501 6 -1][718.909 10 1][718.942 24 1][719.201 20 1]
[719.9 10 1][722.701 8 0][723.654 15 1][726.164 7 1][728.529 9 1]
[728.856 9 1][729.138 6 1][729.872 7 1][731.681 12 1][732.143 7 0]
[732.312 7 1][733.454 6 0][735.71 6 0][737.404 6 1][738.179 7 1]
[740.131 9 0][740.662 10 1][741.12 6 1][741.818 10 1][742.741 9 1]
[744.871 9 1][748.128 5 1][751.116 12 1][751.373 17 1][751.444 7 1]
[751.602 7 1][752.645 9 1][752.899 12 1][753.826 10 1][754.097 5 1]
[754.7 7 1][757.754 5 1][758.765 7 1][759.075 6 1][760.373 6 1]
[760.592 5 1][761.472 5 0][763.979 9 1][764.6 8 1][766.352 6 1]
[769.656 12 1][771.82 6 1][774.39 4 1][774.892 4 1][775.095 10 1]
[777.306 6 1][779.222 7 1][779.64 6 1][779.732 8 1][779.832 5 1]]
5400} bind def
%
/wl@elt@Pm {[
[380.606 250 1][380.92 300 0][381.093 400 0][381.926 200 1][382.053 300 1]
[383.952 300 0][384.288 200 1][384.298 300 1][384.538 250 1][387.403 300 0]
[387.762 800 1][388.579 300 0][389.097 250 0][389.215 1000 1][389.873 300 0]
[389.978 400 1][390.95 250 1][391.026 1000 1][391.91 1000 1][393.648 800 1]
[394.421 300 1][395.476 300 0][395.774 1000 1][398.074 500 1][399.505 300 1]
[399.896 1000 1][400.996 500 1][401.272 200 1][401.42 250 1][401.934 200 1]
[402.82 250 1][404.536 200 1][405.154 300 1][405.52 600 1][405.656 200 0]
[407.584 600 1][408.531 200 0][408.61 500 1][414.046 250 1][418.574 200 1]
[419.292 300 1][419.47 200 1][422.215 200 1][426.432 300 0][428.437 300 0]
[429.778 600 1][430.389 200 1][430.564 200 0][431.88 400 0][432.592 250 1]
[433.205 200 1][433.654 300 1][433.748 200 1][434.212 300 1][434.772 200 0]
[436.392 350 0][436.964 300 0][438.188 200 1][438.849 400 0][438.876 200 1]
[440.942 400 0][441.247 500 0][441.796 1000 1][443.251 400 1][443.586 250 0]
[443.655 300 0][443.868 300 0][444.541 500 1][444.69 600 1][445.395 800 1]
[445.997 200 1][446.816 250 0][447.148 200 1][447.323 300 1][447.746 200 1]
[447.858 350 0][448.16 300 0][448.505 300 0][449.05 300 0][449.205 250 1]
[450.015 600 1][450.033 350 0][450.684 250 0][450.938 100 1][451.356 100 1]
[451.731 200 0][452.332 200 0][452.52 600 1][452.612 250 0][452.676 250 0]
[452.77 400 0][452.921 800 1][454.006 300 0][454.142 300 0][454.175 450 0]
[454.408 500 0][454.517 200 0][454.978 400 0][455.403 300 0][455.463 200 0]
[455.534 500 0][455.606 200 0][455.703 300 0][455.921 300 0][456.483 100 1]
[456.814 300 0][457.037 200 0][457.215 300 0][457.527 400 0][457.828 300 0]
[457.841 200 0][457.948 300 0][458.114 300 0][458.549 300 0][459.382 200 0]
[459.582 400 0][459.755 800 0][460.025 500 0][460.296 400 0][460.459 400 0]
[460.566 600 0][460.985 500 0][461.587 100 1][461.702 600 0][461.84 200 0]
[461.849 400 0][461.975 500 0][462.157 500 0][462.331 500 0][462.368 700 0]
[462.441 900 0][462.529 500 0][462.76 400 0][463.093 200 0][463.345 600 0]
[464.096 400 0][464.336 700 0][464.376 700 0][464.594 400 0][464.703 600 0]
[465.042 600 0][465.052 500 0][465.341 400 0][465.45 400 0][465.505 500 0]
[465.938 300 0][466.079 500 0][466.326 300 0][466.346 600 0][466.519 400 0]
[467.123 500 0][467.176 400 0][467.442 500 0][467.746 200 0][467.792 500 0]
[467.809 400 0][468.292 700 0][469.68 500 0][469.951 200 0][472.206 250 1]
[472.706 300 0][472.836 900 0][472.868 400 0][473.427 800 0][473.799 200 0]
[473.908 100 1][473.978 200 0][474.513 350 0][475.773 500 0][475.9 800 0]
[476.257 700 0][477.346 700 0][478.129 900 0][479.459 250 0][479.543 200 0]
[479.898 700 0][480.136 900 0][480.954 700 0][481.196 900 0][481.712 400 0]
[482.772 400 0][483.766 800 0][483.892 400 0][483.962 300 0][484.401 200 0]
[485.273 350 0][486.062 400 0][486.074 700 0][486.53 300 0][486.572 500 0]
[486.98 400 0][487.242 700 0][488.702 500 0][489.252 700 0][490.03 400 0]
[490.428 300 0][491.828 400 0][493.299 600 0][495.946 700 0][497.14 100 1]
[499.71 500 0][503.08 200 0][505.831 300 0][506.735 100 1][508.052 150 1]
[508.935 150 1][509.242 200 0][509.483 400 0][509.618 200 0][509.73 150 1]
[510.077 400 0][512.147 250 1][512.734 400 0][512.975 200 0][514.513 400 0]
[514.63 500 0][515.386 400 1][516.971 300 1][517.158 500 1][519.405 300 1]
[520.809 500 1][521.596 150 1][522.512 250 1][523.626 500 1][523.666 300 1]
[524.633 400 1][526.242 150 1][527.064 500 1][529.392 200 1][530.886 100 1]
[531.858 150 1][541.045 200 1][542.454 200 1][542.479 180 1][542.904 150 1]
[546.764 100 1][549.545 150 1][551.642 100 1][553.496 180 1][553.738 200 0]
[554.608 800 1][555.688 120 1][555.839 150 1][556.173 200 1][557.602 800 1]
[564.129 200 1][573.081 200 0][576.816 200 1][577.699 200 0][582.393 500 1]
[586.879 300 1][587.531 200 1][587.876 100 1][589.976 150 1][590.471 250 0]
[590.59 100 0][591.496 125 0][592.717 250 1][593.966 150 0][594.649 400 1]
[595.642 800 0][595.669 200 0][596.008 100 1][596.3 150 1][596.789 400 0]
[597.973 200 0][598.482 200 0][598.713 100 1][599.712 400 0][602.711 200 1]
[603.006 300 0][603.132 400 0][604.339 500 0][605.257 150 1][606.7 100 1]
[606.906 500 0][607.64 100 1][608.541 200 1][610.021 900 0][610.64 400 0]
[611.49 100 1][615.176 400 0][615.953 100 1][616.316 400 0][618.452 100 1]
[620.891 200 1][622.964 500 0][623.779 400 0][626.325 100 1][627.269 400 0]
[628.606 400 0][630.829 500 0][631.42 100 1][632.384 700 0][639.031 500 0]
[642.964 100 1][643.193 500 0][643.657 100 1][648.761 400 0][651.034 400 0]
[651.725 500 0][651.943 200 1][652.045 1000 0][654.22 500 0][655.848 100 1]
[658.639 100 1][659.229 100 1][659.815 900 0][659.866 800 0][660.637 700 0]
[662.523 800 0][662.554 100 1][664.981 700 0][665.905 400 1][666.125 100 1]
[666.168 500 0][666.376 400 0][666.751 800 0][667.747 700 0][668.089 200 1]
[668.555 500 0][668.568 500 0][669.009 150 1][670.033 600 0][670.627 100 1]
[671.467 700 0][671.726 500 0][672.071 500 0][672.75 700 0][674.371 600 0]
[674.991 900 0][675.048 900 0][675.645 200 1][677.229 300 1][677.878 400 0]
[678.309 100 1][679.687 100 1][681.168 200 1][683.33 800 0][684.837 400 0]
[685.858 50 1]]
1000} bind def
%
/wl@elt@Sm {[
[380.089 800 1][380.563 320 1][380.846 420 1][380.975 320 1][380.988 320 1]
[381.043 420 1][381.207 500 1][381.363 480 1][381.463 420 1][382.082 930 -1]
[382.418 530 1][382.62 1600 1][383.029 530 1][383.15 1100 1][383.383 530 1]
[383.448 560 0][383.46 560 1][383.572 370 1][383.894 500 1][384.045 400 1]
[384.35 1600 1][384.751 530 1][384.878 640 1][385.188 420 1][385.33 530 0]
[385.421 2700 1][385.456 480 0][385.59 800 1][385.791 480 1][385.874 400 0]
[386.205 660 1][386.223 350 1][386.524 320 1][387.178 800 1][387.519 400 1]
[387.554 560 1][388.077 800 1][388.138 450 1][388.179 450 1][388.25 320 1]
[388.529 3700 1][388.916 660 1][389.008 610 1][389.121 320 1][389.405 400 1]
[389.698 1600 1][390.342 1300 1][391.744 620 1][392.24 2500 1][392.828 1900 1]
[393.576 470 1][394.187 1300 1][394.324 620 1][394.651 500 1][394.811 740 1]
[395.189 470 0][395.953 370 1][396.3 1500 1][396.604 620 1][396.768 470 1]
[397.053 740 1][397.14 1500 1][397.466 620 0][397.627 960 1][397.643 1000 1]
[397.92 960 1][398.314 740 1][398.668 740 1][398.743 370 1][399 1500 1]
[399.331 740 1][400.346 280 1][400.748 470 1][401.998 280 1][402.323 880 1]
[403.511 740 1][404.168 590 1][404.272 740 1][404.29 880 1][404.411 240 1]
[404.505 560 1][404.616 440 1][404.716 740 1][404.862 210 1][404.981 590 1]
[405.887 440 1][406.354 560 1][406.432 280 1][406.458 1400 1][406.674 810 1]
[406.833 710 1][407.584 810 1][407.665 280 1][408.056 240 1][408.26 410 1]
[408.358 280 1][408.44 220 1][409.227 1000 1][409.405 290 1][410.413 240 1]
[410.728 810 1][410.94 410 1][411.019 280 1][411.39 410 1][411.855 1900 1]
[412.136 410 1][412.251 280 1][412.396 710 1][412.923 280 1][413.514 250 1]
[414.771 320 1][414.983 810 1][415.221 1200 1][415.333 530 1][415.522 560 1]
[416.948 810 1][417.157 410 1][417.802 440 1][418.11 530 1][418.333 210 0]
[418.376 530 1][418.813 1000 1][419.193 410 1][419.945 270 1][420.292 650 1]
[420.305 1100 1][420.613 660 1][420.662 270 1][421.035 660 1][422.066 740 1]
[422.533 1000 1][422.97 740 1][423.457 620 1][423.674 1200 1][423.766 500 1]
[424.47 620 1][424.955 210 1][425.178 250 1][425.639 2100 1][425.858 210 1]
[426.268 1300 1][426.508 500 1][427.968 1200 1][427.994 240 1][428.079 2200 1]
[428.221 710 0][428.283 470 0][428.35 240 0][428.664 350 1][429.218 350 1]
[429.674 1600 0][430.494 320 1][430.901 880 1][431.285 240 0][431.894 1900 1]
[431.953 470 0][432.328 590 1][432.446 240 0][432.902 1800 1][433.002 440 0]
[433.415 1300 1][433.614 880 0][434.586 560 1][434.78 1100 1][435.046 560 1]
[435.21 560 1][436.072 560 1][436.107 220 1][436.204 810 1][436.291 440 0]
[436.345 220 1][436.803 500 1][436.992 210 1][437.346 440 1][437.498 320 1]
[437.824 880 1][438.042 530 0][438.429 290 1][439.086 1600 1][439.335 210 0]
[439.734 290 0][440.117 410 0][440.306 810 1][440.336 410 1][440.933 520 1]
[441.158 290 0][441.758 380 1][441.933 470 0][442.053 1500 1][442.114 960 1]
[442.434 2900 1][442.966 470 0][443.388 1600 1][443.432 1800 1][444.181 530 0]
[444.228 440 0][444.426 710 1][444.515 710 0][445.273 1300 1][445.295 250 0]
[445.463 1200 1][445.852 1000 1][445.929 250 0][446.734 2200 1][447.089 810 0]
[447.243 470 1][447.302 620 1][447.866 740 1][449.911 370 0][449.948 370 1]
[450.338 240 0][450.505 180 1][451.133 120 0][451.183 560 1][451.509 440 1]
[451.963 880 1][452.304 440 1][452.391 650 1][453.38 290 0][453.651 270 1]
[453.795 710 1][453.853 150 1][454.019 290 1][454.206 380 1][454.395 810 1]
[454.483 100 1][455.266 410 1][455.445 270 1][456.043 240 1][456.621 470 1]
[457.769 590 1][458.158 290 0][458.173 440 0][458.483 560 1][459.182 290 1]
[459.354 380 1][459.529 560 1][459.674 240 0][460.418 220 1][460.651 290 1]
[461.544 290 1][461.569 470 1][463.021 150 1][464.224 880 1][464.54 290 0]
[464.668 290 1][464.816 240 1][464.949 380 0][465.513 150 1][466.356 290 0]
[466.94 740 1][466.965 620 1][467.075 470 0][467.46 1100 1][467.691 680 1]
[468.155 210 0][468.718 370 1][468.873 370 0][469.363 130 1][469.934 120 1]
[470.44 530 1][471.306 270 1][471.526 130 1][471.61 730 0][471.707 270 0]
[471.772 210 1][471.833 190 1][471.984 270 1][472.602 130 1][472.842 770 0]
[474.568 470 1][475.072 150 0][476.027 730 0][477.02 110 0][477.415 110 1]
[477.785 190 1][478.31 580 0][478.586 350 0][478.996 160 0][479.158 230 1]
[481.581 430 1][482.957 130 1][484.17 970 0][484.421 310 1][484.776 140 1]
[484.832 270 0][485.436 120 1][488.377 210 0][488.397 730 0][490.497 170 0]
[491.04 630 0][491.325 350 1][491.899 430 0][492.404 110 0][493.81 120 1]
[494.863 170 1][495.237 120 1][496.194 170 1][497.598 170 0][502.844 140 1]
[504.428 400 0][505.276 200 1][506.946 170 1][507.12 540 0][510.022 170 1]
[510.309 260 1][510.448 140 1][511.67 140 1][511.716 510 0][512.214 350 0]
[515.503 360 1][517.274 250 0][517.542 470 0][520.059 250 0][525.192 260 0]
[527.14 400 0][528.291 250 0][532.06 190 0][534.129 110 0][536.836 140 0]
[540.523 130 0][545.3 220 0][546.672 140 0][549.372 230 0][551.21 80 0]
[551.609 230 0][554.895 50 0][555.04 140 0][557.342 45 0][558.82 35 0]
[560.086 50 1][562.179 50 0][562.601 70 0][564.41 85 0][565.986 140 0]
[569.673 120 0][570.62 85 0][571.093 35 0][573.295 50 0][574.335 50 1]
[575.952 45 1][577.377 70 0][577.833 60 0][577.924 45 0][578.193 45 1]
[578.698 70 1][578.838 60 0][580.052 60 0][580.284 65 0][581.489 45 0]
[583.102 45 1][583.637 45 1][586.078 35 0][586.779 65 0][586.861 45 0]
[587.106 35 0][587.421 50 0][589.739 45 1][589.896 50 0][593.89 35 1]
[596.571 65 1][596.882 35 1][598.429 35 0][604.5 50 0][604.539 45 0]
[607.006 50 0][608.412 45 0][609.14 35 0][611.066 45 1][615.956 45 0]
[624.676 45 1][625.654 45 0][625.666 45 1][626.728 100 1][629.182 50 1]
[630.706 35 1][632.747 70 1][642.664 45 1][647.234 45 1][648.452 35 1]
[649.867 35 1][654.276 50 1][656.931 140 1][657.067 35 1][658.521 40 1]
[658.972 110 1][660.183 40 1][660.456 95 1][663.228 40 1][667.151 50 0]
[667.921 70 1][669.355 70 1][672.307 40 0][673.184 120 1][673.406 70 1]
[673.481 40 1][674.147 55 1][677.861 40 1][679 60 1][679.42 95 1]
[684.471 55 1][685.603 75 1][686.093 120 0][686.282 40 1][695.051 30 1]
[695.529 120 1][702.044 90 1][703.673 13 1][703.922 90 1][704.224 90 1]
[704.915 13 1][705.152 90 1][705.497 16 1][707.467 19 0][708.237 90 1]
[708.552 40 1][708.83 26 0][709.116 16 0][709.55 30 0][709.633 16 0]
[710.454 30 0][710.623 19 0][711.596 26 0][711.751 23 1][711.981 26 1]
[712.24 12 1][712.511 23 1][713.18 13 0][713.601 10 0][713.939 12 1]
[714.398 40 1][714.96 85 1][717.267 10 0][718.957 10 1][721.095 9 0]
[721.382 23 0][721.809 26 1][722.007 13 0][723.702 13 1][724.09 60 1]
[725.711 9 1][726.152 9 1][727.925 13 0][728.147 26 1][728.221 8 0]
[728.333 19 1][728.892 16 1][729.023 13 0][730.072 26 1][732.708 13 1]
[733.265 13 0][733.804 8 0][734.73 26 0][737.669 26 1][739.398 13 1]
[744.456 30 0][744.541 26 0][745.303 26 1][747.076 13 0][748.199 26 1]
[750.239 23 1][751.7 10 1][754.142 23 1][754.474 9 0][754.657 10 0]
[756.003 12 1][756.294 19 1][757.095 23 1][757.229 23 1][757.809 19 1]
[758.585 30 1][758.831 23 1][759.801 10 0][760.748 23 1][761.394 12 1]
[763.177 10 1][763.794 23 1][764.509 45 1][764.582 12 0][764.802 19 1]
[765.578 10 1][766.72 19 1][767.249 8 1][767.879 10 1][769.578 10 0]
[771.204 23 1][772.856 30 1][773.626 30 1][774.93 30 1][775.52 23 1]
[779.45 10 0]]
3700} bind def
%
/wl@elt@Eu {[
[380.136 70 -1][380.754 95 1][381.133 120 0][381.55 120 1][381.967 39000 1]
[382.668 120 1][384.423 140 1][386.557 190 0][387.272 45 0][387.727 70 1]
[388.475 150 0][389.678 23 0][390.018 23 0][390.051 70 0][390.71 28000 1]
[391.524 45 1][391.6 45 0][391.729 230 0][391.77 23 1][391.852 40 0]
[391.909 100 1][392.887 40 1][393.048 32000 1][394.156 55 1][394.221 30 1]
[394.294 60 1][394.308 120 1][394.459 30 1][394.567 30 1][394.913 30 1]
[394.96 60 0][395.076 45 1][395.133 55 1][395.575 60 0][395.792 40 1]
[396.361 30 0][396.49 120 1][396.659 150 1][396.718 45 0][397.196 30000 1]
[397.842 60 0][397.963 30 1][398.66 55 0][398.824 40 1][399.393 30 1]
[399.598 55 1][400.371 60 1][401.169 180 1][401.758 150 1][403.919 120 0]
[407.824 45 0][408.538 120 1][409.68 75 1][410.688 60 0][411.204 90 1]
[411.93 45 1][412.728 75 0][412.97 33000 1][413.659 30 1][413.707 40 0]
[414.102 30 1][414.172 60 1][415.152 30 1][415.164 45 1][415.772 30 0]
[417.28 110 1][417.516 30 1][418.222 110 0][419.536 40 1][419.618 40 1]
[420.505 60000 1][422.108 45 1][422.388 40 1][422.74 90 1][422.933 75 1]
[423.245 75 1][423.751 90 1][423.869 45 1][424.474 45 0][424.706 45 1]
[425.38 45 1][427.024 30 1][429.873 150 0][432.936 90 0][432.997 75 0]
[433.061 60 1][433.118 40 0][433.768 90 0][435.509 240 1][436.157 27 1]
[436.947 55 1][437.22 45 1][438.317 75 1][438.788 90 0][440.527 21 1]
[440.707 55 1][441.966 18 1][443.481 120 1][443.556 14000 1][446.497 75 1]
[448.515 24 1][452.257 3000 1][453.559 45 0][459.403 11000 0][460.263 21 0]
[462.722 9800 0][466.188 8300 0][471.359 30 0][474.05 27 0][479.259 45 0]
[482.93 40 0][483.033 60 0][484.047 40 0][484.964 60 0][486.762 110 0]
[488.405 40 0][489.468 90 0][490.086 60 0][490.718 150 0][491.14 180 0]
[495.352 55 0][496.021 55 0][496.255 55 0][497.576 45 0][501.317 180 0]
[502.291 170 0][502.954 110 0][503.355 90 0][506.795 75 0][509.269 75 0]
[509.644 90 0][511.437 170 0][512.477 90 0][512.91 170 0][513.008 90 0]
[513.352 210 0][516.007 270 0][516.67 210 0][519.374 60 0][519.985 200 0]
[520.096 110 0][520.644 120 0][521.51 750 0][522.349 300 0][523.924 120 0]
[526.64 200 0][527.196 390 0][527.248 110 0][528.282 150 0][528.725 55 0]
[528.925 60 0][529.126 120 0][529.368 60 0][529.464 120 0][530.385 90 0]
[535.041 30 0][535.169 75 0][535.284 40 0][535.51 90 0][535.761 540 0]
[536.083 60 0][536.161 120 0][537.694 110 0][539.294 120 0][540.277 450 0]
[540.533 45 0][541.186 45 0][542.107 55 0][542.694 90 0][544.356 40 0]
[545.151 380 0][545.294 260 0][545.762 40 0][547.232 90 0][548.865 120 0]
[549.52 45 0][550.083 15 0][551.052 120 0][552.663 30 0][553.325 30 0]
[554.254 30 0][554.744 200 0][557.033 150 0][557.714 200 0][557.963 75 0]
[558.003 120 0][558.624 90 0][558.683 75 0][559.225 18 0][559.98 18 0]
[560.586 18 0][561.881 40 0][562.244 60 0][563.254 75 0][564.58 210 0]
[565.111 15 0][567.385 60 0][568.11 27 0][568.424 27 0][573.087 60 0]
[573.9 60 0][576.52 330 0][578.369 180 0][579.272 15 0][580.027 60 0]
[581.874 170 1][583.098 600 0][584.577 27 0][586.097 27 0][586.477 15 0]
[587.298 90 1][589.531 15 0][590.297 27 0][590.994 12 0][591.574 75 0]
[592.53 12 0][592.652 27 0][594.272 45 0][595.349 27 0][595.384 27 1]
[595.428 30 0][596.376 90 0][596.607 330 1][596.71 480 0][596.843 15 0]
[597.169 30 0][597.275 170 0][598.047 15 0][598.314 27 0][598.378 27 0]
[599.283 240 0][600.436 60 0][600.561 15 0][601.22 60 0][601.256 110 0]
[601.558 60 0][601.815 420 0][602.315 60 0][602.9 170 0][604.466 60 0]
[604.951 420 1][605.736 140 0][607.558 90 0][607.738 30 0][608.384 240 0]
[609.935 240 0][610.815 60 0][611.878 120 0][612.467 60 0][617.305 330 1]
[617.876 110 0][618.813 260 0][619.507 140 0][620.76 15 0][623.051 15 0]
[623.373 90 0][625.047 55 0][626.225 240 0][626.695 55 0][628.595 15 0]
[629.134 60 0][629.977 170 0][630.341 230 1][631.378 24 0][631.858 15 0]
[633.582 75 0][635.004 120 0][635.589 60 0][636.925 60 0][638.273 55 0]
[638.386 75 0][640.093 120 0][640.611 40 0][641.004 180 0][641.132 140 0]
[642.829 55 0][643.764 830 1][643.993 18 0][645.796 120 0][647.07 12 0]
[648.302 18 0][650.155 45 0][651.959 60 0][652.272 15 0][654.912 8 0]
[656.787 75 0][659.379 45 0][660.355 18 0][664.511 1400 1][668.521 26 0]
[669.396 95 0][670.106 7 0][671.045 12 0][674.488 30 0][678.254 30 0]
[678.748 14 0][680.272 140 0][681.606 35 0][683.43 11 0][684.093 17 0]
[684.483 17 0][684.704 14 0][686.454 360 0][689.821 21 0][690.367 60 0]
[691.017 14 0][691.482 30 0][704.02 120 0][707.454 12 0][707.71 330 1]
[710.648 100 0][716.466 6 0][717.555 30 0][719.481 570 1][721.755 570 1]
[722.468 11 0][725.872 15 0][726.277 30 0][728.153 11 0][729.756 6 0]
[730.117 540 1][731.046 11 0][731.363 12 0][733.618 55 0][734.625 4 0]
[735.665 4 0][736.225 11 0][736.96 55 0][737.022 720 1][738.736 4 0]
[738.916 12 0][740.441 11 0][742.657 300 1][743.659 21 0][747.053 8 0]
[749.1 5 0][752.87 50 0][753.302 5 0][754.732 6 0][758.391 160 0]
[774.257 60 0][774.619 70 0][483.798 10 2][666.635 50 2][722.184 30 2]
[769.044 20 2]]
60000} bind def
%
/wl@elt@Gd {[
[380.129 720 1][380.439 210 0][380.509 210 1][380.552 560 1][381.397 3700 1]
[381.474 430 1][381.664 770 1][381.875 430 1][382.605 350 1][382.733 230 1]
[382.946 230 1][383.18 370 1][383.297 210 0][383.499 330 1][383.691 970 1]
[383.964 1000 1][384.22 1200 1][384.328 1400 0][384.458 1400 1][385.069 3300 1]
[385.097 5100 1][385.245 4300 1][385.556 470 1][386.305 250 1][386.699 1600 0]
[387.357 250 0][387.546 220 1][389.47 1500 1][389.579 450 1][390.24 750 1]
[390.271 300 0][390.429 240 0][390.565 450 0][391.651 2200 1][392.325 450 1]
[393.479 1200 0][393.538 220 0][394.18 450 0][394.263 590 0][394.324 270 0]
[394.362 220 0][394.554 1400 0][395.2 300 1][395.337 590 0][395.767 1200 1]
[395.944 750 1][396.366 220 1][396.628 590 0][396.826 590 1][396.9 750 0]
[396.929 270 1][397.175 450 1][397.271 390 0][397.398 590 1][397.481 300 0]
[397.933 750 0][398.721 450 1][398.784 470 0][399.269 320 0][399.321 220 1]
[399.416 650 1][399.632 700 1][399.776 320 1][400.126 470 1][400.494 260 1]
[400.833 320 0][400.891 300 1][401.38 300 1][401.558 200 0][401.725 300 0]
[401.771 430 0][401.973 300 0][402.233 300 1][402.314 1100 0][402.335 810 0]
[402.761 220 0][402.815 1100 0][403.088 860 0][403.349 700 0][403.54 340 0]
[403.684 260 0][403.733 1400 1][403.79 700 1][404.371 410 0][404.501 1600 0]
[404.684 270 1][404.709 270 0][404.92 270 0][404.943 1300 1][404.986 2200 1]
[405.037 270 0][405.329 810 1][405.364 2600 0][405.472 810 0][405.822 2600 0]
[405.988 650 0][406.13 270 1][406.259 650 1][406.339 1900 1][406.359 540 1]
[406.604 260 0][406.835 520 0][406.874 260 0][407.029 750 1][407.32 650 1]
[407.376 300 1][407.844 1300 1][407.87 2800 0][408.37 520 0][408.556 1500 1]
[408.769 260 1][409.041 650 0][409.271 1100 0][409.372 260 0][409.448 260 1]
[409.861 2600 1][409.89 520 1][410.026 650 0][411.144 390 1][413.037 2200 1]
[413.148 270 1][413.228 1100 1][413.416 750 0][413.71 410 1][414.886 280 0]
[416.273 540 1][416.309 280 1][416.716 280 1][417.554 2400 0][418.425 2400 1]
[419.078 2200 0][419.107 750 1][419.163 750 0][419.768 450 1][420.486 590 1]
[421.2 1300 1][421.502 970 1][421.72 650 1][422.503 320 0][422.585 4800 0]
[422.714 220 1][422.98 220 1][423.878 650 1][424.657 200 1][425.173 1700 1]
[425.337 860 1][425.361 650 1][426.012 810 0][426.209 1600 0][426.66 650 0]
[426.7 470 0][427.417 300 0][428.049 910 1][428.582 430 0][428.612 300 0]
[429.608 540 1][429.717 220 1][429.929 430 0][430.634 1100 0][430.929 260 0]
[431.384 1800 0][431.44 520 0][431.605 520 1][432.052 370 0][432.111 750 1]
[432.557 2600 1][432.712 1900 0][432.958 370 0][433.061 340 1][433.138 240 0]
[434.128 450 1][434.218 910 1][434.43 1000 1][434.646 2200 0][434.662 910 0]
[434.731 220 1][436.977 300 1][437.383 970 0][439.206 280 0][440.186 1400 0]
[440.314 520 0][440.667 260 1][440.825 260 1][440.925 220 0][441.116 520 0]
[441.416 860 0][441.473 700 0][441.903 340 1][442.241 1400 0][443.063 1100 0]
[443.61 240 0][446.474 300 0][446.655 300 1][446.708 520 0][447.413 700 0]
[447.612 860 0][447.88 220 1][448.106 280 1][448.333 220 1][448.47 220 0]
[448.69 280 0][449.713 500 0][449.732 220 0][450.621 430 0][450.633 140 1]
[451.45 140 1][451.966 1100 0][452.282 300 1][452.412 150 0][453.781 910 0]
[454.002 220 1][454.203 300 0][454.8 240 0][455.808 120 1][457.381 130 0]
[457.591 260 0][457.959 280 0][458.129 410 0][458.253 130 1][458.307 410 0]
[458.699 160 0][459.698 220 1][459.791 320 1][459.89 410 0][460.105 340 1]
[460.293 240 0][461.45 520 0][462.442 140 0][463.664 430 0][463.9 110 1]
[464.004 170 0][464.6 170 0][464.764 170 0][464.859 170 0][465.354 430 0]
[467.087 140 0][467.918 170 0][468.004 260 0][468.333 430 0][468.812 140 0]
[469.433 700 0][469.549 170 0][469.742 430 0][470.313 170 0][470.978 200 0]
[472.146 110 0][472.847 150 1][473.26 220 1][473.575 260 0][474.365 410 0]
[474.582 110 0][475.87 320 0][476.074 110 0][476.382 130 0][476.724 470 0]
[478.192 180 0][478.462 300 0][478.675 110 0][480.105 140 1][480.745 220 0]
[482.169 320 0][483.526 130 0][484.81 110 0][486.259 110 0][486.502 170 1]
[487.15 120 0][493.412 280 0][493.861 220 0][495.247 110 0][495.879 130 0]
[501.082 65 1][501.174 55 0][501.504 750 0][502.313 55 1][503.129 65 1]
[503.909 75 0][505.088 65 1][507.374 55 0][508.28 55 0][509.225 95 1]
[509.606 65 1][509.838 130 1][510.094 55 1][510.345 910 0][510.891 180 1]
[512.556 120 1][513.028 65 1][513.559 65 0][513.604 75 0][514.084 85 1]
[514.15 75 0][514.268 75 0][515.584 860 0][515.676 55 1][515.848 75 0]
[516.37 75 0][516.454 55 1][517.628 190 1][518.724 55 1][518.788 55 0]
[519.108 55 1][519.777 410 0][521.049 55 1][521.748 85 0][521.94 280 0]
[522.03 75 1][523.393 130 0][524.687 65 0][525.118 320 0][525.214 120 1]
[525.475 85 0][525.58 140 0][526.878 65 0][527.291 55 0][528.248 55 0]
[528.308 280 0][530.167 280 0][530.276 220 0][530.67 55 0][530.73 280 0]
[532.15 130 0][532.178 280 0][532.732 110 0][532.83 65 0][533.33 170 0]
[533.753 55 0][534.3 300 0][534.513 85 0][534.568 75 0][534.867 200 0]
[535.038 300 0][535.326 240 0][536.166 55 0][536.538 95 0][536.992 95 0]
[537.063 150 0][538.95 85 0][541.32 85 0][541.569 85 0][545.346 65 0]
[558.368 55 1][559.185 55 0][561.791 190 0][562.955 65 0][563.225 110 0]
[564.324 260 0][568.089 55 -1][569.622 390 0][570.135 95 0][570.942 65 0]
[573.386 120 1][574.636 85 0][575.417 85 0][577.602 75 0][579.138 240 0]
[579.68 65 0][580.292 55 0][580.772 55 0][580.922 55 0][581.585 55 1]
[581.951 65 -1][584.047 55 1][585.163 220 0][585.524 55 1][585.622 280 0]
[586.073 55 1][587.726 65 1][588.646 55 0][590.407 55 1][590.456 110 0]
[591.145 170 1][591.355 65 1][591.677 55 0][593.029 85 0][593.684 85 0]
[593.771 65 0][594.095 55 -1][594.278 55 -1][595.16 55 1][595.648 55 1]
[597.725 85 0][598.802 110 0][599.908 85 0][600.096 65 -1][600.187 75 -1]
[600.457 55 1][600.871 55 0][602.113 55 0][608.065 55 1][611.407 430 0]
[618.042 55 1][618.268 110 -1][620.086 110 -1][621.171 110 -1][622.093 110 -1]
[623.162 55 -1][624.166 75 -1][625.212 55 -1][626.264 55 -1][627.3 45 -1]
[628.973 85 1][629.287 30 0][630.515 75 1][630.911 30 1][631.719 27 0]
[633.135 40 0][633.375 17 0][633.634 17 0][634.665 27 1][635.172 27 0]
[636.323 17 0][638.095 40 1][638.219 17 1][640.855 22 0][642.242 22 1]
[642.452 17 0][647.029 19 0][648.011 15 1][653.815 40 0][654.925 22 0]
[656.478 55 0][656.8 10 1][657.38 10 0][659.16 30 0][659.342 15 0]
[661.004 10 1][663.436 50 1][664.008 35 0][664.276 10 0][664.398 30 0]
[664.685 10 0][665.355 10 0][667.956 10 1][668.123 35 1][669.286 10 0]
[670.418 10 1][671.814 14 1][672.783 17 1][673.073 85 0][675.267 50 1]
[675.391 14 1][678.339 14 0][678.633 26 1][678.718 10 0][681.456 12 0]
[681.649 26 0][682.09 17 0][682.825 100 0][684.66 35 1][685.713 30 1]
[686.425 15 0][688.763 21 1][690.073 14 1][691.657 100 0][692.062 21 1]
[692.499 15 1][692.649 21 0][694.598 17 1][695.774 15 1][695.924 15 1]
[696.433 14 0][697.166 15 1][697.635 12 1][697.827 10 1][698.086 26 0]
[698.589 50 1][698.875 10 1][699.192 75 0][699.318 21 0][699.676 60 1]
[700.075 17 1][700.616 45 1][701.66 10 0][703.726 21 1][705.1 14 1]
[705.462 13 1][705.802 10 1][706.809 10 1][707.1 18 0][707.363 18 0]
[709.811 14 0][709.873 14 0][711.677 10 1][711.886 21 1][712.257 35 0]
[713.573 13 1][714.731 18 1][715.828 13 0][716.837 170 0][717.226 21 1]
[718.957 28 1][719.708 13 1][720.141 13 1][722.802 10 0][723.345 25 0]
[725.27 14 1][726.266 28 0][729.135 14 0][731.328 21 0][732.489 18 1]
[737.381 14 0][737.641 14 0][737.727 13 1][738.028 13 0][739.49 13 1]
[743.019 13 0][744.185 35 0][746.436 40 0][756.297 55 0][756.319 10 1]
[758.82 10 0][761.178 10 0][762.196 21 0][765.032 21 0][767.256 25 0]
[767.606 10 0][769.445 13 0][773.35 80 0][774.93 35 0][775.597 10 0]
[776.648 10 1][383.173 300 2][391.024 300 2][401.691 300 2][417.726 600 2]
[427.996 400 2][431.428 300 2][444.591 300 2][468.425 600 2][471.506 600 2]
[478.279 600 2][497.672 250 2][509.17 5000 2][512.406 300 2][534.795 1800 2]
[536.596 3000 2][541.262 1100 2][555.33 4000 2][558.788 3000 2][565.898 3000 2]
[578.696 1800 2][586.209 1500 2][598.785 1500 2]]
5100} bind def
%
/wl@elt@Tb {[
[380.18 330 1][380.685 760 1][383.026 1500 0][383.342 540 0][384.25 920 1]
[384.561 370 1][384.873 3700 1][386.975 450 1][387.417 3500 1][388.334 330 0]
[388.822 480 0][389.464 490 0][389.599 330 0][389.658 330 1][389.789 330 0]
[389.92 2400 1][390.133 1600 0][390.806 480 0][390.914 380 0][390.955 330 0]
[391.543 650 0][391.952 480 1][392.21 300 1][392.274 480 1][392.545 760 1]
[393.524 650 1][393.952 810 1][394.689 650 1][395.836 350 1][397.684 2200 1]
[398.187 1800 1][398.385 300 1][399.94 350 1][400.219 350 1][400.259 970 1]
[400.547 1900 1][401.004 300 0][401.275 760 1][401.326 330 0][401.914 370 1]
[402.047 540 1][402.288 220 0][402.477 370 0][403.166 520 1][403.228 870 0]
[403.303 2100 1][403.622 350 0][403.886 210 0][405.186 300 1][405.287 300 1]
[405.412 430 0][406.037 410 0][406.087 220 1][406.158 1300 0][406.389 220 1]
[406.622 390 1][407.522 260 0][408.124 390 0][408.66 210 0][409.219 210 0]
[409.437 260 1][409.449 260 0][410.39 260 1][410.537 650 0][411.25 300 0]
[411.992 260 0][414.351 280 0][414.441 1100 1][415.853 350 0][416.909 240 0]
[416.932 240 0][417.105 240 0][417.26 240 0][417.282 240 0][417.347 260 0]
[418.621 240 0][418.716 300 0][419.674 390 0][420.1 450 1][420.374 650 0]
[420.649 600 0][421.35 300 0][421.442 300 1][421.509 480 0][421.756 300 0]
[421.916 260 0][422.428 260 0][422.645 480 1][423.189 260 0][423.282 480 0]
[423.535 300 0][425.524 370 0][425.823 480 1][426.366 260 0][426.634 650 0]
[426.969 330 0][427.521 220 0][427.852 760 1][428.513 300 1][428.97 300 0]
[429.836 370 0][429.99 300 0][430.295 240 0][430.718 240 0][431.042 450 0]
[431.156 300 0][431.325 370 0][431.883 2200 0][432.223 600 0][432.583 600 1]
[432.643 3000 0][432.89 240 0][433.212 600 0][433.643 870 0][433.764 600 0]
[433.841 1700 0][434.062 700 0][434.253 430 0][435.32 430 1][435.609 280 0]
[435.681 870 0][436.016 280 0][436.73 220 1][437.202 220 0][438.245 330 0]
[438.823 300 0][439.091 260 0][441.627 200 1][442.019 140 0][442.31 350 0]
[443.272 110 0][443.612 240 0][443.938 110 0][444.804 240 0][446.769 110 0]
[449.307 430 0][450.904 45 1][451.152 150 0][451.296 45 1][451.431 75 1]
[451.972 45 1][452.501 45 1][452.976 45 -1][453.183 45 1][453.413 45 0]
[453.714 45 0][453.723 45 0][454.907 110 0][454.972 45 1][455.045 110 0]
[455.646 110 0][456.224 55 1][456.369 110 1][456.485 30 1][457.319 55 1]
[457.869 210 1][458.484 65 1][459.156 65 1][459.238 45 0][460.41 45 1]
[461.196 30 0][461.592 45 1][461.749 27 0][461.936 30 1][462.632 75 1]
[462.694 95 1][463.207 65 0][463.659 65 0][463.699 30 1][464.1 85 1]
[464.198 210 1][464.531 260 1][464.723 80 0][465.838 60 0][465.873 20 -1]
[466.279 80 0][466.545 50 0][466.94 40 0][467.69 80 0][468.187 70 0]
[468.252 50 0][468.279 25 1][468.863 80 1][469.311 80 1][469.339 30 1]
[470.241 200 1][470.794 110 1][471.607 40 1][472.816 40 1][473.42 60 0]
[473.993 80 0][474.78 70 0][475.253 410 1][475.844 40 1][476.019 40 1]
[476.237 30 1][476.447 25 1][477.836 35 1][477.88 35 1][478.678 180 0]
[478.991 40 1][480.187 30 1][481.377 100 0][483.759 60 1][484.039 25 0]
[484.269 30 1][484.489 30 1][485.481 30 0][485.654 20 1][485.887 30 1]
[487.557 80 1][487.612 25 1][488.115 80 1][489.433 29 -1][491.59 95 0]
[492.409 35 0][492.683 35 0][492.893 50 0][493.179 65 0][497.099 29 1]
[497.142 29 0][497.304 29 0][498.016 29 1][498.056 29 0][499.382 85 1]
[499.584 50 1][499.795 55 0][500.61 29 1][502.216 50 0][502.424 29 1]
[502.465 29 0][503.312 50 0][504.206 50 1][505.43 55 0][506.579 55 0]
[507.825 110 0][508.005 24 1][508.111 24 0][508.912 75 1][508.966 24 0]
[510.109 24 0][510.856 24 0][511.839 35 0][512.018 24 0][513.169 50 0]
[514.108 50 1][514.758 50 0][516.427 24 0][517.013 29 0][517.061 24 0]
[517.651 50 0][517.997 50 0][518.459 50 0][518.613 85 0][518.848 50 0]
[519.886 50 0][520.277 35 0][520.455 40 0][520.797 40 0][521.428 40 0]
[522.199 40 0][522.812 120 0][523.511 40 0][524.871 75 0][526.211 75 1]
[527.503 24 0][528.105 75 0][530.472 65 0][530.819 29 0][530.946 29 0]
[531.923 110 0][533.104 35 0][533.79 65 0][533.859 35 0][534.783 24 1]
[535.488 160 0][536.972 75 0][537.598 75 0][540.206 29 1][541.365 29 0]
[541.62 29 0][542.41 50 1][542.643 29 0][544.338 35 0][545.7 29 0]
[545.981 55 0][547.034 29 1][548.145 24 0][550.961 55 0][551.454 50 0]
[552.412 65 0][552.562 24 0][556.593 35 0][563.88 29 0][568.574 29 1]
[568.648 40 0][574.758 85 0][576.266 24 0][578.518 24 1][579.564 75 0]
[580.313 75 1][581.536 65 0][584.297 29 0][585.107 65 0][587.062 65 0]
[589.884 35 0][590.24 24 0][590.471 35 0][592.078 65 0][593.938 50 0]
[594.017 35 0][595.117 24 0][596.734 75 1][603.897 29 0][603.938 29 0]
[610.429 24 1][629.243 24 0][633.168 35 1][633.491 24 1][644.687 24 1]
[651.868 35 0][657.404 24 1][658.182 35 0][660.717 30 1][667.794 90 1]
[670.261 40 0][670.679 20 1][678.512 30 1][679.458 130 1][687.418 40 1]
[689.637 55 1][689.995 45 0][690.198 40 0][700.599 9 1][708.285 17 1]
[708.922 11 1][711.269 11 0][718.748 10 0][719.589 10 1][720.428 65 0]
[723.498 19 0][725.773 40 0][731.157 17 0][734.888 45 1][739.827 10 1]
[742.424 15 1][742.962 10 1][747.215 9 0][748.454 22 0][749.545 9 0]
[749.612 45 0][749.969 17 1][751.14 27 0][751.977 9 1][755.759 6 1]
[758.203 27 1][758.749 27 0][759.024 45 0][759.644 65 0][760.118 17 1]
[761.601 17 1][762.405 22 0][762.781 30 0][763.905 9 1][767.272 8 1]
[769.474 8 1][770.616 22 1][772.697 22 1][773.763 30 0][779.32 22 0]]
3700} bind def
%
/wl@elt@Dy {[
[380.414 510 1][380.627 580 1][381.227 470 0][381.367 470 1][381.676 1400 1]
[382.568 700 1][383.65 2300 1][384.089 370 0][384.131 1400 1][384.2 330 1]
[384.436 330 0][384.634 420 1][384.702 420 0][384.939 330 1][385.303 1200 1]
[385.84 420 0][386.658 370 1][386.845 560 1][386.881 1600 0][386.942 300 1]
[386.986 820 1][387.211 7000 1][387.399 1200 1][387.911 470 1][388.199 300 1]
[389.853 5800 1][391.487 540 1][391.559 540 1][391.729 540 0][392.338 320 1]
[392.786 420 0][393.014 540 0][393.152 2100 1][393.222 320 1][393.3 370 1]
[393.421 320 1][393.67 420 0][394.253 540 1][394.468 10000 1][394.693 420 1]
[395.039 540 1][395.455 420 1][395.779 800 1][396.259 370 0][396.751 320 0]
[396.839 14000 1][397.857 2700 1][398.192 1400 1][398.365 1600 1][398.421 800 1]
[399.132 540 1][399.669 1600 1][400.045 8000 1][400.584 420 0][400.607 320 0]
[401.129 540 1][401.382 540 0][401.47 540 1][402.371 370 0][402.778 420 1]
[402.832 520 1][403.247 520 1][403.365 420 1][403.632 420 1][404.198 320 1]
[404.597 12000 0][405.056 1600 1][405.514 520 1][407.312 2500 1][407.796 7400 1]
[408.534 370 0][409.61 390 0][410.33 3900 1][410.387 860 0][411.134 1500 1]
[412.463 490 1][412.824 390 1][412.912 350 0][412.942 990 1][413.035 350 0]
[413.385 390 0][414.15 470 1][414.31 1200 1][414.606 990 0][416.797 5700 0]
[417.193 370 0][418.372 930 0][418.682 12000 0][419.094 320 0][419.164 2200 0]
[419.484 6800 0][419.519 320 1][419.802 800 0][420.13 680 0][420.224 680 0]
[420.506 230 0][420.654 370 1][421.124 440 0][421.172 16000 0][421.318 1800 0]
[421.516 3700 0][421.809 4400 0][422.111 4400 0][422.221 540 0][422.516 2700 0]
[423.202 680 0][423.985 680 0][424.591 440 0][425.633 440 1][427.669 250 0]
[429.493 370 1][430.863 1000 1][432.586 320 0][435.844 200 1][437.424 320 1]
[437.476 320 1][440.938 540 1][444.458 150 0][444.97 740 1][445.56 110 1]
[446.814 250 1][452.758 100 0][454.166 100 1][456.509 140 0][457.778 420 0]
[458.936 2100 0][461.226 990 0][461.383 50 0][461.482 50 0][461.726 60 1]
[462.003 140 1][466.272 50 0][466.466 110 1][467.36 85 1][468.203 50 1]
[468.975 50 1][469.868 95 1][472.122 85 0][472.713 70 1][473.184 170 1]
[474.573 40 1][475.499 60 1][476.004 50 1][477.194 60 0][477.48 50 0]
[477.579 120 0][478.692 75 1][479.129 95 0][480.064 29 0][480.794 50 0]
[481.028 40 0][481.28 50 0][481.904 75 0][482.496 85 0][482.888 75 0]
[482.968 50 1][483.238 70 0][483.375 35 1][484.175 75 0][485.624 40 1]
[486.805 40 1][487.593 40 0][488.016 85 0][488.455 40 0][488.808 95 0]
[488.933 40 1][489.01 75 1][489.368 50 0][489.924 24 0][491.641 55 0]
[492.222 50 1][492.316 65 1][495.734 480 1][495.959 24 0][497.357 28 0]
[498.552 40 0][500.387 50 0][500.428 55 1][501.06 24 0][501.798 24 1]
[502.212 70 0][502.403 30 0][502.454 24 0][502.787 40 0][503.3 50 0]
[504.263 160 0][504.725 24 0][505.021 50 0][505.335 30 0][505.546 24 0]
[507.068 95 0][507.767 120 0][509.038 80 1][511.032 80 0][512.004 130 0]
[513.502 30 0][513.96 190 1][516.103 40 1][516.412 40 1][516.534 50 0]
[516.969 110 1][517.29 20 1][518.53 80 0][518.845 40 1][519.286 290 1]
[519.766 95 1][524.694 50 1][525.988 70 0][526.056 130 0][526.33 55 -1]
[526.711 65 0][527.225 50 1][527.529 50 1][527.97 50 1][528.207 55 0]
[528.499 28 1][529.782 40 1][530.158 160 0][530.902 40 1][532.469 50 0]
[533.743 24 1][534.03 65 0][535.211 30 0][536.82 30 1][538.563 20 1]
[538.958 85 1][539.557 40 0][539.826 20 -1][539.993 24 1][540.419 50 0]
[541.913 80 0][542.332 70 0][542.427 30 0][542.67 40 1][544.334 30 1]
[545.111 95 0][545.547 30 1][546.91 24 1][549.683 28 0][550.279 24 0]
[550.652 28 0][551.541 24 1][552.801 30 0][554.727 65 0][560.065 40 1]
[560.553 24 0][561.323 30 0][562.749 20 0][563.95 100 0][564.599 55 0]
[565.201 80 0][568.558 24 0][569.367 28 -1][569.41 24 -1][569.454 28 -1]
[569.872 28 1][570.291 24 0][571.846 70 0][572.584 28 -1][572.864 55 -1]
[573.873 24 -1][574.02 50 0][574.553 55 0][575.048 24 0][575.879 24 0]
[583.201 80 -1][583.385 55 -1][583.486 40 -1][584.441 28 -1][584.565 24 -1]
[584.805 40 -1][585.556 40 -1][586.811 55 1][591.516 40 1][592.456 20 1]
[594.58 70 0][596.446 50 0][597.449 120 0][598.486 24 0][598.856 140 0]
[600.575 24 -1][600.654 24 -1][600.697 24 -1][600.894 30 0][601.082 65 0]
[601.726 24 0][603.098 24 0][604.249 24 -1][605.818 24 0][608.506 30 0]
[608.826 140 0][612.715 24 0][613.364 24 0][615.828 24 0][616.843 100 0]
[619.623 20 1][625.909 270 0][626.036 30 0][634.332 14 0][638.68 40 0]
[639.66 24 1][642.192 50 0][643.655 13 0][646.083 8 0][646.858 10 1]
[647.491 11 0][648.359 20 1][648.659 28 0][655.802 20 0][657.937 160 0]
[659.414 14 1][664.337 15 0][665.836 22 0][666.164 29 0][666.786 75 0]
[670.064 10 1][674.793 29 0][675.762 10 0][676.589 45 0][681.82 12 0]
[683.542 180 0][685.296 80 0][685.646 22 0][688.883 22 0][689.797 15 1]
[689.932 65 1][690.653 22 1][692.955 15 0][695.028 29 1][695.142 11 0]
[695.808 40 0][698.244 13 0][699.13 13 0][699.81 45 0][701.742 20 0]
[705.595 35 1][707.514 24 1][710.926 17 1][712.081 11 1][717.511 13 1]
[721.327 11 0][723.004 17 0][725.001 13 0][734.513 17 1][737.023 11 1]
[737.604 20 0][740.759 11 0][741.237 24 0][742.686 55 1][745.705 20 1]
[751.661 17 1][754.373 55 0][755.3 17 0][755.978 27 0][756.296 40 1]
[757.746 20 1][759.13 27 0][761.155 13 0][761.77 11 0][764.109 35 0]
[764.586 17 0][764.664 13 0][766.236 80 0][766.678 11 1][771.533 35 0]
[772.976 45 1][775.162 20 1]]
16000} bind def
%
/wl@elt@Ho {[
[381.073 8900 1][381.186 490 0][381.325 900 1][382.173 300 1][382.927 390 0]
[383.19 320 1][383.535 410 1][383.751 1300 1][384.205 410 1][384.386 1100 1]
[384.673 490 1][384.988 300 0][385.24 320 1][385.407 1800 1][385.694 390 1]
[385.772 720 1][386.168 2700 1][386.262 540 0][387.205 360 1][387.409 320 1]
[387.468 630 1][388.161 540 1][388.896 3000 1][389.042 490 0][389.102 13000 1]
[389.676 540 1][390.223 290 1][390.444 320 0][390.568 1300 1][391.18 320 0]
[391.945 320 0][393.644 320 1][393.885 220 0][394.053 320 1][395.056 220 0]
[395.573 580 0][395.951 230 1][395.968 490 0][397.588 220 0][397.693 390 0]
[398.571 220 1][399.373 220 1][399.958 380 0][400.259 160 1][400.339 220 0]
[401.35 110 0][401.42 320 1][401.809 160 1][402.276 160 1][402.394 160 1]
[402.539 110 0][402.721 320 0][402.886 270 0][403.18 180 0][403.762 220 0]
[403.887 220 1][404.081 2700 0][404.544 5400 1][404.752 220 0][405.393 8100 0]
[405.448 540 1][405.755 270 0][406.031 220 0][406.509 1700 1][406.757 170 0]
[406.805 720 0][407.183 270 0][407.313 270 0][407.351 290 0][408.023 120 1]
[408.367 230 0][408.509 140 0][408.735 170 0][408.759 200 0][409.164 140 0]
[409.478 120 0][410.022 230 0][410.384 8900 0][410.504 120 0][410.65 270 0]
[410.736 100 0][410.862 2900 0][411.2 300 0][411.272 100 0][411.673 270 0]
[412.02 1500 0][412.565 1300 0][412.716 4300 0][413.454 300 0][413.622 1500 0]
[413.934 130 0][414.219 230 0][414.897 290 0][415.261 980 1][416.303 8100 0]
[417.223 160 0][417.323 2500 0][419.435 540 0][419.808 100 0][420.321 130 0]
[421.13 100 1][422.229 290 0][422.347 290 0][422.704 2000 0][422.952 390 1]
[423.124 130 0][424.378 290 0][425.443 1300 0][425.861 130 1][426.405 490 0]
[426.604 300 0][427.363 100 1][431.104 200 0][433.064 250 1][433.713 300 1]
[434.684 100 1][435.073 1300 0][435.673 290 1][436.393 140 1][437.914 170 1]
[438.483 180 1][440.055 150 1][440.124 120 1][440.327 180 0][442.056 200 1]
[444.463 130 0][447.359 100 1][447.764 300 1][448.457 120 1][451.082 140 0]
[452.614 100 1][453.008 170 1][453.128 170 0][453.165 130 1][453.458 170 0]
[456.252 200 0][460.932 120 1][461.337 130 0][461.884 100 0][462.822 100 0]
[462.91 290 1][464.977 200 1][466.133 130 1][467.462 140 1][470.117 70 1]
[470.169 80 1][470.984 130 1][471.139 65 0][471.752 130 0][472.872 35 1]
[473.8 35 1][474.204 290 1][474.909 35 1][475.14 35 0][475.701 100 0]
[476.239 35 1][476.357 35 1][477.748 55 1][477.942 30 0][478.119 70 0]
[478.292 65 0][478.629 55 0][479.148 35 1][479.592 35 1][479.887 45 0]
[481.292 27 1][483.231 55 1][483.332 30 0][485.554 30 1][486.039 45 0]
[488.967 27 1][489.235 30 0][489.644 35 1][490.699 55 1][492.273 45 0]
[493.489 55 0][493.901 290 0][494.68 27 0][494.818 45 1][495.942 65 1]
[496.103 35 1][496.673 55 1][496.721 250 1][497.997 220 0][498.896 35 0]
[499.505 90 0][501.242 35 0][501.328 55 1][502.653 65 0][502.817 30 0]
[503.295 55 1][503.76 65 0][504.237 130 0][504.473 35 0][505.144 30 1]
[505.492 30 1][506.075 35 0][507.434 65 0][509.307 80 0][512.781 140 0]
[512.927 55 1][514.259 130 1][514.322 110 1][514.959 160 1][516.788 90 0]
[518.211 130 0][518.785 55 0][519.011 90 1][519.523 18 0][522.154 45 0]
[524.447 35 0][525.182 65 0][527.548 55 0][530.125 90 0][531.924 35 0]
[531.965 35 0][533.011 80 0][535.999 90 0][538.14 55 0][538.456 30 0]
[538.497 30 0][539.385 18 0][540.317 70 0][540.708 100 0][541.362 14 1]
[543.439 16 1][543.587 18 0][544.539 30 0][544.98 18 1][545.19 30 0]
[545.4 14 1][549.857 30 0][550.451 30 0][551.556 27 1][551.645 18 1]
[553.433 30 0][555.314 27 0][556.094 35 0][556.36 35 -1][556.652 70 0]
[557.396 18 1][558.47 35 -1][559.11 55 -1][559.23 55 -1][560.71 30 -1]
[561.364 27 0][562.64 45 -1][562.76 65 0][562.824 30 1][564.062 55 0]
[565.59 70 -1][565.89 65 -1][565.958 140 0][567.184 70 -1][567.47 65 0]
[569.147 140 0][569.63 70 -1][569.657 140 0][573.402 27 0][573.64 45 -1]
[573.924 55 0][574.958 22 0][576.664 30 -1][580.38 27 -1][581.92 45 -1]
[582.19 27 0][583.947 22 0][584.94 45 -1][586.028 140 0][586.442 27 0]
[587.085 45 0][587.96 27 -1][588.299 70 0][589.256 35 0][590.429 22 0]
[592.176 70 0][593.371 30 0][594.803 70 0][595.598 45 0][597.276 70 0]
[597.352 90 0][598.143 22 0][598.29 230 0][600.204 55 0][600.533 27 0]
[602.143 35 0][603.897 16 0][605.071 27 0][606.031 45 0][608.179 120 0]
[613.36 70 0][615.638 35 0][615.658 27 0][619.168 55 0][620.865 70 0]
[623.417 18 0][625.575 45 0][630.536 70 0][630.668 22 0][632.194 30 -1]
[635.435 30 0][637.259 30 0][637.386 14 0][641.341 22 0][647.177 27 0]
[647.917 13 0][651.53 11 0][653.899 11 0][655.097 70 0][656.008 15 0]
[660.058 35 0][660.494 260 0][660.747 55 0][662.835 13 0][662.899 120 0]
[663.224 15 0][665.298 9 0][666.252 15 0][668.046 19 0][668.162 24 0]
[668.202 15 -1][669.432 55 0][672.234 15 0][674.505 40 0][676.674 13 0]
[677.468 28 0][678.543 55 0][679.37 13 0][681.104 13 0][682.038 15 0]
[682.164 24 0][682.572 17 0][682.662 8 -1][685.297 8 -1][686.585 17 0]
[688.336 9 0][688.85 13 0][689.296 15 0][689.795 17 0][690.38 15 0]
[691.347 15 0][691.67 9 0][693.949 40 0][695.039 45 0][695.53 13 0]
[697.67 19 1][698.511 10 -1][699.438 9 -1][700.071 14 -1][707.907 10 -1]
[709.858 12 -1][724.208 9 0][725.06 9 0][730.855 14 -1][734.143 25 -1]
[738.94 18 -1][749.62 5 0][751.074 10 0][755.509 140 0][758.92 18 0]
[759.187 25 0][759.364 9 0][759.435 7 0][760.231 12 1][760.535 16 0]
[761.705 12 0][762.798 14 0][762.842 40 0][764.114 9 0][764.816 4 0]
[765.38 14 0][766.73 12 0][769.043 20 0][769.315 50 0][771.506 40 0]
[771.905 16 0][773.898 16 0][775.201 8 0]]
13000} bind def
%
/wl@elt@Er {[
[381.033 1600 0][383.048 3600 1][384.991 540 0][385.16 320 1][385.59 680 0]
[385.839 540 1][386.285 7500 0][388.061 1500 1][388.289 1200 1][389.061 400 1]
[389.268 4200 0][389.623 5200 1][390.276 810 1][390.398 250 0][390.456 250 1]
[390.54 1200 0][390.631 11000 1][391.805 280 0][391.835 210 1][392.188 280 1]
[393.225 810 1][393.701 3200 0][393.863 2100 1][394.442 3200 0][394.806 550 0]
[395.148 250 0][395.642 320 0][396.635 280 0][397.304 2700 0][397.358 3200 0]
[397.472 1400 1][397.673 280 0][397.702 810 0][398.233 1100 0][398.753 280 0]
[398.766 810 0][399.115 230 0][400.405 230 0][400.796 14000 0][400.818 230 1]
[400.916 280 1][401.258 1100 0][401.557 350 1][402.051 3000 0][402.155 450 0]
[404.301 230 1][404.696 1000 0][404.834 280 1][404.949 200 1][405.547 940 1]
[405.951 550 0][405.978 690 1][407.788 420 0][408.124 550 1][408.763 3500 0]
[409.29 210 0][409.81 1100 0][410.056 350 1][411.636 320 0][411.855 320 0]
[413.15 600 0][414.291 550 1][415.111 6900 0][418.998 280 1][419.07 1000 0]
[420.532 130 0][421.843 1400 0][422.099 200 0][423.02 320 1][423.478 140 1]
[425.194 200 1][427.648 140 1][428.656 690 0][429.891 320 0][430.16 320 1]
[430.381 140 1][431.994 110 1][432.881 130 0][433.136 110 0][434.092 140 0]
[434.834 190 0][436.939 110 1][438.217 160 0][438.47 300 1][438.64 300 0]
[440.317 100 1][440.934 810 0][441.87 180 0][441.961 570 1][442.251 110 1]
[442.457 320 0][442.677 370 0][443.766 110 0][445.924 100 1][447.35 100 1]
[449.639 130 0][450.075 200 1][452.274 130 0][456.326 160 1][460.661 1000 0]
[463.088 160 1][464.06 110 1][466.544 110 1][467.316 310 0][467.562 570 1]
[467.906 150 1][472.269 230 0][472.905 150 0][475.152 130 1][475.965 170 1]
[482.035 190 1][485.744 140 0][487.209 150 1][490.008 210 1][493.411 210 1]
[494.436 130 0][495.174 180 1][497.642 130 0][500.725 250 0][502.833 140 0]
[502.891 120 1][503.594 200 0][504.205 210 1][504.386 130 0][504.489 130 0]
[507.759 130 1][512.456 120 0][512.741 130 1][513.153 120 0][513.383 130 1]
[516.477 170 1][517.278 130 0][518.89 160 1][520.652 150 0][521.291 60 1]
[521.513 30 1][521.826 30 1][522.934 45 1][525.593 140 1][525.647 22 1]
[525.702 27 1][526.477 35 1][527.291 80 0][527.771 55 0][527.934 27 1]
[530.23 45 1][533.306 55 0][533.333 27 1][533.423 27 1][534.394 22 1]
[534.45 30 1][534.806 90 0][535.047 45 0][536.885 35 0][539.587 35 1]
[541.463 60 1][542.281 18 1][545.13 18 0][545.427 35 1][545.662 180 0]
[546.243 35 1][546.832 90 0][547.747 18 1][548.597 80 1][549.744 27 1]
[551.602 27 0][559.346 80 0][560.114 45 0][560.994 45 0][561.182 60 0]
[562.201 70 0][562.653 80 1][563.62 30 0][564.036 90 0][564.142 22 0]
[565.863 22 1][566.495 70 0][566.544 45 1][567.548 55 0][569.553 14 1]
[571.087 27 1][571.748 55 0][571.955 70 0][572.697 55 0][573.343 22 1]
[573.656 22 0][573.694 22 0][573.919 100 0][574.061 35 0][574.865 60 0]
[575.253 55 0][575.763 70 1][576.28 290 0][576.992 70 0][578.282 45 0]
[578.466 70 0][579.115 22 1][580.079 70 0][580.61 22 0][582.679 430 0]
[583.584 45 0][585.007 100 0][585.531 120 0][587.235 140 0][588.114 120 0]
[588.63 27 1][590.208 27 1][590.606 55 0][590.924 45 0][593.35 35 0]
[594.637 22 0][596.868 55 0][597.549 27 0][600.679 35 1][600.875 22 1]
[601.483 55 0][601.574 35 1][602.256 70 0][603.212 22 1][604.563 22 1]
[604.814 22 1][605.485 45 0][606.125 70 0][607.645 60 1][611.601 35 0]
[612.532 35 0][617.006 30 1][618.321 27 1][622.102 360 0][623.09 35 0]
[626.256 55 0][626.793 45 0][626.887 60 0][627.494 35 0][628.686 30 0]
[629.942 45 0][630.877 130 0][632.613 55 0][634.716 22 1][638.819 45 0]
[643.253 22 0][648.587 27 0][649.235 55 0][654.157 22 0][658.348 60 0]
[660.111 70 0][672.191 27 0][675.987 70 0][676.292 22 0][677.337 27 0]
[679.092 35 0][682.544 22 0][682.598 22 0][684.81 70 0][686.513 55 0]
[687.998 27 0][700.14 22 0][705.855 12 0][706.504 12 0][707.099 11 1]
[710.127 18 0][710.967 8 0][715.54 11 1][716.191 5 0][719.7 14 0]
[726.482 7 1][728.395 7 0][732.973 14 1][735.537 18 0][735.634 11 0]
[742.867 18 0][745.955 55 0][746.042 9 0][746.951 120 0][753.234 22 0]
[753.918 6 0][755.626 27 0][757.421 6 0][759.051 5 0][759.733 11 0]
[760.723 6 0][761.352 11 0][762.348 6 0][764.567 16 0][765.063 8 0]
[765.445 22 1][765.805 12 0][765.925 22 0][766.564 4 0][768.001 35 0]
[772.214 9 0][772.619 8 1][774.744 11 0][775.463 22 0][776.216 4 0]
[779.669 9 0][779.747 35 0][381.678 4000 2][396.287 600 2][400.97 40 2]
[408.858 2 2][428.818 1000 2][429.006 40000 2][433.824 300 2][438.686 20000 2]
[461.293 30 2][473.556 15000 2][478.312 2000 2][487.607 8 2][590.33 8000 2]]
40000} bind def
%
/wl@elt@Tm {[
[380.772 600 0][381.072 380 1][381.739 550 1][382.639 290 0][383.82 1300 1]
[384.087 290 0][384.802 8900 1][385.784 140 1][388.313 6800 0][388.344 1800 1]
[388.735 5400 0][389.053 440 1][389.662 440 0][390.079 680 1][391.648 3500 0]
[392.866 120 1][392.958 570 1][394.927 1500 0][395.81 1500 1][399.558 440 1]
[399.652 1800 1][402.423 220 0][404.447 380 0][409.419 10000 0][410.584 9500 0]
[413.269 120 1][413.833 1100 0][414.914 120 0][415.86 120 0][418.762 8800 0]
[419.992 520 1][420.373 6000 0][420.6 220 1][422.267 380 0][424.215 3000 1]
[427.171 270 0][429.836 150 0][435.993 2700 0][438.643 1400 0][439.442 200 0]
[439.596 120 0][439.65 140 0][443.74 55 1][444.274 80 0][444.758 50 0]
[445.403 120 0][445.999 80 0][446.798 50 0][448.126 540 1][448.97 80 1]
[451.96 150 0][452.257 260 1][452.938 180 1][453.215 80 0][454.86 110 0]
[455.668 40 1][456.186 40 1][456.468 80 0][456.711 40 1][459.663 95 0]
[459.902 270 0][460.129 35 1][460.343 55 1][460.485 40 0][461.397 50 0]
[461.447 40 1][461.594 300 1][461.906 35 1][462.172 40 0][462.633 80 1]
[462.656 95 1][462.697 40 0][463.426 110 1][464.296 40 1][464.312 95 0]
[464.458 35 0][465.509 120 0][466.67 35 1][467.199 35 1][467.51 35 0]
[467.531 80 0][467.786 40 1][468.192 160 0][468.511 70 0][469.111 120 0]
[472.426 110 0][473.334 680 0][475.075 35 1][475.99 70 0][478.992 27 1]
[480.748 27 0][480.868 35 0][481.35 35 0][482.699 27 1][482.897 27 0]
[483.12 80 1][483.575 35 0][485.176 27 0][487.228 19 1][487.919 27 0]
[489.164 27 0][490.974 24 0][492.383 55 0][495.718 140 0][497.087 40 1]
[497.126 27 0][497.512 40 1][497.89 50 0][498.068 40 1][498.932 55 1]
[499.379 27 1][499.472 19 1][500.102 35 0][500.159 27 0][500.977 160 1]
[501.456 35 1][501.787 27 1][503.422 160 1][504.1 27 1][504.35 22 0]
[504.541 35 0][506.042 27 1][506.09 150 0][506.225 27 0][506.588 27 0]
[506.667 80 0][507.242 27 0][507.636 27 0][507.718 27 0][508.509 35 0]
[510.753 40 0][511.397 95 0][511.455 50 1][512.067 22 0][514.028 22 1]
[514.94 40 1][518.268 19 0][518.525 40 0][520.451 14 1][521.338 80 0]
[522.823 22 1][526.093 14 1][526.734 24 1][529.114 40 0][529.432 40 0]
[530.021 35 0][530.269 35 0][530.587 55 1][530.712 650 0][532.299 16 1]
[533.89 35 0][534.649 80 1][537.298 27 1][539.196 14 1][540.046 27 1]
[540.223 27 0][540.598 14 1][546.195 14 1][546.414 14 0][546.554 14 1]
[550.03 16 1][552.682 14 1][552.834 24 0][553.903 14 1][556.6 27 0]
[558.137 22 0][558.665 14 1][558.994 14 1][560.664 14 0][563.141 270 0]
[564.26 40 0][564.54 27 0][565.83 70 0][567.584 520 0][568.359 14 0]
[568.476 40 1][569.642 14 1][570.997 35 1][571.579 22 0][573.381 14 1]
[573.72 11 1][573.892 14 1][575.802 27 0][576.02 55 0][576.429 190 0]
[577.882 5 1][578.236 19 1][578.446 22 1][579.997 11 1][581.119 14 1]
[581.646 14 0][583.876 35 1][589.563 240 0][589.947 35 0][590.157 24 0]
[591.258 8 0][593.17 11 0][593.59 27 0][597.126 140 0][597.502 27 0]
[598.487 11 0][602.544 19 0][606.778 11 1][613.153 16 0][617.529 14 0]
[618.141 14 1][629.946 14 1][635.266 27 0][640.144 22 0][643.094 8 1]
[644.054 14 0][646.026 200 0][649.07 14 0][651.978 14 0][657.554 8 0]
[660.496 95 0][662.725 8 0][665.772 35 0][665.864 11 0][669.293 11 0]
[672.136 30 0][672.634 9 0][672.794 9 1][673.922 18 0][676.748 9 0]
[677.793 9 0][677.977 110 0][678.2 14 0][678.852 18 0][682.027 13 0]
[682.695 14 0][682.912 14 1][683.109 23 0][684.426 120 0][684.576 80 0]
[685.412 18 0][689.856 6 0][691.586 6 0][693.737 10 0][694.954 5 0]
[697.669 5 1][701.079 5 0][701.431 6 1][701.79 10 0][702.94 6 0]
[703.434 12 0][705.643 10 1][706.097 5 0][707.978 6 1][710.614 10 0]
[723.133 5 0][723.374 5 1][725.772 4 0][727.262 17 0][728.43 8 0]
[728.616 11 0][731.051 14 0][733.663 11 1][743.218 14 0][743.451 5 1]
[743.995 5 1][748.108 75 0][749.02 75 0][750.728 10 0][754.578 14 0]
[755.833 140 0][758.061 17 0][759.374 20 0][759.507 17 1][762.985 5 0]
[764.876 5 1][765.5 17 0][766.032 4 0][766.624 7 0][767.604 8 1]
[770.146 8 0][773.153 80 0][777.827 4 0][778.235 12 0][778.551 8 0]
[399.884 300 2][402.192 200 2][402.603 200 2][403.213 700 2][407.615 100 2]
[433.547 200 2][438.541 500 2]]
10000} bind def
%
/wl@elt@Yb {[
[383.991 170 0][387.285 340 0][390.085 340 0][390.481 50 1][391.127 140 0]
[398.799 32000 0][399.088 930 0][400.736 50 0][405.228 70 0][407.728 85 1]
[408.968 440 0][411.925 120 1][413.509 70 1][414.907 470 0][417.456 120 0]
[418.081 340 1][421.856 150 1][423.197 120 0][427.774 70 0][430.597 120 0]
[431.695 70 1][439.369 60 0][443.021 60 0][443.919 440 0][448.242 85 0]
[451.516 85 1][455.358 35 1][456.395 85 0][457.621 640 0][458.236 200 0]
[458.921 70 0][459.083 140 0][459.836 40 1][468.381 35 1][468.427 40 0]
[472.608 190 1][478.187 170 0][478.661 170 1][481.643 35 0][482.024 40 1]
[483.696 35 1][483.746 40 0][485.115 17 1][489.46 40 0][491.236 27 0]
[493.55 710 0][493.722 24 1][496.69 140 0][500.952 24 1][506.73 17 1]
[506.78 30 0][506.914 70 0][507.434 220 0][507.674 50 0][513.598 20 1]
[514.702 14 1][518.415 20 1][519.608 60 0][521.16 85 0][524.051 35 1]
[524.411 100 0][525.749 40 1][527.704 150 0][527.953 35 1][530.094 17 1]
[533.515 170 1][534.566 30 1][534.722 60 1][535.129 30 0][535.295 150 1]
[535.864 30 1][536.366 30 0][538.984 17 1][543.271 14 1][544.927 40 1]
[547.85 14 1][548.192 60 0][550.549 40 0][552.454 17 0][553.905 85 0]
[555.647 2400 0][556.209 35 0][556.811 20 0][558.636 20 0][558.845 40 1]
[565.198 60 1][568.653 7 1][571.999 220 0][574.991 10 1][575.589 10 0]
[577.166 27 1][580.344 10 0][581.941 10 1][583.399 35 1][583.714 35 1]
[585.451 27 0][589.721 8 1][590.836 20 1][598.933 17 0][599.151 40 1]
[605.288 10 1][605.457 10 0][615.257 60 1][624.697 30 1][627.478 60 1]
[630.815 14 1][640.035 35 0][641.791 35 0][643.273 20 1][646.315 17 1]
[648.906 340 0][664.355 20 0][666.782 180 0][667.817 15 0][672.761 25 1]
[676.87 25 0][679.96 690 0][693.405 18 1][699.988 20 1][704.378 10 1]
[724.441 9 0][730.522 8 0][731.305 10 0][735.004 16 0][744.828 25 0]
[752.746 30 0][769.948 750 0][387.998 20 2][388.258 10 2][388.717 20 2]
[389.655 150 2][391.275 15 2][391.323 20 2][393.123 500 2][398.556 100 2]
[399.174 10 2][399.767 10 2][402.814 2000 2][403.303 10 2][407.453 20 2]
[409.067 20 2][409.823 20 2][412.106 15 2][415.004 10 2][415.311 15 2]
[416.272 100 2][417.295 60 2][419.434 30 2][419.495 100 2][419.874 10 2]
[421.364 300 2][422.083 10 2][423.107 15 2][428.964 20 2][430.114 40 2]
[430.401 20 2][435.08 15 2][438.007 10 2][451.758 100 2][463.914 40 2]
[483.493 10 2][505.494 15 2][525.685 20 2][533.154 20 2][574.083 15 2]
[594.902 10 2][597.305 20 2][605.585 40 2][621.422 100 2][632.852 200 2]
[636.588 10 2][637.833 150 2][646.633 25 2][698.515 20 2][703.704 10 2]
[715.772 15 2][731.102 10 2][739.998 10 2][741.001 80 2][745.686 15 2]
[766.441 70 2]]
32000} bind def
%
/wl@elt@Lu {[
[380.067 150 0][382.907 75 0][384.118 2700 0][384.361 75 0][385.329 95 0]
[387.461 40 0][387.665 530 1][391.177 29 0][391.886 50 0][392.662 35 0]
[396.846 480 0][399.138 50 0][405.445 670 0][409.613 75 -1][410.744 35 0]
[411.267 95 0][412.249 310 0][412.473 3100 0][413.179 150 0][415.408 460 0]
[415.898 24 0][418.425 1600 1][427.75 150 0][428.103 250 0][429.597 330 0]
[430.957 150 0][433.272 75 0][434.198 29 1][442.096 65 0][443.048 190 0]
[443.879 35 0][445.081 190 0][447.155 50 0][449.885 60 0][451.857 3300 0]
[456.095 24 -1][457.531 24 -1][460.539 85 0][464.547 95 0][464.821 100 0]
[464.885 95 0][465.403 65 -1][465.802 1000 0][465.903 85 0][466.175 630 -1]
[467.231 310 -1][468.416 420 -1][469.546 270 -1][470.8 190 -1][471.67 30 0]
[472.086 65 -1][472.62 65 0][473.5 100 -1][474.911 75 -1][476.422 40 -1]
[478.542 150 1][481.505 85 0][483.962 50 1][486.536 18 1][490.488 460 0]
[494.234 180 0][499.413 800 1][500.114 800 0][505.76 55 0][513.405 140 0]
[513.509 2700 0][517.011 130 -1][519.661 170 0][520.647 90 0][530.44 40 0]
[534.912 80 0][540.257 500 0][542.19 140 0][543.788 100 0][545.357 35 0]
[547.669 2100 1][566.489 9 1][571.349 14 1][573.655 550 0][577.54 55 0]
[580.059 80 0][586.079 40 0][586.63 9 0][598.39 690 1][599.713 140 0]
[600.452 1400 0][604.166 35 0][605.503 440 0][614.071 11 0][615.994 150 1]
[619.966 160 1][622.187 2100 1][622.814 35 1][623.536 80 1][624.234 160 1]
[624.88 16 0][634.535 70 0][635.485 18 0][636.579 9 0][636.6 16 0]
[644.114 22 0][644.489 11 1][646.312 1100 1][647.767 29 0][652.318 55 0]
[661.128 35 1][661.915 11 1][667.714 23 0][673.576 9 0][679.377 30 0]
[682.659 11 1][691.731 45 0][694.396 8 1][703.124 23 0][709.634 14 0]
[712.584 45 1][714.279 9 0][714.31 7 0][716.594 8 1][723.798 14 0]
[740.97 5 1][744.152 11 0][745.696 8 1][764.008 7 0][775.83 7 0]
[425.144 200 2][427.191 300 2][449 200 2][495.643 400 2][504.612 10 2]
[514.586 150 2][541.942 70 2][551.988 60 2][552.68 5 2][574.871 5 2]
[578.646 70 2][586.971 80 2][588.976 60 2][619.796 300 2][619.813 600 2]
[730.995 100 2][731.025 200 2][753.427 50 2]]
3300} bind def
%
/wl@elt@Hf {[
[380.038 850 0][380.607 140 1][381.178 320 0][381.72 100 1][381.938 100 0]
[382.073 1300 0][382.967 140 0][383.002 280 0][384.918 800 0][384.952 140 1]
[385.831 600 0][386.091 230 0][387.255 200 1][387.71 160 1][388.082 380 1]
[388.252 200 0][388.377 150 1][388.923 200 0][388.933 200 0][389.994 620 0]
[391.809 620 1][392.39 200 1][392.642 120 0][392.757 150 0][392.954 110 1]
[393.138 320 0][393.565 120 1][393.904 120 0][395.183 410 0][396.801 160 0]
[397.005 150 -1][397.348 200 0][403.227 180 0][404.796 100 1][406.284 230 0]
[406.621 140 0][408.335 180 0][409.316 540 1][410.423 110 0][410.658 140 0]
[411.353 110 1][411.86 110 0][412.78 150 1][414.576 140 0][416.236 150 1]
[416.269 110 0][417.434 1100 0][419.095 120 0][420.658 160 1][420.97 190 0]
[422.808 170 0][423.244 170 1][425.208 120 -1][426.098 170 0][426.339 200 0]
[427.285 170 1][429.479 320 0][431.814 120 0][433.027 160 0][433.666 180 1]
[435.051 150 1][435.633 250 0][436.79 110 1][437.097 180 1][441.735 120 1]
[441.791 160 0][443.804 200 0][445.734 140 0][446.118 140 0][454.093 140 0]
[456.594 250 0][459.88 500 0][462.086 230 0][465.519 210 0][469.901 120 0]
[478.274 160 0][480.05 310 0][485.924 130 0][497.525 120 0][501.82 95 0]
[502.175 15 0][504.082 55 1][504.745 95 0][507.474 55 -1][507.965 30 1]
[509.388 55 -1][511.213 15 0][512.853 19 1][515.796 30 0][516.742 55 0]
[517.018 75 0][518.186 230 0][518.684 30 0][518.775 30 1][524.399 110 0]
[524.71 55 1][526.044 25 1][526.495 30 1][527.504 55 0][528.609 22 0]
[529.487 120 0][529.806 45 1][530.782 30 0][530.968 45 0][531.16 55 1]
[532.426 12 1][534.63 9 1][535.473 110 0][537.386 110 0][538.934 40 0]
[539.136 19 1][540.447 19 0][542.402 28 0][543.578 12 0][543.874 40 0]
[544.407 14 1][545.292 75 0][546.338 30 1][549.73 15 0][551.012 15 0]
[551.045 15 0][552.435 19 1][553.802 45 0][553.826 28 0][555.06 230 0]
[555.212 230 0][557.586 55 0][560.077 14 0][561.327 95 0][561.401 25 0]
[562.827 8 0][565.083 19 0][569.803 40 -1][571.328 25 0][571.918 160 0]
[572.016 25 -1][574.872 12 0][576.718 14 1][580.95 12 1][581.747 19 0]
[584.223 25 1][584.587 25 0][584.777 19 0][588.366 22 0][592.647 15 0]
[593.369 60 0][597.428 75 0][597.472 25 0][597.866 60 0][599.296 25 0]
[601.679 45 0][602.112 28 -1][604.319 25 -1][605.417 25 0][609.867 95 0]
[618.513 95 0][621.07 55 0][621.682 28 0][623.858 45 0][624.895 60 1]
[629.954 22 0][631.185 25 0][631.833 19 0][633.81 30 0][638.019 19 0]
[638.623 60 0][640.952 19 0][655.65 15 0][658.723 28 0][664.46 45 1]
[664.706 19 1][665.94 11 0][671.348 30 0][675.461 17 1][676.995 11 0]
[678.927 85 0][681.894 160 0][682.656 15 0][685.007 13 0][685.87 35 0]
[691.14 45 0][692.619 10 0][697.959 19 0][698.091 21 1][701.925 7 0]
[703.033 7 1][703.513 7 0][706.19 11 0][706.287 15 0][706.383 160 0]
[709.44 11 0][710.054 15 0][711.952 55 0][713.181 570 0][723.71 650 0]
[724.087 410 0][726.262 6 0][732.005 75 0][732.176 16 0][735.61 6 0]
[736.528 6 0][739.07 20 0][742.369 6 0][743.756 25 0][746.386 13 0]
[748.456 7 0][755.637 15 0][756.293 75 0][756.422 15 0][757.695 11 0]
[759.296 11 0][760.859 13 0][762.44 360 0][764.564 20 0][774.017 110 0]
[774.357 8 0][775.789 5 1][779.09 40 0][779.681 7 0][775.129 20 3]
[726.758 10 3]]
1300} bind def
%
/wl@elt@Ta {[
[383.374 210 1][384.805 100 0][388.52 100 0][391.851 210 0][392.278 140 0]
[392.292 140 0][397.01 210 0][399.617 210 0][399.928 100 0][400.684 190 0]
[402.694 190 0][402.994 140 0][404.087 120 0][406.14 410 0][406.463 210 0]
[406.724 100 0][406.791 310 0][410.502 120 0][412.938 210 0][413.62 230 0]
[414.789 230 0][417.521 210 0][417.792 100 0][418.115 130 0][420.588 300 0]
[420.64 120 0][424.535 130 0][426.826 130 0][430.298 160 0][435.514 110 0]
[437.882 100 0][438.607 150 0][439.845 110 0][440.25 180 0][441.574 130 0]
[451.098 360 0][453.085 190 0][455.195 130 0][456.585 170 0][457.431 340 0]
[461.951 260 0][466.914 130 0][468.188 450 0][469.19 130 0][474.016 150 0]
[475.651 220 0][476.898 120 0][481.275 220 0][492.011 110 0][492.127 100 0]
[492.6 110 0][493.642 150 0][503.737 200 0][506.787 100 0][511.584 110 0]
[514.162 100 0][514.369 100 0][515.656 330 0][521.274 110 0][521.845 110 0]
[534.105 140 0][540.251 200 0][541.919 130 0][550.068 18 0][550.566 20 0]
[551.627 15 0][551.891 90 0][552.115 9 0][552.398 10 0][552.836 13 0]
[554.52 10 0][554.832 20 0][558.402 30 0][559.875 15 0][559.952 30 0]
[560.55 9 0][561.771 9 0][562.068 40 0][562.82 13 0][563.571 20 0]
[564.018 40 0][564.591 150 0][566.49 130 0][568.825 30 0][569.924 40 0]
[570.431 15 0][570.628 25 0][571.524 30 0][571.653 8 0][574.671 23 0]
[575.581 30 0][576.161 15 0][576.656 25 0][576.791 30 0][577.193 10 0]
[577.677 130 0][578.002 25 0][578.071 90 0][581.11 130 0][581.651 25 0]
[584.394 45 0][584.968 13 0][586.661 15 0][587.736 240 0][588.23 130 0]
[590.191 90 0][591.651 30 0][591.895 90 0][592.59 15 0][593.062 15 0]
[593.105 23 0][593.168 20 0][593.554 18 0][593.976 130 0][594.402 240 0]
[595.178 25 0][596.013 18 0][599.723 190 0][600.989 25 0][601.59 25 0]
[602.072 100 0][604.539 250 0][604.725 100 0][605.37 25 0][609.082 30 0]
[609.206 18 0][610.158 100 0][614.007 25 0][614.456 65 0][615.254 30 0]
[615.45 130 0][615.884 40 0][617.046 15 0][618.966 15 0][619.311 15 0]
[620.837 25 0][624.979 40 0][625.668 150 0][626.87 150 0][627.834 50 0]
[628.133 65 0][628.736 15 0][628.791 40 0][628.934 40 0][630.906 50 0]
[630.958 150 0][631.222 25 0][632.508 75 0][633.291 50 0][634.117 65 0]
[634.602 30 0][635.616 75 0][636.084 65 0][637.306 40 0][637.907 15 0]
[638.945 90 0][639.221 23 0][642.86 65 0][643.079 250 0][643.736 13 0]
[644.461 40 0][644.587 30 0][645.036 200 0][645.583 20 0][645.992 30 0]
[648.537 380 0][650.243 18 0][650.552 65 0][651.439 100 0][651.61 100 0]
[656.16 25 0][656.426 25 0][657.484 100 0][658.513 10 0][658.716 15 0]
[661.195 110 0][662.13 75 0][666.224 15 0][667.373 100 0][667.553 180 0]
[668.4 30 0][669.361 15 0][670.646 15 0][670.939 25 0][671.444 10 0]
[672.361 15 0][674.073 75 0][675.491 40 0][675.585 13 0][677.037 13 0]
[677.174 75 0][677.425 40 0][678.899 40 0][679.006 13 0][679.927 13 0]
[681.046 40 0][681.325 160 0][681.936 20 0][682.496 18 0][683.2 13 0]
[685.083 15 0][686.513 15 0][686.623 210 0][687.527 180 0][687.749 40 0]
[689.677 15 0][690.055 40 0][690.21 150 0][692.738 140 0][692.854 140 0]
[693.933 8 0][694.687 20 0][695.126 65 0][695.388 45 0][696.613 180 0]
[696.949 8 0][697.131 8 0][697.153 9 0][698.352 23 0][699.522 110 0]
[700.021 20 0][700.507 40 0][700.696 75 0][702.503 50 0][703.151 13 0]
[703.907 40 0][708.13 15 0][708.54 20 0][709.302 23 0][710.805 8 0]
[711.752 15 0][712.127 20 0][712.572 40 0][714.863 150 0][717.29 110 0]
[717.491 13 0][719.135 13 0][723.345 8 0][725.027 30 0][726.482 11 0]
[727.229 6 0][727.696 30 0][727.754 5 0][728.636 9 0][729.632 13 0]
[730.174 140 0][731.984 20 0][732.272 11 0][732.595 13 0][734.019 11 0]
[734.641 160 0][735.286 140 0][735.696 100 0][736.909 90 0][740.789 160 0]
[743.519 11 0][744.017 23 0][746.775 30 0][748.601 23 0][752.056 30 0]
[756.923 6 0][759.022 9 0][764.962 6 0][772.202 11 0][776.311 11 0]
[777.967 9 0]]
450} bind def
%
/wl@elt@W {[
[380.922 290 0][381.038 190 0][381.079 260 0][381.748 1400 0][382.913 110 0]
[383.506 1100 0][383.851 290 0][384.622 730 0][384.749 250 0][385.157 27 1]
[385.555 150 0][385.93 150 0][386.434 180 0][386.799 1800 0][387.284 250 0]
[387.441 110 0][388.141 730 0][389.272 110 0][389.791 140 0][393.503 150 0]
[393.697 120 0][394.798 120 0][395.252 120 0][395.29 120 0][395.315 160 0]
[395.53 200 0][396.514 160 0][396.859 130 0][397.08 150 0][397.929 130 0]
[398.064 130 0][398.329 250 0][400.875 8600 0][401.522 540 0][401.652 170 0]
[401.923 220 0][402.212 130 0][402.879 180 0][403.686 180 0][403.985 140 0]
[404.428 140 0][404.559 910 0][406.479 180 0][406.979 150 0][406.995 730 0]
[407.061 340 0][407.193 100 0][407.436 5000 0][408.296 150 0][408.833 130 0]
[409.569 100 0][410.27 1000 0][410.975 150 0][411.182 100 0][411.805 150 0]
[411.819 100 0][412.085 100 0][412.516 100 0][412.68 150 0][413.348 100 0]
[413.746 540 0][413.802 150 0][414.225 110 0][414.516 140 0][414.595 110 0]
[415.466 160 0][417.053 160 0][417.117 450 0][420.44 160 0][420.705 220 0]
[421.538 110 0][421.937 250 0][422.204 110 0][423.434 150 0][424.144 290 0]
[424.436 540 0][425.935 290 0][426.029 200 0][426.33 200 0][426.938 1400 0]
[426.977 110 0][427.455 220 0][427.549 160 0][427.674 160 0][428.234 110 0]
[428.601 110 0][429.41 110 0][429.461 4100 0][430.211 2200 0][430.687 160 0]
[430.764 110 0][433.213 110 0][434.7 100 0][435.517 150 0][436.181 100 0]
[436.478 150 0][436.595 100 0][437.252 150 0][437.848 200 0][438.485 180 0]
[440.395 100 0][440.828 200 0][441.219 130 0][443.69 160 0][446.049 140 0]
[446.634 140 0][446.674 140 0][448.419 640 0][450.484 160 0][451.288 130 0]
[451.325 120 0][454.354 150 0][454.647 150 0][455.182 150 0][457.064 140 0]
[458.873 170 0][459.994 140 0][460.989 140 0][461.33 160 0][464.253 100 0]
[465.742 130 0][465.987 640 0][468.051 640 0][469.372 100 0][475.754 140 0]
[484.381 790 0][488.69 380 0][498.259 220 0][500.615 330 0][501.53 220 0]
[505.328 820 0][505.46 210 0][506.912 210 0][507.174 120 0][522.466 770 0]
[550.049 27 0][550.344 27 0][550.861 10 0][551.468 220 0][553.138 15 0]
[553.772 15 0][556.809 13 0][560.431 13 0][563.127 11 0][563.194 27 0]
[564.837 65 0][566.072 35 0][567.439 27 0][567.66 13 0][567.69 15 0]
[569.779 15 0][573.509 55 0][574.924 13 0][575.61 11 0][579.306 13 0]
[579.649 13 0][580.485 45 0][580.605 13 0][583.361 13 0][583.897 13 0]
[584.527 17 0][585.158 28 0][585.661 11 0][586.463 22 0][587.422 11 0]
[588.021 13 0][589.161 13 0][590.12 13 0][590.264 40 0][592.858 13 0]
[594.757 55 0][595.396 13 0][595.619 13 0][596.083 27 0][596.586 55 0]
[597.251 27 0][597.886 20 0][598.382 20 0][600.901 13 0][601.278 55 0]
[602.152 40 0][602.832 20 0][604.331 20 0][604.992 13 0][606.508 13 0]
[608.144 22 0][611.166 13 0][611.552 13 0][612.825 22 0][614.394 13 0]
[615.372 20 0][615.487 20 0][620.351 20 0][625.428 20 0][628.588 27 0]
[629.202 45 0][630.321 20 0][638.647 13 0][640.421 35 0][644.512 40 0]
[650.805 11 0][653.239 15 0][653.811 13 0][656.32 13 0][657.393 20 0]
[660.713 11 0][660.905 11 0][661.162 17 0][662.174 11 0][667.842 13 0]
[669.308 15 0][674.656 5 0][676.445 5 0][680.531 7 0][681.492 9 0]
[682.027 9 0][682.843 8 0][685.374 4 0][687.601 4 0][690.829 5 0]
[693.423 9 0][696.412 8 0][698.427 13 0][699.327 8 0][699.406 4 0]
[701.788 8 0][702.868 3 0][709.822 3 0][711.118 4 0][714.052 15 0]
[716.264 9 0][719.133 5 0][719.862 5 0][720.016 11 0][721.635 5 0]
[722.606 4 0][723.712 8 0][727.447 5 0][727.824 10 0][728.581 15 0]
[729.655 15 0][729.825 3 0][738.508 7 0][745.139 4 0][745.637 3 0]
[748.335 8 0][750.413 7 0][750.9 10 0][752.066 3 0][753.745 9 0]
[755.048 9 0][756.992 17 0][758.288 5 0][761.218 3 0][761.415 17 0]
[763.129 3 0][765.481 3 0][768.897 13 0][770.101 4 0][776.116 5 0]
[777.673 3 0][778.415 11 0]]
8600} bind def
%
/wl@elt@Re {[
[380.774 190 0][381.566 120 0][383.63 120 0][386.994 240 0][387.526 240 0]
[387.686 240 0][390.821 100 0][391.392 130 0][391.727 380 0][392.985 550 0]
[393.69 140 0][394.472 110 0][394.591 180 0][396.104 280 0][396.248 350 0]
[400.493 100 0][402.296 140 0][402.331 100 0][402.963 110 0][403.331 220 0]
[403.749 110 0][404.899 200 0][408.143 240 0][410.442 140 0][411.089 240 0]
[412.164 190 0][413.342 240 0][413.645 1800 0][414.436 700 0][414.996 140 0]
[417.04 160 0][418.29 220 0][418.306 220 0][422.108 650 0][422.746 3600 0]
[424.139 150 0][425.76 260 0][429.117 120 0][430.44 200 0][433.225 200 0]
[435.798 40 1][435.869 380 0][436.758 190 0][439.134 140 0][439.438 360 0]
[440.64 110 0][441.582 180 0][447.508 150 0][447.839 120 0][450.704 120 0]
[451.331 2600 0][451.664 260 0][452.273 500 0][452.388 120 0][452.995 120 0]
[454.517 100 0][458.068 120 0][460.573 120 0][462.138 100 0][479.142 190 0]
[488.914 2200 0][492.39 220 0][505.856 40 0][509.65 70 0][512.032 20 0]
[516.165 25 0][517.889 40 0][518.174 20 0][523.431 35 0][524.886 50 0]
[527.095 1300 0][527.556 1600 0][527.824 100 0][530.556 30 0][531.728 20 0]
[532.128 35 0][532.746 50 0][533.19 20 0][533.276 20 0][533.385 20 0]
[536.948 35 0][536.98 50 0][537.71 100 0][543.19 25 0][543.703 14 0]
[544.792 14 0][546.064 25 0][552.005 14 0][552.11 25 0][553.268 50 0]
[556.324 50 0][557.347 25 0][558.472 25 0][560.721 10 0][561.227 12 0]
[566.788 100 0][571.143 25 0][571.695 18 0][575.293 110 0][577.683 110 0]
[579.16 18 0][581.592 10 0][583.431 550 0][591.986 10 0][594.324 60 0]
[595.021 10 0][596.977 18 0][598.999 10 0][599.573 18 0][611.422 30 0]
[614.581 35 0][614.682 50 0][620.324 18 0][621.797 25 0][622.942 30 0]
[624.324 35 0][626.002 35 0][627.137 18 0][627.876 18 0][628.641 10 0]
[630.342 10 0][630.77 200 0][632.19 200 0][635.075 80 0][638.294 16 0]
[641.147 14 0][651.147 50 0][651.525 14 0][654.491 12 0][657.711 35 0]
[659.252 40 0][660.519 100 0][662.391 30 0][663.725 10 0][665.239 27 0]
[668.328 15 0][671.13 9 0][675.122 30 0][676.119 5 0][681.341 180 0]
[682.99 260 0][697.153 85 0][700.663 35 0][702.415 65 0][724.667 65 0]
[729.272 13 0][757.873 40 0][761.189 13 0][762.025 7 0][764.094 50 0]]
3600} bind def
%
/wl@elt@Os {[
[383.606 250 0][384.03 150 0][384.129 150 0][384.994 190 0][385.709 230 0]
[386.547 230 0][387.677 730 0][388.186 250 0][390.039 140 0][390.171 190 0]
[393 100 0][393.859 250 0][394.978 100 0][396.102 200 0][396.363 1000 0]
[396.496 100 0][396.967 150 0][397.544 110 0][397.723 730 0][398.818 100 0]
[400.348 150 0][400.402 100 0][400.516 150 0][401.826 160 0][403.784 100 0]
[404.192 280 0][404.805 160 0][406.669 960 0][407.086 250 0][407.156 190 0]
[407.468 230 0][409.182 490 0][410.03 120 0][411.202 1200 0][412.46 180 0]
[412.896 180 0][413.578 2500 0][413.784 150 0][417.257 180 0][417.323 1200 0]
[417.563 620 0][418.413 120 0][418.991 320 0][420.145 180 0][420.206 250 0]
[421.186 1200 0][421.386 120 0][421.516 100 0][423.346 170 0][426.085 4900 0]
[426.475 100 0][426.961 120 0][428.59 100 0][429.395 560 0][431.14 560 0]
[432.625 110 0][432.868 340 0][433.875 100 0][435.153 100 0][436.567 210 0]
[437.066 110 0][439.486 520 0][439.726 160 0][440.274 160 0][442.047 4900 0]
[443.241 100 0][443.632 290 0][443.964 100 0][444.735 230 0][448.476 120 0]
[454.866 110 0][455.041 540 0][455.13 140 0][461.678 170 0][463.183 170 0]
[466.382 140 0][479.399 670 0][486.56 110 0][503.183 55 0][503.912 45 0]
[507.288 35 0][507.477 35 0][507.909 35 0][510.35 90 0][511.081 55 0]
[512.223 22 0][514.554 22 0][514.974 140 0][515.201 28 0][516.898 28 0]
[519.352 40 0][520.263 270 0][520.323 35 0][525.046 20 -1][525.582 45 0]
[526.515 55 0][528.389 20 0][529.565 20 0][529.878 40 0][530.258 13 0]
[533.623 18 0][534.603 11 0][535.225 13 0][537.679 110 0][540.343 16 0]
[541.214 13 0][541.634 120 0][541.669 45 0][541.751 28 0][544.182 16 0]
[544.331 55 0][544.693 22 0][544.776 11 0][544.937 20 0][545.34 20 0]
[545.73 22 0][547 28 0][547.458 13 0][547.513 13 0][547.727 9 0]
[548.185 16 0][550.933 22 0][551.601 9 0][552.353 270 0][554.682 22 0]
[554.979 9 0][555.288 13 0][556.062 11 0][558.066 16 0][558.444 80 0]
[560.05 8 0][562.008 35 0][563.741 9 0][564.256 22 0][564.525 28 0]
[564.898 7 0][566.021 9 0][567.438 7 0][568.088 28 0][570.937 11 0]
[572.193 170 0][573.789 8 0][573.972 8 0][576.505 22 0][578.082 170 0]
[580.06 40 0][584.249 8 0][585.776 110 0][586.064 28 0][588.292 11 0]
[590.398 11 0][590.684 11 0][590.895 7 0][598.136 7 0][598.322 11 0]
[599.6 65 0][601.579 20 0][605.463 7 0][614.453 20 0][615.803 11 0]
[622.77 35 0][624.17 7 0][626.941 22 0][627.494 11 0][628.683 11 0]
[639.886 9 0][640.315 22 0][644.813 9 0][652.085 6 0][652.887 7 0]
[653.314 7 0][653.83 11 0][657.683 11 0][661.456 8 0][661.543 4 0]
[666.181 7 0][672.956 27 0][679.153 18 0][680.661 14 0][687.87 5 0]
[690.158 4 0][695.602 11 0][698.495 6 0][706.067 15 0][714.554 22 0]
[714.989 10 0][718.41 4 0][720.633 10 0][720.996 5 0][725.116 9 0]
[725.349 6 0][737.507 6 0][740.795 9 0][760.295 26 0][770.146 4 0]
[778.996 7 0]]
4900} bind def
%
/wl@elt@Ir {[
[380.012 3100 0][381.724 230 0][386.564 170 0][390.251 480 0][391.538 480 0]
[393.484 400 0][394.627 120 0][397.631 590 0][399.212 460 0][402.003 180 0]
[403.376 350 0][404.008 130 0][406.992 370 0][407.068 150 0][409.261 100 0]
[411.578 140 0][412.792 23 0][415.57 27 0][416.604 15 0][417.256 90 0]
[418.247 35 0][418.321 15 0][418.566 18 0][419.754 23 0][421.776 27 0]
[422.08 13 0][425.911 75 0][426.53 27 0][426.81 260 0][428.662 23 0]
[430.16 75 0][431.059 55 0][431.15 220 0][435.13 18 0][435.256 18 0]
[439.259 18 0][439.947 160 0][440.378 65 0][442.627 110 0][445.018 15 0]
[447.848 55 0][449.535 16 0][449.603 11 0][454.568 55 0][454.848 30 0]
[455.078 13 0][456.809 35 0][457.002 18 0][460.448 18 0][461.639 75 0]
[465.618 26 0][466.899 17 0][470.888 21 0][472.886 50 0][473.186 21 0]
[475.646 26 0][475.796 13 0][477.816 65 0][479.567 30 0][480.714 10 0]
[480.947 21 0][484.077 10 0][484.538 17 0][493.809 50 0][497.048 26 0]
[499.974 25 0][500.274 25 0][500.917 17 0][501.498 30 0][504.606 17 0]
[512.366 30 0][517.795 20 0][523.892 22 0][534.074 12 0][536.432 35 0]
[544.95 75 0][545.45 30 0][546.94 7 0][562.004 10 0][562.555 45 0]
[582.855 10 0][588.23 10 0][588.736 7 0][589.406 35 0][602.61 7 0]
[606.783 12 0][611.067 20 0][628.828 12 0][633.444 7 0][662.473 5 0]
[668.608 10 0][683.001 5 0][692.988 5 0][718.371 4 0]]
3100} bind def
%
/wl@elt@Pt {[
[380.105 20 -1][381.869 80 0][390.073 40 0][392.296 110 0][394.84 35 0]
[396.636 100 0][399.657 20 0][411.869 110 0][416.456 80 0][419.243 40 0]
[432.706 18 0][439.183 18 0][444.255 80 0][444.555 14 0][449.876 25 0]
[452.09 12 0][455.242 35 0][487.953 12 0][504.404 14 0][505.948 30 0]
[522.766 35 0][530.102 40 0][536.899 12 0][539.079 12 0][547.577 14 0]
[547.85 14 0][576.357 6 0][584.012 20 0][584.484 8 0][602.604 6 0]
[631.837 7 0][632.658 8 0][652.345 9 0][671.042 10 0][676.002 20 0]
[684.26 60 0][711.373 20 0]]
110} bind def
%
/wl@elt@Au {[
[380.192 30 0][380.401 30 1][382.185 10 0][382.57 10 0][387.473 100 0]
[388.025 30 0][388.948 30 0][389.226 100 0][389.786 400 0][390.109 30 0]
[390.938 300 0][392.769 100 0][395.91 10 0][396.623 30 0][397.665 30 0]
[397.968 30 0][399.137 30 0][401.257 3 0][401.607 10 1][404.093 400 0]
[405.279 30 1][406.507 700 0][407.635 10 1][408.328 3 1][408.41 100 0]
[410.17 30 0][412.859 30 0][420.113 30 0][422.788 30 0][424.18 100 0]
[431.511 200 0][436.104 30 1][442.061 10 1][443.727 120 0][448.825 250 0]
[460.751 900 0][462.056 100 0][466.392 1 0][466.397 3 0][469.469 10 0]
[476.017 3 1][479.258 500 0][481.16 100 0][482.296 10 0][495.082 30 0]
[506.459 30 0][510.884 30 0][514.744 100 0][523.026 300 0][526.176 100 0]
[565.577 100 0][572.136 100 0][583.737 300 0][586.293 100 0][595.696 300 0]
[596.268 30 0][627.817 600 0][656.268 100 0][665.289 30 0][751.073 600 0]]
900} bind def
%
/wl@elt@Hg {[
[380.166 30 0][390.1867 20 0][390.6372 60 0][398.3839 200 1][404.6572 1800 0]
[407.7838 150 0][410.8057 40 0][433.9224 250 0][434.7496 400 0][435.8337 4000 0]
[491.6068 80 0][546.0753 1100 0][567.5922 160 0][576.9598 240 0][579.0663 280 0]
[607.2713 20 0][623.4402 30 0][671.6429 160 0][690.7461 250 0][380.166 30 0]
[380.638 100 1][390.187 20 0][390.637 60 0][391.892 100 1][398.396 200 1]
[404.656 1800 0][407.783 150 0][410.805 40 0][433.922 250 0][434.749 400 0]
[435.833 4000 0][439.862 100 1][466.028 90 1][485.572 80 1][488.3 5 0]
[488.991 5 0][491.607 80 0][497.037 5 0][498.064 5 0][510.27 20 0]
[512.064 40 0][512.845 100 1][513.794 20 0][529.074 20 0][531.678 5 0]
[535.405 60 0][538.463 30 0][546.074 1100 0][554.963 30 0][567.586 160 0]
[576.96 240 0][578.966 100 0][579.066 280 0][580.378 140 0][585.925 60 0]
[587.173 60 1][587.198 20 0][607.272 20 0][614.95 1000 1][623.44 30 0]
[652.113 80 1][671.643 160 0][690.752 250 0][708.19 250 0][709.186 200 0]
[734.637 40 1][748.587 100 1][772.882 20 0][380.351 15 2][412.207 70 2]
[414.034 10 2][421.674 100 2][447.058 15 2][455.284 12 2][479.701 50 2]
[486.985 10 2][497.357 80 2][521.082 30 2][569.571 6 2][622.035 25 2]
[641.898 35 2][650.138 40 2][658.426 10 2][661.012 6 2][670.929 30 2]
[751.746 12 2]]
4000} bind def
%
/wl@elt@Tl {[
[383.23 10 1][386.915 6 1][388.715 10 1][422.305 8 1][427.498 20 1]
[430.68 40 1][435.99 2 0][449.077 8 1][473.705 20 1][498.135 15 1]
[507.854 25 1][515.214 25 1][518.195 6 1][518.31 6 1][535.046 18000 0]
[538.485 15 1][540.992 7 1][541.097 10 1][594.948 25 1][617.998 10 1]
[623.903 8 1][637.832 10 1][654.984 16 0][671.38 6 0][696.65 10 1]
[749.36 3 0][767.893 2 0][393.305 6 2][394.602 2 2][410.985 7 2]
[415.575 4 2][426.981 6 2][438.057 2 2][508.699 4 2][536.24 4 2]
[549.94 2 2][592.78 5 2]]
18000} bind def
%
/wl@elt@Pb {[
[401.9632 15000 0][405.7807 95000 0][406.2136 14000 0][411.076 5 1][411.335 4 1]
[415.282 10 1][415.7814 10 0][416.8033 10000 0][424.214 9 1][424.492 20 1]
[429.382 7 1][429.665 6 1][434.0413 200 0][435.274 10 1][438.646 20 1]
[457.9051 10 1][458.227 10 1][500.5416 1000 0][500.6572 100 0][504.258 50 1]
[507.058 10 1][507.453 10 1][507.635 10 0][508.9484 50 0][509.001 20 0]
[510.7242 10 0][511.164 10 1][520.1437 2000 0][536.764 10 1][537.2099 10 1]
[554.425 10 1][560.885 20 1][569.2346 40 0][589.5624 200 0][600.1862 2000 0]
[600.958 9 1][601.1667 500 0][604.117 8 1][605.9356 500 0][607.574 40 1]
[608.1409 40 1][611.052 50 0][615.989 10 1][623.5266 100 0][666.02 50 1]
[689.211 10 0][712.894 5 0][719.36 20 1][722.8965 20000 0][730.468 5 0]
[733.015 8 0][734.6676 10 0][755.897 10 1][763.256 10 1][773.296 4 1]
[385.408 12 2][395.192 8 2][403.116 3 2][409.454 3 2][412.811 2 2]
[427.266 8 2][449.934 6 2][457.121 7 2][459.645 1 2][476.112 6 2]
[479.859 4 2][482.686 1 2][485.506 2 2][506.512 3 2][519.156 4 2]
[552.397 5 2][577.941 3 2][585.796 6 2][396.248 4 3][404.98 4 3]
[449.615 10 3][453.46 16 3][460.54 8 3][591.454 2 3][480.936 4 4]
[665.099 5 4][675.32 4 4]]
95000} bind def
%
/wl@elt@Bi {[
[381.11 12 1][381.58 20 1][384.58 10 1][386.39 30 1][407.91 40 1]
[409.72 10 1][412.153 140 0][412.186 140 0][425.94 75 1][427.2 25 1]
[430.17 70 1][433.98 12 1][434.05 25 1][437.94 12 1][447.68 25 1]
[470.53 60 1][472.252 600 0][473.03 30 1][474.97 20 1][490.82 12 1]
[491.66 10 1][496.97 12 1][499.36 20 1][509.16 10 1][512.43 50 1]
[514.43 60 1][520.15 20 1][520.92 75 1][527.03 40 1][539.78 10 1]
[555.235 10 0][559.941 3 0][565.52 20 1][571.92 40 1][574.255 6 0]
[581.83 12 1][586.02 20 1][597.3 20 1][605.91 15 1][612.8 15 1]
[613.482 6 0][647.573 3 0][647.624 3 0][649.77 15 1][657.72 10 1]
[660.02 40 1][680.86 50 1][699.112 4 0][703.3 12 1][703.615 2 0]
[738.1 10 1][750.233 2 0][763.7 10 1][775 10 1][422.46 12 2]
[432.78 25 2][456.084 30 2][456.154 30 2][479.74 40 2][507.93 45 2]
[662.34 12 2][738.1 10 2][755.1 12 2][759.8 25 2][763.7 10 2]
[386.8 100 3][434.2 30 3][534.7 30 3]]
600} bind def
%
/wl@elt@Po {[
[386.193 500 0][405.198 200 -1][417.052 1200 0][423.613 250 -1][441.558 200 -1]
[449.321 800 0][461.144 350 0][486.712 200 -1][487.624 400 0][494.681 450 -1]
[532.323 350 0][574.485 300 0]]
1200} bind def
%
/wl@elt@Rn {[
[391.72 10 0][394.172 10 0][395.236 10 0][422.606 10 0][430.776 80 0]
[433.578 7 0][434.96 100 0][443.505 40 0][445.925 50 0][450.848 50 0]
[457.772 50 0][460.938 50 0][472.176 30 0][572.258 6 0][606.192 10 0]
[620.075 6 0][638.045 6 0][655.749 10 0][660.643 10 0][662.723 15 0]
[666.96 6 0][670.428 8 0][675.181 20 0][680.679 6 0][683.695 8 0]
[683.757 8 0][689.116 10 0][699.89 10 0][705.542 200 0][726.811 100 0]
[729.1 20 0][732.098 6 0][741.904 10 0][745 300 0][747.089 8 0]
[748.313 8 0][751.413 8 0][751.692 8 0][752.393 6 0][759.755 6 0]
[760.128 8 0][765.748 10 0][773.843 10 0][774.664 20 0]]
300} bind def
%
/wl@elt@Ra {[
[381.442 200 1][419.409 8 1][424.472 8 1][434.064 100 1][443.627 20 1]
[453.311 30 1][464.129 8 0][468.228 100 1][469.928 8 0][482.591 100 0]
[485.607 10 0][485.941 10 1][492.753 10 1][509.756 10 0][520.593 10 0]
[528.328 10 0][532.029 10 0][539.98 10 0][540.023 20 0][540.681 20 0]
[548.213 8 0][550.198 10 0][555.357 10 0][555.585 20 0][561.666 10 0]
[566.081 50 0][581.363 20 1][620.03 30 0][633.69 10 0][644.62 20 0]
[648.732 20 0][659.334 10 1][671.932 10 1][698.022 20 0][711.85 20 0]
[714.121 50 0][722.516 20 0][731.027 10 0]]
200} bind def
%
/wl@elt@Ac {[
[386.312 2000 1][391.447 100 1][406.16 400 1][408.844 3000 1][416.84 3000 1]
[417.998 100 0][418.312 20 0][419.44 20 0][420.969 300 1][435.913 300 1]
[438.453 20 0][438.641 1000 1][439.671 20 0][446.273 20 0][450.72 1000 1]
[460.545 500 1][471.658 10 0][472.016 400 1][481.222 300 1][494.518 100 1]
[495.823 100 1][496.087 100 1][544.638 150 1][573.205 300 1][575.897 400 1]
[591.085 1000 1][616.475 600 1][616.783 200 1][624.283 400 1][635.986 20 0]
[669.127 20 0][729.04 6 0][441.309 2000 2][456.987 3000 2][519.321 8 2]]
3000} bind def
%
/wl@elt@Th {[
[380.0197 50 0][380.3075 590 0][380.7273 50 0][381.3068 340 1][381.8685 50 0]
[382.5133 75 0][382.8384 450 0][383.6584 70 0][383.9746 840 1][384.196 280 1]
[384.6887 100 0][385.2135 85 0][385.4511 390 1][385.984 140 1][386.3405 450 1]
[386.9663 100 0][387.5374 210 0][387.9644 140 0][388.6915 100 0][389.5419 340 0]
[390.1661 50 0][390.3102 110 0][390.5186 170 1][390.875 50 0][391.1909 85 0]
[391.6417 50 0][391.9023 110 0][392.5093 140 0][392.9669 590 1][393.2911 200 0]
[393.704 140 1][394.2072 50 0][394.803 50 0][394.8964 200 1][395.276 50 0]
[395.93 110 0][396.7392 390 0][397.2155 200 0][398.0089 150 0][399.173 110 0]
[399.4549 530 1][399.8061 50 0][400.3309 240 1][400.7021 250 1][400.821 220 0]
[400.9056 220 0][401.2495 280 0][401.9129 4200 1][402.5656 210 1][402.7009 140 0]
[403.0842 250 0][403.6047 250 0][403.6565 240 1][404.1204 240 1][404.8287 55 0]
[405.0887 110 0][405.9253 140 0][406.3407 250 0][406.9201 300 1][406.9461 100 0]
[407.5503 55 0][408.1368 110 0][408.5434 85 0][408.652 700 1][408.8726 70 0]
[409.4747 700 1][410.0341 150 0][410.533 270 1][410.8421 840 1][411.2754 240 0]
[411.5758 280 0][411.6713 1100 1][412.36 30 0][412.7411 200 0][413.1002 110 0]
[413.2753 340 1][413.4067 200 0][414.0235 220 1][414.2701 250 1][414.8182 200 1]
[414.9986 450 1][415.8535 110 0][416.5766 140 0][417.806 620 1][417.9714 250 1]
[418.4138 30 0][419.3017 130 0][420.889 620 1][421.0923 130 0][421.4828 28 0]
[422.0065 55 0][422.7387 55 0][423.0824 30 0][423.5463 85 0][424.1094 20 0]
[424.7989 30 1][425.3538 110 0][425.6254 70 0][426.0333 110 0][426.9942 28 0]
[427.3357 280 1][427.7313 480 1][428.2042 700 1][428.8669 28 0][429.7306 55 0]
[429.9839 85 0][430.7176 100 0][430.9991 200 1][431.5254 55 0][431.8416 110 0]
[432.5274 30 0][433.0844 28 0][433.7277 130 0][434.2256 85 1][434.4326 130 1]
[434.9072 55 0][435.4484 55 0][435.9372 85 0][436.593 85 0][437.4123 85 0]
[438.186 1300 1][439.111 1100 1][439.2974 55 0][440.158 55 0][440.8882 85 0]
[441.2741 210 1][441.6845 28 0][442.2048 50 0][443.2963 250 1][444.0866 140 1]
[445.2565 25 0][445.8002 85 0][446.5341 220 1][447.5221 30 0][448.2169 75 0]
[448.9664 50 0][449.894 110 0][450.5216 55 0][451.0527 280 1][452.1194 70 0]
[453.0319 22 0][453.5255 40 0][454.5915 30 1][455.5812 70 0][456.366 40 0]
[457.0972 65 0][458.8426 50 0][459.5421 75 0][461.2554 26 1][462.1163 30 0]
[463.1761 140 1][463.1761 140 1][464.1254 30 0][465.1558 140 1][466.3202 23 0]
[466.9984 50 0][467.6056 65 0][468.6195 50 0][469.4091 140 1][470.399 50 0]
[471.2841 20 0][472.3438 90 0][472.9128 30 0][474.0529 190 1][475.2414 140 1]
[476.66 13 0][477.8294 50 0][478.6531 20 0][478.9387 40 0][480.8134 45 0]
[481.9193 20 0][482.2855 26 0][482.67 40 0][483.1121 45 0][484.0843 50 0]
[484.8362 30 0][485.2868 15 0][485.8333 40 1][486.3163 280 1][487.2917 40 0]
[487.8733 26 0][489.4955 45 0][490.7209 20 0][491.9816 240 1][492.778 18 0]
[493.9642 40 0][494.7575 60 1][495.4659 50 1][496.5731 30 0][497.595 35 1]
[498.5372 24 0][500.2097 50 0][500.2097 50 0][501.5889 50 1][501.7255 260 1]
[502.9892 20 0][503.923 24 0][504.4719 50 0][504.9796 240 1][505.5347 85 1]
[505.8562 70 1][506.7974 110 0][508.1446 30 0][509.0051 50 0][509.8043 50 1]
[510.113 40 0][511.0867 50 1][511.5044 30 0][512.595 10 0][513.4746 20 0]
[514.3267 95 1][514.8211 120 1][515.1612 50 0][515.4243 50 0][515.8604 85 0]
[516.073 70 0][516.8922 20 0][517.6961 50 0][518.399 35 1][519.0871 50 1]
[519.5814 50 0][519.88 50 0][519.9164 95 0][521.123 50 0][521.6596 95 1]
[521.8528 50 1][521.911 35 0][523.116 110 0][523.3225 85 1][523.3229 85 1]
[524.7654 95 1][525.5573 10 0][525.836 35 0][526.671 12 0][527.7501 70 1]
[528.1069 15 0][529.4397 10 0][529.7743 30 0][530.7466 30 1][531.2002 35 0]
[531.7494 20 0][532.5145 60 1][532.6976 50 0][533.008 20 0][534.3581 60 0]
[535.1126 14 0][535.8707 30 0][536.9281 20 0][537.8836 30 0][539.0466 70 1]
[539.2572 50 0][539.9175 20 0][541.7486 24 0][542.5678 60 1][543.5893 50 1]
[544.9479 40 1][546.2615 30 1][547.0759 15 0][548.4147 24 1][549.6137 10 0]
[550.4302 19 0][550.9994 35 0][552.4584 12 0][553.9262 50 0][553.9911 70 1]
[554.8176 35 0][555.8342 50 0][556.4203 60 1][557.3354 40 0][558.7026 60 0]
[559.5064 24 0][560.4515 50 1][561.532 35 0][563.0297 7 0][563.9746 70 1]
[564.8991 7 0][565.7925 12 0][566.7128 15 0][567.7053 20 0][568.5192 10 0]
[570.0918 65 1][570.7103 95 1][572.0183 50 0][573.2975 30 1][574.2084 24 1]
[574.9388 30 1][576.0551 70 0][577.3946 15 0][578.9645 20 0][580.4141 35 0]
[581.5422 19 1][583.237 10 0][584.5919 10 0][585.4121 15 0][586.8373 15 0]
[587.8933 10 0][589.1451 8 0][589.9844 15 0][591.4387 20 1][592.5893 19 1]
[593.7162 10 0][594.4648 10 0][595.7587 8 0][597.3665 30 0][598.9044 85 1]
[599.4129 24 0][600.7072 21 0][601.5426 30 1][602.1036 17 0][603.7698 17 0]
[604.4431 24 1][605.3381 10 0][606.1536 5 0][607.7106 30 0][608.7262 30 1]
[609.9083 24 0][610.458 30 0][611.2837 40 0][612.0557 30 1][612.448 10 0]
[615.1993 14 0][616.1354 10 0][616.9822 60 0][618.2622 50 0][619.1906 12 0]
[619.3858 24 1][620.3493 12 0][622.4528 12 0][623.4856 24 0][624.0954 8 0]
[625.7424 10 0][626.1063 21 0][626.1418 21 0][627.4116 50 1][627.4117 50 1]
[627.9172 30 1][629.1192 8 0][630.3251 10 1][631.7185 8 0][632.7278 21 0]
[634.286 35 0][635.5911 50 1][636.914 14 0][637.6931 40 0][641.1899 30 0]
[641.3615 24 0][643.7762 15 0][645.0005 15 0][645.7283 60 0][646.2614 50 0]
[646.6717 5 0][649.0738 14 0][650.1992 5 0][651.2364 20 0][652.2044 5 0]
[653.1342 50 0][655.416 6 0][655.8876 5 0][656.507 3 0][657.7215 5 0]
[658.3907 24 0][658.854 24 0][659.394 24 0][660.5416 24 1][661.9946 24 1]
[661.9947 24 1][664.465 21 1][665.8678 6 1][666.2269 30 0][667.4697 6 0]
[668.3367 3 0][669.2724 8 1][669.7712 5 0][672.7459 16 0][673.5126 3 0]
[674.2884 5 0][675.6453 20 0][676.5677 6 0][677.8313 15 0][678.0413 15 0]
[679.1236 6 0][679.8747 3 0][680.9511 3 0][682.3509 5 0][682.9036 11 0]
[683.4925 14 0][686.2873 4 0][686.6367 5 0][687.4754 8 0][688.9303 20 1]
[690.8988 3 0][691.1227 24 0][691.6129 5 0][693.6652 5 0][694.3611 35 0]
[695.4657 5 0][696.5947 15 0][698.1086 3 0][698.9656 55 0][699.3038 24 1]
[700.0806 18 0][700.0806 18 0][701.5319 3 0][701.8569 10 0][702.6462 3 0]
[703.6281 7 0][704.5795 30 1][705.3619 15 1][706.0654 6 0][707.5333 24 1]
[708.4171 30 0][708.9339 24 1][710.0512 10 1][710.9861 3 0][712.4562 11 0]
[713.2613 3 0][714.856 5 0][715.4954 10 0][716.8896 30 0][717.3373 15 0]
[719.1132 40 1][720.0046 7 0][720.8006 35 0][721.269 11 0][721.7755 10 1]
[721.8054 11 0][724.2355 3 0][725.5354 5 0][727.0558 3 0][728.4904 7 0]
[729.8143 5 0][730.5405 11 1][731.5067 5 0][732.4808 7 0][733.9606 5 0]
[734.1152 8 0][736.1349 5 0][738.4175 5 0][738.5501 18 0][739.3431 3 1]
[740.2252 5 0][741.855 3 0][742.894 21 0][743.0254 10 0][744.4749 3 0]
[746.2993 2 0][748.1355 10 0][749.3427 2 0][752.5508 50 1][754.9314 7 0]
[756.774 18 0][758.569 12 0][758.5792 12 0][759.8204 4 0][760.7824 2 0]
[762.7176 5 0][763.6176 3 0][764.738 30 0][765.8324 4 0][767.6219 7 0]
[768.5305 21 0][771.0269 4 0][772.8951 4 0][773.172 10 1][777.1948 4 0]
[778.779 15 1][778.8937 15 0][779.836 5 0][455.573 100 2][458.928 50 2]
[537.613 100 2][544.718 50 2][624.295 50 2][659.939 50 2][746.159 50 2]
[493.709 2 3][495.252 4 3][542.038 3 3][671.187 2 3][674.037 3 3]
[690.116 50 3]]
4200} bind def
%
/wl@elt@Pa {[
[387.335 3000 0][393.183 3000 0][395.262 3000 1][395.785 10000 1][397.007 3000 1]
[398.182 3000 0][398.223 10000 0][401.296 3000 1][401.821 3000 1][403.016 3000 1]
[404.693 3000 1][405.62 10000 1][407.04 10000 1][411.762 3000 -1][417.618 3000 1]
[421.723 10000 1][424.808 10000 1][429.134 3000 1][440.077 3000 -1][443.613 3000 -1]
[460.143 3000 1][462.819 3000 -1][482.034 3000 -1][486.149 3000 -1][603.578 3000 0]
[616.256 3000 0][621.635 3000 -1][635.861 3000 0][637.925 3000 0][643.897 3000 0]
[679.275 3000 0][694.572 10000 0][696.009 3000 0][696.178 3000 0][699.273 3000 0]
[707.627 3000 0][710.094 3000 0][711.489 10000 0][717.155 3000 0][722.713 3000 0]
[731.879 3000 0][736.825 10000 0][747.189 3000 0][749.315 10000 0][755.826 3000 0]
[760.82 10000 0][762.679 10000 0][763.518 10000 0][766.934 10000 0][767.92 3000 0]
[774.919 10000 0]]
10000} bind def
%
/wl@elt@U {[
[380.892 380 0][380.922 380 1][381.199 1900 0][381.379 380 1][381.406 380 1]
[382.651 750 1][383.146 2000 1][383.963 1200 0][384.86 490 1][385.422 620 0]
[385.464 2400 1][385.957 4900 1][386.117 490 1][386.592 1900 1][386.68 380 1]
[387.103 1500 0][387.404 620 1][387.808 620 1][388.145 1000 1][388.236 490 1]
[388.328 380 1][389.036 2200 1][389.268 620 1][389.412 490 0][389.677 490 1]
[389.978 620 1][390.255 410 1][390.43 460 1][390.645 380 0][391.167 330 1]
[391.588 380 1][392.621 330 0][392.672 330 0][393.098 430 1][393.202 2000 1]
[393.538 490 1][394.048 330 1][394.382 1200 0][394.844 300 0][395.358 300 1]
[395.467 360 1][396.421 350 0][396.652 600 1][398.579 1200 1][399.042 460 1]
[399.253 380 1][399.824 350 1][400.406 350 1][400.521 430 0][401.772 570 1]
[401.899 300 1][404.275 1000 0][404.441 520 1][404.761 410 0][405.004 1600 1]
[405.191 540 1][405.43 300 1][405.819 430 1][406.254 880 1][406.775 520 1]
[407.112 410 1][407.448 300 1][407.669 330 1][408.06 330 1][409.013 2200 1]
[409.303 460 1][410.638 380 1][411.61 810 1][412.473 410 1][412.834 410 1]
[414.122 460 1][415.397 880 0][415.665 380 0][416.368 350 1][417.159 1400 1]
[418.927 300 1][422.237 350 0][424.167 1000 1][424.437 520 1][434.169 680 1]
[435.574 430 0][436.205 430 0][439.359 330 0][447.233 600 1][451.528 240 1]
[454.363 620 1][462.021 300 0][462.707 240 1][463.162 210 0][464.66 220 1]
[466.685 140 1][467.14 100 1][468.907 170 1][470.251 100 1][472.272 160 1]
[473.159 120 1][475.574 100 1][475.681 150 0][477.27 100 1][486.099 100 1]
[500.821 110 1][502.738 170 0][511.724 70 1][516.032 80 1][516.414 55 0]
[518.457 55 1][520.431 45 1][524.775 45 1][525.704 45 1][528.038 70 0]
[538.619 55 1][547.57 80 1][548.026 70 1][548.12 70 1][548.253 45 1]
[549.295 160 1][552.782 70 1][556.417 70 0][558.159 45 1][562.078 55 0]
[578.059 70 0][579.853 70 1][583.602 45 0][583.768 55 1][591.539 230 0]
[597.15 55 0][597.632 100 0][599.731 45 0][601.738 28 1][605.174 55 1]
[606.722 45 1][607.729 90 0][608.734 28 1][617.186 40 0][617.539 35 0]
[628.018 28 1][635.929 28 0][637.246 55 0][637.852 28 1][639.277 28 0]
[639.542 90 0][644.916 110 0][646.498 35 0][682.692 90 0][687.674 35 1]
[707.479 23 0][710.161 27 0][712.89 30 0][714.789 16 0][725.445 16 0]
[742.55 23 0][753.393 45 0][761.935 16 0]]
4900} bind def
%
/wl@elt@Np {[
[398.689 300 0][504.466 300 0][560.17 300 0][565.275 300 0][578.439 300 0]
[587.804 300 0][601.122 300 0][605.609 300 0][607.39 300 0][608.005 300 0]
[612.049 300 0][618.859 300 0][620 300 0][621.59 300 0][631.784 300 0]
[634.138 300 0][656.611 300 0][672.068 300 0][675.132 300 0][679.521 300 0]
[680.262 300 0][680.581 300 0][681.644 300 0][686.545 300 0][690.713 300 0]
[691.291 300 0][693.031 1000 0][696.363 300 0][697.209 3000 0][701.402 300 0]
[701.891 300 0][703.914 300 0][708.001 300 0][717.483 300 0][718.493 300 0]
[728.428 300 0][729.229 300 0][733.252 300 0][737.06 300 0][738.103 300 0]
[738.165 300 0][740.27 300 0][751.222 300 0][751.515 300 0][754.605 300 0]
[762.483 300 0][762.685 300 0][768.101 300 0][768.525 300 0][773.514 1000 0]
[776.161 300 0][776.575 1000 0][777.607 300 0][778.746 300 0][779.138 1000 0]]
3000} bind def
%
/wl@elt@Pu {[
[380.593 10000 0][381.14 10000 0][381.23 10000 1][382.757 10000 0][383.552 10000 0]
[383.696 10000 0][383.892 10000 0][384.21 10000 0][385.101 10000 0][385.185 10000 0]
[387.854 10000 0][389.589 10000 0][392.853 10000 0][397.543 10000 1][409.712 10000 0]
[410.196 10000 0][410.595 10000 1][411.107 10000 0][411.491 10000 0][412.812 10000 0]
[412.993 10000 1][413.301 10000 0][413.597 10000 0][414.004 10000 0][414.12 10000 1]
[415.109 10000 0][415.145 10000 0][415.546 10000 0][415.939 10000 1][416.777 10000 0]
[417.095 10000 0][417.828 10000 1][418.99 10000 1][419.006 10000 1][419.62 10000 1]
[420.648 10000 0][420.823 10000 0][422.187 10000 0][422.42 10000 0][422.977 10000 1]
[425.476 10000 1][426.188 10000 0][426.977 10000 0][427.334 10000 1][428.117 10000 0]
[428.908 10000 1][433.718 10000 1][435.271 10000 1][436.741 10000 0][437.991 10000 1]
[438.535 10000 1][439.393 10000 1][440.49 10000 0][444.165 10000 1][446.854 10000 1]
[447.279 10000 1][449.378 10000 1][450.491 10000 1][453.615 10000 1][473.54 10000 0]
[498.934 10000 0][526.986 10000 0][538.102 10000 0][549.85 10000 0][551.072 10000 0]
[553.759 10000 0][554.962 10000 0][559.054 10000 0][559.233 10000 0][571.239 10000 0]
[577.026 10000 0][583.905 10000 0][598.335 10000 0][601.278 10000 0][619.28 10000 0]
[630.466 10000 0][644.975 10000 0][648.671 10000 0][648.886 10000 0][648.889 10000 -1]
[653.527 10000 0][654.421 10000 0][660.895 10000 0][667.272 10000 0][678.466 10000 0]
[688.016 10000 0][689.138 10000 0][705.923 10000 0][706.89 10000 0][709.246 10000 0]
[711.688 10000 0][714.166 10000 0][717.714 10000 0][723.109 10000 0][725.806 10000 0]
[732.223 10000 0][732.597 10000 0][733.181 10000 0][743.118 10000 0][744.799 10000 0]
[750.78 10000 0][752.693 10000 0][754.745 10000 0][756.45 10000 0][757.187 10000 0]
[757.293 10000 0][760.977 10000 0][768.94 10000 0][775.82 10000 0][779.854 10000 0]]
10000} bind def
%
/wl@elt@Am {[
[392.625 5000 1][395.258 1000 1][402.025 100 0][403.581 100 0][403.637 500 1]
[408.929 5000 1][408.932 100 1][414.096 100 0][418.812 1000 1][426.555 1000 0]
[428.926 5000 0][430.965 200 1][432.457 2000 1][444.136 2000 1][450.945 5000 1]
[457.559 5000 1][459.331 1000 1][464.912 100 0][465.345 100 0][466.279 5000 0]
[468.165 2000 0][469.97 2000 1][470.68 1000 0][487.222 2000 1][499.079 200 0]
[500.021 100 0][502.096 1000 1][521.599 200 1][540.262 1000 0][542.47 1000 0]
[558.421 1000 1][559.813 1000 0][605.464 10000 0][640.511 1000 0][654.416 500 0]
[695.558 500 0]]
10000} bind def
%
/wl@elt@Cm {[
[381.63 10000 0][382.514 10000 0][383.332 10000 0][383.759 10000 0][384.2 10000 0]
[384.992 10000 0][385.411 10000 0][390.025 10000 0][390.406 10000 1][390.824 10000 1]
[393.667 10000 0][394.203 10000 0][394.415 10000 0][394.868 10000 0][395.336 10000 0]
[396.483 10000 0][399.51 10000 0][401.617 10000 0][403.176 10000 0][404.829 10000 0]
[404.965 10000 0][411.329 10000 0][412.971 10000 0][420.766 10000 1][421.162 10000 0]
[426.645 10000 0][429.3 10000 0][433.082 10000 0][434.569 10000 0][444.777 10000 0]
[445.916 10000 0][460.84 10000 0][584.607 10000 0][595.241 10000 0][605.89 10000 0]
[624.335 10000 0][637.671 10000 0][651.016 10000 0][655.441 10000 0][664.017 10000 0]
[666.325 10000 0][668.687 10000 0][670.685 10000 0][672.668 10000 0][679.315 10000 0]
[716.269 10000 0][757.78 10000 0][767.379 10000 0][772.047 10000 0]]
10000} bind def
%
/wl@elt@Bk {[
[380.108 10000 1][380.235 10000 0][380.247 10000 0][381.529 10000 0][382.31 10000 1]
[382.408 10000 1][382.519 10000 0][382.584 10000 1][382.741 10000 0][383.055 10000 0]
[383.157 10000 1][383.348 10000 -1][383.597 10000 1][384.219 10000 0][384.662 10000 0]
[384.763 10000 0][385.503 10000 0][385.989 10000 1][387.794 10000 1][388.011 10000 0]
[388.26 10000 0][389.455 10000 1][390.609 10000 1][391.216 10000 1][391.637 10000 1]
[392.142 10000 0][392.805 10000 1][414.713 10000 1][418.969 10000 1][419.744 10000 1]
[432.958 10000 0][435.15 10000 0][436.364 10000 0][442.301 10000 0][446.646 10000 0]
[468.57 10000 -1][476.54 10000 -1][505.673 10000 0][511.824 10000 0][513.553 10000 1]
[517.061 10000 0][519.755 10000 0][521.253 10000 0][527.195 10000 0][539.203 10000 0]
[539.424 10000 0][540.462 10000 0][544.963 10000 0][546.747 10000 0][548.458 10000 0]
[551.222 10000 1][553.793 10000 0][555.68 10000 0][555.709 10000 0][558.121 10000 0]
[565.654 10000 0][565.903 10000 0][570.224 10000 0][591.071 10000 0][704.085 10000 0]
[710.785 10000 0][717.622 10000 0][724.926 10000 -1][725.25 10000 0][725.721 10000 0]
[730.694 10000 0][739.426 10000 -1][751.126 10000 0][755.112 10000 0][757.977 10000 0]
[772.993 10000 0]]
10000} bind def
%
/wl@elt@Cf {[
[389.323 10000 1][399.357 10000 1][403.545 10000 -1][409.912 10000 0][424.238 10000 0]
[432.903 10000 0][433.522 10000 0][517.396 10000 0][517.908 10000 0][521.924 10000 0]
[527.901 10000 -1][532.009 10000 -1][533.913 10000 -1][540.888 10000 0][572.605 10000 0]
[662.283 10000 0][663.126 10000 0][667.79 10000 0][689.459 10000 0][692.71 10000 1]
[707.452 10000 0][730.79 10000 0]]
10000} bind def
%
/wl@elt@Es {[
[380.149 10000 -1][392.91 300 -1][393.077 3000 -1][395.719 100 -1][399.535 100 -1]
[407.771 300 -1][408.224 10000 -1][410.759 3000 -1][417.694 1000 -1][449.625 100 -1]
[463.166 100 -1][465.086 300 -1][478.993 1000 -1][480.217 300 -1][480.221 1000 -1]
[495.829 3000 -1][505.208 10000 -1][510.293 1000 -1][515.582 100 -1][516.174 10000 0]
[520.44 10000 0][561.551 3000 0][653.971 100 -1]]
10000} bind def
%
end
