/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SpellCheckedDocument
extends DefaultStyledDocument {
    public static final String ERROR_STYLE = "errorstyle";
    Style errorstyle;
    Style normalstyle;
    static AttributeSet normal;
    int checkoffset;
    int checkend;
    String checkingline;
    static SpellDictionary dictionary;
    boolean checkspelling = false;

    public SpellCheckedDocument(SpellDictionary spellDictionary) {
        dictionary = spellDictionary;
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        normal = this.addStyle("normal", style);
        this.errorstyle = this.addStyle(ERROR_STYLE, style);
        StyleConstants.setForeground(this.errorstyle, Color.red);
        StyleConstants.setUnderline(this.errorstyle, true);
    }

    public void checkSpelling() {
        if (dictionary != null) {
            int n = 0;
            int n2 = this.getLength();
            try {
                String string = this.getText(n, n2 - n);
                this.checkoffset = string.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = string.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = string.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += n;
                this.checkend += n;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer stringTokenizer = new StringTokenizer(this.checkingline, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3;
                    String string4 = stringTokenizer.nextToken();
                    if ((string4 = this.clean(string4)).indexOf("\n") != -1) {
                        string3 = string4.substring(0, string4.indexOf("\n"));
                        string2 = string4.substring(string4.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(string3)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(string3) + this.checkoffset, string3.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(string2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(string2) + this.checkoffset, string2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (string4.indexOf("/") != -1) {
                        string3 = string4.substring(0, string4.indexOf("/"));
                        string2 = string4.substring(string4.indexOf("/") + 1);
                        if (!dictionary.isCorrect(string3)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(string3) + this.checkoffset, string3.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(string2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(string2) + this.checkoffset, string2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(string4)) continue;
                    this.setCharacterAttributes(this.checkingline.indexOf(string4) + this.checkoffset, string4.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setCheckSpelling(boolean bl) {
        if (!this.checkspelling) {
            this.checkSpelling();
        }
        this.checkspelling = bl;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n, string, normal);
        if (!this.checkspelling) {
            return;
        }
        if (dictionary != null) {
            int n2 = n - 30;
            int n3 = n + 30;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > this.getLength()) {
                n3 = this.getLength();
            }
            try {
                String string2 = this.getText(n2, n3 - n2);
                this.checkoffset = string2.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = string2.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = string2.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += n2;
                this.checkend += n2;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer stringTokenizer = new StringTokenizer(this.checkingline, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3;
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if ((string5 = this.clean(string5)).indexOf("\n") != -1) {
                        string4 = string5.substring(0, string5.indexOf("\n"));
                        string3 = string5.substring(string5.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(string4)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(string4) + this.checkoffset, string4.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(string3)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(string3) + this.checkoffset, string3.length(), this.errorstyle, false);
                        continue;
                    }
                    if (string5.indexOf("/") != -1) {
                        string4 = string5.substring(0, string5.indexOf("/"));
                        string3 = string5.substring(string5.indexOf("/") + 1);
                        if (!dictionary.isCorrect(string4)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(string4) + this.checkoffset, string4.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(string3)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(string3) + this.checkoffset, string3.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(string5)) continue;
                    System.out.println(string5 + string5.length());
                    this.setCharacterAttributes(this.checkingline.indexOf(string5) + this.checkoffset, string5.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        super.remove(n, n2);
        if (!this.checkspelling) {
            return;
        }
        if (dictionary != null) {
            int n3 = n - 30;
            int n4 = n + 30;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 > this.getLength()) {
                n4 = this.getLength();
            }
            try {
                String string = this.getText(n3, n4 - n3);
                this.checkoffset = string.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = string.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = string.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += n3;
                this.checkend += n3;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer stringTokenizer = new StringTokenizer(this.checkingline, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if ((string2 = this.clean(string2)).indexOf("\n") != -1) {
                        String string3 = string2.substring(0, string2.indexOf("\n"));
                        String string4 = string2.substring(string2.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(string3)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(string3) + this.checkoffset, string3.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(string4)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(string4) + this.checkoffset, string4.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(string2)) continue;
                    this.setCharacterAttributes(this.checkingline.indexOf(string2) + this.checkoffset, string2.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public String clean(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = cArray.length - 1; !Character.isLetterOrDigit(cArray[n]) && n > 0; --n) {
        }
        if ((string = string.substring(0, n + 1)).endsWith(",") || string.endsWith(";") || string.endsWith(".") || string.endsWith("\n") || string.endsWith("?") || string.endsWith("!")) {
            return string.substring(0, string.length() - 1);
        }
        cArray = string.toCharArray();
        for (n = 0; !Character.isLetterOrDigit(cArray[n]) && n < cArray.length - 1; ++n) {
        }
        string = string.substring(n);
        return string;
    }

    public void checkSplittedWords(String string, String string2) {
    }
}

