/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;

public final class AuthenticationDigest {
    private final MessageDigest digest;
    private final RepositorySystemSession session;
    private final RemoteRepository repository;
    private final Proxy proxy;

    public static String forRepository(RepositorySystemSession session, RemoteRepository repository) {
        String digest = "";
        Authentication auth = repository.getAuthentication();
        if (auth != null) {
            AuthenticationDigest authDigest = new AuthenticationDigest(session, repository, null);
            auth.digest(authDigest);
            digest = authDigest.digest();
        }
        return digest;
    }

    public static String forProxy(RepositorySystemSession session, RemoteRepository repository) {
        Authentication auth;
        String digest = "";
        Proxy proxy2 = repository.getProxy();
        if (proxy2 != null && (auth = proxy2.getAuthentication()) != null) {
            AuthenticationDigest authDigest = new AuthenticationDigest(session, repository, proxy2);
            auth.digest(authDigest);
            digest = authDigest.digest();
        }
        return digest;
    }

    private AuthenticationDigest(RepositorySystemSession session, RemoteRepository repository, Proxy proxy2) {
        this.session = session;
        this.repository = repository;
        this.proxy = proxy2;
        this.digest = AuthenticationDigest.newDigest();
    }

    private static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e2) {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ne) {
                throw new IllegalStateException(ne);
            }
        }
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void update(String ... strings) {
        if (strings != null) {
            for (String string2 : strings) {
                if (string2 == null) continue;
                this.digest.update(string2.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public void update(char ... chars2) {
        if (chars2 != null) {
            for (char c : chars2) {
                this.digest.update((byte)(c >> 8));
                this.digest.update((byte)(c & 0xFF));
            }
        }
    }

    public void update(byte ... bytes2) {
        if (bytes2 != null) {
            this.digest.update(bytes2);
        }
    }

    private String digest() {
        byte[] bytes2 = this.digest.digest();
        StringBuilder buffer = new StringBuilder(bytes2.length * 2);
        for (byte aByte : bytes2) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }
}

