/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ResultSetClosingStatement
implements Statement {
    static Logger logger = Logger.getLogger(ResultSetClosingStatement.class);
    protected Statement actualStatement;
    protected Connection con;
    protected ResultSet results;
    protected String lastQuery;

    ResultSetClosingStatement(Connection con, Statement actualStmt) {
        this.con = con;
        this.actualStatement = actualStmt;
        this.results = null;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        long startTime = 0L;
        long queryTime = 0L;
        this.lastQuery = sql;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(sql.hashCode() + ", " + sql));
            startTime = System.currentTimeMillis();
        }
        this.results = this.actualStatement.executeQuery(sql);
        if (logger.isDebugEnabled()) {
            queryTime = System.currentTimeMillis() - startTime;
            logger.debug((Object)("low level query time for " + sql.hashCode() + " (ms): " + queryTime));
        }
        return this.results;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        logger.debug((Object)sql);
        this.lastQuery = sql;
        int rowCount = this.actualStatement.executeUpdate(sql);
        logger.debug((Object)("Affected " + rowCount + " rows"));
        return rowCount;
    }

    @Override
    public void close() throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        this.actualStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.actualStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.actualStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.actualStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.actualStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.actualStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.actualStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.actualStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.actualStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.actualStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.actualStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.actualStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not allowed by ResultSetClosingStatement");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.results;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.actualStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException("Not allowed by ResultSetClosingStatement");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.actualStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.actualStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.actualStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.actualStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.actualStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.actualStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.actualStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.actualStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.actualStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void finalize() {
        try {
            if (this.results != null) {
                this.results.close();
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("Couldn't close result set in finalizer: " + e));
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet...");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }
}

